/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewDebug;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IconMenuItemView
extends TextView
implements MenuView.ItemView,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int NO_ALPHA = 255;
    private IconMenuView mIconMenuView;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private MenuItemImpl mItemData;
    private Drawable mIcon;
    private int mTextAppearance;
    private Context mTextAppearanceContext;
    private float mDisabledAlpha;
    private Rect mPositionIconAvailable;
    private Rect mPositionIconOutput;
    private boolean mShortcutCaptionMode;
    private String mShortcutCaption;
    private static String sPrependShortcutLabel;

    private void $$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mPositionIconAvailable = new Rect();
        this.mPositionIconOutput = new Rect();
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = this.getResources().getString(17040725);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuView, defStyleAttr, defStyleRes);
        this.mDisabledAlpha = a.getFloat(6, 0.8f);
        this.mTextAppearance = a.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        a.recycle();
    }

    private void $$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(Context context, AttributeSet attrs) {
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$initialize(CharSequence title, Drawable icon) {
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mTextAppearance != -1) {
            this.setTextAppearance(this.mTextAppearanceContext, this.mTextAppearance);
        }
        this.setTitle(title);
        this.setIcon(icon);
        if (this.mItemData != null) {
            CharSequence contentDescription = this.mItemData.getContentDescription();
            if (TextUtils.isEmpty(contentDescription)) {
                this.setContentDescription(title);
            } else {
                this.setContentDescription(contentDescription);
            }
            this.setTooltipText(this.mItemData.getTooltipText());
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.initialize(itemData.getTitleForItemView(this), itemData.getIcon());
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setEnabled(itemData.isEnabled());
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setItemData(MenuItemImpl data) {
        this.mItemData = data;
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuItemView$performClick() {
        if (super.performClick()) {
            return true;
        }
        if (this.mItemInvoker != null && this.mItemInvoker.invokeItem(this.mItemData)) {
            this.playSoundEffect(0);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setTitle(CharSequence title) {
        if (this.mShortcutCaptionMode) {
            this.setCaptionMode(true);
        } else if (title != null) {
            this.setText(title);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setCaptionMode(boolean shortcut) {
        if (this.mItemData == null) {
            return;
        }
        this.mShortcutCaptionMode = shortcut && this.mItemData.shouldShowShortcut();
        CharSequence text = this.mItemData.getTitleForItemView(this);
        if (this.mShortcutCaptionMode) {
            if (this.mShortcutCaption == null) {
                this.mShortcutCaption = this.mItemData.getShortcutLabel();
            }
            text = this.mShortcutCaption;
        }
        this.setText(text);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setIcon(Drawable icon) {
        this.mIcon = icon;
        if (icon != null) {
            icon.setBounds(0, 0, icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
            this.setCompoundDrawables(null, icon, null, null);
            this.setGravity(81);
            this.requestLayout();
        } else {
            this.setCompoundDrawables(null, null, null, null);
            this.setGravity(17);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    @ViewDebug.CapturedViewProperty(retrieveReturn=true)
    private final MenuItemImpl $$robo$$com_android_internal_view_menu_IconMenuItemView$getItemData() {
        return this.mItemData;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setVisibility(int v) {
        super.setVisibility(v);
        if (this.mIconMenuView != null) {
            this.mIconMenuView.markStaleChildren();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setIconMenuView(IconMenuView iconMenuView) {
        this.mIconMenuView = iconMenuView;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mItemData != null && this.mIcon != null) {
            boolean isInAlphaState = !this.mItemData.isEnabled() && (this.isPressed() || !this.isFocused());
            this.mIcon.setAlpha(isInAlphaState ? (int)(this.mDisabledAlpha * 255.0f) : 255);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.positionIcon();
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$onTextChanged(CharSequence text, int start, int before, int after) {
        super.onTextChanged(text, start, before, after);
        this.setLayoutParams(this.getTextAppropriateLayoutParams());
    }

    private final IconMenuView.LayoutParams $$robo$$com_android_internal_view_menu_IconMenuItemView$getTextAppropriateLayoutParams() {
        IconMenuView.LayoutParams lp = (IconMenuView.LayoutParams)this.getLayoutParams();
        if (lp == null) {
            lp = new IconMenuView.LayoutParams(-1, -1);
        }
        lp.desiredWidth = (int)Layout.getDesiredWidth(this.getText(), 0, this.getText().length(), this.getPaint(), this.getTextDirectionHeuristic());
        return lp;
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$positionIcon() {
        if (this.mIcon == null) {
            return;
        }
        Rect tmpRect = this.mPositionIconOutput;
        this.getLineBounds(0, tmpRect);
        this.mPositionIconAvailable.set(0, 0, this.getWidth(), tmpRect.top);
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(8388627, this.mIcon.getIntrinsicWidth(), this.mIcon.getIntrinsicHeight(), this.mPositionIconAvailable, this.mPositionIconOutput, layoutDirection);
        this.mIcon.setBounds(this.mPositionIconOutput);
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setCheckable(boolean checkable) {
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setChecked(boolean checked) {
    }

    private final void $$robo$$com_android_internal_view_menu_IconMenuItemView$setShortcut(boolean showShortcut, char shortcutKey) {
        if (this.mShortcutCaptionMode) {
            this.mShortcutCaption = null;
            this.setCaptionMode(true);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuItemView$prefersCondensedTitle() {
        return true;
    }

    private final boolean $$robo$$com_android_internal_view_menu_IconMenuItemView$showsIcon() {
        return true;
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(context, attributeSet, n, n2);
    }

    public IconMenuItemView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(context, attributeSet, n);
    }

    public IconMenuItemView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(context, attributeSet);
    }

    public IconMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_IconMenuItemView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    void initialize(CharSequence charSequence, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_view_menu_IconMenuItemView$initialize(java.lang.CharSequence android.graphics.drawable.Drawable ), this, charSequence, drawable2);
    }

    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_view_menu_IconMenuItemView$initialize(com.android.internal.view.menu.MenuItemImpl int ), this, menuItemImpl, n);
    }

    public void setItemData(MenuItemImpl menuItemImpl) {
        InvokeDynamicSupport.bootstrap("setItemData", $$robo$$com_android_internal_view_menu_IconMenuItemView$setItemData(com.android.internal.view.menu.MenuItemImpl ), this, menuItemImpl);
    }

    @Override
    public boolean performClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$com_android_internal_view_menu_IconMenuItemView$performClick(), this);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_IconMenuItemView$setTitle(java.lang.CharSequence ), this, charSequence);
    }

    void setCaptionMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCaptionMode", $$robo$$com_android_internal_view_menu_IconMenuItemView$setCaptionMode(boolean ), this, bl);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_IconMenuItemView$setIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        InvokeDynamicSupport.bootstrap("setItemInvoker", $$robo$$com_android_internal_view_menu_IconMenuItemView$setItemInvoker(com.android.internal.view.menu.MenuBuilder$ItemInvoker ), this, itemInvoker);
    }

    @Override
    @ViewDebug.CapturedViewProperty(retrieveReturn=true)
    public MenuItemImpl getItemData() {
        return InvokeDynamicSupport.bootstrap("getItemData", $$robo$$com_android_internal_view_menu_IconMenuItemView$getItemData(), this);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$com_android_internal_view_menu_IconMenuItemView$setVisibility(int ), this, n);
    }

    void setIconMenuView(IconMenuView iconMenuView) {
        InvokeDynamicSupport.bootstrap("setIconMenuView", $$robo$$com_android_internal_view_menu_IconMenuItemView$setIconMenuView(com.android.internal.view.menu.IconMenuView ), this, iconMenuView);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$com_android_internal_view_menu_IconMenuItemView$drawableStateChanged(), this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_view_menu_IconMenuItemView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$com_android_internal_view_menu_IconMenuItemView$onTextChanged(java.lang.CharSequence int int int ), this, charSequence, n, n2, n3);
    }

    IconMenuView.LayoutParams getTextAppropriateLayoutParams() {
        return InvokeDynamicSupport.bootstrap("getTextAppropriateLayoutParams", $$robo$$com_android_internal_view_menu_IconMenuItemView$getTextAppropriateLayoutParams(), this);
    }

    private void positionIcon() {
        InvokeDynamicSupport.bootstrap("positionIcon", $$robo$$com_android_internal_view_menu_IconMenuItemView$positionIcon(), this);
    }

    @Override
    public void setCheckable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$com_android_internal_view_menu_IconMenuItemView$setCheckable(boolean ), this, bl);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$com_android_internal_view_menu_IconMenuItemView$setChecked(boolean ), this, bl);
    }

    @Override
    public void setShortcut(boolean bl, char c) {
        InvokeDynamicSupport.bootstrap("setShortcut", $$robo$$com_android_internal_view_menu_IconMenuItemView$setShortcut(boolean char ), this, bl, c);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return (boolean)InvokeDynamicSupport.bootstrap("prefersCondensedTitle", $$robo$$com_android_internal_view_menu_IconMenuItemView$prefersCondensedTitle(), this);
    }

    @Override
    public boolean showsIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsIcon", $$robo$$com_android_internal_view_menu_IconMenuItemView$showsIcon(), this);
    }

    public /* synthetic */ IconMenuItemView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IconMenuItemView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

