/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util.function.pooled;

import android.os.Message;
import android.text.TextUtils;
import android.util.Pools;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.BitUtils;
import com.android.internal.util.function.HexConsumer;
import com.android.internal.util.function.HexFunction;
import com.android.internal.util.function.HexPredicate;
import com.android.internal.util.function.QuadConsumer;
import com.android.internal.util.function.QuadFunction;
import com.android.internal.util.function.QuadPredicate;
import com.android.internal.util.function.QuintConsumer;
import com.android.internal.util.function.QuintFunction;
import com.android.internal.util.function.QuintPredicate;
import com.android.internal.util.function.TriConsumer;
import com.android.internal.util.function.TriFunction;
import com.android.internal.util.function.TriPredicate;
import com.android.internal.util.function.pooled.ArgumentPlaceholder;
import com.android.internal.util.function.pooled.OmniFunction;
import com.android.internal.util.function.pooled.PooledLambda;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PooledLambdaImpl<R>
extends OmniFunction<Object, Object, Object, Object, Object, Object, R> {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG = "PooledLambdaImpl";
    private static int MAX_ARGS = 5;
    private static int MAX_POOL_SIZE = 50;
    static Pool sPool;
    static Pool sMessageCallbacksPool;
    Object mFunc;
    long mConstValue;
    Object[] mArgs;
    private static int FLAG_RECYCLED = 32;
    private static int FLAG_RECYCLE_ON_USE = 64;
    private static int FLAG_ACQUIRED_FROM_MESSAGE_CALLBACKS_POOL = 128;
    static int MASK_EXPOSED_AS = 16128;
    static int MASK_FUNC_TYPE = 1032192;
    int mFlags;

    private void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$__constructor__() {
        this.mArgs = null;
        this.mFlags = 0;
    }

    private final void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$recycle() {
        if (!this.isRecycled()) {
            this.doRecycle();
        }
    }

    private final void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$doRecycle() {
        Pool pool = (this.mFlags & 0x80) != 0 ? sMessageCallbacksPool : sPool;
        this.mFunc = null;
        if (this.mArgs != null) {
            Arrays.fill(this.mArgs, null);
        }
        this.mFlags = 32;
        this.mConstValue = 0L;
        pool.release(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$invoke(Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        this.checkNotRecycled();
        boolean notUsed = this.fillInArg(a1) && this.fillInArg(a2) && this.fillInArg(a3) && this.fillInArg(a4) && this.fillInArg(a5) && this.fillInArg(a6);
        int argCount = LambdaType.decodeArgCount(this.getFlags(1032192));
        if (argCount != 7) {
            for (int i = 0; i < argCount; ++i) {
                if (this.mArgs[i] != ArgumentPlaceholder.INSTANCE) continue;
                throw new IllegalStateException("Missing argument #" + i + " among " + Arrays.toString(this.mArgs));
            }
        }
        try {
            R r = this.doInvoke();
            return r;
        }
        finally {
            if (this.isRecycleOnUse()) {
                this.doRecycle();
            }
            if (!this.isRecycled()) {
                int argsSize = ArrayUtils.size(this.mArgs);
                for (int i = 0; i < argsSize; ++i) {
                    this.popArg(i);
                }
            }
        }
    }

    private final boolean $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$fillInArg(Object invocationArg) {
        int argsSize = ArrayUtils.size(this.mArgs);
        for (int i = 0; i < argsSize; ++i) {
            if (this.mArgs[i] != ArgumentPlaceholder.INSTANCE) continue;
            this.mArgs[i] = invocationArg;
            this.mFlags = (int)((long)this.mFlags | BitUtils.bitAt(i));
            return true;
        }
        if (invocationArg != null && invocationArg != ArgumentPlaceholder.INSTANCE) {
            throw new IllegalStateException("No more arguments expected for provided arg " + invocationArg + " among " + Arrays.toString(this.mArgs));
        }
        return false;
    }

    private final void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$checkNotRecycled() {
        if (this.isRecycled()) {
            throw new IllegalStateException("Instance is recycled: " + this);
        }
    }

    private final R $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$doInvoke() {
        int funcType = this.getFlags(1032192);
        int argCount = LambdaType.decodeArgCount(funcType);
        int returnType = LambdaType.decodeReturnType(funcType);
        switch (argCount) {
            case 7: {
                switch (returnType) {
                    case 4: {
                        return (R)Integer.valueOf(this.getAsInt());
                    }
                    case 5: {
                        return (R)Long.valueOf(this.getAsLong());
                    }
                    case 6: {
                        return (R)Double.valueOf(this.getAsDouble());
                    }
                }
                return (R)this.mFunc;
            }
            case 0: {
                switch (returnType) {
                    case 1: {
                        ((Runnable)this.mFunc).run();
                        return null;
                    }
                    case 2: 
                    case 3: {
                        return (R)((Supplier)this.mFunc).get();
                    }
                }
                break;
            }
            case 1: {
                switch (returnType) {
                    case 1: {
                        ((Consumer)this.mFunc).accept(this.popArg(0));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((Predicate)this.mFunc).test(this.popArg(0)));
                    }
                    case 3: {
                        return ((Function)this.mFunc).apply(this.popArg(0));
                    }
                }
                break;
            }
            case 2: {
                switch (returnType) {
                    case 1: {
                        ((BiConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((BiPredicate)this.mFunc).test(this.popArg(0), this.popArg(1)));
                    }
                    case 3: {
                        return ((BiFunction)this.mFunc).apply(this.popArg(0), this.popArg(1));
                    }
                }
                break;
            }
            case 3: {
                switch (returnType) {
                    case 1: {
                        ((TriConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((TriPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2)));
                    }
                    case 3: {
                        return ((TriFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2));
                    }
                }
                break;
            }
            case 4: {
                switch (returnType) {
                    case 1: {
                        ((QuadConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((QuadPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3)));
                    }
                    case 3: {
                        return ((QuadFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3));
                    }
                }
                break;
            }
            case 5: {
                switch (returnType) {
                    case 1: {
                        ((QuintConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((QuintPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4)));
                    }
                    case 3: {
                        return ((QuintFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4));
                    }
                }
                break;
            }
            case 6: {
                switch (returnType) {
                    case 1: {
                        ((HexConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4), this.popArg(5));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((HexPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4), this.popArg(5)));
                    }
                    case 3: {
                        return ((HexFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4), this.popArg(5));
                    }
                }
            }
        }
        throw new IllegalStateException("Unknown function type: " + LambdaType.toString(funcType));
    }

    private final boolean $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isConstSupplier() {
        return LambdaType.decodeArgCount(this.getFlags(1032192)) == 7;
    }

    private final Object $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$popArg(int index) {
        Object result = this.mArgs[index];
        if (this.isInvocationArgAtIndex(index)) {
            this.mArgs[index] = ArgumentPlaceholder.INSTANCE;
            this.mFlags = (int)((long)this.mFlags & (BitUtils.bitAt(index) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return result;
    }

    private final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$toString() {
        if (this.isRecycled()) {
            return "<recycled PooledLambda@" + PooledLambdaImpl.hashCodeHex(this) + ">";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isConstSupplier()) {
            sb.append(this.getFuncTypeAsString()).append("(").append(this.doInvoke()).append(")");
        } else {
            if (this.mFunc instanceof PooledLambdaImpl) {
                sb.append(this.mFunc);
            } else {
                sb.append(this.getFuncTypeAsString()).append("@").append(PooledLambdaImpl.hashCodeHex(this.mFunc));
            }
            sb.append("(");
            sb.append(this.commaSeparateFirstN(this.mArgs, LambdaType.decodeArgCount(this.getFlags(1032192))));
            sb.append(")");
        }
        return sb.toString();
    }

    private final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$commaSeparateFirstN(Object[] arr, int n) {
        if (arr == null) {
            return "";
        }
        return TextUtils.join((CharSequence)",", Arrays.copyOf(arr, n));
    }

    private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$hashCodeHex(Object o) {
        return Integer.toHexString(o.hashCode());
    }

    private final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getFuncTypeAsString() {
        if (this.isRecycled()) {
            throw new IllegalStateException();
        }
        if (this.isConstSupplier()) {
            return "supplier";
        }
        String name = LambdaType.toString(this.getFlags(16128));
        if (name.endsWith("Consumer")) {
            return "consumer";
        }
        if (name.endsWith("Function")) {
            return "function";
        }
        if (name.endsWith("Predicate")) {
            return "predicate";
        }
        if (name.endsWith("Supplier")) {
            return "supplier";
        }
        if (name.endsWith("Runnable")) {
            return "runnable";
        }
        throw new IllegalStateException("Don't know the string representation of " + name);
    }

    private static final <E extends PooledLambda> E $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$acquire(Pool pool, Object func, int fNumArgs, int numPlaceholders, int fReturnType, Object a, Object b, Object c, Object d, Object e, Object f) {
        PooledLambdaImpl r = PooledLambdaImpl.acquire(pool);
        r.mFunc = func;
        r.setFlags(1032192, LambdaType.encode(fNumArgs, fReturnType));
        r.setFlags(16128, LambdaType.encode(numPlaceholders, fReturnType));
        if (ArrayUtils.size(r.mArgs) < fNumArgs) {
            r.mArgs = new Object[fNumArgs];
        }
        PooledLambdaImpl.setIfInBounds(r.mArgs, 0, a);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 1, b);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 2, c);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 3, d);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 4, e);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 5, f);
        return (E)r;
    }

    private static final PooledLambdaImpl $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$acquireConstSupplier(int type) {
        PooledLambdaImpl r = PooledLambdaImpl.acquire(sPool);
        int lambdaType = LambdaType.encode(7, type);
        r.setFlags(1032192, lambdaType);
        r.setFlags(16128, lambdaType);
        return r;
    }

    private static final PooledLambdaImpl $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$acquire(Pool pool) {
        PooledLambdaImpl r = (PooledLambdaImpl)pool.acquire();
        if (r == null) {
            r = new PooledLambdaImpl();
        }
        r.mFlags &= 0xFFFFFFDF;
        r.setFlags(128, pool == sMessageCallbacksPool ? 1 : 0);
        return r;
    }

    private static final void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$setIfInBounds(Object[] array2, int i, Object a) {
        if (i < ArrayUtils.size(array2)) {
            array2[i] = a;
        }
    }

    private final OmniFunction<Object, Object, Object, Object, Object, Object, R> $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$negate() {
        throw new UnsupportedOperationException();
    }

    private final <V> OmniFunction<Object, Object, Object, Object, Object, Object, V> $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$andThen(Function<? super R, ? extends V> after) {
        throw new UnsupportedOperationException();
    }

    private final double $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getAsDouble() {
        return Double.longBitsToDouble(this.mConstValue);
    }

    private final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getAsInt() {
        return (int)this.mConstValue;
    }

    private final long $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getAsLong() {
        return this.mConstValue;
    }

    private final OmniFunction<Object, Object, Object, Object, Object, Object, R> $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$recycleOnUse() {
        this.mFlags |= 0x40;
        return this;
    }

    private final boolean $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isRecycled() {
        return (this.mFlags & 0x20) != 0;
    }

    private final boolean $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isRecycleOnUse() {
        return (this.mFlags & 0x40) != 0;
    }

    private final boolean $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isInvocationArgAtIndex(int argIndex) {
        return (this.mFlags & 1 << argIndex) != 0;
    }

    private final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getFlags(int mask) {
        return PooledLambdaImpl.unmask(mask, this.mFlags);
    }

    private final void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$setFlags(int mask, int value) {
        this.mFlags &= ~mask;
        this.mFlags |= PooledLambdaImpl.mask(mask, value);
    }

    private static final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$mask(int mask, int value) {
        return value << Integer.numberOfTrailingZeros(mask) & mask;
    }

    private static final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$unmask(int mask, int bits) {
        return (bits & mask) / (1 << Integer.numberOfTrailingZeros(mask));
    }

    static void __staticInitializer__() {
        sPool = new Pool(new Object());
        sMessageCallbacksPool = new Pool(Message.sPoolSync);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$__constructor__();
    }

    public PooledLambdaImpl() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$__constructor__(), this);
    }

    @Override
    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$recycle(), this);
    }

    private void doRecycle() {
        InvokeDynamicSupport.bootstrap("doRecycle", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$doRecycle(), this);
    }

    @Override
    R invoke(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return (R)InvokeDynamicSupport.bootstrap("invoke", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$invoke(java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), this, object, object2, object3, object4, object5, object6);
    }

    private boolean fillInArg(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("fillInArg", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$fillInArg(java.lang.Object ), this, object);
    }

    private void checkNotRecycled() {
        InvokeDynamicSupport.bootstrap("checkNotRecycled", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$checkNotRecycled(), this);
    }

    private R doInvoke() {
        return (R)InvokeDynamicSupport.bootstrap("doInvoke", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$doInvoke(), this);
    }

    private boolean isConstSupplier() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConstSupplier", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isConstSupplier(), this);
    }

    private Object popArg(int n) {
        return InvokeDynamicSupport.bootstrap("popArg", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$popArg(int ), this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$toString(), this);
    }

    private String commaSeparateFirstN(Object[] objectArray, int n) {
        return InvokeDynamicSupport.bootstrap("commaSeparateFirstN", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$commaSeparateFirstN(java.lang.Object[] int ), this, objectArray, n);
    }

    private static String hashCodeHex(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("hashCodeHex", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$hashCodeHex(java.lang.Object ), (Object)object);
    }

    private String getFuncTypeAsString() {
        return InvokeDynamicSupport.bootstrap("getFuncTypeAsString", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getFuncTypeAsString(), this);
    }

    static <E extends PooledLambda> E acquire(Pool pool, Object object, int n, int n2, int n3, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return (E)InvokeDynamicSupport.bootstrapStatic("acquire", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$acquire(com.android.internal.util.function.pooled.PooledLambdaImpl$Pool java.lang.Object int int int java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object java.lang.Object ), (Pool)pool, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2, (Object)object3, (Object)object4, (Object)object5, (Object)object6, (Object)object7);
    }

    static PooledLambdaImpl acquireConstSupplier(int n) {
        return InvokeDynamicSupport.bootstrapStatic("acquireConstSupplier", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$acquireConstSupplier(int ), (int)n);
    }

    static PooledLambdaImpl acquire(Pool pool) {
        return InvokeDynamicSupport.bootstrapStatic("acquire", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$acquire(com.android.internal.util.function.pooled.PooledLambdaImpl$Pool ), (Pool)pool);
    }

    private static void setIfInBounds(Object[] objectArray, int n, Object object) {
        InvokeDynamicSupport.bootstrapStatic("setIfInBounds", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$setIfInBounds(java.lang.Object[] int java.lang.Object ), (Object[])objectArray, (int)n, (Object)object);
    }

    @Override
    public OmniFunction<Object, Object, Object, Object, Object, Object, R> negate() {
        return InvokeDynamicSupport.bootstrap("negate", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$negate(), this);
    }

    @Override
    public <V> OmniFunction<Object, Object, Object, Object, Object, Object, V> andThen(Function<? super R, ? extends V> function) {
        return InvokeDynamicSupport.bootstrap("andThen", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$andThen(java.util.function.Function<? super R, ? extends V> ), this, function);
    }

    @Override
    public double getAsDouble() {
        return (double)InvokeDynamicSupport.bootstrap("getAsDouble", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getAsDouble(), this);
    }

    @Override
    public int getAsInt() {
        return (int)InvokeDynamicSupport.bootstrap("getAsInt", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getAsInt(), this);
    }

    @Override
    public long getAsLong() {
        return (long)InvokeDynamicSupport.bootstrap("getAsLong", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getAsLong(), this);
    }

    @Override
    public OmniFunction<Object, Object, Object, Object, Object, Object, R> recycleOnUse() {
        return InvokeDynamicSupport.bootstrap("recycleOnUse", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$recycleOnUse(), this);
    }

    private boolean isRecycled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecycled", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isRecycled(), this);
    }

    private boolean isRecycleOnUse() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecycleOnUse", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isRecycleOnUse(), this);
    }

    private boolean isInvocationArgAtIndex(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInvocationArgAtIndex", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$isInvocationArgAtIndex(int ), this, n);
    }

    int getFlags(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$getFlags(int ), this, n);
    }

    void setFlags(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$setFlags(int int ), this, n, n2);
    }

    private static int mask(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("mask", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$mask(int int ), (int)n, (int)n2);
    }

    private static int unmask(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("unmask", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl$unmask(int int ), (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(PooledLambdaImpl.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PooledLambdaImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LambdaType
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int MASK_ARG_COUNT = 7;
        public static int MASK_RETURN_TYPE = 56;
        public static int MASK = 63;
        public static int MASK_BIT_COUNT = 6;

        private void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$__constructor__() {
        }

        private static final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$encode(int argCount, int returnType) {
            return PooledLambdaImpl.mask(7, argCount) | PooledLambdaImpl.mask(56, returnType);
        }

        private static final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$decodeArgCount(int type) {
            return type & 7;
        }

        private static final int $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$decodeReturnType(int type) {
            return PooledLambdaImpl.unmask(56, type);
        }

        private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$toString(int type) {
            int argCount = LambdaType.decodeArgCount(type);
            int returnType = LambdaType.decodeReturnType(type);
            if (argCount == 0) {
                if (returnType == 1) {
                    return "Runnable";
                }
                if (returnType == 3 || returnType == 2) {
                    return "Supplier";
                }
            }
            return LambdaType.argCountPrefix(argCount) + ReturnType.lambdaSuffix(returnType);
        }

        private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$argCountPrefix(int argCount) {
            switch (argCount) {
                case 7: {
                    return "";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "Bi";
                }
                case 3: {
                    return "Tri";
                }
                case 4: {
                    return "Quad";
                }
                case 5: {
                    return "Quint";
                }
                case 6: {
                    return "Hex";
                }
            }
            throw new IllegalArgumentException("" + argCount);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$__constructor__();
        }

        public LambdaType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$__constructor__(), this);
        }

        static int encode(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$encode(int int ), (int)n, (int)n2);
        }

        static int decodeArgCount(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("decodeArgCount", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$decodeArgCount(int ), (int)n);
        }

        static int decodeReturnType(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("decodeReturnType", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$decodeReturnType(int ), (int)n);
        }

        static String toString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$toString(int ), (int)n);
        }

        private static String argCountPrefix(int n) {
            return InvokeDynamicSupport.bootstrapStatic("argCountPrefix", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType$argCountPrefix(int ), (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LambdaType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class ReturnType
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public static int VOID = 1;
            public static int BOOLEAN = 2;
            public static int OBJECT = 3;
            public static int INT = 4;
            public static int LONG = 5;
            public static int DOUBLE = 6;

            private void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$__constructor__() {
            }

            private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$toString(int returnType) {
                switch (returnType) {
                    case 1: {
                        return "VOID";
                    }
                    case 2: {
                        return "BOOLEAN";
                    }
                    case 3: {
                        return "OBJECT";
                    }
                    case 4: {
                        return "INT";
                    }
                    case 5: {
                        return "LONG";
                    }
                    case 6: {
                        return "DOUBLE";
                    }
                }
                return "" + returnType;
            }

            private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$lambdaSuffix(int type) {
                return ReturnType.prefix(type) + ReturnType.suffix(type);
            }

            private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$prefix(int type) {
                switch (type) {
                    case 4: {
                        return "Int";
                    }
                    case 5: {
                        return "Long";
                    }
                    case 6: {
                        return "Double";
                    }
                }
                return "";
            }

            private static final String $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$suffix(int type) {
                switch (type) {
                    case 1: {
                        return "Consumer";
                    }
                    case 2: {
                        return "Predicate";
                    }
                    case 3: {
                        return "Function";
                    }
                }
                return "Supplier";
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$__constructor__();
            }

            public ReturnType() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$__constructor__(), this);
            }

            static String toString(int n) {
                return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$toString(int ), (int)n);
            }

            static String lambdaSuffix(int n) {
                return InvokeDynamicSupport.bootstrapStatic("lambdaSuffix", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$lambdaSuffix(int ), (int)n);
            }

            private static String prefix(int n) {
                return InvokeDynamicSupport.bootstrapStatic("prefix", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$prefix(int ), (int)n);
            }

            private static String suffix(int n) {
                return InvokeDynamicSupport.bootstrapStatic("suffix", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_LambdaType_ReturnType$suffix(int ), (int)n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReturnType)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class Pool
    extends Pools.SynchronizedPool<PooledLambdaImpl> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_Pool$__constructor__(Object lock) {
        }

        private void __constructor__(Object object) {
            this.$$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_Pool$__constructor__(object);
        }

        public Pool(Object object) {
            super(50, object);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_function_pooled_PooledLambdaImpl_Pool$__constructor__(java.lang.Object ), this, object);
        }

        public /* synthetic */ Pool() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Pool)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

