/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class RingBuffer<T> {
    public /* synthetic */ Object __robo_data__;
    private T[] mBuffer;
    private long mCursor;

    private void $$robo$$com_android_internal_util_RingBuffer$__constructor__(Class<T> c, int capacity) {
        this.mCursor = 0L;
        Preconditions.checkArgumentPositive(capacity, "A RingBuffer cannot have 0 capacity");
        this.mBuffer = (Object[])Array.newInstance(c, capacity);
    }

    private final int $$robo$$com_android_internal_util_RingBuffer$size() {
        return (int)Math.min((long)this.mBuffer.length, this.mCursor);
    }

    private final boolean $$robo$$com_android_internal_util_RingBuffer$isEmpty() {
        return this.size() == 0;
    }

    private final void $$robo$$com_android_internal_util_RingBuffer$clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.mBuffer[i] = null;
        }
        this.mCursor = 0L;
    }

    private final void $$robo$$com_android_internal_util_RingBuffer$append(T t) {
        this.mBuffer[this.indexOf((long)this.mCursor++)] = t;
    }

    private final T $$robo$$com_android_internal_util_RingBuffer$getNextSlot() {
        int nextSlotIdx;
        if (this.mBuffer[nextSlotIdx = this.indexOf(this.mCursor++)] == null) {
            this.mBuffer[nextSlotIdx] = this.createNewItem();
        }
        return this.mBuffer[nextSlotIdx];
    }

    private final T $$robo$$com_android_internal_util_RingBuffer$createNewItem() {
        try {
            return (T)this.mBuffer.getClass().getComponentType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private final T[] $$robo$$com_android_internal_util_RingBuffer$toArray() {
        T[] out = Arrays.copyOf(this.mBuffer, this.size(), this.mBuffer.getClass());
        long inCursor = this.mCursor - 1L;
        int outIdx = out.length - 1;
        while (outIdx >= 0) {
            out[outIdx--] = this.mBuffer[this.indexOf(inCursor--)];
        }
        return out;
    }

    private final int $$robo$$com_android_internal_util_RingBuffer$indexOf(long cursor) {
        return (int)Math.abs(cursor % (long)this.mBuffer.length);
    }

    private void __constructor__(Class<T> clazz, int n) {
        this.$$robo$$com_android_internal_util_RingBuffer$__constructor__(clazz, n);
    }

    public RingBuffer(Class<T> clazz, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_RingBuffer$__constructor__(java.lang.Class<T> int ), this, clazz, n);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$com_android_internal_util_RingBuffer$size(), this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$com_android_internal_util_RingBuffer$isEmpty(), this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_util_RingBuffer$clear(), this);
    }

    public void append(T t) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_util_RingBuffer$append(T ), this, t);
    }

    public T getNextSlot() {
        return (T)InvokeDynamicSupport.bootstrap("getNextSlot", $$robo$$com_android_internal_util_RingBuffer$getNextSlot(), this);
    }

    protected T createNewItem() {
        return (T)InvokeDynamicSupport.bootstrap("createNewItem", $$robo$$com_android_internal_util_RingBuffer$createNewItem(), this);
    }

    public T[] toArray() {
        return InvokeDynamicSupport.bootstrap("toArray", $$robo$$com_android_internal_util_RingBuffer$toArray(), this);
    }

    private int indexOf(long l) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$com_android_internal_util_RingBuffer$indexOf(long ), this, l);
    }

    public /* synthetic */ RingBuffer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RingBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

