/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.SystemClock;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ProviderAccessStats
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Object mLock;
    private long mStartUptime;
    private SparseBooleanArray mAllCallingUids;
    private SparseLongArray mQueryStats;
    private SparseLongArray mBatchStats;
    private SparseLongArray mInsertStats;
    private SparseLongArray mUpdateStats;
    private SparseLongArray mDeleteStats;
    private SparseLongArray mInsertInBatchStats;
    private SparseLongArray mUpdateInBatchStats;
    private SparseLongArray mDeleteInBatchStats;
    private SparseLongArray mOperationDurationMillis;
    private ThreadLocal<PerThreadData> mThreadLocal;

    private void $$robo$$com_android_internal_util_ProviderAccessStats$__constructor__() {
        this.mLock = new Object();
        this.mStartUptime = SystemClock.uptimeMillis();
        this.mAllCallingUids = new SparseBooleanArray();
        this.mQueryStats = new SparseLongArray(16);
        this.mBatchStats = new SparseLongArray(0);
        this.mInsertStats = new SparseLongArray(0);
        this.mUpdateStats = new SparseLongArray(0);
        this.mDeleteStats = new SparseLongArray(0);
        this.mInsertInBatchStats = new SparseLongArray(0);
        this.mUpdateInBatchStats = new SparseLongArray(0);
        this.mDeleteInBatchStats = new SparseLongArray(0);
        this.mOperationDurationMillis = new SparseLongArray(16);
        this.mThreadLocal = ThreadLocal.withInitial(() -> new PerThreadData(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementStats(int callingUid, SparseLongArray stats) {
        Object object = this.mLock;
        synchronized (object) {
            stats.put(callingUid, stats.get(callingUid) + 1L);
            this.mAllCallingUids.put(callingUid, true);
        }
        PerThreadData data = this.mThreadLocal.get();
        ++data.nestCount;
        if (data.nestCount == 1) {
            data.startUptimeMillis = SystemClock.uptimeMillis();
        }
    }

    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementStats(int callingUid, boolean inBatch, SparseLongArray statsNonBatch, SparseLongArray statsInBatch) {
        this.incrementStats(callingUid, inBatch ? statsInBatch : statsNonBatch);
    }

    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementInsertStats(int callingUid, boolean inBatch) {
        this.incrementStats(callingUid, inBatch, this.mInsertStats, this.mInsertInBatchStats);
    }

    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementUpdateStats(int callingUid, boolean inBatch) {
        this.incrementStats(callingUid, inBatch, this.mUpdateStats, this.mUpdateInBatchStats);
    }

    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementDeleteStats(int callingUid, boolean inBatch) {
        this.incrementStats(callingUid, inBatch, this.mDeleteStats, this.mDeleteInBatchStats);
    }

    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementQueryStats(int callingUid) {
        this.incrementStats(callingUid, this.mQueryStats);
    }

    private final void $$robo$$com_android_internal_util_ProviderAccessStats$incrementBatchStats(int callingUid) {
        this.incrementStats(callingUid, this.mBatchStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProviderAccessStats$finishOperation(int callingUid) {
        PerThreadData data = this.mThreadLocal.get();
        --data.nestCount;
        if (data.nestCount == 0) {
            long duration = Math.max(1L, SystemClock.uptimeMillis() - data.startUptimeMillis);
            Object object = this.mLock;
            synchronized (object) {
                this.mOperationDurationMillis.put(callingUid, this.mOperationDurationMillis.get(callingUid) + duration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProviderAccessStats$dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("  Process uptime: ");
            pw.print((SystemClock.uptimeMillis() - this.mStartUptime) / 60000L);
            pw.println(" minutes");
            pw.println();
            pw.print(prefix);
            pw.println("Client activities:");
            pw.print(prefix);
            pw.println("  UID        Query  Insert Update Delete   Batch Insert Update Delete          Sec");
            for (int i = 0; i < this.mAllCallingUids.size(); ++i) {
                int uid = this.mAllCallingUids.keyAt(i);
                pw.print(prefix);
                pw.println(String.format("  %-9d %6d  %6d %6d %6d  %6d %6d %6d %6d %12.3f", uid, this.mQueryStats.get(uid), this.mInsertStats.get(uid), this.mUpdateStats.get(uid), this.mDeleteStats.get(uid), this.mBatchStats.get(uid), this.mInsertInBatchStats.get(uid), this.mUpdateInBatchStats.get(uid), this.mDeleteInBatchStats.get(uid), (double)this.mOperationDurationMillis.get(uid) / 1000.0));
            }
            pw.println();
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_ProviderAccessStats$__constructor__();
    }

    public ProviderAccessStats() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ProviderAccessStats$__constructor__(), this);
    }

    private void incrementStats(int n, SparseLongArray sparseLongArray) {
        InvokeDynamicSupport.bootstrap("incrementStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementStats(int android.util.SparseLongArray ), this, n, sparseLongArray);
    }

    private void incrementStats(int n, boolean bl, SparseLongArray sparseLongArray, SparseLongArray sparseLongArray2) {
        InvokeDynamicSupport.bootstrap("incrementStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementStats(int boolean android.util.SparseLongArray android.util.SparseLongArray ), this, n, bl, sparseLongArray, sparseLongArray2);
    }

    public void incrementInsertStats(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("incrementInsertStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementInsertStats(int boolean ), this, n, bl);
    }

    public void incrementUpdateStats(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("incrementUpdateStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementUpdateStats(int boolean ), this, n, bl);
    }

    public void incrementDeleteStats(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("incrementDeleteStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementDeleteStats(int boolean ), this, n, bl);
    }

    public void incrementQueryStats(int n) {
        InvokeDynamicSupport.bootstrap("incrementQueryStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementQueryStats(int ), this, n);
    }

    public void incrementBatchStats(int n) {
        InvokeDynamicSupport.bootstrap("incrementBatchStats", $$robo$$com_android_internal_util_ProviderAccessStats$incrementBatchStats(int ), this, n);
    }

    public void finishOperation(int n) {
        InvokeDynamicSupport.bootstrap("finishOperation", $$robo$$com_android_internal_util_ProviderAccessStats$finishOperation(int ), this, n);
    }

    public void dump(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_util_ProviderAccessStats$dump(java.io.PrintWriter java.lang.String ), this, printWriter, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProviderAccessStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PerThreadData
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int nestCount;
        public long startUptimeMillis;

        private void $$robo$$com_android_internal_util_ProviderAccessStats_PerThreadData$__constructor__() {
        }

        private /* synthetic */ void $$robo$$com_android_internal_util_ProviderAccessStats_PerThreadData$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_ProviderAccessStats_PerThreadData$__constructor__();
        }

        public PerThreadData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ProviderAccessStats_PerThreadData$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_util_ProviderAccessStats_PerThreadData$__constructor__(var1_1);
        }

        public /* synthetic */ PerThreadData(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ProviderAccessStats_PerThreadData$__constructor__(com.android.internal.util.ProviderAccessStats$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PerThreadData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

