/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ProcFileReader
implements Closeable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private InputStream mStream;
    private byte[] mBuffer;
    private int mTail;
    private boolean mLineFinished;

    private void $$robo$$com_android_internal_util_ProcFileReader$__constructor__(InputStream stream) throws IOException {
    }

    private void $$robo$$com_android_internal_util_ProcFileReader$__constructor__(InputStream stream, int bufferSize) throws IOException {
        this.mStream = stream;
        this.mBuffer = new byte[bufferSize];
        this.fillBuf();
    }

    private final int $$robo$$com_android_internal_util_ProcFileReader$fillBuf() throws IOException {
        int length = this.mBuffer.length - this.mTail;
        if (length == 0) {
            throw new IOException("attempting to fill already-full buffer");
        }
        int read = this.mStream.read(this.mBuffer, this.mTail, length);
        if (read != -1) {
            this.mTail += read;
        }
        return read;
    }

    private final void $$robo$$com_android_internal_util_ProcFileReader$consumeBuf(int count) throws IOException {
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mBuffer, (int)count, (byte[])this.mBuffer, (int)0, (int)(this.mTail - count));
        this.mTail -= count;
        if (this.mTail == 0) {
            this.fillBuf();
        }
    }

    private final int $$robo$$com_android_internal_util_ProcFileReader$nextTokenIndex() throws IOException {
        if (this.mLineFinished) {
            return -1;
        }
        int i = 0;
        while (true) {
            if (i < this.mTail) {
                byte b = this.mBuffer[i];
                if (b == 10) {
                    this.mLineFinished = true;
                    return i;
                }
                if (b == 32) {
                    return i;
                }
                ++i;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new ProtocolException("End of stream while looking for token boundary");
    }

    private final boolean $$robo$$com_android_internal_util_ProcFileReader$hasMoreData() {
        return this.mTail > 0;
    }

    private final void $$robo$$com_android_internal_util_ProcFileReader$finishLine() throws IOException {
        if (this.mLineFinished) {
            this.mLineFinished = false;
            return;
        }
        int i = 0;
        while (true) {
            if (i < this.mTail) {
                if (this.mBuffer[i] == 10) {
                    this.consumeBuf(i + 1);
                    return;
                }
                ++i;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new ProtocolException("End of stream while looking for line boundary");
    }

    private final String $$robo$$com_android_internal_util_ProcFileReader$nextString() throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            throw new ProtocolException("Missing required string");
        }
        return this.parseAndConsumeString(tokenIndex);
    }

    private final long $$robo$$com_android_internal_util_ProcFileReader$nextLong() throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            throw new ProtocolException("Missing required long");
        }
        return this.parseAndConsumeLong(tokenIndex);
    }

    private final long $$robo$$com_android_internal_util_ProcFileReader$nextOptionalLong(long def) throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            return def;
        }
        return this.parseAndConsumeLong(tokenIndex);
    }

    private final String $$robo$$com_android_internal_util_ProcFileReader$parseAndConsumeString(int tokenIndex) throws IOException {
        String s = new String(this.mBuffer, 0, tokenIndex, StandardCharsets.US_ASCII);
        this.consumeBuf(tokenIndex + 1);
        return s;
    }

    private final long $$robo$$com_android_internal_util_ProcFileReader$parseAndConsumeLong(int tokenIndex) throws IOException {
        int i;
        boolean negative = this.mBuffer[0] == 45;
        long result = 0L;
        int n = i = negative ? 1 : 0;
        while (i < tokenIndex) {
            int digit = this.mBuffer[i] - 48;
            if (digit < 0 || digit > 9) {
                throw this.invalidLong(tokenIndex);
            }
            long next = result * 10L - (long)digit;
            if (next > result) {
                throw this.invalidLong(tokenIndex);
            }
            result = next;
            ++i;
        }
        this.consumeBuf(tokenIndex + 1);
        return negative ? result : -result;
    }

    private final NumberFormatException $$robo$$com_android_internal_util_ProcFileReader$invalidLong(int tokenIndex) {
        return new NumberFormatException("invalid long: " + new String(this.mBuffer, 0, tokenIndex, StandardCharsets.US_ASCII));
    }

    private final int $$robo$$com_android_internal_util_ProcFileReader$nextInt() throws IOException {
        long value = this.nextLong();
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new NumberFormatException("parsed value larger than integer");
        }
        return (int)value;
    }

    private final void $$robo$$com_android_internal_util_ProcFileReader$close() throws IOException {
        this.mStream.close();
    }

    private void __constructor__(InputStream inputStream) throws IOException {
        this.$$robo$$com_android_internal_util_ProcFileReader$__constructor__(inputStream);
    }

    public ProcFileReader(InputStream inputStream) throws IOException {
        this(inputStream, 4096);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ProcFileReader$__constructor__(java.io.InputStream ), this, inputStream);
    }

    private void __constructor__(InputStream inputStream, int n) throws IOException {
        this.$$robo$$com_android_internal_util_ProcFileReader$__constructor__(inputStream, n);
    }

    public ProcFileReader(InputStream inputStream, int n) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ProcFileReader$__constructor__(java.io.InputStream int ), this, inputStream, n);
    }

    private int fillBuf() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("fillBuf", $$robo$$com_android_internal_util_ProcFileReader$fillBuf(), this);
    }

    private void consumeBuf(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("consumeBuf", $$robo$$com_android_internal_util_ProcFileReader$consumeBuf(int ), this, n);
    }

    private int nextTokenIndex() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("nextTokenIndex", $$robo$$com_android_internal_util_ProcFileReader$nextTokenIndex(), this);
    }

    public boolean hasMoreData() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMoreData", $$robo$$com_android_internal_util_ProcFileReader$hasMoreData(), this);
    }

    public void finishLine() throws IOException {
        InvokeDynamicSupport.bootstrap("finishLine", $$robo$$com_android_internal_util_ProcFileReader$finishLine(), this);
    }

    public String nextString() throws IOException {
        return InvokeDynamicSupport.bootstrap("nextString", $$robo$$com_android_internal_util_ProcFileReader$nextString(), this);
    }

    public long nextLong() throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("nextLong", $$robo$$com_android_internal_util_ProcFileReader$nextLong(), this);
    }

    public long nextOptionalLong(long l) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("nextOptionalLong", $$robo$$com_android_internal_util_ProcFileReader$nextOptionalLong(long ), this, l);
    }

    private String parseAndConsumeString(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("parseAndConsumeString", $$robo$$com_android_internal_util_ProcFileReader$parseAndConsumeString(int ), this, n);
    }

    private long parseAndConsumeLong(int n) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("parseAndConsumeLong", $$robo$$com_android_internal_util_ProcFileReader$parseAndConsumeLong(int ), this, n);
    }

    private NumberFormatException invalidLong(int n) {
        return InvokeDynamicSupport.bootstrap("invalidLong", $$robo$$com_android_internal_util_ProcFileReader$invalidLong(int ), this, n);
    }

    public int nextInt() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("nextInt", $$robo$$com_android_internal_util_ProcFileReader$nextInt(), this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_util_ProcFileReader$close(), this);
    }

    public /* synthetic */ ProcFileReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcFileReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

