/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.app.Notification;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NotificationMessagingUtil
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String DEFAULT_SMS_APP_SETTING = "sms_default_application";
    private Context mContext;
    private ArrayMap<Integer, String> mDefaultSmsApp;
    private ContentObserver mSmsContentObserver;

    private void $$robo$$com_android_internal_util_NotificationMessagingUtil$__constructor__(Context context) {
        this.mDefaultSmsApp = new ArrayMap();
        this.mSmsContentObserver = new ShadowedObject(this, new Handler(Looper.getMainLooper())){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NotificationMessagingUtil this$0;

            private void $$robo$$com_android_internal_util_NotificationMessagingUtil_1$__constructor__(NotificationMessagingUtil this$0, Handler x0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_util_NotificationMessagingUtil_1$onChange(boolean selfChange, Uri uri, int userId) {
                if (Settings.Secure.getUriFor("sms_default_application").equals(uri)) {
                    this.this$0.cacheDefaultSmsApp(userId);
                }
            }

            private void __constructor__(NotificationMessagingUtil notificationMessagingUtil, Handler handler) {
                this.$$robo$$com_android_internal_util_NotificationMessagingUtil_1$__constructor__(notificationMessagingUtil, handler);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_NotificationMessagingUtil_1$__constructor__(com.android.internal.util.NotificationMessagingUtil android.os.Handler ), this, notificationMessagingUtil, handler);
            }

            @Override
            public void onChange(boolean bl, Uri uri, int n) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_util_NotificationMessagingUtil_1$onChange(boolean android.net.Uri int ), this, bl, uri, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("sms_default_application"), false, this.mSmsContentObserver);
    }

    private final boolean $$robo$$com_android_internal_util_NotificationMessagingUtil$isImportantMessaging(StatusBarNotification sbn, int importance) {
        if (importance < 2) {
            return false;
        }
        return this.hasMessagingStyle(sbn) || this.isCategoryMessage(sbn) && this.isDefaultMessagingApp(sbn);
    }

    private final boolean $$robo$$com_android_internal_util_NotificationMessagingUtil$isMessaging(StatusBarNotification sbn) {
        return this.hasMessagingStyle(sbn) || this.isDefaultMessagingApp(sbn) || this.isCategoryMessage(sbn);
    }

    private final boolean $$robo$$com_android_internal_util_NotificationMessagingUtil$isDefaultMessagingApp(StatusBarNotification sbn) {
        int userId = sbn.getUserId();
        if (userId == -10000 || userId == -1) {
            return false;
        }
        if (this.mDefaultSmsApp.get(userId) == null) {
            this.cacheDefaultSmsApp(userId);
        }
        return Objects.equals(this.mDefaultSmsApp.get(userId), sbn.getPackageName());
    }

    private final void $$robo$$com_android_internal_util_NotificationMessagingUtil$cacheDefaultSmsApp(int userId) {
        this.mDefaultSmsApp.put(userId, Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "sms_default_application", userId));
    }

    private final boolean $$robo$$com_android_internal_util_NotificationMessagingUtil$hasMessagingStyle(StatusBarNotification sbn) {
        Class<? extends Notification.Style> style2 = sbn.getNotification().getNotificationStyle();
        return Notification.MessagingStyle.class.equals(style2);
    }

    private final boolean $$robo$$com_android_internal_util_NotificationMessagingUtil$isCategoryMessage(StatusBarNotification sbn) {
        return "msg".equals(sbn.getNotification().category);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_util_NotificationMessagingUtil$__constructor__(context);
    }

    public NotificationMessagingUtil(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_NotificationMessagingUtil$__constructor__(android.content.Context ), this, context);
    }

    public boolean isImportantMessaging(StatusBarNotification statusBarNotification, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isImportantMessaging", $$robo$$com_android_internal_util_NotificationMessagingUtil$isImportantMessaging(android.service.notification.StatusBarNotification int ), this, statusBarNotification, n);
    }

    public boolean isMessaging(StatusBarNotification statusBarNotification) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMessaging", $$robo$$com_android_internal_util_NotificationMessagingUtil$isMessaging(android.service.notification.StatusBarNotification ), this, statusBarNotification);
    }

    private boolean isDefaultMessagingApp(StatusBarNotification statusBarNotification) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultMessagingApp", $$robo$$com_android_internal_util_NotificationMessagingUtil$isDefaultMessagingApp(android.service.notification.StatusBarNotification ), this, statusBarNotification);
    }

    private void cacheDefaultSmsApp(int n) {
        InvokeDynamicSupport.bootstrap("cacheDefaultSmsApp", $$robo$$com_android_internal_util_NotificationMessagingUtil$cacheDefaultSmsApp(int ), this, n);
    }

    private boolean hasMessagingStyle(StatusBarNotification statusBarNotification) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessagingStyle", $$robo$$com_android_internal_util_NotificationMessagingUtil$hasMessagingStyle(android.service.notification.StatusBarNotification ), this, statusBarNotification);
    }

    private boolean isCategoryMessage(StatusBarNotification statusBarNotification) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCategoryMessage", $$robo$$com_android_internal_util_NotificationMessagingUtil$isCategoryMessage(android.service.notification.StatusBarNotification ), this, statusBarNotification);
    }

    public /* synthetic */ NotificationMessagingUtil() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationMessagingUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

