/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.util;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.net.Uri;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.util.VoicemailNotificationSettingsUtil;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NotificationChannelController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String CHANNEL_ID_ALERT = "alert";
    public static String CHANNEL_ID_CALL_FORWARD = "callForward";
    public static String CHANNEL_ID_MOBILE_DATA_STATUS = "mobileDataAlertNew";
    public static String CHANNEL_ID_SIM = "sim";
    public static String CHANNEL_ID_SMS = "sms";
    public static String CHANNEL_ID_VOICE_MAIL = "voiceMail";
    public static String CHANNEL_ID_WFC = "wfc";
    private static String CHANNEL_ID_MOBILE_DATA_ALERT_DEPRECATED = "mobileDataAlert";
    private BroadcastReceiver mBroadcastReceiver;

    private static final void $$robo$$com_android_internal_telephony_util_NotificationChannelController$createAll(Context context) {
        NotificationChannel alertChannel = new NotificationChannel("alert", context.getText(17040367), 3);
        alertChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, new AudioAttributes.Builder().setUsage(5).build());
        alertChannel.setBlockableSystem(true);
        NotificationChannel mobileDataStatusChannel = new NotificationChannel("mobileDataAlertNew", context.getText(17040366), 2);
        mobileDataStatusChannel.setBlockableSystem(true);
        NotificationChannel simChannel = new NotificationChannel("sim", context.getText(17040374), 2);
        simChannel.setSound(null, null);
        context.getSystemService(NotificationManager.class).createNotificationChannels(Arrays.asList(new NotificationChannel("callForward", context.getText(17040358), 2), new NotificationChannel("sms", context.getText(17040375), 4), new NotificationChannel("wfc", context.getText(17040382), 2), alertChannel, mobileDataStatusChannel, simChannel));
        if (NotificationChannelController.getChannel("voiceMail", context) != null) {
            NotificationChannelController.migrateVoicemailNotificationSettings(context);
        }
        if (NotificationChannelController.getChannel("mobileDataAlert", context) != null) {
            context.getSystemService(NotificationManager.class).deleteNotificationChannel("mobileDataAlert");
        }
    }

    private void $$robo$$com_android_internal_telephony_util_NotificationChannelController$__constructor__(Context context) {
        this.mBroadcastReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NotificationChannelController this$0;

            private void $$robo$$com_android_internal_telephony_util_NotificationChannelController_1$__constructor__(NotificationChannelController this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_util_NotificationChannelController_1$onReceive(Context context, Intent intent) {
                if ("android.intent.action.LOCALE_CHANGED".equals(intent.getAction())) {
                    NotificationChannelController.createAll(context);
                } else if ("android.intent.action.SIM_STATE_CHANGED".equals(intent.getAction()) && -1 != SubscriptionManager.getDefaultSubscriptionId()) {
                    NotificationChannelController.migrateVoicemailNotificationSettings(context);
                }
            }

            private void __constructor__(NotificationChannelController notificationChannelController) {
                this.$$robo$$com_android_internal_telephony_util_NotificationChannelController_1$__constructor__(notificationChannelController);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_util_NotificationChannelController_1$__constructor__(com.android.internal.telephony.util.NotificationChannelController ), this, notificationChannelController);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_util_NotificationChannelController_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.LOCALE_CHANGED");
        intentFilter.addAction("android.intent.action.SIM_STATE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, intentFilter);
        NotificationChannelController.createAll(context);
    }

    private static final NotificationChannel $$robo$$com_android_internal_telephony_util_NotificationChannelController$getChannel(String channelId, Context context) {
        return context.getSystemService(NotificationManager.class).getNotificationChannel(channelId);
    }

    private static final void $$robo$$com_android_internal_telephony_util_NotificationChannelController$migrateVoicemailNotificationSettings(Context context) {
        NotificationChannel voiceMailChannel = new NotificationChannel("voiceMail", context.getText(17040380), 3);
        voiceMailChannel.enableVibration(VoicemailNotificationSettingsUtil.getVibrationPreference(context));
        Uri sound = VoicemailNotificationSettingsUtil.getRingTonePreference(context);
        voiceMailChannel.setSound(sound == null ? Settings.System.DEFAULT_NOTIFICATION_URI : sound, new AudioAttributes.Builder().setUsage(5).build());
        context.getSystemService(NotificationManager.class).createNotificationChannel(voiceMailChannel);
    }

    private static void createAll(Context context) {
        InvokeDynamicSupport.bootstrapStatic("createAll", $$robo$$com_android_internal_telephony_util_NotificationChannelController$createAll(android.content.Context ), (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_util_NotificationChannelController$__constructor__(context);
    }

    public NotificationChannelController(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_util_NotificationChannelController$__constructor__(android.content.Context ), this, context);
    }

    public static NotificationChannel getChannel(String string2, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getChannel", $$robo$$com_android_internal_telephony_util_NotificationChannelController$getChannel(java.lang.String android.content.Context ), (String)string2, (Context)context);
    }

    private static void migrateVoicemailNotificationSettings(Context context) {
        InvokeDynamicSupport.bootstrapStatic("migrateVoicemailNotificationSettings", $$robo$$com_android_internal_telephony_util_NotificationChannelController$migrateVoicemailNotificationSettings(android.content.Context ), (Context)context);
    }

    public /* synthetic */ NotificationChannelController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationChannelController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

