/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.test.CallInfo;
import com.android.internal.telephony.test.InvalidStateEx;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SimulatedGsmCallState
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    CallInfo[] mCalls;
    private boolean mAutoProgressConnecting;
    private boolean mNextDialFailImmediately;
    static int EVENT_PROGRESS_CALL_STATE = 1;
    static int MAX_CALLS = 7;
    static int CONNECTING_PAUSE_MSEC = 500;

    private void $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$__constructor__(Looper looper) {
        this.mCalls = new CallInfo[7];
        this.mAutoProgressConnecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$handleMessage(Message msg) {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            switch (msg.what) {
                case 1: {
                    this.progressConnectingCallState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerRing(String number) {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            int empty = -1;
            boolean isCallWaiting = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null && empty < 0) {
                    empty = i;
                    continue;
                }
                if (call != null && (call.mState == CallInfo.State.INCOMING || call.mState == CallInfo.State.WAITING)) {
                    Rlog.w("ModelInterpreter", "triggerRing failed; phone already ringing");
                    return false;
                }
                if (call == null) continue;
                isCallWaiting = true;
            }
            if (empty < 0) {
                Rlog.w("ModelInterpreter", "triggerRing failed; all full");
                return false;
            }
            this.mCalls[empty] = CallInfo.createIncomingCall(PhoneNumberUtils.extractNetworkPortion(number));
            if (isCallWaiting) {
                this.mCalls[empty].mState = CallInfo.State.WAITING;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$progressConnectingCallState() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call != null && call.mState == CallInfo.State.DIALING) {
                    call.mState = CallInfo.State.ALERTING;
                    if (!this.mAutoProgressConnecting) break;
                    this.sendMessageDelayed(this.obtainMessage(1, call), 500L);
                    break;
                }
                if (call == null || call.mState != CallInfo.State.ALERTING) continue;
                call.mState = CallInfo.State.ACTIVE;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$progressConnectingToActive() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.DIALING && call.mState != CallInfo.State.ALERTING) continue;
                call.mState = CallInfo.State.ACTIVE;
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$setAutoProgressConnectingCall(boolean b) {
        this.mAutoProgressConnecting = b;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$setNextDialFailImmediately(boolean b) {
        this.mNextDialFailImmediately = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerHangupForeground() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            CallInfo call;
            int i;
            boolean found = false;
            for (i = 0; i < this.mCalls.length; ++i) {
                call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.INCOMING && call.mState != CallInfo.State.WAITING) continue;
                this.mCalls[i] = null;
                found = true;
            }
            for (i = 0; i < this.mCalls.length; ++i) {
                call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.DIALING && call.mState != CallInfo.State.ACTIVE && call.mState != CallInfo.State.ALERTING) continue;
                this.mCalls[i] = null;
                found = true;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerHangupBackground() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            boolean found = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.HOLDING) continue;
                this.mCalls[i] = null;
                found = true;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerHangupAll() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            boolean found = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (this.mCalls[i] != null) {
                    found = true;
                }
                this.mCalls[i] = null;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onAnswer() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo call = this.mCalls[i];
                if (call == null || call.mState != CallInfo.State.INCOMING && call.mState != CallInfo.State.WAITING) continue;
                return this.switchActiveAndHeldOrWaiting();
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onHangup() {
        boolean found = false;
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo call = this.mCalls[i];
            if (call == null || call.mState == CallInfo.State.WAITING) continue;
            this.mCalls[i] = null;
            found = true;
        }
        return found;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onChld(char c0, char c1) {
        boolean ret;
        int callIndex = 0;
        if (c1 != '\u0000' && ((callIndex = c1 - 49) < 0 || callIndex >= this.mCalls.length)) {
            return false;
        }
        switch (c0) {
            case '0': {
                ret = this.releaseHeldOrUDUB();
                break;
            }
            case '1': {
                if (c1 <= '\u0000') {
                    ret = this.releaseActiveAcceptHeldOrWaiting();
                    break;
                }
                if (this.mCalls[callIndex] == null) {
                    ret = false;
                    break;
                }
                this.mCalls[callIndex] = null;
                ret = true;
                break;
            }
            case '2': {
                if (c1 <= '\u0000') {
                    ret = this.switchActiveAndHeldOrWaiting();
                    break;
                }
                ret = this.separateCall(callIndex);
                break;
            }
            case '3': {
                ret = this.conference();
                break;
            }
            case '4': {
                ret = this.explicitCallTransfer();
                break;
            }
            case '5': {
                ret = false;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$releaseHeldOrUDUB() {
        CallInfo c;
        int i;
        boolean found = false;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || !c.isRinging()) continue;
            found = true;
            this.mCalls[i] = null;
            break;
        }
        if (!found) {
            for (i = 0; i < this.mCalls.length; ++i) {
                c = this.mCalls[i];
                if (c == null || c.mState != CallInfo.State.HOLDING) continue;
                found = true;
                this.mCalls[i] = null;
            }
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$releaseActiveAcceptHeldOrWaiting() {
        CallInfo c;
        int i;
        boolean foundHeld = false;
        boolean foundActive = false;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || c.mState != CallInfo.State.ACTIVE) continue;
            this.mCalls[i] = null;
            foundActive = true;
        }
        if (!foundActive) {
            for (i = 0; i < this.mCalls.length; ++i) {
                c = this.mCalls[i];
                if (c == null || c.mState != CallInfo.State.DIALING && c.mState != CallInfo.State.ALERTING) continue;
                this.mCalls[i] = null;
                foundActive = true;
            }
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || c.mState != CallInfo.State.HOLDING) continue;
            c.mState = CallInfo.State.ACTIVE;
            foundHeld = true;
        }
        if (foundHeld) {
            return true;
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || !c.isRinging()) continue;
            c.mState = CallInfo.State.ACTIVE;
            return true;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$switchActiveAndHeldOrWaiting() {
        CallInfo c;
        int i;
        boolean hasHeld = false;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null || c.mState != CallInfo.State.HOLDING) continue;
            hasHeld = true;
            break;
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null) continue;
            if (c.mState == CallInfo.State.ACTIVE) {
                c.mState = CallInfo.State.HOLDING;
                continue;
            }
            if (c.mState == CallInfo.State.HOLDING) {
                c.mState = CallInfo.State.ACTIVE;
                continue;
            }
            if (hasHeld || !c.isRinging()) continue;
            c.mState = CallInfo.State.ACTIVE;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$separateCall(int index) {
        try {
            CallInfo c = this.mCalls[index];
            if (c == null || c.isConnecting() || this.countActiveLines() != 1) {
                return false;
            }
            c.mState = CallInfo.State.ACTIVE;
            c.mIsMpty = false;
            for (int i = 0; i < this.mCalls.length; ++i) {
                CallInfo cb;
                int countHeld = 0;
                int lastHeld = 0;
                if (i != index && (cb = this.mCalls[i]) != null && cb.mState == CallInfo.State.ACTIVE) {
                    cb.mState = CallInfo.State.HOLDING;
                    ++countHeld;
                    lastHeld = i;
                }
                if (countHeld != true) continue;
                this.mCalls[lastHeld].mIsMpty = false;
            }
            return true;
        }
        catch (InvalidStateEx ex) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$conference() {
        CallInfo c;
        int i;
        int countCalls = 0;
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null) continue;
            ++countCalls;
            if (!c.isConnecting()) continue;
            return false;
        }
        for (i = 0; i < this.mCalls.length; ++i) {
            c = this.mCalls[i];
            if (c == null) continue;
            c.mState = CallInfo.State.ACTIVE;
            if (countCalls <= 0) continue;
            c.mIsMpty = true;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$explicitCallTransfer() {
        int countCalls = 0;
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo c = this.mCalls[i];
            if (c == null) continue;
            ++countCalls;
            if (!c.isConnecting()) continue;
            return false;
        }
        return this.triggerHangupAll();
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onDial(String address) {
        int freeSlot = -1;
        Rlog.d("GSM", "SC> dial '" + address + "'");
        if (this.mNextDialFailImmediately) {
            this.mNextDialFailImmediately = false;
            Rlog.d("GSM", "SC< dial fail (per request)");
            return false;
        }
        String phNum = PhoneNumberUtils.extractNetworkPortion(address);
        if (phNum.length() == 0) {
            Rlog.d("GSM", "SC< dial fail (invalid ph num)");
            return false;
        }
        if (phNum.startsWith("*99") && phNum.endsWith("#")) {
            Rlog.d("GSM", "SC< dial ignored (gprs)");
            return true;
        }
        try {
            if (this.countActiveLines() > 1) {
                Rlog.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
        }
        catch (InvalidStateEx ex) {
            Rlog.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        for (int i = 0; i < this.mCalls.length; ++i) {
            if (freeSlot < 0 && this.mCalls[i] == null) {
                freeSlot = i;
            }
            if (this.mCalls[i] != null && !this.mCalls[i].isActiveOrHeld()) {
                Rlog.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
            if (this.mCalls[i] == null || this.mCalls[i].mState != CallInfo.State.ACTIVE) continue;
            this.mCalls[i].mState = CallInfo.State.HOLDING;
        }
        if (freeSlot < 0) {
            Rlog.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        this.mCalls[freeSlot] = CallInfo.createOutgoingCall(phNum);
        if (this.mAutoProgressConnecting) {
            this.sendMessageDelayed(this.obtainMessage(1, this.mCalls[freeSlot]), 500L);
        }
        Rlog.d("GSM", "SC< dial (slot = " + freeSlot + ")");
        return true;
    }

    private final List<DriverCall> $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$getDriverCalls() {
        ArrayList<DriverCall> ret = new ArrayList<DriverCall>(this.mCalls.length);
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo c = this.mCalls[i];
            if (c == null) continue;
            DriverCall dc = c.toDriverCall(i + 1);
            ret.add(dc);
        }
        Rlog.d("GSM", "SC< getDriverCalls " + ret);
        return ret;
    }

    private final List<String> $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$getClccLines() {
        ArrayList<String> ret = new ArrayList<String>(this.mCalls.length);
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo c = this.mCalls[i];
            if (c == null) continue;
            ret.add(c.toCLCCLine(i + 1));
        }
        return ret;
    }

    private final int $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$countActiveLines() throws InvalidStateEx {
        boolean hasMpty = false;
        boolean hasHeld = false;
        boolean hasActive = false;
        boolean hasConnecting = false;
        boolean hasRinging = false;
        boolean mptyIsHeld = false;
        for (int i = 0; i < this.mCalls.length; ++i) {
            CallInfo call = this.mCalls[i];
            if (call == null) continue;
            if (!hasMpty && call.mIsMpty) {
                mptyIsHeld = call.mState == CallInfo.State.HOLDING;
            } else {
                if (call.mIsMpty && mptyIsHeld && call.mState == CallInfo.State.ACTIVE) {
                    Rlog.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
                if (!call.mIsMpty && hasMpty && mptyIsHeld && call.mState == CallInfo.State.HOLDING) {
                    Rlog.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
            }
            hasMpty |= call.mIsMpty;
            hasHeld |= call.mState == CallInfo.State.HOLDING;
            hasActive |= call.mState == CallInfo.State.ACTIVE;
            hasConnecting |= call.isConnecting();
            hasRinging |= call.isRinging();
        }
        int ret = 0;
        if (hasHeld) {
            ++ret;
        }
        if (hasActive) {
            ++ret;
        }
        if (hasConnecting) {
            ++ret;
        }
        if (hasRinging) {
            ++ret;
        }
        return ret;
    }

    private void __constructor__(Looper looper) {
        this.$$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$__constructor__(looper);
    }

    public SimulatedGsmCallState(Looper looper) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$__constructor__(android.os.Looper ), this, looper);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$handleMessage(android.os.Message ), this, message);
    }

    public boolean triggerRing(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("triggerRing", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerRing(java.lang.String ), this, string2);
    }

    public void progressConnectingCallState() {
        InvokeDynamicSupport.bootstrap("progressConnectingCallState", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$progressConnectingCallState(), this);
    }

    public void progressConnectingToActive() {
        InvokeDynamicSupport.bootstrap("progressConnectingToActive", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$progressConnectingToActive(), this);
    }

    public void setAutoProgressConnectingCall(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoProgressConnectingCall", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$setAutoProgressConnectingCall(boolean ), this, bl);
    }

    public void setNextDialFailImmediately(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNextDialFailImmediately", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$setNextDialFailImmediately(boolean ), this, bl);
    }

    public boolean triggerHangupForeground() {
        return (boolean)InvokeDynamicSupport.bootstrap("triggerHangupForeground", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerHangupForeground(), this);
    }

    public boolean triggerHangupBackground() {
        return (boolean)InvokeDynamicSupport.bootstrap("triggerHangupBackground", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerHangupBackground(), this);
    }

    public boolean triggerHangupAll() {
        return (boolean)InvokeDynamicSupport.bootstrap("triggerHangupAll", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$triggerHangupAll(), this);
    }

    public boolean onAnswer() {
        return (boolean)InvokeDynamicSupport.bootstrap("onAnswer", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onAnswer(), this);
    }

    public boolean onHangup() {
        return (boolean)InvokeDynamicSupport.bootstrap("onHangup", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onHangup(), this);
    }

    public boolean onChld(char c, char c2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onChld", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onChld(char char ), this, c, c2);
    }

    public boolean releaseHeldOrUDUB() {
        return (boolean)InvokeDynamicSupport.bootstrap("releaseHeldOrUDUB", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$releaseHeldOrUDUB(), this);
    }

    public boolean releaseActiveAcceptHeldOrWaiting() {
        return (boolean)InvokeDynamicSupport.bootstrap("releaseActiveAcceptHeldOrWaiting", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$releaseActiveAcceptHeldOrWaiting(), this);
    }

    public boolean switchActiveAndHeldOrWaiting() {
        return (boolean)InvokeDynamicSupport.bootstrap("switchActiveAndHeldOrWaiting", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$switchActiveAndHeldOrWaiting(), this);
    }

    public boolean separateCall(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("separateCall", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$separateCall(int ), this, n);
    }

    public boolean conference() {
        return (boolean)InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$conference(), this);
    }

    public boolean explicitCallTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$explicitCallTransfer(), this);
    }

    public boolean onDial(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDial", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$onDial(java.lang.String ), this, string2);
    }

    public List<DriverCall> getDriverCalls() {
        return InvokeDynamicSupport.bootstrap("getDriverCalls", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$getDriverCalls(), this);
    }

    public List<String> getClccLines() {
        return InvokeDynamicSupport.bootstrap("getClccLines", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$getClccLines(), this);
    }

    private int countActiveLines() throws InvalidStateEx {
        return (int)InvokeDynamicSupport.bootstrap("countActiveLines", $$robo$$com_android_internal_telephony_test_SimulatedGsmCallState$countActiveLines(), this);
    }

    public /* synthetic */ SimulatedGsmCallState() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimulatedGsmCallState)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

