/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.HandlerThread;
import android.os.Looper;
import android.telephony.Rlog;
import com.android.internal.telephony.test.InterpreterEx;
import com.android.internal.telephony.test.LineReader;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ModelInterpreter
implements Runnable,
SimulatedRadioControl,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static int MAX_CALLS = 6;
    static int CONNECTING_PAUSE_MSEC = 500;
    static String LOG_TAG = "ModelInterpreter";
    InputStream mIn;
    OutputStream mOut;
    LineReader mLineReader;
    ServerSocket mSS;
    private String mFinalResponse;
    SimulatedGsmCallState mSimulatedCallState;
    HandlerThread mHandlerThread;
    int mPausedResponseCount;
    Object mPausedResponseMonitor;
    static int PROGRESS_CALL_STATE = 1;
    static String[][] sDefaultResponses;

    private void $$robo$$com_android_internal_telephony_test_ModelInterpreter$__constructor__(InputStream in, OutputStream out) {
        this.mPausedResponseMonitor = new Object();
        this.mIn = in;
        this.mOut = out;
        this.init();
    }

    private void $$robo$$com_android_internal_telephony_test_ModelInterpreter$__constructor__(InetSocketAddress sa) throws IOException {
        this.mPausedResponseMonitor = new Object();
        this.mSS = new ServerSocket();
        this.mSS.setReuseAddress(true);
        this.mSS.bind(sa);
        this.init();
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$init() {
        new Thread((Runnable)this, "ModelInterpreter").start();
        this.mHandlerThread = new HandlerThread("ModelInterpreter");
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.mSimulatedCallState = new SimulatedGsmCallState(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$run() {
        while (true) {
            String line;
            if (this.mSS != null) {
                Socket s;
                try {
                    s = this.mSS.accept();
                }
                catch (IOException ex) {
                    Rlog.w("ModelInterpreter", "IOException on socket.accept(); stopping", ex);
                    return;
                }
                try {
                    this.mIn = s.getInputStream();
                    this.mOut = s.getOutputStream();
                }
                catch (IOException ex) {
                    Rlog.w("ModelInterpreter", "IOException on accepted socket(); re-listening", ex);
                    continue;
                }
                Rlog.i("ModelInterpreter", "New connection accepted");
            }
            this.mLineReader = new LineReader(this.mIn);
            this.println("Welcome");
            while ((line = this.mLineReader.getNextLine()) != null) {
                Object object = this.mPausedResponseMonitor;
                synchronized (object) {
                    while (this.mPausedResponseCount > 0) {
                        try {
                            this.mPausedResponseMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = this;
                synchronized (object) {
                    try {
                        this.mFinalResponse = "OK";
                        this.processLine(line);
                        this.println(this.mFinalResponse);
                    }
                    catch (InterpreterEx ex) {
                        this.println(ex.mResult);
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                        this.println("ERROR");
                    }
                }
            }
            Rlog.i("ModelInterpreter", "Disconnected");
            if (this.mSS == null) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerRing(String number) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            boolean success = this.mSimulatedCallState.triggerRing(number);
            if (success) {
                this.println("RING");
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$progressConnectingCallState() {
        this.mSimulatedCallState.progressConnectingCallState();
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$progressConnectingToActive() {
        this.mSimulatedCallState.progressConnectingToActive();
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$setAutoProgressConnectingCall(boolean b) {
        this.mSimulatedCallState.setAutoProgressConnectingCall(b);
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$setNextDialFailImmediately(boolean b) {
        this.mSimulatedCallState.setNextDialFailImmediately(b);
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$setNextCallFailCause(int gsmCause) {
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerHangupForeground() {
        boolean success = this.mSimulatedCallState.triggerHangupForeground();
        if (success) {
            this.println("NO CARRIER");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerHangupBackground() {
        boolean success = this.mSimulatedCallState.triggerHangupBackground();
        if (success) {
            this.println("NO CARRIER");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerHangupAll() {
        boolean success = this.mSimulatedCallState.triggerHangupAll();
        if (success) {
            this.println("NO CARRIER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$sendUnsolicited(String unsol) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            this.println(unsol);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerSsn(int a, int b) {
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerIncomingUssd(String statusCode, String message) {
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerIncomingSMS(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$pauseResponses() {
        Object object = this.mPausedResponseMonitor;
        synchronized (object) {
            ++this.mPausedResponseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$resumeResponses() {
        Object object = this.mPausedResponseMonitor;
        synchronized (object) {
            --this.mPausedResponseCount;
            if (this.mPausedResponseCount == 0) {
                this.mPausedResponseMonitor.notifyAll();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$onAnswer() throws InterpreterEx {
        boolean success = this.mSimulatedCallState.onAnswer();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$onHangup() throws InterpreterEx {
        boolean success = false;
        success = this.mSimulatedCallState.onAnswer();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
        this.mFinalResponse = "NO CARRIER";
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$onCHLD(String command) throws InterpreterEx {
        boolean success;
        char c1 = '\u0000';
        char c0 = command.charAt(6);
        if (command.length() >= 8) {
            c1 = command.charAt(7);
        }
        if (!(success = this.mSimulatedCallState.onChld(c0, c1))) {
            throw new InterpreterEx("ERROR");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$onDial(String command) throws InterpreterEx {
        boolean success = this.mSimulatedCallState.onDial(command.substring(1));
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$onCLCC() {
        List<String> lines = this.mSimulatedCallState.getClccLines();
        int s = lines.size();
        for (int i = 0; i < s; ++i) {
            this.println(lines.get(i));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$onSMSSend(String command) {
        this.print("> ");
        String pdu = this.mLineReader.getNextLineCtrlZ();
        this.println("+CMGS: 1");
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$processLine(String line) throws InterpreterEx {
        String[] commands = this.splitCommands(line);
        for (int i = 0; i < commands.length; ++i) {
            String command = commands[i];
            if (command.equals("A")) {
                this.onAnswer();
                continue;
            }
            if (command.equals("H")) {
                this.onHangup();
                continue;
            }
            if (command.startsWith("+CHLD=")) {
                this.onCHLD(command);
                continue;
            }
            if (command.equals("+CLCC")) {
                this.onCLCC();
                continue;
            }
            if (command.startsWith("D")) {
                this.onDial(command);
                continue;
            }
            if (command.startsWith("+CMGS=")) {
                this.onSMSSend(command);
                continue;
            }
            boolean found = false;
            for (int j = 0; j < sDefaultResponses.length; ++j) {
                if (!command.equals(sDefaultResponses[j][0])) continue;
                String r = sDefaultResponses[j][1];
                if (r != null) {
                    this.println(r);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new InterpreterEx("ERROR");
        }
    }

    private final String[] $$robo$$com_android_internal_telephony_test_ModelInterpreter$splitCommands(String line) throws InterpreterEx {
        if (!line.startsWith("AT")) {
            throw new InterpreterEx("ERROR");
        }
        if (line.length() == 2) {
            return new String[0];
        }
        String[] ret = new String[]{line.substring(2)};
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$println(String s) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            try {
                byte[] bytes = s.getBytes("US-ASCII");
                this.mOut.write(bytes);
                this.mOut.write(13);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$print(String s) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            try {
                byte[] bytes = s.getBytes("US-ASCII");
                this.mOut.write(bytes);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_ModelInterpreter$shutdown() {
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
        try {
            this.mIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        sDefaultResponses = new String[][]{{"E0Q0V1", null}, {"+CMEE=2", null}, {"+CREG=2", null}, {"+CGREG=2", null}, {"+CCWA=1", null}, {"+COPS=0", null}, {"+CFUN=1", null}, {"+CGMI", "+CGMI: Android Model AT Interpreter\r"}, {"+CGMM", "+CGMM: Android Model AT Interpreter\r"}, {"+CGMR", "+CGMR: 1.0\r"}, {"+CGSN", "000000000000000\r"}, {"+CIMI", "320720000000000\r"}, {"+CSCS=?", "+CSCS: (\"HEX\",\"UCS2\")\r"}, {"+CFUN?", "+CFUN: 1\r"}, {"+COPS=3,0;+COPS?;+COPS=3,1;+COPS?;+COPS=3,2;+COPS?", "+COPS: 0,0,\"Android\"\r+COPS: 0,1,\"Android\"\r+COPS: 0,2,\"310995\"\r"}, {"+CREG?", "+CREG: 2,5, \"0113\", \"6614\"\r"}, {"+CGREG?", "+CGREG: 2,0\r"}, {"+CSQ", "+CSQ: 16,99\r"}, {"+CNMI?", "+CNMI: 1,2,2,1,1\r"}, {"+CLIR?", "+CLIR: 1,3\r"}, {"%CPVWI=2", "%CPVWI: 0\r"}, {"+CUSD=1,\"#646#\"", "+CUSD=0,\"You have used 23 minutes\"\r"}, {"+CRSM=176,12258,0,0,10", "+CRSM: 144,0,981062200050259429F6\r"}, {"+CRSM=192,12258,0,0,15", "+CRSM: 144,0,0000000A2FE204000FF55501020000\r"}, {"+CRSM=192,28474,0,0,15", "+CRSM: 144,0,0000005a6f3a040011f5220102011e\r"}, {"+CRSM=178,28474,1,4,30", "+CRSM: 144,0,437573746f6d65722043617265ffffff07818100398799f7ffffffffffff\r"}, {"+CRSM=178,28474,2,4,30", "+CRSM: 144,0,566f696365204d61696cffffffffffff07918150367742f3ffffffffffff\r"}, {"+CRSM=178,28474,3,4,30", "+CRSM: 144,0,4164676a6dffffffffffffffffffffff0b918188551512c221436587ff01\r"}, {"+CRSM=178,28474,4,4,30", "+CRSM: 144,0,810101c1ffffffffffffffffffffffff068114455245f8ffffffffffffff\r"}, {"+CRSM=192,28490,0,0,15", "+CRSM: 144,0,000000416f4a040011f5550102010d\r"}, {"+CRSM=178,28490,1,4,13", "+CRSM: 144,0,0206092143658709ffffffffff\r"}};
    }

    private void __constructor__(InputStream inputStream, OutputStream outputStream) {
        this.$$robo$$com_android_internal_telephony_test_ModelInterpreter$__constructor__(inputStream, outputStream);
    }

    public ModelInterpreter(InputStream inputStream, OutputStream outputStream) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_test_ModelInterpreter$__constructor__(java.io.InputStream java.io.OutputStream ), this, inputStream, outputStream);
    }

    private void __constructor__(InetSocketAddress inetSocketAddress) throws IOException {
        this.$$robo$$com_android_internal_telephony_test_ModelInterpreter$__constructor__(inetSocketAddress);
    }

    public ModelInterpreter(InetSocketAddress inetSocketAddress) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_test_ModelInterpreter$__constructor__(java.net.InetSocketAddress ), this, inetSocketAddress);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_telephony_test_ModelInterpreter$init(), this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_test_ModelInterpreter$run(), this);
    }

    @Override
    public void triggerRing(String string2) {
        InvokeDynamicSupport.bootstrap("triggerRing", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerRing(java.lang.String ), this, string2);
    }

    @Override
    public void progressConnectingCallState() {
        InvokeDynamicSupport.bootstrap("progressConnectingCallState", $$robo$$com_android_internal_telephony_test_ModelInterpreter$progressConnectingCallState(), this);
    }

    @Override
    public void progressConnectingToActive() {
        InvokeDynamicSupport.bootstrap("progressConnectingToActive", $$robo$$com_android_internal_telephony_test_ModelInterpreter$progressConnectingToActive(), this);
    }

    @Override
    public void setAutoProgressConnectingCall(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoProgressConnectingCall", $$robo$$com_android_internal_telephony_test_ModelInterpreter$setAutoProgressConnectingCall(boolean ), this, bl);
    }

    @Override
    public void setNextDialFailImmediately(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNextDialFailImmediately", $$robo$$com_android_internal_telephony_test_ModelInterpreter$setNextDialFailImmediately(boolean ), this, bl);
    }

    @Override
    public void setNextCallFailCause(int n) {
        InvokeDynamicSupport.bootstrap("setNextCallFailCause", $$robo$$com_android_internal_telephony_test_ModelInterpreter$setNextCallFailCause(int ), this, n);
    }

    @Override
    public void triggerHangupForeground() {
        InvokeDynamicSupport.bootstrap("triggerHangupForeground", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerHangupForeground(), this);
    }

    @Override
    public void triggerHangupBackground() {
        InvokeDynamicSupport.bootstrap("triggerHangupBackground", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerHangupBackground(), this);
    }

    @Override
    public void triggerHangupAll() {
        InvokeDynamicSupport.bootstrap("triggerHangupAll", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerHangupAll(), this);
    }

    public void sendUnsolicited(String string2) {
        InvokeDynamicSupport.bootstrap("sendUnsolicited", $$robo$$com_android_internal_telephony_test_ModelInterpreter$sendUnsolicited(java.lang.String ), this, string2);
    }

    @Override
    public void triggerSsn(int n, int n2) {
        InvokeDynamicSupport.bootstrap("triggerSsn", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerSsn(int int ), this, n, n2);
    }

    @Override
    public void triggerIncomingUssd(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("triggerIncomingUssd", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerIncomingUssd(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void triggerIncomingSMS(String string2) {
        InvokeDynamicSupport.bootstrap("triggerIncomingSMS", $$robo$$com_android_internal_telephony_test_ModelInterpreter$triggerIncomingSMS(java.lang.String ), this, string2);
    }

    @Override
    public void pauseResponses() {
        InvokeDynamicSupport.bootstrap("pauseResponses", $$robo$$com_android_internal_telephony_test_ModelInterpreter$pauseResponses(), this);
    }

    @Override
    public void resumeResponses() {
        InvokeDynamicSupport.bootstrap("resumeResponses", $$robo$$com_android_internal_telephony_test_ModelInterpreter$resumeResponses(), this);
    }

    private void onAnswer() throws InterpreterEx {
        InvokeDynamicSupport.bootstrap("onAnswer", $$robo$$com_android_internal_telephony_test_ModelInterpreter$onAnswer(), this);
    }

    private void onHangup() throws InterpreterEx {
        InvokeDynamicSupport.bootstrap("onHangup", $$robo$$com_android_internal_telephony_test_ModelInterpreter$onHangup(), this);
    }

    private void onCHLD(String string2) throws InterpreterEx {
        InvokeDynamicSupport.bootstrap("onCHLD", $$robo$$com_android_internal_telephony_test_ModelInterpreter$onCHLD(java.lang.String ), this, string2);
    }

    private void onDial(String string2) throws InterpreterEx {
        InvokeDynamicSupport.bootstrap("onDial", $$robo$$com_android_internal_telephony_test_ModelInterpreter$onDial(java.lang.String ), this, string2);
    }

    private void onCLCC() {
        InvokeDynamicSupport.bootstrap("onCLCC", $$robo$$com_android_internal_telephony_test_ModelInterpreter$onCLCC(), this);
    }

    private void onSMSSend(String string2) {
        InvokeDynamicSupport.bootstrap("onSMSSend", $$robo$$com_android_internal_telephony_test_ModelInterpreter$onSMSSend(java.lang.String ), this, string2);
    }

    void processLine(String string2) throws InterpreterEx {
        InvokeDynamicSupport.bootstrap("processLine", $$robo$$com_android_internal_telephony_test_ModelInterpreter$processLine(java.lang.String ), this, string2);
    }

    String[] splitCommands(String string2) throws InterpreterEx {
        return InvokeDynamicSupport.bootstrap("splitCommands", $$robo$$com_android_internal_telephony_test_ModelInterpreter$splitCommands(java.lang.String ), this, string2);
    }

    void println(String string2) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_telephony_test_ModelInterpreter$println(java.lang.String ), this, string2);
    }

    void print(String string2) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_telephony_test_ModelInterpreter$print(java.lang.String ), this, string2);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$com_android_internal_telephony_test_ModelInterpreter$shutdown(), this);
    }

    static {
        RobolectricInternals.classInitializing(ModelInterpreter.class);
    }

    public /* synthetic */ ModelInterpreter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ModelInterpreter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

