/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.hardware.radio.V1_0.SetupDataCallResult;
import android.os.Build;
import android.os.SystemClock;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyHistogram;
import android.telephony.data.DataCallResponse;
import android.telephony.ims.ImsCallSession;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.feature.MmTelFeature;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.metrics.CallSessionEventBuilder;
import com.android.internal.telephony.metrics.InProgressCallSession;
import com.android.internal.telephony.metrics.InProgressSmsSession;
import com.android.internal.telephony.metrics.ModemPowerMetrics;
import com.android.internal.telephony.metrics.SmsSessionEventBuilder;
import com.android.internal.telephony.metrics.TelephonyEventBuilder;
import com.android.internal.telephony.nano.TelephonyProto;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyMetrics
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int MAX_TELEPHONY_EVENTS = 1000;
    private static int MAX_COMPLETED_CALL_SESSIONS = 50;
    private static int MAX_COMPLETED_SMS_SESSIONS = 500;
    private static int SESSION_START_PRECISION_MINUTES = 5;
    private static TelephonyMetrics sInstance;
    private Deque<TelephonyProto.TelephonyEvent> mTelephonyEvents;
    private SparseArray<InProgressCallSession> mInProgressCallSessions;
    private Deque<TelephonyProto.TelephonyCallSession> mCompletedCallSessions;
    private SparseArray<InProgressSmsSession> mInProgressSmsSessions;
    private Deque<TelephonyProto.SmsSession> mCompletedSmsSessions;
    private SparseArray<TelephonyProto.TelephonyServiceState> mLastServiceState;
    private SparseArray<TelephonyProto.ImsCapabilities> mLastImsCapabilities;
    private SparseArray<TelephonyProto.ImsConnectionState> mLastImsConnectionState;
    private SparseArray<TelephonyProto.TelephonySettings> mLastSettings;
    private long mStartSystemTimeMs;
    private long mStartElapsedTimeMs;
    private boolean mTelephonyEventsDropped;

    private void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$__constructor__() {
        this.mTelephonyEvents = new ArrayDeque<TelephonyProto.TelephonyEvent>();
        this.mInProgressCallSessions = new SparseArray();
        this.mCompletedCallSessions = new ArrayDeque<TelephonyProto.TelephonyCallSession>();
        this.mInProgressSmsSessions = new SparseArray();
        this.mCompletedSmsSessions = new ArrayDeque<TelephonyProto.SmsSession>();
        this.mLastServiceState = new SparseArray();
        this.mLastImsCapabilities = new SparseArray();
        this.mLastImsConnectionState = new SparseArray();
        this.mLastSettings = new SparseArray();
        this.mTelephonyEventsDropped = false;
        this.reset();
    }

    private static final synchronized TelephonyMetrics $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$getInstance() {
        if (sInstance == null) {
            sInstance = new TelephonyMetrics();
        }
        return sInstance;
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (args != null && args.length > 0) {
            switch (args[0]) {
                case "--metrics": {
                    this.printAllMetrics(pw);
                    break;
                }
                case "--metricsproto": {
                    pw.println(TelephonyMetrics.convertProtoToBase64String(this.buildProto()));
                    this.reset();
                }
            }
        }
    }

    private static final String $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$telephonyEventToString(int event) {
        switch (event) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "SETTINGS_CHANGED";
            }
            case 2: {
                return "RIL_SERVICE_STATE_CHANGED";
            }
            case 3: {
                return "IMS_CONNECTION_STATE_CHANGED";
            }
            case 4: {
                return "IMS_CAPABILITIES_CHANGED";
            }
            case 5: {
                return "DATA_CALL_SETUP";
            }
            case 6: {
                return "DATA_CALL_SETUP_RESPONSE";
            }
            case 7: {
                return "DATA_CALL_LIST_CHANGED";
            }
            case 8: {
                return "DATA_CALL_DEACTIVATE";
            }
            case 9: {
                return "DATA_CALL_DEACTIVATE_RESPONSE";
            }
            case 10: {
                return "DATA_STALL_ACTION";
            }
            case 11: {
                return "MODEM_RESTART";
            }
            case 13: {
                return "CARRIER_ID_MATCHING";
            }
        }
        return Integer.toString(event);
    }

    private static final String $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$callSessionEventToString(int event) {
        switch (event) {
            case 0: {
                return "EVENT_UNKNOWN";
            }
            case 1: {
                return "SETTINGS_CHANGED";
            }
            case 2: {
                return "RIL_SERVICE_STATE_CHANGED";
            }
            case 3: {
                return "IMS_CONNECTION_STATE_CHANGED";
            }
            case 4: {
                return "IMS_CAPABILITIES_CHANGED";
            }
            case 5: {
                return "DATA_CALL_LIST_CHANGED";
            }
            case 6: {
                return "RIL_REQUEST";
            }
            case 7: {
                return "RIL_RESPONSE";
            }
            case 8: {
                return "RIL_CALL_RING";
            }
            case 9: {
                return "RIL_CALL_SRVCC";
            }
            case 10: {
                return "RIL_CALL_LIST_CHANGED";
            }
            case 11: {
                return "IMS_COMMAND";
            }
            case 12: {
                return "IMS_COMMAND_RECEIVED";
            }
            case 13: {
                return "IMS_COMMAND_FAILED";
            }
            case 14: {
                return "IMS_COMMAND_COMPLETE";
            }
            case 15: {
                return "IMS_CALL_RECEIVE";
            }
            case 16: {
                return "IMS_CALL_STATE_CHANGED";
            }
            case 17: {
                return "IMS_CALL_TERMINATED";
            }
            case 18: {
                return "IMS_CALL_HANDOVER";
            }
            case 19: {
                return "IMS_CALL_HANDOVER_FAILED";
            }
            case 20: {
                return "PHONE_STATE_CHANGED";
            }
            case 21: {
                return "NITZ_TIME";
            }
        }
        return Integer.toString(event);
    }

    private static final String $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$smsSessionEventToString(int event) {
        switch (event) {
            case 0: {
                return "EVENT_UNKNOWN";
            }
            case 1: {
                return "SETTINGS_CHANGED";
            }
            case 2: {
                return "RIL_SERVICE_STATE_CHANGED";
            }
            case 3: {
                return "IMS_CONNECTION_STATE_CHANGED";
            }
            case 4: {
                return "IMS_CAPABILITIES_CHANGED";
            }
            case 5: {
                return "DATA_CALL_LIST_CHANGED";
            }
            case 6: {
                return "SMS_SEND";
            }
            case 7: {
                return "SMS_SEND_RESULT";
            }
            case 8: {
                return "SMS_RECEIVED";
            }
        }
        return Integer.toString(event);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$printAllMetrics(PrintWriter rawWriter) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)rawWriter, "  ");
        pw.println("Telephony metrics proto:");
        pw.println("------------------------------------------");
        pw.println("Telephony events:");
        pw.increaseIndent();
        for (TelephonyProto.TelephonyEvent telephonyEvent : this.mTelephonyEvents) {
            pw.print(telephonyEvent.timestampMillis);
            pw.print(" [");
            pw.print(telephonyEvent.phoneId);
            pw.print("] ");
            pw.print("T=");
            if (telephonyEvent.type == 2) {
                pw.print(TelephonyMetrics.telephonyEventToString(telephonyEvent.type) + "(" + telephonyEvent.serviceState.dataRat + ")");
            } else {
                pw.print(TelephonyMetrics.telephonyEventToString(telephonyEvent.type));
            }
            pw.println("");
        }
        pw.decreaseIndent();
        pw.println("Call sessions:");
        pw.increaseIndent();
        for (TelephonyProto.TelephonyCallSession telephonyCallSession : this.mCompletedCallSessions) {
            pw.println("Start time in minutes: " + telephonyCallSession.startTimeMinutes);
            pw.println("Events dropped: " + telephonyCallSession.eventsDropped);
            pw.println("Events: ");
            pw.increaseIndent();
            for (TelephonyProto.TelephonyCallSession.Event event : telephonyCallSession.events) {
                pw.print(event.delay);
                pw.print(" T=");
                if (event.type == 2) {
                    pw.println(TelephonyMetrics.callSessionEventToString(event.type) + "(" + event.serviceState.dataRat + ")");
                    continue;
                }
                if (event.type == 10) {
                    pw.println(TelephonyMetrics.callSessionEventToString(event.type));
                    pw.increaseIndent();
                    for (TelephonyProto.TelephonyCallSession.Event.RilCall call : event.calls) {
                        pw.println(call.index + ". Type = " + call.type + " State = " + call.state + " End Reason " + call.callEndReason + " isMultiparty = " + call.isMultiparty);
                    }
                    pw.decreaseIndent();
                    continue;
                }
                pw.println(TelephonyMetrics.callSessionEventToString(event.type));
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Sms sessions:");
        pw.increaseIndent();
        int count = 0;
        for (TelephonyProto.SmsSession smsSession : this.mCompletedSmsSessions) {
            pw.print("[" + ++count + "] Start time in minutes: " + smsSession.startTimeMinutes);
            if (smsSession.eventsDropped) {
                pw.println(", events dropped: " + smsSession.eventsDropped);
            }
            pw.println("Events: ");
            pw.increaseIndent();
            for (TelephonyProto.SmsSession.Event event : smsSession.events) {
                pw.print(event.delay);
                pw.print(" T=");
                pw.println(TelephonyMetrics.smsSessionEventToString(event.type));
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Modem power stats:");
        pw.increaseIndent();
        TelephonyProto.ModemPowerStats modemPowerStats = new ModemPowerMetrics().buildProto();
        pw.println("Power log duration (battery time) (ms): " + modemPowerStats.loggingDurationMs);
        pw.println("Energy consumed by modem (mAh): " + modemPowerStats.energyConsumedMah);
        pw.println("Number of packets sent (tx): " + modemPowerStats.numPacketsTx);
        pw.println("Amount of time kernel is active because of cellular data (ms): " + modemPowerStats.cellularKernelActiveTimeMs);
        pw.println("Amount of time spent in very poor rx signal level (ms): " + modemPowerStats.timeInVeryPoorRxSignalLevelMs);
        pw.println("Amount of time modem is in sleep (ms): " + modemPowerStats.sleepTimeMs);
        pw.println("Amount of time modem is in idle (ms): " + modemPowerStats.idleTimeMs);
        pw.println("Amount of time modem is in rx (ms): " + modemPowerStats.rxTimeMs);
        pw.println("Amount of time modem is in tx (ms): " + Arrays.toString(modemPowerStats.txTimeMs));
        pw.decreaseIndent();
    }

    private static final String $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$convertProtoToBase64String(TelephonyProto.TelephonyLog proto) {
        return Base64.encodeToString(TelephonyProto.TelephonyLog.toByteArray(proto), 0);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$reset() {
        TelephonyProto.TelephonyEvent event;
        int key;
        int i;
        this.mTelephonyEvents.clear();
        this.mCompletedCallSessions.clear();
        this.mCompletedSmsSessions.clear();
        this.mTelephonyEventsDropped = false;
        this.mStartSystemTimeMs = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mStartElapsedTimeMs = SystemClock.elapsedRealtime();
        for (i = 0; i < this.mLastServiceState.size(); ++i) {
            key = this.mLastServiceState.keyAt(i);
            event = new TelephonyEventBuilder(this.mStartElapsedTimeMs, key).setServiceState(this.mLastServiceState.get(key)).build();
            this.addTelephonyEvent(event);
        }
        for (i = 0; i < this.mLastImsCapabilities.size(); ++i) {
            key = this.mLastImsCapabilities.keyAt(i);
            event = new TelephonyEventBuilder(this.mStartElapsedTimeMs, key).setImsCapabilities(this.mLastImsCapabilities.get(key)).build();
            this.addTelephonyEvent(event);
        }
        for (i = 0; i < this.mLastImsConnectionState.size(); ++i) {
            key = this.mLastImsConnectionState.keyAt(i);
            event = new TelephonyEventBuilder(this.mStartElapsedTimeMs, key).setImsConnectionState(this.mLastImsConnectionState.get(key)).build();
            this.addTelephonyEvent(event);
        }
    }

    private final synchronized TelephonyProto.TelephonyLog $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$buildProto() {
        TelephonyProto.TelephonyLog log = new TelephonyProto.TelephonyLog();
        log.events = new TelephonyProto.TelephonyEvent[this.mTelephonyEvents.size()];
        this.mTelephonyEvents.toArray(log.events);
        log.eventsDropped = this.mTelephonyEventsDropped;
        log.callSessions = new TelephonyProto.TelephonyCallSession[this.mCompletedCallSessions.size()];
        this.mCompletedCallSessions.toArray(log.callSessions);
        log.smsSessions = new TelephonyProto.SmsSession[this.mCompletedSmsSessions.size()];
        this.mCompletedSmsSessions.toArray(log.smsSessions);
        List<TelephonyHistogram> rilHistograms = RIL.getTelephonyRILTimingHistograms();
        log.histograms = new TelephonyProto.TelephonyHistogram[rilHistograms.size()];
        for (int i = 0; i < rilHistograms.size(); ++i) {
            log.histograms[i] = new TelephonyProto.TelephonyHistogram();
            TelephonyHistogram rilHistogram = rilHistograms.get(i);
            TelephonyProto.TelephonyHistogram histogramProto = log.histograms[i];
            histogramProto.category = rilHistogram.getCategory();
            histogramProto.id = rilHistogram.getId();
            histogramProto.minTimeMillis = rilHistogram.getMinTime();
            histogramProto.maxTimeMillis = rilHistogram.getMaxTime();
            histogramProto.avgTimeMillis = rilHistogram.getAverageTime();
            histogramProto.count = rilHistogram.getSampleCount();
            histogramProto.bucketCount = rilHistogram.getBucketCount();
            histogramProto.bucketEndPoints = rilHistogram.getBucketEndPoints();
            histogramProto.bucketCounters = rilHistogram.getBucketCounters();
        }
        log.modemPowerStats = new ModemPowerMetrics().buildProto();
        log.startTime = new TelephonyProto.Time();
        log.startTime.systemTimestampMillis = this.mStartSystemTimeMs;
        log.startTime.elapsedTimestampMillis = this.mStartElapsedTimeMs;
        log.endTime = new TelephonyProto.Time();
        log.endTime.systemTimestampMillis = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        log.endTime.elapsedTimestampMillis = SystemClock.elapsedRealtime();
        return log;
    }

    private static final int $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$roundSessionStart(long timestamp) {
        return (int)(timestamp / 300000L * 5L);
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeCarrierKeyEvent(int phoneId, int keyType, boolean isDownloadSuccessful) {
        TelephonyProto.TelephonyEvent.CarrierKeyChange carrierKeyChange = new TelephonyProto.TelephonyEvent.CarrierKeyChange();
        carrierKeyChange.keyType = keyType;
        carrierKeyChange.isDownloadSuccessful = isDownloadSuccessful;
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setCarrierKeyChange(carrierKeyChange).build();
        this.addTelephonyEvent(event);
    }

    private static final int $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toPrivacyFuzzedTimeInterval(long previousTimestamp, long currentTimestamp) {
        long diff = currentTimestamp - previousTimestamp;
        if (diff < 0L) {
            return 0;
        }
        if (diff <= 10L) {
            return 1;
        }
        if (diff <= 20L) {
            return 2;
        }
        if (diff <= 50L) {
            return 3;
        }
        if (diff <= 100L) {
            return 4;
        }
        if (diff <= 200L) {
            return 5;
        }
        if (diff <= 500L) {
            return 6;
        }
        if (diff <= 1000L) {
            return 7;
        }
        if (diff <= 2000L) {
            return 8;
        }
        if (diff <= 5000L) {
            return 9;
        }
        if (diff <= 10000L) {
            return 10;
        }
        if (diff <= 30000L) {
            return 11;
        }
        if (diff <= 60000L) {
            return 12;
        }
        if (diff <= 180000L) {
            return 13;
        }
        if (diff <= 600000L) {
            return 14;
        }
        if (diff <= 1800000L) {
            return 15;
        }
        if (diff <= 3600000L) {
            return 16;
        }
        if (diff <= 0x6DDD00L) {
            return 17;
        }
        if (diff <= 14400000L) {
            return 18;
        }
        return 19;
    }

    private final TelephonyProto.TelephonyServiceState $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toServiceStateProto(ServiceState serviceState) {
        TelephonyProto.TelephonyServiceState ssProto = new TelephonyProto.TelephonyServiceState();
        ssProto.voiceRoamingType = serviceState.getVoiceRoamingType();
        ssProto.dataRoamingType = serviceState.getDataRoamingType();
        ssProto.voiceOperator = new TelephonyProto.TelephonyServiceState.TelephonyOperator();
        if (serviceState.getVoiceOperatorAlphaLong() != null) {
            ssProto.voiceOperator.alphaLong = serviceState.getVoiceOperatorAlphaLong();
        }
        if (serviceState.getVoiceOperatorAlphaShort() != null) {
            ssProto.voiceOperator.alphaShort = serviceState.getVoiceOperatorAlphaShort();
        }
        if (serviceState.getVoiceOperatorNumeric() != null) {
            ssProto.voiceOperator.numeric = serviceState.getVoiceOperatorNumeric();
        }
        ssProto.dataOperator = new TelephonyProto.TelephonyServiceState.TelephonyOperator();
        if (serviceState.getDataOperatorAlphaLong() != null) {
            ssProto.dataOperator.alphaLong = serviceState.getDataOperatorAlphaLong();
        }
        if (serviceState.getDataOperatorAlphaShort() != null) {
            ssProto.dataOperator.alphaShort = serviceState.getDataOperatorAlphaShort();
        }
        if (serviceState.getDataOperatorNumeric() != null) {
            ssProto.dataOperator.numeric = serviceState.getDataOperatorNumeric();
        }
        ssProto.voiceRat = serviceState.getRilVoiceRadioTechnology();
        ssProto.dataRat = serviceState.getRilDataRadioTechnology();
        return ssProto;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$annotateInProgressCallSession(long timestamp, int phoneId, CallSessionEventBuilder eventBuilder) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession != null) {
            callSession.addEvent(timestamp, eventBuilder);
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$annotateInProgressSmsSession(long timestamp, int phoneId, SmsSessionEventBuilder eventBuilder) {
        InProgressSmsSession smsSession = this.mInProgressSmsSessions.get(phoneId);
        if (smsSession != null) {
            smsSession.addEvent(timestamp, eventBuilder);
        }
    }

    private final synchronized InProgressCallSession $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$startNewCallSessionIfNeeded(int phoneId) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            TelephonyProto.ImsConnectionState imsConnectionState;
            TelephonyProto.ImsCapabilities imsCapabilities;
            callSession = new InProgressCallSession(phoneId);
            this.mInProgressCallSessions.append(phoneId, callSession);
            TelephonyProto.TelephonyServiceState serviceState = this.mLastServiceState.get(phoneId);
            if (serviceState != null) {
                callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(2).setServiceState(serviceState));
            }
            if ((imsCapabilities = this.mLastImsCapabilities.get(phoneId)) != null) {
                callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(4).setImsCapabilities(imsCapabilities));
            }
            if ((imsConnectionState = this.mLastImsConnectionState.get(phoneId)) != null) {
                callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(3).setImsConnectionState(imsConnectionState));
            }
        }
        return callSession;
    }

    private final synchronized InProgressSmsSession $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$startNewSmsSessionIfNeeded(int phoneId) {
        InProgressSmsSession smsSession = this.mInProgressSmsSessions.get(phoneId);
        if (smsSession == null) {
            TelephonyProto.ImsConnectionState imsConnectionState;
            TelephonyProto.ImsCapabilities imsCapabilities;
            smsSession = new InProgressSmsSession(phoneId);
            this.mInProgressSmsSessions.append(phoneId, smsSession);
            TelephonyProto.TelephonyServiceState serviceState = this.mLastServiceState.get(phoneId);
            if (serviceState != null) {
                smsSession.addEvent(smsSession.startElapsedTimeMs, new SmsSessionEventBuilder(2).setServiceState(serviceState));
            }
            if ((imsCapabilities = this.mLastImsCapabilities.get(phoneId)) != null) {
                smsSession.addEvent(smsSession.startElapsedTimeMs, new SmsSessionEventBuilder(4).setImsCapabilities(imsCapabilities));
            }
            if ((imsConnectionState = this.mLastImsConnectionState.get(phoneId)) != null) {
                smsSession.addEvent(smsSession.startElapsedTimeMs, new SmsSessionEventBuilder(3).setImsConnectionState(imsConnectionState));
            }
        }
        return smsSession;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$finishCallSession(InProgressCallSession inProgressCallSession) {
        TelephonyProto.TelephonyCallSession callSession = new TelephonyProto.TelephonyCallSession();
        callSession.events = new TelephonyProto.TelephonyCallSession.Event[inProgressCallSession.events.size()];
        inProgressCallSession.events.toArray(callSession.events);
        callSession.startTimeMinutes = inProgressCallSession.startSystemTimeMin;
        callSession.phoneId = inProgressCallSession.phoneId;
        callSession.eventsDropped = inProgressCallSession.isEventsDropped();
        if (this.mCompletedCallSessions.size() >= 50) {
            this.mCompletedCallSessions.removeFirst();
        }
        this.mCompletedCallSessions.add(callSession);
        this.mInProgressCallSessions.remove(inProgressCallSession.phoneId);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$finishSmsSessionIfNeeded(InProgressSmsSession inProgressSmsSession) {
        if (inProgressSmsSession.getNumExpectedResponses() == 0) {
            TelephonyProto.SmsSession smsSession = new TelephonyProto.SmsSession();
            smsSession.events = new TelephonyProto.SmsSession.Event[inProgressSmsSession.events.size()];
            inProgressSmsSession.events.toArray(smsSession.events);
            smsSession.startTimeMinutes = inProgressSmsSession.startSystemTimeMin;
            smsSession.phoneId = inProgressSmsSession.phoneId;
            smsSession.eventsDropped = inProgressSmsSession.isEventsDropped();
            if (this.mCompletedSmsSessions.size() >= 500) {
                this.mCompletedSmsSessions.removeFirst();
            }
            this.mCompletedSmsSessions.add(smsSession);
            this.mInProgressSmsSessions.remove(inProgressSmsSession.phoneId);
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$addTelephonyEvent(TelephonyProto.TelephonyEvent event) {
        if (this.mTelephonyEvents.size() >= 1000) {
            this.mTelephonyEvents.removeFirst();
            this.mTelephonyEventsDropped = true;
        }
        this.mTelephonyEvents.add(event);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeServiceStateChanged(int phoneId, ServiceState serviceState) {
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setServiceState(this.toServiceStateProto(serviceState)).build();
        if (this.mLastServiceState.get(phoneId) != null && Arrays.equals(TelephonyProto.TelephonyServiceState.toByteArray(this.mLastServiceState.get(phoneId)), TelephonyProto.TelephonyServiceState.toByteArray(event.serviceState))) {
            return;
        }
        this.mLastServiceState.put(phoneId, event.serviceState);
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(2).setServiceState(event.serviceState));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(2).setServiceState(event.serviceState));
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeDataStallEvent(int phoneId, int recoveryAction) {
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDataStallRecoveryAction(recoveryAction).build());
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeImsSetFeatureValue(int phoneId, int feature, int network, int value) {
        TelephonyProto.TelephonySettings s = new TelephonyProto.TelephonySettings();
        if (network == 0) {
            switch (feature) {
                case 1: {
                    s.isEnhanced4GLteModeEnabled = value != 0;
                    break;
                }
                case 2: {
                    s.isVtOverLteEnabled = value != 0;
                }
            }
        } else if (network == 1) {
            switch (feature) {
                case 1: {
                    s.isWifiCallingEnabled = value != 0;
                    break;
                }
                case 2: {
                    boolean bl = s.isVtOverWifiEnabled = value != 0;
                }
            }
        }
        if (this.mLastSettings.get(phoneId) != null && Arrays.equals(TelephonyProto.TelephonySettings.toByteArray(this.mLastSettings.get(phoneId)), TelephonyProto.TelephonySettings.toByteArray(s))) {
            return;
        }
        this.mLastSettings.put(phoneId, s);
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setSettings(s).build();
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(1).setSettings(s));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(1).setSettings(s));
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeSetPreferredNetworkType(int phoneId, int networkType) {
        TelephonyProto.TelephonySettings s = new TelephonyProto.TelephonySettings();
        s.preferredNetworkMode = networkType + 1;
        if (this.mLastSettings.get(phoneId) != null && Arrays.equals(TelephonyProto.TelephonySettings.toByteArray(this.mLastSettings.get(phoneId)), TelephonyProto.TelephonySettings.toByteArray(s))) {
            return;
        }
        this.mLastSettings.put(phoneId, s);
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setSettings(s).build());
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsConnectionState(int phoneId, int state, ImsReasonInfo reasonInfo) {
        TelephonyProto.ImsConnectionState imsState = new TelephonyProto.ImsConnectionState();
        imsState.state = state;
        if (reasonInfo != null) {
            TelephonyProto.ImsReasonInfo ri = new TelephonyProto.ImsReasonInfo();
            ri.reasonCode = reasonInfo.getCode();
            ri.extraCode = reasonInfo.getExtraCode();
            String extraMessage = reasonInfo.getExtraMessage();
            if (extraMessage != null) {
                ri.extraMessage = extraMessage;
            }
            imsState.reasonInfo = ri;
        }
        if (this.mLastImsConnectionState.get(phoneId) != null && Arrays.equals(TelephonyProto.ImsConnectionState.toByteArray(this.mLastImsConnectionState.get(phoneId)), TelephonyProto.ImsConnectionState.toByteArray(imsState))) {
            return;
        }
        this.mLastImsConnectionState.put(phoneId, imsState);
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setImsConnectionState(imsState).build();
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(3).setImsConnectionState(event.imsConnectionState));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(3).setImsConnectionState(event.imsConnectionState));
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCapabilities(int phoneId, int radioTech, MmTelFeature.MmTelCapabilities capabilities) {
        TelephonyProto.ImsCapabilities cap = new TelephonyProto.ImsCapabilities();
        if (radioTech == 0) {
            cap.voiceOverLte = capabilities.isCapable(1);
            cap.videoOverLte = capabilities.isCapable(2);
            cap.utOverLte = capabilities.isCapable(4);
        } else if (radioTech == 1) {
            cap.voiceOverWifi = capabilities.isCapable(1);
            cap.videoOverWifi = capabilities.isCapable(2);
            cap.utOverWifi = capabilities.isCapable(4);
        }
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setImsCapabilities(cap).build();
        if (this.mLastImsCapabilities.get(phoneId) != null && Arrays.equals(TelephonyProto.ImsCapabilities.toByteArray(this.mLastImsCapabilities.get(phoneId)), TelephonyProto.ImsCapabilities.toByteArray(cap))) {
            return;
        }
        this.mLastImsCapabilities.put(phoneId, cap);
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(4).setImsCapabilities(event.imsCapabilities));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(4).setImsCapabilities(event.imsCapabilities));
    }

    private final int $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toPdpType(String type) {
        switch (type) {
            case "IP": {
                return 1;
            }
            case "IPV6": {
                return 2;
            }
            case "IPV4V6": {
                return 3;
            }
            case "PPP": {
                return 4;
            }
        }
        Rlog.e(TAG, "Unknown type: " + type);
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeSetupDataCall(int phoneId, int radioTechnology, int profileId, String apn, String protocol) {
        TelephonyProto.TelephonyEvent.RilSetupDataCall setupDataCall = new TelephonyProto.TelephonyEvent.RilSetupDataCall();
        setupDataCall.rat = radioTechnology;
        setupDataCall.dataProfile = profileId + 1;
        if (apn != null) {
            setupDataCall.apn = apn;
        }
        if (protocol != null) {
            setupDataCall.type = this.toPdpType(protocol);
        }
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setSetupDataCall(setupDataCall).build());
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilDeactivateDataCall(int phoneId, int rilSerial, int cid, int reason) {
        TelephonyProto.TelephonyEvent.RilDeactivateDataCall deactivateDataCall = new TelephonyProto.TelephonyEvent.RilDeactivateDataCall();
        deactivateDataCall.cid = cid;
        switch (reason) {
            case 1: {
                deactivateDataCall.reason = 1;
                break;
            }
            case 2: {
                deactivateDataCall.reason = 2;
                break;
            }
            case 3: {
                deactivateDataCall.reason = 4;
                break;
            }
            default: {
                deactivateDataCall.reason = 0;
            }
        }
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDeactivateDataCall(deactivateDataCall).build());
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilDataCallList(int phoneId, ArrayList<DataCallResponse> dcsList) {
        TelephonyProto.RilDataCall[] dataCalls = new TelephonyProto.RilDataCall[dcsList.size()];
        for (int i = 0; i < dcsList.size(); ++i) {
            dataCalls[i] = new TelephonyProto.RilDataCall();
            dataCalls[i].cid = dcsList.get(i).getCallId();
            if (!TextUtils.isEmpty(dcsList.get(i).getIfname())) {
                dataCalls[i].iframe = dcsList.get(i).getIfname();
            }
            if (TextUtils.isEmpty(dcsList.get(i).getType())) continue;
            dataCalls[i].type = this.toPdpType(dcsList.get(i).getType());
        }
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDataCalls(dataCalls).build());
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilCallList(int phoneId, ArrayList<GsmCdmaConnection> connections) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilCallList: Call session is missing");
        } else {
            TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = this.convertConnectionsToRilCalls(connections);
            callSession.addEvent(new CallSessionEventBuilder(10).setRilCalls(calls));
            if (callSession.isPhoneIdle() && this.disconnectReasonsKnown(calls)) {
                this.finishCallSession(callSession);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$disconnectReasonsKnown(TelephonyProto.TelephonyCallSession.Event.RilCall[] calls) {
        for (TelephonyProto.TelephonyCallSession.Event.RilCall call : calls) {
            if (call.callEndReason != 0) continue;
            return false;
        }
        return true;
    }

    private final TelephonyProto.TelephonyCallSession.Event.RilCall[] $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$convertConnectionsToRilCalls(ArrayList<GsmCdmaConnection> mConnections) {
        TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = new TelephonyProto.TelephonyCallSession.Event.RilCall[mConnections.size()];
        for (int i = 0; i < mConnections.size(); ++i) {
            calls[i] = new TelephonyProto.TelephonyCallSession.Event.RilCall();
            calls[i].index = i;
            this.convertConnectionToRilCall(mConnections.get(i), calls[i]);
        }
        return calls;
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$convertConnectionToRilCall(GsmCdmaConnection conn, TelephonyProto.TelephonyCallSession.Event.RilCall call) {
        call.type = conn.isIncoming() ? 2 : 1;
        switch (1.$SwitchMap$com$android$internal$telephony$Call$State[conn.getState().ordinal()]) {
            case 1: {
                call.state = 1;
                break;
            }
            case 2: {
                call.state = 2;
                break;
            }
            case 3: {
                call.state = 3;
                break;
            }
            case 4: {
                call.state = 4;
                break;
            }
            case 5: {
                call.state = 5;
                break;
            }
            case 6: {
                call.state = 6;
                break;
            }
            case 7: {
                call.state = 7;
                break;
            }
            case 8: {
                call.state = 8;
                break;
            }
            case 9: {
                call.state = 9;
                break;
            }
            default: {
                call.state = 0;
            }
        }
        call.callEndReason = conn.getDisconnectCause();
        call.isMultiparty = conn.isMultiparty();
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilDial(int phoneId, GsmCdmaConnection conn, int clirMode, UUSInfo uusInfo) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilDial: Call session is missing");
        } else {
            TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = new TelephonyProto.TelephonyCallSession.Event.RilCall[]{new TelephonyProto.TelephonyCallSession.Event.RilCall()};
            calls[0].index = -1;
            this.convertConnectionToRilCall(conn, calls[0]);
            callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(6).setRilRequest(1).setRilCalls(calls));
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilCallRing(int phoneId, char[] response) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(8));
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilHangup(int phoneId, GsmCdmaConnection conn, int callId) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilHangup: Call session is missing");
        } else {
            TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = new TelephonyProto.TelephonyCallSession.Event.RilCall[]{new TelephonyProto.TelephonyCallSession.Event.RilCall()};
            calls[0].index = callId;
            this.convertConnectionToRilCall(conn, calls[0]);
            callSession.addEvent(new CallSessionEventBuilder(6).setRilRequest(3).setRilCalls(calls));
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilAnswer(int phoneId, int rilSerial) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilAnswer: Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(6).setRilRequest(2).setRilRequestId(rilSerial));
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilSrvcc(int phoneId, int rilSrvccState) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilSrvcc: Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(9).setSrvccState(rilSrvccState + 1));
        }
    }

    private final int $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toCallSessionRilRequest(int r) {
        switch (r) {
            case 10: {
                return 1;
            }
            case 40: {
                return 2;
            }
            case 12: 
            case 13: 
            case 14: {
                return 3;
            }
            case 36: {
                return 4;
            }
            case 15: {
                return 5;
            }
            case 84: {
                return 6;
            }
            case 16: {
                return 7;
            }
        }
        Rlog.e(TAG, "Unknown RIL request: " + r);
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnSetupDataCallResponse(int phoneId, int rilSerial, int rilError, int rilRequest, SetupDataCallResult result) {
        TelephonyProto.TelephonyEvent.RilSetupDataCallResponse setupDataCallResponse = new TelephonyProto.TelephonyEvent.RilSetupDataCallResponse();
        TelephonyProto.RilDataCall dataCall = new TelephonyProto.RilDataCall();
        if (result != null) {
            setupDataCallResponse.status = result.status == 0 ? 1 : result.status;
            setupDataCallResponse.suggestedRetryTimeMillis = result.suggestedRetryTime;
            dataCall.cid = result.cid;
            if (!TextUtils.isEmpty(result.type)) {
                dataCall.type = this.toPdpType(result.type);
            }
            if (!TextUtils.isEmpty(result.ifname)) {
                dataCall.iframe = result.ifname;
            }
        }
        setupDataCallResponse.call = dataCall;
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setSetupDataCallResponse(setupDataCallResponse).build());
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnCallSolicitedResponse(int phoneId, int rilSerial, int rilError, int rilRequest) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeOnCallSolicitedResponse: Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(7).setRilRequest(this.toCallSessionRilRequest(rilRequest)).setRilRequestId(rilSerial).setRilError(rilError + 1));
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnSmsSolicitedResponse(int phoneId, int rilSerial, int rilError, SmsResponse response) {
        InProgressSmsSession smsSession = this.mInProgressSmsSessions.get(phoneId);
        if (smsSession == null) {
            Rlog.e(TAG, "SMS session is missing");
        } else {
            int errorCode = 0;
            if (response != null) {
                errorCode = response.mErrorCode;
            }
            smsSession.addEvent(new SmsSessionEventBuilder(7).setErrorCode(errorCode).setRilErrno(rilError + 1).setRilRequestId(rilSerial));
            smsSession.decreaseExpectedResponse();
            this.finishSmsSessionIfNeeded(smsSession);
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnDeactivateDataCallResponse(int phoneId, int rilError) {
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDeactivateDataCallResponse(rilError + 1).build());
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnRilSolicitedResponse(int phoneId, int rilSerial, int rilError, int rilRequest, Object ret) {
        switch (rilRequest) {
            case 27: {
                SetupDataCallResult result = (SetupDataCallResult)ret;
                this.writeOnSetupDataCallResponse(phoneId, rilSerial, rilError, rilRequest, result);
                break;
            }
            case 41: {
                this.writeOnDeactivateDataCallResponse(phoneId, rilError);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 40: {
                this.writeOnCallSolicitedResponse(phoneId, rilSerial, rilError, rilRequest);
                break;
            }
            case 25: 
            case 26: 
            case 87: 
            case 113: {
                SmsResponse smsResponse = (SmsResponse)ret;
                this.writeOnSmsSolicitedResponse(phoneId, rilSerial, rilError, smsResponse);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writePhoneState(int phoneId, PhoneConstants.State phoneState) {
        int state;
        switch (1.$SwitchMap$com$android$internal$telephony$PhoneConstants$State[phoneState.ordinal()]) {
            case 1: {
                state = 1;
                break;
            }
            case 2: {
                state = 2;
                break;
            }
            case 3: {
                state = 3;
                break;
            }
            default: {
                state = 0;
            }
        }
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writePhoneState: Call session is missing");
        } else {
            callSession.setLastKnownPhoneState(state);
            if (state == 1 && !callSession.containsCsCalls()) {
                this.finishCallSession(callSession);
            }
            callSession.addEvent(new CallSessionEventBuilder(20).setPhoneState(state));
        }
    }

    private final int $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$getCallId(ImsCallSession session) {
        if (session == null) {
            return -1;
        }
        try {
            return Integer.parseInt(session.getCallId());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeImsCallState(int phoneId, ImsCallSession session, Call.State callState) {
        int state;
        switch (1.$SwitchMap$com$android$internal$telephony$Call$State[callState.ordinal()]) {
            case 1: {
                state = 1;
                break;
            }
            case 2: {
                state = 2;
                break;
            }
            case 3: {
                state = 3;
                break;
            }
            case 4: {
                state = 4;
                break;
            }
            case 5: {
                state = 5;
                break;
            }
            case 6: {
                state = 6;
                break;
            }
            case 7: {
                state = 7;
                break;
            }
            case 8: {
                state = 8;
                break;
            }
            case 9: {
                state = 9;
                break;
            }
            default: {
                state = 0;
            }
        }
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(16).setCallIndex(this.getCallId(session)).setCallState(state));
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallStart(int phoneId, ImsCallSession session) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        callSession.addEvent(new CallSessionEventBuilder(11).setCallIndex(this.getCallId(session)).setImsCommand(1));
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallReceive(int phoneId, ImsCallSession session) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        callSession.addEvent(new CallSessionEventBuilder(15).setCallIndex(this.getCallId(session)));
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCommand(int phoneId, ImsCallSession session, int command) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(11).setCallIndex(this.getCallId(session)).setImsCommand(command));
        }
    }

    private final TelephonyProto.ImsReasonInfo $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toImsReasonInfoProto(ImsReasonInfo reasonInfo) {
        TelephonyProto.ImsReasonInfo ri = new TelephonyProto.ImsReasonInfo();
        if (reasonInfo != null) {
            ri.reasonCode = reasonInfo.getCode();
            ri.extraCode = reasonInfo.getExtraCode();
            String extraMessage = reasonInfo.getExtraMessage();
            if (extraMessage != null) {
                ri.extraMessage = extraMessage;
            }
        }
        return ri;
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallTerminated(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(17).setCallIndex(this.getCallId(session)).setImsReasonInfo(this.toImsReasonInfoProto(reasonInfo)));
        }
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHandoverEvent(int phoneId, int eventType, ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(eventType).setCallIndex(this.getCallId(session)).setSrcAccessTech(srcAccessTech).setTargetAccessTech(targetAccessTech).setImsReasonInfo(this.toImsReasonInfoProto(reasonInfo)));
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilSendSms(int phoneId, int rilSerial, int tech, int format) {
        InProgressSmsSession smsSession = this.startNewSmsSessionIfNeeded(phoneId);
        smsSession.addEvent(new SmsSessionEventBuilder(6).setTech(tech).setRilRequestId(rilSerial).setFormat(format));
        smsSession.increaseExpectedResponse();
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilNewSms(int phoneId, int tech, int format) {
        InProgressSmsSession smsSession = this.startNewSmsSessionIfNeeded(phoneId);
        smsSession.addEvent(new SmsSessionEventBuilder(8).setTech(tech).setFormat(format));
        this.finishSmsSessionIfNeeded(smsSession);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeNewCBSms(int phoneId, int format, int priority, boolean isCMAS, boolean isETWS, int serviceCategory) {
        InProgressSmsSession smsSession = this.startNewSmsSessionIfNeeded(phoneId);
        int type = isCMAS ? 2 : (isETWS ? 1 : 3);
        TelephonyProto.SmsSession.Event.CBMessage cbm = new TelephonyProto.SmsSession.Event.CBMessage();
        cbm.msgFormat = format;
        cbm.msgPriority = priority + 1;
        cbm.msgType = type;
        cbm.serviceCategory = serviceCategory;
        smsSession.addEvent(new SmsSessionEventBuilder(9).setCellBroadcastMessage(cbm));
        this.finishSmsSessionIfNeeded(smsSession);
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeNITZEvent(int phoneId, long timestamp) {
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setNITZ(timestamp).build();
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(21).setNITZ(timestamp));
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeModemRestartEvent(int phoneId, String reason) {
        TelephonyProto.TelephonyEvent.ModemRestart modemRestart = new TelephonyProto.TelephonyEvent.ModemRestart();
        String basebandVersion = Build.getRadioVersion();
        if (basebandVersion != null) {
            modemRestart.basebandVersion = basebandVersion;
        }
        if (reason != null) {
            modemRestart.reason = reason;
        }
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setModemRestart(modemRestart).build();
        this.addTelephonyEvent(event);
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeCarrierIdMatchingEvent(int phoneId, int version, int cid, String mccmnc, String gid1) {
        TelephonyProto.TelephonyEvent.CarrierIdMatching carrierIdMatching = new TelephonyProto.TelephonyEvent.CarrierIdMatching();
        TelephonyProto.TelephonyEvent.CarrierIdMatchingResult carrierIdMatchingResult = new TelephonyProto.TelephonyEvent.CarrierIdMatchingResult();
        if (cid != -1) {
            carrierIdMatchingResult.carrierId = cid;
            if (gid1 != null) {
                carrierIdMatchingResult.mccmnc = mccmnc;
                carrierIdMatchingResult.gid1 = gid1;
            }
        } else if (mccmnc != null) {
            carrierIdMatchingResult.mccmnc = mccmnc;
        }
        carrierIdMatching.cidTableVersion = version;
        carrierIdMatching.result = carrierIdMatchingResult;
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setCarrierIdMatching(carrierIdMatching).build();
        this.addTelephonyEvent(event);
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallProgressing(int phoneId, ImsCallSession session) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallStarted(int phoneId, ImsCallSession session) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallStartFailed(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHeld(int phoneId, ImsCallSession session) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHoldReceived(int phoneId, ImsCallSession session) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHoldFailed(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallResumed(int phoneId, ImsCallSession session) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallResumeReceived(int phoneId, ImsCallSession session) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallResumeFailed(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
    }

    private final void $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnRilTimeoutResponse(int phoneId, int rilSerial, int rilRequest) {
    }

    static void __staticInitializer__() {
        TAG = TelephonyMetrics.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$__constructor__();
    }

    public TelephonyMetrics() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$__constructor__(), this);
    }

    public static synchronized TelephonyMetrics getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$getInstance());
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    private static String telephonyEventToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("telephonyEventToString", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$telephonyEventToString(int ), (int)n);
    }

    private static String callSessionEventToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("callSessionEventToString", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$callSessionEventToString(int ), (int)n);
    }

    private static String smsSessionEventToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("smsSessionEventToString", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$smsSessionEventToString(int ), (int)n);
    }

    private synchronized void printAllMetrics(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("printAllMetrics", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$printAllMetrics(java.io.PrintWriter ), this, printWriter);
    }

    private static String convertProtoToBase64String(TelephonyProto.TelephonyLog telephonyLog) {
        return InvokeDynamicSupport.bootstrapStatic("convertProtoToBase64String", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$convertProtoToBase64String(com.android.internal.telephony.nano.TelephonyProto$TelephonyLog ), (TelephonyProto.TelephonyLog)telephonyLog);
    }

    private synchronized void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$reset(), this);
    }

    private synchronized TelephonyProto.TelephonyLog buildProto() {
        return InvokeDynamicSupport.bootstrap("buildProto", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$buildProto(), this);
    }

    static int roundSessionStart(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("roundSessionStart", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$roundSessionStart(long ), (long)l);
    }

    public void writeCarrierKeyEvent(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("writeCarrierKeyEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeCarrierKeyEvent(int int boolean ), this, n, n2, bl);
    }

    static int toPrivacyFuzzedTimeInterval(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toPrivacyFuzzedTimeInterval", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toPrivacyFuzzedTimeInterval(long long ), (long)l, (long)l2);
    }

    private TelephonyProto.TelephonyServiceState toServiceStateProto(ServiceState serviceState) {
        return InvokeDynamicSupport.bootstrap("toServiceStateProto", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toServiceStateProto(android.telephony.ServiceState ), this, serviceState);
    }

    private synchronized void annotateInProgressCallSession(long l, int n, CallSessionEventBuilder callSessionEventBuilder) {
        InvokeDynamicSupport.bootstrap("annotateInProgressCallSession", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$annotateInProgressCallSession(long int com.android.internal.telephony.metrics.CallSessionEventBuilder ), this, l, n, callSessionEventBuilder);
    }

    private synchronized void annotateInProgressSmsSession(long l, int n, SmsSessionEventBuilder smsSessionEventBuilder) {
        InvokeDynamicSupport.bootstrap("annotateInProgressSmsSession", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$annotateInProgressSmsSession(long int com.android.internal.telephony.metrics.SmsSessionEventBuilder ), this, l, n, smsSessionEventBuilder);
    }

    private synchronized InProgressCallSession startNewCallSessionIfNeeded(int n) {
        return InvokeDynamicSupport.bootstrap("startNewCallSessionIfNeeded", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$startNewCallSessionIfNeeded(int ), this, n);
    }

    private synchronized InProgressSmsSession startNewSmsSessionIfNeeded(int n) {
        return InvokeDynamicSupport.bootstrap("startNewSmsSessionIfNeeded", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$startNewSmsSessionIfNeeded(int ), this, n);
    }

    private synchronized void finishCallSession(InProgressCallSession inProgressCallSession) {
        InvokeDynamicSupport.bootstrap("finishCallSession", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$finishCallSession(com.android.internal.telephony.metrics.InProgressCallSession ), this, inProgressCallSession);
    }

    private synchronized void finishSmsSessionIfNeeded(InProgressSmsSession inProgressSmsSession) {
        InvokeDynamicSupport.bootstrap("finishSmsSessionIfNeeded", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$finishSmsSessionIfNeeded(com.android.internal.telephony.metrics.InProgressSmsSession ), this, inProgressSmsSession);
    }

    private synchronized void addTelephonyEvent(TelephonyProto.TelephonyEvent telephonyEvent) {
        InvokeDynamicSupport.bootstrap("addTelephonyEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$addTelephonyEvent(com.android.internal.telephony.nano.TelephonyProto$TelephonyEvent ), this, telephonyEvent);
    }

    public synchronized void writeServiceStateChanged(int n, ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("writeServiceStateChanged", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeServiceStateChanged(int android.telephony.ServiceState ), this, n, serviceState);
    }

    public void writeDataStallEvent(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeDataStallEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeDataStallEvent(int int ), this, n, n2);
    }

    public void writeImsSetFeatureValue(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("writeImsSetFeatureValue", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeImsSetFeatureValue(int int int int ), this, n, n2, n3, n4);
    }

    public void writeSetPreferredNetworkType(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeSetPreferredNetworkType", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeSetPreferredNetworkType(int int ), this, n, n2);
    }

    public synchronized void writeOnImsConnectionState(int n, int n2, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsConnectionState", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsConnectionState(int int android.telephony.ims.ImsReasonInfo ), this, n, n2, imsReasonInfo);
    }

    public synchronized void writeOnImsCapabilities(int n, int n2, MmTelFeature.MmTelCapabilities mmTelCapabilities) {
        InvokeDynamicSupport.bootstrap("writeOnImsCapabilities", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCapabilities(int int android.telephony.ims.feature.MmTelFeature$MmTelCapabilities ), this, n, n2, mmTelCapabilities);
    }

    private int toPdpType(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("toPdpType", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toPdpType(java.lang.String ), this, string2);
    }

    public void writeSetupDataCall(int n, int n2, int n3, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("writeSetupDataCall", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeSetupDataCall(int int int java.lang.String java.lang.String ), this, n, n2, n3, string2, string3);
    }

    public void writeRilDeactivateDataCall(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("writeRilDeactivateDataCall", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilDeactivateDataCall(int int int int ), this, n, n2, n3, n4);
    }

    public void writeRilDataCallList(int n, ArrayList<DataCallResponse> arrayList) {
        InvokeDynamicSupport.bootstrap("writeRilDataCallList", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilDataCallList(int java.util.ArrayList<android.telephony.data.DataCallResponse> ), this, n, arrayList);
    }

    public void writeRilCallList(int n, ArrayList<GsmCdmaConnection> arrayList) {
        InvokeDynamicSupport.bootstrap("writeRilCallList", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilCallList(int java.util.ArrayList<com.android.internal.telephony.GsmCdmaConnection> ), this, n, arrayList);
    }

    private boolean disconnectReasonsKnown(TelephonyProto.TelephonyCallSession.Event.RilCall[] rilCallArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnectReasonsKnown", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$disconnectReasonsKnown(com.android.internal.telephony.nano.TelephonyProto$TelephonyCallSession$Event$RilCall[] ), this, rilCallArray);
    }

    private TelephonyProto.TelephonyCallSession.Event.RilCall[] convertConnectionsToRilCalls(ArrayList<GsmCdmaConnection> arrayList) {
        return InvokeDynamicSupport.bootstrap("convertConnectionsToRilCalls", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$convertConnectionsToRilCalls(java.util.ArrayList<com.android.internal.telephony.GsmCdmaConnection> ), this, arrayList);
    }

    private void convertConnectionToRilCall(GsmCdmaConnection gsmCdmaConnection, TelephonyProto.TelephonyCallSession.Event.RilCall rilCall) {
        InvokeDynamicSupport.bootstrap("convertConnectionToRilCall", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$convertConnectionToRilCall(com.android.internal.telephony.GsmCdmaConnection com.android.internal.telephony.nano.TelephonyProto$TelephonyCallSession$Event$RilCall ), this, gsmCdmaConnection, rilCall);
    }

    public void writeRilDial(int n, GsmCdmaConnection gsmCdmaConnection, int n2, UUSInfo uUSInfo) {
        InvokeDynamicSupport.bootstrap("writeRilDial", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilDial(int com.android.internal.telephony.GsmCdmaConnection int com.android.internal.telephony.UUSInfo ), this, n, gsmCdmaConnection, n2, uUSInfo);
    }

    public void writeRilCallRing(int n, char[] cArray) {
        InvokeDynamicSupport.bootstrap("writeRilCallRing", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilCallRing(int char[] ), this, n, cArray);
    }

    public void writeRilHangup(int n, GsmCdmaConnection gsmCdmaConnection, int n2) {
        InvokeDynamicSupport.bootstrap("writeRilHangup", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilHangup(int com.android.internal.telephony.GsmCdmaConnection int ), this, n, gsmCdmaConnection, n2);
    }

    public void writeRilAnswer(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeRilAnswer", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilAnswer(int int ), this, n, n2);
    }

    public void writeRilSrvcc(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeRilSrvcc", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilSrvcc(int int ), this, n, n2);
    }

    private int toCallSessionRilRequest(int n) {
        return (int)InvokeDynamicSupport.bootstrap("toCallSessionRilRequest", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toCallSessionRilRequest(int ), this, n);
    }

    private void writeOnSetupDataCallResponse(int n, int n2, int n3, int n4, SetupDataCallResult setupDataCallResult) {
        InvokeDynamicSupport.bootstrap("writeOnSetupDataCallResponse", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnSetupDataCallResponse(int int int int android.hardware.radio.V1_0.SetupDataCallResult ), this, n, n2, n3, n4, setupDataCallResult);
    }

    private void writeOnCallSolicitedResponse(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("writeOnCallSolicitedResponse", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnCallSolicitedResponse(int int int int ), this, n, n2, n3, n4);
    }

    private synchronized void writeOnSmsSolicitedResponse(int n, int n2, int n3, SmsResponse smsResponse) {
        InvokeDynamicSupport.bootstrap("writeOnSmsSolicitedResponse", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnSmsSolicitedResponse(int int int com.android.internal.telephony.SmsResponse ), this, n, n2, n3, smsResponse);
    }

    private void writeOnDeactivateDataCallResponse(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeOnDeactivateDataCallResponse", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnDeactivateDataCallResponse(int int ), this, n, n2);
    }

    public void writeOnRilSolicitedResponse(int n, int n2, int n3, int n4, Object object) {
        InvokeDynamicSupport.bootstrap("writeOnRilSolicitedResponse", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnRilSolicitedResponse(int int int int java.lang.Object ), this, n, n2, n3, n4, object);
    }

    public void writePhoneState(int n, PhoneConstants.State state) {
        InvokeDynamicSupport.bootstrap("writePhoneState", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writePhoneState(int com.android.internal.telephony.PhoneConstants$State ), this, n, state);
    }

    private int getCallId(ImsCallSession imsCallSession) {
        return (int)InvokeDynamicSupport.bootstrap("getCallId", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$getCallId(android.telephony.ims.ImsCallSession ), this, imsCallSession);
    }

    public void writeImsCallState(int n, ImsCallSession imsCallSession, Call.State state) {
        InvokeDynamicSupport.bootstrap("writeImsCallState", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeImsCallState(int android.telephony.ims.ImsCallSession com.android.internal.telephony.Call$State ), this, n, imsCallSession, state);
    }

    public void writeOnImsCallStart(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStart", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallStart(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallReceive(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallReceive", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallReceive(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCommand(int n, ImsCallSession imsCallSession, int n2) {
        InvokeDynamicSupport.bootstrap("writeOnImsCommand", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCommand(int android.telephony.ims.ImsCallSession int ), this, n, imsCallSession, n2);
    }

    private TelephonyProto.ImsReasonInfo toImsReasonInfoProto(ImsReasonInfo imsReasonInfo) {
        return InvokeDynamicSupport.bootstrap("toImsReasonInfoProto", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$toImsReasonInfoProto(android.telephony.ims.ImsReasonInfo ), this, imsReasonInfo);
    }

    public void writeOnImsCallTerminated(int n, ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallTerminated", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallTerminated(int android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), this, n, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallHandoverEvent(int n, int n2, ImsCallSession imsCallSession, int n3, int n4, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHandoverEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHandoverEvent(int int android.telephony.ims.ImsCallSession int int android.telephony.ims.ImsReasonInfo ), this, n, n2, imsCallSession, n3, n4, imsReasonInfo);
    }

    public synchronized void writeRilSendSms(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("writeRilSendSms", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilSendSms(int int int int ), this, n, n2, n3, n4);
    }

    public synchronized void writeRilNewSms(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("writeRilNewSms", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeRilNewSms(int int int ), this, n, n2, n3);
    }

    public synchronized void writeNewCBSms(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        InvokeDynamicSupport.bootstrap("writeNewCBSms", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeNewCBSms(int int int boolean boolean int ), this, n, n2, n3, bl, bl2, n4);
    }

    public void writeNITZEvent(int n, long l) {
        InvokeDynamicSupport.bootstrap("writeNITZEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeNITZEvent(int long ), this, n, l);
    }

    public void writeModemRestartEvent(int n, String string2) {
        InvokeDynamicSupport.bootstrap("writeModemRestartEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeModemRestartEvent(int java.lang.String ), this, n, string2);
    }

    public void writeCarrierIdMatchingEvent(int n, int n2, int n3, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("writeCarrierIdMatchingEvent", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeCarrierIdMatchingEvent(int int int java.lang.String java.lang.String ), this, n, n2, n3, string2, string3);
    }

    public void writeOnImsCallProgressing(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallProgressing", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallProgressing(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallStarted(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStarted", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallStarted(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallStartFailed(int n, ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStartFailed", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallStartFailed(int android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), this, n, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallHeld(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHeld", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHeld(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallHoldReceived(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHoldReceived", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHoldReceived(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallHoldFailed(int n, ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHoldFailed", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallHoldFailed(int android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), this, n, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallResumed(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResumed", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallResumed(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallResumeReceived(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResumeReceived", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallResumeReceived(int android.telephony.ims.ImsCallSession ), this, n, imsCallSession);
    }

    public void writeOnImsCallResumeFailed(int n, ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResumeFailed", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnImsCallResumeFailed(int android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), this, n, imsCallSession, imsReasonInfo);
    }

    public void writeOnRilTimeoutResponse(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("writeOnRilTimeoutResponse", $$robo$$com_android_internal_telephony_metrics_TelephonyMetrics$writeOnRilTimeoutResponse(int int int ), this, n, n2, n3);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyMetrics.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyMetrics)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

