/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.telecom.ConferenceParticipant;
import android.telephony.Rlog;
import android.telephony.ims.ImsStreamMediaProfile;
import com.android.ims.ImsCall;
import com.android.ims.ImsException;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhoneCall
extends Call
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsPhoneCall";
    private static boolean FORCE_DEBUG = false;
    private static boolean DBG;
    private static boolean VDBG;
    public static String CONTEXT_UNKNOWN = "UK";
    public static String CONTEXT_RINGING = "RG";
    public static String CONTEXT_FOREGROUND = "FG";
    public static String CONTEXT_BACKGROUND = "BG";
    public static String CONTEXT_HANDOVER = "HO";
    ImsPhoneCallTracker mOwner;
    private boolean mRingbackTonePlayed;
    private String mCallContext;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__() {
        this.mRingbackTonePlayed = false;
        this.mCallContext = "UK";
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(ImsPhoneCallTracker owner, String context) {
        this.mRingbackTonePlayed = false;
        this.mOwner = owner;
        this.mCallContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$dispose() {
        try {
            this.mOwner.hangup(this);
        }
        catch (CallStateException i) {
            int s = this.mConnections.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i2);
                c.onDisconnect(14);
            }
        }
        finally {
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i);
                c.onDisconnect(14);
            }
        }
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getConnections() {
        return this.mConnections;
    }

    private final Phone $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getPhone() {
        return this.mOwner.mPhone;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isMultiparty() {
        ImsCall imsCall = this.getImsCall();
        if (imsCall == null) {
            return false;
        }
        return imsCall.isMultiparty();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ImsPhoneCall ");
        sb.append(this.mCallContext);
        sb.append(" state: ");
        sb.append(this.mState.toString());
        sb.append(" ");
        if (this.mConnections.size() > 1) {
            sb.append(" ERROR_MULTIPLE ");
        }
        for (Connection conn : this.mConnections) {
            sb.append(conn);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private final List<ConferenceParticipant> $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getConferenceParticipants() {
        ImsCall call = this.getImsCall();
        if (call == null) {
            return null;
        }
        return call.getConferenceParticipants();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(Connection conn) {
        if (VDBG) {
            Rlog.v("ImsPhoneCall", "attach : " + this.mCallContext + " conn = " + conn);
        }
        this.clearDisconnected();
        this.mConnections.add(conn);
        this.mOwner.logState();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(Connection conn, Call.State state) {
        if (VDBG) {
            Rlog.v("ImsPhoneCall", "attach : " + this.mCallContext + " state = " + state.toString());
        }
        this.attach(conn);
        this.mState = state;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attachFake(Connection conn, Call.State state) {
        this.attach(conn, state);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$connectionDisconnected(ImsPhoneConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                if (VDBG) {
                    Rlog.v("ImsPhoneCall", "connectionDisconnected : " + this.mCallContext + " state = " + (Object)((Object)this.mState));
                }
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$detach(ImsPhoneConnection conn) {
        if (VDBG) {
            Rlog.v("ImsPhoneCall", "detach : " + this.mCallContext + " conn = " + conn);
        }
        this.mConnections.remove(conn);
        this.clearDisconnected();
        this.mOwner.logState();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isFull() {
        return this.mConnections.size() == 5;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            ImsPhoneConnection cn = (ImsPhoneConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
        if (VDBG) {
            Rlog.v("ImsPhoneCall", "onHangupLocal : " + this.mCallContext + " state = " + (Object)((Object)this.mState));
        }
    }

    @VisibleForTesting
    private final ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getFirstConnection() {
        if (this.mConnections.size() == 0) {
            return null;
        }
        return (ImsPhoneConnection)this.mConnections.get(0);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$setMute(boolean mute) {
        ImsCall imsCall;
        ImsCall imsCall2 = imsCall = this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
        if (imsCall != null) {
            try {
                imsCall.setMute(mute);
            }
            catch (ImsException e) {
                Rlog.e("ImsPhoneCall", "setMute failed : " + e.getMessage());
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$merge(ImsPhoneCall that, Call.State state) {
        ImsPhoneConnection imsPhoneConnection = this.getFirstConnection();
        if (imsPhoneConnection != null) {
            long conferenceConnectTime = imsPhoneConnection.getConferenceConnectTime();
            if (conferenceConnectTime > 0L) {
                imsPhoneConnection.setConnectTime(conferenceConnectTime);
                imsPhoneConnection.setConnectTimeReal(imsPhoneConnection.getConnectTimeReal());
            } else if (DBG) {
                Rlog.d("ImsPhoneCall", "merge: conference connect time is 0");
            }
        }
        if (DBG) {
            Rlog.d("ImsPhoneCall", "merge(" + this.mCallContext + "): " + that + "state = " + (Object)((Object)state));
        }
    }

    @VisibleForTesting
    private final ImsCall $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getImsCall() {
        return this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
    }

    private static final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isLocalTone(ImsCall imsCall) {
        if (imsCall == null || imsCall.getCallProfile() == null || imsCall.getCallProfile().mMediaProfile == null) {
            return false;
        }
        ImsStreamMediaProfile mediaProfile = imsCall.getCallProfile().mMediaProfile;
        return mediaProfile.mAudioDirection == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$update(ImsPhoneConnection conn, ImsCall imsCall, Call.State state) {
        boolean changed = false;
        Call.State oldState = this.mState;
        if (state == Call.State.ALERTING) {
            if (this.mRingbackTonePlayed && !ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.stopRingbackTone();
                this.mRingbackTonePlayed = false;
            } else if (!this.mRingbackTonePlayed && ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.startRingbackTone();
                this.mRingbackTonePlayed = true;
            }
        } else if (this.mRingbackTonePlayed) {
            this.mOwner.mPhone.stopRingbackTone();
            this.mRingbackTonePlayed = false;
        }
        if (state != this.mState && state != Call.State.DISCONNECTED) {
            this.mState = state;
            changed = true;
        } else if (state == Call.State.DISCONNECTED) {
            changed = true;
        }
        if (VDBG) {
            Rlog.v("ImsPhoneCall", "update : " + this.mCallContext + " state: " + (Object)((Object)oldState) + " --> " + (Object)((Object)this.mState));
        }
        return changed;
    }

    private final ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getHandoverConnection() {
        return (ImsPhoneConnection)this.getEarliestConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$switchWith(ImsPhoneCall that) {
        if (VDBG) {
            Rlog.v("ImsPhoneCall", "switchWith : switchCall = " + this + " withCall = " + that);
        }
        Class<ImsPhoneCall> clazz = ImsPhoneCall.class;
        synchronized (ImsPhoneCall.class) {
            ImsPhoneCall tmp = new ImsPhoneCall();
            tmp.takeOver(this);
            this.takeOver(that);
            that.takeOver(tmp);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mOwner.logState();
            return;
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$takeOver(ImsPhoneCall that) {
        this.mConnections = that.mConnections;
        this.mState = that.mState;
        for (Connection c : this.mConnections) {
            ((ImsPhoneConnection)c).changeParent(this);
        }
    }

    static void __staticInitializer__() {
        DBG = Rlog.isLoggable("ImsPhoneCall", 3);
        VDBG = Rlog.isLoggable("ImsPhoneCall", 2);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__();
    }

    public ImsPhoneCall() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(), this);
    }

    private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker, String string2) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(imsPhoneCallTracker, string2);
    }

    public ImsPhoneCall(ImsPhoneCallTracker imsPhoneCallTracker, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker java.lang.String ), this, imsPhoneCallTracker, string2);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$dispose(), this);
    }

    @Override
    public List<Connection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getConnections(), this);
    }

    @Override
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getPhone(), this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isMultiparty(), this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$hangup(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$toString(), this);
    }

    @Override
    public List<ConferenceParticipant> getConferenceParticipants() {
        return InvokeDynamicSupport.bootstrap("getConferenceParticipants", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getConferenceParticipants(), this);
    }

    public void attach(Connection connection) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(com.android.internal.telephony.Connection ), this, connection);
    }

    public void attach(Connection connection, Call.State state) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attach(com.android.internal.telephony.Connection com.android.internal.telephony.Call$State ), this, connection, state);
    }

    public void attachFake(Connection connection, Call.State state) {
        InvokeDynamicSupport.bootstrap("attachFake", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$attachFake(com.android.internal.telephony.Connection com.android.internal.telephony.Call$State ), this, connection, state);
    }

    public boolean connectionDisconnected(ImsPhoneConnection imsPhoneConnection) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectionDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$connectionDisconnected(com.android.internal.telephony.imsphone.ImsPhoneConnection ), this, imsPhoneConnection);
    }

    public void detach(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$detach(com.android.internal.telephony.imsphone.ImsPhoneConnection ), this, imsPhoneConnection);
    }

    boolean isFull() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFull", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isFull(), this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$onHangupLocal(), this);
    }

    public ImsPhoneConnection getFirstConnection() {
        return InvokeDynamicSupport.bootstrap("getFirstConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getFirstConnection(), this);
    }

    void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$setMute(boolean ), this, bl);
    }

    void merge(ImsPhoneCall imsPhoneCall, Call.State state) {
        InvokeDynamicSupport.bootstrap("merge", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$merge(com.android.internal.telephony.imsphone.ImsPhoneCall com.android.internal.telephony.Call$State ), this, imsPhoneCall, state);
    }

    public ImsCall getImsCall() {
        return InvokeDynamicSupport.bootstrap("getImsCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getImsCall(), this);
    }

    static boolean isLocalTone(ImsCall imsCall) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalTone", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$isLocalTone(com.android.ims.ImsCall ), (ImsCall)imsCall);
    }

    public boolean update(ImsPhoneConnection imsPhoneConnection, ImsCall imsCall, Call.State state) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$update(com.android.internal.telephony.imsphone.ImsPhoneConnection com.android.ims.ImsCall com.android.internal.telephony.Call$State ), this, imsPhoneConnection, imsCall, state);
    }

    ImsPhoneConnection getHandoverConnection() {
        return InvokeDynamicSupport.bootstrap("getHandoverConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$getHandoverConnection(), this);
    }

    public void switchWith(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("switchWith", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$switchWith(com.android.internal.telephony.imsphone.ImsPhoneCall ), this, imsPhoneCall);
    }

    private void takeOver(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("takeOver", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCall$takeOver(com.android.internal.telephony.imsphone.ImsPhoneCall ), this, imsPhoneCall);
    }

    static {
        RobolectricInternals.classInitializing(ImsPhoneCall.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneCall)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

