/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsServiceController;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsServiceFeatureQueryManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Map<ComponentName, ImsServiceFeatureQuery> mActiveQueries;
    private Context mContext;
    private Listener mListener;
    private Object mLock;

    private void $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$__constructor__(Context context, Listener listener) {
        this.mActiveQueries = new HashMap<ComponentName, ImsServiceFeatureQuery>();
        this.mLock = new Object();
        this.mContext = context;
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$startQuery(ComponentName name, String intentFilter) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveQueries.containsKey(name)) {
                return true;
            }
            ImsServiceFeatureQuery query = new ImsServiceFeatureQuery(this, name, intentFilter);
            this.mActiveQueries.put(name, query);
            return query.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$isQueryInProgress() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mActiveQueries.isEmpty();
        }
    }

    private void __constructor__(Context context, Listener listener) {
        this.$$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$__constructor__(context, listener);
    }

    public ImsServiceFeatureQueryManager(Context context, Listener listener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$__constructor__(android.content.Context com.android.internal.telephony.ims.ImsServiceFeatureQueryManager$Listener ), this, context, listener);
    }

    public boolean startQuery(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("startQuery", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$startQuery(android.content.ComponentName java.lang.String ), this, componentName, string2);
    }

    public boolean isQueryInProgress() {
        return (boolean)InvokeDynamicSupport.bootstrap("isQueryInProgress", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager$isQueryInProgress(), this);
    }

    public /* synthetic */ ImsServiceFeatureQueryManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceFeatureQueryManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Listener {
        public void onComplete(ComponentName var1, Set<ImsFeatureConfiguration.FeatureSlotPair> var2);

        public void onError(ComponentName var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ImsServiceFeatureQuery
    implements ServiceConnection,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String LOG_TAG = "ImsServiceFeatureQuery";
        private ComponentName mName;
        private String mIntentFilter;
        /* synthetic */ ImsServiceFeatureQueryManager this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$__constructor__(ImsServiceFeatureQueryManager imsServiceFeatureQueryManager, ComponentName name, String intentFilter) {
            this.this$0 = imsServiceFeatureQueryManager;
            this.mName = name;
            this.mIntentFilter = intentFilter;
        }

        private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$start() {
            Log.d("ImsServiceFeatureQuery", "start: intent filter=" + this.mIntentFilter + ", name=" + this.mName);
            Intent imsServiceIntent = new Intent(this.mIntentFilter).setComponent(this.mName);
            int serviceFlags = 0x4000041;
            boolean bindStarted = this.this$0.mContext.bindService(imsServiceIntent, this, serviceFlags);
            if (!bindStarted) {
                this.cleanup();
            }
            return bindStarted;
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$onServiceConnected(ComponentName name, IBinder service) {
            Log.i("ImsServiceFeatureQuery", "onServiceConnected for component: " + name);
            if (service != null) {
                this.queryImsFeatures(IImsServiceController.Stub.asInterface(service));
            } else {
                Log.w("ImsServiceFeatureQuery", "onServiceConnected: " + name + " binder null, cleaning up.");
                this.cleanup();
            }
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$onServiceDisconnected(ComponentName name) {
            Log.w("ImsServiceFeatureQuery", "onServiceDisconnected for component: " + name);
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$queryImsFeatures(IImsServiceController controller) {
            ImsFeatureConfiguration config;
            try {
                config = controller.querySupportedImsFeatures();
            }
            catch (RemoteException e) {
                Log.w("ImsServiceFeatureQuery", "queryImsFeatures - error: " + e);
                this.cleanup();
                this.this$0.mListener.onError(this.mName);
                return;
            }
            Set<ImsFeatureConfiguration.FeatureSlotPair> servicePairs = config.getServiceFeatures();
            this.cleanup();
            this.this$0.mListener.onComplete(this.mName, servicePairs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$cleanup() {
            this.this$0.mContext.unbindService(this);
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mActiveQueries.remove(this.mName);
            }
        }

        private void __constructor__(ImsServiceFeatureQueryManager imsServiceFeatureQueryManager, ComponentName componentName, String string2) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$__constructor__(imsServiceFeatureQueryManager, componentName, string2);
        }

        public ImsServiceFeatureQuery(ImsServiceFeatureQueryManager imsServiceFeatureQueryManager, ComponentName componentName, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$__constructor__(com.android.internal.telephony.ims.ImsServiceFeatureQueryManager android.content.ComponentName java.lang.String ), this, imsServiceFeatureQueryManager, componentName, string2);
        }

        public boolean start() {
            return (boolean)InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$start(), this);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$onServiceDisconnected(android.content.ComponentName ), this, componentName);
        }

        private void queryImsFeatures(IImsServiceController iImsServiceController) {
            InvokeDynamicSupport.bootstrap("queryImsFeatures", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$queryImsFeatures(android.telephony.ims.aidl.IImsServiceController ), this, iImsServiceController);
        }

        private void cleanup() {
            InvokeDynamicSupport.bootstrap("cleanup", $$robo$$com_android_internal_telephony_ims_ImsServiceFeatureQueryManager_ImsServiceFeatureQuery$cleanup(), this);
        }

        public /* synthetic */ ImsServiceFeatureQuery() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceFeatureQuery)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

