/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ims.ImsService;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsServiceController;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ExponentialBackoff;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsServiceController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private ImsService.Listener mFeatureChangedListener;
    private static String LOG_TAG = "ImsServiceController";
    private static int REBIND_START_DELAY_MS = 2000;
    private static int REBIND_MAXIMUM_DELAY_MS = 60000;
    private ComponentName mComponentName;
    private HandlerThread mHandlerThread;
    private IPackageManager mPackageManager;
    private ImsServiceControllerCallbacks mCallbacks;
    private ExponentialBackoff mBackoff;
    private boolean mIsBound;
    private boolean mIsBinding;
    private HashSet<ImsFeatureConfiguration.FeatureSlotPair> mImsFeatures;
    private HashSet<ImsFeatureContainer> mImsFeatureBinders;
    private IImsServiceController mIImsServiceController;
    private IBinder mImsServiceControllerBinder;
    private ImsServiceConnection mImsServiceConnection;
    private ImsDeathRecipient mImsDeathRecipient;
    private Set<IImsServiceFeatureCallback> mImsStatusCallbacks;
    private Set<ImsFeatureStatusCallback> mFeatureStatusCallbacks;
    protected Object mLock;
    protected Context mContext;
    private Runnable mRestartImsServiceRunnable;
    private RebindRetry mRebindRetry;

    private void $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks) {
        this.mFeatureChangedListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsServiceController this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$__constructor__(ImsServiceController this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) {
                if (this.this$0.mCallbacks == null) {
                    return;
                }
                this.this$0.mCallbacks.imsServiceFeaturesChanged(c, this.this$0);
            }

            private void __constructor__(ImsServiceController imsServiceController) {
                this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_1$__constructor__(imsServiceController);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$__constructor__(com.android.internal.telephony.ims.ImsServiceController ), this, imsServiceController);
            }

            @Override
            public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration imsFeatureConfiguration) {
                InvokeDynamicSupport.bootstrap("onUpdateSupportedImsFeatures", $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$onUpdateSupportedImsFeatures(android.telephony.ims.stub.ImsFeatureConfiguration ), this, imsFeatureConfiguration);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
        this.mIsBound = false;
        this.mIsBinding = false;
        this.mImsFeatureBinders = new HashSet();
        this.mImsStatusCallbacks = ConcurrentHashMap.newKeySet();
        this.mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
        this.mLock = new Object();
        this.mRestartImsServiceRunnable = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsServiceController this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_2$__constructor__(ImsServiceController this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_2$run() {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (this.this$0.mIsBound) {
                        return;
                    }
                    this.this$0.bind(this.this$0.mImsFeatures);
                }
            }

            private void __constructor__(ImsServiceController imsServiceController) {
                this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_2$__constructor__(imsServiceController);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_2$__constructor__(com.android.internal.telephony.ims.ImsServiceController ), this, imsServiceController);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_ims_ImsServiceController_2$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRebindRetry = new RebindRetry(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsServiceController this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_3$__constructor__(ImsServiceController this$0) {
                this.this$0 = this$0;
            }

            private final long $$robo$$com_android_internal_telephony_ims_ImsServiceController_3$getStartDelay() {
                return 2000L;
            }

            private final long $$robo$$com_android_internal_telephony_ims_ImsServiceController_3$getMaximumDelay() {
                return 60000L;
            }

            private void __constructor__(ImsServiceController imsServiceController) {
                this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_3$__constructor__(imsServiceController);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_3$__constructor__(com.android.internal.telephony.ims.ImsServiceController ), this, imsServiceController);
            }

            @Override
            public long getStartDelay() {
                return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$com_android_internal_telephony_ims_ImsServiceController_3$getStartDelay(), this);
            }

            @Override
            public long getMaximumDelay() {
                return (long)InvokeDynamicSupport.bootstrap("getMaximumDelay", $$robo$$com_android_internal_telephony_ims_ImsServiceController_3$getMaximumDelay(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandlerThread.start();
        this.mBackoff = new ExponentialBackoff(this.mRebindRetry.getStartDelay(), this.mRebindRetry.getMaximumDelay(), 2, this.mHandlerThread.getLooper(), this.mRestartImsServiceRunnable);
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks, Handler handler, RebindRetry rebindRetry) {
        this.mFeatureChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
        this.mIsBound = false;
        this.mIsBinding = false;
        this.mImsFeatureBinders = new HashSet();
        this.mImsStatusCallbacks = ConcurrentHashMap.newKeySet();
        this.mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
        this.mLock = new Object();
        this.mRestartImsServiceRunnable = new /* invalid duplicate definition of identical inner class */;
        this.mRebindRetry = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mBackoff = new ExponentialBackoff(rebindRetry.getStartDelay(), rebindRetry.getMaximumDelay(), 2, handler, this.mRestartImsServiceRunnable);
        this.mPackageManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceController$bind(HashSet<ImsFeatureConfiguration.FeatureSlotPair> imsFeatureSet) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsBound && !this.mIsBinding) {
                this.mIsBinding = true;
                this.mImsFeatures = imsFeatureSet;
                this.grantPermissionsToService();
                Intent imsServiceIntent = new Intent(this.getServiceInterface()).setComponent(this.mComponentName);
                this.mImsServiceConnection = new ImsServiceConnection(this);
                int serviceFlags = 0x4000041;
                Log.i("ImsServiceController", "Binding ImsService:" + this.mComponentName);
                try {
                    boolean bindSucceeded = this.startBindToService(imsServiceIntent, this.mImsServiceConnection, serviceFlags);
                    if (!bindSucceeded) {
                        this.mBackoff.notifyFailed();
                    }
                    return bindSucceeded;
                }
                catch (Exception e) {
                    this.mBackoff.notifyFailed();
                    Log.e("ImsServiceController", "Error binding (" + this.mComponentName + ") with exception: " + e.getMessage() + ", rebinding in " + this.mBackoff.getCurrentDelay() + " ms");
                    return false;
                }
            }
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceController$startBindToService(Intent intent, ImsServiceConnection connection, int flags) {
        return this.mContext.bindService(intent, connection, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$unbind() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.mBackoff.stop();
            if (this.mImsServiceConnection == null || this.mImsDeathRecipient == null) {
                return;
            }
            this.changeImsServiceFeatures(new HashSet<ImsFeatureConfiguration.FeatureSlotPair>());
            this.removeImsServiceFeatureCallbacks();
            this.mImsServiceControllerBinder.unlinkToDeath(this.mImsDeathRecipient, 0);
            Log.i("ImsServiceController", "Unbinding ImsService: " + this.mComponentName);
            this.mContext.unbindService(this.mImsServiceConnection);
            this.cleanUpService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$changeImsServiceFeatures(HashSet<ImsFeatureConfiguration.FeatureSlotPair> newImsFeatures) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            Log.i("ImsServiceController", "Features changed (" + this.mImsFeatures + "->" + newImsFeatures + ") for ImsService: " + this.mComponentName);
            HashSet<ImsFeatureConfiguration.FeatureSlotPair> oldImsFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(this.mImsFeatures);
            this.mImsFeatures = newImsFeatures;
            if (this.mIsBound) {
                HashSet<ImsFeatureConfiguration.FeatureSlotPair> newFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(this.mImsFeatures);
                newFeatures.removeAll(oldImsFeatures);
                for (ImsFeatureConfiguration.FeatureSlotPair i : newFeatures) {
                    this.addImsServiceFeature(i);
                }
                HashSet<ImsFeatureConfiguration.FeatureSlotPair> oldFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(oldImsFeatures);
                oldFeatures.removeAll(this.mImsFeatures);
                for (ImsFeatureConfiguration.FeatureSlotPair i : oldFeatures) {
                    this.removeImsServiceFeature(i);
                }
            }
        }
    }

    @VisibleForTesting
    private final IImsServiceController $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceController() {
        return this.mIImsServiceController;
    }

    @VisibleForTesting
    private final IBinder $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceControllerBinder() {
        return this.mImsServiceControllerBinder;
    }

    @VisibleForTesting
    private final long $$robo$$com_android_internal_telephony_ims_ImsServiceController$getRebindDelay() {
        return this.mBackoff.getCurrentDelay();
    }

    private final ComponentName $$robo$$com_android_internal_telephony_ims_ImsServiceController$getComponentName() {
        return this.mComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeatureCallback(IImsServiceFeatureCallback callback) {
        this.mImsStatusCallbacks.add(callback);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mImsFeatures == null || this.mImsFeatures.isEmpty()) {
                return;
            }
            try {
                for (ImsFeatureConfiguration.FeatureSlotPair i : this.mImsFeatures) {
                    callback.imsFeatureCreated(i.slotId, i.featureType);
                }
            }
            catch (RemoteException e) {
                Log.w("ImsServiceController", "addImsServiceFeatureCallback: exception notifying callback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$enableIms(int slotId) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isServiceControllerAvailable()) {
                    this.mIImsServiceController.enableIms(slotId);
                }
            }
        }
        catch (RemoteException e) {
            Log.w("ImsServiceController", "Couldn't enable IMS: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$disableIms(int slotId) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isServiceControllerAvailable()) {
                    this.mIImsServiceController.disableIms(slotId);
                }
            }
        }
        catch (RemoteException e) {
            Log.w("ImsServiceController", "Couldn't disable IMS: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IImsMmTelFeature $$robo$$com_android_internal_telephony_ims_ImsServiceController$getMmTelFeature(int slotId) {
        Object object = this.mLock;
        synchronized (object) {
            ImsFeatureContainer f = this.getImsFeatureContainer(slotId, 1);
            if (f == null) {
                Log.w("ImsServiceController", "Requested null MMTelFeature on slot " + slotId);
                return null;
            }
            return f.resolve(IImsMmTelFeature.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IImsRcsFeature $$robo$$com_android_internal_telephony_ims_ImsServiceController$getRcsFeature(int slotId) {
        Object object = this.mLock;
        synchronized (object) {
            ImsFeatureContainer f = this.getImsFeatureContainer(slotId, 2);
            if (f == null) {
                Log.w("ImsServiceController", "Requested null RcsFeature on slot " + slotId);
                return null;
            }
            return f.resolve(IImsRcsFeature.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IImsRegistration $$robo$$com_android_internal_telephony_ims_ImsServiceController$getRegistration(int slotId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.isServiceControllerAvailable() ? this.mIImsServiceController.getRegistration(slotId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IImsConfig $$robo$$com_android_internal_telephony_ims_ImsServiceController$getConfig(int slotId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.isServiceControllerAvailable() ? this.mIImsServiceController.getConfig(slotId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$notifyImsServiceReady() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isServiceControllerAvailable()) {
                Log.d("ImsServiceController", "notifyImsServiceReady");
                this.mIImsServiceController.setListener(this.mFeatureChangedListener);
                this.mIImsServiceController.notifyImsServiceReadyForFeatureCreation();
            }
        }
    }

    private final String $$robo$$com_android_internal_telephony_ims_ImsServiceController$getServiceInterface() {
        return "android.telephony.ims.ImsService";
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$setServiceController(IBinder serviceController) {
        this.mIImsServiceController = IImsServiceController.Stub.asInterface(serviceController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceController$isBound() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsBound;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceController$isServiceControllerAvailable() {
        return this.mIImsServiceController != null;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeatureCallbacks() {
        this.mImsStatusCallbacks.clear();
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$startDelayedRebindToService() {
        this.mBackoff.start();
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$grantPermissionsToService() {
        Log.i("ImsServiceController", "Granting Runtime permissions to:" + this.getComponentName());
        String[] pkgToGrant = new String[]{this.mComponentName.getPackageName()};
        try {
            if (this.mPackageManager != null) {
                this.mPackageManager.grantDefaultPermissionsToEnabledImsServices(pkgToGrant, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            Log.w("ImsServiceController", "Unable to grant permissions, binder died.");
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureCreatedCallback(int slot, int feature) {
        Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
        while (i.hasNext()) {
            IImsServiceFeatureCallback callbacks = i.next();
            try {
                callbacks.imsFeatureCreated(slot, feature);
            }
            catch (RemoteException e) {
                Log.w("ImsServiceController", "sendImsFeatureCreatedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                i.remove();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureRemovedCallback(int slot, int feature) {
        Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
        while (i.hasNext()) {
            IImsServiceFeatureCallback callbacks = i.next();
            try {
                callbacks.imsFeatureRemoved(slot, feature);
            }
            catch (RemoteException e) {
                Log.w("ImsServiceController", "sendImsFeatureRemovedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                i.remove();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureStatusChanged(int slot, int feature, int status) {
        Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
        while (i.hasNext()) {
            IImsServiceFeatureCallback callbacks = i.next();
            try {
                callbacks.imsStatusChanged(slot, feature, status);
            }
            catch (RemoteException e) {
                Log.w("ImsServiceController", "sendImsFeatureStatusChanged: Binder died, removing callback. Exception:" + e.getMessage());
                i.remove();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeature(ImsFeatureConfiguration.FeatureSlotPair featurePair) throws RemoteException {
        if (!this.isServiceControllerAvailable() || this.mCallbacks == null) {
            Log.w("ImsServiceController", "addImsServiceFeature called with null values.");
            return;
        }
        if (featurePair.featureType != 0) {
            ImsFeatureStatusCallback c = new ImsFeatureStatusCallback(this, featurePair.slotId, featurePair.featureType);
            this.mFeatureStatusCallbacks.add(c);
            IInterface f = this.createImsFeature(featurePair.slotId, featurePair.featureType, c.getCallback());
            this.addImsFeatureBinder(featurePair.slotId, featurePair.featureType, f);
            this.mCallbacks.imsServiceFeatureCreated(featurePair.slotId, featurePair.featureType, this);
        } else {
            Log.i("ImsServiceController", "supports emergency calling on slot " + featurePair.slotId);
        }
        this.sendImsFeatureCreatedCallback(featurePair.slotId, featurePair.featureType);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeature(ImsFeatureConfiguration.FeatureSlotPair featurePair) throws RemoteException {
        if (!this.isServiceControllerAvailable() || this.mCallbacks == null) {
            Log.w("ImsServiceController", "removeImsServiceFeature called with null values.");
            return;
        }
        if (featurePair.featureType != 0) {
            ImsFeatureStatusCallback callbackToRemove = this.mFeatureStatusCallbacks.stream().filter(c -> ((ImsFeatureStatusCallback)c).mSlotId == featurePair.slotId && ((ImsFeatureStatusCallback)c).mFeatureType == featurePair.featureType).findFirst().orElse(null);
            if (callbackToRemove != null) {
                this.mFeatureStatusCallbacks.remove(callbackToRemove);
            }
            this.removeImsFeature(featurePair.slotId, featurePair.featureType, callbackToRemove != null ? callbackToRemove.getCallback() : null);
            this.removeImsFeatureBinder(featurePair.slotId, featurePair.featureType);
            this.mCallbacks.imsServiceFeatureRemoved(featurePair.slotId, featurePair.featureType, this);
        } else {
            Log.i("ImsServiceController", "doesn't support emergency calling on slot " + featurePair.slotId);
        }
        this.sendImsFeatureRemovedCallback(featurePair.slotId, featurePair.featureType);
    }

    private final IInterface $$robo$$com_android_internal_telephony_ims_ImsServiceController$createImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        switch (featureType) {
            case 1: {
                return this.mIImsServiceController.createMmTelFeature(slotId, c);
            }
            case 2: {
                return this.mIImsServiceController.createRcsFeature(slotId, c);
            }
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        this.mIImsServiceController.removeImsFeature(slotId, featureType, c);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsFeatureBinder(int slotId, int featureType, IInterface b) {
        this.mImsFeatureBinders.add(new ImsFeatureContainer(this, slotId, featureType, b));
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsFeatureBinder(int slotId, int featureType) {
        ImsFeatureContainer container = this.mImsFeatureBinders.stream().filter(f -> f.slotId == slotId && f.featureType == featureType).findFirst().orElse(null);
        if (container != null) {
            this.mImsFeatureBinders.remove(container);
        }
    }

    private final ImsFeatureContainer $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsFeatureContainer(int slotId, int featureType) {
        return this.mImsFeatureBinders.stream().filter(f -> f.slotId == slotId && f.featureType == featureType).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$notifyAllFeaturesRemoved() {
        if (this.mCallbacks == null) {
            Log.w("ImsServiceController", "notifyAllFeaturesRemoved called with invalid callbacks.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (ImsFeatureConfiguration.FeatureSlotPair feature : this.mImsFeatures) {
                if (feature.featureType != 0) {
                    this.mCallbacks.imsServiceFeatureRemoved(feature.slotId, feature.featureType, this);
                }
                this.sendImsFeatureRemovedCallback(feature.slotId, feature.featureType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$cleanUpService() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsDeathRecipient = null;
            this.mImsServiceConnection = null;
            this.mImsServiceControllerBinder = null;
            this.setServiceController(null);
        }
    }

    private void __constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
        this.$$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(context, componentName, imsServiceControllerCallbacks);
    }

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks ), this, context, componentName, imsServiceControllerCallbacks);
    }

    private void __constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks, Handler handler, RebindRetry rebindRetry) {
        this.$$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(context, componentName, imsServiceControllerCallbacks, handler, rebindRetry);
    }

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks, Handler handler, RebindRetry rebindRetry) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks android.os.Handler com.android.internal.telephony.ims.ImsServiceController$RebindRetry ), this, context, componentName, imsServiceControllerCallbacks, handler, rebindRetry);
    }

    public boolean bind(HashSet<ImsFeatureConfiguration.FeatureSlotPair> hashSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("bind", $$robo$$com_android_internal_telephony_ims_ImsServiceController$bind(java.util.HashSet<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, hashSet);
    }

    protected boolean startBindToService(Intent intent, ImsServiceConnection imsServiceConnection, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("startBindToService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$startBindToService(android.content.Intent com.android.internal.telephony.ims.ImsServiceController$ImsServiceConnection int ), this, intent, imsServiceConnection, n);
    }

    public void unbind() throws RemoteException {
        InvokeDynamicSupport.bootstrap("unbind", $$robo$$com_android_internal_telephony_ims_ImsServiceController$unbind(), this);
    }

    public void changeImsServiceFeatures(HashSet<ImsFeatureConfiguration.FeatureSlotPair> hashSet) throws RemoteException {
        InvokeDynamicSupport.bootstrap("changeImsServiceFeatures", $$robo$$com_android_internal_telephony_ims_ImsServiceController$changeImsServiceFeatures(java.util.HashSet<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, hashSet);
    }

    public IImsServiceController getImsServiceController() {
        return InvokeDynamicSupport.bootstrap("getImsServiceController", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceController(), this);
    }

    public IBinder getImsServiceControllerBinder() {
        return InvokeDynamicSupport.bootstrap("getImsServiceControllerBinder", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceControllerBinder(), this);
    }

    public long getRebindDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getRebindDelay", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getRebindDelay(), this);
    }

    public ComponentName getComponentName() {
        return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getComponentName(), this);
    }

    public void addImsServiceFeatureCallback(IImsServiceFeatureCallback iImsServiceFeatureCallback) {
        InvokeDynamicSupport.bootstrap("addImsServiceFeatureCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeatureCallback(com.android.ims.internal.IImsServiceFeatureCallback ), this, iImsServiceFeatureCallback);
    }

    public void enableIms(int n) {
        InvokeDynamicSupport.bootstrap("enableIms", $$robo$$com_android_internal_telephony_ims_ImsServiceController$enableIms(int ), this, n);
    }

    public void disableIms(int n) {
        InvokeDynamicSupport.bootstrap("disableIms", $$robo$$com_android_internal_telephony_ims_ImsServiceController$disableIms(int ), this, n);
    }

    public IImsMmTelFeature getMmTelFeature(int n) {
        return InvokeDynamicSupport.bootstrap("getMmTelFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getMmTelFeature(int ), this, n);
    }

    public IImsRcsFeature getRcsFeature(int n) {
        return InvokeDynamicSupport.bootstrap("getRcsFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getRcsFeature(int ), this, n);
    }

    public IImsRegistration getRegistration(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getRegistration", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getRegistration(int ), this, n);
    }

    public IImsConfig getConfig(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getConfig(int ), this, n);
    }

    protected void notifyImsServiceReady() throws RemoteException {
        InvokeDynamicSupport.bootstrap("notifyImsServiceReady", $$robo$$com_android_internal_telephony_ims_ImsServiceController$notifyImsServiceReady(), this);
    }

    protected String getServiceInterface() {
        return InvokeDynamicSupport.bootstrap("getServiceInterface", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getServiceInterface(), this);
    }

    protected void setServiceController(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setServiceController", $$robo$$com_android_internal_telephony_ims_ImsServiceController$setServiceController(android.os.IBinder ), this, iBinder);
    }

    public boolean isBound() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBound", $$robo$$com_android_internal_telephony_ims_ImsServiceController$isBound(), this);
    }

    protected boolean isServiceControllerAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceControllerAvailable", $$robo$$com_android_internal_telephony_ims_ImsServiceController$isServiceControllerAvailable(), this);
    }

    public void removeImsServiceFeatureCallbacks() {
        InvokeDynamicSupport.bootstrap("removeImsServiceFeatureCallbacks", $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeatureCallbacks(), this);
    }

    private void startDelayedRebindToService() {
        InvokeDynamicSupport.bootstrap("startDelayedRebindToService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$startDelayedRebindToService(), this);
    }

    private void grantPermissionsToService() {
        InvokeDynamicSupport.bootstrap("grantPermissionsToService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$grantPermissionsToService(), this);
    }

    private void sendImsFeatureCreatedCallback(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendImsFeatureCreatedCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureCreatedCallback(int int ), this, n, n2);
    }

    private void sendImsFeatureRemovedCallback(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendImsFeatureRemovedCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureRemovedCallback(int int ), this, n, n2);
    }

    private void sendImsFeatureStatusChanged(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendImsFeatureStatusChanged", $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureStatusChanged(int int int ), this, n, n2, n3);
    }

    private void addImsServiceFeature(ImsFeatureConfiguration.FeatureSlotPair featureSlotPair) throws RemoteException {
        InvokeDynamicSupport.bootstrap("addImsServiceFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeature(android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair ), this, featureSlotPair);
    }

    private void removeImsServiceFeature(ImsFeatureConfiguration.FeatureSlotPair featureSlotPair) throws RemoteException {
        InvokeDynamicSupport.bootstrap("removeImsServiceFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeature(android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair ), this, featureSlotPair);
    }

    protected IInterface createImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createImsFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$createImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, n2, iImsFeatureStatusCallback);
    }

    protected void removeImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
        InvokeDynamicSupport.bootstrap("removeImsFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, n2, iImsFeatureStatusCallback);
    }

    private void addImsFeatureBinder(int n, int n2, IInterface iInterface) {
        InvokeDynamicSupport.bootstrap("addImsFeatureBinder", $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsFeatureBinder(int int android.os.IInterface ), this, n, n2, iInterface);
    }

    private void removeImsFeatureBinder(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeImsFeatureBinder", $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsFeatureBinder(int int ), this, n, n2);
    }

    private ImsFeatureContainer getImsFeatureContainer(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getImsFeatureContainer", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsFeatureContainer(int int ), this, n, n2);
    }

    private void notifyAllFeaturesRemoved() {
        InvokeDynamicSupport.bootstrap("notifyAllFeaturesRemoved", $$robo$$com_android_internal_telephony_ims_ImsServiceController$notifyAllFeaturesRemoved(), this);
    }

    private void cleanUpService() {
        InvokeDynamicSupport.bootstrap("cleanUpService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$cleanUpService(), this);
    }

    public /* synthetic */ ImsServiceController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ImsFeatureStatusCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mSlotId;
        private int mFeatureType;
        private IImsFeatureStatusCallback mCallback;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$__constructor__(ImsServiceController imsServiceController, int slotId, int featureType) {
            this.this$0 = imsServiceController;
            this.mCallback = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ImsFeatureStatusCallback this$1;

                private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$__constructor__(ImsFeatureStatusCallback this$1) {
                    this.this$1 = this$1;
                }

                private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$notifyImsFeatureStatus(int featureStatus) throws RemoteException {
                    Log.i("ImsServiceController", "notifyImsFeatureStatus: slot=" + this.this$1.mSlotId + ", feature=" + this.this$1.mFeatureType + ", status=" + featureStatus);
                    this.this$1.this$0.sendImsFeatureStatusChanged(this.this$1.mSlotId, this.this$1.mFeatureType, featureStatus);
                }

                private void __constructor__(ImsFeatureStatusCallback imsFeatureStatusCallback) {
                    this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$__constructor__(imsFeatureStatusCallback);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$__constructor__(com.android.internal.telephony.ims.ImsServiceController$ImsFeatureStatusCallback ), this, imsFeatureStatusCallback);
                }

                @Override
                public void notifyImsFeatureStatus(int n) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("notifyImsFeatureStatus", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$notifyImsFeatureStatus(int ), this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mSlotId = slotId;
            this.mFeatureType = featureType;
        }

        private final IImsFeatureStatusCallback $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$getCallback() {
            return this.mCallback;
        }

        private void __constructor__(ImsServiceController imsServiceController, int n, int n2) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$__constructor__(imsServiceController, n, n2);
        }

        public ImsFeatureStatusCallback(ImsServiceController imsServiceController, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$__constructor__(com.android.internal.telephony.ims.ImsServiceController int int ), this, imsServiceController, n, n2);
        }

        public IImsFeatureStatusCallback getCallback() {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$getCallback(), this);
        }

        public /* synthetic */ ImsFeatureStatusCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsFeatureStatusCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ImsFeatureContainer
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int slotId;
        public int featureType;
        private IInterface mBinder;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$__constructor__(ImsServiceController imsServiceController, int slotId, int featureType, IInterface binder) {
            this.this$0 = imsServiceController;
            this.slotId = slotId;
            this.featureType = featureType;
            this.mBinder = binder;
        }

        private final <T extends IInterface> T $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$resolve(Class<T> className) {
            return (T)((IInterface)className.cast(this.mBinder));
        }

        private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsFeatureContainer that = (ImsFeatureContainer)o;
            if (this.slotId != that.slotId) {
                return false;
            }
            if (this.featureType != that.featureType) {
                return false;
            }
            return this.mBinder != null ? this.mBinder.equals(that.mBinder) : that.mBinder == null;
        }

        private final int $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$hashCode() {
            int result = this.slotId;
            result = 31 * result + this.featureType;
            result = 31 * result + (this.mBinder != null ? this.mBinder.hashCode() : 0);
            return result;
        }

        private void __constructor__(ImsServiceController imsServiceController, int n, int n2, IInterface iInterface) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$__constructor__(imsServiceController, n, n2, iInterface);
        }

        public ImsFeatureContainer(ImsServiceController imsServiceController, int n, int n2, IInterface iInterface) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$__constructor__(com.android.internal.telephony.ims.ImsServiceController int int android.os.IInterface ), this, imsServiceController, n, n2, iInterface);
        }

        public <T extends IInterface> T resolve(Class<T> clazz) {
            return (T)InvokeDynamicSupport.bootstrap("resolve", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$resolve(java.lang.Class<T> ), this, clazz);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureContainer$hashCode(), this);
        }

        public /* synthetic */ ImsFeatureContainer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsFeatureContainer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public static interface RebindRetry {
        public long getStartDelay();

        public long getMaximumDelay();
    }

    public static interface ImsServiceControllerCallbacks {
        public void imsServiceFeatureCreated(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeatureRemoved(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeaturesChanged(ImsFeatureConfiguration var1, ImsServiceController var2);
    }

    public class ImsServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$__constructor__(ImsServiceController this$0) {
            this.this$0 = this$0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            this.this$0.mBackoff.stop();
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mIsBound = true;
                this.this$0.mIsBinding = false;
                Log.d("ImsServiceController", "ImsService(" + name + "): onServiceConnected with binder: " + service);
                if (service != null) {
                    this.this$0.mImsDeathRecipient = new ImsDeathRecipient(this.this$0, name);
                    try {
                        service.linkToDeath(this.this$0.mImsDeathRecipient, 0);
                        this.this$0.mImsServiceControllerBinder = service;
                        this.this$0.setServiceController(service);
                        this.this$0.notifyImsServiceReady();
                        for (ImsFeatureConfiguration.FeatureSlotPair i : this.this$0.mImsFeatures) {
                            this.this$0.addImsServiceFeature(i);
                        }
                    }
                    catch (RemoteException e) {
                        this.this$0.mIsBound = false;
                        this.this$0.mIsBinding = false;
                        if (this.this$0.mImsDeathRecipient != null) {
                            this.this$0.mImsDeathRecipient.binderDied();
                        }
                        Log.e("ImsServiceController", "ImsService(" + name + ") RemoteException:" + e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceDisconnected(ComponentName name) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mIsBinding = false;
            }
            this.cleanupConnection();
            Log.w("ImsServiceController", "ImsService(" + name + "): onServiceDisconnected. Waiting...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onBindingDied(ComponentName name) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mIsBinding = false;
                this.this$0.mIsBound = false;
            }
            this.cleanupConnection();
            Log.w("ImsServiceController", "ImsService(" + name + "): onBindingDied. Starting rebind...");
            this.this$0.startDelayedRebindToService();
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$cleanupConnection() {
            if (this.this$0.isServiceControllerAvailable()) {
                this.this$0.mImsServiceControllerBinder.unlinkToDeath(this.this$0.mImsDeathRecipient, 0);
            }
            this.this$0.notifyAllFeaturesRemoved();
            this.this$0.cleanUpService();
        }

        private void __constructor__(ImsServiceController imsServiceController) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$__constructor__(imsServiceController);
        }

        public ImsServiceConnection(ImsServiceController imsServiceController) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$__constructor__(com.android.internal.telephony.ims.ImsServiceController ), this, imsServiceController);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceDisconnected(android.content.ComponentName ), this, componentName);
        }

        @Override
        public void onBindingDied(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onBindingDied", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onBindingDied(android.content.ComponentName ), this, componentName);
        }

        private void cleanupConnection() {
            InvokeDynamicSupport.bootstrap("cleanupConnection", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$cleanupConnection(), this);
        }

        public /* synthetic */ ImsServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ImsDeathRecipient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ComponentName mComponentName;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$__constructor__(ImsServiceController this$0, ComponentName name) {
            this.this$0 = this$0;
            this.mComponentName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$binderDied() {
            Log.e("ImsServiceController", "ImsService(" + this.mComponentName + ") died. Restarting...");
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mIsBinding = false;
                this.this$0.mIsBound = false;
            }
            this.this$0.notifyAllFeaturesRemoved();
            this.this$0.cleanUpService();
            this.this$0.startDelayedRebindToService();
        }

        private void __constructor__(ImsServiceController imsServiceController, ComponentName componentName) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$__constructor__(imsServiceController, componentName);
        }

        public ImsDeathRecipient(ImsServiceController imsServiceController, ComponentName componentName) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$__constructor__(com.android.internal.telephony.ims.ImsServiceController android.content.ComponentName ), this, imsServiceController, componentName);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$binderDied(), this);
        }

        public /* synthetic */ ImsDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

