/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UsimServiceTable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsimDataDownloadHandler
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "UsimDataDownloadHandler";
    private static int BER_SMS_PP_DOWNLOAD_TAG = 209;
    private static int DEV_ID_UICC = 129;
    private static int DEV_ID_NETWORK = 131;
    private static int EVENT_START_DATA_DOWNLOAD = 1;
    private static int EVENT_SEND_ENVELOPE_RESPONSE = 2;
    private static int EVENT_WRITE_SMS_COMPLETE = 3;
    private CommandsInterface mCi;

    private void $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$__constructor__(CommandsInterface commandsInterface) {
        this.mCi = commandsInterface;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$handleUsimDataDownload(UsimServiceTable ust, SmsMessage smsMessage) {
        if (ust != null && ust.isAvailable(UsimServiceTable.UsimService.DATA_DL_VIA_SMS_PP)) {
            Rlog.d("UsimDataDownloadHandler", "Received SMS-PP data download, sending to UICC.");
            return this.startDataDownload(smsMessage);
        }
        Rlog.d("UsimDataDownloadHandler", "DATA_DL_VIA_SMS_PP service not available, storing message to UICC.");
        String smsc = IccUtils.bytesToHexString(PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(smsMessage.getServiceCenterAddress()));
        this.mCi.writeSmsToSim(3, smsc, IccUtils.bytesToHexString(smsMessage.getPdu()), this.obtainMessage(3));
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$startDataDownload(SmsMessage smsMessage) {
        if (this.sendMessage(this.obtainMessage(1, smsMessage))) {
            return -1;
        }
        Rlog.e("UsimDataDownloadHandler", "startDataDownload failed to send message to start data download.");
        return 2;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$handleDataDownload(SmsMessage smsMessage) {
        int tpduIndex;
        int tpduLength;
        int bodyLength;
        int dcs = smsMessage.getDataCodingScheme();
        int pid = smsMessage.getProtocolIdentifier();
        byte[] pdu = smsMessage.getPdu();
        int scAddressLength = pdu[0] & 0xFF;
        int totalLength = bodyLength + 1 + ((bodyLength = UsimDataDownloadHandler.getEnvelopeBodyLength(scAddressLength, tpduLength = pdu.length - (tpduIndex = scAddressLength + 1))) > 127 ? 2 : 1);
        byte[] envelope = new byte[totalLength];
        int index = 0;
        envelope[index++] = -47;
        if (bodyLength > 127) {
            envelope[index++] = -127;
        }
        envelope[index++] = (byte)bodyLength;
        envelope[index++] = (byte)(0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value());
        envelope[index++] = 2;
        envelope[index++] = -125;
        envelope[index++] = -127;
        if (scAddressLength != 0) {
            envelope[index++] = (byte)ComprehensionTlvTag.ADDRESS.value();
            envelope[index++] = (byte)scAddressLength;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)1, (byte[])envelope, (int)index, (int)scAddressLength);
            index += scAddressLength;
        }
        envelope[index++] = (byte)(0x80 | ComprehensionTlvTag.SMS_TPDU.value());
        if (tpduLength > 127) {
            envelope[index++] = -127;
        }
        envelope[index++] = (byte)tpduLength;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)tpduIndex, (byte[])envelope, (int)index, (int)tpduLength);
        if ((index += tpduLength) != envelope.length) {
            Rlog.e("UsimDataDownloadHandler", "startDataDownload() calculated incorrect envelope length, aborting.");
            this.acknowledgeSmsWithError(255);
            return;
        }
        String encodedEnvelope = IccUtils.bytesToHexString(envelope);
        this.mCi.sendEnvelopeWithStatus(encodedEnvelope, this.obtainMessage(2, new int[]{dcs, pid}));
    }

    private static final int $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$getEnvelopeBodyLength(int scAddressLength, int tpduLength) {
        int length = tpduLength + 5;
        length += tpduLength > 127 ? 2 : 1;
        if (scAddressLength != 0) {
            length = length + 2 + scAddressLength;
        }
        return length;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$sendSmsAckForEnvelopeResponse(IccIoResult response, int dcs, int pid) {
        byte[] smsAckPdu;
        boolean success;
        int sw1 = response.sw1;
        int sw2 = response.sw2;
        if (sw1 == 144 && sw2 == 0 || sw1 == 145) {
            Rlog.d("UsimDataDownloadHandler", "USIM data download succeeded: " + response.toString());
            success = true;
        } else {
            if (sw1 == 147 && sw2 == 0) {
                Rlog.e("UsimDataDownloadHandler", "USIM data download failed: Toolkit busy");
                this.acknowledgeSmsWithError(212);
                return;
            }
            if (sw1 == 98 || sw1 == 99) {
                Rlog.e("UsimDataDownloadHandler", "USIM data download failed: " + response.toString());
                success = false;
            } else {
                Rlog.e("UsimDataDownloadHandler", "Unexpected SW1/SW2 response from UICC: " + response.toString());
                success = false;
            }
        }
        byte[] responseBytes = response.payload;
        if (responseBytes == null || responseBytes.length == 0) {
            if (success) {
                this.mCi.acknowledgeLastIncomingGsmSms(true, 0, null);
            } else {
                this.acknowledgeSmsWithError(213);
            }
            return;
        }
        int index = 0;
        if (success) {
            smsAckPdu = new byte[responseBytes.length + 5];
            smsAckPdu[index++] = 0;
            smsAckPdu[index++] = 7;
        } else {
            smsAckPdu = new byte[responseBytes.length + 6];
            smsAckPdu[index++] = 0;
            smsAckPdu[index++] = -43;
            smsAckPdu[index++] = 7;
        }
        smsAckPdu[index++] = (byte)pid;
        smsAckPdu[index++] = (byte)dcs;
        if (UsimDataDownloadHandler.is7bitDcs(dcs)) {
            int septetCount = responseBytes.length * 8 / 7;
            smsAckPdu[index++] = (byte)septetCount;
        } else {
            smsAckPdu[index++] = (byte)responseBytes.length;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])responseBytes, (int)0, (byte[])smsAckPdu, (int)index, (int)responseBytes.length);
        this.mCi.acknowledgeIncomingGsmSmsWithPdu(success, IccUtils.bytesToHexString(smsAckPdu), null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$acknowledgeSmsWithError(int cause) {
        this.mCi.acknowledgeLastIncomingGsmSms(false, cause, null);
    }

    private static final boolean $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$is7bitDcs(int dcs) {
        return (dcs & 0x8C) == 0 || (dcs & 0xF4) == 240;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleDataDownload((SmsMessage)msg.obj);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.e("UsimDataDownloadHandler", "UICC Send Envelope failure, exception: " + ar.exception);
                    this.acknowledgeSmsWithError(213);
                    return;
                }
                int[] dcsPid = (int[])ar.userObj;
                this.sendSmsAckForEnvelopeResponse((IccIoResult)ar.result, dcsPid[0], dcsPid[1]);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    Rlog.d("UsimDataDownloadHandler", "Successfully wrote SMS-PP message to UICC");
                    this.mCi.acknowledgeLastIncomingGsmSms(true, 0, null);
                    break;
                }
                Rlog.d("UsimDataDownloadHandler", "Failed to write SMS-PP message to UICC", ar.exception);
                this.mCi.acknowledgeLastIncomingGsmSms(false, 255, null);
                break;
            }
            default: {
                Rlog.e("UsimDataDownloadHandler", "Ignoring unexpected message, what=" + msg.what);
            }
        }
    }

    private void __constructor__(CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$__constructor__(commandsInterface);
    }

    public UsimDataDownloadHandler(CommandsInterface commandsInterface) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$__constructor__(com.android.internal.telephony.CommandsInterface ), this, commandsInterface);
    }

    int handleUsimDataDownload(UsimServiceTable usimServiceTable, SmsMessage smsMessage) {
        return (int)InvokeDynamicSupport.bootstrap("handleUsimDataDownload", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$handleUsimDataDownload(com.android.internal.telephony.uicc.UsimServiceTable com.android.internal.telephony.gsm.SmsMessage ), this, usimServiceTable, smsMessage);
    }

    public int startDataDownload(SmsMessage smsMessage) {
        return (int)InvokeDynamicSupport.bootstrap("startDataDownload", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$startDataDownload(com.android.internal.telephony.gsm.SmsMessage ), this, smsMessage);
    }

    private void handleDataDownload(SmsMessage smsMessage) {
        InvokeDynamicSupport.bootstrap("handleDataDownload", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$handleDataDownload(com.android.internal.telephony.gsm.SmsMessage ), this, smsMessage);
    }

    private static int getEnvelopeBodyLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getEnvelopeBodyLength", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$getEnvelopeBodyLength(int int ), (int)n, (int)n2);
    }

    private void sendSmsAckForEnvelopeResponse(IccIoResult iccIoResult, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendSmsAckForEnvelopeResponse", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$sendSmsAckForEnvelopeResponse(com.android.internal.telephony.uicc.IccIoResult int int ), this, iccIoResult, n, n2);
    }

    private void acknowledgeSmsWithError(int n) {
        InvokeDynamicSupport.bootstrap("acknowledgeSmsWithError", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$acknowledgeSmsWithError(int ), this, n);
    }

    private static boolean is7bitDcs(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is7bitDcs", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$is7bitDcs(int ), (int)n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_UsimDataDownloadHandler$handleMessage(android.os.Message ), this, message);
    }

    public /* synthetic */ UsimDataDownloadHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsimDataDownloadHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

