/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.euicc.GetDefaultDownloadableSubscriptionListResult;
import android.service.euicc.GetDownloadableSubscriptionMetadataResult;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccConnector;
import com.android.internal.telephony.euicc.EuiccOperation;
import com.android.internal.telephony.euicc.IEuiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EuiccController
extends IEuiccController.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "EuiccController";
    @VisibleForTesting
    static String EXTRA_OPERATION = "operation";
    private static int OK = 0;
    private static int RESOLVABLE_ERROR = 1;
    private static int ERROR = 2;
    private static String EXTRA_EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION";
    private static EuiccController sInstance;
    private Context mContext;
    private EuiccConnector mConnector;
    private SubscriptionManager mSubscriptionManager;
    private AppOpsManager mAppOpsManager;
    private PackageManager mPackageManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EuiccController $$robo$$com_android_internal_telephony_euicc_EuiccController$init(Context context) {
        Class<EuiccController> clazz = EuiccController.class;
        synchronized (EuiccController.class) {
            if (sInstance == null) {
                sInstance = new EuiccController(context);
            } else {
                Log.wtf("EuiccController", "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final EuiccController $$robo$$com_android_internal_telephony_euicc_EuiccController$get() {
        if (sInstance != null) return sInstance;
        Class<EuiccController> clazz = EuiccController.class;
        synchronized (EuiccController.class) {
            if (sInstance != null) return sInstance;
            throw new IllegalStateException("get() called before init()");
        }
    }

    private void $$robo$$com_android_internal_telephony_euicc_EuiccController$__constructor__(Context context) {
        ServiceManager.addService("econtroller", this);
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_euicc_EuiccController$__constructor__(Context context, EuiccConnector connector) {
        this.mContext = context;
        this.mConnector = connector;
        this.mSubscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
        this.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
        this.mPackageManager = context.getPackageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$continueOperation(Intent resolutionIntent, Bundle resolutionExtras) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to continue operation");
        }
        long token = Binder.clearCallingIdentity();
        try {
            EuiccOperation op = (EuiccOperation)resolutionIntent.getParcelableExtra("operation");
            if (op == null) {
                throw new IllegalArgumentException("Invalid resolution intent");
            }
            PendingIntent callbackIntent = (PendingIntent)resolutionIntent.getParcelableExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_CALLBACK_INTENT");
            op.continueOperation(resolutionExtras, callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_euicc_EuiccController$getEid() {
        if (!this.callerCanReadPhoneStatePrivileged() && !this.callerHasCarrierPrivilegesForActiveSubscription()) {
            throw new SecurityException("Must have carrier privileges on active subscription to read EID");
        }
        long token = Binder.clearCallingIdentity();
        try {
            String string2 = this.blockingGetEidFromEuiccService();
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_euicc_EuiccController$getOtaStatus() {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get OTA status");
        }
        long token = Binder.clearCallingIdentity();
        try {
            int n = this.blockingGetOtaStatusFromEuiccService();
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$startOtaUpdatingIfNecessary() {
        this.mConnector.startOtaIfNecessary(new EuiccConnector.OtaStatusChangedCallback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_1$__constructor__(EuiccController this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_1$onOtaStatusChanged(int status) {
                this.this$0.sendOtaStatusChangedBroadcast();
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_1$onEuiccServiceUnavailable() {
            }

            private void __constructor__(EuiccController euiccController) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_1$__constructor__(euiccController);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_1$__constructor__(com.android.internal.telephony.euicc.EuiccController ), this, euiccController);
            }

            @Override
            public void onOtaStatusChanged(int n) {
                InvokeDynamicSupport.bootstrap("onOtaStatusChanged", $$robo$$com_android_internal_telephony_euicc_EuiccController_1$onOtaStatusChanged(int ), this, n);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_1$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$getDownloadableSubscriptionMetadata(DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) {
        this.getDownloadableSubscriptionMetadata(subscription, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$getDownloadableSubscriptionMetadata(DownloadableSubscription subscription, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get metadata");
        }
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.getDownloadableSubscriptionMetadata(subscription, forceDeactivateSim, new GetMetadataCommandCallback(this, token, subscription, callingPackage, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$downloadSubscription(DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, PendingIntent callbackIntent) {
        this.downloadSubscription(subscription, switchAfterDownload, callingPackage, false, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$downloadSubscription(DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, boolean forceDeactivateSim, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            if (callerCanWriteEmbeddedSubscriptions) {
                this.downloadSubscriptionPrivileged(token, subscription, switchAfterDownload, forceDeactivateSim, callingPackage, callbackIntent);
                return;
            }
            this.mConnector.getDownloadableSubscriptionMetadata(subscription, forceDeactivateSim, new DownloadSubscriptionGetMetadataCommandCallback(this, token, subscription, switchAfterDownload, callingPackage, forceDeactivateSim, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$downloadSubscriptionPrivileged(long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        this.mConnector.downloadSubscription(subscription, switchAfterDownload, forceDeactivateSim, new EuiccConnector.DownloadCommandCallback(this, subscription, switchAfterDownload, callbackIntent, callingPackage, callingToken){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DownloadableSubscription val$subscription;
            /* synthetic */ boolean val$switchAfterDownload;
            /* synthetic */ PendingIntent val$callbackIntent;
            /* synthetic */ String val$callingPackage;
            /* synthetic */ long val$callingToken;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_2$__constructor__(EuiccController this$0, DownloadableSubscription downloadableSubscription, boolean bl, PendingIntent pendingIntent, String string2, long l) {
                this.this$0 = this$0;
                this.val$subscription = downloadableSubscription;
                this.val$switchAfterDownload = bl;
                this.val$callbackIntent = pendingIntent;
                this.val$callingPackage = string2;
                this.val$callingToken = l;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_2$onDownloadComplete(int result) {
                int resultCode;
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        resultCode = 0;
                        Settings.Global.putInt(this.this$0.mContext.getContentResolver(), "euicc_provisioned", 1);
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION", this.val$subscription);
                        if (this.val$switchAfterDownload) break;
                        this.this$0.refreshSubscriptionsAndSendResult(this.val$callbackIntent, resultCode, extrasIntent);
                        return;
                    }
                    case -1: {
                        resultCode = 1;
                        this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.val$callingPackage, false, EuiccOperation.forDownloadDeactivateSim(this.val$callingToken, this.val$subscription, this.val$switchAfterDownload, this.val$callingPackage));
                        break;
                    }
                    case -2: {
                        resultCode = 1;
                        boolean retried = false;
                        if (!TextUtils.isEmpty(this.val$subscription.getConfirmationCode())) {
                            retried = true;
                        }
                        this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_CONFIRMATION_CODE", this.val$callingPackage, retried, EuiccOperation.forDownloadConfirmationCode(this.val$callingToken, this.val$subscription, this.val$switchAfterDownload, this.val$callingPackage));
                        break;
                    }
                    default: {
                        resultCode = 2;
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    }
                }
                this.this$0.sendResult(this.val$callbackIntent, resultCode, extrasIntent);
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_2$onEuiccServiceUnavailable() {
                this.this$0.sendResult(this.val$callbackIntent, 2, null);
            }

            private void __constructor__(EuiccController euiccController, DownloadableSubscription downloadableSubscription, boolean bl, PendingIntent pendingIntent, String string2, long l) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_2$__constructor__(euiccController, downloadableSubscription, bl, pendingIntent, string2, l);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_2$__constructor__(com.android.internal.telephony.euicc.EuiccController android.telephony.euicc.DownloadableSubscription boolean android.app.PendingIntent java.lang.String long ), this, euiccController, downloadableSubscription, bl, pendingIntent, string2, l);
            }

            @Override
            public void onDownloadComplete(int n) {
                InvokeDynamicSupport.bootstrap("onDownloadComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_2$onDownloadComplete(int ), this, n);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_2$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final GetEuiccProfileInfoListResult $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetEuiccProfileInfoList() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference resultRef = new AtomicReference();
        this.mConnector.getEuiccProfileInfoList(new EuiccConnector.GetEuiccProfileInfoListCommandCallback(this, resultRef, latch){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AtomicReference val$resultRef;
            /* synthetic */ CountDownLatch val$latch;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_3$__constructor__(EuiccController this$0, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.this$0 = this$0;
                this.val$resultRef = atomicReference;
                this.val$latch = countDownLatch;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_3$onListComplete(GetEuiccProfileInfoListResult result) {
                this.val$resultRef.set(result);
                this.val$latch.countDown();
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_3$onEuiccServiceUnavailable() {
                this.val$latch.countDown();
            }

            private void __constructor__(EuiccController euiccController, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_3$__constructor__(euiccController, atomicReference, countDownLatch);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_3$__constructor__(com.android.internal.telephony.euicc.EuiccController java.util.concurrent.atomic.AtomicReference java.util.concurrent.CountDownLatch ), this, euiccController, atomicReference, countDownLatch);
            }

            @Override
            public void onListComplete(GetEuiccProfileInfoListResult getEuiccProfileInfoListResult) {
                InvokeDynamicSupport.bootstrap("onListComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_3$onListComplete(android.service.euicc.GetEuiccProfileInfoListResult ), this, getEuiccProfileInfoListResult);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_3$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (GetEuiccProfileInfoListResult)resultRef.get();
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$getDefaultDownloadableSubscriptionList(String callingPackage, PendingIntent callbackIntent) {
        this.getDefaultDownloadableSubscriptionList(false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$getDefaultDownloadableSubscriptionList(boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get default list");
        }
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.getDefaultDownloadableSubscriptionList(forceDeactivateSim, new GetDefaultListCommandCallback(this, token, callingPackage, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EuiccInfo $$robo$$com_android_internal_telephony_euicc_EuiccController$getEuiccInfo() {
        long token = Binder.clearCallingIdentity();
        try {
            EuiccInfo euiccInfo = this.blockingGetEuiccInfoFromEuiccService();
            return euiccInfo;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$deleteSubscription(int subscriptionId, String callingPackage, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
            if (sub == null) {
                Log.e("EuiccController", "Cannot delete nonexistent subscription: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            if (!callerCanWriteEmbeddedSubscriptions && !sub.canManageSubscription(this.mContext, callingPackage)) {
                Log.e("EuiccController", "No permissions: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            this.deleteSubscriptionPrivileged(sub.getIccId(), callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$deleteSubscriptionPrivileged(String iccid, PendingIntent callbackIntent) {
        this.mConnector.deleteSubscription(iccid, new EuiccConnector.DeleteCommandCallback(this, callbackIntent){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PendingIntent val$callbackIntent;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_4$__constructor__(EuiccController this$0, PendingIntent pendingIntent) {
                this.this$0 = this$0;
                this.val$callbackIntent = pendingIntent;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_4$onDeleteComplete(int result) {
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        int resultCode = 0;
                        this.this$0.refreshSubscriptionsAndSendResult(this.val$callbackIntent, resultCode, extrasIntent);
                        return;
                    }
                }
                int resultCode = 2;
                extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                this.this$0.sendResult(this.val$callbackIntent, resultCode, extrasIntent);
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_4$onEuiccServiceUnavailable() {
                this.this$0.sendResult(this.val$callbackIntent, 2, null);
            }

            private void __constructor__(EuiccController euiccController, PendingIntent pendingIntent) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_4$__constructor__(euiccController, pendingIntent);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_4$__constructor__(com.android.internal.telephony.euicc.EuiccController android.app.PendingIntent ), this, euiccController, pendingIntent);
            }

            @Override
            public void onDeleteComplete(int n) {
                InvokeDynamicSupport.bootstrap("onDeleteComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_4$onDeleteComplete(int ), this, n);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_4$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscription(int subscriptionId, String callingPackage, PendingIntent callbackIntent) {
        this.switchToSubscription(subscriptionId, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscription(int subscriptionId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            String iccid;
            if (callerCanWriteEmbeddedSubscriptions) {
                forceDeactivateSim = true;
            }
            if (subscriptionId == -1) {
                if (!callerCanWriteEmbeddedSubscriptions) {
                    Log.e("EuiccController", "Not permitted to switch to empty subscription");
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                iccid = null;
            } else {
                SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
                if (sub == null) {
                    Log.e("EuiccController", "Cannot switch to nonexistent subscription: " + subscriptionId);
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                if (!callerCanWriteEmbeddedSubscriptions && !this.mSubscriptionManager.canManageSubscription(sub, callingPackage)) {
                    Log.e("EuiccController", "Not permitted to switch to subscription: " + subscriptionId);
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                iccid = sub.getIccId();
            }
            if (!callerCanWriteEmbeddedSubscriptions && !this.canManageActiveSubscription(callingPackage)) {
                Intent extrasIntent = new Intent();
                this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", callingPackage, false, EuiccOperation.forSwitchNoPrivileges(token, subscriptionId, callingPackage));
                this.sendResult(callbackIntent, 1, extrasIntent);
                return;
            }
            this.switchToSubscriptionPrivileged(token, subscriptionId, iccid, forceDeactivateSim, callingPackage, callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscriptionPrivileged(long callingToken, int subscriptionId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        String iccid = null;
        SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
        if (sub != null) {
            iccid = sub.getIccId();
        }
        this.switchToSubscriptionPrivileged(callingToken, subscriptionId, iccid, forceDeactivateSim, callingPackage, callbackIntent);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscriptionPrivileged(long callingToken, int subscriptionId, String iccid, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        this.mConnector.switchToSubscription(iccid, forceDeactivateSim, new EuiccConnector.SwitchCommandCallback(this, callingPackage, callingToken, subscriptionId, callbackIntent){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$callingPackage;
            /* synthetic */ long val$callingToken;
            /* synthetic */ int val$subscriptionId;
            /* synthetic */ PendingIntent val$callbackIntent;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_5$__constructor__(EuiccController this$0, String string2, long l, int n, PendingIntent pendingIntent) {
                this.this$0 = this$0;
                this.val$callingPackage = string2;
                this.val$callingToken = l;
                this.val$subscriptionId = n;
                this.val$callbackIntent = pendingIntent;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_5$onSwitchComplete(int result) {
                int resultCode;
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        resultCode = 0;
                        break;
                    }
                    case -1: {
                        resultCode = 1;
                        this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.val$callingPackage, false, EuiccOperation.forSwitchDeactivateSim(this.val$callingToken, this.val$subscriptionId, this.val$callingPackage));
                        break;
                    }
                    default: {
                        resultCode = 2;
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    }
                }
                this.this$0.sendResult(this.val$callbackIntent, resultCode, extrasIntent);
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_5$onEuiccServiceUnavailable() {
                this.this$0.sendResult(this.val$callbackIntent, 2, null);
            }

            private void __constructor__(EuiccController euiccController, String string2, long l, int n, PendingIntent pendingIntent) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_5$__constructor__(euiccController, string2, l, n, pendingIntent);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_5$__constructor__(com.android.internal.telephony.euicc.EuiccController java.lang.String long int android.app.PendingIntent ), this, euiccController, string2, l, n, pendingIntent);
            }

            @Override
            public void onSwitchComplete(int n) {
                InvokeDynamicSupport.bootstrap("onSwitchComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_5$onSwitchComplete(int ), this, n);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_5$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$updateSubscriptionNickname(int subscriptionId, String nickname, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to update nickname");
        }
        long token = Binder.clearCallingIdentity();
        try {
            SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
            if (sub == null) {
                Log.e("EuiccController", "Cannot update nickname to nonexistent subscription: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            this.mConnector.updateSubscriptionNickname(sub.getIccId(), nickname, new EuiccConnector.UpdateNicknameCommandCallback(this, callbackIntent){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PendingIntent val$callbackIntent;
                /* synthetic */ EuiccController this$0;

                private void $$robo$$com_android_internal_telephony_euicc_EuiccController_6$__constructor__(EuiccController this$0, PendingIntent pendingIntent) {
                    this.this$0 = this$0;
                    this.val$callbackIntent = pendingIntent;
                }

                private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_6$onUpdateNicknameComplete(int result) {
                    int resultCode;
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            resultCode = 0;
                            break;
                        }
                        default: {
                            resultCode = 2;
                            extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                        }
                    }
                    this.this$0.sendResult(this.val$callbackIntent, resultCode, extrasIntent);
                }

                private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_6$onEuiccServiceUnavailable() {
                    this.this$0.sendResult(this.val$callbackIntent, 2, null);
                }

                private void __constructor__(EuiccController euiccController, PendingIntent pendingIntent) {
                    this.$$robo$$com_android_internal_telephony_euicc_EuiccController_6$__constructor__(euiccController, pendingIntent);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_6$__constructor__(com.android.internal.telephony.euicc.EuiccController android.app.PendingIntent ), this, euiccController, pendingIntent);
                }

                @Override
                public void onUpdateNicknameComplete(int n) {
                    InvokeDynamicSupport.bootstrap("onUpdateNicknameComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_6$onUpdateNicknameComplete(int ), this, n);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_6$onEuiccServiceUnavailable(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$eraseSubscriptions(PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to erase subscriptions");
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.eraseSubscriptions(new EuiccConnector.EraseCommandCallback(this, callbackIntent){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PendingIntent val$callbackIntent;
                /* synthetic */ EuiccController this$0;

                private void $$robo$$com_android_internal_telephony_euicc_EuiccController_7$__constructor__(EuiccController this$0, PendingIntent pendingIntent) {
                    this.this$0 = this$0;
                    this.val$callbackIntent = pendingIntent;
                }

                private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_7$onEraseComplete(int result) {
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            int resultCode = 0;
                            this.this$0.refreshSubscriptionsAndSendResult(this.val$callbackIntent, resultCode, extrasIntent);
                            return;
                        }
                    }
                    int resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    this.this$0.sendResult(this.val$callbackIntent, resultCode, extrasIntent);
                }

                private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_7$onEuiccServiceUnavailable() {
                    this.this$0.sendResult(this.val$callbackIntent, 2, null);
                }

                private void __constructor__(EuiccController euiccController, PendingIntent pendingIntent) {
                    this.$$robo$$com_android_internal_telephony_euicc_EuiccController_7$__constructor__(euiccController, pendingIntent);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_7$__constructor__(com.android.internal.telephony.euicc.EuiccController android.app.PendingIntent ), this, euiccController, pendingIntent);
                }

                @Override
                public void onEraseComplete(int n) {
                    InvokeDynamicSupport.bootstrap("onEraseComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_7$onEraseComplete(int ), this, n);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_7$onEuiccServiceUnavailable(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$retainSubscriptionsForFactoryReset(PendingIntent callbackIntent) {
        this.mContext.enforceCallingPermission("android.permission.MASTER_CLEAR", "Must have MASTER_CLEAR to retain subscriptions for factory reset");
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.retainSubscriptions(new EuiccConnector.RetainSubscriptionsCommandCallback(this, callbackIntent){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PendingIntent val$callbackIntent;
                /* synthetic */ EuiccController this$0;

                private void $$robo$$com_android_internal_telephony_euicc_EuiccController_8$__constructor__(EuiccController this$0, PendingIntent pendingIntent) {
                    this.this$0 = this$0;
                    this.val$callbackIntent = pendingIntent;
                }

                private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_8$onRetainSubscriptionsComplete(int result) {
                    int resultCode;
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            resultCode = 0;
                            break;
                        }
                        default: {
                            resultCode = 2;
                            extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                        }
                    }
                    this.this$0.sendResult(this.val$callbackIntent, resultCode, extrasIntent);
                }

                private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_8$onEuiccServiceUnavailable() {
                    this.this$0.sendResult(this.val$callbackIntent, 2, null);
                }

                private void __constructor__(EuiccController euiccController, PendingIntent pendingIntent) {
                    this.$$robo$$com_android_internal_telephony_euicc_EuiccController_8$__constructor__(euiccController, pendingIntent);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_8$__constructor__(com.android.internal.telephony.euicc.EuiccController android.app.PendingIntent ), this, euiccController, pendingIntent);
                }

                @Override
                public void onRetainSubscriptionsComplete(int n) {
                    InvokeDynamicSupport.bootstrap("onRetainSubscriptionsComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_8$onRetainSubscriptionsComplete(int ), this, n);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_8$onEuiccServiceUnavailable(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$refreshSubscriptionsAndSendResult(PendingIntent callbackIntent, int resultCode, Intent extrasIntent) {
        SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh(() -> this.sendResult(callbackIntent, resultCode, extrasIntent));
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$sendResult(PendingIntent callbackIntent, int resultCode, Intent extrasIntent) {
        try {
            callbackIntent.send(this.mContext, resultCode, extrasIntent);
        }
        catch (PendingIntent.CanceledException canceledException) {
            // empty catch block
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$addResolutionIntent(Intent extrasIntent, String resolutionAction, String callingPackage, boolean confirmationCodeRetried, EuiccOperation op) {
        Intent intent = new Intent("android.telephony.euicc.action.RESOLVE_ERROR");
        intent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_ACTION", resolutionAction);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CALLING_PACKAGE", callingPackage);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CONFIRMATION_CODE_RETRIED", confirmationCodeRetried);
        intent.putExtra("operation", op);
        PendingIntent resolutionIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0x40000000);
        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_INTENT", resolutionIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.dump(fd, pw, args);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccController$sendOtaStatusChangedBroadcast() {
        Intent intent = new Intent("android.telephony.euicc.action.OTA_STATUS_CHANGED");
        ComponentInfo bestComponent = EuiccConnector.findBestComponent(this.mContext.getPackageManager());
        if (bestComponent != null) {
            intent.setPackage(bestComponent.packageName);
        }
        this.mContext.sendBroadcast(intent, "android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS");
    }

    private final SubscriptionInfo $$robo$$com_android_internal_telephony_euicc_EuiccController$getSubscriptionForSubscriptionId(int subscriptionId) {
        List<SubscriptionInfo> subs = this.mSubscriptionManager.getAvailableSubscriptionInfoList();
        int subCount = subs.size();
        for (int i = 0; i < subCount; ++i) {
            SubscriptionInfo sub = subs.get(i);
            if (subscriptionId != sub.getSubscriptionId()) continue;
            return sub;
        }
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetEidFromEuiccService() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference eidRef = new AtomicReference();
        this.mConnector.getEid(new EuiccConnector.GetEidCommandCallback(this, eidRef, latch){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AtomicReference val$eidRef;
            /* synthetic */ CountDownLatch val$latch;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_9$__constructor__(EuiccController this$0, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.this$0 = this$0;
                this.val$eidRef = atomicReference;
                this.val$latch = countDownLatch;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_9$onGetEidComplete(String eid) {
                this.val$eidRef.set(eid);
                this.val$latch.countDown();
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_9$onEuiccServiceUnavailable() {
                this.val$latch.countDown();
            }

            private void __constructor__(EuiccController euiccController, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_9$__constructor__(euiccController, atomicReference, countDownLatch);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_9$__constructor__(com.android.internal.telephony.euicc.EuiccController java.util.concurrent.atomic.AtomicReference java.util.concurrent.CountDownLatch ), this, euiccController, atomicReference, countDownLatch);
            }

            @Override
            public void onGetEidComplete(String string2) {
                InvokeDynamicSupport.bootstrap("onGetEidComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_9$onGetEidComplete(java.lang.String ), this, string2);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_9$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return (String)EuiccController.awaitResult(latch, eidRef);
    }

    private final int $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetOtaStatusFromEuiccService() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<Integer> statusRef = new AtomicReference<Integer>(5);
        this.mConnector.getOtaStatus(new EuiccConnector.GetOtaStatusCommandCallback(this, statusRef, latch){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AtomicReference val$statusRef;
            /* synthetic */ CountDownLatch val$latch;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_10$__constructor__(EuiccController this$0, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.this$0 = this$0;
                this.val$statusRef = atomicReference;
                this.val$latch = countDownLatch;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_10$onGetOtaStatusComplete(int status) {
                this.val$statusRef.set(status);
                this.val$latch.countDown();
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_10$onEuiccServiceUnavailable() {
                this.val$latch.countDown();
            }

            private void __constructor__(EuiccController euiccController, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_10$__constructor__(euiccController, atomicReference, countDownLatch);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_10$__constructor__(com.android.internal.telephony.euicc.EuiccController java.util.concurrent.atomic.AtomicReference java.util.concurrent.CountDownLatch ), this, euiccController, atomicReference, countDownLatch);
            }

            @Override
            public void onGetOtaStatusComplete(int n) {
                InvokeDynamicSupport.bootstrap("onGetOtaStatusComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_10$onGetOtaStatusComplete(int ), this, n);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_10$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return EuiccController.awaitResult(latch, statusRef);
    }

    private final EuiccInfo $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetEuiccInfoFromEuiccService() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference euiccInfoRef = new AtomicReference();
        this.mConnector.getEuiccInfo(new EuiccConnector.GetEuiccInfoCommandCallback(this, euiccInfoRef, latch){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AtomicReference val$euiccInfoRef;
            /* synthetic */ CountDownLatch val$latch;
            /* synthetic */ EuiccController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccController_11$__constructor__(EuiccController this$0, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.this$0 = this$0;
                this.val$euiccInfoRef = atomicReference;
                this.val$latch = countDownLatch;
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_11$onGetEuiccInfoComplete(EuiccInfo euiccInfo) {
                this.val$euiccInfoRef.set(euiccInfo);
                this.val$latch.countDown();
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_11$onEuiccServiceUnavailable() {
                this.val$latch.countDown();
            }

            private void __constructor__(EuiccController euiccController, AtomicReference atomicReference, CountDownLatch countDownLatch) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccController_11$__constructor__(euiccController, atomicReference, countDownLatch);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_11$__constructor__(com.android.internal.telephony.euicc.EuiccController java.util.concurrent.atomic.AtomicReference java.util.concurrent.CountDownLatch ), this, euiccController, atomicReference, countDownLatch);
            }

            @Override
            public void onGetEuiccInfoComplete(EuiccInfo euiccInfo) {
                InvokeDynamicSupport.bootstrap("onGetEuiccInfoComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_11$onGetEuiccInfoComplete(android.telephony.euicc.EuiccInfo ), this, euiccInfo);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_11$onEuiccServiceUnavailable(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return (EuiccInfo)EuiccController.awaitResult(latch, euiccInfoRef);
    }

    private static final <T> T $$robo$$com_android_internal_telephony_euicc_EuiccController$awaitResult(CountDownLatch latch, AtomicReference<T> resultRef) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return resultRef.get();
    }

    private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccController$canManageActiveSubscription(String callingPackage) {
        List<SubscriptionInfo> subInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        if (subInfoList == null) {
            return false;
        }
        int size = subInfoList.size();
        for (int subIndex = 0; subIndex < size; ++subIndex) {
            SubscriptionInfo subInfo = subInfoList.get(subIndex);
            if (!subInfo.isEmbedded() || !this.mSubscriptionManager.canManageSubscription(subInfo, callingPackage)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccController$callerCanReadPhoneStatePrivileged() {
        return this.mContext.checkCallingPermission("android.permission.READ_PRIVILEGED_PHONE_STATE") == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccController$callerCanWriteEmbeddedSubscriptions() {
        return this.mContext.checkCallingPermission("android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS") == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccController$callerHasCarrierPrivilegesForActiveSubscription() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        return tm.hasCarrierPrivileges();
    }

    public static EuiccController init(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("init", $$robo$$com_android_internal_telephony_euicc_EuiccController$init(android.content.Context ), (Context)context);
    }

    public static EuiccController get() {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$com_android_internal_telephony_euicc_EuiccController$get());
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccController$__constructor__(context);
    }

    public EuiccController(Context context) {
        this(context, new EuiccConnector(context));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, EuiccConnector euiccConnector) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccController$__constructor__(context, euiccConnector);
    }

    public EuiccController(Context context, EuiccConnector euiccConnector) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController$__constructor__(android.content.Context com.android.internal.telephony.euicc.EuiccConnector ), this, context, euiccConnector);
    }

    @Override
    public void continueOperation(Intent intent, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("continueOperation", $$robo$$com_android_internal_telephony_euicc_EuiccController$continueOperation(android.content.Intent android.os.Bundle ), this, intent, bundle);
    }

    @Override
    public String getEid() {
        return InvokeDynamicSupport.bootstrap("getEid", $$robo$$com_android_internal_telephony_euicc_EuiccController$getEid(), this);
    }

    @Override
    public int getOtaStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getOtaStatus", $$robo$$com_android_internal_telephony_euicc_EuiccController$getOtaStatus(), this);
    }

    public void startOtaUpdatingIfNecessary() {
        InvokeDynamicSupport.bootstrap("startOtaUpdatingIfNecessary", $$robo$$com_android_internal_telephony_euicc_EuiccController$startOtaUpdatingIfNecessary(), this);
    }

    @Override
    public void getDownloadableSubscriptionMetadata(DownloadableSubscription downloadableSubscription, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("getDownloadableSubscriptionMetadata", $$robo$$com_android_internal_telephony_euicc_EuiccController$getDownloadableSubscriptionMetadata(android.telephony.euicc.DownloadableSubscription java.lang.String android.app.PendingIntent ), this, downloadableSubscription, string2, pendingIntent);
    }

    void getDownloadableSubscriptionMetadata(DownloadableSubscription downloadableSubscription, boolean bl, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("getDownloadableSubscriptionMetadata", $$robo$$com_android_internal_telephony_euicc_EuiccController$getDownloadableSubscriptionMetadata(android.telephony.euicc.DownloadableSubscription boolean java.lang.String android.app.PendingIntent ), this, downloadableSubscription, bl, string2, pendingIntent);
    }

    @Override
    public void downloadSubscription(DownloadableSubscription downloadableSubscription, boolean bl, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("downloadSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$downloadSubscription(android.telephony.euicc.DownloadableSubscription boolean java.lang.String android.app.PendingIntent ), this, downloadableSubscription, bl, string2, pendingIntent);
    }

    void downloadSubscription(DownloadableSubscription downloadableSubscription, boolean bl, String string2, boolean bl2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("downloadSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$downloadSubscription(android.telephony.euicc.DownloadableSubscription boolean java.lang.String boolean android.app.PendingIntent ), this, downloadableSubscription, bl, string2, bl2, pendingIntent);
    }

    void downloadSubscriptionPrivileged(long l, DownloadableSubscription downloadableSubscription, boolean bl, boolean bl2, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("downloadSubscriptionPrivileged", $$robo$$com_android_internal_telephony_euicc_EuiccController$downloadSubscriptionPrivileged(long android.telephony.euicc.DownloadableSubscription boolean boolean java.lang.String android.app.PendingIntent ), this, l, downloadableSubscription, bl, bl2, string2, pendingIntent);
    }

    public GetEuiccProfileInfoListResult blockingGetEuiccProfileInfoList() {
        return InvokeDynamicSupport.bootstrap("blockingGetEuiccProfileInfoList", $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetEuiccProfileInfoList(), this);
    }

    @Override
    public void getDefaultDownloadableSubscriptionList(String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("getDefaultDownloadableSubscriptionList", $$robo$$com_android_internal_telephony_euicc_EuiccController$getDefaultDownloadableSubscriptionList(java.lang.String android.app.PendingIntent ), this, string2, pendingIntent);
    }

    void getDefaultDownloadableSubscriptionList(boolean bl, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("getDefaultDownloadableSubscriptionList", $$robo$$com_android_internal_telephony_euicc_EuiccController$getDefaultDownloadableSubscriptionList(boolean java.lang.String android.app.PendingIntent ), this, bl, string2, pendingIntent);
    }

    @Override
    public EuiccInfo getEuiccInfo() {
        return InvokeDynamicSupport.bootstrap("getEuiccInfo", $$robo$$com_android_internal_telephony_euicc_EuiccController$getEuiccInfo(), this);
    }

    @Override
    public void deleteSubscription(int n, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("deleteSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$deleteSubscription(int java.lang.String android.app.PendingIntent ), this, n, string2, pendingIntent);
    }

    void deleteSubscriptionPrivileged(String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("deleteSubscriptionPrivileged", $$robo$$com_android_internal_telephony_euicc_EuiccController$deleteSubscriptionPrivileged(java.lang.String android.app.PendingIntent ), this, string2, pendingIntent);
    }

    @Override
    public void switchToSubscription(int n, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("switchToSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscription(int java.lang.String android.app.PendingIntent ), this, n, string2, pendingIntent);
    }

    void switchToSubscription(int n, boolean bl, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("switchToSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscription(int boolean java.lang.String android.app.PendingIntent ), this, n, bl, string2, pendingIntent);
    }

    void switchToSubscriptionPrivileged(long l, int n, boolean bl, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("switchToSubscriptionPrivileged", $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscriptionPrivileged(long int boolean java.lang.String android.app.PendingIntent ), this, l, n, bl, string2, pendingIntent);
    }

    void switchToSubscriptionPrivileged(long l, int n, String string2, boolean bl, String string3, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("switchToSubscriptionPrivileged", $$robo$$com_android_internal_telephony_euicc_EuiccController$switchToSubscriptionPrivileged(long int java.lang.String boolean java.lang.String android.app.PendingIntent ), this, l, n, string2, bl, string3, pendingIntent);
    }

    @Override
    public void updateSubscriptionNickname(int n, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("updateSubscriptionNickname", $$robo$$com_android_internal_telephony_euicc_EuiccController$updateSubscriptionNickname(int java.lang.String android.app.PendingIntent ), this, n, string2, pendingIntent);
    }

    @Override
    public void eraseSubscriptions(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("eraseSubscriptions", $$robo$$com_android_internal_telephony_euicc_EuiccController$eraseSubscriptions(android.app.PendingIntent ), this, pendingIntent);
    }

    @Override
    public void retainSubscriptionsForFactoryReset(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("retainSubscriptionsForFactoryReset", $$robo$$com_android_internal_telephony_euicc_EuiccController$retainSubscriptionsForFactoryReset(android.app.PendingIntent ), this, pendingIntent);
    }

    public void refreshSubscriptionsAndSendResult(PendingIntent pendingIntent, int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("refreshSubscriptionsAndSendResult", $$robo$$com_android_internal_telephony_euicc_EuiccController$refreshSubscriptionsAndSendResult(android.app.PendingIntent int android.content.Intent ), this, pendingIntent, n, intent);
    }

    public void sendResult(PendingIntent pendingIntent, int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("sendResult", $$robo$$com_android_internal_telephony_euicc_EuiccController$sendResult(android.app.PendingIntent int android.content.Intent ), this, pendingIntent, n, intent);
    }

    public void addResolutionIntent(Intent intent, String string2, String string3, boolean bl, EuiccOperation euiccOperation) {
        InvokeDynamicSupport.bootstrap("addResolutionIntent", $$robo$$com_android_internal_telephony_euicc_EuiccController$addResolutionIntent(android.content.Intent java.lang.String java.lang.String boolean com.android.internal.telephony.euicc.EuiccOperation ), this, intent, string2, string3, bl, euiccOperation);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_euicc_EuiccController$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    public void sendOtaStatusChangedBroadcast() {
        InvokeDynamicSupport.bootstrap("sendOtaStatusChangedBroadcast", $$robo$$com_android_internal_telephony_euicc_EuiccController$sendOtaStatusChangedBroadcast(), this);
    }

    private SubscriptionInfo getSubscriptionForSubscriptionId(int n) {
        return InvokeDynamicSupport.bootstrap("getSubscriptionForSubscriptionId", $$robo$$com_android_internal_telephony_euicc_EuiccController$getSubscriptionForSubscriptionId(int ), this, n);
    }

    private String blockingGetEidFromEuiccService() {
        return InvokeDynamicSupport.bootstrap("blockingGetEidFromEuiccService", $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetEidFromEuiccService(), this);
    }

    private int blockingGetOtaStatusFromEuiccService() {
        return (int)InvokeDynamicSupport.bootstrap("blockingGetOtaStatusFromEuiccService", $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetOtaStatusFromEuiccService(), this);
    }

    private EuiccInfo blockingGetEuiccInfoFromEuiccService() {
        return InvokeDynamicSupport.bootstrap("blockingGetEuiccInfoFromEuiccService", $$robo$$com_android_internal_telephony_euicc_EuiccController$blockingGetEuiccInfoFromEuiccService(), this);
    }

    private static <T> T awaitResult(CountDownLatch countDownLatch, AtomicReference<T> atomicReference) {
        return (T)InvokeDynamicSupport.bootstrapStatic("awaitResult", $$robo$$com_android_internal_telephony_euicc_EuiccController$awaitResult(java.util.concurrent.CountDownLatch java.util.concurrent.atomic.AtomicReference<T> ), (CountDownLatch)countDownLatch, atomicReference);
    }

    private boolean canManageActiveSubscription(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("canManageActiveSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$canManageActiveSubscription(java.lang.String ), this, string2);
    }

    private boolean callerCanReadPhoneStatePrivileged() {
        return (boolean)InvokeDynamicSupport.bootstrap("callerCanReadPhoneStatePrivileged", $$robo$$com_android_internal_telephony_euicc_EuiccController$callerCanReadPhoneStatePrivileged(), this);
    }

    private boolean callerCanWriteEmbeddedSubscriptions() {
        return (boolean)InvokeDynamicSupport.bootstrap("callerCanWriteEmbeddedSubscriptions", $$robo$$com_android_internal_telephony_euicc_EuiccController$callerCanWriteEmbeddedSubscriptions(), this);
    }

    private boolean callerHasCarrierPrivilegesForActiveSubscription() {
        return (boolean)InvokeDynamicSupport.bootstrap("callerHasCarrierPrivilegesForActiveSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccController$callerHasCarrierPrivilegesForActiveSubscription(), this);
    }

    public /* synthetic */ EuiccController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class GetDefaultListCommandCallback
    implements EuiccConnector.GetDefaultListCommandCallback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        long mCallingToken;
        String mCallingPackage;
        PendingIntent mCallbackIntent;
        /* synthetic */ EuiccController this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$__constructor__(EuiccController this$0, long callingToken, String callingPackage, PendingIntent callbackIntent) {
            this.this$0 = this$0;
            this.mCallingToken = callingToken;
            this.mCallingPackage = callingPackage;
            this.mCallbackIntent = callbackIntent;
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$onGetDefaultListComplete(GetDefaultDownloadableSubscriptionListResult result) {
            int resultCode;
            Intent extrasIntent = new Intent();
            switch (result.getResult()) {
                case 0: {
                    resultCode = 0;
                    List<DownloadableSubscription> list = result.getDownloadableSubscriptions();
                    if (list == null || list.size() <= 0) break;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTIONS", list.toArray(new DownloadableSubscription[list.size()]));
                    break;
                }
                case -1: {
                    resultCode = 1;
                    this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, false, EuiccOperation.forGetDefaultListDeactivateSim(this.mCallingToken, this.mCallingPackage));
                    break;
                }
                default: {
                    resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.getResult());
                }
            }
            this.this$0.sendResult(this.mCallbackIntent, resultCode, extrasIntent);
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$onEuiccServiceUnavailable() {
            this.this$0.sendResult(this.mCallbackIntent, 2, null);
        }

        private void __constructor__(EuiccController euiccController, long l, String string2, PendingIntent pendingIntent) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$__constructor__(euiccController, l, string2, pendingIntent);
        }

        public GetDefaultListCommandCallback(EuiccController euiccController, long l, String string2, PendingIntent pendingIntent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$__constructor__(com.android.internal.telephony.euicc.EuiccController long java.lang.String android.app.PendingIntent ), this, euiccController, l, string2, pendingIntent);
        }

        @Override
        public void onGetDefaultListComplete(GetDefaultDownloadableSubscriptionListResult getDefaultDownloadableSubscriptionListResult) {
            InvokeDynamicSupport.bootstrap("onGetDefaultListComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$onGetDefaultListComplete(android.service.euicc.GetDefaultDownloadableSubscriptionListResult ), this, getDefaultDownloadableSubscriptionListResult);
        }

        @Override
        public void onEuiccServiceUnavailable() {
            InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetDefaultListCommandCallback$onEuiccServiceUnavailable(), this);
        }

        public /* synthetic */ GetDefaultListCommandCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetDefaultListCommandCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DownloadSubscriptionGetMetadataCommandCallback
    extends GetMetadataCommandCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mSwitchAfterDownload;
        private boolean mForceDeactivateSim;
        /* synthetic */ EuiccController this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$__constructor__(EuiccController this$0, long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, boolean forceDeactivateSim, PendingIntent callbackIntent) {
            this.this$0 = this$0;
            this.mSwitchAfterDownload = switchAfterDownload;
            this.mForceDeactivateSim = forceDeactivateSim;
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult result) {
            PackageInfo info;
            if (result.getResult() == -1) {
                Intent extrasIntent = new Intent();
                this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", this.mCallingPackage, false, EuiccOperation.forDownloadNoPrivileges(this.mCallingToken, this.mSubscription, this.mSwitchAfterDownload, this.mCallingPackage));
                this.this$0.sendResult(this.mCallbackIntent, 1, extrasIntent);
                return;
            }
            if (result.getResult() != 0) {
                super.onGetMetadataComplete(result);
                return;
            }
            DownloadableSubscription subscription = result.getDownloadableSubscription();
            UiccAccessRule[] rules = null;
            List<UiccAccessRule> rulesList = subscription.getAccessRules();
            if (rulesList != null) {
                rules = rulesList.toArray(new UiccAccessRule[rulesList.size()]);
            }
            if (rules == null) {
                Log.e("EuiccController", "No access rules but caller is unprivileged");
                this.this$0.sendResult(this.mCallbackIntent, 2, null);
                return;
            }
            try {
                info = this.this$0.mPackageManager.getPackageInfo(this.mCallingPackage, 64);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e("EuiccController", "Calling package valid but gone");
                this.this$0.sendResult(this.mCallbackIntent, 2, null);
                return;
            }
            for (int i = 0; i < rules.length; ++i) {
                if (rules[i].getCarrierPrivilegeStatus(info) != 1) continue;
                if (this.this$0.canManageActiveSubscription(this.mCallingPackage)) {
                    this.this$0.downloadSubscriptionPrivileged(this.mCallingToken, subscription, this.mSwitchAfterDownload, this.mForceDeactivateSim, this.mCallingPackage, this.mCallbackIntent);
                    return;
                }
                Intent extrasIntent = new Intent();
                this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", this.mCallingPackage, false, EuiccOperation.forDownloadNoPrivileges(this.mCallingToken, subscription, this.mSwitchAfterDownload, this.mCallingPackage));
                this.this$0.sendResult(this.mCallbackIntent, 1, extrasIntent);
                return;
            }
            Log.e("EuiccController", "Caller is not permitted to download this profile");
            this.this$0.sendResult(this.mCallbackIntent, 2, null);
        }

        private final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$getOperationForDeactivateSim() {
            return EuiccOperation.forDownloadDeactivateSim(this.mCallingToken, this.mSubscription, this.mSwitchAfterDownload, this.mCallingPackage);
        }

        private void __constructor__(EuiccController euiccController, long l, DownloadableSubscription downloadableSubscription, boolean bl, String string2, boolean bl2, PendingIntent pendingIntent) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$__constructor__(euiccController, l, downloadableSubscription, bl, string2, bl2, pendingIntent);
        }

        public DownloadSubscriptionGetMetadataCommandCallback(EuiccController euiccController, long l, DownloadableSubscription downloadableSubscription, boolean bl, String string2, boolean bl2, PendingIntent pendingIntent) {
            super(euiccController, l, downloadableSubscription, string2, pendingIntent);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$__constructor__(com.android.internal.telephony.euicc.EuiccController long android.telephony.euicc.DownloadableSubscription boolean java.lang.String boolean android.app.PendingIntent ), this, euiccController, l, downloadableSubscription, bl, string2, bl2, pendingIntent);
        }

        @Override
        public void onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult getDownloadableSubscriptionMetadataResult) {
            InvokeDynamicSupport.bootstrap("onGetMetadataComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$onGetMetadataComplete(android.service.euicc.GetDownloadableSubscriptionMetadataResult ), this, getDownloadableSubscriptionMetadataResult);
        }

        @Override
        protected EuiccOperation getOperationForDeactivateSim() {
            return InvokeDynamicSupport.bootstrap("getOperationForDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccController_DownloadSubscriptionGetMetadataCommandCallback$getOperationForDeactivateSim(), this);
        }

        public /* synthetic */ DownloadSubscriptionGetMetadataCommandCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DownloadSubscriptionGetMetadataCommandCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class GetMetadataCommandCallback
    implements EuiccConnector.GetMetadataCommandCallback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected long mCallingToken;
        protected DownloadableSubscription mSubscription;
        protected String mCallingPackage;
        protected PendingIntent mCallbackIntent;
        /* synthetic */ EuiccController this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$__constructor__(EuiccController this$0, long callingToken, DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) {
            this.this$0 = this$0;
            this.mCallingToken = callingToken;
            this.mSubscription = subscription;
            this.mCallingPackage = callingPackage;
            this.mCallbackIntent = callbackIntent;
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult result) {
            int resultCode;
            Intent extrasIntent = new Intent();
            switch (result.getResult()) {
                case 0: {
                    resultCode = 0;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION", result.getDownloadableSubscription());
                    break;
                }
                case -1: {
                    resultCode = 1;
                    this.this$0.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, false, this.getOperationForDeactivateSim());
                    break;
                }
                default: {
                    resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.getResult());
                }
            }
            this.this$0.sendResult(this.mCallbackIntent, resultCode, extrasIntent);
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$onEuiccServiceUnavailable() {
            this.this$0.sendResult(this.mCallbackIntent, 2, null);
        }

        private final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$getOperationForDeactivateSim() {
            return EuiccOperation.forGetMetadataDeactivateSim(this.mCallingToken, this.mSubscription, this.mCallingPackage);
        }

        private void __constructor__(EuiccController euiccController, long l, DownloadableSubscription downloadableSubscription, String string2, PendingIntent pendingIntent) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$__constructor__(euiccController, l, downloadableSubscription, string2, pendingIntent);
        }

        public GetMetadataCommandCallback(EuiccController euiccController, long l, DownloadableSubscription downloadableSubscription, String string2, PendingIntent pendingIntent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$__constructor__(com.android.internal.telephony.euicc.EuiccController long android.telephony.euicc.DownloadableSubscription java.lang.String android.app.PendingIntent ), this, euiccController, l, downloadableSubscription, string2, pendingIntent);
        }

        @Override
        public void onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult getDownloadableSubscriptionMetadataResult) {
            InvokeDynamicSupport.bootstrap("onGetMetadataComplete", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$onGetMetadataComplete(android.service.euicc.GetDownloadableSubscriptionMetadataResult ), this, getDownloadableSubscriptionMetadataResult);
        }

        @Override
        public void onEuiccServiceUnavailable() {
            InvokeDynamicSupport.bootstrap("onEuiccServiceUnavailable", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$onEuiccServiceUnavailable(), this);
        }

        protected EuiccOperation getOperationForDeactivateSim() {
            return InvokeDynamicSupport.bootstrap("getOperationForDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccController_GetMetadataCommandCallback$getOperationForDeactivateSim(), this);
        }

        public /* synthetic */ GetMetadataCommandCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetMetadataCommandCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

