/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import android.telephony.Rlog;
import com.android.internal.telephony.dataconnection.ApnContext;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class DcRequest
implements Comparable<DcRequest> {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "DcRequest";
    public NetworkRequest networkRequest;
    public int priority;
    public int apnId;
    private static HashMap<Integer, Integer> sApnPriorityMap;

    private void $$robo$$com_android_internal_telephony_dataconnection_DcRequest$__constructor__(NetworkRequest nr, Context context) {
        this.initApnPriorities(context);
        this.networkRequest = nr;
        this.apnId = this.apnIdForNetworkRequest(this.networkRequest);
        this.priority = this.priorityForApnId(this.apnId);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DcRequest$toString() {
        return this.networkRequest.toString() + ", priority=" + this.priority + ", apnId=" + this.apnId;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcRequest$hashCode() {
        return this.networkRequest.hashCode();
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DcRequest$equals(Object o) {
        if (o instanceof DcRequest) {
            return this.networkRequest.equals(((DcRequest)o).networkRequest);
        }
        return false;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcRequest$compareTo(DcRequest o) {
        return o.priority - this.priority;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcRequest$apnIdForNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return -1;
        }
        int apnId = -1;
        boolean error = false;
        if (nc.hasCapability(12)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 0;
        }
        if (nc.hasCapability(0)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 1;
        }
        if (nc.hasCapability(1)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 2;
        }
        if (nc.hasCapability(2)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 3;
        }
        if (nc.hasCapability(3)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 6;
        }
        if (nc.hasCapability(4)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 5;
        }
        if (nc.hasCapability(5)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 7;
        }
        if (nc.hasCapability(7)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 8;
        }
        if (nc.hasCapability(8)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = -1;
            this.loge("RCS APN type not yet supported");
        }
        if (nc.hasCapability(9)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = -1;
            this.loge("XCAP APN type not yet supported");
        }
        if (nc.hasCapability(10)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 9;
        }
        if (error) {
            this.loge("Multiple apn types specified in request - result is unspecified!");
        }
        if (apnId == -1) {
            this.loge("Unsupported NetworkRequest in Telephony: nr=" + nr);
        }
        return apnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_DcRequest$initApnPriorities(Context context) {
        HashMap<Integer, Integer> hashMap = sApnPriorityMap;
        synchronized (hashMap) {
            if (sApnPriorityMap.isEmpty()) {
                String[] networkConfigStrings;
                for (String networkConfigString : networkConfigStrings = context.getResources().getStringArray(17236065)) {
                    NetworkConfig networkConfig = new NetworkConfig(networkConfigString);
                    int apnId = ApnContext.apnIdForType(networkConfig.type);
                    sApnPriorityMap.put(apnId, networkConfig.priority);
                }
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DcRequest$priorityForApnId(int apnId) {
        Integer priority = sApnPriorityMap.get(apnId);
        return priority != null ? priority : 0;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DcRequest$loge(String s) {
        Rlog.e("DcRequest", s);
    }

    static void __staticInitializer__() {
        sApnPriorityMap = new HashMap();
    }

    private void __constructor__(NetworkRequest networkRequest, Context context) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DcRequest$__constructor__(networkRequest, context);
    }

    public DcRequest(NetworkRequest networkRequest, Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$__constructor__(android.net.NetworkRequest android.content.Context ), this, networkRequest, context);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$toString(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$equals(java.lang.Object ), this, object);
    }

    @Override
    public int compareTo(DcRequest dcRequest) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$compareTo(com.android.internal.telephony.dataconnection.DcRequest ), this, dcRequest);
    }

    private int apnIdForNetworkRequest(NetworkRequest networkRequest) {
        return (int)InvokeDynamicSupport.bootstrap("apnIdForNetworkRequest", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$apnIdForNetworkRequest(android.net.NetworkRequest ), this, networkRequest);
    }

    private void initApnPriorities(Context context) {
        InvokeDynamicSupport.bootstrap("initApnPriorities", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$initApnPriorities(android.content.Context ), this, context);
    }

    private int priorityForApnId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("priorityForApnId", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$priorityForApnId(int ), this, n);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DcRequest$loge(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(DcRequest.class);
    }

    public /* synthetic */ DcRequest() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

