/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.text.Emoji;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsHeader;
import java.text.BreakIterator;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SmsMessageBase
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected String mScAddress;
    protected SmsAddress mOriginatingAddress;
    protected String mMessageBody;
    protected String mPseudoSubject;
    protected String mEmailFrom;
    protected String mEmailBody;
    protected boolean mIsEmail;
    protected long mScTimeMillis;
    protected byte[] mPdu;
    protected byte[] mUserData;
    protected SmsHeader mUserDataHeader;
    protected boolean mIsMwi;
    protected boolean mMwiSense;
    protected boolean mMwiDontStore;
    protected int mStatusOnIcc;
    protected int mIndexOnIcc;
    public int mMessageRef;

    private void $$robo$$com_android_internal_telephony_SmsMessageBase$__constructor__() {
        this.mStatusOnIcc = -1;
        this.mIndexOnIcc = -1;
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getServiceCenterAddress() {
        return this.mScAddress;
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getOriginatingAddress() {
        if (this.mOriginatingAddress == null) {
            return null;
        }
        return this.mOriginatingAddress.getAddressString();
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getDisplayOriginatingAddress() {
        if (this.mIsEmail) {
            return this.mEmailFrom;
        }
        return this.getOriginatingAddress();
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getMessageBody() {
        return this.mMessageBody;
    }

    public abstract SmsConstants.MessageClass getMessageClass();

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getDisplayMessageBody() {
        if (this.mIsEmail) {
            return this.mEmailBody;
        }
        return this.getMessageBody();
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getPseudoSubject() {
        return this.mPseudoSubject == null ? "" : this.mPseudoSubject;
    }

    private final long $$robo$$com_android_internal_telephony_SmsMessageBase$getTimestampMillis() {
        return this.mScTimeMillis;
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsMessageBase$isEmail() {
        return this.mIsEmail;
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getEmailBody() {
        return this.mEmailBody;
    }

    private final String $$robo$$com_android_internal_telephony_SmsMessageBase$getEmailFrom() {
        return this.mEmailFrom;
    }

    public abstract int getProtocolIdentifier();

    public abstract boolean isReplace();

    public abstract boolean isCphsMwiMessage();

    public abstract boolean isMWIClearMessage();

    public abstract boolean isMWISetMessage();

    public abstract boolean isMwiDontStore();

    private final byte[] $$robo$$com_android_internal_telephony_SmsMessageBase$getUserData() {
        return this.mUserData;
    }

    private final SmsHeader $$robo$$com_android_internal_telephony_SmsMessageBase$getUserDataHeader() {
        return this.mUserDataHeader;
    }

    private final byte[] $$robo$$com_android_internal_telephony_SmsMessageBase$getPdu() {
        return this.mPdu;
    }

    public abstract int getStatus();

    public abstract boolean isStatusReportMessage();

    public abstract boolean isReplyPathPresent();

    private final int $$robo$$com_android_internal_telephony_SmsMessageBase$getStatusOnIcc() {
        return this.mStatusOnIcc;
    }

    private final int $$robo$$com_android_internal_telephony_SmsMessageBase$getIndexOnIcc() {
        return this.mIndexOnIcc;
    }

    private final void $$robo$$com_android_internal_telephony_SmsMessageBase$parseMessageBody() {
        if (this.mOriginatingAddress != null && this.mOriginatingAddress.couldBeEmailGateway()) {
            this.extractEmailAddressFromMessageBody();
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsMessageBase$extractEmailAddressFromMessageBody() {
        String[] parts = this.mMessageBody.split("( /)|( )", 2);
        if (parts.length < 2) {
            return;
        }
        this.mEmailFrom = parts[0];
        this.mEmailBody = parts[1];
        this.mIsEmail = Telephony.Mms.isEmailAddress(this.mEmailFrom);
    }

    private static final int $$robo$$com_android_internal_telephony_SmsMessageBase$findNextUnicodePosition(int currentPosition, int byteLimit, CharSequence msgBody) {
        int nextPos = Math.min(currentPosition + byteLimit / 2, msgBody.length());
        if (nextPos < msgBody.length()) {
            BreakIterator breakIterator = BreakIterator.getCharacterInstance();
            breakIterator.setText(msgBody.toString());
            if (!breakIterator.isBoundary(nextPos)) {
                int breakPos = breakIterator.preceding(nextPos);
                while (breakPos + 4 <= nextPos && Emoji.isRegionalIndicatorSymbol(Character.codePointAt(msgBody, breakPos)) && Emoji.isRegionalIndicatorSymbol(Character.codePointAt(msgBody, breakPos + 2))) {
                    breakPos += 4;
                }
                if (breakPos > currentPosition) {
                    nextPos = breakPos;
                } else if (Character.isHighSurrogate(msgBody.charAt(nextPos - 1))) {
                    --nextPos;
                }
            }
        }
        return nextPos;
    }

    private static final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_SmsMessageBase$calcUnicodeEncodingDetails(CharSequence msgBody) {
        GsmAlphabet.TextEncodingDetails ted = new GsmAlphabet.TextEncodingDetails();
        int octets = msgBody.length() * 2;
        ted.codeUnitSize = 3;
        ted.codeUnitCount = msgBody.length();
        if (octets > 140) {
            int maxUserDataBytesWithHeader = 134;
            if (!SmsMessage.hasEmsSupport() && octets <= 9 * (maxUserDataBytesWithHeader - 2)) {
                maxUserDataBytesWithHeader -= 2;
            }
            int pos = 0;
            int msgCount = 0;
            while (pos < msgBody.length()) {
                int nextPos = SmsMessageBase.findNextUnicodePosition(pos, maxUserDataBytesWithHeader, msgBody);
                if (nextPos == msgBody.length()) {
                    ted.codeUnitsRemaining = pos + maxUserDataBytesWithHeader / 2 - msgBody.length();
                }
                pos = nextPos;
                ++msgCount;
            }
            ted.msgCount = msgCount;
        } else {
            ted.msgCount = 1;
            ted.codeUnitsRemaining = (140 - octets) / 2;
        }
        return ted;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_SmsMessageBase$__constructor__();
    }

    public SmsMessageBase() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsMessageBase$__constructor__(), this);
    }

    public String getServiceCenterAddress() {
        return InvokeDynamicSupport.bootstrap("getServiceCenterAddress", $$robo$$com_android_internal_telephony_SmsMessageBase$getServiceCenterAddress(), this);
    }

    public String getOriginatingAddress() {
        return InvokeDynamicSupport.bootstrap("getOriginatingAddress", $$robo$$com_android_internal_telephony_SmsMessageBase$getOriginatingAddress(), this);
    }

    public String getDisplayOriginatingAddress() {
        return InvokeDynamicSupport.bootstrap("getDisplayOriginatingAddress", $$robo$$com_android_internal_telephony_SmsMessageBase$getDisplayOriginatingAddress(), this);
    }

    public String getMessageBody() {
        return InvokeDynamicSupport.bootstrap("getMessageBody", $$robo$$com_android_internal_telephony_SmsMessageBase$getMessageBody(), this);
    }

    public String getDisplayMessageBody() {
        return InvokeDynamicSupport.bootstrap("getDisplayMessageBody", $$robo$$com_android_internal_telephony_SmsMessageBase$getDisplayMessageBody(), this);
    }

    public String getPseudoSubject() {
        return InvokeDynamicSupport.bootstrap("getPseudoSubject", $$robo$$com_android_internal_telephony_SmsMessageBase$getPseudoSubject(), this);
    }

    public long getTimestampMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getTimestampMillis", $$robo$$com_android_internal_telephony_SmsMessageBase$getTimestampMillis(), this);
    }

    public boolean isEmail() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmail", $$robo$$com_android_internal_telephony_SmsMessageBase$isEmail(), this);
    }

    public String getEmailBody() {
        return InvokeDynamicSupport.bootstrap("getEmailBody", $$robo$$com_android_internal_telephony_SmsMessageBase$getEmailBody(), this);
    }

    public String getEmailFrom() {
        return InvokeDynamicSupport.bootstrap("getEmailFrom", $$robo$$com_android_internal_telephony_SmsMessageBase$getEmailFrom(), this);
    }

    public byte[] getUserData() {
        return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$com_android_internal_telephony_SmsMessageBase$getUserData(), this);
    }

    public SmsHeader getUserDataHeader() {
        return InvokeDynamicSupport.bootstrap("getUserDataHeader", $$robo$$com_android_internal_telephony_SmsMessageBase$getUserDataHeader(), this);
    }

    public byte[] getPdu() {
        return InvokeDynamicSupport.bootstrap("getPdu", $$robo$$com_android_internal_telephony_SmsMessageBase$getPdu(), this);
    }

    public int getStatusOnIcc() {
        return (int)InvokeDynamicSupport.bootstrap("getStatusOnIcc", $$robo$$com_android_internal_telephony_SmsMessageBase$getStatusOnIcc(), this);
    }

    public int getIndexOnIcc() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexOnIcc", $$robo$$com_android_internal_telephony_SmsMessageBase$getIndexOnIcc(), this);
    }

    protected void parseMessageBody() {
        InvokeDynamicSupport.bootstrap("parseMessageBody", $$robo$$com_android_internal_telephony_SmsMessageBase$parseMessageBody(), this);
    }

    protected void extractEmailAddressFromMessageBody() {
        InvokeDynamicSupport.bootstrap("extractEmailAddressFromMessageBody", $$robo$$com_android_internal_telephony_SmsMessageBase$extractEmailAddressFromMessageBody(), this);
    }

    public static int findNextUnicodePosition(int n, int n2, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findNextUnicodePosition", $$robo$$com_android_internal_telephony_SmsMessageBase$findNextUnicodePosition(int int java.lang.CharSequence ), (int)n, (int)n2, (CharSequence)charSequence);
    }

    public static GsmAlphabet.TextEncodingDetails calcUnicodeEncodingDetails(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("calcUnicodeEncodingDetails", $$robo$$com_android_internal_telephony_SmsMessageBase$calcUnicodeEncodingDetails(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsMessageBase)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class SubmitPduBase
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public byte[] encodedScAddress;
        public byte[] encodedMessage;

        private void $$robo$$com_android_internal_telephony_SmsMessageBase_SubmitPduBase$__constructor__() {
        }

        private final String $$robo$$com_android_internal_telephony_SmsMessageBase_SubmitPduBase$toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_SmsMessageBase_SubmitPduBase$__constructor__();
        }

        public SubmitPduBase() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsMessageBase_SubmitPduBase$__constructor__(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_SmsMessageBase_SubmitPduBase$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubmitPduBase)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

