/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.TimeUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.NitzData;
import com.android.internal.telephony.TimeServiceHelper;
import com.android.internal.telephony.TimeZoneLookupHelper;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.util.TimeStampedValue;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NitzStateMachine
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SST";
    private static boolean DBG = true;
    private TimeStampedValue<Long> mSavedNitzTime;
    private boolean mNeedCountryCodeForNitz;
    private TimeStampedValue<NitzData> mLatestNitzSignal;
    private boolean mGotCountryCode;
    private String mSavedTimeZoneId;
    private boolean mNitzTimeZoneDetectionSuccessful;
    private LocalLog mTimeLog;
    private LocalLog mTimeZoneLog;
    private GsmCdmaPhone mPhone;
    private DeviceState mDeviceState;
    private TimeServiceHelper mTimeServiceHelper;
    private TimeZoneLookupHelper mTimeZoneLookupHelper;
    private PowerManager.WakeLock mWakeLock;
    private static String WAKELOCK_TAG = "NitzStateMachine";

    private void $$robo$$com_android_internal_telephony_NitzStateMachine$__constructor__(GsmCdmaPhone phone) {
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_NitzStateMachine$__constructor__(GsmCdmaPhone phone, TimeServiceHelper timeServiceHelper, DeviceState deviceState, TimeZoneLookupHelper timeZoneLookupHelper) {
        this.mNeedCountryCodeForNitz = false;
        this.mGotCountryCode = false;
        this.mNitzTimeZoneDetectionSuccessful = false;
        this.mTimeLog = new LocalLog(15);
        this.mTimeZoneLog = new LocalLog(15);
        this.mPhone = phone;
        Context context = phone.getContext();
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, "NitzStateMachine");
        this.mDeviceState = deviceState;
        this.mTimeZoneLookupHelper = timeZoneLookupHelper;
        this.mTimeServiceHelper = timeServiceHelper;
        this.mTimeServiceHelper.setListener(new TimeServiceHelper.Listener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NitzStateMachine this$0;

            private void $$robo$$com_android_internal_telephony_NitzStateMachine_1$__constructor__(NitzStateMachine this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_NitzStateMachine_1$onTimeDetectionChange(boolean enabled) {
                if (enabled) {
                    this.this$0.handleAutoTimeEnabled();
                }
            }

            private final void $$robo$$com_android_internal_telephony_NitzStateMachine_1$onTimeZoneDetectionChange(boolean enabled) {
                if (enabled) {
                    this.this$0.handleAutoTimeZoneEnabled();
                }
            }

            private void __constructor__(NitzStateMachine nitzStateMachine) {
                this.$$robo$$com_android_internal_telephony_NitzStateMachine_1$__constructor__(nitzStateMachine);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NitzStateMachine_1$__constructor__(com.android.internal.telephony.NitzStateMachine ), this, nitzStateMachine);
            }

            @Override
            public void onTimeDetectionChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onTimeDetectionChange", $$robo$$com_android_internal_telephony_NitzStateMachine_1$onTimeDetectionChange(boolean ), this, bl);
            }

            @Override
            public void onTimeZoneDetectionChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onTimeZoneDetectionChange", $$robo$$com_android_internal_telephony_NitzStateMachine_1$onTimeZoneDetectionChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleNetworkCountryCodeSet(boolean countryChanged) {
        this.mGotCountryCode = true;
        String isoCountryCode = this.mDeviceState.getNetworkCountryIsoForPhone();
        if (!TextUtils.isEmpty(isoCountryCode) && !this.mNitzTimeZoneDetectionSuccessful && this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
            this.updateTimeZoneByNetworkCountryCode(isoCountryCode);
        }
        if (countryChanged || this.mNeedCountryCodeForNitz) {
            String zoneId;
            boolean isTimeZoneSettingInitialized = this.mTimeServiceHelper.isTimeZoneSettingInitialized();
            Rlog.d("SST", "handleNetworkCountryCodeSet: isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " mLatestNitzSignal=" + this.mLatestNitzSignal + " isoCountryCode=" + isoCountryCode);
            if (TextUtils.isEmpty(isoCountryCode) && this.mNeedCountryCodeForNitz) {
                TimeZoneLookupHelper.OffsetResult lookupResult = this.mTimeZoneLookupHelper.lookupByNitz((NitzData)this.mLatestNitzSignal.mValue);
                Rlog.d("SST", "handleNetworkCountryCodeSet: guessZoneIdByNitz() returned lookupResult=" + lookupResult);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            } else if (this.mLatestNitzSignal == null) {
                zoneId = null;
                Rlog.d("SST", "handleNetworkCountryCodeSet: No cached NITZ data available, not setting zone");
            } else if (NitzStateMachine.nitzOffsetMightBeBogus((NitzData)this.mLatestNitzSignal.mValue) && isTimeZoneSettingInitialized && !this.countryUsesUtc(isoCountryCode, this.mLatestNitzSignal)) {
                TimeZone zone = TimeZone.getDefault();
                Rlog.d("SST", "handleNetworkCountryCodeSet: NITZ looks bogus, maybe using current default zone to adjust the system clock, mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz + " mLatestNitzSignal=" + this.mLatestNitzSignal + " zone=" + zone);
                zoneId = zone.getID();
                if (this.mNeedCountryCodeForNitz) {
                    NitzData nitzData = (NitzData)this.mLatestNitzSignal.mValue;
                    try {
                        this.mWakeLock.acquire();
                        long ctm = nitzData.getCurrentTimeInMillis();
                        long delayAdjustedCtm = ctm + (this.mTimeServiceHelper.elapsedRealtime() - this.mLatestNitzSignal.mElapsedRealtime);
                        long tzOffset = zone.getOffset(delayAdjustedCtm);
                        Rlog.d("SST", "handleNetworkCountryCodeSet: tzOffset=" + tzOffset + " delayAdjustedCtm=" + TimeUtils.logTimeOfDay(delayAdjustedCtm));
                        if (this.mTimeServiceHelper.isTimeDetectionEnabled()) {
                            long timeZoneAdjustedCtm = delayAdjustedCtm - tzOffset;
                            String msg = "handleNetworkCountryCodeSet: setting time timeZoneAdjustedCtm=" + TimeUtils.logTimeOfDay(timeZoneAdjustedCtm);
                            this.setAndBroadcastNetworkSetTime(msg, timeZoneAdjustedCtm);
                        }
                        this.mSavedNitzTime = new TimeStampedValue<Long>((Long)this.mSavedNitzTime.mValue - tzOffset, this.mSavedNitzTime.mElapsedRealtime);
                        Rlog.d("SST", "handleNetworkCountryCodeSet:adjusting time mSavedNitzTime=" + this.mSavedNitzTime);
                    }
                    finally {
                        this.mWakeLock.release();
                    }
                }
            } else {
                NitzData nitzData = (NitzData)this.mLatestNitzSignal.mValue;
                TimeZoneLookupHelper.OffsetResult lookupResult = this.mTimeZoneLookupHelper.lookupByNitzCountry(nitzData, isoCountryCode);
                Rlog.d("SST", "handleNetworkCountryCodeSet: using guessZoneIdByNitzCountry(nitzData, isoCountryCode), nitzData=" + nitzData + " isoCountryCode=" + isoCountryCode + " lookupResult=" + lookupResult);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            }
            String tmpLog = "handleNetworkCountryCodeSet: isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " mLatestNitzSignal=" + this.mLatestNitzSignal + " isoCountryCode=" + isoCountryCode + " mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz + " zoneId=" + zoneId;
            this.mTimeZoneLog.log(tmpLog);
            if (zoneId != null) {
                Rlog.d("SST", "handleNetworkCountryCodeSet: zoneId != null, zoneId=" + zoneId);
                if (this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
                    this.setAndBroadcastNetworkSetTimeZone(zoneId);
                } else {
                    Rlog.d("SST", "handleNetworkCountryCodeSet: skip changing zone as isTimeZoneDetectionEnabled() is false");
                }
                if (this.mNeedCountryCodeForNitz) {
                    this.mSavedTimeZoneId = zoneId;
                }
            } else {
                Rlog.d("SST", "handleNetworkCountryCodeSet: lookupResult == null, do nothing");
            }
            this.mNeedCountryCodeForNitz = false;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_NitzStateMachine$countryUsesUtc(String isoCountryCode, TimeStampedValue<NitzData> nitzSignal) {
        return this.mTimeZoneLookupHelper.countryUsesUtc(isoCountryCode, ((NitzData)nitzSignal.mValue).getCurrentTimeInMillis());
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleNetworkAvailable() {
        Rlog.d("SST", "handleNetworkAvailable: mNitzTimeZoneDetectionSuccessful=" + this.mNitzTimeZoneDetectionSuccessful + ", Setting mNitzTimeZoneDetectionSuccessful=false");
        this.mNitzTimeZoneDetectionSuccessful = false;
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleNetworkUnavailable() {
        Rlog.d("SST", "handleNetworkUnavailable");
        this.mGotCountryCode = false;
        this.mNitzTimeZoneDetectionSuccessful = false;
    }

    private static final boolean $$robo$$com_android_internal_telephony_NitzStateMachine$nitzOffsetMightBeBogus(NitzData nitzData) {
        return nitzData.getLocalOffsetMillis() == 0 && !nitzData.isDst();
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleNitzReceived(TimeStampedValue<NitzData> nitzSignal) {
        this.handleTimeZoneFromNitz(nitzSignal);
        this.handleTimeFromNitz(nitzSignal);
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleTimeZoneFromNitz(TimeStampedValue<NitzData> nitzSignal) {
        try {
            TimeZoneLookupHelper.OffsetResult lookupResult;
            String zoneId;
            NitzData newNitzData = (NitzData)nitzSignal.mValue;
            String iso = this.mDeviceState.getNetworkCountryIsoForPhone();
            if (newNitzData.getEmulatorHostTimeZone() != null) {
                zoneId = newNitzData.getEmulatorHostTimeZone().getID();
            } else if (!this.mGotCountryCode) {
                zoneId = null;
            } else if (!TextUtils.isEmpty(iso)) {
                lookupResult = this.mTimeZoneLookupHelper.lookupByNitzCountry(newNitzData, iso);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            } else {
                lookupResult = this.mTimeZoneLookupHelper.lookupByNitz(newNitzData);
                Rlog.d("SST", "handleTimeZoneFromNitz: guessZoneIdByNitz returned lookupResult=" + lookupResult);
                String string2 = zoneId = lookupResult != null ? lookupResult.zoneId : null;
            }
            if (zoneId == null || this.mLatestNitzSignal == null || NitzStateMachine.offsetInfoDiffers(newNitzData, (NitzData)this.mLatestNitzSignal.mValue)) {
                this.mNeedCountryCodeForNitz = true;
                this.mLatestNitzSignal = nitzSignal;
            }
            String tmpLog = "handleTimeZoneFromNitz: nitzSignal=" + nitzSignal + " zoneId=" + zoneId + " iso=" + iso + " mGotCountryCode=" + this.mGotCountryCode + " mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz + " isTimeZoneDetectionEnabled()=" + this.mTimeServiceHelper.isTimeZoneDetectionEnabled();
            Rlog.d("SST", tmpLog);
            this.mTimeZoneLog.log(tmpLog);
            if (zoneId != null) {
                if (this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
                    this.setAndBroadcastNetworkSetTimeZone(zoneId);
                }
                this.mNitzTimeZoneDetectionSuccessful = true;
                this.mSavedTimeZoneId = zoneId;
            }
        }
        catch (RuntimeException ex) {
            Rlog.e("SST", "handleTimeZoneFromNitz: Processing NITZ data nitzSignal=" + nitzSignal + " ex=" + ex);
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_NitzStateMachine$offsetInfoDiffers(NitzData one, NitzData two) {
        return one.getLocalOffsetMillis() != two.getLocalOffsetMillis() || one.isDst() != two.isDst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleTimeFromNitz(TimeStampedValue<NitzData> nitzSignal) {
        try {
            boolean ignoreNitz = this.mDeviceState.getIgnoreNitz();
            if (ignoreNitz) {
                Rlog.d("SST", "handleTimeFromNitz: Not setting clock because gsm.ignore-nitz is set");
                return;
            }
            try {
                this.mWakeLock.acquire();
                long elapsedRealtime = this.mTimeServiceHelper.elapsedRealtime();
                long millisSinceNitzReceived = elapsedRealtime - nitzSignal.mElapsedRealtime;
                if (millisSinceNitzReceived < 0L || millisSinceNitzReceived > Integer.MAX_VALUE) {
                    Rlog.d("SST", "handleTimeFromNitz: not setting time, unexpected elapsedRealtime=" + elapsedRealtime + " nitzSignal=" + nitzSignal);
                    return;
                }
                long adjustedCurrentTimeMillis = ((NitzData)nitzSignal.mValue).getCurrentTimeInMillis() + millisSinceNitzReceived;
                long gained = adjustedCurrentTimeMillis - this.mTimeServiceHelper.currentTimeMillis();
                if (this.mTimeServiceHelper.isTimeDetectionEnabled()) {
                    String logMsg = "handleTimeFromNitz: nitzSignal=" + nitzSignal + " adjustedCurrentTimeMillis=" + adjustedCurrentTimeMillis + " millisSinceNitzReceived= " + millisSinceNitzReceived + " gained=" + gained;
                    if (this.mSavedNitzTime == null) {
                        logMsg = logMsg + ": First update received.";
                        this.setAndBroadcastNetworkSetTime(logMsg, adjustedCurrentTimeMillis);
                    } else {
                        long elapsedRealtimeSinceLastSaved = this.mTimeServiceHelper.elapsedRealtime() - this.mSavedNitzTime.mElapsedRealtime;
                        int nitzUpdateSpacing = this.mDeviceState.getNitzUpdateSpacingMillis();
                        int nitzUpdateDiff = this.mDeviceState.getNitzUpdateDiffMillis();
                        if (elapsedRealtimeSinceLastSaved > (long)nitzUpdateSpacing || Math.abs(gained) > (long)nitzUpdateDiff) {
                            logMsg = logMsg + ": New update received.";
                            this.setAndBroadcastNetworkSetTime(logMsg, adjustedCurrentTimeMillis);
                        } else {
                            Rlog.d("SST", logMsg + ": Update throttled.");
                            return;
                        }
                    }
                }
                this.mSavedNitzTime = new TimeStampedValue<Long>(adjustedCurrentTimeMillis, nitzSignal.mElapsedRealtime);
            }
            finally {
                this.mWakeLock.release();
            }
        }
        catch (RuntimeException ex) {
            Rlog.e("SST", "handleTimeFromNitz: Processing NITZ data nitzSignal=" + nitzSignal + " ex=" + ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$setAndBroadcastNetworkSetTimeZone(String zoneId) {
        Rlog.d("SST", "setAndBroadcastNetworkSetTimeZone: zoneId=" + zoneId);
        this.mTimeServiceHelper.setDeviceTimeZone(zoneId);
        Rlog.d("SST", "setAndBroadcastNetworkSetTimeZone: called setDeviceTimeZone() zoneId=" + zoneId);
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$setAndBroadcastNetworkSetTime(String msg, long time) {
        if (!this.mWakeLock.isHeld()) {
            Rlog.w("SST", "setAndBroadcastNetworkSetTime: Wake lock not held while setting device time (msg=" + msg + ")");
        }
        msg = "setAndBroadcastNetworkSetTime: [Setting time to time=" + time + "]:" + msg;
        Rlog.d("SST", msg);
        this.mTimeLog.log(msg);
        this.mTimeServiceHelper.setDeviceTime(time);
        TelephonyMetrics.getInstance().writeNITZEvent(this.mPhone.getPhoneId(), time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleAutoTimeEnabled() {
        Rlog.d("SST", "handleAutoTimeEnabled: Reverting to NITZ Time: mSavedNitzTime=" + this.mSavedNitzTime);
        if (this.mSavedNitzTime != null) {
            try {
                this.mWakeLock.acquire();
                long elapsedRealtime = this.mTimeServiceHelper.elapsedRealtime();
                String msg = "mSavedNitzTime: Reverting to NITZ time elapsedRealtime=" + elapsedRealtime + " mSavedNitzTime=" + this.mSavedNitzTime;
                long adjustedCurrentTimeMillis = (Long)this.mSavedNitzTime.mValue + (elapsedRealtime - this.mSavedNitzTime.mElapsedRealtime);
                this.setAndBroadcastNetworkSetTime(msg, adjustedCurrentTimeMillis);
            }
            finally {
                this.mWakeLock.release();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$handleAutoTimeZoneEnabled() {
        String tmpLog = "handleAutoTimeZoneEnabled: Reverting to NITZ TimeZone: mSavedTimeZoneId=" + this.mSavedTimeZoneId;
        Rlog.d("SST", tmpLog);
        this.mTimeZoneLog.log(tmpLog);
        if (this.mSavedTimeZoneId != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZoneId);
        } else {
            String iso = this.mDeviceState.getNetworkCountryIsoForPhone();
            if (!TextUtils.isEmpty(iso)) {
                this.updateTimeZoneByNetworkCountryCode(iso);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$dumpState(PrintWriter pw) {
        pw.println(" mSavedTime=" + this.mSavedNitzTime);
        pw.println(" mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz);
        pw.println(" mLatestNitzSignal=" + this.mLatestNitzSignal);
        pw.println(" mGotCountryCode=" + this.mGotCountryCode);
        pw.println(" mSavedTimeZoneId=" + this.mSavedTimeZoneId);
        pw.println(" mNitzTimeZoneDetectionSuccessful=" + this.mNitzTimeZoneDetectionSuccessful);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.flush();
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$dumpLogs(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
        ipw.println(" Time Logs:");
        ipw.increaseIndent();
        this.mTimeLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Time zone Logs:");
        ipw.increaseIndent();
        this.mTimeZoneLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    private final void $$robo$$com_android_internal_telephony_NitzStateMachine$updateTimeZoneByNetworkCountryCode(String iso) {
        TimeZoneLookupHelper.CountryResult lookupResult = this.mTimeZoneLookupHelper.lookupByCountry(iso, this.mTimeServiceHelper.currentTimeMillis());
        if (lookupResult != null && lookupResult.allZonesHaveSameOffset) {
            String logMsg = "updateTimeZoneByNetworkCountryCode: set time lookupResult=" + lookupResult + " iso=" + iso;
            Rlog.d("SST", logMsg);
            this.mTimeZoneLog.log(logMsg);
            this.setAndBroadcastNetworkSetTimeZone(lookupResult.zoneId);
        } else {
            Rlog.d("SST", "updateTimeZoneByNetworkCountryCode: no good zone for iso=" + iso + " lookupResult=" + lookupResult);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_NitzStateMachine$getNitzTimeZoneDetectionSuccessful() {
        return this.mNitzTimeZoneDetectionSuccessful;
    }

    private final NitzData $$robo$$com_android_internal_telephony_NitzStateMachine$getCachedNitzData() {
        return this.mLatestNitzSignal != null ? (NitzData)this.mLatestNitzSignal.mValue : null;
    }

    private final String $$robo$$com_android_internal_telephony_NitzStateMachine$getSavedTimeZoneId() {
        return this.mSavedTimeZoneId;
    }

    private void __constructor__(GsmCdmaPhone gsmCdmaPhone) {
        this.$$robo$$com_android_internal_telephony_NitzStateMachine$__constructor__(gsmCdmaPhone);
    }

    public NitzStateMachine(GsmCdmaPhone gsmCdmaPhone) {
        this(gsmCdmaPhone, new TimeServiceHelper(gsmCdmaPhone.getContext()), new DeviceState(gsmCdmaPhone), new TimeZoneLookupHelper());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NitzStateMachine$__constructor__(com.android.internal.telephony.GsmCdmaPhone ), this, gsmCdmaPhone);
    }

    private void __constructor__(GsmCdmaPhone gsmCdmaPhone, TimeServiceHelper timeServiceHelper, DeviceState deviceState, TimeZoneLookupHelper timeZoneLookupHelper) {
        this.$$robo$$com_android_internal_telephony_NitzStateMachine$__constructor__(gsmCdmaPhone, timeServiceHelper, deviceState, timeZoneLookupHelper);
    }

    public NitzStateMachine(GsmCdmaPhone gsmCdmaPhone, TimeServiceHelper timeServiceHelper, DeviceState deviceState, TimeZoneLookupHelper timeZoneLookupHelper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NitzStateMachine$__constructor__(com.android.internal.telephony.GsmCdmaPhone com.android.internal.telephony.TimeServiceHelper com.android.internal.telephony.NitzStateMachine$DeviceState com.android.internal.telephony.TimeZoneLookupHelper ), this, gsmCdmaPhone, timeServiceHelper, deviceState, timeZoneLookupHelper);
    }

    public void handleNetworkCountryCodeSet(boolean bl) {
        InvokeDynamicSupport.bootstrap("handleNetworkCountryCodeSet", $$robo$$com_android_internal_telephony_NitzStateMachine$handleNetworkCountryCodeSet(boolean ), this, bl);
    }

    private boolean countryUsesUtc(String string2, TimeStampedValue<NitzData> timeStampedValue) {
        return (boolean)InvokeDynamicSupport.bootstrap("countryUsesUtc", $$robo$$com_android_internal_telephony_NitzStateMachine$countryUsesUtc(java.lang.String com.android.internal.telephony.util.TimeStampedValue<com.android.internal.telephony.NitzData> ), this, string2, timeStampedValue);
    }

    public void handleNetworkAvailable() {
        InvokeDynamicSupport.bootstrap("handleNetworkAvailable", $$robo$$com_android_internal_telephony_NitzStateMachine$handleNetworkAvailable(), this);
    }

    public void handleNetworkUnavailable() {
        InvokeDynamicSupport.bootstrap("handleNetworkUnavailable", $$robo$$com_android_internal_telephony_NitzStateMachine$handleNetworkUnavailable(), this);
    }

    private static boolean nitzOffsetMightBeBogus(NitzData nitzData) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nitzOffsetMightBeBogus", $$robo$$com_android_internal_telephony_NitzStateMachine$nitzOffsetMightBeBogus(com.android.internal.telephony.NitzData ), (NitzData)nitzData);
    }

    public void handleNitzReceived(TimeStampedValue<NitzData> timeStampedValue) {
        InvokeDynamicSupport.bootstrap("handleNitzReceived", $$robo$$com_android_internal_telephony_NitzStateMachine$handleNitzReceived(com.android.internal.telephony.util.TimeStampedValue<com.android.internal.telephony.NitzData> ), this, timeStampedValue);
    }

    private void handleTimeZoneFromNitz(TimeStampedValue<NitzData> timeStampedValue) {
        InvokeDynamicSupport.bootstrap("handleTimeZoneFromNitz", $$robo$$com_android_internal_telephony_NitzStateMachine$handleTimeZoneFromNitz(com.android.internal.telephony.util.TimeStampedValue<com.android.internal.telephony.NitzData> ), this, timeStampedValue);
    }

    private static boolean offsetInfoDiffers(NitzData nitzData, NitzData nitzData2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("offsetInfoDiffers", $$robo$$com_android_internal_telephony_NitzStateMachine$offsetInfoDiffers(com.android.internal.telephony.NitzData com.android.internal.telephony.NitzData ), (NitzData)nitzData, (NitzData)nitzData2);
    }

    private void handleTimeFromNitz(TimeStampedValue<NitzData> timeStampedValue) {
        InvokeDynamicSupport.bootstrap("handleTimeFromNitz", $$robo$$com_android_internal_telephony_NitzStateMachine$handleTimeFromNitz(com.android.internal.telephony.util.TimeStampedValue<com.android.internal.telephony.NitzData> ), this, timeStampedValue);
    }

    private void setAndBroadcastNetworkSetTimeZone(String string2) {
        InvokeDynamicSupport.bootstrap("setAndBroadcastNetworkSetTimeZone", $$robo$$com_android_internal_telephony_NitzStateMachine$setAndBroadcastNetworkSetTimeZone(java.lang.String ), this, string2);
    }

    private void setAndBroadcastNetworkSetTime(String string2, long l) {
        InvokeDynamicSupport.bootstrap("setAndBroadcastNetworkSetTime", $$robo$$com_android_internal_telephony_NitzStateMachine$setAndBroadcastNetworkSetTime(java.lang.String long ), this, string2, l);
    }

    private void handleAutoTimeEnabled() {
        InvokeDynamicSupport.bootstrap("handleAutoTimeEnabled", $$robo$$com_android_internal_telephony_NitzStateMachine$handleAutoTimeEnabled(), this);
    }

    private void handleAutoTimeZoneEnabled() {
        InvokeDynamicSupport.bootstrap("handleAutoTimeZoneEnabled", $$robo$$com_android_internal_telephony_NitzStateMachine$handleAutoTimeZoneEnabled(), this);
    }

    public void dumpState(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpState", $$robo$$com_android_internal_telephony_NitzStateMachine$dumpState(java.io.PrintWriter ), this, printWriter);
    }

    public void dumpLogs(FileDescriptor fileDescriptor, IndentingPrintWriter indentingPrintWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dumpLogs", $$robo$$com_android_internal_telephony_NitzStateMachine$dumpLogs(java.io.FileDescriptor com.android.internal.util.IndentingPrintWriter java.lang.String[] ), this, fileDescriptor, indentingPrintWriter, stringArray);
    }

    private void updateTimeZoneByNetworkCountryCode(String string2) {
        InvokeDynamicSupport.bootstrap("updateTimeZoneByNetworkCountryCode", $$robo$$com_android_internal_telephony_NitzStateMachine$updateTimeZoneByNetworkCountryCode(java.lang.String ), this, string2);
    }

    public boolean getNitzTimeZoneDetectionSuccessful() {
        return (boolean)InvokeDynamicSupport.bootstrap("getNitzTimeZoneDetectionSuccessful", $$robo$$com_android_internal_telephony_NitzStateMachine$getNitzTimeZoneDetectionSuccessful(), this);
    }

    public NitzData getCachedNitzData() {
        return InvokeDynamicSupport.bootstrap("getCachedNitzData", $$robo$$com_android_internal_telephony_NitzStateMachine$getCachedNitzData(), this);
    }

    public String getSavedTimeZoneId() {
        return InvokeDynamicSupport.bootstrap("getSavedTimeZoneId", $$robo$$com_android_internal_telephony_NitzStateMachine$getSavedTimeZoneId(), this);
    }

    public /* synthetic */ NitzStateMachine() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NitzStateMachine)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DeviceState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int NITZ_UPDATE_SPACING_DEFAULT = 600000;
        private int mNitzUpdateSpacing;
        private static int NITZ_UPDATE_DIFF_DEFAULT = 2000;
        private int mNitzUpdateDiff;
        private GsmCdmaPhone mPhone;
        private TelephonyManager mTelephonyManager;
        private ContentResolver mCr;

        private void $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$__constructor__(GsmCdmaPhone phone) {
            this.mPhone = phone;
            Context context = phone.getContext();
            this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            this.mCr = context.getContentResolver();
            this.mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
            this.mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
        }

        private final int $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getNitzUpdateSpacingMillis() {
            return Settings.Global.getInt(this.mCr, "nitz_update_spacing", this.mNitzUpdateSpacing);
        }

        private final int $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getNitzUpdateDiffMillis() {
            return Settings.Global.getInt(this.mCr, "nitz_update_diff", this.mNitzUpdateDiff);
        }

        private final boolean $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getIgnoreNitz() {
            String ignoreNitz = SystemProperties.get("gsm.ignore-nitz");
            return ignoreNitz != null && ignoreNitz.equals("yes");
        }

        private final String $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getNetworkCountryIsoForPhone() {
            return this.mTelephonyManager.getNetworkCountryIsoForPhone(this.mPhone.getPhoneId());
        }

        private void __constructor__(GsmCdmaPhone gsmCdmaPhone) {
            this.$$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$__constructor__(gsmCdmaPhone);
        }

        public DeviceState(GsmCdmaPhone gsmCdmaPhone) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$__constructor__(com.android.internal.telephony.GsmCdmaPhone ), this, gsmCdmaPhone);
        }

        public int getNitzUpdateSpacingMillis() {
            return (int)InvokeDynamicSupport.bootstrap("getNitzUpdateSpacingMillis", $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getNitzUpdateSpacingMillis(), this);
        }

        public int getNitzUpdateDiffMillis() {
            return (int)InvokeDynamicSupport.bootstrap("getNitzUpdateDiffMillis", $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getNitzUpdateDiffMillis(), this);
        }

        public boolean getIgnoreNitz() {
            return (boolean)InvokeDynamicSupport.bootstrap("getIgnoreNitz", $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getIgnoreNitz(), this);
        }

        public String getNetworkCountryIsoForPhone() {
            return InvokeDynamicSupport.bootstrap("getNetworkCountryIsoForPhone", $$robo$$com_android_internal_telephony_NitzStateMachine_DeviceState$getNetworkCountryIsoForPhone(), this);
        }

        public /* synthetic */ DeviceState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeviceState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

