/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.app.BroadcastOptions;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IDeviceIdleController;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.AppSmsManager;
import com.android.internal.telephony.BlockChecker;
import com.android.internal.telephony.CarrierServicesSmsFilter;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.VisualVoicemailSmsFilter;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.util.HexDump;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class InboundSmsHandler
extends StateMachine
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected static boolean DBG = true;
    private static boolean VDBG = false;
    private static String[] PDU_PROJECTION;
    private static String[] PDU_SEQUENCE_PORT_PROJECTION;
    private static Map<Integer, Integer> PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING;
    public static int PDU_COLUMN = 0;
    public static int SEQUENCE_COLUMN = 1;
    public static int DESTINATION_PORT_COLUMN = 2;
    public static int DATE_COLUMN = 3;
    public static int REFERENCE_NUMBER_COLUMN = 4;
    public static int COUNT_COLUMN = 5;
    public static int ADDRESS_COLUMN = 6;
    public static int ID_COLUMN = 7;
    public static int MESSAGE_BODY_COLUMN = 8;
    public static int DISPLAY_ADDRESS_COLUMN = 9;
    public static String SELECT_BY_ID = "_id=?";
    public static int EVENT_NEW_SMS = 1;
    public static int EVENT_BROADCAST_SMS = 2;
    private static int EVENT_BROADCAST_COMPLETE = 3;
    private static int EVENT_RETURN_TO_IDLE = 4;
    private static int EVENT_RELEASE_WAKELOCK = 5;
    public static int EVENT_START_ACCEPTING_SMS = 6;
    private static int EVENT_UPDATE_PHONE_OBJECT = 7;
    public static int EVENT_INJECT_SMS = 8;
    private static int WAKELOCK_TIMEOUT = 3000;
    private static String NOTIFICATION_TAG = "InboundSmsHandler";
    private static int NOTIFICATION_ID_NEW_MESSAGE = 1;
    protected static Uri sRawUri;
    protected static Uri sRawUriPermanentDelete;
    protected Context mContext;
    private ContentResolver mResolver;
    private WapPushOverSms mWapPush;
    private PowerManager.WakeLock mWakeLock;
    private DefaultState mDefaultState;
    private StartupState mStartupState;
    private IdleState mIdleState;
    private DeliveringState mDeliveringState;
    private WaitingState mWaitingState;
    protected SmsStorageMonitor mStorageMonitor;
    private boolean mSmsReceiveDisabled;
    protected Phone mPhone;
    protected CellBroadcastHandler mCellBroadcastHandler;
    private UserManager mUserManager;
    IDeviceIdleController mDeviceIdleController;
    private int DELETE_PERMANENTLY = 1;
    private int MARK_DELETED = 2;
    private static String ACTION_OPEN_SMS_APP;
    private int mWakeLockTimeout;

    private void $$robo$$com_android_internal_telephony_InboundSmsHandler$__constructor__(String name, Context context, SmsStorageMonitor storageMonitor, Phone phone, CellBroadcastHandler cellBroadcastHandler) {
        this.mDefaultState = new DefaultState(this, null);
        this.mStartupState = new StartupState(this, null);
        this.mIdleState = new IdleState(this, null);
        this.mDeliveringState = new DeliveringState(this, null);
        this.mWaitingState = new WaitingState(this, null);
        this.DELETE_PERMANENTLY = 1;
        this.MARK_DELETED = 2;
        this.mContext = context;
        this.mStorageMonitor = storageMonitor;
        this.mPhone = phone;
        this.mCellBroadcastHandler = cellBroadcastHandler;
        this.mResolver = context.getContentResolver();
        this.mWapPush = new WapPushOverSms(context);
        boolean smsCapable = this.mContext.getResources().getBoolean(17957028);
        this.mSmsReceiveDisabled = !TelephonyManager.from(this.mContext).getSmsReceiveCapableForPhone(this.mPhone.getPhoneId(), smsCapable);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, name);
        this.mWakeLock.acquire();
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mDeviceIdleController = TelephonyComponentFactory.getInstance().getIDeviceIdleController();
        this.addState(this.mDefaultState);
        this.addState(this.mStartupState, this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mDeliveringState, this.mDefaultState);
        this.addState(this.mWaitingState, this.mDeliveringState);
        this.setInitialState(this.mStartupState);
        this.log("created InboundSmsHandler");
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$dispose() {
        this.quit();
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$updatePhoneObject(Phone phone) {
        this.sendMessage(7, phone);
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$onQuitting() {
        this.mWapPush.dispose();
        while (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private final Phone $$robo$$com_android_internal_telephony_InboundSmsHandler$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$handleNewSms(AsyncResult ar) {
        int result;
        if (ar.exception != null) {
            this.loge("Exception processing incoming SMS: " + ar.exception);
            return;
        }
        try {
            SmsMessage sms = (SmsMessage)ar.result;
            result = this.dispatchMessage(sms.mWrappedSmsMessage);
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (result != -1) {
            boolean handled = result == 1;
            this.notifyAndAcknowledgeLastIncomingSms(handled, result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$handleInjectSms(AsyncResult ar) {
        int result;
        SmsDispatchersController.SmsInjectionCallback callback = null;
        try {
            callback = (SmsDispatchersController.SmsInjectionCallback)ar.userObj;
            SmsMessage sms = (SmsMessage)ar.result;
            result = sms == null ? 2 : this.dispatchMessage(sms.mWrappedSmsMessage);
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (callback != null) {
            callback.onSmsInjectedResult(result);
        }
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            this.loge("dispatchSmsMessage: message is null");
            return 2;
        }
        if (this.mSmsReceiveDisabled) {
            this.log("Received short message on device which doesn't support receiving SMS. Ignored.");
            return 1;
        }
        boolean onlyCore = false;
        try {
            onlyCore = IPackageManager.Stub.asInterface(ServiceManager.getService("package")).isOnlyCoreApps();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (onlyCore) {
            this.log("Received a short message in encrypted state. Rejecting.");
            return 2;
        }
        return this.dispatchMessageRadioSpecific(smsb);
    }

    protected abstract int dispatchMessageRadioSpecific(SmsMessageBase var1);

    protected abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$onUpdatePhoneObject(Phone phone) {
        this.mPhone = phone;
        this.mStorageMonitor = this.mPhone.mSmsStorageMonitor;
        this.log("onUpdatePhoneObject: phone=" + this.mPhone.getClass().getSimpleName());
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$notifyAndAcknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (!success) {
            Intent intent = new Intent("android.provider.Telephony.SMS_REJECTED");
            intent.putExtra("result", result);
            intent.addFlags(0x1000000);
            this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
        }
        this.acknowledgeLastIncomingSms(success, result, response);
    }

    protected abstract boolean is3gpp2();

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchNormalMessage(SmsMessageBase sms) {
        InboundSmsTracker tracker;
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            int destPort = -1;
            if (smsHeader != null && smsHeader.portAddrs != null) {
                destPort = smsHeader.portAddrs.destPort;
                this.log("destination port: " + destPort);
            }
            tracker = TelephonyComponentFactory.getInstance().makeInboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), false, sms.getOriginatingAddress(), sms.getDisplayOriginatingAddress(), sms.getMessageBody());
        } else {
            SmsHeader.ConcatRef concatRef = smsHeader.concatRef;
            SmsHeader.PortAddrs portAddrs = smsHeader.portAddrs;
            int destPort = portAddrs != null ? portAddrs.destPort : -1;
            tracker = TelephonyComponentFactory.getInstance().makeInboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), sms.getOriginatingAddress(), sms.getDisplayOriginatingAddress(), concatRef.refNumber, concatRef.seqNumber, concatRef.msgCount, false, sms.getMessageBody());
        }
        return this.addTrackerToRawTableAndSendMessage(tracker, tracker.getDestPort() == -1);
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTableAndSendMessage(InboundSmsTracker tracker, boolean deDup) {
        switch (this.addTrackerToRawTable(tracker, deDup)) {
            case 1: {
                this.sendMessage(2, tracker);
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$processMessagePart(InboundSmsTracker tracker) {
        byte[][] pdus;
        int messageCount = tracker.getMessageCount();
        int destPort = tracker.getDestPort();
        boolean block = false;
        if (messageCount <= 0) {
            this.loge("processMessagePart: returning false due to invalid message count " + messageCount);
            return false;
        }
        if (messageCount == 1) {
            pdus = new byte[][]{tracker.getPdu()};
            block = BlockChecker.isBlocked(this.mContext, tracker.getDisplayAddress(), null);
        } else {
            try (Cursor cursor = null;){
                String address = tracker.getAddress();
                String refNumber = Integer.toString(tracker.getReferenceNumber());
                String count = Integer.toString(tracker.getMessageCount());
                String[] whereArgs = new String[]{address, refNumber, count};
                cursor = this.mResolver.query(sRawUri, PDU_SEQUENCE_PORT_PROJECTION, tracker.getQueryForSegments(), whereArgs, null);
                int cursorCount = cursor.getCount();
                if (cursorCount < messageCount) {
                    boolean bl = false;
                    return bl;
                }
                pdus = new byte[messageCount][];
                while (cursor.moveToNext()) {
                    int index = cursor.getInt(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(1)) - tracker.getIndexOffset();
                    if (index >= pdus.length || index < 0) {
                        this.loge(String.format("processMessagePart: invalid seqNumber = %d, messageCount = %d", index + tracker.getIndexOffset(), messageCount));
                        continue;
                    }
                    pdus[index] = HexDump.hexStringToByteArray(cursor.getString(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(0)));
                    if (index == 0 && !cursor.isNull(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(2))) {
                        int port = cursor.getInt(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(2));
                        if ((port = InboundSmsTracker.getRealDestPort(port)) != -1) {
                            destPort = port;
                        }
                    }
                    if (block) continue;
                    block = BlockChecker.isBlocked(this.mContext, cursor.getString(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(9)), null);
                }
            }
        }
        List pduList = Arrays.asList(pdus);
        if (pduList.size() == 0 || pduList.contains(null)) {
            this.loge("processMessagePart: returning false due to " + (pduList.size() == 0 ? "pduList.size() == 0" : "pduList.contains(null)"));
            return false;
        }
        SmsBroadcastReceiver resultReceiver = new SmsBroadcastReceiver(this, tracker);
        if (!this.mUserManager.isUserUnlocked()) {
            return this.processMessagePartWithUserLocked(tracker, pdus, destPort, resultReceiver);
        }
        if (destPort == 2948) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (Object pdu : (String)pdus) {
                if (!tracker.is3gpp2()) {
                    SmsMessage msg = SmsMessage.createFromPdu((byte[])pdu, "3gpp");
                    if (msg != null) {
                        pdu = msg.getUserData();
                    } else {
                        this.loge("processMessagePart: SmsMessage.createFromPdu returned null");
                        return false;
                    }
                }
                output.write((byte[])pdu, 0, ((Object)pdu).length);
            }
            int result = this.mWapPush.dispatchWapPdu(output.toByteArray(), resultReceiver, this);
            this.log("dispatchWapPdu() returned " + result);
            if (result == -1) {
                return true;
            }
            this.deleteFromRawTable(tracker.getDeleteWhere(), tracker.getDeleteWhereArgs(), 2);
            return false;
        }
        if (block) {
            this.deleteFromRawTable(tracker.getDeleteWhere(), tracker.getDeleteWhereArgs(), 1);
            return false;
        }
        boolean filterInvoked = this.filterSms(pdus, destPort, tracker, resultReceiver, true);
        if (!filterInvoked) {
            this.dispatchSmsDeliveryIntent(pdus, tracker.getFormat(), destPort, resultReceiver);
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$processMessagePartWithUserLocked(InboundSmsTracker tracker, byte[][] pdus, int destPort, SmsBroadcastReceiver resultReceiver) {
        this.log("Credential-encrypted storage not available. Port: " + destPort);
        if (destPort == 2948 && this.mWapPush.isWapPushForMms(pdus[0], this)) {
            this.showNewMessageNotification();
            return false;
        }
        if (destPort == -1) {
            boolean filterInvoked = this.filterSms(pdus, destPort, tracker, resultReceiver, false);
            if (filterInvoked) {
                return true;
            }
            this.showNewMessageNotification();
            return false;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$showNewMessageNotification() {
        if (!StorageManager.isFileEncryptedNativeOrEmulated()) {
            return;
        }
        this.log("Show new message notification.");
        PendingIntent intent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_OPEN_SMS_APP), 0x40000000);
        Notification.Builder mBuilder = new Notification.Builder(this.mContext).setSmallIcon(17301646).setAutoCancel(true).setVisibility(1).setDefaults(-1).setContentTitle(this.mContext.getString(17040343)).setContentText(this.mContext.getString(17040342)).setContentIntent(intent).setChannelId("sms");
        NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        mNotificationManager.notify("InboundSmsHandler", 1, mBuilder.build());
    }

    private static final void $$robo$$com_android_internal_telephony_InboundSmsHandler$cancelNewMessageNotification(Context context) {
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.cancel("InboundSmsHandler", 1);
    }

    private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$filterSms(byte[][] pdus, int destPort, InboundSmsTracker tracker, SmsBroadcastReceiver resultReceiver, boolean userUnlocked) {
        CarrierServicesSmsFilterCallback filterCallback = new CarrierServicesSmsFilterCallback(this, pdus, destPort, tracker.getFormat(), resultReceiver, userUnlocked);
        CarrierServicesSmsFilter carrierServicesFilter = new CarrierServicesSmsFilter(this.mContext, this.mPhone, pdus, destPort, tracker.getFormat(), filterCallback, this.getName());
        if (carrierServicesFilter.filter()) {
            return true;
        }
        if (VisualVoicemailSmsFilter.filter(this.mContext, pdus, tracker.getFormat(), destPort, this.mPhone.getSubId())) {
            this.log("Visual voicemail SMS dropped");
            this.dropSms(resultReceiver);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchIntent(Intent intent, String permission2, int appOp, Bundle opts, BroadcastReceiver resultReceiver, UserHandle user) {
        intent.addFlags(0x8000000);
        String action = intent.getAction();
        if ("android.provider.Telephony.SMS_DELIVER".equals(action) || "android.provider.Telephony.SMS_RECEIVED".equals(action) || "android.provider.Telephony.WAP_PUSH_DELIVER".equals(action) || "android.provider.Telephony.WAP_PUSH_RECEIVED".equals(action)) {
            intent.addFlags(0x10000000);
        }
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        if (user.equals(UserHandle.ALL)) {
            int[] users = null;
            try {
                users = ActivityManager.getService().getRunningUserIds();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (users == null) {
                users = new int[]{user.getIdentifier()};
            }
            for (int i = users.length - 1; i >= 0; --i) {
                UserInfo info;
                UserHandle targetUser = new UserHandle(users[i]);
                if (users[i] != 0 && (this.mUserManager.hasUserRestriction("no_sms", targetUser) || (info = this.mUserManager.getUserInfo(users[i])) == null || info.isManagedProfile())) continue;
                this.mContext.sendOrderedBroadcastAsUser(intent, targetUser, permission2, appOp, opts, users[i] == 0 ? resultReceiver : null, this.getHandler(), -1, null, null);
            }
        } else {
            this.mContext.sendOrderedBroadcastAsUser(intent, user, permission2, appOp, opts, resultReceiver, this.getHandler(), -1, null, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$deleteFromRawTable(String deleteWhere, String[] deleteWhereArgs, int deleteType) {
        Uri uri = deleteType == 1 ? sRawUriPermanentDelete : sRawUri;
        int rows = this.mResolver.delete(uri, deleteWhere, deleteWhereArgs);
        if (rows == 0) {
            this.loge("No rows were deleted from raw table!");
        } else {
            this.log("Deleted " + rows + " rows from raw table.");
        }
    }

    private final Bundle $$robo$$com_android_internal_telephony_InboundSmsHandler$handleSmsWhitelisting(ComponentName target) {
        String reason;
        String pkgName;
        if (target != null) {
            pkgName = target.getPackageName();
            reason = "sms-app";
        } else {
            pkgName = this.mContext.getPackageName();
            reason = "sms-broadcast";
        }
        try {
            long duration = this.mDeviceIdleController.addPowerSaveTempWhitelistAppForSms(pkgName, 0, reason);
            BroadcastOptions bopts = BroadcastOptions.makeBasic();
            bopts.setTemporaryAppWhitelistDuration(duration);
            return bopts.toBundle();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchSmsDeliveryIntent(byte[][] pdus, String format, int destPort, SmsBroadcastReceiver resultReceiver) {
        Intent intent = new Intent();
        intent.putExtra("pdus", (Serializable)pdus);
        intent.putExtra("format", format);
        if (destPort == -1) {
            AppSmsManager appManager;
            Uri uri;
            intent.setAction("android.provider.Telephony.SMS_DELIVER");
            ComponentName componentName = SmsApplication.getDefaultSmsApplication(this.mContext, true);
            if (componentName != null) {
                intent.setComponent(componentName);
                this.log("Delivering SMS to: " + componentName.getPackageName() + " " + componentName.getClassName());
            } else {
                intent.setComponent(null);
            }
            if (SmsManager.getDefault().getAutoPersisting() && (uri = this.writeInboxMessage(intent)) != null) {
                intent.putExtra("uri", uri.toString());
            }
            if ((appManager = this.mPhone.getAppSmsManager()).handleSmsReceivedIntent(intent)) {
                this.dropSms(resultReceiver);
                return;
            }
        } else {
            intent.setAction("android.intent.action.DATA_SMS_RECEIVED");
            Uri uri = Uri.parse("sms://localhost:" + destPort);
            intent.setData(uri);
            intent.setComponent(null);
            intent.addFlags(0x1000000);
        }
        Bundle options = this.handleSmsWhitelisting(intent.getComponent());
        this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, options, resultReceiver, UserHandle.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$duplicateExists(InboundSmsTracker tracker) throws SQLException {
        String address = tracker.getAddress();
        String refNumber = Integer.toString(tracker.getReferenceNumber());
        String count = Integer.toString(tracker.getMessageCount());
        int sequence = tracker.getSequenceNumber();
        String seqNumber = Integer.toString(sequence);
        String date = Long.toString(tracker.getTimestamp());
        String messageBody = tracker.getMessageBody();
        String where = tracker.getMessageCount() == 1 ? "address=? AND reference_number=? AND count=? AND sequence=? AND date=? AND message_body=?" : tracker.getQueryForMultiPartDuplicates();
        try (Cursor cursor = null;){
            cursor = this.mResolver.query(sRawUri, PDU_PROJECTION, where, new String[]{address, refNumber, count, seqNumber, date, messageBody}, null);
            if (cursor != null && cursor.moveToNext()) {
                this.loge("Discarding duplicate message segment, refNumber=" + refNumber + " seqNumber=" + seqNumber + " count=" + count);
                String oldPduString = cursor.getString(0);
                byte[] pdu = tracker.getPdu();
                byte[] oldPdu = HexDump.hexStringToByteArray(oldPduString);
                if (!Arrays.equals(oldPdu, tracker.getPdu())) {
                    this.loge("Warning: dup message segment PDU of length " + pdu.length + " is different from existing PDU of length " + oldPdu.length);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTable(InboundSmsTracker tracker, boolean deDup) {
        block8: {
            if (deDup) {
                try {
                    if (this.duplicateExists(tracker)) {
                        return 5;
                    }
                    break block8;
                }
                catch (SQLException e) {
                    this.loge("Can't access SMS database", e);
                    return 2;
                }
            }
            this.logd("Skipped message de-duping logic");
        }
        String address = tracker.getAddress();
        String refNumber = Integer.toString(tracker.getReferenceNumber());
        String count = Integer.toString(tracker.getMessageCount());
        ContentValues values = tracker.getContentValues();
        Uri newUri = this.mResolver.insert(sRawUri, values);
        this.log("URI of new row -> " + newUri);
        try {
            long rowId = ContentUris.parseId(newUri);
            if (tracker.getMessageCount() == 1) {
                tracker.setDeleteWhere("_id=?", new String[]{Long.toString(rowId)});
            } else {
                String[] deleteWhereArgs = new String[]{address, refNumber, count};
                tracker.setDeleteWhere(tracker.getQueryForSegments(), deleteWhereArgs);
            }
            return 1;
        }
        catch (Exception e) {
            this.loge("error parsing URI for new row: " + newUri, e);
            return 2;
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$isCurrentFormat3gpp2() {
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        return 2 == activePhone;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$dropSms(SmsBroadcastReceiver receiver) {
        this.deleteFromRawTable(receiver.mDeleteWhere, receiver.mDeleteWhereArgs, 2);
        this.sendMessage(3);
    }

    private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$isSkipNotifyFlagSet(int callbackResult) {
        return (callbackResult & 2) > 0;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$log(String s) {
        Rlog.d(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(String s) {
        Rlog.e(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$com_android_internal_telephony_InboundSmsHandler$writeInboxMessage(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent(intent);
        if (messages == null || messages.length < 1) {
            this.loge("Failed to parse SMS pdu");
            return null;
        }
        for (SmsMessage smsMessage : messages) {
            try {
                smsMessage.getDisplayMessageBody();
            }
            catch (NullPointerException e) {
                this.loge("NPE inside SmsMessage");
                return null;
            }
        }
        ContentValues values = InboundSmsHandler.parseSmsMessage(messages);
        long identity = Binder.clearCallingIdentity();
        try {
            Uri uri = this.mContext.getContentResolver().insert(Telephony.Sms.Inbox.CONTENT_URI, values);
            return uri;
        }
        catch (Exception exception) {
            this.loge("Failed to persist inbox message", exception);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    private static final ContentValues $$robo$$com_android_internal_telephony_InboundSmsHandler$parseSmsMessage(SmsMessage[] msgs) {
        SmsMessage sms = msgs[0];
        ContentValues values = new ContentValues();
        values.put("address", sms.getDisplayOriginatingAddress());
        values.put("body", InboundSmsHandler.buildMessageBodyFromPdus(msgs));
        values.put("date_sent", sms.getTimestampMillis());
        values.put("date", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        values.put("protocol", sms.getProtocolIdentifier());
        values.put("seen", 0);
        values.put("read", 0);
        String subject = sms.getPseudoSubject();
        if (!TextUtils.isEmpty(subject)) {
            values.put("subject", subject);
        }
        values.put("reply_path_present", sms.isReplyPathPresent() ? 1 : 0);
        values.put("service_center", sms.getServiceCenterAddress());
        return values;
    }

    private static final String $$robo$$com_android_internal_telephony_InboundSmsHandler$buildMessageBodyFromPdus(SmsMessage[] msgs) {
        if (msgs.length == 1) {
            return InboundSmsHandler.replaceFormFeeds(msgs[0].getDisplayMessageBody());
        }
        StringBuilder body = new StringBuilder();
        for (SmsMessage msg : msgs) {
            body.append(msg.getDisplayMessageBody());
        }
        return InboundSmsHandler.replaceFormFeeds(body.toString());
    }

    private static final String $$robo$$com_android_internal_telephony_InboundSmsHandler$replaceFormFeeds(String s) {
        return s == null ? "" : s.replace('\f', '\n');
    }

    @VisibleForTesting
    private final PowerManager.WakeLock $$robo$$com_android_internal_telephony_InboundSmsHandler$getWakeLock() {
        return this.mWakeLock;
    }

    @VisibleForTesting
    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$getWakeLockTimeout() {
        return this.mWakeLockTimeout;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$setWakeLockTimeout(int timeOut) {
        this.mWakeLockTimeout = timeOut;
    }

    private static final void $$robo$$com_android_internal_telephony_InboundSmsHandler$registerNewMessageNotificationActionHandler(Context context) {
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction(ACTION_OPEN_SMS_APP);
        context.registerReceiver(new NewMessageNotificationActionReceiver(null), userFilter);
    }

    static void __staticInitializer__() {
        PDU_PROJECTION = new String[]{"pdu"};
        PDU_SEQUENCE_PORT_PROJECTION = new String[]{"pdu", "sequence", "destination_port", "display_originating_addr"};
        PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING = new HashMap<Integer, Integer>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_telephony_InboundSmsHandler_1$__constructor__() {
                this.put(0, 0);
                this.put(1, 1);
                this.put(2, 2);
                this.put(9, 3);
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_telephony_InboundSmsHandler_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_1$__constructor__(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
        sRawUriPermanentDelete = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw/permanentDelete");
        ACTION_OPEN_SMS_APP = "com.android.internal.telephony.OPEN_DEFAULT_SMS_APP";
    }

    private void __constructor__(String string2, Context context, SmsStorageMonitor smsStorageMonitor, Phone phone, CellBroadcastHandler cellBroadcastHandler) {
        this.$$robo$$com_android_internal_telephony_InboundSmsHandler$__constructor__(string2, context, smsStorageMonitor, phone, cellBroadcastHandler);
    }

    public InboundSmsHandler(String string2, Context context, SmsStorageMonitor smsStorageMonitor, Phone phone, CellBroadcastHandler cellBroadcastHandler) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler$__constructor__(java.lang.String android.content.Context com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.Phone com.android.internal.telephony.CellBroadcastHandler ), this, string2, context, smsStorageMonitor, phone, cellBroadcastHandler);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispose(), this);
    }

    public void updatePhoneObject(Phone phone) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_InboundSmsHandler$updatePhoneObject(com.android.internal.telephony.Phone ), this, phone);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$com_android_internal_telephony_InboundSmsHandler$onQuitting(), this);
    }

    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_InboundSmsHandler$getPhone(), this);
    }

    private void handleNewSms(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleNewSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$handleNewSms(android.os.AsyncResult ), this, asyncResult);
    }

    private void handleInjectSms(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleInjectSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$handleInjectSms(android.os.AsyncResult ), this, asyncResult);
    }

    private int dispatchMessage(SmsMessageBase smsMessageBase) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchMessage(com.android.internal.telephony.SmsMessageBase ), this, smsMessageBase);
    }

    protected void onUpdatePhoneObject(Phone phone) {
        InvokeDynamicSupport.bootstrap("onUpdatePhoneObject", $$robo$$com_android_internal_telephony_InboundSmsHandler$onUpdatePhoneObject(com.android.internal.telephony.Phone ), this, phone);
    }

    private void notifyAndAcknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("notifyAndAcknowledgeLastIncomingSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$notifyAndAcknowledgeLastIncomingSms(boolean int android.os.Message ), this, bl, n, message);
    }

    protected int dispatchNormalMessage(SmsMessageBase smsMessageBase) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchNormalMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchNormalMessage(com.android.internal.telephony.SmsMessageBase ), this, smsMessageBase);
    }

    protected int addTrackerToRawTableAndSendMessage(InboundSmsTracker inboundSmsTracker, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("addTrackerToRawTableAndSendMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTableAndSendMessage(com.android.internal.telephony.InboundSmsTracker boolean ), this, inboundSmsTracker, bl);
    }

    private boolean processMessagePart(InboundSmsTracker inboundSmsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("processMessagePart", $$robo$$com_android_internal_telephony_InboundSmsHandler$processMessagePart(com.android.internal.telephony.InboundSmsTracker ), this, inboundSmsTracker);
    }

    private boolean processMessagePartWithUserLocked(InboundSmsTracker inboundSmsTracker, byte[][] byArray, int n, SmsBroadcastReceiver smsBroadcastReceiver) {
        return (boolean)InvokeDynamicSupport.bootstrap("processMessagePartWithUserLocked", $$robo$$com_android_internal_telephony_InboundSmsHandler$processMessagePartWithUserLocked(com.android.internal.telephony.InboundSmsTracker byte[][] int com.android.internal.telephony.InboundSmsHandler$SmsBroadcastReceiver ), this, inboundSmsTracker, byArray, n, smsBroadcastReceiver);
    }

    private void showNewMessageNotification() {
        InvokeDynamicSupport.bootstrap("showNewMessageNotification", $$robo$$com_android_internal_telephony_InboundSmsHandler$showNewMessageNotification(), this);
    }

    static void cancelNewMessageNotification(Context context) {
        InvokeDynamicSupport.bootstrapStatic("cancelNewMessageNotification", $$robo$$com_android_internal_telephony_InboundSmsHandler$cancelNewMessageNotification(android.content.Context ), (Context)context);
    }

    private boolean filterSms(byte[][] byArray, int n, InboundSmsTracker inboundSmsTracker, SmsBroadcastReceiver smsBroadcastReceiver, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$filterSms(byte[][] int com.android.internal.telephony.InboundSmsTracker com.android.internal.telephony.InboundSmsHandler$SmsBroadcastReceiver boolean ), this, byArray, n, inboundSmsTracker, smsBroadcastReceiver, bl);
    }

    public void dispatchIntent(Intent intent, String string2, int n, Bundle bundle, BroadcastReceiver broadcastReceiver, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("dispatchIntent", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchIntent(android.content.Intent java.lang.String int android.os.Bundle android.content.BroadcastReceiver android.os.UserHandle ), this, intent, string2, n, bundle, broadcastReceiver, userHandle);
    }

    private void deleteFromRawTable(String string2, String[] stringArray, int n) {
        InvokeDynamicSupport.bootstrap("deleteFromRawTable", $$robo$$com_android_internal_telephony_InboundSmsHandler$deleteFromRawTable(java.lang.String java.lang.String[] int ), this, string2, stringArray, n);
    }

    private Bundle handleSmsWhitelisting(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("handleSmsWhitelisting", $$robo$$com_android_internal_telephony_InboundSmsHandler$handleSmsWhitelisting(android.content.ComponentName ), this, componentName);
    }

    private void dispatchSmsDeliveryIntent(byte[][] byArray, String string2, int n, SmsBroadcastReceiver smsBroadcastReceiver) {
        InvokeDynamicSupport.bootstrap("dispatchSmsDeliveryIntent", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchSmsDeliveryIntent(byte[][] java.lang.String int com.android.internal.telephony.InboundSmsHandler$SmsBroadcastReceiver ), this, byArray, string2, n, smsBroadcastReceiver);
    }

    private boolean duplicateExists(InboundSmsTracker inboundSmsTracker) throws SQLException {
        return (boolean)InvokeDynamicSupport.bootstrap("duplicateExists", $$robo$$com_android_internal_telephony_InboundSmsHandler$duplicateExists(com.android.internal.telephony.InboundSmsTracker ), this, inboundSmsTracker);
    }

    private int addTrackerToRawTable(InboundSmsTracker inboundSmsTracker, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("addTrackerToRawTable", $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTable(com.android.internal.telephony.InboundSmsTracker boolean ), this, inboundSmsTracker, bl);
    }

    static boolean isCurrentFormat3gpp2() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCurrentFormat3gpp2", $$robo$$com_android_internal_telephony_InboundSmsHandler$isCurrentFormat3gpp2());
    }

    private void dropSms(SmsBroadcastReceiver smsBroadcastReceiver) {
        InvokeDynamicSupport.bootstrap("dropSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$dropSms(com.android.internal.telephony.InboundSmsHandler$SmsBroadcastReceiver ), this, smsBroadcastReceiver);
    }

    private boolean isSkipNotifyFlagSet(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSkipNotifyFlagSet", $$robo$$com_android_internal_telephony_InboundSmsHandler$isSkipNotifyFlagSet(int ), this, n);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_InboundSmsHandler$log(java.lang.String ), this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(java.lang.String ), this, string2);
    }

    @Override
    protected void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(java.lang.String java.lang.Throwable ), this, string2, throwable);
    }

    private Uri writeInboxMessage(Intent intent) {
        return InvokeDynamicSupport.bootstrap("writeInboxMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$writeInboxMessage(android.content.Intent ), this, intent);
    }

    private static ContentValues parseSmsMessage(SmsMessage[] smsMessageArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseSmsMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$parseSmsMessage(android.telephony.SmsMessage[] ), (SmsMessage[])smsMessageArray);
    }

    private static String buildMessageBodyFromPdus(SmsMessage[] smsMessageArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildMessageBodyFromPdus", $$robo$$com_android_internal_telephony_InboundSmsHandler$buildMessageBodyFromPdus(android.telephony.SmsMessage[] ), (SmsMessage[])smsMessageArray);
    }

    private static String replaceFormFeeds(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("replaceFormFeeds", $$robo$$com_android_internal_telephony_InboundSmsHandler$replaceFormFeeds(java.lang.String ), (String)string2);
    }

    public PowerManager.WakeLock getWakeLock() {
        return InvokeDynamicSupport.bootstrap("getWakeLock", $$robo$$com_android_internal_telephony_InboundSmsHandler$getWakeLock(), this);
    }

    public int getWakeLockTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getWakeLockTimeout", $$robo$$com_android_internal_telephony_InboundSmsHandler$getWakeLockTimeout(), this);
    }

    private void setWakeLockTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setWakeLockTimeout", $$robo$$com_android_internal_telephony_InboundSmsHandler$setWakeLockTimeout(int ), this, n);
    }

    static void registerNewMessageNotificationActionHandler(Context context) {
        InvokeDynamicSupport.bootstrapStatic("registerNewMessageNotificationActionHandler", $$robo$$com_android_internal_telephony_InboundSmsHandler$registerNewMessageNotificationActionHandler(android.content.Context ), (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(InboundSmsHandler.class);
    }

    public /* synthetic */ InboundSmsHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InboundSmsHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NewMessageNotificationActionReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$__constructor__() {
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$onReceive(Context context, Intent intent) {
            if (ACTION_OPEN_SMS_APP.equals(intent.getAction())) {
                context.startActivity(context.getPackageManager().getLaunchIntentForPackage(Telephony.Sms.getDefaultSmsPackage(context)));
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$__constructor__();
        }

        public NewMessageNotificationActionReceiver() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$__constructor__(), this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$onReceive(android.content.Context android.content.Intent ), this, context, intent);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$__constructor__(var1_1);
        }

        public /* synthetic */ NewMessageNotificationActionReceiver(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_NewMessageNotificationActionReceiver$__constructor__(com.android.internal.telephony.InboundSmsHandler$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NewMessageNotificationActionReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CarrierServicesSmsFilterCallback
    implements CarrierServicesSmsFilter.CarrierServicesSmsFilterCallbackInterface,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private byte[][] mPdus;
        private int mDestPort;
        private String mSmsFormat;
        private SmsBroadcastReceiver mSmsBroadcastReceiver;
        private boolean mUserUnlocked;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_CarrierServicesSmsFilterCallback$__constructor__(InboundSmsHandler inboundSmsHandler, byte[][] pdus, int destPort, String smsFormat, SmsBroadcastReceiver smsBroadcastReceiver, boolean userUnlocked) {
            this.this$0 = inboundSmsHandler;
            this.mPdus = pdus;
            this.mDestPort = destPort;
            this.mSmsFormat = smsFormat;
            this.mSmsBroadcastReceiver = smsBroadcastReceiver;
            this.mUserUnlocked = userUnlocked;
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_CarrierServicesSmsFilterCallback$onFilterComplete(int result) {
            this.this$0.logv("onFilterComplete: result is " + result);
            if ((result & 1) == 0) {
                if (VisualVoicemailSmsFilter.filter(this.this$0.mContext, this.mPdus, this.mSmsFormat, this.mDestPort, this.this$0.mPhone.getSubId())) {
                    this.this$0.log("Visual voicemail SMS dropped");
                    this.this$0.dropSms(this.mSmsBroadcastReceiver);
                    return;
                }
                if (this.mUserUnlocked) {
                    this.this$0.dispatchSmsDeliveryIntent(this.mPdus, this.mSmsFormat, this.mDestPort, this.mSmsBroadcastReceiver);
                } else {
                    if (!this.this$0.isSkipNotifyFlagSet(result)) {
                        this.this$0.showNewMessageNotification();
                    }
                    this.this$0.sendMessage(3);
                }
            } else {
                this.this$0.dropSms(this.mSmsBroadcastReceiver);
            }
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler, byte[][] byArray, int n, String string2, SmsBroadcastReceiver smsBroadcastReceiver, boolean bl) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_CarrierServicesSmsFilterCallback$__constructor__(inboundSmsHandler, byArray, n, string2, smsBroadcastReceiver, bl);
        }

        public CarrierServicesSmsFilterCallback(InboundSmsHandler inboundSmsHandler, byte[][] byArray, int n, String string2, SmsBroadcastReceiver smsBroadcastReceiver, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_CarrierServicesSmsFilterCallback$__constructor__(com.android.internal.telephony.InboundSmsHandler byte[][] int java.lang.String com.android.internal.telephony.InboundSmsHandler$SmsBroadcastReceiver boolean ), this, inboundSmsHandler, byArray, n, string2, smsBroadcastReceiver, bl);
        }

        @Override
        public void onFilterComplete(int n) {
            InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$com_android_internal_telephony_InboundSmsHandler_CarrierServicesSmsFilterCallback$onFilterComplete(int ), this, n);
        }

        public /* synthetic */ CarrierServicesSmsFilterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServicesSmsFilterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class SmsBroadcastReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mDeleteWhere;
        private String[] mDeleteWhereArgs;
        private long mBroadcastTimeNano;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$__constructor__(InboundSmsHandler inboundSmsHandler, InboundSmsTracker tracker) {
            this.this$0 = inboundSmsHandler;
            this.mDeleteWhere = tracker.getDeleteWhere();
            this.mDeleteWhereArgs = tracker.getDeleteWhereArgs();
            this.mBroadcastTimeNano = (long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.provider.Telephony.SMS_DELIVER")) {
                intent.setAction("android.provider.Telephony.SMS_RECEIVED");
                intent.addFlags(0x1000000);
                intent.setComponent(null);
                Bundle options = this.this$0.handleSmsWhitelisting(null);
                this.this$0.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, options, this, UserHandle.ALL);
            } else if (action.equals("android.provider.Telephony.WAP_PUSH_DELIVER")) {
                intent.setAction("android.provider.Telephony.WAP_PUSH_RECEIVED");
                intent.setComponent(null);
                intent.addFlags(0x1000000);
                Bundle options = null;
                try {
                    long duration = this.this$0.mDeviceIdleController.addPowerSaveTempWhitelistAppForMms(this.this$0.mContext.getPackageName(), 0, "mms-broadcast");
                    BroadcastOptions bopts = BroadcastOptions.makeBasic();
                    bopts.setTemporaryAppWhitelistDuration(duration);
                    options = bopts.toBundle();
                }
                catch (RemoteException duration) {
                    // empty catch block
                }
                String mimeType = intent.getType();
                this.this$0.dispatchIntent(intent, WapPushOverSms.getPermissionForType(mimeType), WapPushOverSms.getAppOpsPermissionForIntent(mimeType), options, this, UserHandle.SYSTEM);
            } else {
                int rc;
                if (!("android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.SMS_RECEIVED".equals(action) || "android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.WAP_PUSH_RECEIVED".equals(action))) {
                    this.this$0.loge("unexpected BroadcastReceiver action: " + action);
                }
                if ((rc = this.getResultCode()) != -1 && rc != 1) {
                    this.this$0.loge("a broadcast receiver set the result code to " + rc + ", deleting from raw table anyway!");
                } else {
                    this.this$0.log("successful broadcast, deleting from raw table.");
                }
                this.this$0.deleteFromRawTable(this.mDeleteWhere, this.mDeleteWhereArgs, 2);
                this.this$0.sendMessage(3);
                int durationMillis = (int)((InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") - this.mBroadcastTimeNano) / 1000000L);
                if (durationMillis >= 5000) {
                    this.this$0.loge("Slow ordered broadcast completion time: " + durationMillis + " ms");
                } else {
                    this.this$0.log("ordered broadcast completed in: " + durationMillis + " ms");
                }
            }
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler, InboundSmsTracker inboundSmsTracker) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$__constructor__(inboundSmsHandler, inboundSmsTracker);
        }

        public SmsBroadcastReceiver(InboundSmsHandler inboundSmsHandler, InboundSmsTracker inboundSmsTracker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsTracker ), this, inboundSmsHandler, inboundSmsTracker);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$onReceive(android.content.Context android.content.Intent ), this, context, intent);
        }

        public /* synthetic */ SmsBroadcastReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsBroadcastReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class WaitingState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$enter() {
            this.this$0.log("entering Waiting state");
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$exit() {
            this.this$0.log("exiting Waiting state");
            this.this$0.setWakeLockTimeout(3000);
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$processMessage(Message msg) {
            this.this$0.log("WaitingState.processMessage:" + msg.what);
            switch (msg.what) {
                case 2: {
                    this.this$0.deferMessage(msg);
                    return true;
                }
                case 3: {
                    this.this$0.sendMessage(4);
                    this.this$0.transitionTo(this.this$0.mDeliveringState);
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(InboundSmsHandler x0, 1 x1) {
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(inboundSmsHandler);
        }

        public WaitingState(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), this, inboundSmsHandler);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(inboundSmsHandler, var2_2);
        }

        public /* synthetic */ WaitingState(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this(inboundSmsHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsHandler$1 ), this, inboundSmsHandler, var2_2);
        }

        public /* synthetic */ WaitingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DeliveringState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$enter() {
            this.this$0.log("entering Delivering state");
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$exit() {
            this.this$0.log("leaving Delivering state");
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$processMessage(Message msg) {
            this.this$0.log("DeliveringState.processMessage:" + msg.what);
            switch (msg.what) {
                case 1: {
                    this.this$0.handleNewSms((AsyncResult)msg.obj);
                    this.this$0.sendMessage(4);
                    return true;
                }
                case 8: {
                    this.this$0.handleInjectSms((AsyncResult)msg.obj);
                    this.this$0.sendMessage(4);
                    return true;
                }
                case 2: {
                    InboundSmsTracker inboundSmsTracker = (InboundSmsTracker)msg.obj;
                    if (this.this$0.processMessagePart(inboundSmsTracker)) {
                        this.this$0.transitionTo(this.this$0.mWaitingState);
                    } else {
                        this.this$0.log("No broadcast sent on processing EVENT_BROADCAST_SMS in Delivering state. Return to Idle state");
                        this.this$0.sendMessage(4);
                    }
                    return true;
                }
                case 4: {
                    this.this$0.transitionTo(this.this$0.mIdleState);
                    return true;
                }
                case 5: {
                    this.this$0.mWakeLock.release();
                    if (!this.this$0.mWakeLock.isHeld()) {
                        this.this$0.loge("mWakeLock released while delivering/broadcasting!");
                    }
                    return true;
                }
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(InboundSmsHandler x0, 1 x1) {
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(inboundSmsHandler);
        }

        public DeliveringState(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), this, inboundSmsHandler);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(inboundSmsHandler, var2_2);
        }

        public /* synthetic */ DeliveringState(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this(inboundSmsHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsHandler$1 ), this, inboundSmsHandler, var2_2);
        }

        public /* synthetic */ DeliveringState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeliveringState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class IdleState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$enter() {
            this.this$0.log("entering Idle state");
            this.this$0.sendMessageDelayed(5, (long)this.this$0.getWakeLockTimeout());
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$exit() {
            this.this$0.mWakeLock.acquire();
            this.this$0.log("acquired wakelock, leaving Idle state");
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$processMessage(Message msg) {
            this.this$0.log("IdleState.processMessage:" + msg.what);
            this.this$0.log("Idle state processing message type " + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: 
                case 8: {
                    this.this$0.deferMessage(msg);
                    this.this$0.transitionTo(this.this$0.mDeliveringState);
                    return true;
                }
                case 5: {
                    this.this$0.mWakeLock.release();
                    if (this.this$0.mWakeLock.isHeld()) {
                        this.this$0.log("mWakeLock is still held after release");
                    } else {
                        this.this$0.log("mWakeLock released");
                    }
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(InboundSmsHandler x0, 1 x1) {
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(inboundSmsHandler);
        }

        public IdleState(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), this, inboundSmsHandler);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(inboundSmsHandler, var2_2);
        }

        public /* synthetic */ IdleState(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this(inboundSmsHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsHandler$1 ), this, inboundSmsHandler, var2_2);
        }

        public /* synthetic */ IdleState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StartupState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$enter() {
            this.this$0.log("entering Startup state");
            this.this$0.setWakeLockTimeout(0);
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$processMessage(Message msg) {
            this.this$0.log("StartupState.processMessage:" + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: 
                case 8: {
                    this.this$0.deferMessage(msg);
                    return true;
                }
                case 6: {
                    this.this$0.transitionTo(this.this$0.mIdleState);
                    return true;
                }
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(InboundSmsHandler x0, 1 x1) {
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(inboundSmsHandler);
        }

        public StartupState(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), this, inboundSmsHandler);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(inboundSmsHandler, var2_2);
        }

        public /* synthetic */ StartupState(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this(inboundSmsHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsHandler$1 ), this, inboundSmsHandler, var2_2);
        }

        public /* synthetic */ StartupState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StartupState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DefaultState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$processMessage(Message msg) {
            switch (msg.what) {
                case 7: {
                    this.this$0.onUpdatePhoneObject((Phone)msg.obj);
                    break;
                }
                default: {
                    String errorText = "processMessage: unhandled message type " + msg.what + " currState=" + this.this$0.getCurrentState().getName();
                    if (Build.IS_DEBUGGABLE) {
                        this.this$0.loge("---- Dumping InboundSmsHandler ----");
                        this.this$0.loge("Total records=" + this.this$0.getLogRecCount());
                        for (int i = Math.max(this.this$0.getLogRecSize() - 20, 0); i < this.this$0.getLogRecSize(); ++i) {
                            this.this$0.loge("Rec[%d]: %s\n" + i + this.this$0.getLogRec(i).toString());
                        }
                        this.this$0.loge("---- Dumped InboundSmsHandler ----");
                        throw new RuntimeException(errorText);
                    }
                    this.this$0.loge(errorText);
                    break;
                }
            }
            return true;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(InboundSmsHandler x0, 1 x1) {
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(inboundSmsHandler);
        }

        public DefaultState(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), this, inboundSmsHandler);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(inboundSmsHandler, var2_2);
        }

        public /* synthetic */ DefaultState(InboundSmsHandler inboundSmsHandler, 1 var2_2) {
            this(inboundSmsHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsHandler$1 ), this, inboundSmsHandler, var2_2);
        }

        public /* synthetic */ DefaultState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

