/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.ZygoteConnection;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteServer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String TAG = "ZygoteServer";
    private static String ANDROID_SOCKET_PREFIX = "ANDROID_SOCKET_";
    private LocalServerSocket mServerSocket;
    private boolean mCloseSocketFd;
    private boolean mIsForkChild;

    private void $$robo$$com_android_internal_os_ZygoteServer$__constructor__() {
    }

    private final void $$robo$$com_android_internal_os_ZygoteServer$setForkChild() {
        this.mIsForkChild = true;
    }

    private final void $$robo$$com_android_internal_os_ZygoteServer$registerServerSocketFromEnv(String socketName) {
        if (this.mServerSocket == null) {
            int fileDesc;
            String fullSocketName = "ANDROID_SOCKET_" + socketName;
            try {
                String env = System.getenv(fullSocketName);
                fileDesc = Integer.parseInt(env);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(fullSocketName + " unset or invalid", ex);
            }
            try {
                FileDescriptor fd = new FileDescriptor();
                fd.setInt$(fileDesc);
                this.mServerSocket = new LocalServerSocket(fd);
                this.mCloseSocketFd = true;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to local socket '" + fileDesc + "'", ex);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteServer$registerServerSocketAtAbstractName(String socketName) {
        if (this.mServerSocket == null) {
            try {
                this.mServerSocket = new LocalServerSocket(socketName);
                this.mCloseSocketFd = false;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to abstract socket '" + socketName + "'", ex);
            }
        }
    }

    private final ZygoteConnection $$robo$$com_android_internal_os_ZygoteServer$acceptCommandPeer(String abiList) {
        try {
            return this.createNewConnection(this.mServerSocket.accept(), abiList);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException during accept()", ex);
        }
    }

    private final ZygoteConnection $$robo$$com_android_internal_os_ZygoteServer$createNewConnection(LocalSocket socket, String abiList) throws IOException {
        return new ZygoteConnection(socket, abiList);
    }

    private final void $$robo$$com_android_internal_os_ZygoteServer$closeServerSocket() {
        try {
            if (this.mServerSocket != null) {
                FileDescriptor fd = this.mServerSocket.getFileDescriptor();
                this.mServerSocket.close();
                if (fd != null && this.mCloseSocketFd) {
                    Os.close(fd);
                }
            }
        }
        catch (IOException ex) {
            Log.e("ZygoteServer", "Zygote:  error closing sockets", ex);
        }
        catch (ErrnoException ex) {
            Log.e("ZygoteServer", "Zygote:  error closing descriptor", ex);
        }
        this.mServerSocket = null;
    }

    private final FileDescriptor $$robo$$com_android_internal_os_ZygoteServer$getServerSocketFileDescriptor() {
        return this.mServerSocket.getFileDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Runnable $$robo$$com_android_internal_os_ZygoteServer$runSelectLoop(String abiList) {
        ArrayList<FileDescriptor> fds = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> peers = new ArrayList<ZygoteConnection>();
        fds.add(this.mServerSocket.getFileDescriptor());
        peers.add(null);
        block8: while (true) {
            int i;
            StructPollfd[] pollFds = new StructPollfd[fds.size()];
            for (i = 0; i < pollFds.length; ++i) {
                pollFds[i] = new StructPollfd();
                pollFds[i].fd = (FileDescriptor)fds.get(i);
                pollFds[i].events = (short)OsConstants.POLLIN;
            }
            try {
                Os.poll(pollFds, -1);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("poll failed", ex);
            }
            i = pollFds.length - 1;
            while (true) {
                block19: {
                    if (i < 0) continue block8;
                    if ((pollFds[i].revents & OsConstants.POLLIN) != 0) {
                        if (i == 0) {
                            ZygoteConnection newPeer = this.acceptCommandPeer(abiList);
                            peers.add(newPeer);
                            fds.add(newPeer.getFileDesciptor());
                        } else {
                            try {
                                ZygoteConnection connection = (ZygoteConnection)peers.get(i);
                                Runnable command = connection.processOneCommand(this);
                                if (this.mIsForkChild) {
                                    if (command == null) {
                                        throw new IllegalStateException("command == null");
                                    }
                                    Runnable runnable = command;
                                    return runnable;
                                }
                                if (command != null) {
                                    throw new IllegalStateException("command != null");
                                }
                                if (connection.isClosedByPeer()) {
                                    connection.closeSocket();
                                    peers.remove(i);
                                    fds.remove(i);
                                }
                            }
                            catch (Exception e) {
                                if (!this.mIsForkChild) {
                                    Slog.e("ZygoteServer", "Exception executing zygote command: ", e);
                                    ZygoteConnection conn = (ZygoteConnection)peers.remove(i);
                                    conn.closeSocket();
                                    fds.remove(i);
                                    break block19;
                                }
                                Log.e("ZygoteServer", "Caught post-fork exception in child process.", e);
                                throw e;
                            }
                            finally {
                                this.mIsForkChild = false;
                            }
                        }
                    }
                }
                --i;
            }
            break;
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_ZygoteServer$__constructor__();
    }

    public ZygoteServer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteServer$__constructor__(), this);
    }

    void setForkChild() {
        InvokeDynamicSupport.bootstrap("setForkChild", $$robo$$com_android_internal_os_ZygoteServer$setForkChild(), this);
    }

    void registerServerSocketFromEnv(String string2) {
        InvokeDynamicSupport.bootstrap("registerServerSocketFromEnv", $$robo$$com_android_internal_os_ZygoteServer$registerServerSocketFromEnv(java.lang.String ), this, string2);
    }

    void registerServerSocketAtAbstractName(String string2) {
        InvokeDynamicSupport.bootstrap("registerServerSocketAtAbstractName", $$robo$$com_android_internal_os_ZygoteServer$registerServerSocketAtAbstractName(java.lang.String ), this, string2);
    }

    private ZygoteConnection acceptCommandPeer(String string2) {
        return InvokeDynamicSupport.bootstrap("acceptCommandPeer", $$robo$$com_android_internal_os_ZygoteServer$acceptCommandPeer(java.lang.String ), this, string2);
    }

    protected ZygoteConnection createNewConnection(LocalSocket localSocket, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("createNewConnection", $$robo$$com_android_internal_os_ZygoteServer$createNewConnection(android.net.LocalSocket java.lang.String ), this, localSocket, string2);
    }

    void closeServerSocket() {
        InvokeDynamicSupport.bootstrap("closeServerSocket", $$robo$$com_android_internal_os_ZygoteServer$closeServerSocket(), this);
    }

    FileDescriptor getServerSocketFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getServerSocketFileDescriptor", $$robo$$com_android_internal_os_ZygoteServer$getServerSocketFileDescriptor(), this);
    }

    Runnable runSelectLoop(String string2) {
        return InvokeDynamicSupport.bootstrap("runSelectLoop", $$robo$$com_android_internal_os_ZygoteServer$runSelectLoop(java.lang.String ), this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteServer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

