/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KernelCpuSpeedReader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "KernelCpuSpeedReader";
    private String mProcFile;
    private int mNumSpeedSteps;
    private long[] mLastSpeedTimesMs;
    private long[] mDeltaSpeedTimesMs;
    private long mJiffyMillis;

    private void $$robo$$com_android_internal_os_KernelCpuSpeedReader$__constructor__(int cpuNumber, int numSpeedSteps) {
        this.mProcFile = String.format("/sys/devices/system/cpu/cpu%d/cpufreq/stats/time_in_state", cpuNumber);
        this.mNumSpeedSteps = numSpeedSteps;
        this.mLastSpeedTimesMs = new long[numSpeedSteps];
        this.mDeltaSpeedTimesMs = new long[numSpeedSteps];
        long jiffyHz = Os.sysconf(OsConstants._SC_CLK_TCK);
        this.mJiffyMillis = 1000L / jiffyHz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long[] $$robo$$com_android_internal_os_KernelCpuSpeedReader$readDelta() {
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            for (int speedIndex = 0; speedIndex < this.mLastSpeedTimesMs.length && (line = reader.readLine()) != null; ++speedIndex) {
                splitter.setString(line);
                splitter.next();
                long time = Long.parseLong((String)splitter.next()) * this.mJiffyMillis;
                this.mDeltaSpeedTimesMs[speedIndex] = time < this.mLastSpeedTimesMs[speedIndex] ? time : time - this.mLastSpeedTimesMs[speedIndex];
                this.mLastSpeedTimesMs[speedIndex] = time;
            }
        }
        catch (IOException e) {
            Slog.e("KernelCpuSpeedReader", "Failed to read cpu-freq: " + e.getMessage());
            Arrays.fill(this.mDeltaSpeedTimesMs, 0L);
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
        return this.mDeltaSpeedTimesMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long[] $$robo$$com_android_internal_os_KernelCpuSpeedReader$readAbsolute() {
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        long[] speedTimeMs = new long[this.mNumSpeedSteps];
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            for (int speedIndex = 0; speedIndex < this.mNumSpeedSteps && (line = reader.readLine()) != null; ++speedIndex) {
                long time;
                splitter.setString(line);
                splitter.next();
                speedTimeMs[speedIndex] = time = Long.parseLong((String)splitter.next()) * this.mJiffyMillis;
            }
        }
        catch (IOException e) {
            Slog.e("KernelCpuSpeedReader", "Failed to read cpu-freq: " + e.getMessage());
            Arrays.fill(speedTimeMs, 0L);
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
        return speedTimeMs;
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$com_android_internal_os_KernelCpuSpeedReader$__constructor__(n, n2);
    }

    public KernelCpuSpeedReader(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelCpuSpeedReader$__constructor__(int int ), this, n, n2);
    }

    public long[] readDelta() {
        return InvokeDynamicSupport.bootstrap("readDelta", $$robo$$com_android_internal_os_KernelCpuSpeedReader$readDelta(), this);
    }

    public long[] readAbsolute() {
        return InvokeDynamicSupport.bootstrap("readAbsolute", $$robo$$com_android_internal_os_KernelCpuSpeedReader$readAbsolute(), this);
    }

    public /* synthetic */ KernelCpuSpeedReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelCpuSpeedReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

