/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.SystemClock;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BinderCallsStats
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int CALL_SESSIONS_POOL_SIZE = 100;
    private static BinderCallsStats sInstance;
    private volatile boolean mDetailedTracking;
    @GuardedBy(value="mLock")
    private SparseArray<UidEntry> mUidEntries;
    private Queue<CallSession> mCallSessionsPool;
    private Object mLock;
    private long mStartTime;

    private void $$robo$$com_android_internal_os_BinderCallsStats$__constructor__() {
        this.mDetailedTracking = false;
        this.mUidEntries = new SparseArray();
        this.mCallSessionsPool = new ConcurrentLinkedQueue<CallSession>();
        this.mLock = new Object();
        this.mStartTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_os_BinderCallsStats$__constructor__(boolean detailedTracking) {
        this.mDetailedTracking = false;
        this.mUidEntries = new SparseArray();
        this.mCallSessionsPool = new ConcurrentLinkedQueue<CallSession>();
        this.mLock = new Object();
        this.mStartTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mDetailedTracking = detailedTracking;
    }

    private final CallSession $$robo$$com_android_internal_os_BinderCallsStats$callStarted(Binder binder, int code) {
        return this.callStarted(binder.getClass().getName(), code);
    }

    private final CallSession $$robo$$com_android_internal_os_BinderCallsStats$callStarted(String className, int code) {
        CallSession s = this.mCallSessionsPool.poll();
        if (s == null) {
            s = new CallSession();
        }
        s.mCallStat.className = className;
        s.mCallStat.msg = code;
        s.mStarted = this.getThreadTimeMicro();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BinderCallsStats$callEnded(CallSession s) {
        Preconditions.checkNotNull(s);
        long duration = this.mDetailedTracking ? this.getThreadTimeMicro() - s.mStarted : 1L;
        s.mCallingUId = Binder.getCallingUid();
        Object object = this.mLock;
        synchronized (object) {
            UidEntry uidEntry = this.mUidEntries.get(s.mCallingUId);
            if (uidEntry == null) {
                uidEntry = new UidEntry(s.mCallingUId);
                this.mUidEntries.put(s.mCallingUId, uidEntry);
            }
            if (this.mDetailedTracking) {
                CallStat callStat = uidEntry.mCallStats.get(s.mCallStat);
                if (callStat == null) {
                    callStat = new CallStat(s.mCallStat.className, s.mCallStat.msg);
                    uidEntry.mCallStats.put(callStat, callStat);
                }
                ++callStat.callCount;
                callStat.time += duration;
            }
            uidEntry.time += duration;
            ++uidEntry.callCount;
        }
        if (this.mCallSessionsPool.size() < 100) {
            this.mCallSessionsPool.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BinderCallsStats$dump(PrintWriter pw) {
        HashMap<Integer, Long> uidTimeMap = new HashMap<Integer, Long>();
        HashMap<Integer, Long> uidCallCountMap = new HashMap<Integer, Long>();
        long totalCallsCount = 0L;
        long totalCallsTime = 0L;
        pw.print("Start time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mStartTime));
        int uidEntriesSize = this.mUidEntries.size();
        ArrayList<UidEntry> entries = new ArrayList<UidEntry>();
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < uidEntriesSize; ++i) {
                UidEntry uidEntry = this.mUidEntries.valueAt(i);
                entries.add(uidEntry);
                totalCallsTime += uidEntry.time;
                Long l = (Long)uidTimeMap.get(uidEntry.uid);
                uidTimeMap.put(uidEntry.uid, l == null ? uidEntry.time : l + uidEntry.time);
                Long totalCallsPerUid = (Long)uidCallCountMap.get(uidEntry.uid);
                uidCallCountMap.put(uidEntry.uid, totalCallsPerUid == null ? uidEntry.callCount : totalCallsPerUid + uidEntry.callCount);
                totalCallsCount += uidEntry.callCount;
            }
        }
        if (this.mDetailedTracking) {
            pw.println("Raw data (uid,call_desc,time):");
            entries.sort((o1, o2) -> {
                if (o1.time < o2.time) {
                    return 1;
                }
                if (o1.time > o2.time) {
                    return -1;
                }
                return 0;
            });
            StringBuilder sb = new StringBuilder();
            for (UidEntry uidEntry : entries) {
                ArrayList<CallStat> arrayList = new ArrayList<CallStat>(uidEntry.mCallStats.keySet());
                arrayList.sort((o1, o2) -> {
                    if (o1.time < o2.time) {
                        return 1;
                    }
                    if (o1.time > o2.time) {
                        return -1;
                    }
                    return 0;
                });
                for (CallStat e : arrayList) {
                    sb.setLength(0);
                    sb.append("    ").append(uidEntry.uid).append(",").append(e).append(',').append(e.time);
                    pw.println(sb);
                }
            }
            pw.println();
            pw.println("Per UID Summary(UID: time, % of total_time, calls_count):");
            ArrayList uidTotals = new ArrayList(uidTimeMap.entrySet());
            uidTotals.sort((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
            for (Map.Entry entry : uidTotals) {
                Long callCount = (Long)uidCallCountMap.get(entry.getKey());
                pw.println(String.format("  %7d: %11d %3.0f%% %8d", entry.getKey(), entry.getValue(), 100.0 * (double)((Long)entry.getValue()).longValue() / (double)totalCallsTime, callCount));
            }
            pw.println();
            pw.println(String.format("  Summary: total_time=%d, calls_count=%d, avg_call_time=%.0f", totalCallsTime, totalCallsCount, (double)totalCallsTime / (double)totalCallsCount));
        } else {
            pw.println("Per UID Summary(UID: calls_count, % of total calls_count):");
            ArrayList uidTotals = new ArrayList(uidTimeMap.entrySet());
            uidTotals.sort((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
            for (Map.Entry entry : uidTotals) {
                Long l = (Long)uidCallCountMap.get(entry.getKey());
                pw.println(String.format("    %7d: %8d %3.0f%%", entry.getKey(), l, 100.0 * (double)((Long)entry.getValue()).longValue() / (double)totalCallsTime));
            }
        }
    }

    private final long $$robo$$com_android_internal_os_BinderCallsStats$getThreadTimeMicro() {
        return this.mDetailedTracking ? SystemClock.currentThreadTimeMicro() : 0L;
    }

    private static final BinderCallsStats $$robo$$com_android_internal_os_BinderCallsStats$getInstance() {
        return sInstance;
    }

    private final void $$robo$$com_android_internal_os_BinderCallsStats$setDetailedTracking(boolean enabled) {
        if (enabled != this.mDetailedTracking) {
            this.reset();
            this.mDetailedTracking = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BinderCallsStats$reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidEntries.clear();
            this.mStartTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
    }

    static void __staticInitializer__() {
        sInstance = new BinderCallsStats();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_BinderCallsStats$__constructor__();
    }

    public BinderCallsStats() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BinderCallsStats$__constructor__(), this);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$com_android_internal_os_BinderCallsStats$__constructor__(bl);
    }

    public BinderCallsStats(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BinderCallsStats$__constructor__(boolean ), this, bl);
    }

    public CallSession callStarted(Binder binder, int n) {
        return InvokeDynamicSupport.bootstrap("callStarted", $$robo$$com_android_internal_os_BinderCallsStats$callStarted(android.os.Binder int ), this, binder, n);
    }

    private CallSession callStarted(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("callStarted", $$robo$$com_android_internal_os_BinderCallsStats$callStarted(java.lang.String int ), this, string2, n);
    }

    public void callEnded(CallSession callSession) {
        InvokeDynamicSupport.bootstrap("callEnded", $$robo$$com_android_internal_os_BinderCallsStats$callEnded(com.android.internal.os.BinderCallsStats$CallSession ), this, callSession);
    }

    public void dump(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_os_BinderCallsStats$dump(java.io.PrintWriter ), this, printWriter);
    }

    private long getThreadTimeMicro() {
        return (long)InvokeDynamicSupport.bootstrap("getThreadTimeMicro", $$robo$$com_android_internal_os_BinderCallsStats$getThreadTimeMicro(), this);
    }

    public static BinderCallsStats getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_os_BinderCallsStats$getInstance());
    }

    public void setDetailedTracking(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDetailedTracking", $$robo$$com_android_internal_os_BinderCallsStats$setDetailedTracking(boolean ), this, bl);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BinderCallsStats$reset(), this);
    }

    static {
        RobolectricInternals.classInitializing(BinderCallsStats.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BinderCallsStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class UidEntry
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int uid;
        long time;
        long callCount;
        Map<CallStat, CallStat> mCallStats;

        private void $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$__constructor__(int uid) {
            this.mCallStats = new ArrayMap<CallStat, CallStat>();
            this.uid = uid;
        }

        private final String $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$toString() {
            return "UidEntry{time=" + this.time + ", callCount=" + this.callCount + ", mCallStats=" + this.mCallStats + '}';
        }

        private final boolean $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$equals(Object o) {
            if (this == o) {
                return true;
            }
            UidEntry uidEntry = (UidEntry)o;
            return this.uid == uidEntry.uid;
        }

        private final int $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$hashCode() {
            return this.uid;
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_os_BinderCallsStats_UidEntry$__constructor__(n);
        }

        public UidEntry(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$__constructor__(int ), this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$toString(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_os_BinderCallsStats_UidEntry$hashCode(), this);
        }

        public /* synthetic */ UidEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UidEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CallSession
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mCallingUId;
        long mStarted;
        CallStat mCallStat;

        private void $$robo$$com_android_internal_os_BinderCallsStats_CallSession$__constructor__() {
            this.mCallStat = new CallStat();
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_BinderCallsStats_CallSession$__constructor__();
        }

        public CallSession() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BinderCallsStats_CallSession$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallSession)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CallStat
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String className;
        int msg;
        long time;
        long callCount;

        private void $$robo$$com_android_internal_os_BinderCallsStats_CallStat$__constructor__() {
        }

        private void $$robo$$com_android_internal_os_BinderCallsStats_CallStat$__constructor__(String className, int msg) {
            this.className = className;
            this.msg = msg;
        }

        private final boolean $$robo$$com_android_internal_os_BinderCallsStats_CallStat$equals(Object o) {
            if (this == o) {
                return true;
            }
            CallStat callStat = (CallStat)o;
            return this.msg == callStat.msg && this.className.equals(callStat.className);
        }

        private final int $$robo$$com_android_internal_os_BinderCallsStats_CallStat$hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.msg;
            return result;
        }

        private final String $$robo$$com_android_internal_os_BinderCallsStats_CallStat$toString() {
            return this.className + "/" + this.msg;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_BinderCallsStats_CallStat$__constructor__();
        }

        public CallStat() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BinderCallsStats_CallStat$__constructor__(), this);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_os_BinderCallsStats_CallStat$__constructor__(string2, n);
        }

        public CallStat(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BinderCallsStats_CallStat$__constructor__(java.lang.String int ), this, string2, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_os_BinderCallsStats_CallStat$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_os_BinderCallsStats_CallStat$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_os_BinderCallsStats_CallStat$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallStat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

