/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Printer;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.inputmethod.InputMethodUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InputMethodSubtypeSwitchingController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG = false;
    private static int NOT_A_SUBTYPE_ID = -1;
    private InputMethodUtils.InputMethodSettings mSettings;
    private InputMethodAndSubtypeList mSubtypeList;
    private ControllerImpl mController;

    private static final int $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$calculateSubtypeId(InputMethodInfo imi, InputMethodSubtype subtype) {
        return subtype != null ? InputMethodUtils.getSubtypeIdFromHashCode(imi, subtype.hashCode()) : -1;
    }

    private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$__constructor__(InputMethodUtils.InputMethodSettings settings, Context context) {
        this.mSettings = settings;
        this.resetCircularListLocked(context);
    }

    private static final InputMethodSubtypeSwitchingController $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$createInstanceLocked(InputMethodUtils.InputMethodSettings settings, Context context) {
        return new InputMethodSubtypeSwitchingController(settings, context);
    }

    private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$onUserActionLocked(InputMethodInfo imi, InputMethodSubtype subtype) {
        if (this.mController == null) {
            return;
        }
        this.mController.onUserActionLocked(imi, subtype);
    }

    private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$resetCircularListLocked(Context context) {
        this.mSubtypeList = new InputMethodAndSubtypeList(context, this.mSettings);
        this.mController = ControllerImpl.createFrom(this.mController, this.mSubtypeList.getSortedInputMethodAndSubtypeList(false, false));
    }

    private final ImeSubtypeListItem $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$getNextInputMethodLocked(boolean onlyCurrentIme, InputMethodInfo imi, InputMethodSubtype subtype, boolean forward) {
        if (this.mController == null) {
            return null;
        }
        return this.mController.getNextInputMethod(onlyCurrentIme, imi, subtype, forward);
    }

    private final List<ImeSubtypeListItem> $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$getSortedInputMethodAndSubtypeListLocked(boolean includingAuxiliarySubtypes, boolean isScreenLocked) {
        return this.mSubtypeList.getSortedInputMethodAndSubtypeList(includingAuxiliarySubtypes, isScreenLocked);
    }

    private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$dump(Printer pw) {
        if (this.mController != null) {
            this.mController.dump(pw);
        } else {
            pw.println("    mController=null");
        }
    }

    static void __staticInitializer__() {
        TAG = InputMethodSubtypeSwitchingController.class.getSimpleName();
    }

    private static int calculateSubtypeId(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateSubtypeId", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$calculateSubtypeId(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), (InputMethodInfo)inputMethodInfo, (InputMethodSubtype)inputMethodSubtype);
    }

    private void __constructor__(InputMethodUtils.InputMethodSettings inputMethodSettings, Context context) {
        this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$__constructor__(inputMethodSettings, context);
    }

    public InputMethodSubtypeSwitchingController(InputMethodUtils.InputMethodSettings inputMethodSettings, Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$__constructor__(com.android.internal.inputmethod.InputMethodUtils$InputMethodSettings android.content.Context ), this, inputMethodSettings, context);
    }

    public static InputMethodSubtypeSwitchingController createInstanceLocked(InputMethodUtils.InputMethodSettings inputMethodSettings, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("createInstanceLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$createInstanceLocked(com.android.internal.inputmethod.InputMethodUtils$InputMethodSettings android.content.Context ), (InputMethodUtils.InputMethodSettings)inputMethodSettings, (Context)context);
    }

    public void onUserActionLocked(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        InvokeDynamicSupport.bootstrap("onUserActionLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$onUserActionLocked(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), this, inputMethodInfo, inputMethodSubtype);
    }

    public void resetCircularListLocked(Context context) {
        InvokeDynamicSupport.bootstrap("resetCircularListLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$resetCircularListLocked(android.content.Context ), this, context);
    }

    public ImeSubtypeListItem getNextInputMethodLocked(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getNextInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$getNextInputMethodLocked(boolean android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype boolean ), this, bl, inputMethodInfo, inputMethodSubtype, bl2);
    }

    public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeListLocked(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getSortedInputMethodAndSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$getSortedInputMethodAndSubtypeListLocked(boolean boolean ), this, bl, bl2);
    }

    public void dump(Printer printer) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController$dump(android.util.Printer ), this, printer);
    }

    static {
        RobolectricInternals.classInitializing(InputMethodSubtypeSwitchingController.class);
    }

    public /* synthetic */ InputMethodSubtypeSwitchingController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodSubtypeSwitchingController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public static class ControllerImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private DynamicRotationList mSwitchingAwareRotationList;
        private StaticRotationList mSwitchingUnawareRotationList;

        private static final ControllerImpl $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$createFrom(ControllerImpl currentInstance, List<ImeSubtypeListItem> sortedEnabledItems) {
            DynamicRotationList switchingAwareRotationList = null;
            List<ImeSubtypeListItem> switchingAwareImeSubtypes = ControllerImpl.filterImeSubtypeList(sortedEnabledItems, true);
            if (currentInstance != null && currentInstance.mSwitchingAwareRotationList != null && Objects.equals(currentInstance.mSwitchingAwareRotationList.mImeSubtypeList, switchingAwareImeSubtypes)) {
                switchingAwareRotationList = currentInstance.mSwitchingAwareRotationList;
            }
            if (switchingAwareRotationList == null) {
                switchingAwareRotationList = new DynamicRotationList(switchingAwareImeSubtypes, null);
            }
            StaticRotationList switchingUnawareRotationList = null;
            List<ImeSubtypeListItem> switchingUnawareImeSubtypes = ControllerImpl.filterImeSubtypeList(sortedEnabledItems, false);
            if (currentInstance != null && currentInstance.mSwitchingUnawareRotationList != null && Objects.equals(currentInstance.mSwitchingUnawareRotationList.mImeSubtypeList, switchingUnawareImeSubtypes)) {
                switchingUnawareRotationList = currentInstance.mSwitchingUnawareRotationList;
            }
            if (switchingUnawareRotationList == null) {
                switchingUnawareRotationList = new StaticRotationList(switchingUnawareImeSubtypes);
            }
            return new ControllerImpl(switchingAwareRotationList, switchingUnawareRotationList);
        }

        private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$__constructor__(DynamicRotationList switchingAwareRotationList, StaticRotationList switchingUnawareRotationList) {
            this.mSwitchingAwareRotationList = switchingAwareRotationList;
            this.mSwitchingUnawareRotationList = switchingUnawareRotationList;
        }

        private final ImeSubtypeListItem $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$getNextInputMethod(boolean onlyCurrentIme, InputMethodInfo imi, InputMethodSubtype subtype, boolean forward) {
            if (imi == null) {
                return null;
            }
            if (imi.supportsSwitchingToNextInputMethod()) {
                return this.mSwitchingAwareRotationList.getNextInputMethodLocked(onlyCurrentIme, imi, subtype, forward);
            }
            return this.mSwitchingUnawareRotationList.getNextInputMethodLocked(onlyCurrentIme, imi, subtype, forward);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$onUserActionLocked(InputMethodInfo imi, InputMethodSubtype subtype) {
            if (imi == null) {
                return;
            }
            if (imi.supportsSwitchingToNextInputMethod()) {
                this.mSwitchingAwareRotationList.onUserAction(imi, subtype);
            }
        }

        private static final List<ImeSubtypeListItem> $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$filterImeSubtypeList(List<ImeSubtypeListItem> items, boolean supportsSwitchingToNextInputMethod) {
            ArrayList<ImeSubtypeListItem> result = new ArrayList<ImeSubtypeListItem>();
            int ALL_ITEMS_COUNT = items.size();
            for (int i = 0; i < ALL_ITEMS_COUNT; ++i) {
                ImeSubtypeListItem item = items.get(i);
                if (item.mImi.supportsSwitchingToNextInputMethod() != supportsSwitchingToNextInputMethod) continue;
                result.add(item);
            }
            return result;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$dump(Printer pw) {
            pw.println("    mSwitchingAwareRotationList:");
            this.mSwitchingAwareRotationList.dump(pw, "      ");
            pw.println("    mSwitchingUnawareRotationList:");
            this.mSwitchingUnawareRotationList.dump(pw, "      ");
        }

        public static ControllerImpl createFrom(ControllerImpl controllerImpl, List<ImeSubtypeListItem> list) {
            return InvokeDynamicSupport.bootstrapStatic("createFrom", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$createFrom(com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$ControllerImpl java.util.List<com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$ImeSubtypeListItem> ), (ControllerImpl)controllerImpl, list);
        }

        private void __constructor__(DynamicRotationList dynamicRotationList, StaticRotationList staticRotationList) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$__constructor__(dynamicRotationList, staticRotationList);
        }

        public ControllerImpl(DynamicRotationList dynamicRotationList, StaticRotationList staticRotationList) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$__constructor__(com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$DynamicRotationList com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$StaticRotationList ), this, dynamicRotationList, staticRotationList);
        }

        public ImeSubtypeListItem getNextInputMethod(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype, boolean bl2) {
            return InvokeDynamicSupport.bootstrap("getNextInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$getNextInputMethod(boolean android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype boolean ), this, bl, inputMethodInfo, inputMethodSubtype, bl2);
        }

        public void onUserActionLocked(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            InvokeDynamicSupport.bootstrap("onUserActionLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$onUserActionLocked(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), this, inputMethodInfo, inputMethodSubtype);
        }

        private static List<ImeSubtypeListItem> filterImeSubtypeList(List<ImeSubtypeListItem> list, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("filterImeSubtypeList", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$filterImeSubtypeList(java.util.List<com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$ImeSubtypeListItem> boolean ), list, (boolean)bl);
        }

        protected void dump(Printer printer) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ControllerImpl$dump(android.util.Printer ), this, printer);
        }

        public /* synthetic */ ControllerImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ControllerImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DynamicRotationList
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String TAG;
        private List<ImeSubtypeListItem> mImeSubtypeList;
        private int[] mUsageHistoryOfSubtypeListItemIndex;

        private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$__constructor__(List<ImeSubtypeListItem> imeSubtypeListItems) {
            this.mImeSubtypeList = imeSubtypeListItems;
            this.mUsageHistoryOfSubtypeListItemIndex = new int[this.mImeSubtypeList.size()];
            int N = this.mImeSubtypeList.size();
            for (int i = 0; i < N; ++i) {
                this.mUsageHistoryOfSubtypeListItemIndex[i] = i;
            }
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$getUsageRank(InputMethodInfo imi, InputMethodSubtype subtype) {
            int currentSubtypeId = InputMethodSubtypeSwitchingController.calculateSubtypeId(imi, subtype);
            int N = this.mUsageHistoryOfSubtypeListItemIndex.length;
            for (int usageRank = 0; usageRank < N; ++usageRank) {
                int subtypeListItemIndex = this.mUsageHistoryOfSubtypeListItemIndex[usageRank];
                ImeSubtypeListItem subtypeListItem = this.mImeSubtypeList.get(subtypeListItemIndex);
                if (!subtypeListItem.mImi.equals(imi) || subtypeListItem.mSubtypeId != currentSubtypeId) continue;
                return usageRank;
            }
            return -1;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$onUserAction(InputMethodInfo imi, InputMethodSubtype subtype) {
            int currentUsageRank = this.getUsageRank(imi, subtype);
            if (currentUsageRank <= 0) {
                return;
            }
            int currentItemIndex = this.mUsageHistoryOfSubtypeListItemIndex[currentUsageRank];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUsageHistoryOfSubtypeListItemIndex, (int)0, (Object)this.mUsageHistoryOfSubtypeListItemIndex, (int)1, (int)currentUsageRank);
            this.mUsageHistoryOfSubtypeListItemIndex[0] = currentItemIndex;
        }

        private final ImeSubtypeListItem $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$getNextInputMethodLocked(boolean onlyCurrentIme, InputMethodInfo imi, InputMethodSubtype subtype, boolean forward) {
            int currentUsageRank = this.getUsageRank(imi, subtype);
            if (currentUsageRank < 0) {
                return null;
            }
            int N = this.mUsageHistoryOfSubtypeListItemIndex.length;
            for (int i = 1; i < N; ++i) {
                int offset = forward ? i : N - i;
                int subtypeListItemRank = (currentUsageRank + offset) % N;
                int subtypeListItemIndex = this.mUsageHistoryOfSubtypeListItemIndex[subtypeListItemRank];
                ImeSubtypeListItem subtypeListItem = this.mImeSubtypeList.get(subtypeListItemIndex);
                if (onlyCurrentIme && !imi.equals(subtypeListItem.mImi)) continue;
                return subtypeListItem;
            }
            return null;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$dump(Printer pw, String prefix) {
            for (int i = 0; i < this.mUsageHistoryOfSubtypeListItemIndex.length; ++i) {
                int rank = this.mUsageHistoryOfSubtypeListItemIndex[i];
                ImeSubtypeListItem item = this.mImeSubtypeList.get(i);
                pw.println(prefix + "rank=" + rank + " item=" + item);
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$__constructor__(List x0, 1 x1) {
        }

        static void __staticInitializer__() {
            TAG = DynamicRotationList.class.getSimpleName();
        }

        private void __constructor__(List<ImeSubtypeListItem> list) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$__constructor__(list);
        }

        public DynamicRotationList(List<ImeSubtypeListItem> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$__constructor__(java.util.List<com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$ImeSubtypeListItem> ), this, list);
        }

        private int getUsageRank(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            return (int)InvokeDynamicSupport.bootstrap("getUsageRank", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$getUsageRank(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), this, inputMethodInfo, inputMethodSubtype);
        }

        public void onUserAction(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            InvokeDynamicSupport.bootstrap("onUserAction", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$onUserAction(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), this, inputMethodInfo, inputMethodSubtype);
        }

        public ImeSubtypeListItem getNextInputMethodLocked(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype, boolean bl2) {
            return InvokeDynamicSupport.bootstrap("getNextInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$getNextInputMethodLocked(boolean android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype boolean ), this, bl, inputMethodInfo, inputMethodSubtype, bl2);
        }

        protected void dump(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$dump(android.util.Printer java.lang.String ), this, printer, string2);
        }

        private /* synthetic */ void __constructor__(List list, 1 var2_2) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$__constructor__(list, var2_2);
        }

        public /* synthetic */ DynamicRotationList(List list, 1 var2_2) {
            this(list);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_DynamicRotationList$__constructor__(java.util.List com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$1 ), this, list, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(DynamicRotationList.class);
        }

        public /* synthetic */ DynamicRotationList() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DynamicRotationList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StaticRotationList
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private List<ImeSubtypeListItem> mImeSubtypeList;

        private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$__constructor__(List<ImeSubtypeListItem> imeSubtypeList) {
            this.mImeSubtypeList = imeSubtypeList;
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$getIndex(InputMethodInfo imi, InputMethodSubtype subtype) {
            int currentSubtypeId = InputMethodSubtypeSwitchingController.calculateSubtypeId(imi, subtype);
            int N = this.mImeSubtypeList.size();
            for (int i = 0; i < N; ++i) {
                ImeSubtypeListItem isli = this.mImeSubtypeList.get(i);
                if (!imi.equals(isli.mImi) || isli.mSubtypeId != currentSubtypeId) continue;
                return i;
            }
            return -1;
        }

        private final ImeSubtypeListItem $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$getNextInputMethodLocked(boolean onlyCurrentIme, InputMethodInfo imi, InputMethodSubtype subtype, boolean forward) {
            if (imi == null) {
                return null;
            }
            if (this.mImeSubtypeList.size() <= 1) {
                return null;
            }
            int currentIndex = this.getIndex(imi, subtype);
            if (currentIndex < 0) {
                return null;
            }
            int N = this.mImeSubtypeList.size();
            for (int i = 1; i < N; ++i) {
                int offset = forward ? i : N - i;
                int candidateIndex = (currentIndex + offset) % N;
                ImeSubtypeListItem candidate = this.mImeSubtypeList.get(candidateIndex);
                if (onlyCurrentIme && !imi.equals(candidate.mImi)) continue;
                return candidate;
            }
            return null;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$dump(Printer pw, String prefix) {
            int N = this.mImeSubtypeList.size();
            for (int i = 0; i < N; ++i) {
                int rank = i;
                ImeSubtypeListItem item = this.mImeSubtypeList.get(i);
                pw.println(prefix + "rank=" + rank + " item=" + item);
            }
        }

        private void __constructor__(List<ImeSubtypeListItem> list) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$__constructor__(list);
        }

        public StaticRotationList(List<ImeSubtypeListItem> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$__constructor__(java.util.List<com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$ImeSubtypeListItem> ), this, list);
        }

        private int getIndex(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$getIndex(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), this, inputMethodInfo, inputMethodSubtype);
        }

        public ImeSubtypeListItem getNextInputMethodLocked(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype, boolean bl2) {
            return InvokeDynamicSupport.bootstrap("getNextInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$getNextInputMethodLocked(boolean android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype boolean ), this, bl, inputMethodInfo, inputMethodSubtype, bl2);
        }

        protected void dump(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_StaticRotationList$dump(android.util.Printer java.lang.String ), this, printer, string2);
        }

        public /* synthetic */ StaticRotationList() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StaticRotationList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InputMethodAndSubtypeList
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Context mContext;
        private PackageManager mPm;
        private String mSystemLocaleStr;
        private InputMethodUtils.InputMethodSettings mSettings;
        private TreeMap<InputMethodInfo, List<InputMethodSubtype>> mSortedImmis;

        private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList$__constructor__(Context context, InputMethodUtils.InputMethodSettings settings) {
            this.mSortedImmis = new TreeMap(new Comparator<InputMethodInfo>(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ InputMethodAndSubtypeList this$0;

                private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList_1$__constructor__(InputMethodAndSubtypeList this$0) {
                    this.this$0 = this$0;
                }

                private final int $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList_1$compare(InputMethodInfo imi1, InputMethodInfo imi2) {
                    if (imi2 == null) {
                        return 0;
                    }
                    if (imi1 == null) {
                        return 1;
                    }
                    if (this.this$0.mPm == null) {
                        return imi1.getId().compareTo(imi2.getId());
                    }
                    String imiId1 = imi1.loadLabel(this.this$0.mPm) + "/" + imi1.getId();
                    String imiId2 = imi2.loadLabel(this.this$0.mPm) + "/" + imi2.getId();
                    return imiId1.toString().compareTo(imiId2.toString());
                }

                private void __constructor__(InputMethodAndSubtypeList inputMethodAndSubtypeList) {
                    this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList_1$__constructor__(inputMethodAndSubtypeList);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList_1$__constructor__(com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$InputMethodAndSubtypeList ), this, inputMethodAndSubtypeList);
                }

                @Override
                public int compare(InputMethodInfo inputMethodInfo, InputMethodInfo inputMethodInfo2) {
                    return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList_1$compare(android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodInfo ), this, inputMethodInfo, inputMethodInfo2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mContext = context;
            this.mSettings = settings;
            this.mPm = context.getPackageManager();
            Locale locale = context.getResources().getConfiguration().locale;
            this.mSystemLocaleStr = locale != null ? locale.toString() : "";
        }

        private final List<ImeSubtypeListItem> $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList$getSortedInputMethodAndSubtypeList(boolean includeAuxiliarySubtypes, boolean isScreenLocked) {
            ArrayList<ImeSubtypeListItem> imList = new ArrayList<ImeSubtypeListItem>();
            HashMap<InputMethodInfo, List<InputMethodSubtype>> immis = this.mSettings.getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(this.mContext);
            if (immis == null || immis.size() == 0) {
                return Collections.emptyList();
            }
            if (isScreenLocked && includeAuxiliarySubtypes) {
                includeAuxiliarySubtypes = false;
            }
            this.mSortedImmis.clear();
            this.mSortedImmis.putAll(immis);
            for (InputMethodInfo imi : this.mSortedImmis.keySet()) {
                if (imi == null) continue;
                List<InputMethodSubtype> explicitlyOrImplicitlyEnabledSubtypeList = immis.get(imi);
                HashSet<String> enabledSubtypeSet = new HashSet<String>();
                for (InputMethodSubtype subtype : explicitlyOrImplicitlyEnabledSubtypeList) {
                    enabledSubtypeSet.add(String.valueOf(subtype.hashCode()));
                }
                CharSequence imeLabel = imi.loadLabel(this.mPm);
                if (enabledSubtypeSet.size() > 0) {
                    int subtypeCount = imi.getSubtypeCount();
                    for (int j = 0; j < subtypeCount; ++j) {
                        InputMethodSubtype subtype = imi.getSubtypeAt(j);
                        String subtypeHashCode = String.valueOf(subtype.hashCode());
                        if (!enabledSubtypeSet.contains(subtypeHashCode) || !includeAuxiliarySubtypes && subtype.isAuxiliary()) continue;
                        CharSequence subtypeLabel = subtype.overridesImplicitlyEnabledSubtype() ? null : subtype.getDisplayName(this.mContext, imi.getPackageName(), imi.getServiceInfo().applicationInfo);
                        imList.add(new ImeSubtypeListItem(imeLabel, subtypeLabel, imi, j, subtype.getLocale(), this.mSystemLocaleStr));
                        enabledSubtypeSet.remove(subtypeHashCode);
                    }
                    continue;
                }
                imList.add(new ImeSubtypeListItem(imeLabel, null, imi, -1, null, this.mSystemLocaleStr));
            }
            Collections.sort(imList);
            return imList;
        }

        private void __constructor__(Context context, InputMethodUtils.InputMethodSettings inputMethodSettings) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList$__constructor__(context, inputMethodSettings);
        }

        public InputMethodAndSubtypeList(Context context, InputMethodUtils.InputMethodSettings inputMethodSettings) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList$__constructor__(android.content.Context com.android.internal.inputmethod.InputMethodUtils$InputMethodSettings ), this, context, inputMethodSettings);
        }

        public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeList(boolean bl, boolean bl2) {
            return InvokeDynamicSupport.bootstrap("getSortedInputMethodAndSubtypeList", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_InputMethodAndSubtypeList$getSortedInputMethodAndSubtypeList(boolean boolean ), this, bl, bl2);
        }

        public /* synthetic */ InputMethodAndSubtypeList() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodAndSubtypeList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ImeSubtypeListItem
    implements Comparable<ImeSubtypeListItem> {
        public /* synthetic */ Object __robo_data__;
        public CharSequence mImeName;
        public CharSequence mSubtypeName;
        public InputMethodInfo mImi;
        public int mSubtypeId;
        public boolean mIsSystemLocale;
        public boolean mIsSystemLanguage;

        private void $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$__constructor__(CharSequence imeName, CharSequence subtypeName, InputMethodInfo imi, int subtypeId, String subtypeLocale, String systemLocale) {
            this.mImeName = imeName;
            this.mSubtypeName = subtypeName;
            this.mImi = imi;
            this.mSubtypeId = subtypeId;
            if (TextUtils.isEmpty(subtypeLocale)) {
                this.mIsSystemLocale = false;
                this.mIsSystemLanguage = false;
            } else {
                this.mIsSystemLocale = subtypeLocale.equals(systemLocale);
                if (this.mIsSystemLocale) {
                    this.mIsSystemLanguage = true;
                } else {
                    String systemLanguage = ImeSubtypeListItem.parseLanguageFromLocaleString(systemLocale);
                    String subtypeLanguage = ImeSubtypeListItem.parseLanguageFromLocaleString(subtypeLocale);
                    this.mIsSystemLanguage = systemLanguage.length() >= 2 && systemLanguage.equals(subtypeLanguage);
                }
            }
        }

        private static final String $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$parseLanguageFromLocaleString(String locale) {
            int idx = locale.indexOf(95);
            if (idx < 0) {
                return locale;
            }
            return locale.substring(0, idx);
        }

        private static final int $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$compareNullableCharSequences(CharSequence c1, CharSequence c2) {
            boolean empty1 = TextUtils.isEmpty(c1);
            boolean empty2 = TextUtils.isEmpty(c2);
            if (empty1 || empty2) {
                return (empty1 ? 1 : 0) - (empty2 ? 1 : 0);
            }
            return c1.toString().compareTo(c2.toString());
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$compareTo(ImeSubtypeListItem other) {
            int result = ImeSubtypeListItem.compareNullableCharSequences(this.mImeName, other.mImeName);
            if (result != 0) {
                return result;
            }
            result = (this.mIsSystemLocale ? -1 : 0) - (other.mIsSystemLocale ? -1 : 0);
            if (result != 0) {
                return result;
            }
            result = (this.mIsSystemLanguage ? -1 : 0) - (other.mIsSystemLanguage ? -1 : 0);
            if (result != 0) {
                return result;
            }
            return ImeSubtypeListItem.compareNullableCharSequences(this.mSubtypeName, other.mSubtypeName);
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$toString() {
            return "ImeSubtypeListItem{mImeName=" + this.mImeName + " mSubtypeName=" + this.mSubtypeName + " mSubtypeId=" + this.mSubtypeId + " mIsSystemLocale=" + this.mIsSystemLocale + " mIsSystemLanguage=" + this.mIsSystemLanguage + "}";
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ImeSubtypeListItem) {
                ImeSubtypeListItem that = (ImeSubtypeListItem)o;
                return Objects.equals(this.mImi, that.mImi) && this.mSubtypeId == that.mSubtypeId;
            }
            return false;
        }

        private void __constructor__(CharSequence charSequence, CharSequence charSequence2, InputMethodInfo inputMethodInfo, int n, String string2, String string3) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$__constructor__(charSequence, charSequence2, inputMethodInfo, n, string2, string3);
        }

        public ImeSubtypeListItem(CharSequence charSequence, CharSequence charSequence2, InputMethodInfo inputMethodInfo, int n, String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$__constructor__(java.lang.CharSequence java.lang.CharSequence android.view.inputmethod.InputMethodInfo int java.lang.String java.lang.String ), this, charSequence, charSequence2, inputMethodInfo, n, string2, string3);
        }

        private static String parseLanguageFromLocaleString(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("parseLanguageFromLocaleString", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$parseLanguageFromLocaleString(java.lang.String ), (String)string2);
        }

        private static int compareNullableCharSequences(CharSequence charSequence, CharSequence charSequence2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compareNullableCharSequences", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$compareNullableCharSequences(java.lang.CharSequence java.lang.CharSequence ), (CharSequence)charSequence, (CharSequence)charSequence2);
        }

        @Override
        public int compareTo(ImeSubtypeListItem imeSubtypeListItem) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$compareTo(com.android.internal.inputmethod.InputMethodSubtypeSwitchingController$ImeSubtypeListItem ), this, imeSubtypeListItem);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$toString(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_inputmethod_InputMethodSubtypeSwitchingController_ImeSubtypeListItem$equals(java.lang.Object ), this, object);
        }

        public /* synthetic */ ImeSubtypeListItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImeSubtypeListItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

