/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics;

import android.graphics.Color;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ColorUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static double XYZ_WHITE_REFERENCE_X = 95.047;
    private static double XYZ_WHITE_REFERENCE_Y = 100.0;
    private static double XYZ_WHITE_REFERENCE_Z = 108.883;
    private static double XYZ_EPSILON = 0.008856;
    private static double XYZ_KAPPA = 903.3;
    private static int MIN_ALPHA_SEARCH_MAX_ITERATIONS = 10;
    private static int MIN_ALPHA_SEARCH_PRECISION = 1;
    private static ThreadLocal<double[]> TEMP_ARRAY;

    private void $$robo$$com_android_internal_graphics_ColorUtils$__constructor__() {
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$compositeColors(int foreground, int background) {
        int bgAlpha = Color.alpha(background);
        int fgAlpha = Color.alpha(foreground);
        int a = ColorUtils.compositeAlpha(fgAlpha, bgAlpha);
        int r = ColorUtils.compositeComponent(Color.red(foreground), fgAlpha, Color.red(background), bgAlpha, a);
        int g = ColorUtils.compositeComponent(Color.green(foreground), fgAlpha, Color.green(background), bgAlpha, a);
        int b = ColorUtils.compositeComponent(Color.blue(foreground), fgAlpha, Color.blue(background), bgAlpha, a);
        return Color.argb(a, r, g, b);
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$compositeAlpha(int foregroundAlpha, int backgroundAlpha) {
        return 255 - (255 - backgroundAlpha) * (255 - foregroundAlpha) / 255;
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$compositeComponent(int fgC, int fgA, int bgC, int bgA, int a) {
        if (a == 0) {
            return 0;
        }
        return (255 * fgC * fgA + bgC * bgA * (255 - fgA)) / (a * 255);
    }

    private static final double $$robo$$com_android_internal_graphics_ColorUtils$calculateLuminance(int color2) {
        double[] result = ColorUtils.getTempDouble3Array();
        ColorUtils.colorToXYZ(color2, result);
        return result[1] / 100.0;
    }

    private static final double $$robo$$com_android_internal_graphics_ColorUtils$calculateContrast(int foreground, int background) {
        if (Color.alpha(background) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(background));
        }
        if (Color.alpha(foreground) < 255) {
            foreground = ColorUtils.compositeColors(foreground, background);
        }
        double luminance1 = ColorUtils.calculateLuminance(foreground) + 0.05;
        double luminance2 = ColorUtils.calculateLuminance(background) + 0.05;
        return Math.max(luminance1, luminance2) / Math.min(luminance1, luminance2);
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$calculateMinimumBackgroundAlpha(int foreground, int background, float minContrastRatio) {
        background = ColorUtils.setAlphaComponent(background, 255);
        int leastContrastyColor = ColorUtils.setAlphaComponent(foreground, 255);
        return ColorUtils.binaryAlphaSearch(foreground, background, minContrastRatio, (fg, bg, alpha) -> {
            int testBackground = ColorUtils.blendARGB(leastContrastyColor, bg, (float)alpha / 255.0f);
            testBackground = ColorUtils.setAlphaComponent(testBackground, 255);
            return ColorUtils.calculateContrast(fg, testBackground);
        });
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$calculateMinimumAlpha(int foreground, int background, float minContrastRatio) {
        if (Color.alpha(background) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(background));
        }
        ContrastCalculator contrastCalculator = (fg, bg, alpha) -> {
            int testForeground = ColorUtils.setAlphaComponent(fg, alpha);
            return ColorUtils.calculateContrast(testForeground, bg);
        };
        double testRatio = contrastCalculator.calculateContrast(foreground, background, 255);
        if (testRatio < (double)minContrastRatio) {
            return -1;
        }
        foreground = ColorUtils.setAlphaComponent(foreground, 255);
        return ColorUtils.binaryAlphaSearch(foreground, background, minContrastRatio, contrastCalculator);
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$binaryAlphaSearch(int foreground, int background, float minContrastRatio, ContrastCalculator calculator) {
        int minAlpha = 0;
        int maxAlpha = 255;
        for (int numIterations = 0; numIterations <= 10 && maxAlpha - minAlpha > 1; ++numIterations) {
            int testAlpha = (minAlpha + maxAlpha) / 2;
            double testRatio = calculator.calculateContrast(foreground, background, testAlpha);
            if (testRatio < (double)minContrastRatio) {
                minAlpha = testAlpha;
                continue;
            }
            maxAlpha = testAlpha;
        }
        return maxAlpha;
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$RGBToHSL(int r, int g, int b, float[] outHsl) {
        float h;
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float deltaMaxMin = max - min;
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            h = max == rf ? (gf - bf) / deltaMaxMin % 6.0f : (max == gf ? (bf - rf) / deltaMaxMin + 2.0f : (rf - gf) / deltaMaxMin + 4.0f);
            s = deltaMaxMin / (1.0f - Math.abs(2.0f * l - 1.0f));
        }
        h = h * 60.0f % 360.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        outHsl[0] = ColorUtils.constrain(h, 0.0f, 360.0f);
        outHsl[1] = ColorUtils.constrain(s, 0.0f, 1.0f);
        outHsl[2] = ColorUtils.constrain(l, 0.0f, 1.0f);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$colorToHSL(int color2, float[] outHsl) {
        ColorUtils.RGBToHSL(Color.red(color2), Color.green(color2), Color.blue(color2), outHsl);
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$HSLToColor(float[] hsl) {
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float m = l - 0.5f * c;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        int hueSegment = (int)h / 60;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (hueSegment) {
            case 0: {
                r = Math.round(255.0f * (c + m));
                g = Math.round(255.0f * (x + m));
                b = Math.round(255.0f * m);
                break;
            }
            case 1: {
                r = Math.round(255.0f * (x + m));
                g = Math.round(255.0f * (c + m));
                b = Math.round(255.0f * m);
                break;
            }
            case 2: {
                r = Math.round(255.0f * m);
                g = Math.round(255.0f * (c + m));
                b = Math.round(255.0f * (x + m));
                break;
            }
            case 3: {
                r = Math.round(255.0f * m);
                g = Math.round(255.0f * (x + m));
                b = Math.round(255.0f * (c + m));
                break;
            }
            case 4: {
                r = Math.round(255.0f * (x + m));
                g = Math.round(255.0f * m);
                b = Math.round(255.0f * (c + m));
                break;
            }
            case 5: 
            case 6: {
                r = Math.round(255.0f * (c + m));
                g = Math.round(255.0f * m);
                b = Math.round(255.0f * (x + m));
            }
        }
        r = ColorUtils.constrain(r, 0, 255);
        g = ColorUtils.constrain(g, 0, 255);
        b = ColorUtils.constrain(b, 0, 255);
        return Color.rgb(r, g, b);
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$setAlphaComponent(int color2, int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return color2 & 0xFFFFFF | alpha << 24;
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$colorToLAB(int color2, double[] outLab) {
        ColorUtils.RGBToLAB(Color.red(color2), Color.green(color2), Color.blue(color2), outLab);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$RGBToLAB(int r, int g, int b, double[] outLab) {
        ColorUtils.RGBToXYZ(r, g, b, outLab);
        ColorUtils.XYZToLAB(outLab[0], outLab[1], outLab[2], outLab);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$colorToXYZ(int color2, double[] outXyz) {
        ColorUtils.RGBToXYZ(Color.red(color2), Color.green(color2), Color.blue(color2), outXyz);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$RGBToXYZ(int r, int g, int b, double[] outXyz) {
        if (outXyz.length != 3) {
            throw new IllegalArgumentException("outXyz must have a length of 3.");
        }
        double sr = (double)r / 255.0;
        sr = sr < 0.04045 ? sr / 12.92 : Math.pow((sr + 0.055) / 1.055, 2.4);
        double sg = (double)g / 255.0;
        sg = sg < 0.04045 ? sg / 12.92 : Math.pow((sg + 0.055) / 1.055, 2.4);
        double sb = (double)b / 255.0;
        sb = sb < 0.04045 ? sb / 12.92 : Math.pow((sb + 0.055) / 1.055, 2.4);
        outXyz[0] = 100.0 * (sr * 0.4124 + sg * 0.3576 + sb * 0.1805);
        outXyz[1] = 100.0 * (sr * 0.2126 + sg * 0.7152 + sb * 0.0722);
        outXyz[2] = 100.0 * (sr * 0.0193 + sg * 0.1192 + sb * 0.9505);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$XYZToLAB(double x, double y, double z, double[] outLab) {
        if (outLab.length != 3) {
            throw new IllegalArgumentException("outLab must have a length of 3.");
        }
        x = ColorUtils.pivotXyzComponent(x / 95.047);
        y = ColorUtils.pivotXyzComponent(y / 100.0);
        z = ColorUtils.pivotXyzComponent(z / 108.883);
        outLab[0] = Math.max(0.0, 116.0 * y - 16.0);
        outLab[1] = 500.0 * (x - y);
        outLab[2] = 200.0 * (y - z);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$LABToXYZ(double l, double a, double b, double[] outXyz) {
        double fy = (l + 16.0) / 116.0;
        double fx = a / 500.0 + fy;
        double fz = fy - b / 200.0;
        double tmp = Math.pow(fx, 3.0);
        double xr = tmp > 0.008856 ? tmp : (116.0 * fx - 16.0) / 903.3;
        double yr = l > 7.9996247999999985 ? Math.pow(fy, 3.0) : l / 903.3;
        tmp = Math.pow(fz, 3.0);
        double zr = tmp > 0.008856 ? tmp : (116.0 * fz - 16.0) / 903.3;
        outXyz[0] = xr * 95.047;
        outXyz[1] = yr * 100.0;
        outXyz[2] = zr * 108.883;
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$XYZToColor(double x, double y, double z) {
        double r = (x * 3.2406 + y * -1.5372 + z * -0.4986) / 100.0;
        double g = (x * -0.9689 + y * 1.8758 + z * 0.0415) / 100.0;
        double b = (x * 0.0557 + y * -0.204 + z * 1.057) / 100.0;
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : 12.92 * r;
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : 12.92 * g;
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : 12.92 * b;
        return Color.rgb(ColorUtils.constrain((int)Math.round(r * 255.0), 0, 255), ColorUtils.constrain((int)Math.round(g * 255.0), 0, 255), ColorUtils.constrain((int)Math.round(b * 255.0), 0, 255));
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$LABToColor(double l, double a, double b) {
        double[] result = ColorUtils.getTempDouble3Array();
        ColorUtils.LABToXYZ(l, a, b, result);
        return ColorUtils.XYZToColor(result[0], result[1], result[2]);
    }

    private static final double $$robo$$com_android_internal_graphics_ColorUtils$distanceEuclidean(double[] labX, double[] labY) {
        return Math.sqrt(Math.pow(labX[0] - labY[0], 2.0) + Math.pow(labX[1] - labY[1], 2.0) + Math.pow(labX[2] - labY[2], 2.0));
    }

    private static final float $$robo$$com_android_internal_graphics_ColorUtils$constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    private static final double $$robo$$com_android_internal_graphics_ColorUtils$pivotXyzComponent(double component) {
        return component > 0.008856 ? Math.pow(component, 0.3333333333333333) : (903.3 * component + 16.0) / 116.0;
    }

    private static final int $$robo$$com_android_internal_graphics_ColorUtils$blendARGB(int color1, int color2, float ratio) {
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha(color1) * inverseRatio + (float)Color.alpha(color2) * ratio;
        float r = (float)Color.red(color1) * inverseRatio + (float)Color.red(color2) * ratio;
        float g = (float)Color.green(color1) * inverseRatio + (float)Color.green(color2) * ratio;
        float b = (float)Color.blue(color1) * inverseRatio + (float)Color.blue(color2) * ratio;
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$blendHSL(float[] hsl1, float[] hsl2, float ratio, float[] outResult) {
        if (outResult.length != 3) {
            throw new IllegalArgumentException("result must have a length of 3.");
        }
        float inverseRatio = 1.0f - ratio;
        outResult[0] = ColorUtils.circularInterpolate(hsl1[0], hsl2[0], ratio);
        outResult[1] = hsl1[1] * inverseRatio + hsl2[1] * ratio;
        outResult[2] = hsl1[2] * inverseRatio + hsl2[2] * ratio;
    }

    private static final void $$robo$$com_android_internal_graphics_ColorUtils$blendLAB(double[] lab1, double[] lab2, double ratio, double[] outResult) {
        if (outResult.length != 3) {
            throw new IllegalArgumentException("outResult must have a length of 3.");
        }
        double inverseRatio = 1.0 - ratio;
        outResult[0] = lab1[0] * inverseRatio + lab2[0] * ratio;
        outResult[1] = lab1[1] * inverseRatio + lab2[1] * ratio;
        outResult[2] = lab1[2] * inverseRatio + lab2[2] * ratio;
    }

    private static final float $$robo$$com_android_internal_graphics_ColorUtils$circularInterpolate(float a, float b, float f) {
        if (Math.abs(b - a) > 180.0f) {
            if (b > a) {
                a += 360.0f;
            } else {
                b += 360.0f;
            }
        }
        return (a + (b - a) * f) % 360.0f;
    }

    private static final double[] $$robo$$com_android_internal_graphics_ColorUtils$getTempDouble3Array() {
        double[] result = TEMP_ARRAY.get();
        if (result == null) {
            result = new double[3];
            TEMP_ARRAY.set(result);
        }
        return result;
    }

    static void __staticInitializer__() {
        TEMP_ARRAY = new ThreadLocal();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_graphics_ColorUtils$__constructor__();
    }

    public ColorUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_ColorUtils$__constructor__(), this);
    }

    public static int compositeColors(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compositeColors", $$robo$$com_android_internal_graphics_ColorUtils$compositeColors(int int ), (int)n, (int)n2);
    }

    private static int compositeAlpha(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compositeAlpha", $$robo$$com_android_internal_graphics_ColorUtils$compositeAlpha(int int ), (int)n, (int)n2);
    }

    private static int compositeComponent(int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compositeComponent", $$robo$$com_android_internal_graphics_ColorUtils$compositeComponent(int int int int int ), (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static double calculateLuminance(int n) {
        return (double)InvokeDynamicSupport.bootstrapStatic("calculateLuminance", $$robo$$com_android_internal_graphics_ColorUtils$calculateLuminance(int ), (int)n);
    }

    public static double calculateContrast(int n, int n2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("calculateContrast", $$robo$$com_android_internal_graphics_ColorUtils$calculateContrast(int int ), (int)n, (int)n2);
    }

    public static int calculateMinimumBackgroundAlpha(int n, int n2, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateMinimumBackgroundAlpha", $$robo$$com_android_internal_graphics_ColorUtils$calculateMinimumBackgroundAlpha(int int float ), (int)n, (int)n2, (float)f);
    }

    public static int calculateMinimumAlpha(int n, int n2, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateMinimumAlpha", $$robo$$com_android_internal_graphics_ColorUtils$calculateMinimumAlpha(int int float ), (int)n, (int)n2, (float)f);
    }

    private static int binaryAlphaSearch(int n, int n2, float f, ContrastCalculator contrastCalculator) {
        return (int)InvokeDynamicSupport.bootstrapStatic("binaryAlphaSearch", $$robo$$com_android_internal_graphics_ColorUtils$binaryAlphaSearch(int int float com.android.internal.graphics.ColorUtils$ContrastCalculator ), (int)n, (int)n2, (float)f, (ContrastCalculator)contrastCalculator);
    }

    public static void RGBToHSL(int n, int n2, int n3, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("RGBToHSL", $$robo$$com_android_internal_graphics_ColorUtils$RGBToHSL(int int int float[] ), (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    public static void colorToHSL(int n, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("colorToHSL", $$robo$$com_android_internal_graphics_ColorUtils$colorToHSL(int float[] ), (int)n, (float[])fArray);
    }

    public static int HSLToColor(float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("HSLToColor", $$robo$$com_android_internal_graphics_ColorUtils$HSLToColor(float[] ), (float[])fArray);
    }

    public static int setAlphaComponent(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setAlphaComponent", $$robo$$com_android_internal_graphics_ColorUtils$setAlphaComponent(int int ), (int)n, (int)n2);
    }

    public static void colorToLAB(int n, double[] dArray) {
        InvokeDynamicSupport.bootstrapStatic("colorToLAB", $$robo$$com_android_internal_graphics_ColorUtils$colorToLAB(int double[] ), (int)n, (double[])dArray);
    }

    public static void RGBToLAB(int n, int n2, int n3, double[] dArray) {
        InvokeDynamicSupport.bootstrapStatic("RGBToLAB", $$robo$$com_android_internal_graphics_ColorUtils$RGBToLAB(int int int double[] ), (int)n, (int)n2, (int)n3, (double[])dArray);
    }

    public static void colorToXYZ(int n, double[] dArray) {
        InvokeDynamicSupport.bootstrapStatic("colorToXYZ", $$robo$$com_android_internal_graphics_ColorUtils$colorToXYZ(int double[] ), (int)n, (double[])dArray);
    }

    public static void RGBToXYZ(int n, int n2, int n3, double[] dArray) {
        InvokeDynamicSupport.bootstrapStatic("RGBToXYZ", $$robo$$com_android_internal_graphics_ColorUtils$RGBToXYZ(int int int double[] ), (int)n, (int)n2, (int)n3, (double[])dArray);
    }

    public static void XYZToLAB(double d, double d2, double d3, double[] dArray) {
        InvokeDynamicSupport.bootstrapStatic("XYZToLAB", $$robo$$com_android_internal_graphics_ColorUtils$XYZToLAB(double double double double[] ), (double)d, (double)d2, (double)d3, (double[])dArray);
    }

    public static void LABToXYZ(double d, double d2, double d3, double[] dArray) {
        InvokeDynamicSupport.bootstrapStatic("LABToXYZ", $$robo$$com_android_internal_graphics_ColorUtils$LABToXYZ(double double double double[] ), (double)d, (double)d2, (double)d3, (double[])dArray);
    }

    public static int XYZToColor(double d, double d2, double d3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("XYZToColor", $$robo$$com_android_internal_graphics_ColorUtils$XYZToColor(double double double ), (double)d, (double)d2, (double)d3);
    }

    public static int LABToColor(double d, double d2, double d3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("LABToColor", $$robo$$com_android_internal_graphics_ColorUtils$LABToColor(double double double ), (double)d, (double)d2, (double)d3);
    }

    public static double distanceEuclidean(double[] dArray, double[] dArray2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("distanceEuclidean", $$robo$$com_android_internal_graphics_ColorUtils$distanceEuclidean(double[] double[] ), (double[])dArray, (double[])dArray2);
    }

    private static float constrain(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("constrain", $$robo$$com_android_internal_graphics_ColorUtils$constrain(float float float ), (float)f, (float)f2, (float)f3);
    }

    private static int constrain(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("constrain", $$robo$$com_android_internal_graphics_ColorUtils$constrain(int int int ), (int)n, (int)n2, (int)n3);
    }

    private static double pivotXyzComponent(double d) {
        return (double)InvokeDynamicSupport.bootstrapStatic("pivotXyzComponent", $$robo$$com_android_internal_graphics_ColorUtils$pivotXyzComponent(double ), (double)d);
    }

    public static int blendARGB(int n, int n2, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("blendARGB", $$robo$$com_android_internal_graphics_ColorUtils$blendARGB(int int float ), (int)n, (int)n2, (float)f);
    }

    public static void blendHSL(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        InvokeDynamicSupport.bootstrapStatic("blendHSL", $$robo$$com_android_internal_graphics_ColorUtils$blendHSL(float[] float[] float float[] ), (float[])fArray, (float[])fArray2, (float)f, (float[])fArray3);
    }

    public static void blendLAB(double[] dArray, double[] dArray2, double d, double[] dArray3) {
        InvokeDynamicSupport.bootstrapStatic("blendLAB", $$robo$$com_android_internal_graphics_ColorUtils$blendLAB(double[] double[] double double[] ), (double[])dArray, (double[])dArray2, (double)d, (double[])dArray3);
    }

    static float circularInterpolate(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("circularInterpolate", $$robo$$com_android_internal_graphics_ColorUtils$circularInterpolate(float float float ), (float)f, (float)f2, (float)f3);
    }

    private static double[] getTempDouble3Array() {
        return InvokeDynamicSupport.bootstrapStatic("getTempDouble3Array", $$robo$$com_android_internal_graphics_ColorUtils$getTempDouble3Array());
    }

    static {
        RobolectricInternals.classInitializing(ColorUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface ContrastCalculator {
        public double calculateContrast(int var1, int var2, int var3);
    }
}

