/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.DocumentsProvider;
import android.provider.MediaStore;
import android.provider.MetadataReader;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class FileSystemProvider
extends DocumentsProvider
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "FileSystemProvider";
    private static boolean LOG_INOTIFY = false;
    private String[] mDefaultProjection;
    @GuardedBy(value="mObservers")
    private ArrayMap<File, DirectoryObserver> mObservers;
    private Handler mHandler;
    private static String MIMETYPE_JPEG = "image/jpeg";
    private static String MIMETYPE_JPG = "image/jpg";
    private static String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$com_android_internal_content_FileSystemProvider$__constructor__() {
        this.mObservers = new ArrayMap();
    }

    protected abstract File getFileForDocId(String var1, boolean var2) throws FileNotFoundException;

    protected abstract String getDocIdForFile(File var1) throws FileNotFoundException;

    protected abstract Uri buildNotificationUri(String var1);

    private final void $$robo$$com_android_internal_content_FileSystemProvider$onDocIdChanged(String docId) {
    }

    private final boolean $$robo$$com_android_internal_content_FileSystemProvider$onCreate() {
        throw new UnsupportedOperationException("Subclass should override this and call onCreate(defaultDocumentProjection)");
    }

    private final void $$robo$$com_android_internal_content_FileSystemProvider$onCreate(String[] defaultProjection) {
        this.mHandler = new Handler();
        this.mDefaultProjection = defaultProjection;
    }

    private final boolean $$robo$$com_android_internal_content_FileSystemProvider$isChildDocument(String parentDocId, String docId) {
        try {
            File parent = this.getFileForDocId(parentDocId).getCanonicalFile();
            File doc = this.getFileForDocId(docId).getCanonicalFile();
            return FileUtils.contains(parent, doc);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to determine if " + docId + " is child of " + parentDocId + ": " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle $$robo$$com_android_internal_content_FileSystemProvider$getDocumentMetadata(String documentId) throws FileNotFoundException {
        Bundle bundle;
        File file = this.getFileForDocId(documentId);
        if (!file.exists()) {
            throw new FileNotFoundException("Can't find the file for documentId: " + documentId);
        }
        if (!file.isFile()) {
            Log.w("FileSystemProvider", "Can't stream non-regular file. Returning empty metadata.");
            return null;
        }
        if (!file.canRead()) {
            Log.w("FileSystemProvider", "Can't stream non-readable file. Returning empty metadata.");
            return null;
        }
        String mimeType = FileSystemProvider.getTypeForFile(file);
        if (!MetadataReader.isSupportedMimeType(mimeType)) {
            return null;
        }
        FileInputStream stream = null;
        try {
            Bundle metadata = new Bundle();
            stream = new FileInputStream(file.getAbsolutePath());
            MetadataReader.getMetadata(metadata, stream, mimeType, null);
            bundle = metadata;
        }
        catch (IOException e) {
            Bundle bundle2;
            try {
                Log.e("FileSystemProvider", "An error occurred retrieving the metadata", e);
                bundle2 = null;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(stream);
                throw throwable;
            }
            IoUtils.closeQuietly(stream);
            return bundle2;
        }
        IoUtils.closeQuietly(stream);
        return bundle;
    }

    private final List<String> $$robo$$com_android_internal_content_FileSystemProvider$findDocumentPath(File parent, File doc) throws FileNotFoundException {
        if (!doc.exists()) {
            throw new FileNotFoundException(doc + " is not found.");
        }
        if (!FileUtils.contains(parent, doc)) {
            throw new FileNotFoundException(doc + " is not found under " + parent);
        }
        LinkedList<String> path = new LinkedList<String>();
        while (doc != null && FileUtils.contains(parent, doc)) {
            path.addFirst(this.getDocIdForFile(doc));
            doc = doc.getParentFile();
        }
        return path;
    }

    private final String $$robo$$com_android_internal_content_FileSystemProvider$createDocument(String docId, String mimeType, String displayName) throws FileNotFoundException {
        String childId;
        displayName = FileUtils.buildValidFatFilename(displayName);
        File parent = this.getFileForDocId(docId);
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Parent document isn't a directory");
        }
        File file = FileUtils.buildUniqueFile(parent, mimeType, displayName);
        if ("vnd.android.document/directory".equals(mimeType)) {
            if (!file.mkdir()) {
                throw new IllegalStateException("Failed to mkdir " + file);
            }
            childId = this.getDocIdForFile(file);
            this.onDocIdChanged(childId);
            this.addFolderToMediaStore(this.getFileForDocId(childId, true));
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IllegalStateException("Failed to touch " + file);
                }
                childId = this.getDocIdForFile(file);
                this.onDocIdChanged(childId);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to touch " + file + ": " + e);
            }
        }
        return childId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_content_FileSystemProvider$addFolderToMediaStore(File visibleFolder) {
        if (visibleFolder != null) {
            if (!$assertionsDisabled && !visibleFolder.isDirectory()) {
                throw new AssertionError();
            }
            long token = Binder.clearCallingIdentity();
            try {
                ContentResolver resolver = this.getContext().getContentResolver();
                Uri uri = MediaStore.Files.getDirectoryUri("external");
                ContentValues values = new ContentValues();
                values.put("_data", visibleFolder.getAbsolutePath());
                resolver.insert(uri, values);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private final String $$robo$$com_android_internal_content_FileSystemProvider$renameDocument(String docId, String displayName) throws FileNotFoundException {
        File after;
        displayName = FileUtils.buildValidFatFilename(displayName);
        File before = this.getFileForDocId(docId);
        if (!before.renameTo(after = FileUtils.buildUniqueFile(before.getParentFile(), displayName))) {
            throw new IllegalStateException("Failed to rename to " + after);
        }
        String afterDocId = this.getDocIdForFile(after);
        this.onDocIdChanged(docId);
        this.onDocIdChanged(afterDocId);
        File beforeVisibleFile = this.getFileForDocId(docId, true);
        File afterVisibleFile = this.getFileForDocId(afterDocId, true);
        this.moveInMediaStore(beforeVisibleFile, afterVisibleFile);
        if (!TextUtils.equals(docId, afterDocId)) {
            this.scanFile(afterVisibleFile);
            return afterDocId;
        }
        return null;
    }

    private final String $$robo$$com_android_internal_content_FileSystemProvider$moveDocument(String sourceDocumentId, String sourceParentDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        File before = this.getFileForDocId(sourceDocumentId);
        File after = new File(this.getFileForDocId(targetParentDocumentId), before.getName());
        File visibleFileBefore = this.getFileForDocId(sourceDocumentId, true);
        if (after.exists()) {
            throw new IllegalStateException("Already exists " + after);
        }
        if (!before.renameTo(after)) {
            throw new IllegalStateException("Failed to move to " + after);
        }
        String docId = this.getDocIdForFile(after);
        this.onDocIdChanged(sourceDocumentId);
        this.onDocIdChanged(docId);
        this.moveInMediaStore(visibleFileBefore, this.getFileForDocId(docId, true));
        return docId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_content_FileSystemProvider$moveInMediaStore(File oldVisibleFile, File newVisibleFile) {
        if (oldVisibleFile != null && newVisibleFile != null) {
            long token = Binder.clearCallingIdentity();
            try {
                ContentResolver resolver = this.getContext().getContentResolver();
                Uri externalUri = newVisibleFile.isDirectory() ? MediaStore.Files.getDirectoryUri("external") : MediaStore.Files.getContentUri("external");
                ContentValues values = new ContentValues();
                values.put("_data", newVisibleFile.getAbsolutePath());
                String path = oldVisibleFile.getAbsolutePath();
                resolver.update(externalUri, values, "_data LIKE ? AND lower(_data)=lower(?)", new String[]{path, path});
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private final void $$robo$$com_android_internal_content_FileSystemProvider$deleteDocument(String docId) throws FileNotFoundException {
        File file = this.getFileForDocId(docId);
        File visibleFile = this.getFileForDocId(docId, true);
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            FileUtils.deleteContents(file);
        }
        if (!file.delete()) {
            throw new IllegalStateException("Failed to delete " + file);
        }
        this.onDocIdChanged(docId);
        this.removeFromMediaStore(visibleFile, isDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_content_FileSystemProvider$removeFromMediaStore(File visibleFile, boolean isFolder) throws FileNotFoundException {
        if (visibleFile != null) {
            long token = Binder.clearCallingIdentity();
            try {
                String path;
                ContentResolver resolver = this.getContext().getContentResolver();
                Uri externalUri = MediaStore.Files.getContentUri("external");
                if (isFolder) {
                    path = visibleFile.getAbsolutePath() + "/";
                    resolver.delete(externalUri, "_data LIKE ?1 AND lower(substr(_data,1,?2))=lower(?3)", new String[]{path + "%", Integer.toString(path.length()), path});
                }
                path = visibleFile.getAbsolutePath();
                resolver.delete(externalUri, "_data LIKE ?1 AND lower(_data)=lower(?2)", new String[]{path, path});
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private final Cursor $$robo$$com_android_internal_content_FileSystemProvider$queryDocument(String documentId, String[] projection) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(this.resolveProjection(projection));
        this.includeFile(result, documentId, null);
        return result;
    }

    private final Cursor $$robo$$com_android_internal_content_FileSystemProvider$queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        File parent = this.getFileForDocId(parentDocumentId);
        DirectoryCursor result = new DirectoryCursor(this, this.resolveProjection(projection), parentDocumentId, parent);
        for (File file : parent.listFiles()) {
            this.includeFile(result, null, file);
        }
        return result;
    }

    private final Cursor $$robo$$com_android_internal_content_FileSystemProvider$querySearchDocuments(File folder, String query, String[] projection, Set<String> exclusion) throws FileNotFoundException {
        query = query.toLowerCase();
        MatrixCursor result = new MatrixCursor(this.resolveProjection(projection));
        LinkedList<File> pending = new LinkedList<File>();
        pending.add(folder);
        while (!pending.isEmpty() && result.getCount() < 24) {
            File file = (File)pending.removeFirst();
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    pending.add(child);
                }
            }
            if (!file.getName().toLowerCase().contains(query) || exclusion.contains(file.getAbsolutePath())) continue;
            this.includeFile(result, null, file);
        }
        return result;
    }

    private final String $$robo$$com_android_internal_content_FileSystemProvider$getDocumentType(String documentId) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        return FileSystemProvider.getTypeForFile(file);
    }

    private final ParcelFileDescriptor $$robo$$com_android_internal_content_FileSystemProvider$openDocument(String documentId, String mode, CancellationSignal signal) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        File visibleFile = this.getFileForDocId(documentId, true);
        int pfdMode = ParcelFileDescriptor.parseMode(mode);
        if (pfdMode == 0x10000000 || visibleFile == null) {
            return ParcelFileDescriptor.open(file, pfdMode);
        }
        try {
            return ParcelFileDescriptor.open(file, pfdMode, this.mHandler, e -> {
                this.onDocIdChanged(documentId);
                this.scanFile(visibleFile);
            });
        }
        catch (IOException e2) {
            throw new FileNotFoundException("Failed to open for writing: " + e2);
        }
    }

    private final void $$robo$$com_android_internal_content_FileSystemProvider$scanFile(File visibleFile) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intent.setData(Uri.fromFile(visibleFile));
        this.getContext().sendBroadcast(intent);
    }

    private final AssetFileDescriptor $$robo$$com_android_internal_content_FileSystemProvider$openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        return DocumentsContract.openImageThumbnail(file);
    }

    private final MatrixCursor.RowBuilder $$robo$$com_android_internal_content_FileSystemProvider$includeFile(MatrixCursor result, String docId, File file) throws FileNotFoundException {
        if (docId == null) {
            docId = this.getDocIdForFile(file);
        } else {
            file = this.getFileForDocId(docId);
        }
        int flags = 0;
        if (file.canWrite()) {
            if (file.isDirectory()) {
                flags |= 8;
                flags |= 4;
                flags |= 0x40;
                flags |= 0x100;
            } else {
                flags |= 2;
                flags |= 4;
                flags |= 0x40;
                flags |= 0x100;
            }
        }
        String mimeType = FileSystemProvider.getTypeForFile(file);
        String displayName = file.getName();
        if (mimeType.startsWith("image/")) {
            flags |= 1;
        }
        if (this.typeSupportsMetadata(mimeType)) {
            flags |= 0x20000;
        }
        MatrixCursor.RowBuilder row = result.newRow();
        row.add("document_id", docId);
        row.add("_display_name", displayName);
        row.add("_size", file.length());
        row.add("mime_type", mimeType);
        row.add("flags", flags);
        long lastModified = file.lastModified();
        if (lastModified > 31536000000L) {
            row.add("last_modified", lastModified);
        }
        return row;
    }

    private static final String $$robo$$com_android_internal_content_FileSystemProvider$getTypeForFile(File file) {
        if (file.isDirectory()) {
            return "vnd.android.document/directory";
        }
        return FileSystemProvider.getTypeForName(file.getName());
    }

    private final boolean $$robo$$com_android_internal_content_FileSystemProvider$typeSupportsMetadata(String mimeType) {
        return MetadataReader.isSupportedMimeType(mimeType);
    }

    private static final String $$robo$$com_android_internal_content_FileSystemProvider$getTypeForName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = name.substring(lastDot + 1).toLowerCase();
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    private final File $$robo$$com_android_internal_content_FileSystemProvider$getFileForDocId(String docId) throws FileNotFoundException {
        return this.getFileForDocId(docId, false);
    }

    private final String[] $$robo$$com_android_internal_content_FileSystemProvider$resolveProjection(String[] projection) {
        return projection == null ? this.mDefaultProjection : projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_content_FileSystemProvider$startObserving(File file, Uri notifyUri) {
        ArrayMap<File, DirectoryObserver> arrayMap = this.mObservers;
        synchronized (arrayMap) {
            DirectoryObserver observer = this.mObservers.get(file);
            if (observer == null) {
                observer = new DirectoryObserver(file, this.getContext().getContentResolver(), notifyUri);
                observer.startWatching();
                this.mObservers.put(file, observer);
            }
            observer.mRefCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_content_FileSystemProvider$stopObserving(File file) {
        ArrayMap<File, DirectoryObserver> arrayMap = this.mObservers;
        synchronized (arrayMap) {
            DirectoryObserver observer = this.mObservers.get(file);
            if (observer == null) {
                return;
            }
            observer.mRefCount--;
            if (observer.mRefCount == 0) {
                this.mObservers.remove(file);
                observer.stopWatching();
            }
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !FileSystemProvider.class.desiredAssertionStatus();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_content_FileSystemProvider$__constructor__();
    }

    public FileSystemProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_FileSystemProvider$__constructor__(), this);
    }

    protected void onDocIdChanged(String string2) {
        InvokeDynamicSupport.bootstrap("onDocIdChanged", $$robo$$com_android_internal_content_FileSystemProvider$onDocIdChanged(java.lang.String ), this, string2);
    }

    @Override
    public boolean onCreate() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_content_FileSystemProvider$onCreate(), this);
    }

    protected void onCreate(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_content_FileSystemProvider$onCreate(java.lang.String[] ), this, stringArray);
    }

    @Override
    public boolean isChildDocument(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isChildDocument", $$robo$$com_android_internal_content_FileSystemProvider$isChildDocument(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public Bundle getDocumentMetadata(String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getDocumentMetadata", $$robo$$com_android_internal_content_FileSystemProvider$getDocumentMetadata(java.lang.String ), this, string2);
    }

    protected List<String> findDocumentPath(File file, File file2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("findDocumentPath", $$robo$$com_android_internal_content_FileSystemProvider$findDocumentPath(java.io.File java.io.File ), this, file, file2);
    }

    @Override
    public String createDocument(String string2, String string3, String string4) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("createDocument", $$robo$$com_android_internal_content_FileSystemProvider$createDocument(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    private void addFolderToMediaStore(File file) {
        InvokeDynamicSupport.bootstrap("addFolderToMediaStore", $$robo$$com_android_internal_content_FileSystemProvider$addFolderToMediaStore(java.io.File ), this, file);
    }

    @Override
    public String renameDocument(String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("renameDocument", $$robo$$com_android_internal_content_FileSystemProvider$renameDocument(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public String moveDocument(String string2, String string3, String string4) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("moveDocument", $$robo$$com_android_internal_content_FileSystemProvider$moveDocument(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    private void moveInMediaStore(File file, File file2) {
        InvokeDynamicSupport.bootstrap("moveInMediaStore", $$robo$$com_android_internal_content_FileSystemProvider$moveInMediaStore(java.io.File java.io.File ), this, file, file2);
    }

    @Override
    public void deleteDocument(String string2) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrap("deleteDocument", $$robo$$com_android_internal_content_FileSystemProvider$deleteDocument(java.lang.String ), this, string2);
    }

    private void removeFromMediaStore(File file, boolean bl) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrap("removeFromMediaStore", $$robo$$com_android_internal_content_FileSystemProvider$removeFromMediaStore(java.io.File boolean ), this, file, bl);
    }

    @Override
    public Cursor queryDocument(String string2, String[] stringArray) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryDocument", $$robo$$com_android_internal_content_FileSystemProvider$queryDocument(java.lang.String java.lang.String[] ), this, string2, stringArray);
    }

    @Override
    public Cursor queryChildDocuments(String string2, String[] stringArray, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryChildDocuments", $$robo$$com_android_internal_content_FileSystemProvider$queryChildDocuments(java.lang.String java.lang.String[] java.lang.String ), this, string2, stringArray, string3);
    }

    protected Cursor querySearchDocuments(File file, String string2, String[] stringArray, Set<String> set) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("querySearchDocuments", $$robo$$com_android_internal_content_FileSystemProvider$querySearchDocuments(java.io.File java.lang.String java.lang.String[] java.util.Set<java.lang.String> ), this, file, string2, stringArray, set);
    }

    @Override
    public String getDocumentType(String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getDocumentType", $$robo$$com_android_internal_content_FileSystemProvider$getDocumentType(java.lang.String ), this, string2);
    }

    @Override
    public ParcelFileDescriptor openDocument(String string2, String string3, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openDocument", $$robo$$com_android_internal_content_FileSystemProvider$openDocument(java.lang.String java.lang.String android.os.CancellationSignal ), this, string2, string3, cancellationSignal);
    }

    private void scanFile(File file) {
        InvokeDynamicSupport.bootstrap("scanFile", $$robo$$com_android_internal_content_FileSystemProvider$scanFile(java.io.File ), this, file);
    }

    @Override
    public AssetFileDescriptor openDocumentThumbnail(String string2, Point point, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openDocumentThumbnail", $$robo$$com_android_internal_content_FileSystemProvider$openDocumentThumbnail(java.lang.String android.graphics.Point android.os.CancellationSignal ), this, string2, point, cancellationSignal);
    }

    protected MatrixCursor.RowBuilder includeFile(MatrixCursor matrixCursor, String string2, File file) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("includeFile", $$robo$$com_android_internal_content_FileSystemProvider$includeFile(android.database.MatrixCursor java.lang.String java.io.File ), this, matrixCursor, string2, file);
    }

    private static String getTypeForFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("getTypeForFile", $$robo$$com_android_internal_content_FileSystemProvider$getTypeForFile(java.io.File ), (File)file);
    }

    protected boolean typeSupportsMetadata(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("typeSupportsMetadata", $$robo$$com_android_internal_content_FileSystemProvider$typeSupportsMetadata(java.lang.String ), this, string2);
    }

    private static String getTypeForName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getTypeForName", $$robo$$com_android_internal_content_FileSystemProvider$getTypeForName(java.lang.String ), (String)string2);
    }

    protected File getFileForDocId(String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getFileForDocId", $$robo$$com_android_internal_content_FileSystemProvider$getFileForDocId(java.lang.String ), this, string2);
    }

    private String[] resolveProjection(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("resolveProjection", $$robo$$com_android_internal_content_FileSystemProvider$resolveProjection(java.lang.String[] ), this, stringArray);
    }

    private void startObserving(File file, Uri uri) {
        InvokeDynamicSupport.bootstrap("startObserving", $$robo$$com_android_internal_content_FileSystemProvider$startObserving(java.io.File android.net.Uri ), this, file, uri);
    }

    private void stopObserving(File file) {
        InvokeDynamicSupport.bootstrap("stopObserving", $$robo$$com_android_internal_content_FileSystemProvider$stopObserving(java.io.File ), this, file);
    }

    static {
        RobolectricInternals.classInitializing(FileSystemProvider.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileSystemProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DirectoryCursor
    extends MatrixCursor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private File mFile;
        /* synthetic */ FileSystemProvider this$0;

        private void $$robo$$com_android_internal_content_FileSystemProvider_DirectoryCursor$__constructor__(FileSystemProvider fileSystemProvider, String[] columnNames, String docId, File file) {
            this.this$0 = fileSystemProvider;
            Uri notifyUri = fileSystemProvider.buildNotificationUri(docId);
            this.setNotificationUri(fileSystemProvider.getContext().getContentResolver(), notifyUri);
            this.mFile = file;
            fileSystemProvider.startObserving(this.mFile, notifyUri);
        }

        private final void $$robo$$com_android_internal_content_FileSystemProvider_DirectoryCursor$close() {
            super.close();
            this.this$0.stopObserving(this.mFile);
        }

        private void __constructor__(FileSystemProvider fileSystemProvider, String[] stringArray, String string2, File file) {
            this.$$robo$$com_android_internal_content_FileSystemProvider_DirectoryCursor$__constructor__(fileSystemProvider, stringArray, string2, file);
        }

        public DirectoryCursor(FileSystemProvider fileSystemProvider, String[] stringArray, String string2, File file) {
            super(stringArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_FileSystemProvider_DirectoryCursor$__constructor__(com.android.internal.content.FileSystemProvider java.lang.String[] java.lang.String java.io.File ), this, fileSystemProvider, stringArray, string2, file);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_content_FileSystemProvider_DirectoryCursor$close(), this);
        }

        public /* synthetic */ DirectoryCursor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DirectoryCursor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DirectoryObserver
    extends FileObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int NOTIFY_EVENTS = 4044;
        private File mFile;
        private ContentResolver mResolver;
        private Uri mNotifyUri;
        private int mRefCount;

        private void $$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$__constructor__(File file, ContentResolver resolver, Uri notifyUri) {
            this.mRefCount = 0;
            this.mFile = file;
            this.mResolver = resolver;
            this.mNotifyUri = notifyUri;
        }

        private final void $$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$onEvent(int event, String path) {
            if ((event & 0xFCC) != 0) {
                this.mResolver.notifyChange(this.mNotifyUri, null, false);
            }
        }

        private final String $$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$toString() {
            return "DirectoryObserver{file=" + this.mFile.getAbsolutePath() + ", ref=" + this.mRefCount + "}";
        }

        private void __constructor__(File file, ContentResolver contentResolver, Uri uri) {
            this.$$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$__constructor__(file, contentResolver, uri);
        }

        public DirectoryObserver(File file, ContentResolver contentResolver, Uri uri) {
            super(file.getAbsolutePath(), 4044);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$__constructor__(java.io.File android.content.ContentResolver android.net.Uri ), this, file, contentResolver, uri);
        }

        @Override
        public void onEvent(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$onEvent(int java.lang.String ), this, n, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_content_FileSystemProvider_DirectoryObserver$toString(), this);
        }

        public /* synthetic */ DirectoryObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DirectoryObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

