/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.colorextraction;

import android.app.WallpaperColors;
import android.app.WallpaperManager;
import android.content.Context;
import android.os.Trace;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.colorextraction.types.ExtractionType;
import com.android.internal.colorextraction.types.Tonal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ColorExtractor
implements WallpaperManager.OnColorsChangedListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int TYPE_NORMAL = 0;
    public static int TYPE_DARK = 1;
    public static int TYPE_EXTRA_DARK = 2;
    private static int[] sGradientTypes;
    private static String TAG = "ColorExtractor";
    private static boolean DEBUG = false;
    protected SparseArray<GradientColors[]> mGradientColors;
    private ArrayList<WeakReference<OnColorsChangedListener>> mOnColorsChangedListeners;
    private Context mContext;
    private ExtractionType mExtractionType;
    protected WallpaperColors mSystemColors;
    protected WallpaperColors mLockColors;

    private void $$robo$$com_android_internal_colorextraction_ColorExtractor$__constructor__(Context context) {
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_colorextraction_ColorExtractor$__constructor__(Context context, ExtractionType extractionType) {
        this.mContext = context;
        this.mExtractionType = extractionType;
        this.mGradientColors = new SparseArray();
        for (int which : new int[]{2, 1}) {
            GradientColors[] colors = new GradientColors[sGradientTypes.length];
            this.mGradientColors.append(which, colors);
            for (int type : sGradientTypes) {
                colors[type] = new GradientColors();
            }
        }
        this.mOnColorsChangedListeners = new ArrayList();
        GradientColors[] systemColors = this.mGradientColors.get(1);
        GradientColors[] lockColors = this.mGradientColors.get(2);
        WallpaperManager wallpaperManager = this.mContext.getSystemService(WallpaperManager.class);
        if (wallpaperManager == null) {
            Log.w("ColorExtractor", "Can't listen to color changes!");
        } else {
            wallpaperManager.addOnColorsChangedListener(this, null);
            Trace.beginSection("ColorExtractor#getWallpaperColors");
            this.mSystemColors = wallpaperManager.getWallpaperColors(1);
            this.mLockColors = wallpaperManager.getWallpaperColors(2);
            Trace.endSection();
        }
        this.extractInto(this.mSystemColors, systemColors[0], systemColors[1], systemColors[2]);
        this.extractInto(this.mLockColors, lockColors[0], lockColors[1], lockColors[2]);
    }

    private final GradientColors $$robo$$com_android_internal_colorextraction_ColorExtractor$getColors(int which) {
        return this.getColors(which, 1);
    }

    private final GradientColors $$robo$$com_android_internal_colorextraction_ColorExtractor$getColors(int which, int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("type should be TYPE_NORMAL, TYPE_DARK or TYPE_EXTRA_DARK");
        }
        if (which != 2 && which != 1) {
            throw new IllegalArgumentException("which should be FLAG_SYSTEM or FLAG_NORMAL");
        }
        return this.mGradientColors.get(which)[type];
    }

    private final WallpaperColors $$robo$$com_android_internal_colorextraction_ColorExtractor$getWallpaperColors(int which) {
        if (which == 2) {
            return this.mLockColors;
        }
        if (which == 1) {
            return this.mSystemColors;
        }
        throw new IllegalArgumentException("Invalid value for which: " + which);
    }

    private final void $$robo$$com_android_internal_colorextraction_ColorExtractor$onColorsChanged(WallpaperColors colors, int which) {
        boolean changed = false;
        if ((which & 2) != 0) {
            this.mLockColors = colors;
            GradientColors[] lockColors = this.mGradientColors.get(2);
            this.extractInto(colors, lockColors[0], lockColors[1], lockColors[2]);
            changed = true;
        }
        if ((which & 1) != 0) {
            this.mSystemColors = colors;
            GradientColors[] systemColors = this.mGradientColors.get(1);
            this.extractInto(colors, systemColors[0], systemColors[1], systemColors[2]);
            changed = true;
        }
        if (changed) {
            this.triggerColorsChanged(which);
        }
    }

    private final void $$robo$$com_android_internal_colorextraction_ColorExtractor$triggerColorsChanged(int which) {
        ArrayList<WeakReference<OnColorsChangedListener>> references = new ArrayList<WeakReference<OnColorsChangedListener>>(this.mOnColorsChangedListeners);
        int size = references.size();
        for (int i = 0; i < size; ++i) {
            WeakReference<OnColorsChangedListener> weakReference = references.get(i);
            OnColorsChangedListener listener = (OnColorsChangedListener)weakReference.get();
            if (listener == null) {
                this.mOnColorsChangedListeners.remove(weakReference);
                continue;
            }
            listener.onColorsChanged(this, which);
        }
    }

    private final void $$robo$$com_android_internal_colorextraction_ColorExtractor$extractInto(WallpaperColors inWallpaperColors, GradientColors outGradientColorsNormal, GradientColors outGradientColorsDark, GradientColors outGradientColorsExtraDark) {
        this.mExtractionType.extractInto(inWallpaperColors, outGradientColorsNormal, outGradientColorsDark, outGradientColorsExtraDark);
    }

    private final void $$robo$$com_android_internal_colorextraction_ColorExtractor$destroy() {
        WallpaperManager wallpaperManager = this.mContext.getSystemService(WallpaperManager.class);
        if (wallpaperManager != null) {
            wallpaperManager.removeOnColorsChangedListener(this);
        }
    }

    private final void $$robo$$com_android_internal_colorextraction_ColorExtractor$addOnColorsChangedListener(OnColorsChangedListener listener) {
        this.mOnColorsChangedListeners.add(new WeakReference<OnColorsChangedListener>(listener));
    }

    private final void $$robo$$com_android_internal_colorextraction_ColorExtractor$removeOnColorsChangedListener(OnColorsChangedListener listener) {
        ArrayList<WeakReference<OnColorsChangedListener>> references = new ArrayList<WeakReference<OnColorsChangedListener>>(this.mOnColorsChangedListeners);
        int size = references.size();
        for (int i = 0; i < size; ++i) {
            WeakReference<OnColorsChangedListener> weakReference = references.get(i);
            if (weakReference.get() != listener) continue;
            this.mOnColorsChangedListeners.remove(weakReference);
            break;
        }
    }

    static void __staticInitializer__() {
        sGradientTypes = new int[]{0, 1, 2};
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_colorextraction_ColorExtractor$__constructor__(context);
    }

    public ColorExtractor(Context context) {
        this(context, new Tonal(context));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_ColorExtractor$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, ExtractionType extractionType) {
        this.$$robo$$com_android_internal_colorextraction_ColorExtractor$__constructor__(context, extractionType);
    }

    public ColorExtractor(Context context, ExtractionType extractionType) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_ColorExtractor$__constructor__(android.content.Context com.android.internal.colorextraction.types.ExtractionType ), this, context, extractionType);
    }

    public GradientColors getColors(int n) {
        return InvokeDynamicSupport.bootstrap("getColors", $$robo$$com_android_internal_colorextraction_ColorExtractor$getColors(int ), this, n);
    }

    public GradientColors getColors(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getColors", $$robo$$com_android_internal_colorextraction_ColorExtractor$getColors(int int ), this, n, n2);
    }

    public WallpaperColors getWallpaperColors(int n) {
        return InvokeDynamicSupport.bootstrap("getWallpaperColors", $$robo$$com_android_internal_colorextraction_ColorExtractor$getWallpaperColors(int ), this, n);
    }

    @Override
    public void onColorsChanged(WallpaperColors wallpaperColors, int n) {
        InvokeDynamicSupport.bootstrap("onColorsChanged", $$robo$$com_android_internal_colorextraction_ColorExtractor$onColorsChanged(android.app.WallpaperColors int ), this, wallpaperColors, n);
    }

    protected void triggerColorsChanged(int n) {
        InvokeDynamicSupport.bootstrap("triggerColorsChanged", $$robo$$com_android_internal_colorextraction_ColorExtractor$triggerColorsChanged(int ), this, n);
    }

    private void extractInto(WallpaperColors wallpaperColors, GradientColors gradientColors, GradientColors gradientColors2, GradientColors gradientColors3) {
        InvokeDynamicSupport.bootstrap("extractInto", $$robo$$com_android_internal_colorextraction_ColorExtractor$extractInto(android.app.WallpaperColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors ), this, wallpaperColors, gradientColors, gradientColors2, gradientColors3);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$com_android_internal_colorextraction_ColorExtractor$destroy(), this);
    }

    public void addOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener) {
        InvokeDynamicSupport.bootstrap("addOnColorsChangedListener", $$robo$$com_android_internal_colorextraction_ColorExtractor$addOnColorsChangedListener(com.android.internal.colorextraction.ColorExtractor$OnColorsChangedListener ), this, onColorsChangedListener);
    }

    public void removeOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnColorsChangedListener", $$robo$$com_android_internal_colorextraction_ColorExtractor$removeOnColorsChangedListener(com.android.internal.colorextraction.ColorExtractor$OnColorsChangedListener ), this, onColorsChangedListener);
    }

    static {
        RobolectricInternals.classInitializing(ColorExtractor.class);
    }

    public /* synthetic */ ColorExtractor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorExtractor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnColorsChangedListener {
        public void onColorsChanged(ColorExtractor var1, int var2);
    }

    public static class GradientColors
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mMainColor;
        private int mSecondaryColor;
        private boolean mSupportsDarkText;

        private void $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$__constructor__() {
        }

        private final void $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$setMainColor(int mainColor) {
            this.mMainColor = mainColor;
        }

        private final void $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$setSecondaryColor(int secondaryColor) {
            this.mSecondaryColor = secondaryColor;
        }

        private final void $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$setSupportsDarkText(boolean supportsDarkText) {
            this.mSupportsDarkText = supportsDarkText;
        }

        private final void $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$set(GradientColors other) {
            this.mMainColor = other.mMainColor;
            this.mSecondaryColor = other.mSecondaryColor;
            this.mSupportsDarkText = other.mSupportsDarkText;
        }

        private final int $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$getMainColor() {
            return this.mMainColor;
        }

        private final int $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$getSecondaryColor() {
            return this.mSecondaryColor;
        }

        private final boolean $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$supportsDarkText() {
            return this.mSupportsDarkText;
        }

        private final boolean $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            GradientColors other = (GradientColors)o;
            return other.mMainColor == this.mMainColor && other.mSecondaryColor == this.mSecondaryColor && other.mSupportsDarkText == this.mSupportsDarkText;
        }

        private final int $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$hashCode() {
            int code = this.mMainColor;
            code = 31 * code + this.mSecondaryColor;
            code = 31 * code + (this.mSupportsDarkText ? 0 : 1);
            return code;
        }

        private final String $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$toString() {
            return "GradientColors(" + Integer.toHexString(this.mMainColor) + ", " + Integer.toHexString(this.mSecondaryColor) + ")";
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$__constructor__();
        }

        public GradientColors() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$__constructor__(), this);
        }

        public void setMainColor(int n) {
            InvokeDynamicSupport.bootstrap("setMainColor", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$setMainColor(int ), this, n);
        }

        public void setSecondaryColor(int n) {
            InvokeDynamicSupport.bootstrap("setSecondaryColor", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$setSecondaryColor(int ), this, n);
        }

        public void setSupportsDarkText(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSupportsDarkText", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$setSupportsDarkText(boolean ), this, bl);
        }

        public void set(GradientColors gradientColors) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$set(com.android.internal.colorextraction.ColorExtractor$GradientColors ), this, gradientColors);
        }

        public int getMainColor() {
            return (int)InvokeDynamicSupport.bootstrap("getMainColor", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$getMainColor(), this);
        }

        public int getSecondaryColor() {
            return (int)InvokeDynamicSupport.bootstrap("getSecondaryColor", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$getSecondaryColor(), this);
        }

        public boolean supportsDarkText() {
            return (boolean)InvokeDynamicSupport.bootstrap("supportsDarkText", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$supportsDarkText(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_colorextraction_ColorExtractor_GradientColors$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientColors)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

