/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Parcel;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.DurationsTable;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.PssTable;
import com.android.internal.app.procstats.SparseMappingTable;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ProcessState
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ProcessStats";
    private static boolean DEBUG = false;
    private static boolean DEBUG_PARCEL = false;
    private static int[] PROCESS_STATE_TO_STATE;
    public static Comparator<ProcessState> COMPARATOR;
    public int tmpNumInUse;
    public ProcessState tmpFoundSubProc;
    private ProcessStats mStats;
    private String mName;
    private String mPackage;
    private int mUid;
    private long mVersion;
    private DurationsTable mDurations;
    private PssTable mPssTable;
    private ProcessState mCommonProcess;
    private int mCurState;
    private long mStartTime;
    private int mLastPssState;
    private long mLastPssTime;
    private boolean mActive;
    private int mNumActiveServices;
    private int mNumStartedServices;
    private int mNumExcessiveCpu;
    private int mNumCachedKill;
    private long mMinCachedKillPss;
    private long mAvgCachedKillPss;
    private long mMaxCachedKillPss;
    private boolean mMultiPackage;
    private boolean mDead;
    private long mTmpTotalTime;

    private void $$robo$$com_android_internal_app_procstats_ProcessState$__constructor__(ProcessStats processStats, String pkg, int uid, long vers, String name) {
        this.mCurState = -1;
        this.mLastPssState = -1;
        this.mStats = processStats;
        this.mName = name;
        this.mCommonProcess = this;
        this.mPackage = pkg;
        this.mUid = uid;
        this.mVersion = vers;
        this.mDurations = new DurationsTable(processStats.mTableData);
        this.mPssTable = new PssTable(processStats.mTableData);
    }

    private void $$robo$$com_android_internal_app_procstats_ProcessState$__constructor__(ProcessState commonProcess, String pkg, int uid, long vers, String name, long now) {
        this.mCurState = -1;
        this.mLastPssState = -1;
        this.mStats = commonProcess.mStats;
        this.mName = name;
        this.mCommonProcess = commonProcess;
        this.mPackage = pkg;
        this.mUid = uid;
        this.mVersion = vers;
        this.mCurState = commonProcess.mCurState;
        this.mStartTime = now;
        this.mDurations = new DurationsTable(commonProcess.mStats.mTableData);
        this.mPssTable = new PssTable(commonProcess.mStats.mTableData);
    }

    private final ProcessState $$robo$$com_android_internal_app_procstats_ProcessState$clone(long now) {
        ProcessState pnew = new ProcessState(this, this.mPackage, this.mUid, this.mVersion, this.mName, now);
        pnew.mDurations.addDurations(this.mDurations);
        pnew.mPssTable.copyFrom(this.mPssTable, 10);
        pnew.mNumExcessiveCpu = this.mNumExcessiveCpu;
        pnew.mNumCachedKill = this.mNumCachedKill;
        pnew.mMinCachedKillPss = this.mMinCachedKillPss;
        pnew.mAvgCachedKillPss = this.mAvgCachedKillPss;
        pnew.mMaxCachedKillPss = this.mMaxCachedKillPss;
        pnew.mActive = this.mActive;
        pnew.mNumActiveServices = this.mNumActiveServices;
        pnew.mNumStartedServices = this.mNumStartedServices;
        return pnew;
    }

    private final String $$robo$$com_android_internal_app_procstats_ProcessState$getName() {
        return this.mName;
    }

    private final ProcessState $$robo$$com_android_internal_app_procstats_ProcessState$getCommonProcess() {
        return this.mCommonProcess;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$makeStandalone() {
        this.mCommonProcess = this;
    }

    private final String $$robo$$com_android_internal_app_procstats_ProcessState$getPackage() {
        return this.mPackage;
    }

    private final int $$robo$$com_android_internal_app_procstats_ProcessState$getUid() {
        return this.mUid;
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getVersion() {
        return this.mVersion;
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessState$isMultiPackage() {
        return this.mMultiPackage;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$setMultiPackage(boolean val) {
        this.mMultiPackage = val;
    }

    private final int $$robo$$com_android_internal_app_procstats_ProcessState$getDurationsBucketCount() {
        return this.mDurations.getKeyCount();
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$add(ProcessState other) {
        this.mDurations.addDurations(other.mDurations);
        this.mPssTable.mergeStats(other.mPssTable);
        this.mNumExcessiveCpu += other.mNumExcessiveCpu;
        if (other.mNumCachedKill > 0) {
            this.addCachedKill(other.mNumCachedKill, other.mMinCachedKillPss, other.mAvgCachedKillPss, other.mMaxCachedKillPss);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$resetSafely(long now) {
        this.mDurations.resetTable();
        this.mPssTable.resetTable();
        this.mStartTime = now;
        this.mLastPssState = -1;
        this.mLastPssTime = 0L;
        this.mNumExcessiveCpu = 0;
        this.mNumCachedKill = 0;
        this.mMaxCachedKillPss = 0L;
        this.mAvgCachedKillPss = 0L;
        this.mMinCachedKillPss = 0L;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$makeDead() {
        this.mDead = true;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$ensureNotDead() {
        if (!this.mDead) {
            return;
        }
        Slog.w("ProcessStats", "ProcessState dead: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$writeToParcel(Parcel out, long now) {
        out.writeInt(this.mMultiPackage ? 1 : 0);
        this.mDurations.writeToParcel(out);
        this.mPssTable.writeToParcel(out);
        out.writeInt(0);
        out.writeInt(this.mNumExcessiveCpu);
        out.writeInt(this.mNumCachedKill);
        if (this.mNumCachedKill > 0) {
            out.writeLong(this.mMinCachedKillPss);
            out.writeLong(this.mAvgCachedKillPss);
            out.writeLong(this.mMaxCachedKillPss);
        }
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessState$readFromParcel(Parcel in, boolean fully) {
        boolean multiPackage;
        boolean bl = multiPackage = in.readInt() != 0;
        if (fully) {
            this.mMultiPackage = multiPackage;
        }
        if (!this.mDurations.readFromParcel(in)) {
            return false;
        }
        if (!this.mPssTable.readFromParcel(in)) {
            return false;
        }
        in.readInt();
        this.mNumExcessiveCpu = in.readInt();
        this.mNumCachedKill = in.readInt();
        if (this.mNumCachedKill > 0) {
            this.mMinCachedKillPss = in.readLong();
            this.mAvgCachedKillPss = in.readLong();
            this.mMaxCachedKillPss = in.readLong();
        } else {
            this.mMaxCachedKillPss = 0L;
            this.mAvgCachedKillPss = 0L;
            this.mMinCachedKillPss = 0L;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$makeActive() {
        this.ensureNotDead();
        this.mActive = true;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$makeInactive() {
        this.mActive = false;
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessState$isInUse() {
        return this.mActive || this.mNumActiveServices > 0 || this.mNumStartedServices > 0 || this.mCurState != -1;
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessState$isActive() {
        return this.mActive;
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessState$hasAnyData() {
        return this.mDurations.getKeyCount() != 0 || this.mCurState != -1 || this.mPssTable.getKeyCount() != 0;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$setState(int state, int memFactor, long now, ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        state = state < 0 ? (this.mNumStartedServices > 0 ? 6 + memFactor * 14 : -1) : PROCESS_STATE_TO_STATE[state] + memFactor * 14;
        this.mCommonProcess.setState(state, now);
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        if (pkgList != null) {
            for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                this.pullFixedProc(pkgList, ip).setState(state, now);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$setState(int state, long now) {
        this.ensureNotDead();
        if (!this.mDead && this.mCurState != state) {
            this.commitStateTime(now);
            this.mCurState = state;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$commitStateTime(long now) {
        long dur;
        if (this.mCurState != -1 && (dur = now - this.mStartTime) > 0L) {
            this.mDurations.addDuration(this.mCurState, dur);
        }
        this.mStartTime = now;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$incActiveServices(String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.incActiveServices(serviceName);
        }
        ++this.mNumActiveServices;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$decActiveServices(String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.decActiveServices(serviceName);
        }
        --this.mNumActiveServices;
        if (this.mNumActiveServices < 0) {
            Slog.wtfStack("ProcessStats", "Proc active services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " proc=" + this.mName + " service=" + serviceName);
            this.mNumActiveServices = 0;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$incStartedServices(int memFactor, long now, String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.incStartedServices(memFactor, now, serviceName);
        }
        ++this.mNumStartedServices;
        if (this.mNumStartedServices == 1 && this.mCurState == -1) {
            this.setState(6 + memFactor * 14, now);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$decStartedServices(int memFactor, long now, String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.decStartedServices(memFactor, now, serviceName);
        }
        --this.mNumStartedServices;
        if (this.mNumStartedServices == 0 && this.mCurState % 14 == 6) {
            this.setState(-1, now);
        } else if (this.mNumStartedServices < 0) {
            Slog.wtfStack("ProcessStats", "Proc started services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " name=" + this.mName);
            this.mNumStartedServices = 0;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$addPss(long pss, long uss, long rss, boolean always, int type, long duration, ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        switch (type) {
            case 0: {
                ++this.mStats.mInternalSinglePssCount;
                this.mStats.mInternalSinglePssTime += duration;
                break;
            }
            case 1: {
                ++this.mStats.mInternalAllMemPssCount;
                this.mStats.mInternalAllMemPssTime += duration;
                break;
            }
            case 2: {
                ++this.mStats.mInternalAllPollPssCount;
                this.mStats.mInternalAllPollPssTime += duration;
                break;
            }
            case 3: {
                ++this.mStats.mExternalPssCount;
                this.mStats.mExternalPssTime += duration;
                break;
            }
            case 4: {
                ++this.mStats.mExternalSlowPssCount;
                this.mStats.mExternalSlowPssTime += duration;
            }
        }
        if (!always && this.mLastPssState == this.mCurState && SystemClock.uptimeMillis() < this.mLastPssTime + 30000L) {
            return;
        }
        this.mLastPssState = this.mCurState;
        this.mLastPssTime = SystemClock.uptimeMillis();
        if (this.mCurState != -1) {
            this.mCommonProcess.mPssTable.mergeStats(this.mCurState, 1, pss, pss, pss, uss, uss, uss, rss, rss, rss);
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            if (pkgList != null) {
                for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                    this.pullFixedProc(pkgList, (int)ip).mPssTable.mergeStats(this.mCurState, 1, pss, pss, pss, uss, uss, uss, rss, rss, rss);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$reportExcessiveCpu(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        ++this.mCommonProcess.mNumExcessiveCpu;
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            ++this.pullFixedProc(pkgList, (int)ip).mNumExcessiveCpu;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$addCachedKill(int num, long minPss, long avgPss, long maxPss) {
        if (this.mNumCachedKill <= 0) {
            this.mNumCachedKill = num;
            this.mMinCachedKillPss = minPss;
            this.mAvgCachedKillPss = avgPss;
            this.mMaxCachedKillPss = maxPss;
        } else {
            if (minPss < this.mMinCachedKillPss) {
                this.mMinCachedKillPss = minPss;
            }
            if (maxPss > this.mMaxCachedKillPss) {
                this.mMaxCachedKillPss = maxPss;
            }
            this.mAvgCachedKillPss = (long)(((double)this.mAvgCachedKillPss * (double)this.mNumCachedKill + (double)avgPss) / (double)(this.mNumCachedKill + num));
            this.mNumCachedKill += num;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$reportCachedKill(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList, long pss) {
        this.ensureNotDead();
        this.mCommonProcess.addCachedKill(1, pss, pss, pss);
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            this.pullFixedProc(pkgList, ip).addCachedKill(1, pss, pss, pss);
        }
    }

    private final ProcessState $$robo$$com_android_internal_app_procstats_ProcessState$pullFixedProc(String pkgName) {
        if (this.mMultiPackage) {
            LongSparseArray<ProcessStats.PackageState> vpkg = this.mStats.mPackages.get(pkgName, this.mUid);
            if (vpkg == null) {
                throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid);
            }
            ProcessStats.PackageState pkg = vpkg.get(this.mVersion);
            if (pkg == null) {
                throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
            }
            ProcessState proc = pkg.mProcesses.get(this.mName);
            if (proc == null) {
                throw new IllegalStateException("Didn't create per-package process " + this.mName + " in pkg " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
            }
            return proc;
        }
        return this;
    }

    private final ProcessState $$robo$$com_android_internal_app_procstats_ProcessState$pullFixedProc(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList, int index) {
        ProcessStats.ProcessStateHolder holder = pkgList.valueAt(index);
        ProcessState proc = holder.state;
        if (this.mDead && proc.mCommonProcess != proc) {
            Log.wtf("ProcessStats", "Pulling dead proc: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
            proc = this.mStats.getProcessStateLocked(proc.mPackage, proc.mUid, proc.mVersion, proc.mName);
        }
        if (proc.mMultiPackage) {
            LongSparseArray<ProcessStats.PackageState> vpkg = this.mStats.mPackages.get(pkgList.keyAt(index), proc.mUid);
            if (vpkg == null) {
                throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName);
            }
            ProcessStats.PackageState pkg = vpkg.get(proc.mVersion);
            if (pkg == null) {
                throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName + " version " + proc.mVersion);
            }
            String savedName = proc.mName;
            proc = pkg.mProcesses.get(proc.mName);
            if (proc == null) {
                throw new IllegalStateException("Didn't create per-package process " + savedName + " in pkg " + pkg.mPackageName + "/" + pkg.mUid);
            }
            holder.state = proc;
        }
        return proc;
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getDuration(int state, long now) {
        long time = this.mDurations.getValueForId((byte)state);
        if (this.mCurState == state) {
            time += now - this.mStartTime;
        }
        return time;
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssSampleCount(int state) {
        return this.mPssTable.getValueForId((byte)state, 0);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 1);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 2);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 3);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssUssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 4);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssUssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 5);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssUssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 6);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssRssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 7);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssRssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 8);
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$getPssRssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 9);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$aggregatePss(ProcessStats.TotalMemoryUseCollection data, long now) {
        PssAggr fgPss = new PssAggr();
        PssAggr bgPss = new PssAggr();
        PssAggr cachedPss = new PssAggr();
        boolean havePss = false;
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            int procState = type % 14;
            long samples = this.getPssSampleCount(type);
            if (samples <= 0L) continue;
            long avg = this.getPssAverage(type);
            havePss = true;
            if (procState <= 2) {
                fgPss.add(avg, samples);
                continue;
            }
            if (procState <= 7) {
                bgPss.add(avg, samples);
                continue;
            }
            cachedPss.add(avg, samples);
        }
        if (!havePss) {
            return;
        }
        boolean fgHasBg = false;
        boolean fgHasCached = false;
        boolean bgHasCached = false;
        if (fgPss.samples < 3L && bgPss.samples > 0L) {
            fgHasBg = true;
            fgPss.add(bgPss.pss, bgPss.samples);
        }
        if (fgPss.samples < 3L && cachedPss.samples > 0L) {
            fgHasCached = true;
            fgPss.add(cachedPss.pss, cachedPss.samples);
        }
        if (bgPss.samples < 3L && cachedPss.samples > 0L) {
            bgHasCached = true;
            bgPss.add(cachedPss.pss, cachedPss.samples);
        }
        if (bgPss.samples < 3L && !fgHasBg && fgPss.samples > 0L) {
            bgPss.add(fgPss.pss, fgPss.samples);
        }
        if (cachedPss.samples < 3L && !bgHasCached && bgPss.samples > 0L) {
            cachedPss.add(bgPss.pss, bgPss.samples);
        }
        if (cachedPss.samples < 3L && !fgHasCached && fgPss.samples > 0L) {
            cachedPss.add(fgPss.pss, fgPss.samples);
        }
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            long avg;
            int procState;
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurState == type) {
                time += now - this.mStartTime;
            }
            int n = procState = type % 14;
            data.processStateTime[n] = data.processStateTime[n] + time;
            long samples = this.getPssSampleCount(type);
            if (samples > 0L) {
                avg = this.getPssAverage(type);
            } else if (procState <= 2) {
                samples = fgPss.samples;
                avg = fgPss.pss;
            } else if (procState <= 7) {
                samples = bgPss.samples;
                avg = bgPss.pss;
            } else {
                samples = cachedPss.samples;
                avg = cachedPss.pss;
            }
            double newAvg = ((double)data.processStatePss[procState] * (double)data.processStateSamples[procState] + (double)avg * (double)samples) / (double)((long)data.processStateSamples[procState] + samples);
            data.processStatePss[procState] = (long)newAvg;
            int n2 = procState;
            data.processStateSamples[n2] = (int)((long)data.processStateSamples[n2] + samples);
            int n3 = procState;
            data.processStateWeight[n3] = data.processStateWeight[n3] + (double)avg * (double)time;
        }
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessState$computeProcessTimeLocked(int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        for (int is = 0; is < screenStates.length; ++is) {
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int bucket = (screenStates[is] + memStates[im]) * 14 + procStates[ip];
                    totalTime += this.getDuration(bucket, now);
                }
            }
        }
        this.mTmpTotalTime = totalTime;
        return totalTime;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpSummary(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime) {
        pw.print(prefix);
        pw.print("* ");
        pw.print(this.mName);
        pw.print(" / ");
        UserHandle.formatUid(pw, this.mUid);
        pw.print(" / v");
        pw.print(this.mVersion);
        pw.println(":");
        this.dumpProcessSummaryDetails(pw, prefix, "         TOTAL: ", screenStates, memStates, procStates, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "    Persistent: ", screenStates, memStates, new int[]{0}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "           Top: ", screenStates, memStates, new int[]{1}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        Imp Fg: ", screenStates, memStates, new int[]{2}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        Imp Bg: ", screenStates, memStates, new int[]{3}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        Backup: ", screenStates, memStates, new int[]{4}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "     Heavy Wgt: ", screenStates, memStates, new int[]{8}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "       Service: ", screenStates, memStates, new int[]{5}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "    Service Rs: ", screenStates, memStates, new int[]{6}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "      Receiver: ", screenStates, memStates, new int[]{7}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "         Heavy: ", screenStates, memStates, new int[]{9}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        (Home): ", screenStates, memStates, new int[]{9}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "    (Last Act): ", screenStates, memStates, new int[]{10}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "      (Cached): ", screenStates, memStates, new int[]{11, 12, 13}, now, totalTime, true);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpProcessState(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long time = this.mDurations.getValueForId((byte)bucket);
                    String running = "";
                    if (this.mCurState == bucket) {
                        running = " (running)";
                    }
                    if (time == 0L) continue;
                    pw.print(prefix);
                    if (screenStates.length > 1) {
                        DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(DumpUtils.STATE_NAMES[procStates[ip]]);
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                    totalTime += time;
                }
            }
        }
        if (totalTime != 0L) {
            pw.print(prefix);
            if (screenStates.length > 1) {
                DumpUtils.printScreenLabel(pw, -1);
            }
            if (memStates.length > 1) {
                DumpUtils.printMemLabel(pw, -1, '/');
            }
            pw.print("TOTAL  : ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpPss(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates) {
        boolean printedHeader = false;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long count = this.getPssSampleCount(bucket);
                    if (count <= 0L) continue;
                    if (!printedHeader) {
                        pw.print(prefix);
                        pw.print("PSS/USS (");
                        pw.print(this.mPssTable.getKeyCount());
                        pw.println(" entries):");
                        printedHeader = true;
                    }
                    pw.print(prefix);
                    pw.print("  ");
                    if (screenStates.length > 1) {
                        DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(DumpUtils.STATE_NAMES[procStates[ip]]);
                    pw.print(": ");
                    pw.print(count);
                    pw.print(" samples ");
                    DebugUtils.printSizeValue(pw, this.getPssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssAverage(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssMaximum(bucket) * 1024L);
                    pw.print(" / ");
                    DebugUtils.printSizeValue(pw, this.getPssUssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssUssAverage(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssUssMaximum(bucket) * 1024L);
                    pw.print(" / ");
                    DebugUtils.printSizeValue(pw, this.getPssRssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssRssAverage(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssRssMaximum(bucket) * 1024L);
                    pw.println();
                }
            }
        }
        if (this.mNumExcessiveCpu != 0) {
            pw.print(prefix);
            pw.print("Killed for excessive CPU use: ");
            pw.print(this.mNumExcessiveCpu);
            pw.println(" times");
        }
        if (this.mNumCachedKill != 0) {
            pw.print(prefix);
            pw.print("Killed from cached state: ");
            pw.print(this.mNumCachedKill);
            pw.print(" times from pss ");
            DebugUtils.printSizeValue(pw, this.mMinCachedKillPss * 1024L);
            pw.print("-");
            DebugUtils.printSizeValue(pw, this.mAvgCachedKillPss * 1024L);
            pw.print("-");
            DebugUtils.printSizeValue(pw, this.mMaxCachedKillPss * 1024L);
            pw.println();
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpProcessSummaryDetails(PrintWriter pw, String prefix, String label, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime, boolean full) {
        ProcessStats.ProcessDataCollection totals = new ProcessStats.ProcessDataCollection(screenStates, memStates, procStates);
        this.computeProcessData(totals, now);
        double percentage = (double)totals.totalTime / (double)totalTime * 100.0;
        if (percentage >= 0.005 || totals.numPss != 0L) {
            if (prefix != null) {
                pw.print(prefix);
            }
            if (label != null) {
                pw.print(label);
            }
            totals.print(pw, totalTime, full);
            if (prefix != null) {
                pw.println();
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpInternalLocked(PrintWriter pw, String prefix, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("myID=");
            pw.print(Integer.toHexString(System.identityHashCode(this)));
            pw.print(" mCommonProcess=");
            pw.print(Integer.toHexString(System.identityHashCode(this.mCommonProcess)));
            pw.print(" mPackage=");
            pw.println(this.mPackage);
            if (this.mMultiPackage) {
                pw.print(prefix);
                pw.print("mMultiPackage=");
                pw.println(this.mMultiPackage);
            }
            if (this != this.mCommonProcess) {
                pw.print(prefix);
                pw.print("Common Proc: ");
                pw.print(this.mCommonProcess.mName);
                pw.print("/");
                pw.print(this.mCommonProcess.mUid);
                pw.print(" pkg=");
                pw.println(this.mCommonProcess.mPackage);
            }
        }
        if (this.mActive) {
            pw.print(prefix);
            pw.print("mActive=");
            pw.println(this.mActive);
        }
        if (this.mDead) {
            pw.print(prefix);
            pw.print("mDead=");
            pw.println(this.mDead);
        }
        if (this.mNumActiveServices != 0 || this.mNumStartedServices != 0) {
            pw.print(prefix);
            pw.print("mNumActiveServices=");
            pw.print(this.mNumActiveServices);
            pw.print(" mNumStartedServices=");
            pw.println(this.mNumStartedServices);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$computeProcessData(ProcessStats.ProcessDataCollection data, long now) {
        data.totalTime = 0L;
        data.maxRss = 0L;
        data.avgRss = 0L;
        data.minRss = 0L;
        data.maxUss = 0L;
        data.avgUss = 0L;
        data.minUss = 0L;
        data.maxPss = 0L;
        data.avgPss = 0L;
        data.minPss = 0L;
        data.numPss = 0L;
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                for (int ip = 0; ip < data.procStates.length; ++ip) {
                    int bucket = (data.screenStates[is] + data.memStates[im]) * 14 + data.procStates[ip];
                    data.totalTime += this.getDuration(bucket, now);
                    long samples = this.getPssSampleCount(bucket);
                    if (samples <= 0L) continue;
                    long minPss = this.getPssMinimum(bucket);
                    long avgPss = this.getPssAverage(bucket);
                    long maxPss = this.getPssMaximum(bucket);
                    long minUss = this.getPssUssMinimum(bucket);
                    long avgUss = this.getPssUssAverage(bucket);
                    long maxUss = this.getPssUssMaximum(bucket);
                    long minRss = this.getPssRssMinimum(bucket);
                    long avgRss = this.getPssRssAverage(bucket);
                    long maxRss = this.getPssRssMaximum(bucket);
                    if (data.numPss == 0L) {
                        data.minPss = minPss;
                        data.avgPss = avgPss;
                        data.maxPss = maxPss;
                        data.minUss = minUss;
                        data.avgUss = avgUss;
                        data.maxUss = maxUss;
                        data.minRss = minRss;
                        data.avgRss = avgRss;
                        data.maxRss = maxRss;
                    } else {
                        if (minPss < data.minPss) {
                            data.minPss = minPss;
                        }
                        data.avgPss = (long)(((double)data.avgPss * (double)data.numPss + (double)avgPss * (double)samples) / (double)(data.numPss + samples));
                        if (maxPss > data.maxPss) {
                            data.maxPss = maxPss;
                        }
                        if (minUss < data.minUss) {
                            data.minUss = minUss;
                        }
                        data.avgUss = (long)(((double)data.avgUss * (double)data.numPss + (double)avgUss * (double)samples) / (double)(data.numPss + samples));
                        if (maxUss > data.maxUss) {
                            data.maxUss = maxUss;
                        }
                        if (minRss < data.minRss) {
                            data.minRss = minRss;
                        }
                        data.avgRss = (long)(((double)data.avgRss * (double)data.numPss + (double)avgRss * (double)samples) / (double)(data.numPss + samples));
                        if (maxRss > data.maxRss) {
                            data.maxRss = maxRss;
                        }
                    }
                    data.numPss += samples;
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpCsv(PrintWriter pw, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        int NSS = sepScreenStates ? screenStates.length : 1;
        int NMS = sepMemStates ? memStates.length : 1;
        int NPS = sepProcStates ? procStates.length : 1;
        for (int iss = 0; iss < NSS; ++iss) {
            for (int ims = 0; ims < NMS; ++ims) {
                for (int ips = 0; ips < NPS; ++ips) {
                    int vsscreen = sepScreenStates ? screenStates[iss] : 0;
                    int vsmem = sepMemStates ? memStates[ims] : 0;
                    int vsproc = sepProcStates ? procStates[ips] : 0;
                    int NSA = sepScreenStates ? 1 : screenStates.length;
                    int NMA = sepMemStates ? 1 : memStates.length;
                    int NPA = sepProcStates ? 1 : procStates.length;
                    long totalTime = 0L;
                    for (int isa = 0; isa < NSA; ++isa) {
                        for (int ima = 0; ima < NMA; ++ima) {
                            for (int ipa = 0; ipa < NPA; ++ipa) {
                                int vascreen = sepScreenStates ? 0 : screenStates[isa];
                                int vamem = sepMemStates ? 0 : memStates[ima];
                                int vaproc = sepProcStates ? 0 : procStates[ipa];
                                int bucket = (vsscreen + vascreen + vsmem + vamem) * 14 + vsproc + vaproc;
                                totalTime += this.getDuration(bucket, now);
                            }
                        }
                    }
                    pw.print("\t");
                    pw.print(totalTime);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpPackageProcCheckin(PrintWriter pw, String pkgName, int uid, long vers, String itemName, long now) {
        pw.print("pkgproc,");
        pw.print(pkgName);
        pw.print(",");
        pw.print(uid);
        pw.print(",");
        pw.print(vers);
        pw.print(",");
        pw.print(DumpUtils.collapseString(pkgName, itemName));
        this.dumpAllStateCheckin(pw, now);
        pw.println();
        if (this.mPssTable.getKeyCount() > 0) {
            pw.print("pkgpss,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            this.dumpAllPssCheckin(pw);
            pw.println();
        }
        if (this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            pw.print("pkgkills,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            pw.print(",");
            pw.print("0");
            pw.print(",");
            pw.print(this.mNumExcessiveCpu);
            pw.print(",");
            pw.print(this.mNumCachedKill);
            pw.print(",");
            pw.print(this.mMinCachedKillPss);
            pw.print(":");
            pw.print(this.mAvgCachedKillPss);
            pw.print(":");
            pw.print(this.mMaxCachedKillPss);
            pw.println();
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpProcCheckin(PrintWriter pw, String procName, int uid, long now) {
        if (this.mDurations.getKeyCount() > 0) {
            pw.print("proc,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            this.dumpAllStateCheckin(pw, now);
            pw.println();
        }
        if (this.mPssTable.getKeyCount() > 0) {
            pw.print("pss,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            this.dumpAllPssCheckin(pw);
            pw.println();
        }
        if (this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            pw.print("kills,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print("0");
            pw.print(",");
            pw.print(this.mNumExcessiveCpu);
            pw.print(",");
            pw.print(this.mNumCachedKill);
            pw.print(",");
            pw.print(this.mMinCachedKillPss);
            pw.print(":");
            pw.print(this.mAvgCachedKillPss);
            pw.print(":");
            pw.print(this.mMaxCachedKillPss);
            pw.println();
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpAllStateCheckin(PrintWriter pw, long now) {
        boolean didCurState = false;
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurState == type) {
                didCurState = true;
                time += now - this.mStartTime;
            }
            DumpUtils.printProcStateTagAndValue(pw, type, time);
        }
        if (!didCurState && this.mCurState != -1) {
            DumpUtils.printProcStateTagAndValue(pw, this.mCurState, now - this.mStartTime);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$dumpAllPssCheckin(PrintWriter pw) {
        int N = this.mPssTable.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.mPssTable.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            pw.print(',');
            DumpUtils.printProcStateTag(pw, type);
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 0));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 1));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 2));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 3));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 4));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 5));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 6));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 7));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 8));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 9));
        }
    }

    private final String $$robo$$com_android_internal_app_procstats_ProcessState$toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessState{").append(Integer.toHexString(System.identityHashCode(this))).append(" ").append(this.mName).append("/").append(this.mUid).append(" pkg=").append(this.mPackage);
        if (this.mMultiPackage) {
            sb.append(" (multi)");
        }
        if (this.mCommonProcess != this) {
            sb.append(" (sub)");
        }
        sb.append("}");
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessState$writeToProto(ProtoOutputStream proto, long fieldId, String procName, int uid, long now) {
        byte type;
        int key;
        int i;
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, procName);
        proto.write(1120986464258L, uid);
        if (this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            long killToken = proto.start(1146756268035L);
            proto.write(0x10500000001L, this.mNumExcessiveCpu);
            proto.write(1120986464258L, this.mNumCachedKill);
            ProtoUtils.toAggStatsProto(proto, 1146756268035L, this.mMinCachedKillPss, this.mAvgCachedKillPss, this.mMaxCachedKillPss);
            proto.end(killToken);
        }
        HashMap<Integer, Long> durationByState = new HashMap<Integer, Long>();
        boolean didCurState = false;
        for (i = 0; i < this.mDurations.getKeyCount(); ++i) {
            key = this.mDurations.getKeyAt(i);
            type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurState == type) {
                didCurState = true;
                time += now - this.mStartTime;
            }
            durationByState.put(Integer.valueOf(type), time);
        }
        if (!didCurState && this.mCurState != -1) {
            durationByState.put(this.mCurState, now - this.mStartTime);
        }
        for (i = 0; i < this.mPssTable.getKeyCount(); ++i) {
            key = this.mPssTable.getKeyAt(i);
            type = SparseMappingTable.getIdFromKey(key);
            if (!durationByState.containsKey(type)) continue;
            long stateToken = proto.start(2246267895813L);
            DumpUtils.printProcStateTagProto(proto, 0x10E00000001L, 1159641169922L, 1159641169923L, type);
            long duration = (Long)durationByState.get(type);
            durationByState.remove(type);
            proto.write(1112396529668L, duration);
            proto.write(0x10500000005L, this.mPssTable.getValue(key, 0));
            ProtoUtils.toAggStatsProto(proto, 1146756268038L, this.mPssTable.getValue(key, 1), this.mPssTable.getValue(key, 2), this.mPssTable.getValue(key, 3));
            ProtoUtils.toAggStatsProto(proto, 1146756268039L, this.mPssTable.getValue(key, 4), this.mPssTable.getValue(key, 5), this.mPssTable.getValue(key, 6));
            ProtoUtils.toAggStatsProto(proto, 1146756268040L, this.mPssTable.getValue(key, 7), this.mPssTable.getValue(key, 8), this.mPssTable.getValue(key, 9));
            proto.end(stateToken);
        }
        for (Map.Entry entry : durationByState.entrySet()) {
            long stateToken = proto.start(2246267895813L);
            DumpUtils.printProcStateTagProto(proto, 0x10E00000001L, 1159641169922L, 1159641169923L, (Integer)entry.getKey());
            proto.write(1112396529668L, (Long)entry.getValue());
            proto.end(stateToken);
        }
        proto.end(token);
    }

    static void __staticInitializer__() {
        PROCESS_STATE_TO_STATE = new int[]{0, 0, 1, 2, 2, 2, 3, 3, 4, 5, 7, 1, 8, 9, 10, 11, 12, 11, 13};
        COMPARATOR = new Comparator<ProcessState>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_app_procstats_ProcessState_1$__constructor__() {
            }

            private final int $$robo$$com_android_internal_app_procstats_ProcessState_1$compare(ProcessState lhs, ProcessState rhs) {
                if (lhs.mTmpTotalTime < rhs.mTmpTotalTime) {
                    return -1;
                }
                if (lhs.mTmpTotalTime > rhs.mTmpTotalTime) {
                    return 1;
                }
                return 0;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_app_procstats_ProcessState_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessState_1$__constructor__(), this);
            }

            @Override
            public int compare(ProcessState processState, ProcessState processState2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_procstats_ProcessState_1$compare(com.android.internal.app.procstats.ProcessState com.android.internal.app.procstats.ProcessState ), this, processState, processState2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ProcessStats processStats, String string2, int n, long l, String string3) {
        this.$$robo$$com_android_internal_app_procstats_ProcessState$__constructor__(processStats, string2, n, l, string3);
    }

    public ProcessState(ProcessStats processStats, String string2, int n, long l, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessState$__constructor__(com.android.internal.app.procstats.ProcessStats java.lang.String int long java.lang.String ), this, processStats, string2, n, l, string3);
    }

    private void __constructor__(ProcessState processState, String string2, int n, long l, String string3, long l2) {
        this.$$robo$$com_android_internal_app_procstats_ProcessState$__constructor__(processState, string2, n, l, string3, l2);
    }

    public ProcessState(ProcessState processState, String string2, int n, long l, String string3, long l2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessState$__constructor__(com.android.internal.app.procstats.ProcessState java.lang.String int long java.lang.String long ), this, processState, string2, n, l, string3, l2);
    }

    public ProcessState clone(long l) {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$com_android_internal_app_procstats_ProcessState$clone(long ), this, l);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$com_android_internal_app_procstats_ProcessState$getName(), this);
    }

    public ProcessState getCommonProcess() {
        return InvokeDynamicSupport.bootstrap("getCommonProcess", $$robo$$com_android_internal_app_procstats_ProcessState$getCommonProcess(), this);
    }

    public void makeStandalone() {
        InvokeDynamicSupport.bootstrap("makeStandalone", $$robo$$com_android_internal_app_procstats_ProcessState$makeStandalone(), this);
    }

    public String getPackage() {
        return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$com_android_internal_app_procstats_ProcessState$getPackage(), this);
    }

    public int getUid() {
        return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$com_android_internal_app_procstats_ProcessState$getUid(), this);
    }

    public long getVersion() {
        return (long)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$com_android_internal_app_procstats_ProcessState$getVersion(), this);
    }

    public boolean isMultiPackage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiPackage", $$robo$$com_android_internal_app_procstats_ProcessState$isMultiPackage(), this);
    }

    public void setMultiPackage(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMultiPackage", $$robo$$com_android_internal_app_procstats_ProcessState$setMultiPackage(boolean ), this, bl);
    }

    public int getDurationsBucketCount() {
        return (int)InvokeDynamicSupport.bootstrap("getDurationsBucketCount", $$robo$$com_android_internal_app_procstats_ProcessState$getDurationsBucketCount(), this);
    }

    public void add(ProcessState processState) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_procstats_ProcessState$add(com.android.internal.app.procstats.ProcessState ), this, processState);
    }

    public void resetSafely(long l) {
        InvokeDynamicSupport.bootstrap("resetSafely", $$robo$$com_android_internal_app_procstats_ProcessState$resetSafely(long ), this, l);
    }

    public void makeDead() {
        InvokeDynamicSupport.bootstrap("makeDead", $$robo$$com_android_internal_app_procstats_ProcessState$makeDead(), this);
    }

    private void ensureNotDead() {
        InvokeDynamicSupport.bootstrap("ensureNotDead", $$robo$$com_android_internal_app_procstats_ProcessState$ensureNotDead(), this);
    }

    public void writeToParcel(Parcel parcel, long l) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_procstats_ProcessState$writeToParcel(android.os.Parcel long ), this, parcel, l);
    }

    public boolean readFromParcel(Parcel parcel, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_procstats_ProcessState$readFromParcel(android.os.Parcel boolean ), this, parcel, bl);
    }

    public void makeActive() {
        InvokeDynamicSupport.bootstrap("makeActive", $$robo$$com_android_internal_app_procstats_ProcessState$makeActive(), this);
    }

    public void makeInactive() {
        InvokeDynamicSupport.bootstrap("makeInactive", $$robo$$com_android_internal_app_procstats_ProcessState$makeInactive(), this);
    }

    public boolean isInUse() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInUse", $$robo$$com_android_internal_app_procstats_ProcessState$isInUse(), this);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$com_android_internal_app_procstats_ProcessState$isActive(), this);
    }

    public boolean hasAnyData() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAnyData", $$robo$$com_android_internal_app_procstats_ProcessState$hasAnyData(), this);
    }

    public void setState(int n, int n2, long l, ArrayMap<String, ProcessStats.ProcessStateHolder> arrayMap) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_app_procstats_ProcessState$setState(int int long android.util.ArrayMap<java.lang.String, com.android.internal.app.procstats.ProcessStats$ProcessStateHolder> ), this, n, n2, l, arrayMap);
    }

    public void setState(int n, long l) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_app_procstats_ProcessState$setState(int long ), this, n, l);
    }

    public void commitStateTime(long l) {
        InvokeDynamicSupport.bootstrap("commitStateTime", $$robo$$com_android_internal_app_procstats_ProcessState$commitStateTime(long ), this, l);
    }

    public void incActiveServices(String string2) {
        InvokeDynamicSupport.bootstrap("incActiveServices", $$robo$$com_android_internal_app_procstats_ProcessState$incActiveServices(java.lang.String ), this, string2);
    }

    public void decActiveServices(String string2) {
        InvokeDynamicSupport.bootstrap("decActiveServices", $$robo$$com_android_internal_app_procstats_ProcessState$decActiveServices(java.lang.String ), this, string2);
    }

    public void incStartedServices(int n, long l, String string2) {
        InvokeDynamicSupport.bootstrap("incStartedServices", $$robo$$com_android_internal_app_procstats_ProcessState$incStartedServices(int long java.lang.String ), this, n, l, string2);
    }

    public void decStartedServices(int n, long l, String string2) {
        InvokeDynamicSupport.bootstrap("decStartedServices", $$robo$$com_android_internal_app_procstats_ProcessState$decStartedServices(int long java.lang.String ), this, n, l, string2);
    }

    public void addPss(long l, long l2, long l3, boolean bl, int n, long l4, ArrayMap<String, ProcessStats.ProcessStateHolder> arrayMap) {
        InvokeDynamicSupport.bootstrap("addPss", $$robo$$com_android_internal_app_procstats_ProcessState$addPss(long long long boolean int long android.util.ArrayMap<java.lang.String, com.android.internal.app.procstats.ProcessStats$ProcessStateHolder> ), this, l, l2, l3, bl, n, l4, arrayMap);
    }

    public void reportExcessiveCpu(ArrayMap<String, ProcessStats.ProcessStateHolder> arrayMap) {
        InvokeDynamicSupport.bootstrap("reportExcessiveCpu", $$robo$$com_android_internal_app_procstats_ProcessState$reportExcessiveCpu(android.util.ArrayMap<java.lang.String, com.android.internal.app.procstats.ProcessStats$ProcessStateHolder> ), this, arrayMap);
    }

    private void addCachedKill(int n, long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrap("addCachedKill", $$robo$$com_android_internal_app_procstats_ProcessState$addCachedKill(int long long long ), this, n, l, l2, l3);
    }

    public void reportCachedKill(ArrayMap<String, ProcessStats.ProcessStateHolder> arrayMap, long l) {
        InvokeDynamicSupport.bootstrap("reportCachedKill", $$robo$$com_android_internal_app_procstats_ProcessState$reportCachedKill(android.util.ArrayMap<java.lang.String, com.android.internal.app.procstats.ProcessStats$ProcessStateHolder> long ), this, arrayMap, l);
    }

    public ProcessState pullFixedProc(String string2) {
        return InvokeDynamicSupport.bootstrap("pullFixedProc", $$robo$$com_android_internal_app_procstats_ProcessState$pullFixedProc(java.lang.String ), this, string2);
    }

    private ProcessState pullFixedProc(ArrayMap<String, ProcessStats.ProcessStateHolder> arrayMap, int n) {
        return InvokeDynamicSupport.bootstrap("pullFixedProc", $$robo$$com_android_internal_app_procstats_ProcessState$pullFixedProc(android.util.ArrayMap<java.lang.String, com.android.internal.app.procstats.ProcessStats$ProcessStateHolder> int ), this, arrayMap, n);
    }

    public long getDuration(int n, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$com_android_internal_app_procstats_ProcessState$getDuration(int long ), this, n, l);
    }

    public long getPssSampleCount(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssSampleCount", $$robo$$com_android_internal_app_procstats_ProcessState$getPssSampleCount(int ), this, n);
    }

    public long getPssMinimum(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssMinimum", $$robo$$com_android_internal_app_procstats_ProcessState$getPssMinimum(int ), this, n);
    }

    public long getPssAverage(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssAverage", $$robo$$com_android_internal_app_procstats_ProcessState$getPssAverage(int ), this, n);
    }

    public long getPssMaximum(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssMaximum", $$robo$$com_android_internal_app_procstats_ProcessState$getPssMaximum(int ), this, n);
    }

    public long getPssUssMinimum(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssUssMinimum", $$robo$$com_android_internal_app_procstats_ProcessState$getPssUssMinimum(int ), this, n);
    }

    public long getPssUssAverage(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssUssAverage", $$robo$$com_android_internal_app_procstats_ProcessState$getPssUssAverage(int ), this, n);
    }

    public long getPssUssMaximum(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssUssMaximum", $$robo$$com_android_internal_app_procstats_ProcessState$getPssUssMaximum(int ), this, n);
    }

    public long getPssRssMinimum(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssRssMinimum", $$robo$$com_android_internal_app_procstats_ProcessState$getPssRssMinimum(int ), this, n);
    }

    public long getPssRssAverage(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssRssAverage", $$robo$$com_android_internal_app_procstats_ProcessState$getPssRssAverage(int ), this, n);
    }

    public long getPssRssMaximum(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPssRssMaximum", $$robo$$com_android_internal_app_procstats_ProcessState$getPssRssMaximum(int ), this, n);
    }

    public void aggregatePss(ProcessStats.TotalMemoryUseCollection totalMemoryUseCollection, long l) {
        InvokeDynamicSupport.bootstrap("aggregatePss", $$robo$$com_android_internal_app_procstats_ProcessState$aggregatePss(com.android.internal.app.procstats.ProcessStats$TotalMemoryUseCollection long ), this, totalMemoryUseCollection, l);
    }

    public long computeProcessTimeLocked(int[] nArray, int[] nArray2, int[] nArray3, long l) {
        return (long)InvokeDynamicSupport.bootstrap("computeProcessTimeLocked", $$robo$$com_android_internal_app_procstats_ProcessState$computeProcessTimeLocked(int[] int[] int[] long ), this, nArray, nArray2, nArray3, l);
    }

    public void dumpSummary(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2, int[] nArray3, long l, long l2) {
        InvokeDynamicSupport.bootstrap("dumpSummary", $$robo$$com_android_internal_app_procstats_ProcessState$dumpSummary(java.io.PrintWriter java.lang.String int[] int[] int[] long long ), this, printWriter, string2, nArray, nArray2, nArray3, l, l2);
    }

    public void dumpProcessState(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrap("dumpProcessState", $$robo$$com_android_internal_app_procstats_ProcessState$dumpProcessState(java.io.PrintWriter java.lang.String int[] int[] int[] long ), this, printWriter, string2, nArray, nArray2, nArray3, l);
    }

    public void dumpPss(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2, int[] nArray3) {
        InvokeDynamicSupport.bootstrap("dumpPss", $$robo$$com_android_internal_app_procstats_ProcessState$dumpPss(java.io.PrintWriter java.lang.String int[] int[] int[] ), this, printWriter, string2, nArray, nArray2, nArray3);
    }

    private void dumpProcessSummaryDetails(PrintWriter printWriter, String string2, String string3, int[] nArray, int[] nArray2, int[] nArray3, long l, long l2, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpProcessSummaryDetails", $$robo$$com_android_internal_app_procstats_ProcessState$dumpProcessSummaryDetails(java.io.PrintWriter java.lang.String java.lang.String int[] int[] int[] long long boolean ), this, printWriter, string2, string3, nArray, nArray2, nArray3, l, l2, bl);
    }

    public void dumpInternalLocked(PrintWriter printWriter, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpInternalLocked", $$robo$$com_android_internal_app_procstats_ProcessState$dumpInternalLocked(java.io.PrintWriter java.lang.String boolean ), this, printWriter, string2, bl);
    }

    public void computeProcessData(ProcessStats.ProcessDataCollection processDataCollection, long l) {
        InvokeDynamicSupport.bootstrap("computeProcessData", $$robo$$com_android_internal_app_procstats_ProcessState$computeProcessData(com.android.internal.app.procstats.ProcessStats$ProcessDataCollection long ), this, processDataCollection, l);
    }

    public void dumpCsv(PrintWriter printWriter, boolean bl, int[] nArray, boolean bl2, int[] nArray2, boolean bl3, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrap("dumpCsv", $$robo$$com_android_internal_app_procstats_ProcessState$dumpCsv(java.io.PrintWriter boolean int[] boolean int[] boolean int[] long ), this, printWriter, bl, nArray, bl2, nArray2, bl3, nArray3, l);
    }

    public void dumpPackageProcCheckin(PrintWriter printWriter, String string2, int n, long l, String string3, long l2) {
        InvokeDynamicSupport.bootstrap("dumpPackageProcCheckin", $$robo$$com_android_internal_app_procstats_ProcessState$dumpPackageProcCheckin(java.io.PrintWriter java.lang.String int long java.lang.String long ), this, printWriter, string2, n, l, string3, l2);
    }

    public void dumpProcCheckin(PrintWriter printWriter, String string2, int n, long l) {
        InvokeDynamicSupport.bootstrap("dumpProcCheckin", $$robo$$com_android_internal_app_procstats_ProcessState$dumpProcCheckin(java.io.PrintWriter java.lang.String int long ), this, printWriter, string2, n, l);
    }

    public void dumpAllStateCheckin(PrintWriter printWriter, long l) {
        InvokeDynamicSupport.bootstrap("dumpAllStateCheckin", $$robo$$com_android_internal_app_procstats_ProcessState$dumpAllStateCheckin(java.io.PrintWriter long ), this, printWriter, l);
    }

    public void dumpAllPssCheckin(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpAllPssCheckin", $$robo$$com_android_internal_app_procstats_ProcessState$dumpAllPssCheckin(java.io.PrintWriter ), this, printWriter);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_procstats_ProcessState$toString(), this);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l, String string2, int n, long l2) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$com_android_internal_app_procstats_ProcessState$writeToProto(android.util.proto.ProtoOutputStream long java.lang.String int long ), this, protoOutputStream, l, string2, n, l2);
    }

    static {
        RobolectricInternals.classInitializing(ProcessState.class);
    }

    public /* synthetic */ ProcessState() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PssAggr
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        long pss;
        long samples;

        private void $$robo$$com_android_internal_app_procstats_ProcessState_PssAggr$__constructor__() {
            this.pss = 0L;
            this.samples = 0L;
        }

        private final void $$robo$$com_android_internal_app_procstats_ProcessState_PssAggr$add(long newPss, long newSamples) {
            this.pss = (long)((double)this.pss * (double)this.samples + (double)newPss * (double)newSamples) / (this.samples + newSamples);
            this.samples += newSamples;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_app_procstats_ProcessState_PssAggr$__constructor__();
        }

        public PssAggr() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessState_PssAggr$__constructor__(), this);
        }

        void add(long l, long l2) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_procstats_ProcessState_PssAggr$add(long long ), this, l, l2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PssAggr)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

