/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.os.LocaleList;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocalePicker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleStore
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static HashMap<String, LocaleInfo> sLocaleCache;
    private static boolean sFullyInitialized;

    private void $$robo$$com_android_internal_app_LocaleStore$__constructor__() {
    }

    private static final Set<String> $$robo$$com_android_internal_app_LocaleStore$getSimCountries(Context context) {
        HashSet<String> result = new HashSet<String>();
        TelephonyManager tm = TelephonyManager.from(context);
        if (tm != null) {
            String iso = tm.getSimCountryIso().toUpperCase(Locale.US);
            if (!iso.isEmpty()) {
                result.add(iso);
            }
            if (!(iso = tm.getNetworkCountryIso().toUpperCase(Locale.US)).isEmpty()) {
                result.add(iso);
            }
        }
        return result;
    }

    private static final void $$robo$$com_android_internal_app_LocaleStore$updateSimCountries(Context context) {
        Set<String> simCountries = LocaleStore.getSimCountries(context);
        for (LocaleInfo li : sLocaleCache.values()) {
            if (!simCountries.contains(li.getLocale().getCountry())) continue;
            li.mSuggestionFlags |= 1;
        }
    }

    private static final void $$robo$$com_android_internal_app_LocaleStore$addSuggestedLocalesForRegion(Locale locale) {
        if (locale == null) {
            return;
        }
        String country = locale.getCountry();
        if (country.isEmpty()) {
            return;
        }
        for (LocaleInfo li : sLocaleCache.values()) {
            if (!country.equals(li.getLocale().getCountry())) continue;
            li.mSuggestionFlags |= 1;
        }
    }

    private static final void $$robo$$com_android_internal_app_LocaleStore$fillCache(Context context) {
        if (sFullyInitialized) {
            return;
        }
        Set<String> simCountries = LocaleStore.getSimCountries(context);
        boolean isInDeveloperMode = Settings.Global.getInt(context.getContentResolver(), "development_settings_enabled", 0) != 0;
        for (String localeId : LocalePicker.getSupportedLocales(context)) {
            String parentId;
            if (localeId.isEmpty()) {
                throw new IllformedLocaleException("Bad locale entry in locale_config.xml");
            }
            LocaleInfo li = new LocaleInfo(localeId, null);
            if (LocaleList.isPseudoLocale(li.getLocale())) {
                if (!isInDeveloperMode) continue;
                li.setTranslated(true);
                li.mIsPseudo = true;
                li.mSuggestionFlags |= 1;
            }
            if (simCountries.contains(li.getLocale().getCountry())) {
                li.mSuggestionFlags |= 1;
            }
            sLocaleCache.put(li.getId(), li);
            Locale parent = li.getParent();
            if (parent == null || sLocaleCache.containsKey(parentId = parent.toLanguageTag())) continue;
            sLocaleCache.put(parentId, new LocaleInfo(parent, null));
        }
        HashSet<String> localizedLocales = new HashSet<String>();
        for (String localeId : LocalePicker.getSystemAssetLocales()) {
            LocaleInfo li = new LocaleInfo(localeId, null);
            String country = li.getLocale().getCountry();
            if (!country.isEmpty()) {
                LocaleInfo cachedLocale = null;
                if (sLocaleCache.containsKey(li.getId())) {
                    cachedLocale = sLocaleCache.get(li.getId());
                } else {
                    String langScriptCtry = li.getLangScriptKey() + "-" + country;
                    if (sLocaleCache.containsKey(langScriptCtry)) {
                        cachedLocale = sLocaleCache.get(langScriptCtry);
                    }
                }
                if (cachedLocale != null) {
                    cachedLocale.mSuggestionFlags |= 2;
                }
            }
            localizedLocales.add(li.getLangScriptKey());
        }
        for (LocaleInfo li : sLocaleCache.values()) {
            li.setTranslated(localizedLocales.contains(li.getLangScriptKey()));
        }
        LocaleStore.addSuggestedLocalesForRegion(Locale.getDefault());
        sFullyInitialized = true;
    }

    private static final int $$robo$$com_android_internal_app_LocaleStore$getLevel(Set<String> ignorables, LocaleInfo li, boolean translatedOnly) {
        if (ignorables.contains(li.getId())) {
            return 0;
        }
        if (li.mIsPseudo) {
            return 2;
        }
        if (translatedOnly && !li.isTranslated()) {
            return 0;
        }
        if (li.getParent() != null) {
            return 2;
        }
        return 0;
    }

    private static final Set<LocaleInfo> $$robo$$com_android_internal_app_LocaleStore$getLevelLocales(Context context, Set<String> ignorables, LocaleInfo parent, boolean translatedOnly) {
        LocaleStore.fillCache(context);
        String parentId = parent == null ? null : parent.getId();
        HashSet<LocaleInfo> result = new HashSet<LocaleInfo>();
        for (LocaleInfo li : sLocaleCache.values()) {
            int level = LocaleStore.getLevel(ignorables, li, translatedOnly);
            if (level != 2) continue;
            if (parent != null) {
                if (!parentId.equals(li.getParent().toLanguageTag())) continue;
                result.add(li);
                continue;
            }
            if (li.isSuggestionOfType(1)) {
                result.add(li);
                continue;
            }
            result.add(LocaleStore.getLocaleInfo(li.getParent()));
        }
        return result;
    }

    private static final LocaleInfo $$robo$$com_android_internal_app_LocaleStore$getLocaleInfo(Locale locale) {
        LocaleInfo result;
        String id2 = locale.toLanguageTag();
        if (!sLocaleCache.containsKey(id2)) {
            result = new LocaleInfo(locale, null);
            sLocaleCache.put(id2, result);
        } else {
            result = sLocaleCache.get(id2);
        }
        return result;
    }

    static void __staticInitializer__() {
        sLocaleCache = new HashMap();
        sFullyInitialized = false;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_LocaleStore$__constructor__();
    }

    public LocaleStore() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleStore$__constructor__(), this);
    }

    private static Set<String> getSimCountries(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSimCountries", $$robo$$com_android_internal_app_LocaleStore$getSimCountries(android.content.Context ), (Context)context);
    }

    public static void updateSimCountries(Context context) {
        InvokeDynamicSupport.bootstrapStatic("updateSimCountries", $$robo$$com_android_internal_app_LocaleStore$updateSimCountries(android.content.Context ), (Context)context);
    }

    private static void addSuggestedLocalesForRegion(Locale locale) {
        InvokeDynamicSupport.bootstrapStatic("addSuggestedLocalesForRegion", $$robo$$com_android_internal_app_LocaleStore$addSuggestedLocalesForRegion(java.util.Locale ), (Locale)locale);
    }

    public static void fillCache(Context context) {
        InvokeDynamicSupport.bootstrapStatic("fillCache", $$robo$$com_android_internal_app_LocaleStore$fillCache(android.content.Context ), (Context)context);
    }

    private static int getLevel(Set<String> set, LocaleInfo localeInfo, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLevel", $$robo$$com_android_internal_app_LocaleStore$getLevel(java.util.Set<java.lang.String> com.android.internal.app.LocaleStore$LocaleInfo boolean ), set, (LocaleInfo)localeInfo, (boolean)bl);
    }

    public static Set<LocaleInfo> getLevelLocales(Context context, Set<String> set, LocaleInfo localeInfo, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getLevelLocales", $$robo$$com_android_internal_app_LocaleStore$getLevelLocales(android.content.Context java.util.Set<java.lang.String> com.android.internal.app.LocaleStore$LocaleInfo boolean ), (Context)context, set, (LocaleInfo)localeInfo, (boolean)bl);
    }

    public static LocaleInfo getLocaleInfo(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getLocaleInfo", $$robo$$com_android_internal_app_LocaleStore$getLocaleInfo(java.util.Locale ), (Locale)locale);
    }

    static {
        RobolectricInternals.classInitializing(LocaleStore.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LocaleInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int SUGGESTION_TYPE_NONE = 0;
        private static int SUGGESTION_TYPE_SIM = 1;
        private static int SUGGESTION_TYPE_CFG = 2;
        private Locale mLocale;
        private Locale mParent;
        private String mId;
        private boolean mIsTranslated;
        private boolean mIsPseudo;
        private boolean mIsChecked;
        private int mSuggestionFlags;
        private String mFullNameNative;
        private String mFullCountryNameNative;
        private String mLangScriptKey;

        private void $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(Locale locale) {
            this.mLocale = locale;
            this.mId = locale.toLanguageTag();
            this.mParent = LocaleInfo.getParent(locale);
            this.mIsChecked = false;
            this.mSuggestionFlags = 0;
            this.mIsTranslated = false;
            this.mIsPseudo = false;
        }

        private void $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(String localeId) {
        }

        private static final Locale $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getParent(Locale locale) {
            if (locale.getCountry().isEmpty()) {
                return null;
            }
            return new Locale.Builder().setLocale(locale).setRegion("").setExtension('u', "").build();
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$toString() {
            return this.mId;
        }

        private final Locale $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getLocale() {
            return this.mLocale;
        }

        private final Locale $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getParent() {
            return this.mParent;
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getId() {
            return this.mId;
        }

        private final boolean $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$isTranslated() {
            return this.mIsTranslated;
        }

        private final void $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$setTranslated(boolean isTranslated) {
            this.mIsTranslated = isTranslated;
        }

        private final boolean $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$isSuggested() {
            if (!this.mIsTranslated) {
                return false;
            }
            return this.mSuggestionFlags != 0;
        }

        private final boolean $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$isSuggestionOfType(int suggestionMask) {
            if (!this.mIsTranslated) {
                return false;
            }
            return (this.mSuggestionFlags & suggestionMask) == suggestionMask;
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullNameNative() {
            if (this.mFullNameNative == null) {
                this.mFullNameNative = LocaleHelper.getDisplayName(this.mLocale, this.mLocale, true);
            }
            return this.mFullNameNative;
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullCountryNameNative() {
            if (this.mFullCountryNameNative == null) {
                this.mFullCountryNameNative = LocaleHelper.getDisplayCountry(this.mLocale, this.mLocale);
            }
            return this.mFullCountryNameNative;
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullCountryNameInUiLanguage() {
            return LocaleHelper.getDisplayCountry(this.mLocale);
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullNameInUiLanguage() {
            return LocaleHelper.getDisplayName(this.mLocale, true);
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getLangScriptKey() {
            if (this.mLangScriptKey == null) {
                Locale baseLocale = new Locale.Builder().setLocale(this.mLocale).setExtension('u', "").build();
                Locale parentWithScript = LocaleInfo.getParent(LocaleHelper.addLikelySubtags(baseLocale));
                this.mLangScriptKey = parentWithScript == null ? this.mLocale.toLanguageTag() : parentWithScript.toLanguageTag();
            }
            return this.mLangScriptKey;
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getLabel(boolean countryMode) {
            if (countryMode) {
                return this.getFullCountryNameNative();
            }
            return this.getFullNameNative();
        }

        private final String $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getContentDescription(boolean countryMode) {
            if (countryMode) {
                return this.getFullCountryNameInUiLanguage();
            }
            return this.getFullNameInUiLanguage();
        }

        private final boolean $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getChecked() {
            return this.mIsChecked;
        }

        private final void $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$setChecked(boolean checked) {
            this.mIsChecked = checked;
        }

        private /* synthetic */ void $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(String x0, 1 x1) {
        }

        private /* synthetic */ void $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(Locale x0, 1 x1) {
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(locale);
        }

        public LocaleInfo(Locale locale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(java.util.Locale ), this, locale);
        }

        private void __constructor__(String string2) {
            this.$$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(string2);
        }

        public LocaleInfo(String string2) {
            this(Locale.forLanguageTag(string2));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(java.lang.String ), this, string2);
        }

        private static Locale getParent(Locale locale) {
            return InvokeDynamicSupport.bootstrapStatic("getParent", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getParent(java.util.Locale ), (Locale)locale);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$toString(), this);
        }

        public Locale getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getLocale(), this);
        }

        public Locale getParent() {
            return InvokeDynamicSupport.bootstrap("getParent", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getParent(), this);
        }

        public String getId() {
            return InvokeDynamicSupport.bootstrap("getId", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getId(), this);
        }

        public boolean isTranslated() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTranslated", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$isTranslated(), this);
        }

        public void setTranslated(boolean bl) {
            InvokeDynamicSupport.bootstrap("setTranslated", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$setTranslated(boolean ), this, bl);
        }

        boolean isSuggested() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSuggested", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$isSuggested(), this);
        }

        private boolean isSuggestionOfType(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSuggestionOfType", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$isSuggestionOfType(int ), this, n);
        }

        public String getFullNameNative() {
            return InvokeDynamicSupport.bootstrap("getFullNameNative", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullNameNative(), this);
        }

        String getFullCountryNameNative() {
            return InvokeDynamicSupport.bootstrap("getFullCountryNameNative", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullCountryNameNative(), this);
        }

        String getFullCountryNameInUiLanguage() {
            return InvokeDynamicSupport.bootstrap("getFullCountryNameInUiLanguage", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullCountryNameInUiLanguage(), this);
        }

        public String getFullNameInUiLanguage() {
            return InvokeDynamicSupport.bootstrap("getFullNameInUiLanguage", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getFullNameInUiLanguage(), this);
        }

        private String getLangScriptKey() {
            return InvokeDynamicSupport.bootstrap("getLangScriptKey", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getLangScriptKey(), this);
        }

        String getLabel(boolean bl) {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getLabel(boolean ), this, bl);
        }

        String getContentDescription(boolean bl) {
            return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getContentDescription(boolean ), this, bl);
        }

        public boolean getChecked() {
            return (boolean)InvokeDynamicSupport.bootstrap("getChecked", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$getChecked(), this);
        }

        public void setChecked(boolean bl) {
            InvokeDynamicSupport.bootstrap("setChecked", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$setChecked(boolean ), this, bl);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(string2, var2_2);
        }

        public /* synthetic */ LocaleInfo(String string2, 1 var2_2) {
            this(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(java.lang.String com.android.internal.app.LocaleStore$1 ), this, string2, var2_2);
        }

        private /* synthetic */ void __constructor__(Locale locale, 1 var2_2) {
            this.$$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(locale, var2_2);
        }

        public /* synthetic */ LocaleInfo(Locale locale, 1 var2_2) {
            this(locale);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleStore_LocaleInfo$__constructor__(java.util.Locale com.android.internal.app.LocaleStore$1 ), this, locale, var2_2);
        }

        public /* synthetic */ LocaleInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

