/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.icu.text.DecimalFormatSymbols;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.style.TtsSpan;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.RadialTimePickerView;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextInputTimePickerView;
import android.widget.TextView;
import android.widget.TimePicker;
import com.android.internal.R;
import com.android.internal.widget.NumericTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimePickerClockDelegate
extends TimePicker.AbstractTimePickerDelegate
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long DELAY_COMMIT_MILLIS = 2000L;
    private static int FROM_EXTERNAL_API = 0;
    private static int FROM_RADIAL_PICKER = 1;
    private static int FROM_INPUT_PICKER = 2;
    private static int HOUR_INDEX = 0;
    private static int MINUTE_INDEX = 1;
    private static int[] ATTRS_TEXT_COLOR;
    private static int[] ATTRS_DISABLED_ALPHA;
    private static int AM = 0;
    private static int PM = 1;
    private static int HOURS_IN_HALF_DAY = 12;
    private NumericTextView mHourView;
    private NumericTextView mMinuteView;
    private View mAmPmLayout;
    private RadioButton mAmLabel;
    private RadioButton mPmLabel;
    private RadialTimePickerView mRadialTimePickerView;
    private TextView mSeparatorView;
    private boolean mRadialPickerModeEnabled;
    private ImageButton mRadialTimePickerModeButton;
    private String mRadialTimePickerModeEnabledDescription;
    private String mTextInputPickerModeEnabledDescription;
    private View mRadialTimePickerHeader;
    private View mTextInputPickerHeader;
    private TextInputTimePickerView mTextInputPickerView;
    private Calendar mTempCalendar;
    private String mSelectHours;
    private String mSelectMinutes;
    private boolean mIsEnabled;
    private boolean mAllowAutoAdvance;
    private int mCurrentHour;
    private int mCurrentMinute;
    private boolean mIs24Hour;
    private boolean mIsAmPmAtLeft;
    private boolean mIsAmPmAtTop;
    private boolean mHourFormatShowLeadingZero;
    private boolean mHourFormatStartsAtZero;
    private CharSequence mLastAnnouncedText;
    private boolean mLastAnnouncedIsHour;
    private RadialTimePickerView.OnValueSelectedListener mOnValueSelectedListener;
    private TextInputTimePickerView.OnValueTypedListener mOnValueTypedListener;
    private NumericTextView.OnValueChangedListener mDigitEnteredListener;
    private Runnable mCommitHour;
    private Runnable mCommitMinute;
    private View.OnFocusChangeListener mFocusListener;
    private View.OnClickListener mClickListener;

    private void $$robo$$android_widget_TimePickerClockDelegate$__constructor__(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mRadialPickerModeEnabled = true;
        this.mIsEnabled = true;
        this.mIsAmPmAtLeft = false;
        this.mIsAmPmAtTop = false;
        this.mOnValueSelectedListener = new RadialTimePickerView.OnValueSelectedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_2$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_2$onValueSelected(int pickerType, int newValue, boolean autoAdvance) {
                boolean valueChanged = false;
                switch (pickerType) {
                    case 0: {
                        if (this.this$0.getHour() != newValue) {
                            valueChanged = true;
                        }
                        boolean isTransition = this.this$0.mAllowAutoAdvance && autoAdvance;
                        this.this$0.setHourInternal(newValue, 1, !isTransition, true);
                        if (!isTransition) break;
                        this.this$0.setCurrentItemShowing(1, true, false);
                        int localizedHour = this.this$0.getLocalizedHour(newValue);
                        this.this$0.mDelegator.announceForAccessibility(localizedHour + ". " + this.this$0.mSelectMinutes);
                        break;
                    }
                    case 1: {
                        if (this.this$0.getMinute() != newValue) {
                            valueChanged = true;
                        }
                        this.this$0.setMinuteInternal(newValue, 1, true);
                    }
                }
                if (this.this$0.mOnTimeChangedListener != null && valueChanged) {
                    this.this$0.mOnTimeChangedListener.onTimeChanged(this.this$0.mDelegator, this.this$0.getHour(), this.this$0.getMinute());
                }
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_2$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_2$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void onValueSelected(int n, int n2, boolean bl) {
                InvokeDynamicSupport.bootstrap("onValueSelected", $$robo$$android_widget_TimePickerClockDelegate_2$onValueSelected(int int boolean ), this, n, n2, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnValueTypedListener = new TextInputTimePickerView.OnValueTypedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_3$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_3$onValueChanged(int pickerType, int newValue) {
                switch (pickerType) {
                    case 0: {
                        this.this$0.setHourInternal(newValue, 2, false, true);
                        break;
                    }
                    case 1: {
                        this.this$0.setMinuteInternal(newValue, 2, true);
                        break;
                    }
                    case 2: {
                        this.this$0.setAmOrPm(newValue);
                    }
                }
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_3$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_3$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void onValueChanged(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onValueChanged", $$robo$$android_widget_TimePickerClockDelegate_3$onValueChanged(int int ), this, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDigitEnteredListener = new NumericTextView.OnValueChangedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_4$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_4$onValueChanged(NumericTextView view, int value, boolean isValid, boolean isFinished) {
                NumericTextView nextFocusTarget;
                Runnable commitCallback;
                if (view == this.this$0.mHourView) {
                    commitCallback = this.this$0.mCommitHour;
                    nextFocusTarget = view.isFocused() ? this.this$0.mMinuteView : null;
                } else if (view == this.this$0.mMinuteView) {
                    commitCallback = this.this$0.mCommitMinute;
                    nextFocusTarget = null;
                } else {
                    return;
                }
                view.removeCallbacks(commitCallback);
                if (isValid) {
                    if (isFinished) {
                        commitCallback.run();
                        if (nextFocusTarget != null) {
                            nextFocusTarget.requestFocus();
                        }
                    } else {
                        view.postDelayed(commitCallback, 2000L);
                    }
                }
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_4$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_4$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void onValueChanged(NumericTextView numericTextView, int n, boolean bl, boolean bl2) {
                InvokeDynamicSupport.bootstrap("onValueChanged", $$robo$$android_widget_TimePickerClockDelegate_4$onValueChanged(com.android.internal.widget.NumericTextView int boolean boolean ), this, numericTextView, n, bl, bl2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCommitHour = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_5$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_5$run() {
                this.this$0.setHour(this.this$0.mHourView.getValue());
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_5$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_5$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_TimePickerClockDelegate_5$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCommitMinute = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_6$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_6$run() {
                this.this$0.setMinute(this.this$0.mMinuteView.getValue());
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_6$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_6$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_TimePickerClockDelegate_6$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFocusListener = new View.OnFocusChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_7$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_7$onFocusChange(View v, boolean focused) {
                if (focused) {
                    switch (v.getId()) {
                        case 16908713: {
                            this.this$0.setAmOrPm(0);
                            break;
                        }
                        case 16909188: {
                            this.this$0.setAmOrPm(1);
                            break;
                        }
                        case 16908954: {
                            this.this$0.setCurrentItemShowing(0, true, true);
                            break;
                        }
                        case 16909071: {
                            this.this$0.setCurrentItemShowing(1, true, true);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.this$0.tryVibrate();
                }
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_7$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_7$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void onFocusChange(View view, boolean bl) {
                InvokeDynamicSupport.bootstrap("onFocusChange", $$robo$$android_widget_TimePickerClockDelegate_7$onFocusChange(android.view.View boolean ), this, view, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mClickListener = new View.OnClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_8$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_8$onClick(View v) {
                switch (v.getId()) {
                    case 16908713: {
                        this.this$0.setAmOrPm(0);
                        break;
                    }
                    case 16909188: {
                        this.this$0.setAmOrPm(1);
                        break;
                    }
                    case 16908954: {
                        this.this$0.setCurrentItemShowing(0, true, true);
                        break;
                    }
                    case 16909071: {
                        this.this$0.setCurrentItemShowing(1, true, true);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.this$0.tryVibrate();
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_8$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_8$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerClockDelegate_8$onClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources res = this.mContext.getResources();
        this.mSelectHours = res.getString(17040826);
        this.mSelectMinutes = res.getString(17040830);
        int layoutResourceId = a.getResourceId(12, 17367314);
        View mainView = inflater.inflate(layoutResourceId, (ViewGroup)delegator);
        mainView.setSaveFromParentEnabled(false);
        this.mRadialTimePickerHeader = mainView.findViewById(16909410);
        this.mRadialTimePickerHeader.setOnTouchListener(new NearestTouchDelegate(null));
        this.mHourView = (NumericTextView)mainView.findViewById(16908954);
        this.mHourView.setOnClickListener(this.mClickListener);
        this.mHourView.setOnFocusChangeListener(this.mFocusListener);
        this.mHourView.setOnDigitEnteredListener(this.mDigitEnteredListener);
        this.mHourView.setAccessibilityDelegate(new ClickActionDelegate(context, 17040826));
        this.mSeparatorView = (TextView)mainView.findViewById(16909282);
        this.mMinuteView = (NumericTextView)mainView.findViewById(16909071);
        this.mMinuteView.setOnClickListener(this.mClickListener);
        this.mMinuteView.setOnFocusChangeListener(this.mFocusListener);
        this.mMinuteView.setOnDigitEnteredListener(this.mDigitEnteredListener);
        this.mMinuteView.setAccessibilityDelegate(new ClickActionDelegate(context, 17040830));
        this.mMinuteView.setRange(0, 59);
        this.mAmPmLayout = mainView.findViewById(16908715);
        this.mAmPmLayout.setOnTouchListener(new NearestTouchDelegate(null));
        String[] amPmStrings = TimePicker.getAmPmStrings(context);
        this.mAmLabel = (RadioButton)this.mAmPmLayout.findViewById(16908713);
        this.mAmLabel.setText(TimePickerClockDelegate.obtainVerbatim(amPmStrings[0]));
        this.mAmLabel.setOnClickListener(this.mClickListener);
        TimePickerClockDelegate.ensureMinimumTextWidth(this.mAmLabel);
        this.mPmLabel = (RadioButton)this.mAmPmLayout.findViewById(16909188);
        this.mPmLabel.setText(TimePickerClockDelegate.obtainVerbatim(amPmStrings[1]));
        this.mPmLabel.setOnClickListener(this.mClickListener);
        TimePickerClockDelegate.ensureMinimumTextWidth(this.mPmLabel);
        ColorStateList headerTextColor = null;
        int timeHeaderTextAppearance = a.getResourceId(1, 0);
        if (timeHeaderTextAppearance != 0) {
            TypedArray textAppearance = this.mContext.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, timeHeaderTextAppearance);
            ColorStateList legacyHeaderTextColor = textAppearance.getColorStateList(0);
            headerTextColor = this.applyLegacyColorFixes(legacyHeaderTextColor);
            textAppearance.recycle();
        }
        if (headerTextColor == null) {
            headerTextColor = a.getColorStateList(11);
        }
        this.mTextInputPickerHeader = mainView.findViewById(16908982);
        if (headerTextColor != null) {
            this.mHourView.setTextColor(headerTextColor);
            this.mSeparatorView.setTextColor(headerTextColor);
            this.mMinuteView.setTextColor(headerTextColor);
            this.mAmLabel.setTextColor(headerTextColor);
            this.mPmLabel.setTextColor(headerTextColor);
        }
        if (a.hasValueOrEmpty(0)) {
            this.mRadialTimePickerHeader.setBackground(a.getDrawable(0));
            this.mTextInputPickerHeader.setBackground(a.getDrawable(0));
        }
        a.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)mainView.findViewById(16909213);
        this.mRadialTimePickerView.applyAttributes(attrs, defStyleAttr, defStyleRes);
        this.mRadialTimePickerView.setOnValueSelectedListener(this.mOnValueSelectedListener);
        this.mTextInputPickerView = (TextInputTimePickerView)mainView.findViewById(16908985);
        this.mTextInputPickerView.setListener(this.mOnValueTypedListener);
        this.mRadialTimePickerModeButton = (ImageButton)mainView.findViewById(16909426);
        this.mRadialTimePickerModeButton.setOnClickListener(new View.OnClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_1$__constructor__(TimePickerClockDelegate this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_1$onClick(View v) {
                this.this$0.toggleRadialPickerMode();
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_1$__constructor__(timePickerClockDelegate);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_1$__constructor__(android.widget.TimePickerClockDelegate ), this, timePickerClockDelegate);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerClockDelegate_1$onClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mRadialTimePickerModeEnabledDescription = context.getResources().getString(17040983);
        this.mTextInputPickerModeEnabledDescription = context.getResources().getString(17040984);
        this.mAllowAutoAdvance = true;
        this.updateHourFormat();
        this.mTempCalendar = Calendar.getInstance(this.mLocale);
        int currentHour = this.mTempCalendar.get(11);
        int currentMinute = this.mTempCalendar.get(12);
        this.initialize(currentHour, currentMinute, this.mIs24Hour, 0);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$toggleRadialPickerMode() {
        if (this.mRadialPickerModeEnabled) {
            this.mRadialTimePickerView.setVisibility(8);
            this.mRadialTimePickerHeader.setVisibility(8);
            this.mTextInputPickerHeader.setVisibility(0);
            this.mTextInputPickerView.setVisibility(0);
            this.mRadialTimePickerModeButton.setImageResource(17301787);
            this.mRadialTimePickerModeButton.setContentDescription(this.mRadialTimePickerModeEnabledDescription);
            this.mRadialPickerModeEnabled = false;
        } else {
            this.mRadialTimePickerView.setVisibility(0);
            this.mRadialTimePickerHeader.setVisibility(0);
            this.mTextInputPickerHeader.setVisibility(8);
            this.mTextInputPickerView.setVisibility(8);
            this.mRadialTimePickerModeButton.setImageResource(17301864);
            this.mRadialTimePickerModeButton.setContentDescription(this.mTextInputPickerModeEnabledDescription);
            this.updateTextInputPicker();
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            }
            this.mRadialPickerModeEnabled = true;
        }
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$validateInput() {
        return this.mTextInputPickerView.validateInput();
    }

    private static final void $$robo$$android_widget_TimePickerClockDelegate$ensureMinimumTextWidth(TextView v) {
        v.measure(0, 0);
        int minWidth = v.getMeasuredWidth();
        v.setMinWidth(minWidth);
        v.setMinimumWidth(minWidth);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateHourFormat() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, this.mIs24Hour ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        boolean showLeadingZero = false;
        int hourFormat = 0;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            hourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            showLeadingZero = true;
            break;
        }
        this.mHourFormatShowLeadingZero = showLeadingZero;
        this.mHourFormatStartsAtZero = hourFormat == 75 || hourFormat == 72;
        int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
        int maxHour = (this.mIs24Hour ? 23 : 11) + minHour;
        this.mHourView.setRange(minHour, maxHour);
        this.mHourView.setShowLeadingZeroes(this.mHourFormatShowLeadingZero);
        String[] digits = DecimalFormatSymbols.getInstance(this.mLocale).getDigitStrings();
        int maxCharLength = 0;
        for (int i = 0; i < 10; ++i) {
            maxCharLength = Math.max(maxCharLength, digits[i].length());
        }
        this.mTextInputPickerView.setHourFormat(maxCharLength * 2);
    }

    private static final CharSequence $$robo$$android_widget_TimePickerClockDelegate$obtainVerbatim(String text) {
        return new SpannableStringBuilder().append((CharSequence)text, new TtsSpan.VerbatimBuilder(text).build(), 0);
    }

    private final ColorStateList $$robo$$android_widget_TimePickerClockDelegate$applyLegacyColorFixes(ColorStateList color2) {
        int defaultColor;
        int activatedColor;
        if (color2 == null || color2.hasState(16843518)) {
            return color2;
        }
        if (color2.hasState(0x10100A1)) {
            activatedColor = color2.getColorForState(StateSet.get(10), 0);
            defaultColor = color2.getColorForState(StateSet.get(8), 0);
        } else {
            activatedColor = color2.getDefaultColor();
            TypedArray ta = this.mContext.obtainStyledAttributes(ATTRS_DISABLED_ALPHA);
            float disabledAlpha = ta.getFloat(0, 0.3f);
            defaultColor = this.multiplyAlphaComponent(activatedColor, disabledAlpha);
        }
        if (activatedColor == 0 || defaultColor == 0) {
            return null;
        }
        int[][] stateSet = new int[][]{{16843518}, new int[0]};
        int[] colors = new int[]{activatedColor, defaultColor};
        return new ColorStateList(stateSet, colors);
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$multiplyAlphaComponent(int color2, float alphaMod) {
        int srcRgb = color2 & 0xFFFFFF;
        int srcAlpha = color2 >> 24 & 0xFF;
        int dstAlpha = (int)((float)srcAlpha * alphaMod + 0.5f);
        return srcRgb | dstAlpha << 24;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$initialize(int hourOfDay, int minute, boolean is24HourView, int index) {
        this.mCurrentHour = hourOfDay;
        this.mCurrentMinute = minute;
        this.mIs24Hour = is24HourView;
        this.updateUI(index);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateUI(int index) {
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mCurrentHour, false);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mCurrentMinute, false);
        this.updateRadialPicker(index);
        this.updateTextInputPicker();
        this.mDelegator.invalidate();
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateTextInputPicker() {
        this.mTextInputPickerView.updateTextInputValues(this.getLocalizedHour(this.mCurrentHour), this.mCurrentMinute, this.mCurrentHour < 12 ? 0 : 1, this.mIs24Hour, this.mHourFormatStartsAtZero);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateRadialPicker(int index) {
        this.mRadialTimePickerView.initialize(this.mCurrentHour, this.mCurrentMinute, this.mIs24Hour);
        this.setCurrentItemShowing(index, false, true);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateHeaderAmPm() {
        if (this.mIs24Hour) {
            this.mAmPmLayout.setVisibility(8);
        } else {
            String dateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, "hm");
            boolean isAmPmAtStart = dateTimePattern.startsWith("a");
            this.setAmPmStart(isAmPmAtStart);
            this.updateAmPmLabelStates(this.mCurrentHour < 12 ? 0 : 1);
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setAmPmStart(boolean isAmPmAtStart) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mAmPmLayout.getLayoutParams();
        if (params.getRule(1) != 0 || params.getRule(0) != 0) {
            boolean isAmPmAtLeft;
            if (TextUtils.getLayoutDirectionFromLocale(this.mLocale) == 0) {
                isAmPmAtLeft = isAmPmAtStart;
            } else {
                boolean bl = isAmPmAtLeft = !isAmPmAtStart;
            }
            if (this.mIsAmPmAtLeft == isAmPmAtLeft) {
                return;
            }
            if (isAmPmAtLeft) {
                params.removeRule(1);
                params.addRule(0, this.mHourView.getId());
            } else {
                params.removeRule(0);
                params.addRule(1, this.mMinuteView.getId());
            }
            this.mIsAmPmAtLeft = isAmPmAtLeft;
        } else if (params.getRule(3) != 0 || params.getRule(2) != 0) {
            int otherViewId;
            if (this.mIsAmPmAtTop == isAmPmAtStart) {
                return;
            }
            if (isAmPmAtStart) {
                otherViewId = params.getRule(3);
                params.removeRule(3);
                params.addRule(2, otherViewId);
            } else {
                otherViewId = params.getRule(2);
                params.removeRule(2);
                params.addRule(3, otherViewId);
            }
            Object otherView = this.mRadialTimePickerHeader.findViewById(otherViewId);
            int top = ((View)otherView).getPaddingTop();
            int bottom = ((View)otherView).getPaddingBottom();
            int left = ((View)otherView).getPaddingLeft();
            int right = ((View)otherView).getPaddingRight();
            ((View)otherView).setPadding(left, bottom, right, top);
            this.mIsAmPmAtTop = isAmPmAtStart;
        }
        this.mAmPmLayout.setLayoutParams(params);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setDate(int hour, int minute) {
        this.setHourInternal(hour, 0, true, false);
        this.setMinuteInternal(minute, 0, false);
        this.onTimeChanged();
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setHour(int hour) {
        this.setHourInternal(hour, 0, true, true);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setHourInternal(int hour, int source, boolean announce, boolean notify) {
        if (this.mCurrentHour == hour) {
            return;
        }
        this.resetAutofilledValue();
        this.mCurrentHour = hour;
        this.updateHeaderHour(hour, announce);
        this.updateHeaderAmPm();
        if (source != 1) {
            this.mRadialTimePickerView.setCurrentHour(hour);
            this.mRadialTimePickerView.setAmOrPm(hour < 12 ? 0 : 1);
        }
        if (source != 2) {
            this.updateTextInputPicker();
        }
        this.mDelegator.invalidate();
        if (notify) {
            this.onTimeChanged();
        }
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$getHour() {
        int currentHour = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24Hour) {
            return currentHour;
        }
        if (this.mRadialTimePickerView.getAmOrPm() == 1) {
            return currentHour % 12 + 12;
        }
        return currentHour % 12;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setMinute(int minute) {
        this.setMinuteInternal(minute, 0, true);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setMinuteInternal(int minute, int source, boolean notify) {
        if (this.mCurrentMinute == minute) {
            return;
        }
        this.resetAutofilledValue();
        this.mCurrentMinute = minute;
        this.updateHeaderMinute(minute, true);
        if (source != 1) {
            this.mRadialTimePickerView.setCurrentMinute(minute);
        }
        if (source != 2) {
            this.updateTextInputPicker();
        }
        this.mDelegator.invalidate();
        if (notify) {
            this.onTimeChanged();
        }
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$getMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setIs24Hour(boolean is24Hour) {
        if (this.mIs24Hour != is24Hour) {
            this.mIs24Hour = is24Hour;
            this.mCurrentHour = this.getHour();
            this.updateHourFormat();
            this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
        }
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$is24Hour() {
        return this.mIs24Hour;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setEnabled(boolean enabled) {
        this.mHourView.setEnabled(enabled);
        this.mMinuteView.setEnabled(enabled);
        this.mAmLabel.setEnabled(enabled);
        this.mPmLabel.setEnabled(enabled);
        this.mRadialTimePickerView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$isEnabled() {
        return this.mIsEnabled;
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$getBaseline() {
        return -1;
    }

    private final Parcelable $$robo$$android_widget_TimePickerClockDelegate$onSaveInstanceState(Parcelable superState) {
        return new TimePicker.AbstractTimePickerDelegate.SavedState(superState, this.getHour(), this.getMinute(), this.is24Hour(), this.getCurrentItemShowing());
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onRestoreInstanceState(Parcelable state) {
        if (state instanceof TimePicker.AbstractTimePickerDelegate.SavedState) {
            TimePicker.AbstractTimePickerDelegate.SavedState ss = (TimePicker.AbstractTimePickerDelegate.SavedState)state;
            this.initialize(ss.getHour(), ss.getMinute(), ss.is24HourMode(), ss.getCurrentItemShowing());
            this.mRadialTimePickerView.invalidate();
        }
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24Hour ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getHour());
        this.mTempCalendar.set(12, this.getMinute());
        String selectedTime = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        String selectionMode = this.mRadialTimePickerView.getCurrentItemShowing() == 0 ? this.mSelectHours : this.mSelectMinutes;
        event.getText().add(selectedTime + " " + selectionMode);
    }

    private final View $$robo$$android_widget_TimePickerClockDelegate$getHourView() {
        return this.mHourView;
    }

    private final View $$robo$$android_widget_TimePickerClockDelegate$getMinuteView() {
        return this.mMinuteView;
    }

    private final View $$robo$$android_widget_TimePickerClockDelegate$getAmView() {
        return this.mAmLabel;
    }

    private final View $$robo$$android_widget_TimePickerClockDelegate$getPmView() {
        return this.mPmLabel;
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
        if (this.mAutoFillChangeListener != null) {
            this.mAutoFillChangeListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateAmPmLabelStates(int amOrPm) {
        boolean isAm = amOrPm == 0;
        this.mAmLabel.setActivated(isAm);
        this.mAmLabel.setChecked(isAm);
        boolean isPm = amOrPm == 1;
        this.mPmLabel.setActivated(isPm);
        this.mPmLabel.setChecked(isPm);
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$getLocalizedHour(int hourOfDay) {
        if (!this.mIs24Hour) {
            hourOfDay %= 12;
        }
        if (!this.mHourFormatStartsAtZero && hourOfDay == 0) {
            hourOfDay = this.mIs24Hour ? 24 : 12;
        }
        return hourOfDay;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateHeaderHour(int hourOfDay, boolean announce) {
        int localizedHour = this.getLocalizedHour(hourOfDay);
        this.mHourView.setValue(localizedHour);
        if (announce) {
            this.tryAnnounceForAccessibility(this.mHourView.getText(), true);
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateHeaderMinute(int minuteOfHour, boolean announce) {
        this.mMinuteView.setValue(minuteOfHour);
        if (announce) {
            this.tryAnnounceForAccessibility(this.mMinuteView.getText(), false);
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateHeaderSeparator() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, this.mIs24Hour ? "Hm" : "hm");
        String separatorText = TimePickerClockDelegate.getHourMinSeparatorFromPattern(bestDateTimePattern);
        this.mSeparatorView.setText(separatorText);
        this.mTextInputPickerView.updateSeparator(separatorText);
    }

    private static final String $$robo$$android_widget_TimePickerClockDelegate$getHourMinSeparatorFromPattern(String dateTimePattern) {
        String defaultSeparator = ":";
        boolean foundHourPattern = false;
        block5: for (int i = 0; i < dateTimePattern.length(); ++i) {
            switch (dateTimePattern.charAt(i)) {
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    foundHourPattern = true;
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                case '\'': {
                    if (!foundHourPattern) continue block5;
                    SpannableStringBuilder quotedSubstring = new SpannableStringBuilder(dateTimePattern.substring(i));
                    int quotedTextLength = DateFormat.appendQuotedText(quotedSubstring, 0);
                    return quotedSubstring.subSequence(0, quotedTextLength).toString();
                }
                default: {
                    if (!foundHourPattern) continue block5;
                    return Character.toString(dateTimePattern.charAt(i));
                }
            }
        }
        return ":";
    }

    private static final int $$robo$$android_widget_TimePickerClockDelegate$lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$tryAnnounceForAccessibility(CharSequence text, boolean isHour) {
        if (this.mLastAnnouncedIsHour != isHour || !text.equals(this.mLastAnnouncedText)) {
            this.mDelegator.announceForAccessibility(text);
            this.mLastAnnouncedText = text;
            this.mLastAnnouncedIsHour = isHour;
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setCurrentItemShowing(int index, boolean animateCircle, boolean announce) {
        this.mRadialTimePickerView.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            if (announce) {
                this.mDelegator.announceForAccessibility(this.mSelectHours);
            }
        } else if (announce) {
            this.mDelegator.announceForAccessibility(this.mSelectMinutes);
        }
        this.mHourView.setActivated(index == 0);
        this.mMinuteView.setActivated(index == 1);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setAmOrPm(int amOrPm) {
        this.updateAmPmLabelStates(amOrPm);
        if (this.mRadialTimePickerView.setAmOrPm(amOrPm)) {
            this.mCurrentHour = this.getHour();
            this.updateTextInputPicker();
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
            }
        }
    }

    static void __staticInitializer__() {
        ATTRS_TEXT_COLOR = new int[]{16842904};
        ATTRS_DISABLED_ALPHA = new int[]{0x1010033};
    }

    private void __constructor__(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TimePickerClockDelegate$__constructor__(timePicker, context, attributeSet, n, n2);
    }

    public TimePickerClockDelegate(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(timePicker, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate$__constructor__(android.widget.TimePicker android.content.Context android.util.AttributeSet int int ), this, timePicker, context, attributeSet, n, n2);
    }

    private void toggleRadialPickerMode() {
        InvokeDynamicSupport.bootstrap("toggleRadialPickerMode", $$robo$$android_widget_TimePickerClockDelegate$toggleRadialPickerMode(), this);
    }

    @Override
    public boolean validateInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("validateInput", $$robo$$android_widget_TimePickerClockDelegate$validateInput(), this);
    }

    private static void ensureMinimumTextWidth(TextView textView) {
        InvokeDynamicSupport.bootstrapStatic("ensureMinimumTextWidth", $$robo$$android_widget_TimePickerClockDelegate$ensureMinimumTextWidth(android.widget.TextView ), (TextView)textView);
    }

    private void updateHourFormat() {
        InvokeDynamicSupport.bootstrap("updateHourFormat", $$robo$$android_widget_TimePickerClockDelegate$updateHourFormat(), this);
    }

    static CharSequence obtainVerbatim(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("obtainVerbatim", $$robo$$android_widget_TimePickerClockDelegate$obtainVerbatim(java.lang.String ), (String)string2);
    }

    private ColorStateList applyLegacyColorFixes(ColorStateList colorStateList) {
        return InvokeDynamicSupport.bootstrap("applyLegacyColorFixes", $$robo$$android_widget_TimePickerClockDelegate$applyLegacyColorFixes(android.content.res.ColorStateList ), this, colorStateList);
    }

    private int multiplyAlphaComponent(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrap("multiplyAlphaComponent", $$robo$$android_widget_TimePickerClockDelegate$multiplyAlphaComponent(int float ), this, n, f);
    }

    private void initialize(int n, int n2, boolean bl, int n3) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_TimePickerClockDelegate$initialize(int int boolean int ), this, n, n2, bl, n3);
    }

    private void updateUI(int n) {
        InvokeDynamicSupport.bootstrap("updateUI", $$robo$$android_widget_TimePickerClockDelegate$updateUI(int ), this, n);
    }

    private void updateTextInputPicker() {
        InvokeDynamicSupport.bootstrap("updateTextInputPicker", $$robo$$android_widget_TimePickerClockDelegate$updateTextInputPicker(), this);
    }

    private void updateRadialPicker(int n) {
        InvokeDynamicSupport.bootstrap("updateRadialPicker", $$robo$$android_widget_TimePickerClockDelegate$updateRadialPicker(int ), this, n);
    }

    private void updateHeaderAmPm() {
        InvokeDynamicSupport.bootstrap("updateHeaderAmPm", $$robo$$android_widget_TimePickerClockDelegate$updateHeaderAmPm(), this);
    }

    private void setAmPmStart(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAmPmStart", $$robo$$android_widget_TimePickerClockDelegate$setAmPmStart(boolean ), this, bl);
    }

    @Override
    public void setDate(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_TimePickerClockDelegate$setDate(int int ), this, n, n2);
    }

    @Override
    public void setHour(int n) {
        InvokeDynamicSupport.bootstrap("setHour", $$robo$$android_widget_TimePickerClockDelegate$setHour(int ), this, n);
    }

    private void setHourInternal(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setHourInternal", $$robo$$android_widget_TimePickerClockDelegate$setHourInternal(int int boolean boolean ), this, n, n2, bl, bl2);
    }

    @Override
    public int getHour() {
        return (int)InvokeDynamicSupport.bootstrap("getHour", $$robo$$android_widget_TimePickerClockDelegate$getHour(), this);
    }

    @Override
    public void setMinute(int n) {
        InvokeDynamicSupport.bootstrap("setMinute", $$robo$$android_widget_TimePickerClockDelegate$setMinute(int ), this, n);
    }

    private void setMinuteInternal(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setMinuteInternal", $$robo$$android_widget_TimePickerClockDelegate$setMinuteInternal(int int boolean ), this, n, n2, bl);
    }

    @Override
    public int getMinute() {
        return (int)InvokeDynamicSupport.bootstrap("getMinute", $$robo$$android_widget_TimePickerClockDelegate$getMinute(), this);
    }

    @Override
    public void setIs24Hour(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIs24Hour", $$robo$$android_widget_TimePickerClockDelegate$setIs24Hour(boolean ), this, bl);
    }

    @Override
    public boolean is24Hour() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24Hour", $$robo$$android_widget_TimePickerClockDelegate$is24Hour(), this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TimePickerClockDelegate$setEnabled(boolean ), this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_TimePickerClockDelegate$isEnabled(), this);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_TimePickerClockDelegate$getBaseline(), this);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_TimePickerClockDelegate$onSaveInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_TimePickerClockDelegate$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerClockDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerClockDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public View getHourView() {
        return InvokeDynamicSupport.bootstrap("getHourView", $$robo$$android_widget_TimePickerClockDelegate$getHourView(), this);
    }

    @Override
    public View getMinuteView() {
        return InvokeDynamicSupport.bootstrap("getMinuteView", $$robo$$android_widget_TimePickerClockDelegate$getMinuteView(), this);
    }

    @Override
    public View getAmView() {
        return InvokeDynamicSupport.bootstrap("getAmView", $$robo$$android_widget_TimePickerClockDelegate$getAmView(), this);
    }

    @Override
    public View getPmView() {
        return InvokeDynamicSupport.bootstrap("getPmView", $$robo$$android_widget_TimePickerClockDelegate$getPmView(), this);
    }

    private int getCurrentItemShowing() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentItemShowing", $$robo$$android_widget_TimePickerClockDelegate$getCurrentItemShowing(), this);
    }

    private void onTimeChanged() {
        InvokeDynamicSupport.bootstrap("onTimeChanged", $$robo$$android_widget_TimePickerClockDelegate$onTimeChanged(), this);
    }

    private void tryVibrate() {
        InvokeDynamicSupport.bootstrap("tryVibrate", $$robo$$android_widget_TimePickerClockDelegate$tryVibrate(), this);
    }

    private void updateAmPmLabelStates(int n) {
        InvokeDynamicSupport.bootstrap("updateAmPmLabelStates", $$robo$$android_widget_TimePickerClockDelegate$updateAmPmLabelStates(int ), this, n);
    }

    private int getLocalizedHour(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLocalizedHour", $$robo$$android_widget_TimePickerClockDelegate$getLocalizedHour(int ), this, n);
    }

    private void updateHeaderHour(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateHeaderHour", $$robo$$android_widget_TimePickerClockDelegate$updateHeaderHour(int boolean ), this, n, bl);
    }

    private void updateHeaderMinute(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateHeaderMinute", $$robo$$android_widget_TimePickerClockDelegate$updateHeaderMinute(int boolean ), this, n, bl);
    }

    private void updateHeaderSeparator() {
        InvokeDynamicSupport.bootstrap("updateHeaderSeparator", $$robo$$android_widget_TimePickerClockDelegate$updateHeaderSeparator(), this);
    }

    private static String getHourMinSeparatorFromPattern(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getHourMinSeparatorFromPattern", $$robo$$android_widget_TimePickerClockDelegate$getHourMinSeparatorFromPattern(java.lang.String ), (String)string2);
    }

    private static int lastIndexOfAny(String string2, char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOfAny", $$robo$$android_widget_TimePickerClockDelegate$lastIndexOfAny(java.lang.String char[] ), (String)string2, (char[])cArray);
    }

    private void tryAnnounceForAccessibility(CharSequence charSequence, boolean bl) {
        InvokeDynamicSupport.bootstrap("tryAnnounceForAccessibility", $$robo$$android_widget_TimePickerClockDelegate$tryAnnounceForAccessibility(java.lang.CharSequence boolean ), this, charSequence, bl);
    }

    private void setCurrentItemShowing(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setCurrentItemShowing", $$robo$$android_widget_TimePickerClockDelegate$setCurrentItemShowing(int boolean boolean ), this, n, bl, bl2);
    }

    private void setAmOrPm(int n) {
        InvokeDynamicSupport.bootstrap("setAmOrPm", $$robo$$android_widget_TimePickerClockDelegate$setAmOrPm(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(TimePickerClockDelegate.class);
    }

    public /* synthetic */ TimePickerClockDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimePickerClockDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NearestTouchDelegate
    implements View.OnTouchListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private View mInitialTouchTarget;

        private void $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$__constructor__() {
        }

        private final boolean $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$onTouch(View view, MotionEvent motionEvent) {
            View child;
            int actionMasked = motionEvent.getActionMasked();
            if (actionMasked == 0) {
                this.mInitialTouchTarget = view instanceof ViewGroup ? this.findNearestChild((ViewGroup)view, (int)motionEvent.getX(), (int)motionEvent.getY()) : null;
            }
            if ((child = this.mInitialTouchTarget) == null) {
                return false;
            }
            float offsetX = view.getScrollX() - child.getLeft();
            float offsetY = view.getScrollY() - child.getTop();
            motionEvent.offsetLocation(offsetX, offsetY);
            boolean handled = child.dispatchTouchEvent(motionEvent);
            motionEvent.offsetLocation(-offsetX, -offsetY);
            if (actionMasked == 1 || actionMasked == 3) {
                this.mInitialTouchTarget = null;
            }
            return handled;
        }

        private final View $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$findNearestChild(ViewGroup v, int x, int y) {
            View bestChild = null;
            int bestDist = Integer.MAX_VALUE;
            int count = v.getChildCount();
            for (int i = 0; i < count; ++i) {
                int dY;
                View child = v.getChildAt(i);
                int dX = x - (child.getLeft() + child.getWidth() / 2);
                int dist = dX * dX + (dY = y - (child.getTop() + child.getHeight() / 2)) * dY;
                if (bestDist <= dist) continue;
                bestChild = child;
                bestDist = dist;
            }
            return bestChild;
        }

        private /* synthetic */ void $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$__constructor__();
        }

        public NearestTouchDelegate() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$__constructor__(), this);
        }

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$onTouch(android.view.View android.view.MotionEvent ), this, view, motionEvent);
        }

        private View findNearestChild(ViewGroup viewGroup, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("findNearestChild", $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$findNearestChild(android.view.ViewGroup int int ), this, viewGroup, n, n2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$__constructor__(var1_1);
        }

        public /* synthetic */ NearestTouchDelegate(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_NearestTouchDelegate$__constructor__(android.widget.TimePickerClockDelegate$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NearestTouchDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ClickActionDelegate
    extends View.AccessibilityDelegate
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AccessibilityNodeInfo.AccessibilityAction mClickAction;

        private void $$robo$$android_widget_TimePickerClockDelegate_ClickActionDelegate$__constructor__(Context context, int resId) {
            this.mClickAction = new AccessibilityNodeInfo.AccessibilityAction(16, context.getString(resId));
        }

        private final void $$robo$$android_widget_TimePickerClockDelegate_ClickActionDelegate$onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(this.mClickAction);
        }

        private void __constructor__(Context context, int n) {
            this.$$robo$$android_widget_TimePickerClockDelegate_ClickActionDelegate$__constructor__(context, n);
        }

        public ClickActionDelegate(Context context, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_ClickActionDelegate$__constructor__(android.content.Context int ), this, context, n);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_TimePickerClockDelegate_ClickActionDelegate$onInitializeAccessibilityNodeInfo(android.view.View android.view.accessibility.AccessibilityNodeInfo ), this, view, accessibilityNodeInfo);
        }

        public /* synthetic */ ClickActionDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClickActionDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ChangeSource {
    }
}

