/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SmartSelectSprite
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int EXPAND_DURATION = 300;
    private static int CORNER_DURATION = 50;
    private Interpolator mExpandInterpolator;
    private Interpolator mCornerInterpolator;
    private Animator mActiveAnimator;
    private Runnable mInvalidator;
    private int mFillColor;
    static Comparator<RectF> RECTANGLE_COMPARATOR;
    private Drawable mExistingDrawable;
    private RectangleList mExistingRectangleList;

    private void $$robo$$android_widget_SmartSelectSprite$__constructor__(Context context, int highlightColor, Runnable invalidator) {
        this.mActiveAnimator = null;
        this.mExistingDrawable = null;
        this.mExistingRectangleList = null;
        this.mExpandInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mCornerInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mFillColor = highlightColor;
        this.mInvalidator = Preconditions.checkNotNull(invalidator);
    }

    private final void $$robo$$android_widget_SmartSelectSprite$startAnimation(PointF start, List<RectangleWithTextSelectionLayout> destinationRectangles, Runnable onAnimationEnd) {
        this.cancelAnimation();
        ValueAnimator.AnimatorUpdateListener updateListener = valueAnimator -> this.mInvalidator.run();
        int rectangleCount = destinationRectangles.size();
        ArrayList<RoundedRectangleShape> shapes = new ArrayList<RoundedRectangleShape>(rectangleCount);
        ArrayList<Animator> cornerAnimators = new ArrayList<Animator>(rectangleCount);
        RectangleWithTextSelectionLayout centerRectangle = null;
        int startingOffset = 0;
        for (RectangleWithTextSelectionLayout rectangleWithTextSelectionLayout : destinationRectangles) {
            RectF rectangle = rectangleWithTextSelectionLayout.getRectangle();
            if (SmartSelectSprite.contains(rectangle, start)) {
                centerRectangle = rectangleWithTextSelectionLayout;
                break;
            }
            startingOffset = (int)((float)startingOffset + rectangle.width());
        }
        if (centerRectangle == null) {
            throw new IllegalArgumentException("Center point is not inside any of the rectangles!");
        }
        startingOffset = (int)((float)startingOffset + (start.x - centerRectangle.getRectangle().left));
        int[] expansionDirections = SmartSelectSprite.generateDirections(centerRectangle, destinationRectangles);
        for (int index = 0; index < rectangleCount; ++index) {
            RectangleWithTextSelectionLayout rectangleWithTextSelectionLayout = destinationRectangles.get(index);
            RectF rectangle = rectangleWithTextSelectionLayout.getRectangle();
            RoundedRectangleShape shape = new RoundedRectangleShape(rectangle, expansionDirections[index], rectangleWithTextSelectionLayout.getTextSelectionLayout() == 0, null);
            cornerAnimators.add(this.createCornerAnimator(shape, updateListener));
            shapes.add(shape);
        }
        RectangleList rectangleList = new RectangleList(shapes, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable(rectangleList);
        Paint paint = shapeDrawable.getPaint();
        paint.setColor(this.mFillColor);
        paint.setStyle(Paint.Style.FILL);
        this.mExistingRectangleList = rectangleList;
        this.mExistingDrawable = shapeDrawable;
        this.mActiveAnimator = this.createAnimator(rectangleList, startingOffset, startingOffset, cornerAnimators, updateListener, onAnimationEnd);
        this.mActiveAnimator.start();
    }

    private final boolean $$robo$$android_widget_SmartSelectSprite$isAnimationActive() {
        return this.mActiveAnimator != null && this.mActiveAnimator.isRunning();
    }

    private final Animator $$robo$$android_widget_SmartSelectSprite$createAnimator(RectangleList rectangleList, float startingOffsetLeft, float startingOffsetRight, List<Animator> cornerAnimators, ValueAnimator.AnimatorUpdateListener updateListener, Runnable onAnimationEnd) {
        ObjectAnimator rightBoundaryAnimator = ObjectAnimator.ofFloat((Object)rectangleList, "rightBoundary", startingOffsetRight, rectangleList.getTotalWidth());
        ObjectAnimator leftBoundaryAnimator = ObjectAnimator.ofFloat((Object)rectangleList, "leftBoundary", startingOffsetLeft, 0.0f);
        rightBoundaryAnimator.setDuration(300L);
        leftBoundaryAnimator.setDuration(300L);
        rightBoundaryAnimator.addUpdateListener(updateListener);
        leftBoundaryAnimator.addUpdateListener(updateListener);
        rightBoundaryAnimator.setInterpolator(this.mExpandInterpolator);
        leftBoundaryAnimator.setInterpolator(this.mExpandInterpolator);
        AnimatorSet cornerAnimator = new AnimatorSet();
        cornerAnimator.playTogether(cornerAnimators);
        AnimatorSet boundaryAnimator = new AnimatorSet();
        boundaryAnimator.playTogether(leftBoundaryAnimator, rightBoundaryAnimator);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(boundaryAnimator, cornerAnimator);
        this.setUpAnimatorListener(animatorSet, onAnimationEnd);
        return animatorSet;
    }

    private final void $$robo$$android_widget_SmartSelectSprite$setUpAnimatorListener(Animator animator2, Runnable onAnimationEnd) {
        animator2.addListener(new Animator.AnimatorListener(this, onAnimationEnd){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Runnable val$onAnimationEnd;
            /* synthetic */ SmartSelectSprite this$0;

            private void $$robo$$android_widget_SmartSelectSprite_1$__constructor__(SmartSelectSprite this$0, Runnable runnable) {
                this.this$0 = this$0;
                this.val$onAnimationEnd = runnable;
            }

            private final void $$robo$$android_widget_SmartSelectSprite_1$onAnimationStart(Animator animator2) {
            }

            private final void $$robo$$android_widget_SmartSelectSprite_1$onAnimationEnd(Animator animator2) {
                this.this$0.mExistingRectangleList.setDisplayType(1);
                this.this$0.mInvalidator.run();
                this.val$onAnimationEnd.run();
            }

            private final void $$robo$$android_widget_SmartSelectSprite_1$onAnimationCancel(Animator animator2) {
            }

            private final void $$robo$$android_widget_SmartSelectSprite_1$onAnimationRepeat(Animator animator2) {
            }

            private void __constructor__(SmartSelectSprite smartSelectSprite, Runnable runnable) {
                this.$$robo$$android_widget_SmartSelectSprite_1$__constructor__(smartSelectSprite, runnable);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite_1$__constructor__(android.widget.SmartSelectSprite java.lang.Runnable ), this, smartSelectSprite, runnable);
            }

            @Override
            public void onAnimationStart(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_widget_SmartSelectSprite_1$onAnimationStart(android.animation.Animator ), this, animator2);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_widget_SmartSelectSprite_1$onAnimationEnd(android.animation.Animator ), this, animator2);
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_widget_SmartSelectSprite_1$onAnimationCancel(android.animation.Animator ), this, animator2);
            }

            @Override
            public void onAnimationRepeat(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$android_widget_SmartSelectSprite_1$onAnimationRepeat(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final ObjectAnimator $$robo$$android_widget_SmartSelectSprite$createCornerAnimator(RoundedRectangleShape shape, ValueAnimator.AnimatorUpdateListener listener) {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)shape, "roundRatio", shape.getRoundRatio(), 0.0f);
        animator2.setDuration(50L);
        animator2.addUpdateListener(listener);
        animator2.setInterpolator(this.mCornerInterpolator);
        return animator2;
    }

    private static final int[] $$robo$$android_widget_SmartSelectSprite$generateDirections(RectangleWithTextSelectionLayout centerRectangle, List<RectangleWithTextSelectionLayout> rectangles) {
        int i;
        int[] result = new int[rectangles.size()];
        int centerRectangleIndex = rectangles.indexOf(centerRectangle);
        for (i = 0; i < centerRectangleIndex - 1; ++i) {
            result[i] = -1;
        }
        result[centerRectangleIndex] = rectangles.size() == 1 ? 0 : (centerRectangleIndex == 0 ? -1 : (centerRectangleIndex == rectangles.size() - 1 ? 1 : 0));
        for (i = centerRectangleIndex + 1; i < result.length; ++i) {
            result[i] = 1;
        }
        return result;
    }

    private static final boolean $$robo$$android_widget_SmartSelectSprite$contains(RectF rectangle, PointF point) {
        float x = point.x;
        float y = point.y;
        return x >= rectangle.left && x <= rectangle.right && y >= rectangle.top && y <= rectangle.bottom;
    }

    private final void $$robo$$android_widget_SmartSelectSprite$removeExistingDrawables() {
        this.mExistingDrawable = null;
        this.mExistingRectangleList = null;
        this.mInvalidator.run();
    }

    private final void $$robo$$android_widget_SmartSelectSprite$cancelAnimation() {
        if (this.mActiveAnimator != null) {
            this.mActiveAnimator.cancel();
            this.mActiveAnimator = null;
            this.removeExistingDrawables();
        }
    }

    private final void $$robo$$android_widget_SmartSelectSprite$draw(Canvas canvas) {
        if (this.mExistingDrawable != null) {
            this.mExistingDrawable.draw(canvas);
        }
    }

    static void __staticInitializer__() {
        RECTANGLE_COMPARATOR = Comparator.comparingDouble(e -> e.bottom).thenComparingDouble(e -> e.left);
    }

    private void __constructor__(Context context, int n, Runnable runnable) {
        this.$$robo$$android_widget_SmartSelectSprite$__constructor__(context, n, runnable);
    }

    public SmartSelectSprite(Context context, int n, Runnable runnable) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite$__constructor__(android.content.Context int java.lang.Runnable ), this, context, n, runnable);
    }

    public void startAnimation(PointF pointF, List<RectangleWithTextSelectionLayout> list, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$android_widget_SmartSelectSprite$startAnimation(android.graphics.PointF java.util.List<android.widget.SmartSelectSprite$RectangleWithTextSelectionLayout> java.lang.Runnable ), this, pointF, list, runnable);
    }

    public boolean isAnimationActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnimationActive", $$robo$$android_widget_SmartSelectSprite$isAnimationActive(), this);
    }

    private Animator createAnimator(RectangleList rectangleList, float f, float f2, List<Animator> list, ValueAnimator.AnimatorUpdateListener animatorUpdateListener, Runnable runnable) {
        return InvokeDynamicSupport.bootstrap("createAnimator", $$robo$$android_widget_SmartSelectSprite$createAnimator(android.widget.SmartSelectSprite$RectangleList float float java.util.List<android.animation.Animator> android.animation.ValueAnimator$AnimatorUpdateListener java.lang.Runnable ), this, rectangleList, f, f2, list, animatorUpdateListener, runnable);
    }

    private void setUpAnimatorListener(Animator animator2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("setUpAnimatorListener", $$robo$$android_widget_SmartSelectSprite$setUpAnimatorListener(android.animation.Animator java.lang.Runnable ), this, animator2, runnable);
    }

    private ObjectAnimator createCornerAnimator(RoundedRectangleShape roundedRectangleShape, ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        return InvokeDynamicSupport.bootstrap("createCornerAnimator", $$robo$$android_widget_SmartSelectSprite$createCornerAnimator(android.widget.SmartSelectSprite$RoundedRectangleShape android.animation.ValueAnimator$AnimatorUpdateListener ), this, roundedRectangleShape, animatorUpdateListener);
    }

    private static int[] generateDirections(RectangleWithTextSelectionLayout rectangleWithTextSelectionLayout, List<RectangleWithTextSelectionLayout> list) {
        return InvokeDynamicSupport.bootstrapStatic("generateDirections", $$robo$$android_widget_SmartSelectSprite$generateDirections(android.widget.SmartSelectSprite$RectangleWithTextSelectionLayout java.util.List<android.widget.SmartSelectSprite$RectangleWithTextSelectionLayout> ), (RectangleWithTextSelectionLayout)rectangleWithTextSelectionLayout, list);
    }

    private static boolean contains(RectF rectF, PointF pointF) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("contains", $$robo$$android_widget_SmartSelectSprite$contains(android.graphics.RectF android.graphics.PointF ), (RectF)rectF, (PointF)pointF);
    }

    private void removeExistingDrawables() {
        InvokeDynamicSupport.bootstrap("removeExistingDrawables", $$robo$$android_widget_SmartSelectSprite$removeExistingDrawables(), this);
    }

    public void cancelAnimation() {
        InvokeDynamicSupport.bootstrap("cancelAnimation", $$robo$$android_widget_SmartSelectSprite$cancelAnimation(), this);
    }

    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_SmartSelectSprite$draw(android.graphics.Canvas ), this, canvas);
    }

    static {
        RobolectricInternals.classInitializing(SmartSelectSprite.class);
    }

    public /* synthetic */ SmartSelectSprite() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmartSelectSprite)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RectangleList
    extends Shape
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String PROPERTY_RIGHT_BOUNDARY = "rightBoundary";
        private static String PROPERTY_LEFT_BOUNDARY = "leftBoundary";
        private List<RoundedRectangleShape> mRectangles;
        private List<RoundedRectangleShape> mReversedRectangles;
        private Path mOutlinePolygonPath;
        private int mDisplayType;

        private void $$robo$$android_widget_SmartSelectSprite_RectangleList$__constructor__(List<RoundedRectangleShape> rectangles) {
            this.mDisplayType = 0;
            this.mRectangles = new ArrayList<RoundedRectangleShape>(rectangles);
            this.mReversedRectangles = new ArrayList<RoundedRectangleShape>(rectangles);
            Collections.reverse(this.mReversedRectangles);
            this.mOutlinePolygonPath = RectangleList.generateOutlinePolygonPath(rectangles);
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RectangleList$setLeftBoundary(float leftBoundary) {
            float boundarySoFar = this.getTotalWidth();
            for (RoundedRectangleShape rectangle : this.mReversedRectangles) {
                float rectangleLeftBoundary = boundarySoFar - rectangle.getBoundingWidth();
                if (leftBoundary < rectangleLeftBoundary) {
                    rectangle.setStartBoundary(0.0f);
                } else if (leftBoundary > boundarySoFar) {
                    rectangle.setStartBoundary(rectangle.getBoundingWidth());
                } else {
                    rectangle.setStartBoundary(rectangle.getBoundingWidth() - boundarySoFar + leftBoundary);
                }
                boundarySoFar = rectangleLeftBoundary;
            }
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RectangleList$setRightBoundary(float rightBoundary) {
            float boundarySoFar = 0.0f;
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                float rectangleRightBoundary = rectangle.getBoundingWidth() + boundarySoFar;
                if (rectangleRightBoundary < rightBoundary) {
                    rectangle.setEndBoundary(rectangle.getBoundingWidth());
                } else if (boundarySoFar > rightBoundary) {
                    rectangle.setEndBoundary(0.0f);
                } else {
                    rectangle.setEndBoundary(rightBoundary - boundarySoFar);
                }
                boundarySoFar = rectangleRightBoundary;
            }
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RectangleList$setDisplayType(int displayType) {
            this.mDisplayType = displayType;
        }

        private final int $$robo$$android_widget_SmartSelectSprite_RectangleList$getTotalWidth() {
            int sum = 0;
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                sum = (int)((float)sum + rectangle.getBoundingWidth());
            }
            return sum;
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RectangleList$draw(Canvas canvas, Paint paint) {
            if (this.mDisplayType == 1) {
                this.drawPolygon(canvas, paint);
            } else {
                this.drawRectangles(canvas, paint);
            }
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RectangleList$drawRectangles(Canvas canvas, Paint paint) {
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                rectangle.draw(canvas, paint);
            }
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RectangleList$drawPolygon(Canvas canvas, Paint paint) {
            canvas.drawPath(this.mOutlinePolygonPath, paint);
        }

        private static final Path $$robo$$android_widget_SmartSelectSprite_RectangleList$generateOutlinePolygonPath(List<RoundedRectangleShape> rectangles) {
            Path path = new Path();
            for (RoundedRectangleShape shape : rectangles) {
                Path rectanglePath = new Path();
                rectanglePath.addRect(shape.mBoundingRectangle, Path.Direction.CW);
                path.op(rectanglePath, Path.Op.UNION);
            }
            return path;
        }

        private /* synthetic */ void $$robo$$android_widget_SmartSelectSprite_RectangleList$__constructor__(List x0, 1 x1) {
        }

        private void __constructor__(List<RoundedRectangleShape> list) {
            this.$$robo$$android_widget_SmartSelectSprite_RectangleList$__constructor__(list);
        }

        public RectangleList(List<RoundedRectangleShape> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite_RectangleList$__constructor__(java.util.List<android.widget.SmartSelectSprite$RoundedRectangleShape> ), this, list);
        }

        private void setLeftBoundary(float f) {
            InvokeDynamicSupport.bootstrap("setLeftBoundary", $$robo$$android_widget_SmartSelectSprite_RectangleList$setLeftBoundary(float ), this, f);
        }

        private void setRightBoundary(float f) {
            InvokeDynamicSupport.bootstrap("setRightBoundary", $$robo$$android_widget_SmartSelectSprite_RectangleList$setRightBoundary(float ), this, f);
        }

        void setDisplayType(int n) {
            InvokeDynamicSupport.bootstrap("setDisplayType", $$robo$$android_widget_SmartSelectSprite_RectangleList$setDisplayType(int ), this, n);
        }

        private int getTotalWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalWidth", $$robo$$android_widget_SmartSelectSprite_RectangleList$getTotalWidth(), this);
        }

        @Override
        public void draw(Canvas canvas, Paint paint) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_SmartSelectSprite_RectangleList$draw(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
        }

        private void drawRectangles(Canvas canvas, Paint paint) {
            InvokeDynamicSupport.bootstrap("drawRectangles", $$robo$$android_widget_SmartSelectSprite_RectangleList$drawRectangles(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
        }

        private void drawPolygon(Canvas canvas, Paint paint) {
            InvokeDynamicSupport.bootstrap("drawPolygon", $$robo$$android_widget_SmartSelectSprite_RectangleList$drawPolygon(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
        }

        private static Path generateOutlinePolygonPath(List<RoundedRectangleShape> list) {
            return InvokeDynamicSupport.bootstrapStatic("generateOutlinePolygonPath", $$robo$$android_widget_SmartSelectSprite_RectangleList$generateOutlinePolygonPath(java.util.List<android.widget.SmartSelectSprite$RoundedRectangleShape> ), list);
        }

        private /* synthetic */ void __constructor__(List list, 1 var2_2) {
            this.$$robo$$android_widget_SmartSelectSprite_RectangleList$__constructor__(list, var2_2);
        }

        public /* synthetic */ RectangleList(List list, 1 var2_2) {
            this(list);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite_RectangleList$__constructor__(java.util.List android.widget.SmartSelectSprite$1 ), this, list, var2_2);
        }

        public /* synthetic */ RectangleList() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RectangleList)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface DisplayType {
            public static final int RECTANGLES = 0;
            public static final int POLYGON = 1;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RoundedRectangleShape
    extends Shape
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String PROPERTY_ROUND_RATIO = "roundRatio";
        private RectF mBoundingRectangle;
        private float mRoundRatio;
        private int mExpansionDirection;
        private RectF mDrawRect;
        private Path mClipPath;
        private float mLeftBoundary;
        private float mRightBoundary;
        private boolean mInverted;
        private float mBoundingWidth;

        private static final int $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$invert(int expansionDirection) {
            return expansionDirection * -1;
        }

        private void $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$__constructor__(RectF boundingRectangle, int expansionDirection, boolean inverted) {
            this.mRoundRatio = 1.0f;
            this.mDrawRect = new RectF();
            this.mClipPath = new Path();
            this.mLeftBoundary = 0.0f;
            this.mRightBoundary = 0.0f;
            this.mBoundingRectangle = new RectF(boundingRectangle);
            this.mBoundingWidth = boundingRectangle.width();
            this.mInverted = inverted && expansionDirection != 0;
            this.mExpansionDirection = inverted ? RoundedRectangleShape.invert(expansionDirection) : expansionDirection;
            if (boundingRectangle.height() > boundingRectangle.width()) {
                this.setRoundRatio(0.0f);
            } else {
                this.setRoundRatio(1.0f);
            }
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$draw(Canvas canvas, Paint paint) {
            if (this.mLeftBoundary == this.mRightBoundary) {
                return;
            }
            float cornerRadius = this.getCornerRadius();
            float adjustedCornerRadius = this.getAdjustedCornerRadius();
            this.mDrawRect.set(this.mBoundingRectangle);
            this.mDrawRect.left = this.mBoundingRectangle.left + this.mLeftBoundary - cornerRadius / 2.0f;
            this.mDrawRect.right = this.mBoundingRectangle.left + this.mRightBoundary + cornerRadius / 2.0f;
            canvas.save();
            this.mClipPath.reset();
            this.mClipPath.addRoundRect(this.mDrawRect, adjustedCornerRadius, adjustedCornerRadius, Path.Direction.CW);
            canvas.clipPath(this.mClipPath);
            canvas.drawRect(this.mBoundingRectangle, paint);
            canvas.restore();
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$setRoundRatio(float roundRatio) {
            this.mRoundRatio = roundRatio;
        }

        private final float $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getRoundRatio() {
            return this.mRoundRatio;
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$setStartBoundary(float startBoundary) {
            if (this.mInverted) {
                this.mRightBoundary = this.mBoundingWidth - startBoundary;
            } else {
                this.mLeftBoundary = startBoundary;
            }
        }

        private final void $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$setEndBoundary(float endBoundary) {
            if (this.mInverted) {
                this.mLeftBoundary = this.mBoundingWidth - endBoundary;
            } else {
                this.mRightBoundary = endBoundary;
            }
        }

        private final float $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getCornerRadius() {
            return Math.min(this.mBoundingRectangle.width(), this.mBoundingRectangle.height());
        }

        private final float $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getAdjustedCornerRadius() {
            return this.getCornerRadius() * this.mRoundRatio;
        }

        private final float $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getBoundingWidth() {
            return (int)(this.mBoundingRectangle.width() + this.getCornerRadius());
        }

        private /* synthetic */ void $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$__constructor__(RectF x0, int x1, boolean x2, 1 x3) {
        }

        private static int invert(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("invert", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$invert(int ), (int)n);
        }

        private void __constructor__(RectF rectF, int n, boolean bl) {
            this.$$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$__constructor__(rectF, n, bl);
        }

        public RoundedRectangleShape(RectF rectF, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$__constructor__(android.graphics.RectF int boolean ), this, rectF, n, bl);
        }

        @Override
        public void draw(Canvas canvas, Paint paint) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$draw(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
        }

        void setRoundRatio(float f) {
            InvokeDynamicSupport.bootstrap("setRoundRatio", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$setRoundRatio(float ), this, f);
        }

        float getRoundRatio() {
            return (float)InvokeDynamicSupport.bootstrap("getRoundRatio", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getRoundRatio(), this);
        }

        private void setStartBoundary(float f) {
            InvokeDynamicSupport.bootstrap("setStartBoundary", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$setStartBoundary(float ), this, f);
        }

        private void setEndBoundary(float f) {
            InvokeDynamicSupport.bootstrap("setEndBoundary", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$setEndBoundary(float ), this, f);
        }

        private float getCornerRadius() {
            return (float)InvokeDynamicSupport.bootstrap("getCornerRadius", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getCornerRadius(), this);
        }

        private float getAdjustedCornerRadius() {
            return (float)InvokeDynamicSupport.bootstrap("getAdjustedCornerRadius", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getAdjustedCornerRadius(), this);
        }

        private float getBoundingWidth() {
            return (float)InvokeDynamicSupport.bootstrap("getBoundingWidth", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$getBoundingWidth(), this);
        }

        private /* synthetic */ void __constructor__(RectF rectF, int n, boolean bl, 1 var4_4) {
            this.$$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$__constructor__(rectF, n, bl, var4_4);
        }

        public /* synthetic */ RoundedRectangleShape(RectF rectF, int n, boolean bl, 1 var4_4) {
            this(rectF, n, bl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite_RoundedRectangleShape$__constructor__(android.graphics.RectF int boolean android.widget.SmartSelectSprite$1 ), this, rectF, n, bl, var4_4);
        }

        public /* synthetic */ RoundedRectangleShape() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RoundedRectangleShape)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface ExpansionDirection {
            public static final int LEFT = -1;
            public static final int CENTER = 0;
            public static final int RIGHT = 1;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RectangleWithTextSelectionLayout
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private RectF mRectangle;
        private int mTextSelectionLayout;

        private void $$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$__constructor__(RectF rectangle, int textSelectionLayout) {
            this.mRectangle = Preconditions.checkNotNull(rectangle);
            this.mTextSelectionLayout = textSelectionLayout;
        }

        private final RectF $$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$getRectangle() {
            return this.mRectangle;
        }

        private final int $$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$getTextSelectionLayout() {
            return this.mTextSelectionLayout;
        }

        private void __constructor__(RectF rectF, int n) {
            this.$$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$__constructor__(rectF, n);
        }

        public RectangleWithTextSelectionLayout(RectF rectF, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$__constructor__(android.graphics.RectF int ), this, rectF, n);
        }

        public RectF getRectangle() {
            return InvokeDynamicSupport.bootstrap("getRectangle", $$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$getRectangle(), this);
        }

        public int getTextSelectionLayout() {
            return (int)InvokeDynamicSupport.bootstrap("getTextSelectionLayout", $$robo$$android_widget_SmartSelectSprite_RectangleWithTextSelectionLayout$getTextSelectionLayout(), this);
        }

        public /* synthetic */ RectangleWithTextSelectionLayout() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RectangleWithTextSelectionLayout)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

