/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.IBinder;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.lang.ref.WeakReference;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PopupWindow
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static int INPUT_METHOD_NEEDED = 1;
    public static int INPUT_METHOD_NOT_NEEDED = 2;
    private static int DEFAULT_ANCHORED_GRAVITY = 0x800033;
    private static int ANIMATION_STYLE_DEFAULT = -1;
    private int[] mTmpDrawingLocation;
    private int[] mTmpScreenLocation;
    private int[] mTmpAppLocation;
    private Rect mTempRect;
    private Context mContext;
    private WindowManager mWindowManager;
    private WeakReference<View> mParentRootView;
    private boolean mIsShowing;
    private boolean mIsTransitioningToDismiss;
    private boolean mIsDropdown;
    private PopupDecorView mDecorView;
    private View mBackgroundView;
    private View mContentView;
    private boolean mFocusable;
    private int mInputMethodMode;
    private int mSoftInputMode;
    private boolean mTouchable;
    private boolean mOutsideTouchable;
    private boolean mClippingEnabled;
    private int mSplitTouchEnabled;
    private boolean mLayoutInScreen;
    private boolean mClipToScreen;
    private boolean mAllowScrollingAnchorParent;
    private boolean mLayoutInsetDecor;
    private boolean mNotTouchModal;
    private boolean mAttachedInDecor;
    private boolean mAttachedInDecorSet;
    private View.OnTouchListener mTouchInterceptor;
    private int mWidthMode;
    private int mWidth;
    private int mLastWidth;
    private int mHeightMode;
    private int mHeight;
    private int mLastHeight;
    private float mElevation;
    private Drawable mBackground;
    private Drawable mAboveAnchorBackgroundDrawable;
    private Drawable mBelowAnchorBackgroundDrawable;
    private Transition mEnterTransition;
    private Transition mExitTransition;
    private Rect mEpicenterBounds;
    private boolean mAboveAnchor;
    private int mWindowLayoutType;
    private OnDismissListener mOnDismissListener;
    private boolean mIgnoreCheekPress;
    private int mAnimationStyle;
    private int mGravity;
    private static int[] ABOVE_ANCHOR_STATE_SET;
    private View.OnAttachStateChangeListener mOnAnchorDetachedListener;
    private View.OnAttachStateChangeListener mOnAnchorRootDetachedListener;
    private WeakReference<View> mAnchor;
    private WeakReference<View> mAnchorRoot;
    private boolean mIsAnchorRootAttached;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private View.OnLayoutChangeListener mOnLayoutChangeListener;
    private int mAnchorXoff;
    private int mAnchorYoff;
    private int mAnchoredGravity;
    private boolean mOverlapAnchor;
    private boolean mPopupViewInitialLayoutDirectionInherited;

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int animStyle;
        this.mTmpDrawingLocation = new int[2];
        this.mTmpScreenLocation = new int[2];
        this.mTmpAppLocation = new int[2];
        this.mTempRect = new Rect();
        this.mInputMethodMode = 0;
        this.mSoftInputMode = 1;
        this.mTouchable = true;
        this.mOutsideTouchable = false;
        this.mClippingEnabled = true;
        this.mSplitTouchEnabled = -1;
        this.mAllowScrollingAnchorParent = true;
        this.mLayoutInsetDecor = false;
        this.mAttachedInDecor = true;
        this.mAttachedInDecorSet = false;
        this.mWidth = -2;
        this.mHeight = -2;
        this.mWindowLayoutType = 1000;
        this.mIgnoreCheekPress = false;
        this.mAnimationStyle = -1;
        this.mGravity = 0;
        this.mOnAnchorDetachedListener = new View.OnAttachStateChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PopupWindow this$0;

            private void $$robo$$android_widget_PopupWindow_1$__constructor__(PopupWindow this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_PopupWindow_1$onViewAttachedToWindow(View v) {
                this.this$0.alignToAnchor();
            }

            private final void $$robo$$android_widget_PopupWindow_1$onViewDetachedFromWindow(View v) {
            }

            private void __constructor__(PopupWindow popupWindow) {
                this.$$robo$$android_widget_PopupWindow_1$__constructor__(popupWindow);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_1$__constructor__(android.widget.PopupWindow ), this, popupWindow);
            }

            @Override
            public void onViewAttachedToWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_widget_PopupWindow_1$onViewAttachedToWindow(android.view.View ), this, view);
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_widget_PopupWindow_1$onViewDetachedFromWindow(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnAnchorRootDetachedListener = new View.OnAttachStateChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PopupWindow this$0;

            private void $$robo$$android_widget_PopupWindow_2$__constructor__(PopupWindow this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_PopupWindow_2$onViewAttachedToWindow(View v) {
            }

            private final void $$robo$$android_widget_PopupWindow_2$onViewDetachedFromWindow(View v) {
                this.this$0.mIsAnchorRootAttached = false;
            }

            private void __constructor__(PopupWindow popupWindow) {
                this.$$robo$$android_widget_PopupWindow_2$__constructor__(popupWindow);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_2$__constructor__(android.widget.PopupWindow ), this, popupWindow);
            }

            @Override
            public void onViewAttachedToWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_widget_PopupWindow_2$onViewAttachedToWindow(android.view.View ), this, view);
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_widget_PopupWindow_2$onViewDetachedFromWindow(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnScrollChangedListener = this::alignToAnchor;
        this.mOnLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.alignToAnchor();
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PopupWindow, defStyleAttr, defStyleRes);
        Drawable bg = a.getDrawable(0);
        this.mElevation = a.getDimension(3, 0.0f);
        this.mOverlapAnchor = a.getBoolean(2, false);
        this.mAnimationStyle = a.hasValueOrEmpty(1) ? ((animStyle = a.getResourceId(1, 0)) == 16974588 ? -1 : animStyle) : -1;
        Transition enterTransition = this.getTransition(a.getResourceId(4, 0));
        Object exitTransition = a.hasValueOrEmpty(5) ? this.getTransition(a.getResourceId(5, 0)) : (enterTransition == null ? null : enterTransition.clone());
        a.recycle();
        this.setEnterTransition(enterTransition);
        this.setExitTransition((Transition)exitTransition);
        this.setBackgroundDrawable(bg);
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__() {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(View contentView) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(int width, int height) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(View contentView, int width, int height) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(View contentView, int width, int height, boolean focusable) {
        this.mTmpDrawingLocation = new int[2];
        this.mTmpScreenLocation = new int[2];
        this.mTmpAppLocation = new int[2];
        this.mTempRect = new Rect();
        this.mInputMethodMode = 0;
        this.mSoftInputMode = 1;
        this.mTouchable = true;
        this.mOutsideTouchable = false;
        this.mClippingEnabled = true;
        this.mSplitTouchEnabled = -1;
        this.mAllowScrollingAnchorParent = true;
        this.mLayoutInsetDecor = false;
        this.mAttachedInDecor = true;
        this.mAttachedInDecorSet = false;
        this.mWidth = -2;
        this.mHeight = -2;
        this.mWindowLayoutType = 1000;
        this.mIgnoreCheekPress = false;
        this.mAnimationStyle = -1;
        this.mGravity = 0;
        this.mOnAnchorDetachedListener = new /* invalid duplicate definition of identical inner class */;
        this.mOnAnchorRootDetachedListener = new /* invalid duplicate definition of identical inner class */;
        this.mOnScrollChangedListener = this::alignToAnchor;
        this.mOnLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.alignToAnchor();
        if (contentView != null) {
            this.mContext = contentView.getContext();
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.setContentView(contentView);
        this.setWidth(width);
        this.setHeight(height);
        this.setFocusable(focusable);
    }

    private final void $$robo$$android_widget_PopupWindow$setEnterTransition(Transition enterTransition) {
        this.mEnterTransition = enterTransition;
    }

    private final Transition $$robo$$android_widget_PopupWindow$getEnterTransition() {
        return this.mEnterTransition;
    }

    private final void $$robo$$android_widget_PopupWindow$setExitTransition(Transition exitTransition) {
        this.mExitTransition = exitTransition;
    }

    private final Transition $$robo$$android_widget_PopupWindow$getExitTransition() {
        return this.mExitTransition;
    }

    private final void $$robo$$android_widget_PopupWindow$setEpicenterBounds(Rect bounds) {
        this.mEpicenterBounds = bounds;
    }

    private final Transition $$robo$$android_widget_PopupWindow$getTransition(int resId) {
        TransitionInflater inflater;
        Transition transition2;
        if (resId != 0 && resId != 0x10F0000 && (transition2 = (inflater = TransitionInflater.from(this.mContext)).inflateTransition(resId)) != null) {
            boolean isEmpty;
            boolean bl = isEmpty = transition2 instanceof TransitionSet && ((TransitionSet)transition2).getTransitionCount() == 0;
            if (!isEmpty) {
                return transition2;
            }
        }
        return null;
    }

    private final Drawable $$robo$$android_widget_PopupWindow$getBackground() {
        return this.mBackground;
    }

    private final void $$robo$$android_widget_PopupWindow$setBackgroundDrawable(Drawable background) {
        this.mBackground = background;
        if (this.mBackground instanceof StateListDrawable) {
            StateListDrawable stateList = (StateListDrawable)this.mBackground;
            int aboveAnchorStateIndex = stateList.getStateDrawableIndex(ABOVE_ANCHOR_STATE_SET);
            int count = stateList.getStateCount();
            int belowAnchorStateIndex = -1;
            for (int i = 0; i < count; ++i) {
                if (i == aboveAnchorStateIndex) continue;
                belowAnchorStateIndex = i;
                break;
            }
            if (aboveAnchorStateIndex != -1 && belowAnchorStateIndex != -1) {
                this.mAboveAnchorBackgroundDrawable = stateList.getStateDrawable(aboveAnchorStateIndex);
                this.mBelowAnchorBackgroundDrawable = stateList.getStateDrawable(belowAnchorStateIndex);
            } else {
                this.mBelowAnchorBackgroundDrawable = null;
                this.mAboveAnchorBackgroundDrawable = null;
            }
        }
    }

    private final float $$robo$$android_widget_PopupWindow$getElevation() {
        return this.mElevation;
    }

    private final void $$robo$$android_widget_PopupWindow$setElevation(float elevation) {
        this.mElevation = elevation;
    }

    private final int $$robo$$android_widget_PopupWindow$getAnimationStyle() {
        return this.mAnimationStyle;
    }

    private final void $$robo$$android_widget_PopupWindow$setIgnoreCheekPress() {
        this.mIgnoreCheekPress = true;
    }

    private final void $$robo$$android_widget_PopupWindow$setAnimationStyle(int animationStyle) {
        this.mAnimationStyle = animationStyle;
    }

    private final View $$robo$$android_widget_PopupWindow$getContentView() {
        return this.mContentView;
    }

    private final void $$robo$$android_widget_PopupWindow$setContentView(View contentView) {
        if (this.isShowing()) {
            return;
        }
        this.mContentView = contentView;
        if (this.mContext == null && this.mContentView != null) {
            this.mContext = this.mContentView.getContext();
        }
        if (this.mWindowManager == null && this.mContentView != null) {
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        if (this.mContext != null && !this.mAttachedInDecorSet) {
            this.setAttachedInDecor(this.mContext.getApplicationInfo().targetSdkVersion >= 22);
        }
    }

    private final void $$robo$$android_widget_PopupWindow$setTouchInterceptor(View.OnTouchListener l) {
        this.mTouchInterceptor = l;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isFocusable() {
        return this.mFocusable;
    }

    private final void $$robo$$android_widget_PopupWindow$setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    private final int $$robo$$android_widget_PopupWindow$getInputMethodMode() {
        return this.mInputMethodMode;
    }

    private final void $$robo$$android_widget_PopupWindow$setInputMethodMode(int mode) {
        this.mInputMethodMode = mode;
    }

    private final void $$robo$$android_widget_PopupWindow$setSoftInputMode(int mode) {
        this.mSoftInputMode = mode;
    }

    private final int $$robo$$android_widget_PopupWindow$getSoftInputMode() {
        return this.mSoftInputMode;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isTouchable() {
        return this.mTouchable;
    }

    private final void $$robo$$android_widget_PopupWindow$setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isOutsideTouchable() {
        return this.mOutsideTouchable;
    }

    private final void $$robo$$android_widget_PopupWindow$setOutsideTouchable(boolean touchable) {
        this.mOutsideTouchable = touchable;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isClippingEnabled() {
        return this.mClippingEnabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setClippingEnabled(boolean enabled) {
        this.mClippingEnabled = enabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setClipToScreenEnabled(boolean enabled) {
        this.mClipToScreen = enabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setAllowScrollingAnchorParent(boolean enabled) {
        this.mAllowScrollingAnchorParent = enabled;
    }

    private final boolean $$robo$$android_widget_PopupWindow$getAllowScrollingAnchorParent() {
        return this.mAllowScrollingAnchorParent;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isSplitTouchEnabled() {
        if (this.mSplitTouchEnabled < 0 && this.mContext != null) {
            return this.mContext.getApplicationInfo().targetSdkVersion >= 11;
        }
        return this.mSplitTouchEnabled == 1;
    }

    private final void $$robo$$android_widget_PopupWindow$setSplitTouchEnabled(boolean enabled) {
        this.mSplitTouchEnabled = enabled ? 1 : 0;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isLayoutInScreenEnabled() {
        return this.mLayoutInScreen;
    }

    private final void $$robo$$android_widget_PopupWindow$setLayoutInScreenEnabled(boolean enabled) {
        this.mLayoutInScreen = enabled;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isAttachedInDecor() {
        return this.mAttachedInDecor;
    }

    private final void $$robo$$android_widget_PopupWindow$setAttachedInDecor(boolean enabled) {
        this.mAttachedInDecor = enabled;
        this.mAttachedInDecorSet = true;
    }

    private final void $$robo$$android_widget_PopupWindow$setLayoutInsetDecor(boolean enabled) {
        this.mLayoutInsetDecor = enabled;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isLayoutInsetDecor() {
        return this.mLayoutInsetDecor;
    }

    private final void $$robo$$android_widget_PopupWindow$setWindowLayoutType(int layoutType) {
        this.mWindowLayoutType = layoutType;
    }

    private final int $$robo$$android_widget_PopupWindow$getWindowLayoutType() {
        return this.mWindowLayoutType;
    }

    private final void $$robo$$android_widget_PopupWindow$setTouchModal(boolean touchModal) {
        this.mNotTouchModal = !touchModal;
    }

    @Deprecated
    private final void $$robo$$android_widget_PopupWindow$setWindowLayoutMode(int widthSpec, int heightSpec) {
        this.mWidthMode = widthSpec;
        this.mHeightMode = heightSpec;
    }

    private final int $$robo$$android_widget_PopupWindow$getHeight() {
        return this.mHeight;
    }

    private final void $$robo$$android_widget_PopupWindow$setHeight(int height) {
        this.mHeight = height;
    }

    private final int $$robo$$android_widget_PopupWindow$getWidth() {
        return this.mWidth;
    }

    private final void $$robo$$android_widget_PopupWindow$setWidth(int width) {
        this.mWidth = width;
    }

    private final void $$robo$$android_widget_PopupWindow$setOverlapAnchor(boolean overlapAnchor) {
        this.mOverlapAnchor = overlapAnchor;
    }

    private final boolean $$robo$$android_widget_PopupWindow$getOverlapAnchor() {
        return this.mOverlapAnchor;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isShowing() {
        return this.mIsShowing;
    }

    private final void $$robo$$android_widget_PopupWindow$setShowing(boolean isShowing) {
        this.mIsShowing = isShowing;
    }

    private final void $$robo$$android_widget_PopupWindow$setDropDown(boolean isDropDown) {
        this.mIsDropdown = isDropDown;
    }

    private final void $$robo$$android_widget_PopupWindow$setTransitioningToDismiss(boolean transitioningToDismiss) {
        this.mIsTransitioningToDismiss = transitioningToDismiss;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isTransitioningToDismiss() {
        return this.mIsTransitioningToDismiss;
    }

    private final void $$robo$$android_widget_PopupWindow$showAtLocation(View parent, int gravity, int x, int y) {
        this.mParentRootView = new WeakReference<View>(parent.getRootView());
        this.showAtLocation(parent.getWindowToken(), gravity, x, y);
    }

    private final void $$robo$$android_widget_PopupWindow$showAtLocation(IBinder token, int gravity, int x, int y) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        TransitionManager.endTransitions(this.mDecorView);
        this.detachFromAnchor();
        this.mIsShowing = true;
        this.mIsDropdown = false;
        this.mGravity = gravity;
        WindowManager.LayoutParams p = this.createPopupLayoutParams(token);
        this.preparePopup(p);
        p.x = x;
        p.y = y;
        this.invokePopup(p);
    }

    private final void $$robo$$android_widget_PopupWindow$showAsDropDown(View anchor) {
        this.showAsDropDown(anchor, 0, 0);
    }

    private final void $$robo$$android_widget_PopupWindow$showAsDropDown(View anchor, int xoff, int yoff) {
        this.showAsDropDown(anchor, xoff, yoff, 0x800033);
    }

    private final void $$robo$$android_widget_PopupWindow$showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        if (this.isShowing() || !this.hasContentView()) {
            return;
        }
        TransitionManager.endTransitions(this.mDecorView);
        this.attachToAnchor(anchor, xoff, yoff, gravity);
        this.mIsShowing = true;
        this.mIsDropdown = true;
        WindowManager.LayoutParams p = this.createPopupLayoutParams(anchor.getApplicationWindowToken());
        this.preparePopup(p);
        boolean aboveAnchor = this.findDropDownPosition(anchor, p, xoff, yoff, p.width, p.height, gravity, this.mAllowScrollingAnchorParent);
        this.updateAboveAnchor(aboveAnchor);
        p.accessibilityIdOfAnchor = anchor != null ? (long)anchor.getAccessibilityViewId() : -1L;
        this.invokePopup(p);
    }

    private final void $$robo$$android_widget_PopupWindow$updateAboveAnchor(boolean aboveAnchor) {
        if (aboveAnchor != this.mAboveAnchor) {
            this.mAboveAnchor = aboveAnchor;
            if (this.mBackground != null && this.mBackgroundView != null) {
                if (this.mAboveAnchorBackgroundDrawable != null) {
                    if (this.mAboveAnchor) {
                        this.mBackgroundView.setBackground(this.mAboveAnchorBackgroundDrawable);
                    } else {
                        this.mBackgroundView.setBackground(this.mBelowAnchorBackgroundDrawable);
                    }
                } else {
                    this.mBackgroundView.refreshDrawableState();
                }
            }
        }
    }

    private final boolean $$robo$$android_widget_PopupWindow$isAboveAnchor() {
        return this.mAboveAnchor;
    }

    private final void $$robo$$android_widget_PopupWindow$preparePopup(WindowManager.LayoutParams p) {
        if (this.mContentView == null || this.mContext == null || this.mWindowManager == null) {
            throw new IllegalStateException("You must specify a valid content view by calling setContentView() before attempting to show the popup.");
        }
        if (p.accessibilityTitle == null) {
            p.accessibilityTitle = this.mContext.getString(17040718);
        }
        if (this.mDecorView != null) {
            this.mDecorView.cancelTransitions();
        }
        if (this.mBackground != null) {
            this.mBackgroundView = this.createBackgroundView(this.mContentView);
            this.mBackgroundView.setBackground(this.mBackground);
        } else {
            this.mBackgroundView = this.mContentView;
        }
        this.mDecorView = this.createDecorView(this.mBackgroundView);
        this.mDecorView.setIsRootNamespace(true);
        this.mBackgroundView.setElevation(this.mElevation);
        p.setSurfaceInsets(this.mBackgroundView, true, true);
        this.mPopupViewInitialLayoutDirectionInherited = this.mContentView.getRawLayoutDirection() == 2;
    }

    private final PopupBackgroundView $$robo$$android_widget_PopupWindow$createBackgroundView(View contentView) {
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        int height = layoutParams != null && layoutParams.height == -2 ? -2 : -1;
        PopupBackgroundView backgroundView = new PopupBackgroundView(this, this.mContext);
        FrameLayout.LayoutParams listParams = new FrameLayout.LayoutParams(-1, height);
        backgroundView.addView(contentView, listParams);
        return backgroundView;
    }

    private final PopupDecorView $$robo$$android_widget_PopupWindow$createDecorView(View contentView) {
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        int height = layoutParams != null && layoutParams.height == -2 ? -2 : -1;
        PopupDecorView decorView = new PopupDecorView(this, this.mContext);
        decorView.addView(contentView, -1, height);
        decorView.setClipChildren(false);
        decorView.setClipToPadding(false);
        return decorView;
    }

    private final void $$robo$$android_widget_PopupWindow$invokePopup(WindowManager.LayoutParams p) {
        if (this.mContext != null) {
            p.packageName = this.mContext.getPackageName();
        }
        PopupDecorView decorView = this.mDecorView;
        decorView.setFitsSystemWindows(this.mLayoutInsetDecor);
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.addView(decorView, p);
        if (this.mEnterTransition != null) {
            decorView.requestEnterTransition(this.mEnterTransition);
        }
    }

    private final void $$robo$$android_widget_PopupWindow$setLayoutDirectionFromAnchor() {
        View anchor;
        if (this.mAnchor != null && (anchor = (View)this.mAnchor.get()) != null && this.mPopupViewInitialLayoutDirectionInherited) {
            this.mDecorView.setLayoutDirection(anchor.getLayoutDirection());
        }
    }

    private final int $$robo$$android_widget_PopupWindow$computeGravity() {
        int gravity;
        int n = gravity = this.mGravity == 0 ? 0x800033 : this.mGravity;
        if (this.mIsDropdown && (this.mClipToScreen || this.mClippingEnabled)) {
            gravity |= 0x10000000;
        }
        return gravity;
    }

    private final WindowManager.LayoutParams $$robo$$android_widget_PopupWindow$createPopupLayoutParams(IBinder token) {
        WindowManager.LayoutParams p = new WindowManager.LayoutParams();
        p.gravity = this.computeGravity();
        p.flags = this.computeFlags(p.flags);
        p.type = this.mWindowLayoutType;
        p.token = token;
        p.softInputMode = this.mSoftInputMode;
        p.windowAnimations = this.computeAnimationResource();
        p.format = this.mBackground != null ? this.mBackground.getOpacity() : -3;
        p.height = this.mHeightMode < 0 ? (this.mLastHeight = this.mHeightMode) : (this.mLastHeight = this.mHeight);
        p.width = this.mWidthMode < 0 ? (this.mLastWidth = this.mWidthMode) : (this.mLastWidth = this.mWidth);
        p.privateFlags = 98304;
        p.setTitle("PopupWindow:" + Integer.toHexString(this.hashCode()));
        return p;
    }

    private final int $$robo$$android_widget_PopupWindow$computeFlags(int curFlags) {
        curFlags &= 0xFF797DE7;
        if (this.mIgnoreCheekPress) {
            curFlags |= 0x8000;
        }
        if (!this.mFocusable) {
            curFlags |= 8;
            if (this.mInputMethodMode == 1) {
                curFlags |= 0x20000;
            }
        } else if (this.mInputMethodMode == 2) {
            curFlags |= 0x20000;
        }
        if (!this.mTouchable) {
            curFlags |= 0x10;
        }
        if (this.mOutsideTouchable) {
            curFlags |= 0x40000;
        }
        if (!this.mClippingEnabled || this.mClipToScreen) {
            curFlags |= 0x200;
        }
        if (this.isSplitTouchEnabled()) {
            curFlags |= 0x800000;
        }
        if (this.mLayoutInScreen) {
            curFlags |= 0x100;
        }
        if (this.mLayoutInsetDecor) {
            curFlags |= 0x10000;
        }
        if (this.mNotTouchModal) {
            curFlags |= 0x20;
        }
        if (this.mAttachedInDecor) {
            curFlags |= 0x40000000;
        }
        return curFlags;
    }

    private final int $$robo$$android_widget_PopupWindow$computeAnimationResource() {
        if (this.mAnimationStyle == -1) {
            if (this.mIsDropdown) {
                return this.mAboveAnchor ? 16974576 : 16974575;
            }
            return 0;
        }
        return this.mAnimationStyle;
    }

    private final boolean $$robo$$android_widget_PopupWindow$findDropDownPosition(View anchor, WindowManager.LayoutParams outParams, int xOffset, int yOffset, int width, int height, int gravity, boolean allowScroll) {
        int anchorHeight = anchor.getHeight();
        int anchorWidth = anchor.getWidth();
        if (this.mOverlapAnchor) {
            yOffset -= anchorHeight;
        }
        int[] appScreenLocation = this.mTmpAppLocation;
        View appRootView = this.getAppRootView(anchor);
        appRootView.getLocationOnScreen(appScreenLocation);
        int[] screenLocation = this.mTmpScreenLocation;
        anchor.getLocationOnScreen(screenLocation);
        int[] drawingLocation = this.mTmpDrawingLocation;
        drawingLocation[0] = screenLocation[0] - appScreenLocation[0];
        drawingLocation[1] = screenLocation[1] - appScreenLocation[1];
        outParams.x = drawingLocation[0] + xOffset;
        outParams.y = drawingLocation[1] + anchorHeight + yOffset;
        Rect displayFrame = new Rect();
        appRootView.getWindowVisibleDisplayFrame(displayFrame);
        if (width == -1) {
            width = displayFrame.right - displayFrame.left;
        }
        if (height == -1) {
            height = displayFrame.bottom - displayFrame.top;
        }
        outParams.gravity = this.computeGravity();
        outParams.width = width;
        outParams.height = height;
        int hgrav = Gravity.getAbsoluteGravity(gravity, anchor.getLayoutDirection()) & 7;
        if (hgrav == 5) {
            outParams.x -= width - anchorWidth;
        }
        boolean fitsVertical = this.tryFitVertical(outParams, yOffset, height, anchorHeight, drawingLocation[1], screenLocation[1], displayFrame.top, displayFrame.bottom, false);
        boolean fitsHorizontal = this.tryFitHorizontal(outParams, xOffset, width, anchorWidth, drawingLocation[0], screenLocation[0], displayFrame.left, displayFrame.right, false);
        if (!fitsVertical || !fitsHorizontal) {
            int scrollX = anchor.getScrollX();
            int scrollY = anchor.getScrollY();
            Rect r = new Rect(scrollX, scrollY, scrollX + width + xOffset, scrollY + height + anchorHeight + yOffset);
            if (allowScroll && anchor.requestRectangleOnScreen(r, true)) {
                anchor.getLocationOnScreen(screenLocation);
                drawingLocation[0] = screenLocation[0] - appScreenLocation[0];
                drawingLocation[1] = screenLocation[1] - appScreenLocation[1];
                outParams.x = drawingLocation[0] + xOffset;
                outParams.y = drawingLocation[1] + anchorHeight + yOffset;
                if (hgrav == 5) {
                    outParams.x -= width - anchorWidth;
                }
            }
            this.tryFitVertical(outParams, yOffset, height, anchorHeight, drawingLocation[1], screenLocation[1], displayFrame.top, displayFrame.bottom, this.mClipToScreen);
            this.tryFitHorizontal(outParams, xOffset, width, anchorWidth, drawingLocation[0], screenLocation[0], displayFrame.left, displayFrame.right, this.mClipToScreen);
        }
        return outParams.y < drawingLocation[1];
    }

    private final boolean $$robo$$android_widget_PopupWindow$tryFitVertical(WindowManager.LayoutParams outParams, int yOffset, int height, int anchorHeight, int drawingLocationY, int screenLocationY, int displayFrameTop, int displayFrameBottom, boolean allowResize) {
        int winOffsetY = screenLocationY - drawingLocationY;
        int anchorTopInScreen = outParams.y + winOffsetY;
        int spaceBelow = displayFrameBottom - anchorTopInScreen;
        if (anchorTopInScreen >= 0 && height <= spaceBelow) {
            return true;
        }
        int spaceAbove = anchorTopInScreen - anchorHeight - displayFrameTop;
        if (height <= spaceAbove) {
            if (this.mOverlapAnchor) {
                yOffset += anchorHeight;
            }
            outParams.y = drawingLocationY - height + yOffset;
            return true;
        }
        return this.positionInDisplayVertical(outParams, height, drawingLocationY, screenLocationY, displayFrameTop, displayFrameBottom, allowResize);
    }

    private final boolean $$robo$$android_widget_PopupWindow$positionInDisplayVertical(WindowManager.LayoutParams outParams, int height, int drawingLocationY, int screenLocationY, int displayFrameTop, int displayFrameBottom, boolean canResize) {
        boolean fitsInDisplay = true;
        int winOffsetY = screenLocationY - drawingLocationY;
        outParams.y += winOffsetY;
        outParams.height = height;
        int bottom = outParams.y + height;
        if (bottom > displayFrameBottom) {
            outParams.y -= bottom - displayFrameBottom;
        }
        if (outParams.y < displayFrameTop) {
            outParams.y = displayFrameTop;
            int displayFrameHeight = displayFrameBottom - displayFrameTop;
            if (canResize && height > displayFrameHeight) {
                outParams.height = displayFrameHeight;
            } else {
                fitsInDisplay = false;
            }
        }
        outParams.y -= winOffsetY;
        return fitsInDisplay;
    }

    private final boolean $$robo$$android_widget_PopupWindow$tryFitHorizontal(WindowManager.LayoutParams outParams, int xOffset, int width, int anchorWidth, int drawingLocationX, int screenLocationX, int displayFrameLeft, int displayFrameRight, boolean allowResize) {
        int winOffsetX = screenLocationX - drawingLocationX;
        int anchorLeftInScreen = outParams.x + winOffsetX;
        int spaceRight = displayFrameRight - anchorLeftInScreen;
        if (anchorLeftInScreen >= 0 && width <= spaceRight) {
            return true;
        }
        return this.positionInDisplayHorizontal(outParams, width, drawingLocationX, screenLocationX, displayFrameLeft, displayFrameRight, allowResize);
    }

    private final boolean $$robo$$android_widget_PopupWindow$positionInDisplayHorizontal(WindowManager.LayoutParams outParams, int width, int drawingLocationX, int screenLocationX, int displayFrameLeft, int displayFrameRight, boolean canResize) {
        boolean fitsInDisplay = true;
        int winOffsetX = screenLocationX - drawingLocationX;
        outParams.x += winOffsetX;
        int right = outParams.x + width;
        if (right > displayFrameRight) {
            outParams.x -= right - displayFrameRight;
        }
        if (outParams.x < displayFrameLeft) {
            outParams.x = displayFrameLeft;
            int displayFrameWidth = displayFrameRight - displayFrameLeft;
            if (canResize && width > displayFrameWidth) {
                outParams.width = displayFrameWidth;
            } else {
                fitsInDisplay = false;
            }
        }
        outParams.x -= winOffsetX;
        return fitsInDisplay;
    }

    private final int $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(View anchor) {
        return this.getMaxAvailableHeight(anchor, 0);
    }

    private final int $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(View anchor, int yOffset) {
        return this.getMaxAvailableHeight(anchor, yOffset, false);
    }

    private final int $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(View anchor, int yOffset, boolean ignoreBottomDecorations) {
        Rect displayFrame = null;
        Rect visibleDisplayFrame = new Rect();
        View appView = this.getAppRootView(anchor);
        appView.getWindowVisibleDisplayFrame(visibleDisplayFrame);
        if (ignoreBottomDecorations) {
            displayFrame = new Rect();
            anchor.getWindowDisplayFrame(displayFrame);
            displayFrame.top = visibleDisplayFrame.top;
            displayFrame.right = visibleDisplayFrame.right;
            displayFrame.left = visibleDisplayFrame.left;
        } else {
            displayFrame = visibleDisplayFrame;
        }
        int[] anchorPos = this.mTmpDrawingLocation;
        anchor.getLocationOnScreen(anchorPos);
        int bottomEdge = displayFrame.bottom;
        int distanceToBottom = this.mOverlapAnchor ? bottomEdge - anchorPos[1] - yOffset : bottomEdge - (anchorPos[1] + anchor.getHeight()) - yOffset;
        int distanceToTop = anchorPos[1] - displayFrame.top + yOffset;
        int returnedHeight = Math.max(distanceToBottom, distanceToTop);
        if (this.mBackground != null) {
            this.mBackground.getPadding(this.mTempRect);
            returnedHeight -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return returnedHeight;
    }

    private final void $$robo$$android_widget_PopupWindow$dismiss() {
        if (!this.isShowing() || this.isTransitioningToDismiss()) {
            return;
        }
        PopupDecorView decorView = this.mDecorView;
        View contentView = this.mContentView;
        ViewParent contentParent = contentView.getParent();
        ViewGroup contentHolder = contentParent instanceof ViewGroup ? (ViewGroup)contentParent : null;
        decorView.cancelTransitions();
        this.mIsShowing = false;
        this.mIsTransitioningToDismiss = true;
        Transition exitTransition = this.mExitTransition;
        if (exitTransition != null && decorView.isLaidOut() && (this.mIsAnchorRootAttached || this.mAnchorRoot == null)) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)decorView.getLayoutParams();
            p.flags |= 0x10;
            p.flags |= 8;
            p.flags &= 0xFFFDFFFF;
            this.mWindowManager.updateViewLayout(decorView, p);
            View anchorRoot = this.mAnchorRoot != null ? (View)this.mAnchorRoot.get() : null;
            Rect epicenter = this.getTransitionEpicenter();
            decorView.startExitTransition(exitTransition, anchorRoot, epicenter, (Transition.TransitionListener)new ShadowedObject(this, decorView, contentHolder, contentView){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PopupDecorView val$decorView;
                /* synthetic */ ViewGroup val$contentHolder;
                /* synthetic */ View val$contentView;
                /* synthetic */ PopupWindow this$0;

                private void $$robo$$android_widget_PopupWindow_3$__constructor__(PopupWindow this$0, PopupDecorView popupDecorView, ViewGroup viewGroup, View view) {
                    this.this$0 = this$0;
                    this.val$decorView = popupDecorView;
                    this.val$contentHolder = viewGroup;
                    this.val$contentView = view;
                }

                private final void $$robo$$android_widget_PopupWindow_3$onTransitionEnd(Transition transition2) {
                    this.this$0.dismissImmediate(this.val$decorView, this.val$contentHolder, this.val$contentView);
                }

                private void __constructor__(PopupWindow popupWindow, PopupDecorView popupDecorView, ViewGroup viewGroup, View view) {
                    this.$$robo$$android_widget_PopupWindow_3$__constructor__(popupWindow, popupDecorView, viewGroup, view);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_3$__constructor__(android.widget.PopupWindow android.widget.PopupWindow$PopupDecorView android.view.ViewGroup android.view.View ), this, popupWindow, popupDecorView, viewGroup, view);
                }

                @Override
                public void onTransitionEnd(Transition transition2) {
                    InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_widget_PopupWindow_3$onTransitionEnd(android.transition.Transition ), this, transition2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        } else {
            this.dismissImmediate(decorView, contentHolder, contentView);
        }
        this.detachFromAnchor();
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    private final Rect $$robo$$android_widget_PopupWindow$getTransitionEpicenter() {
        View anchor = this.mAnchor != null ? (View)this.mAnchor.get() : null;
        PopupDecorView decor = this.mDecorView;
        if (anchor == null || decor == null) {
            return null;
        }
        int[] anchorLocation = anchor.getLocationOnScreen();
        int[] popupLocation = this.mDecorView.getLocationOnScreen();
        Rect bounds = new Rect(0, 0, anchor.getWidth(), anchor.getHeight());
        bounds.offset(anchorLocation[0] - popupLocation[0], anchorLocation[1] - popupLocation[1]);
        if (this.mEpicenterBounds != null) {
            int offsetX = bounds.left;
            int offsetY = bounds.top;
            bounds.set(this.mEpicenterBounds);
            bounds.offset(offsetX, offsetY);
        }
        return bounds;
    }

    private final void $$robo$$android_widget_PopupWindow$dismissImmediate(View decorView, ViewGroup contentHolder, View contentView) {
        if (decorView.getParent() != null) {
            this.mWindowManager.removeViewImmediate(decorView);
        }
        if (contentHolder != null) {
            contentHolder.removeView(contentView);
        }
        this.mDecorView = null;
        this.mBackgroundView = null;
        this.mIsTransitioningToDismiss = false;
    }

    private final void $$robo$$android_widget_PopupWindow$setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private final OnDismissListener $$robo$$android_widget_PopupWindow$getOnDismissListener() {
        return this.mOnDismissListener;
    }

    private final void $$robo$$android_widget_PopupWindow$update() {
        int newGravity;
        int newFlags;
        if (!this.isShowing() || !this.hasContentView()) {
            return;
        }
        WindowManager.LayoutParams p = this.getDecorViewLayoutParams();
        boolean update = false;
        int newAnim = this.computeAnimationResource();
        if (newAnim != p.windowAnimations) {
            p.windowAnimations = newAnim;
            update = true;
        }
        if ((newFlags = this.computeFlags(p.flags)) != p.flags) {
            p.flags = newFlags;
            update = true;
        }
        if ((newGravity = this.computeGravity()) != p.gravity) {
            p.gravity = newGravity;
            update = true;
        }
        if (update) {
            this.update(this.mAnchor != null ? (View)this.mAnchor.get() : null, p);
        }
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, WindowManager.LayoutParams params) {
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.updateViewLayout(this.mDecorView, params);
    }

    private final void $$robo$$android_widget_PopupWindow$update(int width, int height) {
        WindowManager.LayoutParams p = this.getDecorViewLayoutParams();
        this.update(p.x, p.y, width, height, false);
    }

    private final void $$robo$$android_widget_PopupWindow$update(int x, int y, int width, int height) {
        this.update(x, y, width, height, false);
    }

    private final void $$robo$$android_widget_PopupWindow$update(int x, int y, int width, int height, boolean force) {
        int newGravity;
        int newFlags;
        int newAnim;
        int finalHeight;
        int finalWidth;
        if (width >= 0) {
            this.mLastWidth = width;
            this.setWidth(width);
        }
        if (height >= 0) {
            this.mLastHeight = height;
            this.setHeight(height);
        }
        if (!this.isShowing() || !this.hasContentView()) {
            return;
        }
        WindowManager.LayoutParams p = this.getDecorViewLayoutParams();
        boolean update = force;
        int n = finalWidth = this.mWidthMode < 0 ? this.mWidthMode : this.mLastWidth;
        if (width != -1 && p.width != finalWidth) {
            p.width = this.mLastWidth = finalWidth;
            update = true;
        }
        int n2 = finalHeight = this.mHeightMode < 0 ? this.mHeightMode : this.mLastHeight;
        if (height != -1 && p.height != finalHeight) {
            p.height = this.mLastHeight = finalHeight;
            update = true;
        }
        if (p.x != x) {
            p.x = x;
            update = true;
        }
        if (p.y != y) {
            p.y = y;
            update = true;
        }
        if ((newAnim = this.computeAnimationResource()) != p.windowAnimations) {
            p.windowAnimations = newAnim;
            update = true;
        }
        if ((newFlags = this.computeFlags(p.flags)) != p.flags) {
            p.flags = newFlags;
            update = true;
        }
        if ((newGravity = this.computeGravity()) != p.gravity) {
            p.gravity = newGravity;
            update = true;
        }
        View anchor = null;
        int newAccessibilityIdOfAnchor = -1;
        if (this.mAnchor != null && this.mAnchor.get() != null) {
            anchor = (View)this.mAnchor.get();
            newAccessibilityIdOfAnchor = anchor.getAccessibilityViewId();
        }
        if ((long)newAccessibilityIdOfAnchor != p.accessibilityIdOfAnchor) {
            p.accessibilityIdOfAnchor = newAccessibilityIdOfAnchor;
            update = true;
        }
        if (update) {
            this.update(anchor, p);
        }
    }

    private final boolean $$robo$$android_widget_PopupWindow$hasContentView() {
        return this.mContentView != null;
    }

    private final boolean $$robo$$android_widget_PopupWindow$hasDecorView() {
        return this.mDecorView != null;
    }

    private final WindowManager.LayoutParams $$robo$$android_widget_PopupWindow$getDecorViewLayoutParams() {
        return (WindowManager.LayoutParams)this.mDecorView.getLayoutParams();
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, int width, int height) {
        this.update(anchor, false, 0, 0, width, height);
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, int xoff, int yoff, int width, int height) {
        this.update(anchor, true, xoff, yoff, width, height);
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, boolean updateLocation, int xoff, int yoff, int width, int height) {
        boolean needsUpdate;
        if (!this.isShowing() || !this.hasContentView()) {
            return;
        }
        WeakReference<View> oldAnchor = this.mAnchor;
        int gravity = this.mAnchoredGravity;
        boolean bl = needsUpdate = updateLocation && (this.mAnchorXoff != xoff || this.mAnchorYoff != yoff);
        if (oldAnchor == null || oldAnchor.get() != anchor || needsUpdate && !this.mIsDropdown) {
            this.attachToAnchor(anchor, xoff, yoff, gravity);
        } else if (needsUpdate) {
            this.mAnchorXoff = xoff;
            this.mAnchorYoff = yoff;
        }
        WindowManager.LayoutParams p = this.getDecorViewLayoutParams();
        int oldGravity = p.gravity;
        int oldWidth = p.width;
        int oldHeight = p.height;
        int oldX = p.x;
        int oldY = p.y;
        if (width < 0) {
            width = this.mWidth;
        }
        if (height < 0) {
            height = this.mHeight;
        }
        boolean aboveAnchor = this.findDropDownPosition(anchor, p, this.mAnchorXoff, this.mAnchorYoff, width, height, gravity, this.mAllowScrollingAnchorParent);
        this.updateAboveAnchor(aboveAnchor);
        boolean paramsChanged = oldGravity != p.gravity || oldX != p.x || oldY != p.y || oldWidth != p.width || oldHeight != p.height;
        int newWidth = width < 0 ? width : p.width;
        int newHeight = height < 0 ? height : p.height;
        this.update(p.x, p.y, newWidth, newHeight, paramsChanged);
    }

    private final void $$robo$$android_widget_PopupWindow$detachFromAnchor() {
        View anchorRoot;
        View anchor = this.getAnchor();
        if (anchor != null) {
            ViewTreeObserver vto = anchor.getViewTreeObserver();
            vto.removeOnScrollChangedListener(this.mOnScrollChangedListener);
            anchor.removeOnAttachStateChangeListener(this.mOnAnchorDetachedListener);
        }
        View view = anchorRoot = this.mAnchorRoot != null ? (View)this.mAnchorRoot.get() : null;
        if (anchorRoot != null) {
            anchorRoot.removeOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
            anchorRoot.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        }
        this.mAnchor = null;
        this.mAnchorRoot = null;
        this.mIsAnchorRootAttached = false;
    }

    private final void $$robo$$android_widget_PopupWindow$attachToAnchor(View anchor, int xoff, int yoff, int gravity) {
        this.detachFromAnchor();
        ViewTreeObserver vto = anchor.getViewTreeObserver();
        if (vto != null) {
            vto.addOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        anchor.addOnAttachStateChangeListener(this.mOnAnchorDetachedListener);
        View anchorRoot = anchor.getRootView();
        anchorRoot.addOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
        anchorRoot.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        this.mAnchor = new WeakReference<View>(anchor);
        this.mAnchorRoot = new WeakReference<View>(anchorRoot);
        this.mIsAnchorRootAttached = anchorRoot.isAttachedToWindow();
        this.mParentRootView = this.mAnchorRoot;
        this.mAnchorXoff = xoff;
        this.mAnchorYoff = yoff;
        this.mAnchoredGravity = gravity;
    }

    private final View $$robo$$android_widget_PopupWindow$getAnchor() {
        return this.mAnchor != null ? (View)this.mAnchor.get() : null;
    }

    private final void $$robo$$android_widget_PopupWindow$alignToAnchor() {
        View anchor;
        View view = anchor = this.mAnchor != null ? (View)this.mAnchor.get() : null;
        if (anchor != null && anchor.isAttachedToWindow() && this.hasDecorView()) {
            WindowManager.LayoutParams p = this.getDecorViewLayoutParams();
            this.updateAboveAnchor(this.findDropDownPosition(anchor, p, this.mAnchorXoff, this.mAnchorYoff, p.width, p.height, this.mAnchoredGravity, false));
            this.update(p.x, p.y, -1, -1, true);
        }
    }

    private final View $$robo$$android_widget_PopupWindow$getAppRootView(View anchor) {
        View appWindowView = WindowManagerGlobal.getInstance().getWindowView(anchor.getApplicationWindowToken());
        if (appWindowView != null) {
            return appWindowView;
        }
        return anchor.getRootView();
    }

    static void __staticInitializer__() {
        ABOVE_ANCHOR_STATE_SET = new int[]{0x10100AA};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context);
    }

    public PopupWindow(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context, attributeSet);
    }

    public PopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842870);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context, attributeSet, n);
    }

    public PopupWindow(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context, attributeSet, n, n2);
    }

    public PopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__() {
        this.$$robo$$android_widget_PopupWindow$__constructor__();
    }

    public PopupWindow() {
        this(null, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(), this);
    }

    private void __constructor__(View view) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(view);
    }

    public PopupWindow(View view) {
        this(view, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.view.View ), this, view);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(n, n2);
    }

    public PopupWindow(int n, int n2) {
        this(null, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(int int ), this, n, n2);
    }

    private void __constructor__(View view, int n, int n2) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(view, n, n2);
    }

    public PopupWindow(View view, int n, int n2) {
        this(view, n, n2, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.view.View int int ), this, view, n, n2);
    }

    private void __constructor__(View view, int n, int n2, boolean bl) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(view, n, n2, bl);
    }

    public PopupWindow(View view, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.view.View int int boolean ), this, view, n, n2, bl);
    }

    public void setEnterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setEnterTransition", $$robo$$android_widget_PopupWindow$setEnterTransition(android.transition.Transition ), this, transition2);
    }

    public Transition getEnterTransition() {
        return InvokeDynamicSupport.bootstrap("getEnterTransition", $$robo$$android_widget_PopupWindow$getEnterTransition(), this);
    }

    public void setExitTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setExitTransition", $$robo$$android_widget_PopupWindow$setExitTransition(android.transition.Transition ), this, transition2);
    }

    public Transition getExitTransition() {
        return InvokeDynamicSupport.bootstrap("getExitTransition", $$robo$$android_widget_PopupWindow$getExitTransition(), this);
    }

    public void setEpicenterBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("setEpicenterBounds", $$robo$$android_widget_PopupWindow$setEpicenterBounds(android.graphics.Rect ), this, rect);
    }

    private Transition getTransition(int n) {
        return InvokeDynamicSupport.bootstrap("getTransition", $$robo$$android_widget_PopupWindow$getTransition(int ), this, n);
    }

    public Drawable getBackground() {
        return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_widget_PopupWindow$getBackground(), this);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_widget_PopupWindow$setBackgroundDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public float getElevation() {
        return (float)InvokeDynamicSupport.bootstrap("getElevation", $$robo$$android_widget_PopupWindow$getElevation(), this);
    }

    public void setElevation(float f) {
        InvokeDynamicSupport.bootstrap("setElevation", $$robo$$android_widget_PopupWindow$setElevation(float ), this, f);
    }

    public int getAnimationStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getAnimationStyle", $$robo$$android_widget_PopupWindow$getAnimationStyle(), this);
    }

    public void setIgnoreCheekPress() {
        InvokeDynamicSupport.bootstrap("setIgnoreCheekPress", $$robo$$android_widget_PopupWindow$setIgnoreCheekPress(), this);
    }

    public void setAnimationStyle(int n) {
        InvokeDynamicSupport.bootstrap("setAnimationStyle", $$robo$$android_widget_PopupWindow$setAnimationStyle(int ), this, n);
    }

    public View getContentView() {
        return InvokeDynamicSupport.bootstrap("getContentView", $$robo$$android_widget_PopupWindow$getContentView(), this);
    }

    public void setContentView(View view) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_widget_PopupWindow$setContentView(android.view.View ), this, view);
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        InvokeDynamicSupport.bootstrap("setTouchInterceptor", $$robo$$android_widget_PopupWindow$setTouchInterceptor(android.view.View$OnTouchListener ), this, onTouchListener);
    }

    public boolean isFocusable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFocusable", $$robo$$android_widget_PopupWindow$isFocusable(), this);
    }

    public void setFocusable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFocusable", $$robo$$android_widget_PopupWindow$setFocusable(boolean ), this, bl);
    }

    public int getInputMethodMode() {
        return (int)InvokeDynamicSupport.bootstrap("getInputMethodMode", $$robo$$android_widget_PopupWindow$getInputMethodMode(), this);
    }

    public void setInputMethodMode(int n) {
        InvokeDynamicSupport.bootstrap("setInputMethodMode", $$robo$$android_widget_PopupWindow$setInputMethodMode(int ), this, n);
    }

    public void setSoftInputMode(int n) {
        InvokeDynamicSupport.bootstrap("setSoftInputMode", $$robo$$android_widget_PopupWindow$setSoftInputMode(int ), this, n);
    }

    public int getSoftInputMode() {
        return (int)InvokeDynamicSupport.bootstrap("getSoftInputMode", $$robo$$android_widget_PopupWindow$getSoftInputMode(), this);
    }

    public boolean isTouchable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchable", $$robo$$android_widget_PopupWindow$isTouchable(), this);
    }

    public void setTouchable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTouchable", $$robo$$android_widget_PopupWindow$setTouchable(boolean ), this, bl);
    }

    public boolean isOutsideTouchable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutsideTouchable", $$robo$$android_widget_PopupWindow$isOutsideTouchable(), this);
    }

    public void setOutsideTouchable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOutsideTouchable", $$robo$$android_widget_PopupWindow$setOutsideTouchable(boolean ), this, bl);
    }

    public boolean isClippingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClippingEnabled", $$robo$$android_widget_PopupWindow$isClippingEnabled(), this);
    }

    public void setClippingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClippingEnabled", $$robo$$android_widget_PopupWindow$setClippingEnabled(boolean ), this, bl);
    }

    public void setClipToScreenEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClipToScreenEnabled", $$robo$$android_widget_PopupWindow$setClipToScreenEnabled(boolean ), this, bl);
    }

    void setAllowScrollingAnchorParent(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowScrollingAnchorParent", $$robo$$android_widget_PopupWindow$setAllowScrollingAnchorParent(boolean ), this, bl);
    }

    protected boolean getAllowScrollingAnchorParent() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowScrollingAnchorParent", $$robo$$android_widget_PopupWindow$getAllowScrollingAnchorParent(), this);
    }

    public boolean isSplitTouchEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSplitTouchEnabled", $$robo$$android_widget_PopupWindow$isSplitTouchEnabled(), this);
    }

    public void setSplitTouchEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitTouchEnabled", $$robo$$android_widget_PopupWindow$setSplitTouchEnabled(boolean ), this, bl);
    }

    public boolean isLayoutInScreenEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutInScreenEnabled", $$robo$$android_widget_PopupWindow$isLayoutInScreenEnabled(), this);
    }

    public void setLayoutInScreenEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLayoutInScreenEnabled", $$robo$$android_widget_PopupWindow$setLayoutInScreenEnabled(boolean ), this, bl);
    }

    public boolean isAttachedInDecor() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAttachedInDecor", $$robo$$android_widget_PopupWindow$isAttachedInDecor(), this);
    }

    public void setAttachedInDecor(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAttachedInDecor", $$robo$$android_widget_PopupWindow$setAttachedInDecor(boolean ), this, bl);
    }

    public void setLayoutInsetDecor(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLayoutInsetDecor", $$robo$$android_widget_PopupWindow$setLayoutInsetDecor(boolean ), this, bl);
    }

    protected boolean isLayoutInsetDecor() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutInsetDecor", $$robo$$android_widget_PopupWindow$isLayoutInsetDecor(), this);
    }

    public void setWindowLayoutType(int n) {
        InvokeDynamicSupport.bootstrap("setWindowLayoutType", $$robo$$android_widget_PopupWindow$setWindowLayoutType(int ), this, n);
    }

    public int getWindowLayoutType() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowLayoutType", $$robo$$android_widget_PopupWindow$getWindowLayoutType(), this);
    }

    public void setTouchModal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTouchModal", $$robo$$android_widget_PopupWindow$setTouchModal(boolean ), this, bl);
    }

    @Deprecated
    public void setWindowLayoutMode(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setWindowLayoutMode", $$robo$$android_widget_PopupWindow$setWindowLayoutMode(int int ), this, n, n2);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_widget_PopupWindow$getHeight(), this);
    }

    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_widget_PopupWindow$setHeight(int ), this, n);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_widget_PopupWindow$getWidth(), this);
    }

    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_widget_PopupWindow$setWidth(int ), this, n);
    }

    public void setOverlapAnchor(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOverlapAnchor", $$robo$$android_widget_PopupWindow$setOverlapAnchor(boolean ), this, bl);
    }

    public boolean getOverlapAnchor() {
        return (boolean)InvokeDynamicSupport.bootstrap("getOverlapAnchor", $$robo$$android_widget_PopupWindow$getOverlapAnchor(), this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_PopupWindow$isShowing(), this);
    }

    protected void setShowing(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowing", $$robo$$android_widget_PopupWindow$setShowing(boolean ), this, bl);
    }

    protected void setDropDown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDropDown", $$robo$$android_widget_PopupWindow$setDropDown(boolean ), this, bl);
    }

    protected void setTransitioningToDismiss(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTransitioningToDismiss", $$robo$$android_widget_PopupWindow$setTransitioningToDismiss(boolean ), this, bl);
    }

    protected boolean isTransitioningToDismiss() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitioningToDismiss", $$robo$$android_widget_PopupWindow$isTransitioningToDismiss(), this);
    }

    public void showAtLocation(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("showAtLocation", $$robo$$android_widget_PopupWindow$showAtLocation(android.view.View int int int ), this, view, n, n2, n3);
    }

    public void showAtLocation(IBinder iBinder, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("showAtLocation", $$robo$$android_widget_PopupWindow$showAtLocation(android.os.IBinder int int int ), this, iBinder, n, n2, n3);
    }

    public void showAsDropDown(View view) {
        InvokeDynamicSupport.bootstrap("showAsDropDown", $$robo$$android_widget_PopupWindow$showAsDropDown(android.view.View ), this, view);
    }

    public void showAsDropDown(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("showAsDropDown", $$robo$$android_widget_PopupWindow$showAsDropDown(android.view.View int int ), this, view, n, n2);
    }

    public void showAsDropDown(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("showAsDropDown", $$robo$$android_widget_PopupWindow$showAsDropDown(android.view.View int int int ), this, view, n, n2, n3);
    }

    protected void updateAboveAnchor(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateAboveAnchor", $$robo$$android_widget_PopupWindow$updateAboveAnchor(boolean ), this, bl);
    }

    public boolean isAboveAnchor() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAboveAnchor", $$robo$$android_widget_PopupWindow$isAboveAnchor(), this);
    }

    private void preparePopup(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("preparePopup", $$robo$$android_widget_PopupWindow$preparePopup(android.view.WindowManager$LayoutParams ), this, layoutParams);
    }

    private PopupBackgroundView createBackgroundView(View view) {
        return InvokeDynamicSupport.bootstrap("createBackgroundView", $$robo$$android_widget_PopupWindow$createBackgroundView(android.view.View ), this, view);
    }

    private PopupDecorView createDecorView(View view) {
        return InvokeDynamicSupport.bootstrap("createDecorView", $$robo$$android_widget_PopupWindow$createDecorView(android.view.View ), this, view);
    }

    private void invokePopup(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("invokePopup", $$robo$$android_widget_PopupWindow$invokePopup(android.view.WindowManager$LayoutParams ), this, layoutParams);
    }

    private void setLayoutDirectionFromAnchor() {
        InvokeDynamicSupport.bootstrap("setLayoutDirectionFromAnchor", $$robo$$android_widget_PopupWindow$setLayoutDirectionFromAnchor(), this);
    }

    private int computeGravity() {
        return (int)InvokeDynamicSupport.bootstrap("computeGravity", $$robo$$android_widget_PopupWindow$computeGravity(), this);
    }

    protected WindowManager.LayoutParams createPopupLayoutParams(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("createPopupLayoutParams", $$robo$$android_widget_PopupWindow$createPopupLayoutParams(android.os.IBinder ), this, iBinder);
    }

    private int computeFlags(int n) {
        return (int)InvokeDynamicSupport.bootstrap("computeFlags", $$robo$$android_widget_PopupWindow$computeFlags(int ), this, n);
    }

    private int computeAnimationResource() {
        return (int)InvokeDynamicSupport.bootstrap("computeAnimationResource", $$robo$$android_widget_PopupWindow$computeAnimationResource(), this);
    }

    protected boolean findDropDownPosition(View view, WindowManager.LayoutParams layoutParams, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("findDropDownPosition", $$robo$$android_widget_PopupWindow$findDropDownPosition(android.view.View android.view.WindowManager$LayoutParams int int int int int boolean ), this, view, layoutParams, n, n2, n3, n4, n5, bl);
    }

    private boolean tryFitVertical(WindowManager.LayoutParams layoutParams, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("tryFitVertical", $$robo$$android_widget_PopupWindow$tryFitVertical(android.view.WindowManager$LayoutParams int int int int int int int boolean ), this, layoutParams, n, n2, n3, n4, n5, n6, n7, bl);
    }

    private boolean positionInDisplayVertical(WindowManager.LayoutParams layoutParams, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("positionInDisplayVertical", $$robo$$android_widget_PopupWindow$positionInDisplayVertical(android.view.WindowManager$LayoutParams int int int int int boolean ), this, layoutParams, n, n2, n3, n4, n5, bl);
    }

    private boolean tryFitHorizontal(WindowManager.LayoutParams layoutParams, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("tryFitHorizontal", $$robo$$android_widget_PopupWindow$tryFitHorizontal(android.view.WindowManager$LayoutParams int int int int int int int boolean ), this, layoutParams, n, n2, n3, n4, n5, n6, n7, bl);
    }

    private boolean positionInDisplayHorizontal(WindowManager.LayoutParams layoutParams, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("positionInDisplayHorizontal", $$robo$$android_widget_PopupWindow$positionInDisplayHorizontal(android.view.WindowManager$LayoutParams int int int int int boolean ), this, layoutParams, n, n2, n3, n4, n5, bl);
    }

    public int getMaxAvailableHeight(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAvailableHeight", $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(android.view.View ), this, view);
    }

    public int getMaxAvailableHeight(View view, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAvailableHeight", $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(android.view.View int ), this, view, n);
    }

    public int getMaxAvailableHeight(View view, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAvailableHeight", $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(android.view.View int boolean ), this, view, n, bl);
    }

    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_PopupWindow$dismiss(), this);
    }

    protected Rect getTransitionEpicenter() {
        return InvokeDynamicSupport.bootstrap("getTransitionEpicenter", $$robo$$android_widget_PopupWindow$getTransitionEpicenter(), this);
    }

    private void dismissImmediate(View view, ViewGroup viewGroup, View view2) {
        InvokeDynamicSupport.bootstrap("dismissImmediate", $$robo$$android_widget_PopupWindow$dismissImmediate(android.view.View android.view.ViewGroup android.view.View ), this, view, viewGroup, view2);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_widget_PopupWindow$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), this, onDismissListener);
    }

    protected OnDismissListener getOnDismissListener() {
        return InvokeDynamicSupport.bootstrap("getOnDismissListener", $$robo$$android_widget_PopupWindow$getOnDismissListener(), this);
    }

    public void update() {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(), this);
    }

    protected void update(View view, WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View android.view.WindowManager$LayoutParams ), this, view, layoutParams);
    }

    public void update(int n, int n2) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(int int ), this, n, n2);
    }

    public void update(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(int int int int ), this, n, n2, n3, n4);
    }

    public void update(int n, int n2, int n3, int n4, boolean bl) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(int int int int boolean ), this, n, n2, n3, n4, bl);
    }

    protected boolean hasContentView() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasContentView", $$robo$$android_widget_PopupWindow$hasContentView(), this);
    }

    protected boolean hasDecorView() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDecorView", $$robo$$android_widget_PopupWindow$hasDecorView(), this);
    }

    protected WindowManager.LayoutParams getDecorViewLayoutParams() {
        return InvokeDynamicSupport.bootstrap("getDecorViewLayoutParams", $$robo$$android_widget_PopupWindow$getDecorViewLayoutParams(), this);
    }

    public void update(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View int int ), this, view, n, n2);
    }

    public void update(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View int int int int ), this, view, n, n2, n3, n4);
    }

    private void update(View view, boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View boolean int int int int ), this, view, bl, n, n2, n3, n4);
    }

    protected void detachFromAnchor() {
        InvokeDynamicSupport.bootstrap("detachFromAnchor", $$robo$$android_widget_PopupWindow$detachFromAnchor(), this);
    }

    protected void attachToAnchor(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("attachToAnchor", $$robo$$android_widget_PopupWindow$attachToAnchor(android.view.View int int int ), this, view, n, n2, n3);
    }

    protected View getAnchor() {
        return InvokeDynamicSupport.bootstrap("getAnchor", $$robo$$android_widget_PopupWindow$getAnchor(), this);
    }

    private void alignToAnchor() {
        InvokeDynamicSupport.bootstrap("alignToAnchor", $$robo$$android_widget_PopupWindow$alignToAnchor(), this);
    }

    private View getAppRootView(View view) {
        return InvokeDynamicSupport.bootstrap("getAppRootView", $$robo$$android_widget_PopupWindow$getAppRootView(android.view.View ), this, view);
    }

    static {
        RobolectricInternals.classInitializing(PopupWindow.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupWindow)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PopupBackgroundView
    extends FrameLayout
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ PopupWindow this$0;

        private void $$robo$$android_widget_PopupWindow_PopupBackgroundView$__constructor__(PopupWindow popupWindow, Context context) {
            this.this$0 = popupWindow;
        }

        private final int[] $$robo$$android_widget_PopupWindow_PopupBackgroundView$onCreateDrawableState(int extraSpace) {
            if (this.this$0.mAboveAnchor) {
                int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
                View.mergeDrawableStates(drawableState, ABOVE_ANCHOR_STATE_SET);
                return drawableState;
            }
            return super.onCreateDrawableState(extraSpace);
        }

        private void __constructor__(PopupWindow popupWindow, Context context) {
            this.$$robo$$android_widget_PopupWindow_PopupBackgroundView$__constructor__(popupWindow, context);
        }

        public PopupBackgroundView(PopupWindow popupWindow, Context context) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupBackgroundView$__constructor__(android.widget.PopupWindow android.content.Context ), this, popupWindow, context);
        }

        @Override
        protected int[] onCreateDrawableState(int n) {
            return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_PopupWindow_PopupBackgroundView$onCreateDrawableState(int ), this, n);
        }

        public /* synthetic */ PopupBackgroundView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupBackgroundView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupDecorView
    extends FrameLayout
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Runnable mCleanupAfterExit;
        private View.OnAttachStateChangeListener mOnAnchorRootDetachedListener;
        /* synthetic */ PopupWindow this$0;

        private void $$robo$$android_widget_PopupWindow_PopupDecorView$__constructor__(PopupWindow popupWindow, Context context) {
            this.this$0 = popupWindow;
            this.mOnAnchorRootDetachedListener = new View.OnAttachStateChangeListener(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PopupDecorView this$1;

                private void $$robo$$android_widget_PopupWindow_PopupDecorView_4$__constructor__(PopupDecorView this$1) {
                    this.this$1 = this$1;
                }

                private final void $$robo$$android_widget_PopupWindow_PopupDecorView_4$onViewAttachedToWindow(View v) {
                }

                private final void $$robo$$android_widget_PopupWindow_PopupDecorView_4$onViewDetachedFromWindow(View v) {
                    v.removeOnAttachStateChangeListener(this);
                    if (this.this$1.isAttachedToWindow()) {
                        TransitionManager.endTransitions(this.this$1);
                    }
                }

                private void __constructor__(PopupDecorView popupDecorView) {
                    this.$$robo$$android_widget_PopupWindow_PopupDecorView_4$__constructor__(popupDecorView);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupDecorView_4$__constructor__(android.widget.PopupWindow$PopupDecorView ), this, popupDecorView);
                }

                @Override
                public void onViewAttachedToWindow(View view) {
                    InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_widget_PopupWindow_PopupDecorView_4$onViewAttachedToWindow(android.view.View ), this, view);
                }

                @Override
                public void onViewDetachedFromWindow(View view) {
                    InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_widget_PopupWindow_PopupDecorView_4$onViewDetachedFromWindow(android.view.View ), this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final boolean $$robo$$android_widget_PopupWindow_PopupDecorView$dispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == 4) {
                KeyEvent.DispatcherState state;
                if (this.getKeyDispatcherState() == null) {
                    return super.dispatchKeyEvent(event);
                }
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                    if (state2 != null) {
                        state2.startTracking(event, this);
                    }
                    return true;
                }
                if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled()) {
                    this.this$0.dismiss();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }

        private final boolean $$robo$$android_widget_PopupWindow_PopupDecorView$dispatchTouchEvent(MotionEvent ev) {
            if (this.this$0.mTouchInterceptor != null && this.this$0.mTouchInterceptor.onTouch(this, ev)) {
                return true;
            }
            return super.dispatchTouchEvent(ev);
        }

        private final boolean $$robo$$android_widget_PopupWindow_PopupDecorView$onTouchEvent(MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
                this.this$0.dismiss();
                return true;
            }
            if (event.getAction() == 4) {
                this.this$0.dismiss();
                return true;
            }
            return super.onTouchEvent(event);
        }

        private final void $$robo$$android_widget_PopupWindow_PopupDecorView$requestEnterTransition(Transition transition2) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            if (observer != null && transition2 != null) {
                Object enterTransition = transition2.clone();
                observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this, (Transition)enterTransition){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ Transition val$enterTransition;
                    /* synthetic */ PopupDecorView this$1;

                    private void $$robo$$android_widget_PopupWindow_PopupDecorView_1$__constructor__(PopupDecorView this$1, Transition transition2) {
                        this.this$1 = this$1;
                        this.val$enterTransition = transition2;
                    }

                    private final void $$robo$$android_widget_PopupWindow_PopupDecorView_1$onGlobalLayout() {
                        ViewTreeObserver observer = this.this$1.getViewTreeObserver();
                        if (observer != null) {
                            observer.removeOnGlobalLayoutListener(this);
                        }
                        Rect epicenter = this.this$1.this$0.getTransitionEpicenter();
                        this.val$enterTransition.setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(this, epicenter){
                            public /* synthetic */ Object __robo_data__;
                            /* synthetic */ Rect val$epicenter;
                            /* synthetic */ 1 this$2;

                            private void $$robo$$android_widget_PopupWindow_PopupDecorView_1_1$__constructor__(1 this$2, Rect rect) {
                                this.this$2 = this$2;
                                this.val$epicenter = rect;
                            }

                            private final Rect $$robo$$android_widget_PopupWindow_PopupDecorView_1_1$onGetEpicenter(Transition transition2) {
                                return this.val$epicenter;
                            }

                            private void __constructor__(1 var1_1, Rect rect) {
                                this.$$robo$$android_widget_PopupWindow_PopupDecorView_1_1$__constructor__(var1_1, rect);
                            }
                            {
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupDecorView_1_1$__constructor__(android.widget.PopupWindow$PopupDecorView$1 android.graphics.Rect ), this, var1_1, rect);
                            }

                            @Override
                            public Rect onGetEpicenter(Transition transition2) {
                                return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_widget_PopupWindow_PopupDecorView_1_1$onGetEpicenter(android.transition.Transition ), this, transition2);
                            }
                            {
                                this.$$robo$init();
                            }

                            @Override
                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            @Override
                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                        this.this$1.startEnterTransition(this.val$enterTransition);
                    }

                    private void __constructor__(PopupDecorView popupDecorView, Transition transition2) {
                        this.$$robo$$android_widget_PopupWindow_PopupDecorView_1$__constructor__(popupDecorView, transition2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupDecorView_1$__constructor__(android.widget.PopupWindow$PopupDecorView android.transition.Transition ), this, popupDecorView, transition2);
                    }

                    @Override
                    public void onGlobalLayout() {
                        InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$android_widget_PopupWindow_PopupDecorView_1$onGlobalLayout(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private final void $$robo$$android_widget_PopupWindow_PopupDecorView$startEnterTransition(Transition enterTransition) {
            View child;
            int i;
            int count = this.getChildCount();
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                enterTransition.addTarget(child);
                child.setTransitionVisibility(4);
            }
            TransitionManager.beginDelayedTransition(this, enterTransition);
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                child.setTransitionVisibility(0);
            }
        }

        private final void $$robo$$android_widget_PopupWindow_PopupDecorView$startExitTransition(Transition transition2, View anchorRoot, Rect epicenter, Transition.TransitionListener listener) {
            View child;
            int i;
            if (transition2 == null) {
                return;
            }
            if (anchorRoot != null) {
                anchorRoot.addOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
            }
            this.mCleanupAfterExit = () -> {
                listener.onTransitionEnd(transition2);
                if (anchorRoot != null) {
                    anchorRoot.removeOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
                }
                this.mCleanupAfterExit = null;
            };
            Object exitTransition = transition2.clone();
            ((Transition)exitTransition).addListener((Transition.TransitionListener)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PopupDecorView this$1;

                private void $$robo$$android_widget_PopupWindow_PopupDecorView_2$__constructor__(PopupDecorView this$1) {
                    this.this$1 = this$1;
                }

                private final void $$robo$$android_widget_PopupWindow_PopupDecorView_2$onTransitionEnd(Transition t) {
                    t.removeListener(this);
                    if (this.this$1.mCleanupAfterExit != null) {
                        this.this$1.mCleanupAfterExit.run();
                    }
                }

                private void __constructor__(PopupDecorView popupDecorView) {
                    this.$$robo$$android_widget_PopupWindow_PopupDecorView_2$__constructor__(popupDecorView);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupDecorView_2$__constructor__(android.widget.PopupWindow$PopupDecorView ), this, popupDecorView);
                }

                @Override
                public void onTransitionEnd(Transition transition2) {
                    InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_widget_PopupWindow_PopupDecorView_2$onTransitionEnd(android.transition.Transition ), this, transition2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            ((Transition)exitTransition).setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(this, epicenter){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Rect val$epicenter;
                /* synthetic */ PopupDecorView this$1;

                private void $$robo$$android_widget_PopupWindow_PopupDecorView_3$__constructor__(PopupDecorView this$1, Rect rect) {
                    this.this$1 = this$1;
                    this.val$epicenter = rect;
                }

                private final Rect $$robo$$android_widget_PopupWindow_PopupDecorView_3$onGetEpicenter(Transition transition2) {
                    return this.val$epicenter;
                }

                private void __constructor__(PopupDecorView popupDecorView, Rect rect) {
                    this.$$robo$$android_widget_PopupWindow_PopupDecorView_3$__constructor__(popupDecorView, rect);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupDecorView_3$__constructor__(android.widget.PopupWindow$PopupDecorView android.graphics.Rect ), this, popupDecorView, rect);
                }

                @Override
                public Rect onGetEpicenter(Transition transition2) {
                    return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_widget_PopupWindow_PopupDecorView_3$onGetEpicenter(android.transition.Transition ), this, transition2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            int count = this.getChildCount();
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                ((Transition)exitTransition).addTarget(child);
            }
            TransitionManager.beginDelayedTransition(this, (Transition)exitTransition);
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                child.setVisibility(4);
            }
        }

        private final void $$robo$$android_widget_PopupWindow_PopupDecorView$cancelTransitions() {
            TransitionManager.endTransitions(this);
            if (this.mCleanupAfterExit != null) {
                this.mCleanupAfterExit.run();
            }
        }

        private final void $$robo$$android_widget_PopupWindow_PopupDecorView$requestKeyboardShortcuts(List<KeyboardShortcutGroup> list, int deviceId) {
            View parentRoot;
            if (this.this$0.mParentRootView != null && (parentRoot = (View)this.this$0.mParentRootView.get()) != null) {
                parentRoot.requestKeyboardShortcuts(list, deviceId);
            }
        }

        private void __constructor__(PopupWindow popupWindow, Context context) {
            this.$$robo$$android_widget_PopupWindow_PopupDecorView$__constructor__(popupWindow, context);
        }

        public PopupDecorView(PopupWindow popupWindow, Context context) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupDecorView$__constructor__(android.widget.PopupWindow android.content.Context ), this, popupWindow, context);
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_PopupWindow_PopupDecorView$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
        }

        @Override
        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_widget_PopupWindow_PopupDecorView$dispatchTouchEvent(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_PopupWindow_PopupDecorView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
        }

        public void requestEnterTransition(Transition transition2) {
            InvokeDynamicSupport.bootstrap("requestEnterTransition", $$robo$$android_widget_PopupWindow_PopupDecorView$requestEnterTransition(android.transition.Transition ), this, transition2);
        }

        private void startEnterTransition(Transition transition2) {
            InvokeDynamicSupport.bootstrap("startEnterTransition", $$robo$$android_widget_PopupWindow_PopupDecorView$startEnterTransition(android.transition.Transition ), this, transition2);
        }

        public void startExitTransition(Transition transition2, View view, Rect rect, Transition.TransitionListener transitionListener) {
            InvokeDynamicSupport.bootstrap("startExitTransition", $$robo$$android_widget_PopupWindow_PopupDecorView$startExitTransition(android.transition.Transition android.view.View android.graphics.Rect android.transition.Transition$TransitionListener ), this, transition2, view, rect, transitionListener);
        }

        public void cancelTransitions() {
            InvokeDynamicSupport.bootstrap("cancelTransitions", $$robo$$android_widget_PopupWindow_PopupDecorView$cancelTransitions(), this);
        }

        @Override
        public void requestKeyboardShortcuts(List<KeyboardShortcutGroup> list, int n) {
            InvokeDynamicSupport.bootstrap("requestKeyboardShortcuts", $$robo$$android_widget_PopupWindow_PopupDecorView$requestKeyboardShortcuts(java.util.List<android.view.KeyboardShortcutGroup> int ), this, list, n);
        }

        public /* synthetic */ PopupDecorView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupDecorView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

