/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListPosition;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExpandableListView
extends ListView
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int PACKED_POSITION_TYPE_GROUP = 0;
    public static int PACKED_POSITION_TYPE_CHILD = 1;
    public static int PACKED_POSITION_TYPE_NULL = 2;
    public static long PACKED_POSITION_VALUE_NULL = 0xFFFFFFFFL;
    private static long PACKED_POSITION_MASK_CHILD = 0xFFFFFFFFL;
    private static long PACKED_POSITION_MASK_GROUP = 0x7FFFFFFF00000000L;
    private static long PACKED_POSITION_MASK_TYPE = Long.MIN_VALUE;
    private static long PACKED_POSITION_SHIFT_GROUP = 32L;
    private static long PACKED_POSITION_SHIFT_TYPE = 63L;
    private static long PACKED_POSITION_INT_MASK_CHILD = -1L;
    private static long PACKED_POSITION_INT_MASK_GROUP = Integer.MAX_VALUE;
    private ExpandableListConnector mConnector;
    private ExpandableListAdapter mAdapter;
    private int mIndicatorLeft;
    private int mIndicatorRight;
    private int mIndicatorStart;
    private int mIndicatorEnd;
    private int mChildIndicatorLeft;
    private int mChildIndicatorRight;
    private int mChildIndicatorStart;
    private int mChildIndicatorEnd;
    public static int CHILD_INDICATOR_INHERIT = -1;
    private static int INDICATOR_UNDEFINED = -2;
    private Drawable mGroupIndicator;
    private Drawable mChildIndicator;
    private static int[] EMPTY_STATE_SET;
    private static int[] GROUP_EXPANDED_STATE_SET;
    private static int[] GROUP_EMPTY_STATE_SET;
    private static int[] GROUP_EXPANDED_EMPTY_STATE_SET;
    private static int[][] GROUP_STATE_SETS;
    private static int[] CHILD_LAST_STATE_SET;
    private Drawable mChildDivider;
    private Rect mIndicatorRect;
    private OnGroupCollapseListener mOnGroupCollapseListener;
    private OnGroupExpandListener mOnGroupExpandListener;
    private OnGroupClickListener mOnGroupClickListener;
    private OnChildClickListener mOnChildClickListener;

    private void $$robo$$android_widget_ExpandableListView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ExpandableListView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ExpandableListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ExpandableListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mIndicatorRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExpandableListView, defStyleAttr, defStyleRes);
        this.mGroupIndicator = a.getDrawable(0);
        this.mChildIndicator = a.getDrawable(1);
        this.mIndicatorLeft = a.getDimensionPixelSize(2, 0);
        this.mIndicatorRight = a.getDimensionPixelSize(3, 0);
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
        this.mChildIndicatorLeft = a.getDimensionPixelSize(4, -1);
        this.mChildIndicatorRight = a.getDimensionPixelSize(5, -1);
        this.mChildDivider = a.getDrawable(6);
        if (!this.isRtlCompatibilityMode()) {
            this.mIndicatorStart = a.getDimensionPixelSize(7, -2);
            this.mIndicatorEnd = a.getDimensionPixelSize(8, -2);
            this.mChildIndicatorStart = a.getDimensionPixelSize(9, -1);
            this.mChildIndicatorEnd = a.getDimensionPixelSize(10, -1);
        }
        a.recycle();
    }

    private final boolean $$robo$$android_widget_ExpandableListView$isRtlCompatibilityMode() {
        int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
        return targetSdkVersion < 17 || !this.hasRtlSupport();
    }

    private final boolean $$robo$$android_widget_ExpandableListView$hasRtlSupport() {
        return this.mContext.getApplicationInfo().hasRtlSupport();
    }

    private final void $$robo$$android_widget_ExpandableListView$onRtlPropertiesChanged(int layoutDirection) {
        this.resolveIndicator();
        this.resolveChildIndicator();
    }

    private final void $$robo$$android_widget_ExpandableListView$resolveIndicator() {
        boolean isLayoutRtl = this.isLayoutRtl();
        if (isLayoutRtl) {
            if (this.mIndicatorStart >= 0) {
                this.mIndicatorRight = this.mIndicatorStart;
            }
            if (this.mIndicatorEnd >= 0) {
                this.mIndicatorLeft = this.mIndicatorEnd;
            }
        } else {
            if (this.mIndicatorStart >= 0) {
                this.mIndicatorLeft = this.mIndicatorStart;
            }
            if (this.mIndicatorEnd >= 0) {
                this.mIndicatorRight = this.mIndicatorEnd;
            }
        }
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    private final void $$robo$$android_widget_ExpandableListView$resolveChildIndicator() {
        boolean isLayoutRtl = this.isLayoutRtl();
        if (isLayoutRtl) {
            if (this.mChildIndicatorStart >= -1) {
                this.mChildIndicatorRight = this.mChildIndicatorStart;
            }
            if (this.mChildIndicatorEnd >= -1) {
                this.mChildIndicatorLeft = this.mChildIndicatorEnd;
            }
        } else {
            if (this.mChildIndicatorStart >= -1) {
                this.mChildIndicatorLeft = this.mChildIndicatorStart;
            }
            if (this.mChildIndicatorEnd >= -1) {
                this.mChildIndicatorRight = this.mChildIndicatorEnd;
            }
        }
    }

    private final void $$robo$$android_widget_ExpandableListView$dispatchDraw(Canvas canvas) {
        boolean clipToPadding;
        super.dispatchDraw(canvas);
        if (this.mChildIndicator == null && this.mGroupIndicator == null) {
            return;
        }
        int saveCount = 0;
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int lastChildFlPos = this.mItemCount - this.getFooterViewsCount() - headerViewsCount - 1;
        int myB = this.mBottom;
        int lastItemType = -4;
        Rect indicatorRect = this.mIndicatorRect;
        int childCount = this.getChildCount();
        int i = 0;
        int childFlPos = this.mFirstPosition - headerViewsCount;
        while (i < childCount) {
            if (childFlPos >= 0) {
                if (childFlPos > lastChildFlPos) break;
                View item = this.getChildAt(i);
                int t = item.getTop();
                int b = item.getBottom();
                if (b >= 0 && t <= myB) {
                    ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(childFlPos);
                    boolean isLayoutRtl = this.isLayoutRtl();
                    int width = this.getWidth();
                    if (pos.position.type != lastItemType) {
                        if (pos.position.type == 1) {
                            indicatorRect.left = this.mChildIndicatorLeft == -1 ? this.mIndicatorLeft : this.mChildIndicatorLeft;
                            indicatorRect.right = this.mChildIndicatorRight == -1 ? this.mIndicatorRight : this.mChildIndicatorRight;
                        } else {
                            indicatorRect.left = this.mIndicatorLeft;
                            indicatorRect.right = this.mIndicatorRight;
                        }
                        if (isLayoutRtl) {
                            int temp = indicatorRect.left;
                            indicatorRect.left = width - indicatorRect.right;
                            indicatorRect.right = width - temp;
                            indicatorRect.left -= this.mPaddingRight;
                            indicatorRect.right -= this.mPaddingRight;
                        } else {
                            indicatorRect.left += this.mPaddingLeft;
                            indicatorRect.right += this.mPaddingLeft;
                        }
                        lastItemType = pos.position.type;
                    }
                    if (indicatorRect.left != indicatorRect.right) {
                        if (this.mStackFromBottom) {
                            indicatorRect.top = t;
                            indicatorRect.bottom = b;
                        } else {
                            indicatorRect.top = t;
                            indicatorRect.bottom = b;
                        }
                        Drawable indicator = this.getIndicator(pos);
                        if (indicator != null) {
                            indicator.setBounds(indicatorRect);
                            indicator.draw(canvas);
                        }
                    }
                    pos.recycle();
                }
            }
            ++i;
            ++childFlPos;
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
        }
    }

    private final Drawable $$robo$$android_widget_ExpandableListView$getIndicator(ExpandableListConnector.PositionMetadata pos) {
        Drawable indicator;
        if (pos.position.type == 2) {
            indicator = this.mGroupIndicator;
            if (indicator != null && indicator.isStateful()) {
                boolean isEmpty = pos.groupMetadata == null || pos.groupMetadata.lastChildFlPos == pos.groupMetadata.flPos;
                int stateSetIndex = (pos.isExpanded() ? 1 : 0) | (isEmpty ? 2 : 0);
                indicator.setState(GROUP_STATE_SETS[stateSetIndex]);
            }
        } else {
            indicator = this.mChildIndicator;
            if (indicator != null && indicator.isStateful()) {
                int[] stateSet = pos.position.flatListPos == pos.groupMetadata.lastChildFlPos ? CHILD_LAST_STATE_SET : EMPTY_STATE_SET;
                indicator.setState(stateSet);
            }
        }
        return indicator;
    }

    private final void $$robo$$android_widget_ExpandableListView$setChildDivider(Drawable childDivider) {
        this.mChildDivider = childDivider;
    }

    private final void $$robo$$android_widget_ExpandableListView$drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        int flatListPosition = childIndex + this.mFirstPosition;
        if (flatListPosition >= 0) {
            int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
            ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(adjustedPosition);
            if (pos.position.type == 1 || pos.isExpanded() && pos.groupMetadata.lastChildFlPos != pos.groupMetadata.flPos) {
                Drawable divider = this.mChildDivider;
                divider.setBounds(bounds);
                divider.draw(canvas);
                pos.recycle();
                return;
            }
            pos.recycle();
        }
        super.drawDivider(canvas, bounds, flatListPosition);
    }

    private final void $$robo$$android_widget_ExpandableListView$setAdapter(ListAdapter adapter) {
        throw new RuntimeException("For ExpandableListView, use setAdapter(ExpandableListAdapter) instead of setAdapter(ListAdapter)");
    }

    private final ListAdapter $$robo$$android_widget_ExpandableListView$getAdapter() {
        return super.getAdapter();
    }

    private final void $$robo$$android_widget_ExpandableListView$setOnItemClickListener(AdapterView.OnItemClickListener l) {
        super.setOnItemClickListener(l);
    }

    private final void $$robo$$android_widget_ExpandableListView$setAdapter(ExpandableListAdapter adapter) {
        this.mAdapter = adapter;
        this.mConnector = adapter != null ? new ExpandableListConnector(adapter) : null;
        super.setAdapter(this.mConnector);
    }

    private final ExpandableListAdapter $$robo$$android_widget_ExpandableListView$getExpandableListAdapter() {
        return this.mAdapter;
    }

    private final boolean $$robo$$android_widget_ExpandableListView$isHeaderOrFooterPosition(int position) {
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        return position < this.getHeaderViewsCount() || position >= footerViewsStart;
    }

    private final int $$robo$$android_widget_ExpandableListView$getFlatPositionForConnector(int flatListPosition) {
        return flatListPosition - this.getHeaderViewsCount();
    }

    private final int $$robo$$android_widget_ExpandableListView$getAbsoluteFlatPosition(int flatListPosition) {
        return flatListPosition + this.getHeaderViewsCount();
    }

    private final boolean $$robo$$android_widget_ExpandableListView$performItemClick(View v, int position, long id2) {
        if (this.isHeaderOrFooterPosition(position)) {
            return super.performItemClick(v, position, id2);
        }
        int adjustedPosition = this.getFlatPositionForConnector(position);
        return this.handleItemClick(v, adjustedPosition, id2);
    }

    private final boolean $$robo$$android_widget_ExpandableListView$handleItemClick(View v, int position, long id2) {
        boolean returnValue;
        ExpandableListConnector.PositionMetadata posMetadata = this.mConnector.getUnflattenedPos(position);
        id2 = this.getChildOrGroupId(posMetadata.position);
        if (posMetadata.position.type == 2) {
            if (this.mOnGroupClickListener != null && this.mOnGroupClickListener.onGroupClick(this, v, posMetadata.position.groupPos, id2)) {
                posMetadata.recycle();
                return true;
            }
            if (posMetadata.isExpanded()) {
                this.mConnector.collapseGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupCollapseListener != null) {
                    this.mOnGroupCollapseListener.onGroupCollapse(posMetadata.position.groupPos);
                }
            } else {
                this.mConnector.expandGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupExpandListener != null) {
                    this.mOnGroupExpandListener.onGroupExpand(posMetadata.position.groupPos);
                }
                int groupPos = posMetadata.position.groupPos;
                int groupFlatPos = posMetadata.position.flatListPos;
                int shiftedGroupPosition = groupFlatPos + this.getHeaderViewsCount();
                this.smoothScrollToPosition(shiftedGroupPosition + this.mAdapter.getChildrenCount(groupPos), shiftedGroupPosition);
            }
            returnValue = true;
        } else {
            if (this.mOnChildClickListener != null) {
                this.playSoundEffect(0);
                return this.mOnChildClickListener.onChildClick(this, v, posMetadata.position.groupPos, posMetadata.position.childPos, id2);
            }
            returnValue = false;
        }
        posMetadata.recycle();
        return returnValue;
    }

    private final boolean $$robo$$android_widget_ExpandableListView$expandGroup(int groupPos) {
        return this.expandGroup(groupPos, false);
    }

    private final boolean $$robo$$android_widget_ExpandableListView$expandGroup(int groupPos, boolean animate) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtain(2, groupPos, -1, -1);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        boolean retValue = this.mConnector.expandGroup(pm);
        if (this.mOnGroupExpandListener != null) {
            this.mOnGroupExpandListener.onGroupExpand(groupPos);
        }
        if (animate) {
            int groupFlatPos = pm.position.flatListPos;
            int shiftedGroupPosition = groupFlatPos + this.getHeaderViewsCount();
            this.smoothScrollToPosition(shiftedGroupPosition + this.mAdapter.getChildrenCount(groupPos), shiftedGroupPosition);
        }
        pm.recycle();
        return retValue;
    }

    private final boolean $$robo$$android_widget_ExpandableListView$collapseGroup(int groupPos) {
        boolean retValue = this.mConnector.collapseGroup(groupPos);
        if (this.mOnGroupCollapseListener != null) {
            this.mOnGroupCollapseListener.onGroupCollapse(groupPos);
        }
        return retValue;
    }

    private final void $$robo$$android_widget_ExpandableListView$setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        this.mOnGroupCollapseListener = onGroupCollapseListener;
    }

    private final void $$robo$$android_widget_ExpandableListView$setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        this.mOnGroupExpandListener = onGroupExpandListener;
    }

    private final void $$robo$$android_widget_ExpandableListView$setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    private final void $$robo$$android_widget_ExpandableListView$setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    private final long $$robo$$android_widget_ExpandableListView$getExpandableListPosition(int flatListPosition) {
        if (this.isHeaderOrFooterPosition(flatListPosition)) {
            return 0xFFFFFFFFL;
        }
        int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        long packedPos = pm.position.getPackedPosition();
        pm.recycle();
        return packedPos;
    }

    private final int $$robo$$android_widget_ExpandableListView$getFlatListPosition(long packedPosition) {
        ExpandableListPosition elPackedPos = ExpandableListPosition.obtainPosition(packedPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elPackedPos);
        elPackedPos.recycle();
        int flatListPosition = pm.position.flatListPos;
        pm.recycle();
        return this.getAbsoluteFlatPosition(flatListPosition);
    }

    private final long $$robo$$android_widget_ExpandableListView$getSelectedPosition() {
        int selectedPos = this.getSelectedItemPosition();
        return this.getExpandableListPosition(selectedPos);
    }

    private final long $$robo$$android_widget_ExpandableListView$getSelectedId() {
        long packedPos = this.getSelectedPosition();
        if (packedPos == 0xFFFFFFFFL) {
            return -1L;
        }
        int groupPos = ExpandableListView.getPackedPositionGroup(packedPos);
        if (ExpandableListView.getPackedPositionType(packedPos) == 0) {
            return this.mAdapter.getGroupId(groupPos);
        }
        return this.mAdapter.getChildId(groupPos, ExpandableListView.getPackedPositionChild(packedPos));
    }

    private final void $$robo$$android_widget_ExpandableListView$setSelectedGroup(int groupPosition) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtainGroupPosition(groupPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        int absoluteFlatPosition = this.getAbsoluteFlatPosition(pm.position.flatListPos);
        super.setSelection(absoluteFlatPosition);
        pm.recycle();
    }

    private final boolean $$robo$$android_widget_ExpandableListView$setSelectedChild(int groupPosition, int childPosition, boolean shouldExpandGroup) {
        ExpandableListPosition elChildPos = ExpandableListPosition.obtainChildPosition(groupPosition, childPosition);
        ExpandableListConnector.PositionMetadata flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
        if (flatChildPos == null) {
            if (!shouldExpandGroup) {
                return false;
            }
            this.expandGroup(groupPosition);
            flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
            if (flatChildPos == null) {
                throw new IllegalStateException("Could not find child");
            }
        }
        int absoluteFlatPosition = this.getAbsoluteFlatPosition(flatChildPos.position.flatListPos);
        super.setSelection(absoluteFlatPosition);
        elChildPos.recycle();
        flatChildPos.recycle();
        return true;
    }

    private final boolean $$robo$$android_widget_ExpandableListView$isGroupExpanded(int groupPosition) {
        return this.mConnector.isGroupExpanded(groupPosition);
    }

    private static final int $$robo$$android_widget_ExpandableListView$getPackedPositionType(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return 2;
        }
        return (packedPosition & Long.MIN_VALUE) == Long.MIN_VALUE ? 1 : 0;
    }

    private static final int $$robo$$android_widget_ExpandableListView$getPackedPositionGroup(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        return (int)((packedPosition & 0x7FFFFFFF00000000L) >> 32);
    }

    private static final int $$robo$$android_widget_ExpandableListView$getPackedPositionChild(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        if ((packedPosition & Long.MIN_VALUE) != Long.MIN_VALUE) {
            return -1;
        }
        return (int)(packedPosition & 0xFFFFFFFFL);
    }

    private static final long $$robo$$android_widget_ExpandableListView$getPackedPositionForChild(int groupPosition, int childPosition) {
        return Long.MIN_VALUE | ((long)groupPosition & Integer.MAX_VALUE) << 32 | (long)childPosition & 0xFFFFFFFFFFFFFFFFL;
    }

    private static final long $$robo$$android_widget_ExpandableListView$getPackedPositionForGroup(int groupPosition) {
        return ((long)groupPosition & Integer.MAX_VALUE) << 32;
    }

    private final ContextMenu.ContextMenuInfo $$robo$$android_widget_ExpandableListView$createContextMenuInfo(View view, int flatListPosition, long id2) {
        if (this.isHeaderOrFooterPosition(flatListPosition)) {
            return new AdapterView.AdapterContextMenuInfo(view, flatListPosition, id2);
        }
        int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        ExpandableListPosition pos = pm.position;
        id2 = this.getChildOrGroupId(pos);
        long packedPosition = pos.getPackedPosition();
        pm.recycle();
        return new ExpandableListContextMenuInfo(view, packedPosition, id2);
    }

    private final long $$robo$$android_widget_ExpandableListView$getChildOrGroupId(ExpandableListPosition position) {
        if (position.type == 1) {
            return this.mAdapter.getChildId(position.groupPos, position.childPos);
        }
        return this.mAdapter.getGroupId(position.groupPos);
    }

    private final void $$robo$$android_widget_ExpandableListView$setChildIndicator(Drawable childIndicator) {
        this.mChildIndicator = childIndicator;
    }

    private final void $$robo$$android_widget_ExpandableListView$setChildIndicatorBounds(int left, int right) {
        this.mChildIndicatorLeft = left;
        this.mChildIndicatorRight = right;
        this.resolveChildIndicator();
    }

    private final void $$robo$$android_widget_ExpandableListView$setChildIndicatorBoundsRelative(int start, int end) {
        this.mChildIndicatorStart = start;
        this.mChildIndicatorEnd = end;
        this.resolveChildIndicator();
    }

    private final void $$robo$$android_widget_ExpandableListView$setGroupIndicator(Drawable groupIndicator) {
        this.mGroupIndicator = groupIndicator;
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    private final void $$robo$$android_widget_ExpandableListView$setIndicatorBounds(int left, int right) {
        this.mIndicatorLeft = left;
        this.mIndicatorRight = right;
        this.resolveIndicator();
    }

    private final void $$robo$$android_widget_ExpandableListView$setIndicatorBoundsRelative(int start, int end) {
        this.mIndicatorStart = start;
        this.mIndicatorEnd = end;
        this.resolveIndicator();
    }

    private final Parcelable $$robo$$android_widget_ExpandableListView$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mConnector != null ? this.mConnector.getExpandedGroupMetadataList() : null);
    }

    private final void $$robo$$android_widget_ExpandableListView$onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mConnector != null && ss.expandedGroupMetadataList != null) {
            this.mConnector.setExpandedGroupMetadataList(ss.expandedGroupMetadataList);
        }
    }

    private final CharSequence $$robo$$android_widget_ExpandableListView$getAccessibilityClassName() {
        return ExpandableListView.class.getName();
    }

    static void __staticInitializer__() {
        EMPTY_STATE_SET = new int[0];
        GROUP_EXPANDED_STATE_SET = new int[]{16842920};
        GROUP_EMPTY_STATE_SET = new int[]{16842921};
        GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
        GROUP_STATE_SETS = new int[][]{EMPTY_STATE_SET, GROUP_EXPANDED_STATE_SET, GROUP_EMPTY_STATE_SET, GROUP_EXPANDED_EMPTY_STATE_SET};
        CHILD_LAST_STATE_SET = new int[]{16842918};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ExpandableListView$__constructor__(context);
    }

    public ExpandableListView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ExpandableListView$__constructor__(context, attributeSet);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842863);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ExpandableListView$__constructor__(context, attributeSet, n);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ExpandableListView$__constructor__(context, attributeSet, n, n2);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private boolean isRtlCompatibilityMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRtlCompatibilityMode", $$robo$$android_widget_ExpandableListView$isRtlCompatibilityMode(), this);
    }

    private boolean hasRtlSupport() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRtlSupport", $$robo$$android_widget_ExpandableListView$hasRtlSupport(), this);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_ExpandableListView$onRtlPropertiesChanged(int ), this, n);
    }

    private void resolveIndicator() {
        InvokeDynamicSupport.bootstrap("resolveIndicator", $$robo$$android_widget_ExpandableListView$resolveIndicator(), this);
    }

    private void resolveChildIndicator() {
        InvokeDynamicSupport.bootstrap("resolveChildIndicator", $$robo$$android_widget_ExpandableListView$resolveChildIndicator(), this);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_ExpandableListView$dispatchDraw(android.graphics.Canvas ), this, canvas);
    }

    private Drawable getIndicator(ExpandableListConnector.PositionMetadata positionMetadata) {
        return InvokeDynamicSupport.bootstrap("getIndicator", $$robo$$android_widget_ExpandableListView$getIndicator(android.widget.ExpandableListConnector$PositionMetadata ), this, positionMetadata);
    }

    public void setChildDivider(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setChildDivider", $$robo$$android_widget_ExpandableListView$setChildDivider(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    void drawDivider(Canvas canvas, Rect rect, int n) {
        InvokeDynamicSupport.bootstrap("drawDivider", $$robo$$android_widget_ExpandableListView$drawDivider(android.graphics.Canvas android.graphics.Rect int ), this, canvas, rect, n);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_ExpandableListView$setAdapter(android.widget.ListAdapter ), this, listAdapter);
    }

    @Override
    public ListAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_ExpandableListView$getAdapter(), this);
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListener", $$robo$$android_widget_ExpandableListView$setOnItemClickListener(android.widget.AdapterView$OnItemClickListener ), this, onItemClickListener);
    }

    @Override
    public void setAdapter(ExpandableListAdapter expandableListAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_ExpandableListView$setAdapter(android.widget.ExpandableListAdapter ), this, expandableListAdapter);
    }

    public ExpandableListAdapter getExpandableListAdapter() {
        return InvokeDynamicSupport.bootstrap("getExpandableListAdapter", $$robo$$android_widget_ExpandableListView$getExpandableListAdapter(), this);
    }

    private boolean isHeaderOrFooterPosition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHeaderOrFooterPosition", $$robo$$android_widget_ExpandableListView$isHeaderOrFooterPosition(int ), this, n);
    }

    private int getFlatPositionForConnector(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFlatPositionForConnector", $$robo$$android_widget_ExpandableListView$getFlatPositionForConnector(int ), this, n);
    }

    private int getAbsoluteFlatPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getAbsoluteFlatPosition", $$robo$$android_widget_ExpandableListView$getAbsoluteFlatPosition(int ), this, n);
    }

    @Override
    public boolean performItemClick(View view, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemClick", $$robo$$android_widget_ExpandableListView$performItemClick(android.view.View int long ), this, view, n, l);
    }

    boolean handleItemClick(View view, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleItemClick", $$robo$$android_widget_ExpandableListView$handleItemClick(android.view.View int long ), this, view, n, l);
    }

    public boolean expandGroup(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandGroup", $$robo$$android_widget_ExpandableListView$expandGroup(int ), this, n);
    }

    public boolean expandGroup(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandGroup", $$robo$$android_widget_ExpandableListView$expandGroup(int boolean ), this, n, bl);
    }

    public boolean collapseGroup(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseGroup", $$robo$$android_widget_ExpandableListView$collapseGroup(int ), this, n);
    }

    public void setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        InvokeDynamicSupport.bootstrap("setOnGroupCollapseListener", $$robo$$android_widget_ExpandableListView$setOnGroupCollapseListener(android.widget.ExpandableListView$OnGroupCollapseListener ), this, onGroupCollapseListener);
    }

    public void setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        InvokeDynamicSupport.bootstrap("setOnGroupExpandListener", $$robo$$android_widget_ExpandableListView$setOnGroupExpandListener(android.widget.ExpandableListView$OnGroupExpandListener ), this, onGroupExpandListener);
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        InvokeDynamicSupport.bootstrap("setOnGroupClickListener", $$robo$$android_widget_ExpandableListView$setOnGroupClickListener(android.widget.ExpandableListView$OnGroupClickListener ), this, onGroupClickListener);
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        InvokeDynamicSupport.bootstrap("setOnChildClickListener", $$robo$$android_widget_ExpandableListView$setOnChildClickListener(android.widget.ExpandableListView$OnChildClickListener ), this, onChildClickListener);
    }

    public long getExpandableListPosition(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getExpandableListPosition", $$robo$$android_widget_ExpandableListView$getExpandableListPosition(int ), this, n);
    }

    public int getFlatListPosition(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getFlatListPosition", $$robo$$android_widget_ExpandableListView$getFlatListPosition(long ), this, l);
    }

    public long getSelectedPosition() {
        return (long)InvokeDynamicSupport.bootstrap("getSelectedPosition", $$robo$$android_widget_ExpandableListView$getSelectedPosition(), this);
    }

    public long getSelectedId() {
        return (long)InvokeDynamicSupport.bootstrap("getSelectedId", $$robo$$android_widget_ExpandableListView$getSelectedId(), this);
    }

    public void setSelectedGroup(int n) {
        InvokeDynamicSupport.bootstrap("setSelectedGroup", $$robo$$android_widget_ExpandableListView$setSelectedGroup(int ), this, n);
    }

    public boolean setSelectedChild(int n, int n2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setSelectedChild", $$robo$$android_widget_ExpandableListView$setSelectedChild(int int boolean ), this, n, n2, bl);
    }

    public boolean isGroupExpanded(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupExpanded", $$robo$$android_widget_ExpandableListView$isGroupExpanded(int ), this, n);
    }

    public static int getPackedPositionType(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPackedPositionType", $$robo$$android_widget_ExpandableListView$getPackedPositionType(long ), (long)l);
    }

    public static int getPackedPositionGroup(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPackedPositionGroup", $$robo$$android_widget_ExpandableListView$getPackedPositionGroup(long ), (long)l);
    }

    public static int getPackedPositionChild(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPackedPositionChild", $$robo$$android_widget_ExpandableListView$getPackedPositionChild(long ), (long)l);
    }

    public static long getPackedPositionForChild(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPackedPositionForChild", $$robo$$android_widget_ExpandableListView$getPackedPositionForChild(int int ), (int)n, (int)n2);
    }

    public static long getPackedPositionForGroup(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPackedPositionForGroup", $$robo$$android_widget_ExpandableListView$getPackedPositionForGroup(int ), (int)n);
    }

    @Override
    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        return InvokeDynamicSupport.bootstrap("createContextMenuInfo", $$robo$$android_widget_ExpandableListView$createContextMenuInfo(android.view.View int long ), this, view, n, l);
    }

    private long getChildOrGroupId(ExpandableListPosition expandableListPosition) {
        return (long)InvokeDynamicSupport.bootstrap("getChildOrGroupId", $$robo$$android_widget_ExpandableListView$getChildOrGroupId(android.widget.ExpandableListPosition ), this, expandableListPosition);
    }

    public void setChildIndicator(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setChildIndicator", $$robo$$android_widget_ExpandableListView$setChildIndicator(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setChildIndicatorBounds(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setChildIndicatorBounds", $$robo$$android_widget_ExpandableListView$setChildIndicatorBounds(int int ), this, n, n2);
    }

    public void setChildIndicatorBoundsRelative(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setChildIndicatorBoundsRelative", $$robo$$android_widget_ExpandableListView$setChildIndicatorBoundsRelative(int int ), this, n, n2);
    }

    public void setGroupIndicator(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setGroupIndicator", $$robo$$android_widget_ExpandableListView$setGroupIndicator(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setIndicatorBounds(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setIndicatorBounds", $$robo$$android_widget_ExpandableListView$setIndicatorBounds(int int ), this, n, n2);
    }

    public void setIndicatorBoundsRelative(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setIndicatorBoundsRelative", $$robo$$android_widget_ExpandableListView$setIndicatorBoundsRelative(int int ), this, n, n2);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_ExpandableListView$onSaveInstanceState(), this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_ExpandableListView$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_ExpandableListView$getAccessibilityClassName(), this);
    }

    static {
        RobolectricInternals.classInitializing(ExpandableListView.class);
    }

    public /* synthetic */ ExpandableListView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExpandableListView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_ExpandableListView_SavedState$__constructor__(Parcelable superState, ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList) {
            this.expandedGroupMetadataList = expandedGroupMetadataList;
        }

        private void $$robo$$android_widget_ExpandableListView_SavedState$__constructor__(Parcel in) {
            this.expandedGroupMetadataList = new ArrayList();
            in.readList(this.expandedGroupMetadataList, ExpandableListConnector.class.getClassLoader());
        }

        private final void $$robo$$android_widget_ExpandableListView_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeList(this.expandedGroupMetadataList);
        }

        private /* synthetic */ void $$robo$$android_widget_ExpandableListView_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ExpandableListView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_ExpandableListView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in, null);
                }

                private final SavedState[] $$robo$$android_widget_ExpandableListView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_ExpandableListView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_ExpandableListView_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_ExpandableListView_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, ArrayList<ExpandableListConnector.GroupMetadata> arrayList) {
            this.$$robo$$android_widget_ExpandableListView_SavedState$__constructor__(parcelable, arrayList);
        }

        public SavedState(Parcelable parcelable, ArrayList<ExpandableListConnector.GroupMetadata> arrayList) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView_SavedState$__constructor__(android.os.Parcelable java.util.ArrayList<android.widget.ExpandableListConnector$GroupMetadata> ), this, parcelable, arrayList);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_ExpandableListView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_ExpandableListView_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_ExpandableListView_SavedState$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ SavedState(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView_SavedState$__constructor__(android.os.Parcel android.widget.ExpandableListView$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ExpandableListContextMenuInfo
    implements ContextMenu.ContextMenuInfo,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public View targetView;
        public long packedPosition;
        public long id;

        private void $$robo$$android_widget_ExpandableListView_ExpandableListContextMenuInfo$__constructor__(View targetView, long packedPosition, long id2) {
            this.targetView = targetView;
            this.packedPosition = packedPosition;
            this.id = id2;
        }

        private void __constructor__(View view, long l, long l2) {
            this.$$robo$$android_widget_ExpandableListView_ExpandableListContextMenuInfo$__constructor__(view, l, l2);
        }

        public ExpandableListContextMenuInfo(View view, long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ExpandableListView_ExpandableListContextMenuInfo$__constructor__(android.view.View long long ), this, view, l, l2);
        }

        public /* synthetic */ ExpandableListContextMenuInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExpandableListContextMenuInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnChildClickListener {
        public boolean onChildClick(ExpandableListView var1, View var2, int var3, int var4, long var5);
    }

    public static interface OnGroupClickListener {
        public boolean onGroupClick(ExpandableListView var1, View var2, int var3, long var4);
    }

    public static interface OnGroupExpandListener {
        public void onGroupExpand(int var1);
    }

    public static interface OnGroupCollapseListener {
        public void onGroupCollapse(int var1);
    }
}

