/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CursorTreeAdapter
extends BaseExpandableListAdapter
implements Filterable,
CursorFilter.CursorFilterClient,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Context mContext;
    private Handler mHandler;
    private boolean mAutoRequery;
    MyCursorHelper mGroupCursorHelper;
    SparseArray<MyCursorHelper> mChildrenCursorHelpers;
    CursorFilter mCursorFilter;
    FilterQueryProvider mFilterQueryProvider;

    private void $$robo$$android_widget_CursorTreeAdapter$__constructor__(Cursor cursor, Context context) {
        this.init(cursor, context, true);
    }

    private void $$robo$$android_widget_CursorTreeAdapter$__constructor__(Cursor cursor, Context context, boolean autoRequery) {
        this.init(cursor, context, autoRequery);
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$init(Cursor cursor, Context context, boolean autoRequery) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mAutoRequery = autoRequery;
        this.mGroupCursorHelper = new MyCursorHelper(this, cursor);
        this.mChildrenCursorHelpers = new SparseArray();
    }

    private final synchronized MyCursorHelper $$robo$$android_widget_CursorTreeAdapter$getChildrenCursorHelper(int groupPosition, boolean requestCursor) {
        MyCursorHelper cursorHelper = this.mChildrenCursorHelpers.get(groupPosition);
        if (cursorHelper == null) {
            if (this.mGroupCursorHelper.moveTo(groupPosition) == null) {
                return null;
            }
            Cursor cursor = this.getChildrenCursor(this.mGroupCursorHelper.getCursor());
            cursorHelper = new MyCursorHelper(this, cursor);
            this.mChildrenCursorHelpers.put(groupPosition, cursorHelper);
        }
        return cursorHelper;
    }

    protected abstract Cursor getChildrenCursor(Cursor var1);

    private final void $$robo$$android_widget_CursorTreeAdapter$setGroupCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, false);
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$setChildrenCursor(int groupPosition, Cursor childrenCursor) {
        MyCursorHelper childrenCursorHelper = this.getChildrenCursorHelper(groupPosition, false);
        childrenCursorHelper.changeCursor(childrenCursor, false);
    }

    private final Cursor $$robo$$android_widget_CursorTreeAdapter$getChild(int groupPosition, int childPosition) {
        return this.getChildrenCursorHelper(groupPosition, true).moveTo(childPosition);
    }

    private final long $$robo$$android_widget_CursorTreeAdapter$getChildId(int groupPosition, int childPosition) {
        return this.getChildrenCursorHelper(groupPosition, true).getId(childPosition);
    }

    private final int $$robo$$android_widget_CursorTreeAdapter$getChildrenCount(int groupPosition) {
        MyCursorHelper helper = this.getChildrenCursorHelper(groupPosition, true);
        return this.mGroupCursorHelper.isValid() && helper != null ? helper.getCount() : 0;
    }

    private final Cursor $$robo$$android_widget_CursorTreeAdapter$getGroup(int groupPosition) {
        return this.mGroupCursorHelper.moveTo(groupPosition);
    }

    private final int $$robo$$android_widget_CursorTreeAdapter$getGroupCount() {
        return this.mGroupCursorHelper.getCount();
    }

    private final long $$robo$$android_widget_CursorTreeAdapter$getGroupId(int groupPosition) {
        return this.mGroupCursorHelper.getId(groupPosition);
    }

    private final View $$robo$$android_widget_CursorTreeAdapter$getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        Cursor cursor = this.mGroupCursorHelper.moveTo(groupPosition);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View v = convertView == null ? this.newGroupView(this.mContext, cursor, isExpanded, parent) : convertView;
        this.bindGroupView(v, this.mContext, cursor, isExpanded);
        return v;
    }

    protected abstract View newGroupView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    protected abstract void bindGroupView(View var1, Context var2, Cursor var3, boolean var4);

    private final View $$robo$$android_widget_CursorTreeAdapter$getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        MyCursorHelper cursorHelper = this.getChildrenCursorHelper(groupPosition, true);
        Cursor cursor = cursorHelper.moveTo(childPosition);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View v = convertView == null ? this.newChildView(this.mContext, cursor, isLastChild, parent) : convertView;
        this.bindChildView(v, this.mContext, cursor, isLastChild);
        return v;
    }

    protected abstract View newChildView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    protected abstract void bindChildView(View var1, Context var2, Cursor var3, boolean var4);

    private final boolean $$robo$$android_widget_CursorTreeAdapter$isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    private final boolean $$robo$$android_widget_CursorTreeAdapter$hasStableIds() {
        return true;
    }

    private final synchronized void $$robo$$android_widget_CursorTreeAdapter$releaseCursorHelpers() {
        for (int pos = this.mChildrenCursorHelpers.size() - 1; pos >= 0; --pos) {
            this.mChildrenCursorHelpers.valueAt(pos).deactivate();
        }
        this.mChildrenCursorHelpers.clear();
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$notifyDataSetChanged() {
        this.notifyDataSetChanged(true);
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$notifyDataSetChanged(boolean releaseCursors) {
        if (releaseCursors) {
            this.releaseCursorHelpers();
        }
        super.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$notifyDataSetInvalidated() {
        this.releaseCursorHelpers();
        super.notifyDataSetInvalidated();
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$onGroupCollapsed(int groupPosition) {
        this.deactivateChildrenCursorHelper(groupPosition);
    }

    private final synchronized void $$robo$$android_widget_CursorTreeAdapter$deactivateChildrenCursorHelper(int groupPosition) {
        MyCursorHelper cursorHelper = this.getChildrenCursorHelper(groupPosition, true);
        this.mChildrenCursorHelpers.remove(groupPosition);
        cursorHelper.deactivate();
    }

    private final String $$robo$$android_widget_CursorTreeAdapter$convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    private final Cursor $$robo$$android_widget_CursorTreeAdapter$runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mGroupCursorHelper.getCursor();
    }

    private final Filter $$robo$$android_widget_CursorTreeAdapter$getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    private final FilterQueryProvider $$robo$$android_widget_CursorTreeAdapter$getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    private final void $$robo$$android_widget_CursorTreeAdapter$changeCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, true);
    }

    private final Cursor $$robo$$android_widget_CursorTreeAdapter$getCursor() {
        return this.mGroupCursorHelper.getCursor();
    }

    private void __constructor__(Cursor cursor, Context context) {
        this.$$robo$$android_widget_CursorTreeAdapter$__constructor__(cursor, context);
    }

    public CursorTreeAdapter(Cursor cursor, Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorTreeAdapter$__constructor__(android.database.Cursor android.content.Context ), this, cursor, context);
    }

    private void __constructor__(Cursor cursor, Context context, boolean bl) {
        this.$$robo$$android_widget_CursorTreeAdapter$__constructor__(cursor, context, bl);
    }

    public CursorTreeAdapter(Cursor cursor, Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorTreeAdapter$__constructor__(android.database.Cursor android.content.Context boolean ), this, cursor, context, bl);
    }

    private void init(Cursor cursor, Context context, boolean bl) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_CursorTreeAdapter$init(android.database.Cursor android.content.Context boolean ), this, cursor, context, bl);
    }

    synchronized MyCursorHelper getChildrenCursorHelper(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getChildrenCursorHelper", $$robo$$android_widget_CursorTreeAdapter$getChildrenCursorHelper(int boolean ), this, n, bl);
    }

    public void setGroupCursor(Cursor cursor) {
        InvokeDynamicSupport.bootstrap("setGroupCursor", $$robo$$android_widget_CursorTreeAdapter$setGroupCursor(android.database.Cursor ), this, cursor);
    }

    public void setChildrenCursor(int n, Cursor cursor) {
        InvokeDynamicSupport.bootstrap("setChildrenCursor", $$robo$$android_widget_CursorTreeAdapter$setChildrenCursor(int android.database.Cursor ), this, n, cursor);
    }

    @Override
    public Cursor getChild(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getChild", $$robo$$android_widget_CursorTreeAdapter$getChild(int int ), this, n, n2);
    }

    @Override
    public long getChildId(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getChildId", $$robo$$android_widget_CursorTreeAdapter$getChildId(int int ), this, n, n2);
    }

    @Override
    public int getChildrenCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getChildrenCount", $$robo$$android_widget_CursorTreeAdapter$getChildrenCount(int ), this, n);
    }

    @Override
    public Cursor getGroup(int n) {
        return InvokeDynamicSupport.bootstrap("getGroup", $$robo$$android_widget_CursorTreeAdapter$getGroup(int ), this, n);
    }

    @Override
    public int getGroupCount() {
        return (int)InvokeDynamicSupport.bootstrap("getGroupCount", $$robo$$android_widget_CursorTreeAdapter$getGroupCount(), this);
    }

    @Override
    public long getGroupId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getGroupId", $$robo$$android_widget_CursorTreeAdapter$getGroupId(int ), this, n);
    }

    @Override
    public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getGroupView", $$robo$$android_widget_CursorTreeAdapter$getGroupView(int boolean android.view.View android.view.ViewGroup ), this, n, bl, view, viewGroup);
    }

    @Override
    public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getChildView", $$robo$$android_widget_CursorTreeAdapter$getChildView(int int boolean android.view.View android.view.ViewGroup ), this, n, n2, bl, view, viewGroup);
    }

    @Override
    public boolean isChildSelectable(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isChildSelectable", $$robo$$android_widget_CursorTreeAdapter$isChildSelectable(int int ), this, n, n2);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_CursorTreeAdapter$hasStableIds(), this);
    }

    private synchronized void releaseCursorHelpers() {
        InvokeDynamicSupport.bootstrap("releaseCursorHelpers", $$robo$$android_widget_CursorTreeAdapter$releaseCursorHelpers(), this);
    }

    @Override
    public void notifyDataSetChanged() {
        InvokeDynamicSupport.bootstrap("notifyDataSetChanged", $$robo$$android_widget_CursorTreeAdapter$notifyDataSetChanged(), this);
    }

    public void notifyDataSetChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyDataSetChanged", $$robo$$android_widget_CursorTreeAdapter$notifyDataSetChanged(boolean ), this, bl);
    }

    @Override
    public void notifyDataSetInvalidated() {
        InvokeDynamicSupport.bootstrap("notifyDataSetInvalidated", $$robo$$android_widget_CursorTreeAdapter$notifyDataSetInvalidated(), this);
    }

    @Override
    public void onGroupCollapsed(int n) {
        InvokeDynamicSupport.bootstrap("onGroupCollapsed", $$robo$$android_widget_CursorTreeAdapter$onGroupCollapsed(int ), this, n);
    }

    synchronized void deactivateChildrenCursorHelper(int n) {
        InvokeDynamicSupport.bootstrap("deactivateChildrenCursorHelper", $$robo$$android_widget_CursorTreeAdapter$deactivateChildrenCursorHelper(int ), this, n);
    }

    @Override
    public String convertToString(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("convertToString", $$robo$$android_widget_CursorTreeAdapter$convertToString(android.database.Cursor ), this, cursor);
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("runQueryOnBackgroundThread", $$robo$$android_widget_CursorTreeAdapter$runQueryOnBackgroundThread(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public Filter getFilter() {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_widget_CursorTreeAdapter$getFilter(), this);
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return InvokeDynamicSupport.bootstrap("getFilterQueryProvider", $$robo$$android_widget_CursorTreeAdapter$getFilterQueryProvider(), this);
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        InvokeDynamicSupport.bootstrap("setFilterQueryProvider", $$robo$$android_widget_CursorTreeAdapter$setFilterQueryProvider(android.widget.FilterQueryProvider ), this, filterQueryProvider);
    }

    @Override
    public void changeCursor(Cursor cursor) {
        InvokeDynamicSupport.bootstrap("changeCursor", $$robo$$android_widget_CursorTreeAdapter$changeCursor(android.database.Cursor ), this, cursor);
    }

    @Override
    public Cursor getCursor() {
        return InvokeDynamicSupport.bootstrap("getCursor", $$robo$$android_widget_CursorTreeAdapter$getCursor(), this);
    }

    public /* synthetic */ CursorTreeAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorTreeAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyCursorHelper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Cursor mCursor;
        private boolean mDataValid;
        private int mRowIDColumn;
        private MyContentObserver mContentObserver;
        private MyDataSetObserver mDataSetObserver;
        /* synthetic */ CursorTreeAdapter this$0;

        private void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$__constructor__(CursorTreeAdapter this$0, Cursor cursor) {
            this.this$0 = this$0;
            boolean cursorPresent = cursor != null;
            this.mCursor = cursor;
            this.mDataValid = cursorPresent;
            this.mRowIDColumn = cursorPresent ? cursor.getColumnIndex("_id") : -1;
            this.mContentObserver = new MyContentObserver(this);
            this.mDataSetObserver = new MyDataSetObserver(this, null);
            if (cursorPresent) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
            }
        }

        private final Cursor $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$getCursor() {
            return this.mCursor;
        }

        private final int $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$getCount() {
            if (this.mDataValid && this.mCursor != null) {
                return this.mCursor.getCount();
            }
            return 0;
        }

        private final long $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$getId(int position) {
            if (this.mDataValid && this.mCursor != null) {
                if (this.mCursor.moveToPosition(position)) {
                    return this.mCursor.getLong(this.mRowIDColumn);
                }
                return 0L;
            }
            return 0L;
        }

        private final Cursor $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$moveTo(int position) {
            if (this.mDataValid && this.mCursor != null && this.mCursor.moveToPosition(position)) {
                return this.mCursor;
            }
            return null;
        }

        private final void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$changeCursor(Cursor cursor, boolean releaseCursors) {
            if (cursor == this.mCursor) {
                return;
            }
            this.deactivate();
            this.mCursor = cursor;
            if (cursor != null) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
                this.mRowIDColumn = cursor.getColumnIndex("_id");
                this.mDataValid = true;
                this.this$0.notifyDataSetChanged(releaseCursors);
            } else {
                this.mRowIDColumn = -1;
                this.mDataValid = false;
                this.this$0.notifyDataSetInvalidated();
            }
        }

        private final void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$deactivate() {
            if (this.mCursor == null) {
                return;
            }
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.close();
            this.mCursor = null;
        }

        private final boolean $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$isValid() {
            return this.mDataValid && this.mCursor != null;
        }

        private void __constructor__(CursorTreeAdapter cursorTreeAdapter, Cursor cursor) {
            this.$$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$__constructor__(cursorTreeAdapter, cursor);
        }

        public MyCursorHelper(CursorTreeAdapter cursorTreeAdapter, Cursor cursor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$__constructor__(android.widget.CursorTreeAdapter android.database.Cursor ), this, cursorTreeAdapter, cursor);
        }

        Cursor getCursor() {
            return InvokeDynamicSupport.bootstrap("getCursor", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$getCursor(), this);
        }

        int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$getCount(), this);
        }

        long getId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$getId(int ), this, n);
        }

        Cursor moveTo(int n) {
            return InvokeDynamicSupport.bootstrap("moveTo", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$moveTo(int ), this, n);
        }

        void changeCursor(Cursor cursor, boolean bl) {
            InvokeDynamicSupport.bootstrap("changeCursor", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$changeCursor(android.database.Cursor boolean ), this, cursor, bl);
        }

        void deactivate() {
            InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$deactivate(), this);
        }

        boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper$isValid(), this);
        }

        public /* synthetic */ MyCursorHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyCursorHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class MyDataSetObserver
        extends DataSetObserver
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MyCursorHelper this$1;

            private void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$__constructor__(MyCursorHelper myCursorHelper) {
                this.this$1 = myCursorHelper;
            }

            private final void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$onChanged() {
                this.this$1.mDataValid = true;
                this.this$1.this$0.notifyDataSetChanged();
            }

            private final void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$onInvalidated() {
                this.this$1.mDataValid = false;
                this.this$1.this$0.notifyDataSetInvalidated();
            }

            private /* synthetic */ void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$__constructor__(MyCursorHelper x0, 1 x1) {
            }

            private void __constructor__(MyCursorHelper myCursorHelper) {
                this.$$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$__constructor__(myCursorHelper);
            }

            public MyDataSetObserver(MyCursorHelper myCursorHelper) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$__constructor__(android.widget.CursorTreeAdapter$MyCursorHelper ), this, myCursorHelper);
            }

            @Override
            public void onChanged() {
                InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$onChanged(), this);
            }

            @Override
            public void onInvalidated() {
                InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$onInvalidated(), this);
            }

            private /* synthetic */ void __constructor__(MyCursorHelper myCursorHelper, 1 var2_2) {
                this.$$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$__constructor__(myCursorHelper, var2_2);
            }

            public /* synthetic */ MyDataSetObserver(MyCursorHelper myCursorHelper, 1 var2_2) {
                this(myCursorHelper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyDataSetObserver$__constructor__(android.widget.CursorTreeAdapter$MyCursorHelper android.widget.CursorTreeAdapter$1 ), this, myCursorHelper, var2_2);
            }

            public /* synthetic */ MyDataSetObserver() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyDataSetObserver)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class MyContentObserver
        extends ContentObserver
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MyCursorHelper this$1;

            private void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$__constructor__(MyCursorHelper myCursorHelper) {
                this.this$1 = myCursorHelper;
            }

            private final boolean $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$deliverSelfNotifications() {
                return true;
            }

            private final void $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$onChange(boolean selfChange) {
                if (this.this$1.this$0.mAutoRequery && this.this$1.mCursor != null && !this.this$1.mCursor.isClosed()) {
                    this.this$1.mDataValid = this.this$1.mCursor.requery();
                }
            }

            private void __constructor__(MyCursorHelper myCursorHelper) {
                this.$$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$__constructor__(myCursorHelper);
            }

            public MyContentObserver(MyCursorHelper myCursorHelper) {
                super(myCursorHelper.this$0.mHandler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$__constructor__(android.widget.CursorTreeAdapter$MyCursorHelper ), this, myCursorHelper);
            }

            @Override
            public boolean deliverSelfNotifications() {
                return (boolean)InvokeDynamicSupport.bootstrap("deliverSelfNotifications", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$deliverSelfNotifications(), this);
            }

            @Override
            public void onChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_widget_CursorTreeAdapter_MyCursorHelper_MyContentObserver$onChange(boolean ), this, bl);
            }

            public /* synthetic */ MyContentObserver() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyContentObserver)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

