/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ActionMenuView;
import android.widget.ImageButton;
import com.android.internal.view.ActionBarPolicy;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BaseMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPopupHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.ShowableListMenu;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionMenuPresenter
extends BaseMenuPresenter
implements ActionProvider.SubUiVisibilityListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int ITEM_ANIMATION_DURATION = 150;
    private static boolean ACTIONBAR_ANIMATIONS_ENABLED = false;
    private OverflowMenuButton mOverflowButton;
    private Drawable mPendingOverflowIcon;
    private boolean mPendingOverflowIconSet;
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet;
    private int mWidthLimit;
    private int mActionItemWidthLimit;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private boolean mStrictWidthLimit;
    private boolean mWidthLimitSet;
    private boolean mExpandedActionViewsExclusive;
    private int mMinCellSize;
    private SparseBooleanArray mActionButtonGroups;
    private OverflowPopup mOverflowPopup;
    private ActionButtonSubmenu mActionButtonPopup;
    private OpenOverflowRunnable mPostedOpenRunnable;
    private ActionMenuPopupCallback mPopupCallback;
    PopupPresenterCallback mPopupPresenterCallback;
    int mOpenSubMenuId;
    private SparseArray<MenuItemLayoutInfo> mPreLayoutItems;
    private SparseArray<MenuItemLayoutInfo> mPostLayoutItems;
    private List<ItemAnimationInfo> mRunningItemAnimations;
    private ViewTreeObserver.OnPreDrawListener mItemAnimationPreDrawListener;
    private View.OnAttachStateChangeListener mAttachStateChangeListener;

    private void $$robo$$android_widget_ActionMenuPresenter$__constructor__(Context context) {
        this.mActionButtonGroups = new SparseBooleanArray();
        this.mPopupPresenterCallback = new PopupPresenterCallback(this, null);
        this.mPreLayoutItems = new SparseArray();
        this.mPostLayoutItems = new SparseArray();
        this.mRunningItemAnimations = new ArrayList<ItemAnimationInfo>();
        this.mItemAnimationPreDrawListener = new ViewTreeObserver.OnPreDrawListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionMenuPresenter this$0;

            private void $$robo$$android_widget_ActionMenuPresenter_1$__constructor__(ActionMenuPresenter this$0) {
                this.this$0 = this$0;
            }

            private final boolean $$robo$$android_widget_ActionMenuPresenter_1$onPreDraw() {
                this.this$0.computeMenuItemAnimationInfo(false);
                ((View)((Object)this.this$0.mMenuView)).getViewTreeObserver().removeOnPreDrawListener(this);
                this.this$0.runItemAnimations();
                return true;
            }

            private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
                this.$$robo$$android_widget_ActionMenuPresenter_1$__constructor__(actionMenuPresenter);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_1$__constructor__(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
            }

            @Override
            public boolean onPreDraw() {
                return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_widget_ActionMenuPresenter_1$onPreDraw(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAttachStateChangeListener = new View.OnAttachStateChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionMenuPresenter this$0;

            private void $$robo$$android_widget_ActionMenuPresenter_2$__constructor__(ActionMenuPresenter this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_ActionMenuPresenter_2$onViewAttachedToWindow(View v) {
            }

            private final void $$robo$$android_widget_ActionMenuPresenter_2$onViewDetachedFromWindow(View v) {
                ((View)((Object)this.this$0.mMenuView)).getViewTreeObserver().removeOnPreDrawListener(this.this$0.mItemAnimationPreDrawListener);
                this.this$0.mPreLayoutItems.clear();
                this.this$0.mPostLayoutItems.clear();
            }

            private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
                this.$$robo$$android_widget_ActionMenuPresenter_2$__constructor__(actionMenuPresenter);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_2$__constructor__(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
            }

            @Override
            public void onViewAttachedToWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_widget_ActionMenuPresenter_2$onViewAttachedToWindow(android.view.View ), this, view);
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_widget_ActionMenuPresenter_2$onViewDetachedFromWindow(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$initForMenu(Context context, MenuBuilder menu2) {
        super.initForMenu(context, menu2);
        Resources res = context.getResources();
        ActionBarPolicy abp = ActionBarPolicy.get(context);
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = abp.showsOverflowMenuButton();
        }
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = abp.getEmbeddedMenuWidthLimit();
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = abp.getMaxActionButtons();
        }
        int width = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this, this.mSystemContext);
                if (this.mPendingOverflowIconSet) {
                    this.mOverflowButton.setImageDrawable(this.mPendingOverflowIcon);
                    this.mPendingOverflowIcon = null;
                    this.mPendingOverflowIconSet = false;
                }
                int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.mOverflowButton.measure(spec, spec);
            }
            width -= this.mOverflowButton.getMeasuredWidth();
        } else {
            this.mOverflowButton = null;
        }
        this.mActionItemWidthLimit = width;
        this.mMinCellSize = (int)(56.0f * res.getDisplayMetrics().density);
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onConfigurationChanged(Configuration newConfig) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = ActionBarPolicy.get(this.mContext).getMaxActionButtons();
        }
        if (this.mMenu != null) {
            this.mMenu.onItemsChanged(true);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setWidthLimit(int width, boolean strict) {
        this.mWidthLimit = width;
        this.mStrictWidthLimit = strict;
        this.mWidthLimitSet = true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setReserveOverflow(boolean reserveOverflow) {
        this.mReserveOverflow = reserveOverflow;
        this.mReserveOverflowSet = true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setItemLimit(int itemCount) {
        this.mMaxItems = itemCount;
        this.mMaxItemsSet = true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setExpandedActionViewsExclusive(boolean isExclusive) {
        this.mExpandedActionViewsExclusive = isExclusive;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setOverflowIcon(Drawable icon) {
        if (this.mOverflowButton != null) {
            this.mOverflowButton.setImageDrawable(icon);
        } else {
            this.mPendingOverflowIconSet = true;
            this.mPendingOverflowIcon = icon;
        }
    }

    private final Drawable $$robo$$android_widget_ActionMenuPresenter$getOverflowIcon() {
        if (this.mOverflowButton != null) {
            return this.mOverflowButton.getDrawable();
        }
        if (this.mPendingOverflowIconSet) {
            return this.mPendingOverflowIcon;
        }
        return null;
    }

    private final MenuView $$robo$$android_widget_ActionMenuPresenter$getMenuView(ViewGroup root) {
        MenuView oldMenuView = this.mMenuView;
        MenuView result = super.getMenuView(root);
        if (oldMenuView != result) {
            ((ActionMenuView)result).setPresenter(this);
            if (oldMenuView != null) {
                ((View)((Object)oldMenuView)).removeOnAttachStateChangeListener(this.mAttachStateChangeListener);
            }
            ((View)((Object)result)).addOnAttachStateChangeListener(this.mAttachStateChangeListener);
        }
        return result;
    }

    private final View $$robo$$android_widget_ActionMenuPresenter$getItemView(MenuItemImpl item, View convertView, ViewGroup parent) {
        View actionView = item.getActionView();
        if (actionView == null || item.hasCollapsibleActionView()) {
            actionView = super.getItemView(item, convertView, parent);
        }
        actionView.setVisibility(item.isActionViewExpanded() ? 8 : 0);
        ActionMenuView menuParent = (ActionMenuView)parent;
        ViewGroup.LayoutParams lp = actionView.getLayoutParams();
        if (!menuParent.checkLayoutParams(lp)) {
            actionView.setLayoutParams(menuParent.generateLayoutParams(lp));
        }
        return actionView;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$bindItemView(MenuItemImpl item, MenuView.ItemView itemView) {
        itemView.initialize(item, 0);
        ActionMenuView menuView = (ActionMenuView)this.mMenuView;
        ActionMenuItemView actionItemView = (ActionMenuItemView)itemView;
        actionItemView.setItemInvoker(menuView);
        if (this.mPopupCallback == null) {
            this.mPopupCallback = new ActionMenuPopupCallback(this, null);
        }
        actionItemView.setPopupCallback(this.mPopupCallback);
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$shouldIncludeItem(int childIndex, MenuItemImpl item) {
        return item.isActionButton();
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$computeMenuItemAnimationInfo(boolean preLayout) {
        ViewGroup menuView = (ViewGroup)((Object)this.mMenuView);
        int count = menuView.getChildCount();
        SparseArray<MenuItemLayoutInfo> items = preLayout ? this.mPreLayoutItems : this.mPostLayoutItems;
        for (int i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            int id2 = child.getId();
            if (id2 <= 0 || child.getWidth() == 0 || child.getHeight() == 0) continue;
            MenuItemLayoutInfo info = new MenuItemLayoutInfo(child, preLayout);
            items.put(id2, info);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$runItemAnimations() {
        ItemAnimationInfo info;
        ObjectAnimator anim2;
        ItemAnimationInfo oldInfo;
        int id2;
        int i;
        for (i = 0; i < this.mPreLayoutItems.size(); ++i) {
            id2 = this.mPreLayoutItems.keyAt(i);
            MenuItemLayoutInfo menuItemLayoutInfoPre = this.mPreLayoutItems.get(id2);
            int postLayoutIndex = this.mPostLayoutItems.indexOfKey(id2);
            if (postLayoutIndex >= 0) {
                MenuItemLayoutInfo menuItemLayoutInfoPost = this.mPostLayoutItems.valueAt(postLayoutIndex);
                PropertyValuesHolder pvhX = null;
                PropertyValuesHolder pvhY = null;
                if (menuItemLayoutInfoPre.left != menuItemLayoutInfoPost.left) {
                    pvhX = PropertyValuesHolder.ofFloat(View.TRANSLATION_X, menuItemLayoutInfoPre.left - menuItemLayoutInfoPost.left, 0.0f);
                }
                if (menuItemLayoutInfoPre.top != menuItemLayoutInfoPost.top) {
                    pvhY = PropertyValuesHolder.ofFloat(View.TRANSLATION_Y, menuItemLayoutInfoPre.top - menuItemLayoutInfoPost.top, 0.0f);
                }
                if (pvhX != null || pvhY != null) {
                    for (int j = 0; j < this.mRunningItemAnimations.size(); ++j) {
                        ItemAnimationInfo oldInfo2 = this.mRunningItemAnimations.get(j);
                        if (oldInfo2.id != id2 || oldInfo2.animType != 0) continue;
                        oldInfo2.animator.cancel();
                    }
                    ObjectAnimator anim3 = pvhX != null ? (pvhY != null ? ObjectAnimator.ofPropertyValuesHolder(menuItemLayoutInfoPost.view, pvhX, pvhY) : ObjectAnimator.ofPropertyValuesHolder(menuItemLayoutInfoPost.view, pvhX)) : ObjectAnimator.ofPropertyValuesHolder(menuItemLayoutInfoPost.view, pvhY);
                    anim3.setDuration(150L);
                    anim3.start();
                    ItemAnimationInfo info2 = new ItemAnimationInfo(id2, menuItemLayoutInfoPost, anim3, 0);
                    this.mRunningItemAnimations.add(info2);
                    anim3.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ ActionMenuPresenter this$0;

                        private void $$robo$$android_widget_ActionMenuPresenter_3$__constructor__(ActionMenuPresenter this$0) {
                            this.this$0 = this$0;
                        }

                        private final void $$robo$$android_widget_ActionMenuPresenter_3$onAnimationEnd(Animator animation) {
                            for (int j = 0; j < this.this$0.mRunningItemAnimations.size(); ++j) {
                                if (((ItemAnimationInfo)((ActionMenuPresenter)this.this$0).mRunningItemAnimations.get((int)j)).animator != animation) continue;
                                this.this$0.mRunningItemAnimations.remove(j);
                                break;
                            }
                        }

                        private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
                            this.$$robo$$android_widget_ActionMenuPresenter_3$__constructor__(actionMenuPresenter);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_3$__constructor__(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
                        }

                        @Override
                        public void onAnimationEnd(Animator animator2) {
                            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_widget_ActionMenuPresenter_3$onAnimationEnd(android.animation.Animator ), this, animator2);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
                this.mPostLayoutItems.remove(id2);
                continue;
            }
            float oldAlpha = 1.0f;
            for (int j = 0; j < this.mRunningItemAnimations.size(); ++j) {
                oldInfo = this.mRunningItemAnimations.get(j);
                if (oldInfo.id != id2 || oldInfo.animType != 1) continue;
                oldAlpha = oldInfo.menuItemLayoutInfo.view.getAlpha();
                oldInfo.animator.cancel();
            }
            anim2 = ObjectAnimator.ofFloat(menuItemLayoutInfoPre.view, View.ALPHA, oldAlpha, 0.0f);
            ((ViewGroupOverlay)((ViewGroup)((Object)this.mMenuView)).getOverlay()).add(menuItemLayoutInfoPre.view);
            anim2.setDuration(150L);
            anim2.start();
            info = new ItemAnimationInfo(id2, menuItemLayoutInfoPre, anim2, 2);
            this.mRunningItemAnimations.add(info);
            anim2.addListener((Animator.AnimatorListener)new ShadowedObject(this, menuItemLayoutInfoPre){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MenuItemLayoutInfo val$menuItemLayoutInfoPre;
                /* synthetic */ ActionMenuPresenter this$0;

                private void $$robo$$android_widget_ActionMenuPresenter_4$__constructor__(ActionMenuPresenter this$0, MenuItemLayoutInfo menuItemLayoutInfo) {
                    this.this$0 = this$0;
                    this.val$menuItemLayoutInfoPre = menuItemLayoutInfo;
                }

                private final void $$robo$$android_widget_ActionMenuPresenter_4$onAnimationEnd(Animator animation) {
                    for (int j = 0; j < this.this$0.mRunningItemAnimations.size(); ++j) {
                        if (((ItemAnimationInfo)((ActionMenuPresenter)this.this$0).mRunningItemAnimations.get((int)j)).animator != animation) continue;
                        this.this$0.mRunningItemAnimations.remove(j);
                        break;
                    }
                    ((ViewGroupOverlay)((ViewGroup)((Object)this.this$0.mMenuView)).getOverlay()).remove(this.val$menuItemLayoutInfoPre.view);
                }

                private void __constructor__(ActionMenuPresenter actionMenuPresenter, MenuItemLayoutInfo menuItemLayoutInfo) {
                    this.$$robo$$android_widget_ActionMenuPresenter_4$__constructor__(actionMenuPresenter, menuItemLayoutInfo);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_4$__constructor__(android.widget.ActionMenuPresenter android.widget.ActionMenuPresenter$MenuItemLayoutInfo ), this, actionMenuPresenter, menuItemLayoutInfo);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_widget_ActionMenuPresenter_4$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        for (i = 0; i < this.mPostLayoutItems.size(); ++i) {
            id2 = this.mPostLayoutItems.keyAt(i);
            int postLayoutIndex = this.mPostLayoutItems.indexOfKey(id2);
            if (postLayoutIndex < 0) continue;
            MenuItemLayoutInfo menuItemLayoutInfo = this.mPostLayoutItems.valueAt(postLayoutIndex);
            float oldAlpha = 0.0f;
            for (int j = 0; j < this.mRunningItemAnimations.size(); ++j) {
                oldInfo = this.mRunningItemAnimations.get(j);
                if (oldInfo.id != id2 || oldInfo.animType != 2) continue;
                oldAlpha = oldInfo.menuItemLayoutInfo.view.getAlpha();
                oldInfo.animator.cancel();
            }
            anim2 = ObjectAnimator.ofFloat(menuItemLayoutInfo.view, View.ALPHA, oldAlpha, 1.0f);
            anim2.start();
            anim2.setDuration(150L);
            info = new ItemAnimationInfo(id2, menuItemLayoutInfo, anim2, 1);
            this.mRunningItemAnimations.add(info);
            anim2.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ActionMenuPresenter this$0;

                private void $$robo$$android_widget_ActionMenuPresenter_5$__constructor__(ActionMenuPresenter this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_widget_ActionMenuPresenter_5$onAnimationEnd(Animator animation) {
                    for (int j = 0; j < this.this$0.mRunningItemAnimations.size(); ++j) {
                        if (((ItemAnimationInfo)((ActionMenuPresenter)this.this$0).mRunningItemAnimations.get((int)j)).animator != animation) continue;
                        this.this$0.mRunningItemAnimations.remove(j);
                        break;
                    }
                }

                private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
                    this.$$robo$$android_widget_ActionMenuPresenter_5$__constructor__(actionMenuPresenter);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_5$__constructor__(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_widget_ActionMenuPresenter_5$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        this.mPreLayoutItems.clear();
        this.mPostLayoutItems.clear();
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setupItemAnimations() {
        this.computeMenuItemAnimationInfo(true);
        ((View)((Object)this.mMenuView)).getViewTreeObserver().addOnPreDrawListener(this.mItemAnimationPreDrawListener);
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$updateMenuView(boolean cleared) {
        ViewGroup menuViewParent = (ViewGroup)((View)((Object)this.mMenuView)).getParent();
        if (menuViewParent != null) {
            // empty if block
        }
        super.updateMenuView(cleared);
        ((View)((Object)this.mMenuView)).requestLayout();
        if (this.mMenu != null) {
            ArrayList<MenuItemImpl> actionItems = this.mMenu.getActionItems();
            int count = actionItems.size();
            for (int i = 0; i < count; ++i) {
                ActionProvider provider = actionItems.get(i).getActionProvider();
                if (provider == null) continue;
                provider.setSubUiVisibilityListener(this);
            }
        }
        ArrayList<MenuItemImpl> nonActionItems = this.mMenu != null ? this.mMenu.getNonActionItems() : null;
        boolean hasOverflow = false;
        if (this.mReserveOverflow && nonActionItems != null) {
            int count = nonActionItems.size();
            if (count == 1) {
                hasOverflow = !nonActionItems.get(0).isActionViewExpanded();
            } else {
                boolean bl = hasOverflow = count > 0;
            }
        }
        if (hasOverflow) {
            ViewGroup parent;
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this, this.mSystemContext);
            }
            if ((parent = (ViewGroup)this.mOverflowButton.getParent()) != this.mMenuView) {
                if (parent != null) {
                    parent.removeView(this.mOverflowButton);
                }
                ActionMenuView menuView = (ActionMenuView)this.mMenuView;
                menuView.addView((View)this.mOverflowButton, menuView.generateOverflowButtonLayoutParams());
            }
        } else if (this.mOverflowButton != null && this.mOverflowButton.getParent() == this.mMenuView) {
            ((ViewGroup)((Object)this.mMenuView)).removeView(this.mOverflowButton);
        }
        ((ActionMenuView)this.mMenuView).setOverflowReserved(this.mReserveOverflow);
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$filterLeftoverView(ViewGroup parent, int childIndex) {
        if (parent.getChildAt(childIndex) == this.mOverflowButton) {
            return false;
        }
        return super.filterLeftoverView(parent, childIndex);
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$onSubMenuSelected(SubMenuBuilder subMenu) {
        if (!subMenu.hasVisibleItems()) {
            return false;
        }
        SubMenuBuilder topSubMenu = subMenu;
        while (topSubMenu.getParentMenu() != this.mMenu) {
            topSubMenu = (SubMenuBuilder)topSubMenu.getParentMenu();
        }
        View anchor = this.findViewForItem(topSubMenu.getItem());
        if (anchor == null) {
            return false;
        }
        this.mOpenSubMenuId = subMenu.getItem().getItemId();
        boolean preserveIconSpacing = false;
        int count = subMenu.size();
        for (int i = 0; i < count; ++i) {
            MenuItem childItem = subMenu.getItem(i);
            if (!childItem.isVisible() || childItem.getIcon() == null) continue;
            preserveIconSpacing = true;
            break;
        }
        this.mActionButtonPopup = new ActionButtonSubmenu(this, this.mContext, subMenu, anchor);
        this.mActionButtonPopup.setForceShowIcon(preserveIconSpacing);
        this.mActionButtonPopup.show();
        super.onSubMenuSelected(subMenu);
        return true;
    }

    private final View $$robo$$android_widget_ActionMenuPresenter$findViewForItem(MenuItem item) {
        ViewGroup parent = (ViewGroup)((Object)this.mMenuView);
        if (parent == null) {
            return null;
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            if (!(child instanceof MenuView.ItemView) || ((MenuView.ItemView)((Object)child)).getItemData() != item) continue;
            return child;
        }
        return null;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$showOverflowMenu() {
        if (this.mReserveOverflow && !this.isOverflowMenuShowing() && this.mMenu != null && this.mMenuView != null && this.mPostedOpenRunnable == null && !this.mMenu.getNonActionItems().isEmpty()) {
            OverflowPopup popup = new OverflowPopup(this, this.mContext, this.mMenu, this.mOverflowButton, true);
            this.mPostedOpenRunnable = new OpenOverflowRunnable(this, popup);
            ((View)((Object)this.mMenuView)).post(this.mPostedOpenRunnable);
            super.onSubMenuSelected(null);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null && this.mMenuView != null) {
            ((View)((Object)this.mMenuView)).removeCallbacks(this.mPostedOpenRunnable);
            this.mPostedOpenRunnable = null;
            return true;
        }
        OverflowPopup popup = this.mOverflowPopup;
        if (popup != null) {
            popup.dismiss();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$dismissPopupMenus() {
        boolean result = this.hideOverflowMenu();
        return result |= this.hideSubMenus();
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$hideSubMenus() {
        if (this.mActionButtonPopup != null) {
            this.mActionButtonPopup.dismiss();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowing() {
        return this.mOverflowPopup != null && this.mOverflowPopup.isShowing();
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowPending() {
        return this.mPostedOpenRunnable != null || this.isOverflowMenuShowing();
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$isOverflowReserved() {
        return this.mReserveOverflow;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$flagActionItems() {
        int itemsSize;
        ArrayList<MenuItemImpl> visibleItems;
        if (this.mMenu != null) {
            visibleItems = this.mMenu.getVisibleItems();
            itemsSize = visibleItems.size();
        } else {
            visibleItems = null;
            itemsSize = 0;
        }
        int maxActions = this.mMaxItems;
        int widthLimit = this.mActionItemWidthLimit;
        int querySpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        ViewGroup parent = (ViewGroup)((Object)this.mMenuView);
        int requiredItems = 0;
        int requestedItems = 0;
        int firstActionWidth = 0;
        boolean hasOverflow = false;
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = visibleItems.get(i);
            if (item.requiresActionButton()) {
                ++requiredItems;
            } else if (item.requestsActionButton()) {
                ++requestedItems;
            } else {
                hasOverflow = true;
            }
            if (!this.mExpandedActionViewsExclusive || !item.isActionViewExpanded()) continue;
            maxActions = 0;
        }
        if (this.mReserveOverflow && (hasOverflow || requiredItems + requestedItems > maxActions)) {
            --maxActions;
        }
        maxActions -= requiredItems;
        SparseBooleanArray seenGroups = this.mActionButtonGroups;
        seenGroups.clear();
        int cellSize = 0;
        int cellsRemaining = 0;
        if (this.mStrictWidthLimit) {
            cellsRemaining = widthLimit / this.mMinCellSize;
            int cellSizeRemaining = widthLimit % this.mMinCellSize;
            cellSize = this.mMinCellSize + cellSizeRemaining / cellsRemaining;
        }
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = visibleItems.get(i);
            if (item.requiresActionButton()) {
                int groupId;
                View v = this.getItemView(item, null, parent);
                if (this.mStrictWidthLimit) {
                    cellsRemaining -= ActionMenuView.measureChildForCells(v, cellSize, cellsRemaining, querySpec, 0);
                } else {
                    v.measure(querySpec, querySpec);
                }
                int measuredWidth = v.getMeasuredWidth();
                widthLimit -= measuredWidth;
                if (firstActionWidth == 0) {
                    firstActionWidth = measuredWidth;
                }
                if ((groupId = item.getGroupId()) != 0) {
                    seenGroups.put(groupId, true);
                }
                item.setIsActionButton(true);
                continue;
            }
            if (item.requestsActionButton()) {
                boolean isAction;
                int groupId = item.getGroupId();
                boolean inGroup = seenGroups.get(groupId);
                boolean bl = isAction = !(maxActions <= 0 && !inGroup || widthLimit <= 0 || this.mStrictWidthLimit && cellsRemaining <= 0);
                if (isAction) {
                    View v = this.getItemView(item, null, parent);
                    if (this.mStrictWidthLimit) {
                        int cells = ActionMenuView.measureChildForCells(v, cellSize, cellsRemaining, querySpec, 0);
                        cellsRemaining -= cells;
                        if (cells == 0) {
                            isAction = false;
                        }
                    } else {
                        v.measure(querySpec, querySpec);
                    }
                    int measuredWidth = v.getMeasuredWidth();
                    widthLimit -= measuredWidth;
                    if (firstActionWidth == 0) {
                        firstActionWidth = measuredWidth;
                    }
                    isAction = this.mStrictWidthLimit ? (isAction &= widthLimit >= 0) : (isAction &= widthLimit + firstActionWidth > 0);
                }
                if (isAction && groupId != 0) {
                    seenGroups.put(groupId, true);
                } else if (inGroup) {
                    seenGroups.put(groupId, false);
                    for (int j = 0; j < i; ++j) {
                        MenuItemImpl areYouMyGroupie = visibleItems.get(j);
                        if (areYouMyGroupie.getGroupId() != groupId) continue;
                        if (areYouMyGroupie.isActionButton()) {
                            ++maxActions;
                        }
                        areYouMyGroupie.setIsActionButton(false);
                    }
                }
                if (isAction) {
                    --maxActions;
                }
                item.setIsActionButton(isAction);
                continue;
            }
            item.setIsActionButton(false);
        }
        return true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        this.dismissPopupMenus();
        super.onCloseMenu(menu2, allMenusAreClosing);
    }

    private final Parcelable $$robo$$android_widget_ActionMenuPresenter$onSaveInstanceState() {
        SavedState state = new SavedState();
        state.openSubMenuId = this.mOpenSubMenuId;
        return state;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onRestoreInstanceState(Parcelable state) {
        MenuItem item;
        SavedState saved = (SavedState)state;
        if (saved.openSubMenuId > 0 && (item = this.mMenu.findItem(saved.openSubMenuId)) != null) {
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            this.onSubMenuSelected(subMenu);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onSubUiVisibilityChanged(boolean isVisible) {
        if (isVisible) {
            super.onSubMenuSelected(null);
        } else if (this.mMenu != null) {
            this.mMenu.close(false);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setMenuView(ActionMenuView menuView) {
        if (menuView != this.mMenuView) {
            if (this.mMenuView != null) {
                ((View)((Object)this.mMenuView)).removeOnAttachStateChangeListener(this.mAttachStateChangeListener);
            }
            this.mMenuView = menuView;
            menuView.initialize(this.mMenu);
            menuView.addOnAttachStateChangeListener(this.mAttachStateChangeListener);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ActionMenuPresenter$__constructor__(context);
    }

    public ActionMenuPresenter(Context context) {
        super(context, 17367071, 17367070);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter$__constructor__(android.content.Context ), this, context);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initForMenu", $$robo$$android_widget_ActionMenuPresenter$initForMenu(android.content.Context com.android.internal.view.menu.MenuBuilder ), this, context, menuBuilder);
    }

    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_ActionMenuPresenter$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    public void setWidthLimit(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setWidthLimit", $$robo$$android_widget_ActionMenuPresenter$setWidthLimit(int boolean ), this, n, bl);
    }

    public void setReserveOverflow(boolean bl) {
        InvokeDynamicSupport.bootstrap("setReserveOverflow", $$robo$$android_widget_ActionMenuPresenter$setReserveOverflow(boolean ), this, bl);
    }

    public void setItemLimit(int n) {
        InvokeDynamicSupport.bootstrap("setItemLimit", $$robo$$android_widget_ActionMenuPresenter$setItemLimit(int ), this, n);
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExpandedActionViewsExclusive", $$robo$$android_widget_ActionMenuPresenter$setExpandedActionViewsExclusive(boolean ), this, bl);
    }

    public void setOverflowIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setOverflowIcon", $$robo$$android_widget_ActionMenuPresenter$setOverflowIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public Drawable getOverflowIcon() {
        return InvokeDynamicSupport.bootstrap("getOverflowIcon", $$robo$$android_widget_ActionMenuPresenter$getOverflowIcon(), this);
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getMenuView", $$robo$$android_widget_ActionMenuPresenter$getMenuView(android.view.ViewGroup ), this, viewGroup);
    }

    @Override
    public View getItemView(MenuItemImpl menuItemImpl, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getItemView", $$robo$$android_widget_ActionMenuPresenter$getItemView(com.android.internal.view.menu.MenuItemImpl android.view.View android.view.ViewGroup ), this, menuItemImpl, view, viewGroup);
    }

    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        InvokeDynamicSupport.bootstrap("bindItemView", $$robo$$android_widget_ActionMenuPresenter$bindItemView(com.android.internal.view.menu.MenuItemImpl com.android.internal.view.menu.MenuView$ItemView ), this, menuItemImpl, itemView);
    }

    @Override
    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIncludeItem", $$robo$$android_widget_ActionMenuPresenter$shouldIncludeItem(int com.android.internal.view.menu.MenuItemImpl ), this, n, menuItemImpl);
    }

    private void computeMenuItemAnimationInfo(boolean bl) {
        InvokeDynamicSupport.bootstrap("computeMenuItemAnimationInfo", $$robo$$android_widget_ActionMenuPresenter$computeMenuItemAnimationInfo(boolean ), this, bl);
    }

    private void runItemAnimations() {
        InvokeDynamicSupport.bootstrap("runItemAnimations", $$robo$$android_widget_ActionMenuPresenter$runItemAnimations(), this);
    }

    private void setupItemAnimations() {
        InvokeDynamicSupport.bootstrap("setupItemAnimations", $$robo$$android_widget_ActionMenuPresenter$setupItemAnimations(), this);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$android_widget_ActionMenuPresenter$updateMenuView(boolean ), this, bl);
    }

    @Override
    public boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterLeftoverView", $$robo$$android_widget_ActionMenuPresenter$filterLeftoverView(android.view.ViewGroup int ), this, viewGroup, n);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$android_widget_ActionMenuPresenter$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), this, subMenuBuilder);
    }

    private View findViewForItem(MenuItem menuItem) {
        return InvokeDynamicSupport.bootstrap("findViewForItem", $$robo$$android_widget_ActionMenuPresenter$findViewForItem(android.view.MenuItem ), this, menuItem);
    }

    public boolean showOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showOverflowMenu", $$robo$$android_widget_ActionMenuPresenter$showOverflowMenu(), this);
    }

    public boolean hideOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideOverflowMenu", $$robo$$android_widget_ActionMenuPresenter$hideOverflowMenu(), this);
    }

    public boolean dismissPopupMenus() {
        return (boolean)InvokeDynamicSupport.bootstrap("dismissPopupMenus", $$robo$$android_widget_ActionMenuPresenter$dismissPopupMenus(), this);
    }

    public boolean hideSubMenus() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideSubMenus", $$robo$$android_widget_ActionMenuPresenter$hideSubMenus(), this);
    }

    public boolean isOverflowMenuShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowing", $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowing(), this);
    }

    public boolean isOverflowMenuShowPending() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowPending", $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowPending(), this);
    }

    public boolean isOverflowReserved() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowReserved", $$robo$$android_widget_ActionMenuPresenter$isOverflowReserved(), this);
    }

    @Override
    public boolean flagActionItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$android_widget_ActionMenuPresenter$flagActionItems(), this);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$android_widget_ActionMenuPresenter$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), this, menuBuilder, bl);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_ActionMenuPresenter$onSaveInstanceState(), this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_ActionMenuPresenter$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public void onSubUiVisibilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onSubUiVisibilityChanged", $$robo$$android_widget_ActionMenuPresenter$onSubUiVisibilityChanged(boolean ), this, bl);
    }

    public void setMenuView(ActionMenuView actionMenuView) {
        InvokeDynamicSupport.bootstrap("setMenuView", $$robo$$android_widget_ActionMenuPresenter$setMenuView(android.widget.ActionMenuView ), this, actionMenuView);
    }

    public /* synthetic */ ActionMenuPresenter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuPresenter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ItemAnimationInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int id;
        MenuItemLayoutInfo menuItemLayoutInfo;
        Animator animator;
        int animType;
        static int MOVE = 0;
        static int FADE_IN = 1;
        static int FADE_OUT = 2;

        private void $$robo$$android_widget_ActionMenuPresenter_ItemAnimationInfo$__constructor__(int id2, MenuItemLayoutInfo info, Animator anim2, int animType) {
            this.id = id2;
            this.menuItemLayoutInfo = info;
            this.animator = anim2;
            this.animType = animType;
        }

        private void __constructor__(int n, MenuItemLayoutInfo menuItemLayoutInfo, Animator animator2, int n2) {
            this.$$robo$$android_widget_ActionMenuPresenter_ItemAnimationInfo$__constructor__(n, menuItemLayoutInfo, animator2, n2);
        }

        public ItemAnimationInfo(int n, MenuItemLayoutInfo menuItemLayoutInfo, Animator animator2, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_ItemAnimationInfo$__constructor__(int android.widget.ActionMenuPresenter$MenuItemLayoutInfo android.animation.Animator int ), this, n, menuItemLayoutInfo, animator2, n2);
        }

        public /* synthetic */ ItemAnimationInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemAnimationInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class MenuItemLayoutInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        View view;
        int left;
        int top;

        private void $$robo$$android_widget_ActionMenuPresenter_MenuItemLayoutInfo$__constructor__(View view, boolean preLayout) {
            this.left = view.getLeft();
            this.top = view.getTop();
            if (preLayout) {
                this.left = (int)((float)this.left + view.getTranslationX());
                this.top = (int)((float)this.top + view.getTranslationY());
            }
            this.view = view;
        }

        private void __constructor__(View view, boolean bl) {
            this.$$robo$$android_widget_ActionMenuPresenter_MenuItemLayoutInfo$__constructor__(view, bl);
        }

        public MenuItemLayoutInfo(View view, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_MenuItemLayoutInfo$__constructor__(android.view.View boolean ), this, view, bl);
        }

        public /* synthetic */ MenuItemLayoutInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuItemLayoutInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActionMenuPopupCallback
    extends ActionMenuItemView.PopupCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(ActionMenuPresenter actionMenuPresenter) {
            this.this$0 = actionMenuPresenter;
        }

        private final ShowableListMenu $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$getPopup() {
            return this.this$0.mActionButtonPopup != null ? this.this$0.mActionButtonPopup.getPopup() : null;
        }

        private /* synthetic */ void $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(ActionMenuPresenter x0, 1 x1) {
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
            this.$$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(actionMenuPresenter);
        }

        public ActionMenuPopupCallback(ActionMenuPresenter actionMenuPresenter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
        }

        @Override
        public ShowableListMenu getPopup() {
            return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$getPopup(), this);
        }

        private /* synthetic */ void __constructor__(ActionMenuPresenter actionMenuPresenter, 1 var2_2) {
            this.$$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(actionMenuPresenter, var2_2);
        }

        public /* synthetic */ ActionMenuPopupCallback(ActionMenuPresenter actionMenuPresenter, 1 var2_2) {
            this(actionMenuPresenter);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(android.widget.ActionMenuPresenter android.widget.ActionMenuPresenter$1 ), this, actionMenuPresenter, var2_2);
        }

        public /* synthetic */ ActionMenuPopupCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuPopupCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OpenOverflowRunnable
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private OverflowPopup mPopup;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$__constructor__(ActionMenuPresenter actionMenuPresenter, OverflowPopup popup) {
            this.this$0 = actionMenuPresenter;
            this.mPopup = popup;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$run() {
            View menuView;
            if (this.this$0.mMenu != null) {
                this.this$0.mMenu.changeMenuMode();
            }
            if ((menuView = (View)((Object)this.this$0.mMenuView)) != null && menuView.getWindowToken() != null && this.mPopup.tryShow()) {
                this.this$0.mOverflowPopup = this.mPopup;
            }
            this.this$0.mPostedOpenRunnable = null;
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
            this.$$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$__constructor__(actionMenuPresenter, overflowPopup);
        }

        public OpenOverflowRunnable(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$__constructor__(android.widget.ActionMenuPresenter android.widget.ActionMenuPresenter$OverflowPopup ), this, actionMenuPresenter, overflowPopup);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$run(), this);
        }

        public /* synthetic */ OpenOverflowRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpenOverflowRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupPresenterCallback
    implements MenuPresenter.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(ActionMenuPresenter actionMenuPresenter) {
            this.this$0 = actionMenuPresenter;
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu == null) {
                return false;
            }
            this.this$0.mOpenSubMenuId = ((SubMenuBuilder)subMenu).getItem().getItemId();
            MenuPresenter.Callback cb = this.this$0.getCallback();
            return cb != null ? cb.onOpenSubMenu(subMenu) : false;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            MenuPresenter.Callback cb;
            if (menu2 instanceof SubMenuBuilder) {
                menu2.getRootMenu().close(false);
            }
            if ((cb = this.this$0.getCallback()) != null) {
                cb.onCloseMenu(menu2, allMenusAreClosing);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(ActionMenuPresenter x0, 1 x1) {
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
            this.$$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(actionMenuPresenter);
        }

        public PopupPresenterCallback(ActionMenuPresenter actionMenuPresenter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), this, menuBuilder);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), this, menuBuilder, bl);
        }

        private /* synthetic */ void __constructor__(ActionMenuPresenter actionMenuPresenter, 1 var2_2) {
            this.$$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(actionMenuPresenter, var2_2);
        }

        public /* synthetic */ PopupPresenterCallback(ActionMenuPresenter actionMenuPresenter, 1 var2_2) {
            this(actionMenuPresenter);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(android.widget.ActionMenuPresenter android.widget.ActionMenuPresenter$1 ), this, actionMenuPresenter, var2_2);
        }

        public /* synthetic */ PopupPresenterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupPresenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActionButtonSubmenu
    extends MenuPopupHelper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$__constructor__(ActionMenuPresenter actionMenuPresenter, Context context, SubMenuBuilder subMenu, View anchorView) {
            this.this$0 = actionMenuPresenter;
            MenuItemImpl item = (MenuItemImpl)subMenu.getItem();
            if (!item.isActionButton()) {
                this.setAnchorView(actionMenuPresenter.mOverflowButton == null ? (View)((Object)actionMenuPresenter.mMenuView) : actionMenuPresenter.mOverflowButton);
            }
            this.setPresenterCallback(actionMenuPresenter.mPopupPresenterCallback);
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$onDismiss() {
            this.this$0.mActionButtonPopup = null;
            this.this$0.mOpenSubMenuId = 0;
            super.onDismiss();
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, Context context, SubMenuBuilder subMenuBuilder, View view) {
            this.$$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$__constructor__(actionMenuPresenter, context, subMenuBuilder, view);
        }

        public ActionButtonSubmenu(ActionMenuPresenter actionMenuPresenter, Context context, SubMenuBuilder subMenuBuilder, View view) {
            super(context, subMenuBuilder, view, false, 0x1010444);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$__constructor__(android.widget.ActionMenuPresenter android.content.Context com.android.internal.view.menu.SubMenuBuilder android.view.View ), this, actionMenuPresenter, context, subMenuBuilder, view);
        }

        @Override
        protected void onDismiss() {
            InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$onDismiss(), this);
        }

        public /* synthetic */ ActionButtonSubmenu() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionButtonSubmenu)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OverflowPopup
    extends MenuPopupHelper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$__constructor__(ActionMenuPresenter actionMenuPresenter, Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly) {
            this.this$0 = actionMenuPresenter;
            this.setGravity(0x800005);
            this.setPresenterCallback(actionMenuPresenter.mPopupPresenterCallback);
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$onDismiss() {
            if (this.this$0.mMenu != null) {
                this.this$0.mMenu.close();
            }
            this.this$0.mOverflowPopup = null;
            super.onDismiss();
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            this.$$robo$$android_widget_ActionMenuPresenter_OverflowPopup$__constructor__(actionMenuPresenter, context, menuBuilder, view, bl);
        }

        public OverflowPopup(ActionMenuPresenter actionMenuPresenter, Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            super(context, menuBuilder, view, bl, 0x1010444);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$__constructor__(android.widget.ActionMenuPresenter android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View boolean ), this, actionMenuPresenter, context, menuBuilder, view, bl);
        }

        @Override
        protected void onDismiss() {
            InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$onDismiss(), this);
        }

        public /* synthetic */ OverflowPopup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowPopup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OverflowMenuButton
    extends ImageButton
    implements ActionMenuView.ActionMenuChildView,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$__constructor__(ActionMenuPresenter actionMenuPresenter, Context context) {
            this.this$0 = actionMenuPresenter;
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
            this.setOnTouchListener((View.OnTouchListener)new ShadowedObject(this, this, actionMenuPresenter){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ActionMenuPresenter val$this$0;
                /* synthetic */ OverflowMenuButton this$1;

                private void $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$__constructor__(OverflowMenuButton this$1, View src, ActionMenuPresenter actionMenuPresenter) {
                    this.this$1 = this$1;
                    this.val$this$0 = actionMenuPresenter;
                }

                private final ShowableListMenu $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$getPopup() {
                    if (this.this$1.this$0.mOverflowPopup == null) {
                        return null;
                    }
                    return this.this$1.this$0.mOverflowPopup.getPopup();
                }

                private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStarted() {
                    this.this$1.this$0.showOverflowMenu();
                    return true;
                }

                private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStopped() {
                    if (this.this$1.this$0.mPostedOpenRunnable != null) {
                        return false;
                    }
                    this.this$1.this$0.hideOverflowMenu();
                    return true;
                }

                private void __constructor__(OverflowMenuButton overflowMenuButton, View view, ActionMenuPresenter actionMenuPresenter) {
                    this.$$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$__constructor__(overflowMenuButton, view, actionMenuPresenter);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$__constructor__(android.widget.ActionMenuPresenter$OverflowMenuButton android.view.View android.widget.ActionMenuPresenter ), this, overflowMenuButton, view, actionMenuPresenter);
                }

                @Override
                public ShowableListMenu getPopup() {
                    return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$getPopup(), this);
                }

                @Override
                public boolean onForwardingStarted() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStarted", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStarted(), this);
                }

                @Override
                public boolean onForwardingStopped() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStopped", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStopped(), this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            this.this$0.showOverflowMenu();
            return true;
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerBefore() {
            return false;
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerAfter() {
            return false;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfoInternal(info);
            info.setCanOpenPopup(true);
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$setFrame(int l, int t, int r, int b) {
            boolean changed = super.setFrame(l, t, r, b);
            Drawable d = this.getDrawable();
            Drawable bg = this.getBackground();
            if (d != null && bg != null) {
                int width = this.getWidth();
                int height = this.getHeight();
                int halfEdge = Math.max(width, height) / 2;
                int offsetX = this.getPaddingLeft() - this.getPaddingRight();
                int offsetY = this.getPaddingTop() - this.getPaddingBottom();
                int centerX = (width + offsetX) / 2;
                int centerY = (height + offsetY) / 2;
                bg.setHotspotBounds(centerX - halfEdge, centerY - halfEdge, centerX + halfEdge, centerY + halfEdge);
            }
            return changed;
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, Context context) {
            this.$$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$__constructor__(actionMenuPresenter, context);
        }

        public OverflowMenuButton(ActionMenuPresenter actionMenuPresenter, Context context) {
            super(context, null, 16843510);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$__constructor__(android.widget.ActionMenuPresenter android.content.Context ), this, actionMenuPresenter, context);
        }

        @Override
        public boolean performClick() {
            return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$performClick(), this);
        }

        @Override
        public boolean needsDividerBefore() {
            return (boolean)InvokeDynamicSupport.bootstrap("needsDividerBefore", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerBefore(), this);
        }

        @Override
        public boolean needsDividerAfter() {
            return (boolean)InvokeDynamicSupport.bootstrap("needsDividerAfter", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerAfter(), this);
        }

        @Override
        public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
        }

        @Override
        protected boolean setFrame(int n, int n2, int n3, int n4) {
            return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$setFrame(int int int int ), this, n, n2, n3, n4);
        }

        public /* synthetic */ OverflowMenuButton() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowMenuButton)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SavedState
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int openSubMenuId;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__() {
        }

        private void $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(Parcel in) {
            this.openSubMenuId = in.readInt();
        }

        private final int $$robo$$android_widget_ActionMenuPresenter_SavedState$describeContents() {
            return 0;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_SavedState$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.openSubMenuId);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ActionMenuPresenter_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_ActionMenuPresenter_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_ActionMenuPresenter_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_ActionMenuPresenter_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_ActionMenuPresenter_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_ActionMenuPresenter_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__();
        }

        public SavedState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_ActionMenuPresenter_SavedState$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_ActionMenuPresenter_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

