/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebViewFactory;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@VisibleForTesting
public class WebViewLibraryLoader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    private static long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static boolean DEBUG = false;
    private static boolean sAddressSpaceReserved;

    private void $$robo$$android_webkit_WebViewLibraryLoader$__constructor__() {
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$createRelroFile(boolean is64Bit, WebViewNativeLibrary nativeLib) {
        String abi = is64Bit ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(abi){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$abi;

            private void $$robo$$android_webkit_WebViewLibraryLoader_1$__constructor__(String string2) {
                this.val$abi = string2;
            }

            private final void $$robo$$android_webkit_WebViewLibraryLoader_1$run() {
                try {
                    Log.e(LOGTAG, "relro file creator for " + this.val$abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_webkit_WebViewLibraryLoader_1$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader_1$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_webkit_WebViewLibraryLoader_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            if (nativeLib == null || nativeLib.path == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            boolean success = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), new String[]{nativeLib.path}, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (!success) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    private static final int $$robo$$android_webkit_WebViewLibraryLoader$prepareNativeLibraries(PackageInfo webviewPackageInfo) throws WebViewFactory.MissingWebViewPackageException {
        WebViewNativeLibrary nativeLib32bit = WebViewLibraryLoader.getWebViewNativeLibrary(webviewPackageInfo, false);
        WebViewNativeLibrary nativeLib64bit = WebViewLibraryLoader.getWebViewNativeLibrary(webviewPackageInfo, true);
        WebViewLibraryLoader.updateWebViewZygoteVmSize(nativeLib32bit, nativeLib64bit);
        return WebViewLibraryLoader.createRelros(nativeLib32bit, nativeLib64bit);
    }

    private static final int $$robo$$android_webkit_WebViewLibraryLoader$createRelros(WebViewNativeLibrary nativeLib32bit, WebViewNativeLibrary nativeLib64bit) {
        int numRelros = 0;
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            if (nativeLib32bit == null) {
                Log.e(LOGTAG, "No 32-bit WebView library path, skipping relro creation.");
            } else {
                WebViewLibraryLoader.createRelroFile(false, nativeLib32bit);
                ++numRelros;
            }
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            if (nativeLib64bit == null) {
                Log.e(LOGTAG, "No 64-bit WebView library path, skipping relro creation.");
            } else {
                WebViewLibraryLoader.createRelroFile(true, nativeLib64bit);
                ++numRelros;
            }
        }
        return numRelros;
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$updateWebViewZygoteVmSize(WebViewNativeLibrary nativeLib32bit, WebViewNativeLibrary nativeLib64bit) throws WebViewFactory.MissingWebViewPackageException {
        long newVmSize = 0L;
        if (nativeLib32bit != null) {
            newVmSize = Math.max(newVmSize, nativeLib32bit.size);
        }
        if (nativeLib64bit != null) {
            newVmSize = Math.max(newVmSize, nativeLib64bit.size);
        }
        newVmSize = Math.max(2L * newVmSize, 0x6400000L);
        Log.d(LOGTAG, "Setting new address space to " + newVmSize);
        WebViewLibraryLoader.setWebViewZygoteVmSize(newVmSize);
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$reserveAddressSpaceInZygote() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"webviewchromium_loader");
        long addressSpaceToReserve = SystemProperties.getLong("persist.sys.webview.vmsize", 0x6400000L);
        sAddressSpaceReserved = WebViewLibraryLoader.nativeReserveAddressSpace(addressSpaceToReserve);
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "reserving " + addressSpaceToReserve + " bytes of address space failed");
        }
    }

    private static final int $$robo$$android_webkit_WebViewLibraryLoader$loadNativeLibrary(ClassLoader clazzLoader, String libraryFileName) {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return 2;
        }
        String relroPath = VMRuntime.getRuntime().is64Bit() ? "/data/misc/shared_relro/libwebviewchromium64.relro" : "/data/misc/shared_relro/libwebviewchromium32.relro";
        int result = WebViewLibraryLoader.nativeLoadWithRelroFile(libraryFileName, relroPath, clazzLoader);
        if (result != 0) {
            Log.w(LOGTAG, "failed to load with relro file, proceeding without");
        }
        return result;
    }

    @VisibleForTesting
    private static final WebViewNativeLibrary $$robo$$android_webkit_WebViewLibraryLoader$getWebViewNativeLibrary(PackageInfo packageInfo, boolean is64bit) throws WebViewFactory.MissingWebViewPackageException {
        ApplicationInfo ai = packageInfo.applicationInfo;
        String nativeLibFileName = WebViewFactory.getWebViewLibrary(ai);
        String dir = WebViewLibraryLoader.getWebViewNativeLibraryDirectory(ai, is64bit);
        WebViewNativeLibrary lib = WebViewLibraryLoader.findNativeLibrary(ai, nativeLibFileName, is64bit ? Build.SUPPORTED_64_BIT_ABIS : Build.SUPPORTED_32_BIT_ABIS, dir);
        return lib;
    }

    @VisibleForTesting
    private static final String $$robo$$android_webkit_WebViewLibraryLoader$getWebViewNativeLibraryDirectory(ApplicationInfo ai, boolean is64bit) {
        if (is64bit == VMRuntime.is64BitAbi(ai.primaryCpuAbi)) {
            return ai.nativeLibraryDir;
        }
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            return ai.secondaryNativeLibraryDir;
        }
        return "";
    }

    private static final WebViewNativeLibrary $$robo$$android_webkit_WebViewLibraryLoader$findNativeLibrary(ApplicationInfo ai, String nativeLibFileName, String[] abiList, String libDirectory) throws WebViewFactory.MissingWebViewPackageException {
        if (TextUtils.isEmpty(libDirectory)) {
            return null;
        }
        String libPath = libDirectory + "/" + nativeLibFileName;
        File f = new File(libPath);
        if (f.exists()) {
            return new WebViewNativeLibrary(libPath, f.length());
        }
        return WebViewLibraryLoader.getLoadFromApkPath(ai.sourceDir, abiList, nativeLibFileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final WebViewNativeLibrary $$robo$$android_webkit_WebViewLibraryLoader$getLoadFromApkPath(String apkPath, String[] abiList, String nativeLibFileName) throws WebViewFactory.MissingWebViewPackageException {
        try (ZipFile z = new ZipFile(apkPath);){
            String[] stringArray = abiList;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String abi = stringArray[n2];
                String entry = "lib/" + abi + "/" + nativeLibFileName;
                ZipEntry e = z.getEntry(entry);
                if (e != null && e.getMethod() == 0) {
                    WebViewNativeLibrary webViewNativeLibrary = new WebViewNativeLibrary(apkPath + "!/" + entry, e.getSize());
                    return webViewNativeLibrary;
                }
                ++n2;
            }
            return null;
        }
        catch (IOException e) {
            throw new WebViewFactory.MissingWebViewPackageException(e);
        }
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$setWebViewZygoteVmSize(long vmSize) {
        SystemProperties.set("persist.sys.webview.vmsize", Long.toString(vmSize));
    }

    private static final boolean $$robo$$android_webkit_WebViewLibraryLoader$nativeReserveAddressSpace(long l) {
        return false;
    }

    private static final boolean $$robo$$android_webkit_WebViewLibraryLoader$nativeCreateRelroFile(String string2, String string3) {
        return false;
    }

    private static final int $$robo$$android_webkit_WebViewLibraryLoader$nativeLoadWithRelroFile(String string2, String string3, ClassLoader classLoader) {
        return 0;
    }

    static void __staticInitializer__() {
        LOGTAG = WebViewLibraryLoader.class.getSimpleName();
        sAddressSpaceReserved = false;
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_WebViewLibraryLoader$__constructor__();
    }

    public WebViewLibraryLoader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader$__constructor__(), this);
    }

    static void createRelroFile(boolean bl, WebViewNativeLibrary webViewNativeLibrary) {
        InvokeDynamicSupport.bootstrapStatic("createRelroFile", $$robo$$android_webkit_WebViewLibraryLoader$createRelroFile(boolean android.webkit.WebViewLibraryLoader$WebViewNativeLibrary ), (boolean)bl, (WebViewNativeLibrary)webViewNativeLibrary);
    }

    static int prepareNativeLibraries(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        return (int)InvokeDynamicSupport.bootstrapStatic("prepareNativeLibraries", $$robo$$android_webkit_WebViewLibraryLoader$prepareNativeLibraries(android.content.pm.PackageInfo ), (PackageInfo)packageInfo);
    }

    private static int createRelros(WebViewNativeLibrary webViewNativeLibrary, WebViewNativeLibrary webViewNativeLibrary2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("createRelros", $$robo$$android_webkit_WebViewLibraryLoader$createRelros(android.webkit.WebViewLibraryLoader$WebViewNativeLibrary android.webkit.WebViewLibraryLoader$WebViewNativeLibrary ), (WebViewNativeLibrary)webViewNativeLibrary, (WebViewNativeLibrary)webViewNativeLibrary2);
    }

    private static void updateWebViewZygoteVmSize(WebViewNativeLibrary webViewNativeLibrary, WebViewNativeLibrary webViewNativeLibrary2) throws WebViewFactory.MissingWebViewPackageException {
        InvokeDynamicSupport.bootstrapStatic("updateWebViewZygoteVmSize", $$robo$$android_webkit_WebViewLibraryLoader$updateWebViewZygoteVmSize(android.webkit.WebViewLibraryLoader$WebViewNativeLibrary android.webkit.WebViewLibraryLoader$WebViewNativeLibrary ), (WebViewNativeLibrary)webViewNativeLibrary, (WebViewNativeLibrary)webViewNativeLibrary2);
    }

    static void reserveAddressSpaceInZygote() {
        InvokeDynamicSupport.bootstrapStatic("reserveAddressSpaceInZygote", $$robo$$android_webkit_WebViewLibraryLoader$reserveAddressSpaceInZygote());
    }

    public static int loadNativeLibrary(ClassLoader classLoader, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadNativeLibrary", $$robo$$android_webkit_WebViewLibraryLoader$loadNativeLibrary(java.lang.ClassLoader java.lang.String ), (ClassLoader)classLoader, (String)string2);
    }

    public static WebViewNativeLibrary getWebViewNativeLibrary(PackageInfo packageInfo, boolean bl) throws WebViewFactory.MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewNativeLibrary", $$robo$$android_webkit_WebViewLibraryLoader$getWebViewNativeLibrary(android.content.pm.PackageInfo boolean ), (PackageInfo)packageInfo, (boolean)bl);
    }

    public static String getWebViewNativeLibraryDirectory(ApplicationInfo applicationInfo, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewNativeLibraryDirectory", $$robo$$android_webkit_WebViewLibraryLoader$getWebViewNativeLibraryDirectory(android.content.pm.ApplicationInfo boolean ), (ApplicationInfo)applicationInfo, (boolean)bl);
    }

    private static WebViewNativeLibrary findNativeLibrary(ApplicationInfo applicationInfo, String string2, String[] stringArray, String string3) throws WebViewFactory.MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("findNativeLibrary", $$robo$$android_webkit_WebViewLibraryLoader$findNativeLibrary(android.content.pm.ApplicationInfo java.lang.String java.lang.String[] java.lang.String ), (ApplicationInfo)applicationInfo, (String)string2, (String[])stringArray, (String)string3);
    }

    private static WebViewNativeLibrary getLoadFromApkPath(String string2, String[] stringArray, String string3) throws WebViewFactory.MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("getLoadFromApkPath", $$robo$$android_webkit_WebViewLibraryLoader$getLoadFromApkPath(java.lang.String java.lang.String[] java.lang.String ), (String)string2, (String[])stringArray, (String)string3);
    }

    private static void setWebViewZygoteVmSize(long l) {
        InvokeDynamicSupport.bootstrapStatic("setWebViewZygoteVmSize", $$robo$$android_webkit_WebViewLibraryLoader$setWebViewZygoteVmSize(long ), (long)l);
    }

    static boolean nativeReserveAddressSpace(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeReserveAddressSpace", $$robo$$android_webkit_WebViewLibraryLoader$nativeReserveAddressSpace(long ), (long)l);
    }

    static boolean nativeCreateRelroFile(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCreateRelroFile", $$robo$$android_webkit_WebViewLibraryLoader$nativeCreateRelroFile(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    static int nativeLoadWithRelroFile(String string2, String string3, ClassLoader classLoader) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeLoadWithRelroFile", $$robo$$android_webkit_WebViewLibraryLoader$nativeLoadWithRelroFile(java.lang.String java.lang.String java.lang.ClassLoader ), (String)string2, (String)string3, (ClassLoader)classLoader);
    }

    static {
        RobolectricInternals.classInitializing(WebViewLibraryLoader.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewLibraryLoader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public static class WebViewNativeLibrary
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String path;
        public long size;

        private void $$robo$$android_webkit_WebViewLibraryLoader_WebViewNativeLibrary$__constructor__(String path, long size) {
            this.path = path;
            this.size = size;
        }

        private void __constructor__(String string2, long l) {
            this.$$robo$$android_webkit_WebViewLibraryLoader_WebViewNativeLibrary$__constructor__(string2, l);
        }

        public WebViewNativeLibrary(String string2, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader_WebViewNativeLibrary$__constructor__(java.lang.String long ), this, string2, l);
        }

        public /* synthetic */ WebViewNativeLibrary() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewNativeLibrary)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RelroFileCreator
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 1 || args[0] == null) {
                    Log.e(LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v(LOGTAG, "RelroFileCreator (64bit = " + is64Bit + "), lib: " + args[0]);
                if (!sAddressSpaceReserved) {
                    Log.e(LOGTAG, "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewLibraryLoader.nativeCreateRelroFile(args[0], is64Bit ? "/data/misc/shared_relro/libwebviewchromium64.relro" : "/data/misc/shared_relro/libwebviewchromium32.relro");
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateServiceUnchecked().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "error notifying update service", e);
                }
                if (!result) {
                    Log.e(LOGTAG, "failed to create relro file");
                }
                System.exit(0);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$__constructor__();
        }

        public RelroFileCreator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$__constructor__(), this);
        }

        public static void main(String[] stringArray) {
            InvokeDynamicSupport.bootstrapStatic("main", $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$main(java.lang.String[] ), (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelroFileCreator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

