/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.StrictMode;
import android.print.PrintDocumentAdapter;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.textclassifier.TextClassifier;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.FindAddress;
import android.webkit.IWebViewUpdateService;
import android.webkit.PluginList;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebMessage;
import android.webkit.WebMessagePort;
import android.webkit.WebSettings;
import android.webkit.WebViewClient;
import android.webkit.WebViewFactory;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewProvider;
import android.widget.AbsoluteLayout;
import java.io.BufferedWriter;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WebView
extends AbsoluteLayout
implements ViewTreeObserver.OnGlobalFocusChangeListener,
ViewGroup.OnHierarchyChangeListener,
ViewDebug.HierarchyHandler,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "WebView";
    private static volatile boolean sEnforceThreadChecking;
    public static String SCHEME_TEL = "tel:";
    public static String SCHEME_MAILTO = "mailto:";
    public static String SCHEME_GEO = "geo:0,0?q=";
    public static int RENDERER_PRIORITY_WAIVED = 0;
    public static int RENDERER_PRIORITY_BOUND = 1;
    public static int RENDERER_PRIORITY_IMPORTANT = 2;
    private WebViewProvider mProvider;
    private FindListenerDistributor mFindListener;
    private Looper mWebViewThread;

    private void $$robo$$android_webkit_WebView$__constructor__(Context context) {
    }

    private void $$robo$$android_webkit_WebView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_webkit_WebView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_webkit_WebView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    }

    @Deprecated
    private void $$robo$$android_webkit_WebView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, boolean privateBrowsing) {
    }

    private void $$robo$$android_webkit_WebView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, Map<String, Object> javaScriptInterfaces, boolean privateBrowsing) {
    }

    private void $$robo$$android_webkit_WebView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, Map<String, Object> javaScriptInterfaces, boolean privateBrowsing) {
        this.mWebViewThread = Looper.myLooper();
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        if (context == null) {
            throw new IllegalArgumentException("Invalid context argument");
        }
        if (this.mWebViewThread == null) {
            throw new RuntimeException("WebView cannot be initialized on a thread that has no Looper.");
        }
        sEnforceThreadChecking = context.getApplicationInfo().targetSdkVersion >= 18;
        this.checkThread();
        this.ensureProviderCreated();
        this.mProvider.init(javaScriptInterfaces, privateBrowsing);
        CookieSyncManager.setGetInstanceIsAllowed();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$setHorizontalScrollbarOverlay(boolean overlay) {
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$setVerticalScrollbarOverlay(boolean overlay) {
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$overlayHorizontalScrollbar() {
        return true;
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$overlayVerticalScrollbar() {
        return false;
    }

    @Deprecated
    private final int $$robo$$android_webkit_WebView$getVisibleTitleHeight() {
        this.checkThread();
        return this.mProvider.getVisibleTitleHeight();
    }

    private final SslCertificate $$robo$$android_webkit_WebView$getCertificate() {
        this.checkThread();
        return this.mProvider.getCertificate();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$setCertificate(SslCertificate certificate) {
        this.checkThread();
        this.mProvider.setCertificate(certificate);
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$savePassword(String host, String username, String password) {
        this.checkThread();
        this.mProvider.savePassword(host, username, password);
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        this.checkThread();
        this.mProvider.setHttpAuthUsernamePassword(host, realm, username, password);
    }

    @Deprecated
    private final String[] $$robo$$android_webkit_WebView$getHttpAuthUsernamePassword(String host, String realm) {
        this.checkThread();
        return this.mProvider.getHttpAuthUsernamePassword(host, realm);
    }

    private final void $$robo$$android_webkit_WebView$destroy() {
        this.checkThread();
        this.mProvider.destroy();
    }

    @Deprecated
    private static final void $$robo$$android_webkit_WebView$enablePlatformNotifications() {
    }

    @Deprecated
    private static final void $$robo$$android_webkit_WebView$disablePlatformNotifications() {
    }

    private static final void $$robo$$android_webkit_WebView$freeMemoryForTests() {
        WebView.getFactory().getStatics().freeMemoryForTests();
    }

    private final void $$robo$$android_webkit_WebView$setNetworkAvailable(boolean networkUp) {
        this.checkThread();
        this.mProvider.setNetworkAvailable(networkUp);
    }

    private final WebBackForwardList $$robo$$android_webkit_WebView$saveState(Bundle outState) {
        this.checkThread();
        return this.mProvider.saveState(outState);
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$savePicture(Bundle b, File dest) {
        this.checkThread();
        return this.mProvider.savePicture(b, dest);
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$restorePicture(Bundle b, File src) {
        this.checkThread();
        return this.mProvider.restorePicture(b, src);
    }

    private final WebBackForwardList $$robo$$android_webkit_WebView$restoreState(Bundle inState) {
        this.checkThread();
        return this.mProvider.restoreState(inState);
    }

    private final void $$robo$$android_webkit_WebView$loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.checkThread();
        this.mProvider.loadUrl(url, additionalHttpHeaders);
    }

    private final void $$robo$$android_webkit_WebView$loadUrl(String url) {
        this.checkThread();
        this.mProvider.loadUrl(url);
    }

    private final void $$robo$$android_webkit_WebView$postUrl(String url, byte[] postData) {
        this.checkThread();
        if (URLUtil.isNetworkUrl(url)) {
            this.mProvider.postUrl(url, postData);
        } else {
            this.mProvider.loadUrl(url);
        }
    }

    private final void $$robo$$android_webkit_WebView$loadData(String data, String mimeType, String encoding) {
        this.checkThread();
        this.mProvider.loadData(data, mimeType, encoding);
    }

    private final void $$robo$$android_webkit_WebView$loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.checkThread();
        this.mProvider.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    private final void $$robo$$android_webkit_WebView$evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        this.checkThread();
        this.mProvider.evaluateJavaScript(script, resultCallback);
    }

    private final void $$robo$$android_webkit_WebView$saveWebArchive(String filename) {
        this.checkThread();
        this.mProvider.saveWebArchive(filename);
    }

    private final void $$robo$$android_webkit_WebView$saveWebArchive(String basename, boolean autoname, ValueCallback<String> callback) {
        this.checkThread();
        this.mProvider.saveWebArchive(basename, autoname, callback);
    }

    private final void $$robo$$android_webkit_WebView$stopLoading() {
        this.checkThread();
        this.mProvider.stopLoading();
    }

    private final void $$robo$$android_webkit_WebView$reload() {
        this.checkThread();
        this.mProvider.reload();
    }

    private final boolean $$robo$$android_webkit_WebView$canGoBack() {
        this.checkThread();
        return this.mProvider.canGoBack();
    }

    private final void $$robo$$android_webkit_WebView$goBack() {
        this.checkThread();
        this.mProvider.goBack();
    }

    private final boolean $$robo$$android_webkit_WebView$canGoForward() {
        this.checkThread();
        return this.mProvider.canGoForward();
    }

    private final void $$robo$$android_webkit_WebView$goForward() {
        this.checkThread();
        this.mProvider.goForward();
    }

    private final boolean $$robo$$android_webkit_WebView$canGoBackOrForward(int steps) {
        this.checkThread();
        return this.mProvider.canGoBackOrForward(steps);
    }

    private final void $$robo$$android_webkit_WebView$goBackOrForward(int steps) {
        this.checkThread();
        this.mProvider.goBackOrForward(steps);
    }

    private final boolean $$robo$$android_webkit_WebView$isPrivateBrowsingEnabled() {
        this.checkThread();
        return this.mProvider.isPrivateBrowsingEnabled();
    }

    private final boolean $$robo$$android_webkit_WebView$pageUp(boolean top) {
        this.checkThread();
        return this.mProvider.pageUp(top);
    }

    private final boolean $$robo$$android_webkit_WebView$pageDown(boolean bottom) {
        this.checkThread();
        return this.mProvider.pageDown(bottom);
    }

    private final void $$robo$$android_webkit_WebView$postVisualStateCallback(long requestId, VisualStateCallback callback) {
        this.checkThread();
        this.mProvider.insertVisualStateCallback(requestId, callback);
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$clearView() {
        this.checkThread();
        this.mProvider.clearView();
    }

    @Deprecated
    private final Picture $$robo$$android_webkit_WebView$capturePicture() {
        this.checkThread();
        return this.mProvider.capturePicture();
    }

    @Deprecated
    private final PrintDocumentAdapter $$robo$$android_webkit_WebView$createPrintDocumentAdapter() {
        this.checkThread();
        return this.mProvider.createPrintDocumentAdapter("default");
    }

    private final PrintDocumentAdapter $$robo$$android_webkit_WebView$createPrintDocumentAdapter(String documentName) {
        this.checkThread();
        return this.mProvider.createPrintDocumentAdapter(documentName);
    }

    @Deprecated
    @ViewDebug.ExportedProperty(category="webview")
    private final float $$robo$$android_webkit_WebView$getScale() {
        this.checkThread();
        return this.mProvider.getScale();
    }

    private final void $$robo$$android_webkit_WebView$setInitialScale(int scaleInPercent) {
        this.checkThread();
        this.mProvider.setInitialScale(scaleInPercent);
    }

    private final void $$robo$$android_webkit_WebView$invokeZoomPicker() {
        this.checkThread();
        this.mProvider.invokeZoomPicker();
    }

    private final HitTestResult $$robo$$android_webkit_WebView$getHitTestResult() {
        this.checkThread();
        return this.mProvider.getHitTestResult();
    }

    private final void $$robo$$android_webkit_WebView$requestFocusNodeHref(Message hrefMsg) {
        this.checkThread();
        this.mProvider.requestFocusNodeHref(hrefMsg);
    }

    private final void $$robo$$android_webkit_WebView$requestImageRef(Message msg) {
        this.checkThread();
        this.mProvider.requestImageRef(msg);
    }

    @ViewDebug.ExportedProperty(category="webview")
    private final String $$robo$$android_webkit_WebView$getUrl() {
        this.checkThread();
        return this.mProvider.getUrl();
    }

    @ViewDebug.ExportedProperty(category="webview")
    private final String $$robo$$android_webkit_WebView$getOriginalUrl() {
        this.checkThread();
        return this.mProvider.getOriginalUrl();
    }

    @ViewDebug.ExportedProperty(category="webview")
    private final String $$robo$$android_webkit_WebView$getTitle() {
        this.checkThread();
        return this.mProvider.getTitle();
    }

    private final Bitmap $$robo$$android_webkit_WebView$getFavicon() {
        this.checkThread();
        return this.mProvider.getFavicon();
    }

    private final String $$robo$$android_webkit_WebView$getTouchIconUrl() {
        return this.mProvider.getTouchIconUrl();
    }

    private final int $$robo$$android_webkit_WebView$getProgress() {
        this.checkThread();
        return this.mProvider.getProgress();
    }

    @ViewDebug.ExportedProperty(category="webview")
    private final int $$robo$$android_webkit_WebView$getContentHeight() {
        this.checkThread();
        return this.mProvider.getContentHeight();
    }

    @ViewDebug.ExportedProperty(category="webview")
    private final int $$robo$$android_webkit_WebView$getContentWidth() {
        return this.mProvider.getContentWidth();
    }

    private final void $$robo$$android_webkit_WebView$pauseTimers() {
        this.checkThread();
        this.mProvider.pauseTimers();
    }

    private final void $$robo$$android_webkit_WebView$resumeTimers() {
        this.checkThread();
        this.mProvider.resumeTimers();
    }

    private final void $$robo$$android_webkit_WebView$onPause() {
        this.checkThread();
        this.mProvider.onPause();
    }

    private final void $$robo$$android_webkit_WebView$onResume() {
        this.checkThread();
        this.mProvider.onResume();
    }

    private final boolean $$robo$$android_webkit_WebView$isPaused() {
        return this.mProvider.isPaused();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$freeMemory() {
        this.checkThread();
        this.mProvider.freeMemory();
    }

    private final void $$robo$$android_webkit_WebView$clearCache(boolean includeDiskFiles) {
        this.checkThread();
        this.mProvider.clearCache(includeDiskFiles);
    }

    private final void $$robo$$android_webkit_WebView$clearFormData() {
        this.checkThread();
        this.mProvider.clearFormData();
    }

    private final void $$robo$$android_webkit_WebView$clearHistory() {
        this.checkThread();
        this.mProvider.clearHistory();
    }

    private final void $$robo$$android_webkit_WebView$clearSslPreferences() {
        this.checkThread();
        this.mProvider.clearSslPreferences();
    }

    private static final void $$robo$$android_webkit_WebView$clearClientCertPreferences(Runnable onCleared) {
        WebView.getFactory().getStatics().clearClientCertPreferences(onCleared);
    }

    private static final void $$robo$$android_webkit_WebView$startSafeBrowsing(Context context, ValueCallback<Boolean> callback) {
        WebView.getFactory().getStatics().initSafeBrowsing(context, callback);
    }

    private static final void $$robo$$android_webkit_WebView$setSafeBrowsingWhitelist(List<String> hosts, ValueCallback<Boolean> callback) {
        WebView.getFactory().getStatics().setSafeBrowsingWhitelist(hosts, callback);
    }

    private static final Uri $$robo$$android_webkit_WebView$getSafeBrowsingPrivacyPolicyUrl() {
        return WebView.getFactory().getStatics().getSafeBrowsingPrivacyPolicyUrl();
    }

    private final WebBackForwardList $$robo$$android_webkit_WebView$copyBackForwardList() {
        this.checkThread();
        return this.mProvider.copyBackForwardList();
    }

    private final void $$robo$$android_webkit_WebView$setFindListener(FindListener listener) {
        this.checkThread();
        this.setupFindListenerIfNeeded();
        this.mFindListener.mUserFindListener = listener;
    }

    private final void $$robo$$android_webkit_WebView$findNext(boolean forward) {
        this.checkThread();
        this.mProvider.findNext(forward);
    }

    @Deprecated
    private final int $$robo$$android_webkit_WebView$findAll(String find) {
        this.checkThread();
        StrictMode.noteSlowCall("findAll blocks UI: prefer findAllAsync");
        return this.mProvider.findAll(find);
    }

    private final void $$robo$$android_webkit_WebView$findAllAsync(String find) {
        this.checkThread();
        this.mProvider.findAllAsync(find);
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$showFindDialog(String text, boolean showIme) {
        this.checkThread();
        return this.mProvider.showFindDialog(text, showIme);
    }

    @Deprecated
    private static final String $$robo$$android_webkit_WebView$findAddress(String addr) {
        if (addr == null) {
            throw new NullPointerException("addr is null");
        }
        return FindAddress.findAddress(addr);
    }

    private static final void $$robo$$android_webkit_WebView$enableSlowWholeDocumentDraw() {
        WebView.getFactory().getStatics().enableSlowWholeDocumentDraw();
    }

    private final void $$robo$$android_webkit_WebView$clearMatches() {
        this.checkThread();
        this.mProvider.clearMatches();
    }

    private final void $$robo$$android_webkit_WebView$documentHasImages(Message response) {
        this.checkThread();
        this.mProvider.documentHasImages(response);
    }

    private final void $$robo$$android_webkit_WebView$setWebViewClient(WebViewClient client) {
        this.checkThread();
        this.mProvider.setWebViewClient(client);
    }

    private final WebViewClient $$robo$$android_webkit_WebView$getWebViewClient() {
        this.checkThread();
        return this.mProvider.getWebViewClient();
    }

    private final void $$robo$$android_webkit_WebView$setDownloadListener(DownloadListener listener) {
        this.checkThread();
        this.mProvider.setDownloadListener(listener);
    }

    private final void $$robo$$android_webkit_WebView$setWebChromeClient(WebChromeClient client) {
        this.checkThread();
        this.mProvider.setWebChromeClient(client);
    }

    private final WebChromeClient $$robo$$android_webkit_WebView$getWebChromeClient() {
        this.checkThread();
        return this.mProvider.getWebChromeClient();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$setPictureListener(PictureListener listener) {
        this.checkThread();
        this.mProvider.setPictureListener(listener);
    }

    private final void $$robo$$android_webkit_WebView$addJavascriptInterface(Object object, String name) {
        this.checkThread();
        this.mProvider.addJavascriptInterface(object, name);
    }

    private final void $$robo$$android_webkit_WebView$removeJavascriptInterface(String name) {
        this.checkThread();
        this.mProvider.removeJavascriptInterface(name);
    }

    private final WebMessagePort[] $$robo$$android_webkit_WebView$createWebMessageChannel() {
        this.checkThread();
        return this.mProvider.createWebMessageChannel();
    }

    private final void $$robo$$android_webkit_WebView$postWebMessage(WebMessage message, Uri targetOrigin) {
        this.checkThread();
        this.mProvider.postMessageToMainFrame(message, targetOrigin);
    }

    private final WebSettings $$robo$$android_webkit_WebView$getSettings() {
        this.checkThread();
        return this.mProvider.getSettings();
    }

    private static final void $$robo$$android_webkit_WebView$setWebContentsDebuggingEnabled(boolean enabled) {
        WebView.getFactory().getStatics().setWebContentsDebuggingEnabled(enabled);
    }

    @Deprecated
    private static final synchronized PluginList $$robo$$android_webkit_WebView$getPluginList() {
        return new PluginList();
    }

    private static final void $$robo$$android_webkit_WebView$setDataDirectorySuffix(String suffix) {
        WebViewFactory.setDataDirectorySuffix(suffix);
    }

    private static final void $$robo$$android_webkit_WebView$disableWebView() {
        WebViewFactory.disableWebView();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$refreshPlugins(boolean reloadOpenPages) {
        this.checkThread();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$emulateShiftHeld() {
        this.checkThread();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$onChildViewAdded(View parent, View child) {
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$onChildViewRemoved(View p, View child) {
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$onGlobalFocusChanged(View oldFocus, View newFocus) {
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$setMapTrackballToArrowKeys(boolean setMap) {
        this.checkThread();
        this.mProvider.setMapTrackballToArrowKeys(setMap);
    }

    private final void $$robo$$android_webkit_WebView$flingScroll(int vx, int vy) {
        this.checkThread();
        this.mProvider.flingScroll(vx, vy);
    }

    @Deprecated
    private final View $$robo$$android_webkit_WebView$getZoomControls() {
        this.checkThread();
        return this.mProvider.getZoomControls();
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$canZoomIn() {
        this.checkThread();
        return this.mProvider.canZoomIn();
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$canZoomOut() {
        this.checkThread();
        return this.mProvider.canZoomOut();
    }

    private final void $$robo$$android_webkit_WebView$zoomBy(float zoomFactor) {
        this.checkThread();
        if ((double)zoomFactor < 0.01) {
            throw new IllegalArgumentException("zoomFactor must be greater than 0.01.");
        }
        if ((double)zoomFactor > 100.0) {
            throw new IllegalArgumentException("zoomFactor must be less than 100.");
        }
        this.mProvider.zoomBy(zoomFactor);
    }

    private final boolean $$robo$$android_webkit_WebView$zoomIn() {
        this.checkThread();
        return this.mProvider.zoomIn();
    }

    private final boolean $$robo$$android_webkit_WebView$zoomOut() {
        this.checkThread();
        return this.mProvider.zoomOut();
    }

    @Deprecated
    private final void $$robo$$android_webkit_WebView$debugDump() {
        this.checkThread();
    }

    private final void $$robo$$android_webkit_WebView$dumpViewHierarchyWithProperties(BufferedWriter out, int level) {
        this.mProvider.dumpViewHierarchyWithProperties(out, level);
    }

    private final View $$robo$$android_webkit_WebView$findHierarchyView(String className, int hashCode) {
        return this.mProvider.findHierarchyView(className, hashCode);
    }

    private final void $$robo$$android_webkit_WebView$setRendererPriorityPolicy(int rendererRequestedPriority, boolean waivedWhenNotVisible) {
        this.mProvider.setRendererPriorityPolicy(rendererRequestedPriority, waivedWhenNotVisible);
    }

    private final int $$robo$$android_webkit_WebView$getRendererRequestedPriority() {
        return this.mProvider.getRendererRequestedPriority();
    }

    private final boolean $$robo$$android_webkit_WebView$getRendererPriorityWaivedWhenNotVisible() {
        return this.mProvider.getRendererPriorityWaivedWhenNotVisible();
    }

    private final void $$robo$$android_webkit_WebView$setTextClassifier(TextClassifier textClassifier) {
        this.mProvider.setTextClassifier(textClassifier);
    }

    private final TextClassifier $$robo$$android_webkit_WebView$getTextClassifier() {
        return this.mProvider.getTextClassifier();
    }

    private static final ClassLoader $$robo$$android_webkit_WebView$getWebViewClassLoader() {
        return WebView.getFactory().getWebViewClassLoader();
    }

    private final Looper $$robo$$android_webkit_WebView$getWebViewLooper() {
        return this.mWebViewThread;
    }

    @SystemApi
    private final WebViewProvider $$robo$$android_webkit_WebView$getWebViewProvider() {
        return this.mProvider;
    }

    private final void $$robo$$android_webkit_WebView$setFindDialogFindListener(FindListener listener) {
        this.checkThread();
        this.setupFindListenerIfNeeded();
        this.mFindListener.mFindDialogFindListener = listener;
    }

    private final void $$robo$$android_webkit_WebView$notifyFindDialogDismissed() {
        this.checkThread();
        this.mProvider.notifyFindDialogDismissed();
    }

    private final void $$robo$$android_webkit_WebView$setupFindListenerIfNeeded() {
        if (this.mFindListener == null) {
            this.mFindListener = new FindListenerDistributor(this, null);
            this.mProvider.setFindListener(this.mFindListener);
        }
    }

    private final void $$robo$$android_webkit_WebView$ensureProviderCreated() {
        this.checkThread();
        if (this.mProvider == null) {
            this.mProvider = WebView.getFactory().createWebView(this, new PrivateAccess(this));
        }
    }

    private static final WebViewFactoryProvider $$robo$$android_webkit_WebView$getFactory() {
        return WebViewFactory.getProvider();
    }

    private final void $$robo$$android_webkit_WebView$checkThread() {
        if (this.mWebViewThread != null && Looper.myLooper() != this.mWebViewThread) {
            Throwable throwable = new Throwable("A WebView method was called on thread '" + Thread.currentThread().getName() + "'. All WebView methods must be called on the same thread. (Expected Looper " + this.mWebViewThread + " called on " + Looper.myLooper() + ", FYI main Looper is " + Looper.getMainLooper() + ")");
            Log.w("WebView", Log.getStackTraceString(throwable));
            StrictMode.onWebViewMethodCalledOnWrongThread(throwable);
            if (sEnforceThreadChecking) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private final void $$robo$$android_webkit_WebView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mProvider.getViewDelegate().onAttachedToWindow();
    }

    private final void $$robo$$android_webkit_WebView$onDetachedFromWindowInternal() {
        this.mProvider.getViewDelegate().onDetachedFromWindow();
        super.onDetachedFromWindowInternal();
    }

    private final void $$robo$$android_webkit_WebView$onMovedToDisplay(int displayId, Configuration config) {
        this.mProvider.getViewDelegate().onMovedToDisplay(displayId, config);
    }

    private final void $$robo$$android_webkit_WebView$setLayoutParams(ViewGroup.LayoutParams params) {
        this.mProvider.getViewDelegate().setLayoutParams(params);
    }

    private final void $$robo$$android_webkit_WebView$setOverScrollMode(int mode) {
        super.setOverScrollMode(mode);
        this.ensureProviderCreated();
        this.mProvider.getViewDelegate().setOverScrollMode(mode);
    }

    private final void $$robo$$android_webkit_WebView$setScrollBarStyle(int style2) {
        this.mProvider.getViewDelegate().setScrollBarStyle(style2);
        super.setScrollBarStyle(style2);
    }

    private final int $$robo$$android_webkit_WebView$computeHorizontalScrollRange() {
        return this.mProvider.getScrollDelegate().computeHorizontalScrollRange();
    }

    private final int $$robo$$android_webkit_WebView$computeHorizontalScrollOffset() {
        return this.mProvider.getScrollDelegate().computeHorizontalScrollOffset();
    }

    private final int $$robo$$android_webkit_WebView$computeVerticalScrollRange() {
        return this.mProvider.getScrollDelegate().computeVerticalScrollRange();
    }

    private final int $$robo$$android_webkit_WebView$computeVerticalScrollOffset() {
        return this.mProvider.getScrollDelegate().computeVerticalScrollOffset();
    }

    private final int $$robo$$android_webkit_WebView$computeVerticalScrollExtent() {
        return this.mProvider.getScrollDelegate().computeVerticalScrollExtent();
    }

    private final void $$robo$$android_webkit_WebView$computeScroll() {
        this.mProvider.getScrollDelegate().computeScroll();
    }

    private final boolean $$robo$$android_webkit_WebView$onHoverEvent(MotionEvent event) {
        return this.mProvider.getViewDelegate().onHoverEvent(event);
    }

    private final boolean $$robo$$android_webkit_WebView$onTouchEvent(MotionEvent event) {
        return this.mProvider.getViewDelegate().onTouchEvent(event);
    }

    private final boolean $$robo$$android_webkit_WebView$onGenericMotionEvent(MotionEvent event) {
        return this.mProvider.getViewDelegate().onGenericMotionEvent(event);
    }

    private final boolean $$robo$$android_webkit_WebView$onTrackballEvent(MotionEvent event) {
        return this.mProvider.getViewDelegate().onTrackballEvent(event);
    }

    private final boolean $$robo$$android_webkit_WebView$onKeyDown(int keyCode, KeyEvent event) {
        return this.mProvider.getViewDelegate().onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$android_webkit_WebView$onKeyUp(int keyCode, KeyEvent event) {
        return this.mProvider.getViewDelegate().onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$android_webkit_WebView$onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return this.mProvider.getViewDelegate().onKeyMultiple(keyCode, repeatCount, event);
    }

    private final AccessibilityNodeProvider $$robo$$android_webkit_WebView$getAccessibilityNodeProvider() {
        AccessibilityNodeProvider provider = this.mProvider.getViewDelegate().getAccessibilityNodeProvider();
        return provider == null ? super.getAccessibilityNodeProvider() : provider;
    }

    @Deprecated
    private final boolean $$robo$$android_webkit_WebView$shouldDelayChildPressedState() {
        return this.mProvider.getViewDelegate().shouldDelayChildPressedState();
    }

    private final CharSequence $$robo$$android_webkit_WebView$getAccessibilityClassName() {
        return WebView.class.getName();
    }

    private final void $$robo$$android_webkit_WebView$onProvideVirtualStructure(ViewStructure structure) {
        this.mProvider.getViewDelegate().onProvideVirtualStructure(structure);
    }

    private final void $$robo$$android_webkit_WebView$onProvideAutofillVirtualStructure(ViewStructure structure, int flags) {
        this.mProvider.getViewDelegate().onProvideAutofillVirtualStructure(structure, flags);
    }

    private final void $$robo$$android_webkit_WebView$autofill(SparseArray<AutofillValue> values) {
        this.mProvider.getViewDelegate().autofill(values);
    }

    private final boolean $$robo$$android_webkit_WebView$isVisibleToUserForAutofill(int virtualId) {
        return this.mProvider.getViewDelegate().isVisibleToUserForAutofill(virtualId);
    }

    private final void $$robo$$android_webkit_WebView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        this.mProvider.getViewDelegate().onInitializeAccessibilityNodeInfo(info);
    }

    private final void $$robo$$android_webkit_WebView$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        this.mProvider.getViewDelegate().onInitializeAccessibilityEvent(event);
    }

    private final boolean $$robo$$android_webkit_WebView$performAccessibilityActionInternal(int action, Bundle arguments) {
        return this.mProvider.getViewDelegate().performAccessibilityAction(action, arguments);
    }

    private final void $$robo$$android_webkit_WebView$onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        this.mProvider.getViewDelegate().onDrawVerticalScrollBar(canvas, scrollBar, l, t, r, b);
    }

    private final void $$robo$$android_webkit_WebView$onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        this.mProvider.getViewDelegate().onOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    private final void $$robo$$android_webkit_WebView$onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mProvider.getViewDelegate().onWindowVisibilityChanged(visibility);
    }

    private final void $$robo$$android_webkit_WebView$onDraw(Canvas canvas) {
        this.mProvider.getViewDelegate().onDraw(canvas);
    }

    private final boolean $$robo$$android_webkit_WebView$performLongClick() {
        return this.mProvider.getViewDelegate().performLongClick();
    }

    private final void $$robo$$android_webkit_WebView$onConfigurationChanged(Configuration newConfig) {
        this.mProvider.getViewDelegate().onConfigurationChanged(newConfig);
    }

    private final InputConnection $$robo$$android_webkit_WebView$onCreateInputConnection(EditorInfo outAttrs) {
        return this.mProvider.getViewDelegate().onCreateInputConnection(outAttrs);
    }

    private final boolean $$robo$$android_webkit_WebView$onDragEvent(DragEvent event) {
        return this.mProvider.getViewDelegate().onDragEvent(event);
    }

    private final void $$robo$$android_webkit_WebView$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.ensureProviderCreated();
        this.mProvider.getViewDelegate().onVisibilityChanged(changedView, visibility);
    }

    private final void $$robo$$android_webkit_WebView$onWindowFocusChanged(boolean hasWindowFocus) {
        this.mProvider.getViewDelegate().onWindowFocusChanged(hasWindowFocus);
        super.onWindowFocusChanged(hasWindowFocus);
    }

    private final void $$robo$$android_webkit_WebView$onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        this.mProvider.getViewDelegate().onFocusChanged(focused, direction, previouslyFocusedRect);
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    private final boolean $$robo$$android_webkit_WebView$setFrame(int left, int top, int right, int bottom) {
        return this.mProvider.getViewDelegate().setFrame(left, top, right, bottom);
    }

    private final void $$robo$$android_webkit_WebView$onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        this.mProvider.getViewDelegate().onSizeChanged(w, h, ow, oh);
    }

    private final void $$robo$$android_webkit_WebView$onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.mProvider.getViewDelegate().onScrollChanged(l, t, oldl, oldt);
    }

    private final boolean $$robo$$android_webkit_WebView$dispatchKeyEvent(KeyEvent event) {
        return this.mProvider.getViewDelegate().dispatchKeyEvent(event);
    }

    private final boolean $$robo$$android_webkit_WebView$requestFocus(int direction, Rect previouslyFocusedRect) {
        return this.mProvider.getViewDelegate().requestFocus(direction, previouslyFocusedRect);
    }

    private final void $$robo$$android_webkit_WebView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mProvider.getViewDelegate().onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private final boolean $$robo$$android_webkit_WebView$requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        return this.mProvider.getViewDelegate().requestChildRectangleOnScreen(child, rect, immediate);
    }

    private final void $$robo$$android_webkit_WebView$setBackgroundColor(int color2) {
        this.mProvider.getViewDelegate().setBackgroundColor(color2);
    }

    private final void $$robo$$android_webkit_WebView$setLayerType(int layerType, Paint paint) {
        super.setLayerType(layerType, paint);
        this.mProvider.getViewDelegate().setLayerType(layerType, paint);
    }

    private final void $$robo$$android_webkit_WebView$dispatchDraw(Canvas canvas) {
        this.mProvider.getViewDelegate().preDispatchDraw(canvas);
        super.dispatchDraw(canvas);
    }

    private final void $$robo$$android_webkit_WebView$onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.mProvider.getViewDelegate().onStartTemporaryDetach();
    }

    private final void $$robo$$android_webkit_WebView$onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.mProvider.getViewDelegate().onFinishTemporaryDetach();
    }

    private final Handler $$robo$$android_webkit_WebView$getHandler() {
        return this.mProvider.getViewDelegate().getHandler(super.getHandler());
    }

    private final View $$robo$$android_webkit_WebView$findFocus() {
        return this.mProvider.getViewDelegate().findFocus(super.findFocus());
    }

    private static final PackageInfo $$robo$$android_webkit_WebView$getCurrentWebViewPackage() {
        PackageInfo webviewPackage = WebViewFactory.getLoadedPackageInfo();
        if (webviewPackage != null) {
            return webviewPackage;
        }
        IWebViewUpdateService service = WebViewFactory.getUpdateService();
        if (service == null) {
            return null;
        }
        try {
            return service.getCurrentWebViewPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_webkit_WebView$onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mProvider.getViewDelegate().onActivityResult(requestCode, resultCode, data);
    }

    private final boolean $$robo$$android_webkit_WebView$onCheckIsTextEditor() {
        return this.mProvider.getViewDelegate().onCheckIsTextEditor();
    }

    private final void $$robo$$android_webkit_WebView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        this.checkThread();
        encoder.addProperty("webview:contentHeight", this.mProvider.getContentHeight());
        encoder.addProperty("webview:contentWidth", this.mProvider.getContentWidth());
        encoder.addProperty("webview:scale", this.mProvider.getScale());
        encoder.addProperty("webview:title", this.mProvider.getTitle());
        encoder.addProperty("webview:url", this.mProvider.getUrl());
        encoder.addProperty("webview:originalUrl", this.mProvider.getOriginalUrl());
    }

    static void __staticInitializer__() {
        sEnforceThreadChecking = false;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_webkit_WebView$__constructor__(context);
    }

    public WebView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_webkit_WebView$__constructor__(context, attributeSet);
    }

    public WebView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842885);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_webkit_WebView$__constructor__(context, attributeSet, n);
    }

    public WebView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_webkit_WebView$__constructor__(context, attributeSet, n, n2);
    }

    public WebView(Context context, AttributeSet attributeSet, int n, int n2) {
        this(context, attributeSet, n, n2, null, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, boolean bl) {
        this.$$robo$$android_webkit_WebView$__constructor__(context, attributeSet, n, bl);
    }

    public WebView(Context context, AttributeSet attributeSet, int n, boolean bl) {
        this(context, attributeSet, n, 0, null, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context android.util.AttributeSet int boolean ), this, context, attributeSet, n, bl);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, Map<String, Object> map, boolean bl) {
        this.$$robo$$android_webkit_WebView$__constructor__(context, attributeSet, n, map, bl);
    }

    public WebView(Context context, AttributeSet attributeSet, int n, Map<String, Object> map, boolean bl) {
        this(context, attributeSet, n, 0, map, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context android.util.AttributeSet int java.util.Map<java.lang.String, java.lang.Object> boolean ), this, context, attributeSet, n, map, bl);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2, Map<String, Object> map, boolean bl) {
        this.$$robo$$android_webkit_WebView$__constructor__(context, attributeSet, n, n2, map, bl);
    }

    public WebView(Context context, AttributeSet attributeSet, int n, int n2, Map<String, Object> map, boolean bl) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView$__constructor__(android.content.Context android.util.AttributeSet int int java.util.Map<java.lang.String, java.lang.Object> boolean ), this, context, attributeSet, n, n2, map, bl);
    }

    @Deprecated
    public void setHorizontalScrollbarOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHorizontalScrollbarOverlay", $$robo$$android_webkit_WebView$setHorizontalScrollbarOverlay(boolean ), this, bl);
    }

    @Deprecated
    public void setVerticalScrollbarOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVerticalScrollbarOverlay", $$robo$$android_webkit_WebView$setVerticalScrollbarOverlay(boolean ), this, bl);
    }

    @Deprecated
    public boolean overlayHorizontalScrollbar() {
        return (boolean)InvokeDynamicSupport.bootstrap("overlayHorizontalScrollbar", $$robo$$android_webkit_WebView$overlayHorizontalScrollbar(), this);
    }

    @Deprecated
    public boolean overlayVerticalScrollbar() {
        return (boolean)InvokeDynamicSupport.bootstrap("overlayVerticalScrollbar", $$robo$$android_webkit_WebView$overlayVerticalScrollbar(), this);
    }

    @Deprecated
    public int getVisibleTitleHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getVisibleTitleHeight", $$robo$$android_webkit_WebView$getVisibleTitleHeight(), this);
    }

    public SslCertificate getCertificate() {
        return InvokeDynamicSupport.bootstrap("getCertificate", $$robo$$android_webkit_WebView$getCertificate(), this);
    }

    @Deprecated
    public void setCertificate(SslCertificate sslCertificate) {
        InvokeDynamicSupport.bootstrap("setCertificate", $$robo$$android_webkit_WebView$setCertificate(android.net.http.SslCertificate ), this, sslCertificate);
    }

    @Deprecated
    public void savePassword(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("savePassword", $$robo$$android_webkit_WebView$savePassword(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    @Deprecated
    public void setHttpAuthUsernamePassword(String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("setHttpAuthUsernamePassword", $$robo$$android_webkit_WebView$setHttpAuthUsernamePassword(java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5);
    }

    @Deprecated
    public String[] getHttpAuthUsernamePassword(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getHttpAuthUsernamePassword", $$robo$$android_webkit_WebView$getHttpAuthUsernamePassword(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_webkit_WebView$destroy(), this);
    }

    @Deprecated
    public static void enablePlatformNotifications() {
        InvokeDynamicSupport.bootstrapStatic("enablePlatformNotifications", $$robo$$android_webkit_WebView$enablePlatformNotifications());
    }

    @Deprecated
    public static void disablePlatformNotifications() {
        InvokeDynamicSupport.bootstrapStatic("disablePlatformNotifications", $$robo$$android_webkit_WebView$disablePlatformNotifications());
    }

    public static void freeMemoryForTests() {
        InvokeDynamicSupport.bootstrapStatic("freeMemoryForTests", $$robo$$android_webkit_WebView$freeMemoryForTests());
    }

    public void setNetworkAvailable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNetworkAvailable", $$robo$$android_webkit_WebView$setNetworkAvailable(boolean ), this, bl);
    }

    public WebBackForwardList saveState(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("saveState", $$robo$$android_webkit_WebView$saveState(android.os.Bundle ), this, bundle);
    }

    @Deprecated
    public boolean savePicture(Bundle bundle, File file) {
        return (boolean)InvokeDynamicSupport.bootstrap("savePicture", $$robo$$android_webkit_WebView$savePicture(android.os.Bundle java.io.File ), this, bundle, file);
    }

    @Deprecated
    public boolean restorePicture(Bundle bundle, File file) {
        return (boolean)InvokeDynamicSupport.bootstrap("restorePicture", $$robo$$android_webkit_WebView$restorePicture(android.os.Bundle java.io.File ), this, bundle, file);
    }

    public WebBackForwardList restoreState(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("restoreState", $$robo$$android_webkit_WebView$restoreState(android.os.Bundle ), this, bundle);
    }

    public void loadUrl(String string2, Map<String, String> map) {
        InvokeDynamicSupport.bootstrap("loadUrl", $$robo$$android_webkit_WebView$loadUrl(java.lang.String java.util.Map<java.lang.String, java.lang.String> ), this, string2, map);
    }

    public void loadUrl(String string2) {
        InvokeDynamicSupport.bootstrap("loadUrl", $$robo$$android_webkit_WebView$loadUrl(java.lang.String ), this, string2);
    }

    public void postUrl(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("postUrl", $$robo$$android_webkit_WebView$postUrl(java.lang.String byte[] ), this, string2, byArray);
    }

    public void loadData(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("loadData", $$robo$$android_webkit_WebView$loadData(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        InvokeDynamicSupport.bootstrap("loadDataWithBaseURL", $$robo$$android_webkit_WebView$loadDataWithBaseURL(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5, string6);
    }

    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        InvokeDynamicSupport.bootstrap("evaluateJavascript", $$robo$$android_webkit_WebView$evaluateJavascript(java.lang.String android.webkit.ValueCallback<java.lang.String> ), this, string2, valueCallback);
    }

    public void saveWebArchive(String string2) {
        InvokeDynamicSupport.bootstrap("saveWebArchive", $$robo$$android_webkit_WebView$saveWebArchive(java.lang.String ), this, string2);
    }

    public void saveWebArchive(String string2, boolean bl, ValueCallback<String> valueCallback) {
        InvokeDynamicSupport.bootstrap("saveWebArchive", $$robo$$android_webkit_WebView$saveWebArchive(java.lang.String boolean android.webkit.ValueCallback<java.lang.String> ), this, string2, bl, valueCallback);
    }

    public void stopLoading() {
        InvokeDynamicSupport.bootstrap("stopLoading", $$robo$$android_webkit_WebView$stopLoading(), this);
    }

    public void reload() {
        InvokeDynamicSupport.bootstrap("reload", $$robo$$android_webkit_WebView$reload(), this);
    }

    public boolean canGoBack() {
        return (boolean)InvokeDynamicSupport.bootstrap("canGoBack", $$robo$$android_webkit_WebView$canGoBack(), this);
    }

    public void goBack() {
        InvokeDynamicSupport.bootstrap("goBack", $$robo$$android_webkit_WebView$goBack(), this);
    }

    public boolean canGoForward() {
        return (boolean)InvokeDynamicSupport.bootstrap("canGoForward", $$robo$$android_webkit_WebView$canGoForward(), this);
    }

    public void goForward() {
        InvokeDynamicSupport.bootstrap("goForward", $$robo$$android_webkit_WebView$goForward(), this);
    }

    public boolean canGoBackOrForward(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("canGoBackOrForward", $$robo$$android_webkit_WebView$canGoBackOrForward(int ), this, n);
    }

    public void goBackOrForward(int n) {
        InvokeDynamicSupport.bootstrap("goBackOrForward", $$robo$$android_webkit_WebView$goBackOrForward(int ), this, n);
    }

    public boolean isPrivateBrowsingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrivateBrowsingEnabled", $$robo$$android_webkit_WebView$isPrivateBrowsingEnabled(), this);
    }

    public boolean pageUp(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("pageUp", $$robo$$android_webkit_WebView$pageUp(boolean ), this, bl);
    }

    public boolean pageDown(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("pageDown", $$robo$$android_webkit_WebView$pageDown(boolean ), this, bl);
    }

    public void postVisualStateCallback(long l, VisualStateCallback visualStateCallback) {
        InvokeDynamicSupport.bootstrap("postVisualStateCallback", $$robo$$android_webkit_WebView$postVisualStateCallback(long android.webkit.WebView$VisualStateCallback ), this, l, visualStateCallback);
    }

    @Deprecated
    public void clearView() {
        InvokeDynamicSupport.bootstrap("clearView", $$robo$$android_webkit_WebView$clearView(), this);
    }

    @Deprecated
    public Picture capturePicture() {
        return InvokeDynamicSupport.bootstrap("capturePicture", $$robo$$android_webkit_WebView$capturePicture(), this);
    }

    @Deprecated
    public PrintDocumentAdapter createPrintDocumentAdapter() {
        return InvokeDynamicSupport.bootstrap("createPrintDocumentAdapter", $$robo$$android_webkit_WebView$createPrintDocumentAdapter(), this);
    }

    public PrintDocumentAdapter createPrintDocumentAdapter(String string2) {
        return InvokeDynamicSupport.bootstrap("createPrintDocumentAdapter", $$robo$$android_webkit_WebView$createPrintDocumentAdapter(java.lang.String ), this, string2);
    }

    @Deprecated
    @ViewDebug.ExportedProperty(category="webview")
    public float getScale() {
        return (float)InvokeDynamicSupport.bootstrap("getScale", $$robo$$android_webkit_WebView$getScale(), this);
    }

    public void setInitialScale(int n) {
        InvokeDynamicSupport.bootstrap("setInitialScale", $$robo$$android_webkit_WebView$setInitialScale(int ), this, n);
    }

    public void invokeZoomPicker() {
        InvokeDynamicSupport.bootstrap("invokeZoomPicker", $$robo$$android_webkit_WebView$invokeZoomPicker(), this);
    }

    public HitTestResult getHitTestResult() {
        return InvokeDynamicSupport.bootstrap("getHitTestResult", $$robo$$android_webkit_WebView$getHitTestResult(), this);
    }

    public void requestFocusNodeHref(Message message) {
        InvokeDynamicSupport.bootstrap("requestFocusNodeHref", $$robo$$android_webkit_WebView$requestFocusNodeHref(android.os.Message ), this, message);
    }

    public void requestImageRef(Message message) {
        InvokeDynamicSupport.bootstrap("requestImageRef", $$robo$$android_webkit_WebView$requestImageRef(android.os.Message ), this, message);
    }

    @ViewDebug.ExportedProperty(category="webview")
    public String getUrl() {
        return InvokeDynamicSupport.bootstrap("getUrl", $$robo$$android_webkit_WebView$getUrl(), this);
    }

    @ViewDebug.ExportedProperty(category="webview")
    public String getOriginalUrl() {
        return InvokeDynamicSupport.bootstrap("getOriginalUrl", $$robo$$android_webkit_WebView$getOriginalUrl(), this);
    }

    @ViewDebug.ExportedProperty(category="webview")
    public String getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_webkit_WebView$getTitle(), this);
    }

    public Bitmap getFavicon() {
        return InvokeDynamicSupport.bootstrap("getFavicon", $$robo$$android_webkit_WebView$getFavicon(), this);
    }

    public String getTouchIconUrl() {
        return InvokeDynamicSupport.bootstrap("getTouchIconUrl", $$robo$$android_webkit_WebView$getTouchIconUrl(), this);
    }

    public int getProgress() {
        return (int)InvokeDynamicSupport.bootstrap("getProgress", $$robo$$android_webkit_WebView$getProgress(), this);
    }

    @ViewDebug.ExportedProperty(category="webview")
    public int getContentHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getContentHeight", $$robo$$android_webkit_WebView$getContentHeight(), this);
    }

    @ViewDebug.ExportedProperty(category="webview")
    public int getContentWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getContentWidth", $$robo$$android_webkit_WebView$getContentWidth(), this);
    }

    public void pauseTimers() {
        InvokeDynamicSupport.bootstrap("pauseTimers", $$robo$$android_webkit_WebView$pauseTimers(), this);
    }

    public void resumeTimers() {
        InvokeDynamicSupport.bootstrap("resumeTimers", $$robo$$android_webkit_WebView$resumeTimers(), this);
    }

    public void onPause() {
        InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_webkit_WebView$onPause(), this);
    }

    public void onResume() {
        InvokeDynamicSupport.bootstrap("onResume", $$robo$$android_webkit_WebView$onResume(), this);
    }

    public boolean isPaused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPaused", $$robo$$android_webkit_WebView$isPaused(), this);
    }

    @Deprecated
    public void freeMemory() {
        InvokeDynamicSupport.bootstrap("freeMemory", $$robo$$android_webkit_WebView$freeMemory(), this);
    }

    public void clearCache(boolean bl) {
        InvokeDynamicSupport.bootstrap("clearCache", $$robo$$android_webkit_WebView$clearCache(boolean ), this, bl);
    }

    public void clearFormData() {
        InvokeDynamicSupport.bootstrap("clearFormData", $$robo$$android_webkit_WebView$clearFormData(), this);
    }

    public void clearHistory() {
        InvokeDynamicSupport.bootstrap("clearHistory", $$robo$$android_webkit_WebView$clearHistory(), this);
    }

    public void clearSslPreferences() {
        InvokeDynamicSupport.bootstrap("clearSslPreferences", $$robo$$android_webkit_WebView$clearSslPreferences(), this);
    }

    public static void clearClientCertPreferences(Runnable runnable) {
        InvokeDynamicSupport.bootstrapStatic("clearClientCertPreferences", $$robo$$android_webkit_WebView$clearClientCertPreferences(java.lang.Runnable ), (Runnable)runnable);
    }

    public static void startSafeBrowsing(Context context, ValueCallback<Boolean> valueCallback) {
        InvokeDynamicSupport.bootstrapStatic("startSafeBrowsing", $$robo$$android_webkit_WebView$startSafeBrowsing(android.content.Context android.webkit.ValueCallback<java.lang.Boolean> ), (Context)context, valueCallback);
    }

    public static void setSafeBrowsingWhitelist(List<String> list, ValueCallback<Boolean> valueCallback) {
        InvokeDynamicSupport.bootstrapStatic("setSafeBrowsingWhitelist", $$robo$$android_webkit_WebView$setSafeBrowsingWhitelist(java.util.List<java.lang.String> android.webkit.ValueCallback<java.lang.Boolean> ), list, valueCallback);
    }

    public static Uri getSafeBrowsingPrivacyPolicyUrl() {
        return InvokeDynamicSupport.bootstrapStatic("getSafeBrowsingPrivacyPolicyUrl", $$robo$$android_webkit_WebView$getSafeBrowsingPrivacyPolicyUrl());
    }

    public WebBackForwardList copyBackForwardList() {
        return InvokeDynamicSupport.bootstrap("copyBackForwardList", $$robo$$android_webkit_WebView$copyBackForwardList(), this);
    }

    public void setFindListener(FindListener findListener) {
        InvokeDynamicSupport.bootstrap("setFindListener", $$robo$$android_webkit_WebView$setFindListener(android.webkit.WebView$FindListener ), this, findListener);
    }

    public void findNext(boolean bl) {
        InvokeDynamicSupport.bootstrap("findNext", $$robo$$android_webkit_WebView$findNext(boolean ), this, bl);
    }

    @Deprecated
    public int findAll(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("findAll", $$robo$$android_webkit_WebView$findAll(java.lang.String ), this, string2);
    }

    public void findAllAsync(String string2) {
        InvokeDynamicSupport.bootstrap("findAllAsync", $$robo$$android_webkit_WebView$findAllAsync(java.lang.String ), this, string2);
    }

    @Deprecated
    public boolean showFindDialog(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("showFindDialog", $$robo$$android_webkit_WebView$showFindDialog(java.lang.String boolean ), this, string2, bl);
    }

    @Deprecated
    public static String findAddress(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findAddress", $$robo$$android_webkit_WebView$findAddress(java.lang.String ), (String)string2);
    }

    public static void enableSlowWholeDocumentDraw() {
        InvokeDynamicSupport.bootstrapStatic("enableSlowWholeDocumentDraw", $$robo$$android_webkit_WebView$enableSlowWholeDocumentDraw());
    }

    public void clearMatches() {
        InvokeDynamicSupport.bootstrap("clearMatches", $$robo$$android_webkit_WebView$clearMatches(), this);
    }

    public void documentHasImages(Message message) {
        InvokeDynamicSupport.bootstrap("documentHasImages", $$robo$$android_webkit_WebView$documentHasImages(android.os.Message ), this, message);
    }

    public void setWebViewClient(WebViewClient webViewClient) {
        InvokeDynamicSupport.bootstrap("setWebViewClient", $$robo$$android_webkit_WebView$setWebViewClient(android.webkit.WebViewClient ), this, webViewClient);
    }

    public WebViewClient getWebViewClient() {
        return InvokeDynamicSupport.bootstrap("getWebViewClient", $$robo$$android_webkit_WebView$getWebViewClient(), this);
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        InvokeDynamicSupport.bootstrap("setDownloadListener", $$robo$$android_webkit_WebView$setDownloadListener(android.webkit.DownloadListener ), this, downloadListener);
    }

    public void setWebChromeClient(WebChromeClient webChromeClient) {
        InvokeDynamicSupport.bootstrap("setWebChromeClient", $$robo$$android_webkit_WebView$setWebChromeClient(android.webkit.WebChromeClient ), this, webChromeClient);
    }

    public WebChromeClient getWebChromeClient() {
        return InvokeDynamicSupport.bootstrap("getWebChromeClient", $$robo$$android_webkit_WebView$getWebChromeClient(), this);
    }

    @Deprecated
    public void setPictureListener(PictureListener pictureListener) {
        InvokeDynamicSupport.bootstrap("setPictureListener", $$robo$$android_webkit_WebView$setPictureListener(android.webkit.WebView$PictureListener ), this, pictureListener);
    }

    public void addJavascriptInterface(Object object, String string2) {
        InvokeDynamicSupport.bootstrap("addJavascriptInterface", $$robo$$android_webkit_WebView$addJavascriptInterface(java.lang.Object java.lang.String ), this, object, string2);
    }

    public void removeJavascriptInterface(String string2) {
        InvokeDynamicSupport.bootstrap("removeJavascriptInterface", $$robo$$android_webkit_WebView$removeJavascriptInterface(java.lang.String ), this, string2);
    }

    public WebMessagePort[] createWebMessageChannel() {
        return InvokeDynamicSupport.bootstrap("createWebMessageChannel", $$robo$$android_webkit_WebView$createWebMessageChannel(), this);
    }

    public void postWebMessage(WebMessage webMessage, Uri uri) {
        InvokeDynamicSupport.bootstrap("postWebMessage", $$robo$$android_webkit_WebView$postWebMessage(android.webkit.WebMessage android.net.Uri ), this, webMessage, uri);
    }

    public WebSettings getSettings() {
        return InvokeDynamicSupport.bootstrap("getSettings", $$robo$$android_webkit_WebView$getSettings(), this);
    }

    public static void setWebContentsDebuggingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setWebContentsDebuggingEnabled", $$robo$$android_webkit_WebView$setWebContentsDebuggingEnabled(boolean ), (boolean)bl);
    }

    @Deprecated
    public static synchronized PluginList getPluginList() {
        return InvokeDynamicSupport.bootstrapStatic("getPluginList", $$robo$$android_webkit_WebView$getPluginList());
    }

    public static void setDataDirectorySuffix(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDataDirectorySuffix", $$robo$$android_webkit_WebView$setDataDirectorySuffix(java.lang.String ), (String)string2);
    }

    public static void disableWebView() {
        InvokeDynamicSupport.bootstrapStatic("disableWebView", $$robo$$android_webkit_WebView$disableWebView());
    }

    @Deprecated
    public void refreshPlugins(boolean bl) {
        InvokeDynamicSupport.bootstrap("refreshPlugins", $$robo$$android_webkit_WebView$refreshPlugins(boolean ), this, bl);
    }

    @Deprecated
    public void emulateShiftHeld() {
        InvokeDynamicSupport.bootstrap("emulateShiftHeld", $$robo$$android_webkit_WebView$emulateShiftHeld(), this);
    }

    @Override
    @Deprecated
    public void onChildViewAdded(View view, View view2) {
        InvokeDynamicSupport.bootstrap("onChildViewAdded", $$robo$$android_webkit_WebView$onChildViewAdded(android.view.View android.view.View ), this, view, view2);
    }

    @Override
    @Deprecated
    public void onChildViewRemoved(View view, View view2) {
        InvokeDynamicSupport.bootstrap("onChildViewRemoved", $$robo$$android_webkit_WebView$onChildViewRemoved(android.view.View android.view.View ), this, view, view2);
    }

    @Override
    @Deprecated
    public void onGlobalFocusChanged(View view, View view2) {
        InvokeDynamicSupport.bootstrap("onGlobalFocusChanged", $$robo$$android_webkit_WebView$onGlobalFocusChanged(android.view.View android.view.View ), this, view, view2);
    }

    @Deprecated
    public void setMapTrackballToArrowKeys(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMapTrackballToArrowKeys", $$robo$$android_webkit_WebView$setMapTrackballToArrowKeys(boolean ), this, bl);
    }

    public void flingScroll(int n, int n2) {
        InvokeDynamicSupport.bootstrap("flingScroll", $$robo$$android_webkit_WebView$flingScroll(int int ), this, n, n2);
    }

    @Deprecated
    public View getZoomControls() {
        return InvokeDynamicSupport.bootstrap("getZoomControls", $$robo$$android_webkit_WebView$getZoomControls(), this);
    }

    @Deprecated
    public boolean canZoomIn() {
        return (boolean)InvokeDynamicSupport.bootstrap("canZoomIn", $$robo$$android_webkit_WebView$canZoomIn(), this);
    }

    @Deprecated
    public boolean canZoomOut() {
        return (boolean)InvokeDynamicSupport.bootstrap("canZoomOut", $$robo$$android_webkit_WebView$canZoomOut(), this);
    }

    public void zoomBy(float f) {
        InvokeDynamicSupport.bootstrap("zoomBy", $$robo$$android_webkit_WebView$zoomBy(float ), this, f);
    }

    public boolean zoomIn() {
        return (boolean)InvokeDynamicSupport.bootstrap("zoomIn", $$robo$$android_webkit_WebView$zoomIn(), this);
    }

    public boolean zoomOut() {
        return (boolean)InvokeDynamicSupport.bootstrap("zoomOut", $$robo$$android_webkit_WebView$zoomOut(), this);
    }

    @Deprecated
    public void debugDump() {
        InvokeDynamicSupport.bootstrap("debugDump", $$robo$$android_webkit_WebView$debugDump(), this);
    }

    @Override
    public void dumpViewHierarchyWithProperties(BufferedWriter bufferedWriter, int n) {
        InvokeDynamicSupport.bootstrap("dumpViewHierarchyWithProperties", $$robo$$android_webkit_WebView$dumpViewHierarchyWithProperties(java.io.BufferedWriter int ), this, bufferedWriter, n);
    }

    @Override
    public View findHierarchyView(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("findHierarchyView", $$robo$$android_webkit_WebView$findHierarchyView(java.lang.String int ), this, string2, n);
    }

    public void setRendererPriorityPolicy(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRendererPriorityPolicy", $$robo$$android_webkit_WebView$setRendererPriorityPolicy(int boolean ), this, n, bl);
    }

    public int getRendererRequestedPriority() {
        return (int)InvokeDynamicSupport.bootstrap("getRendererRequestedPriority", $$robo$$android_webkit_WebView$getRendererRequestedPriority(), this);
    }

    public boolean getRendererPriorityWaivedWhenNotVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRendererPriorityWaivedWhenNotVisible", $$robo$$android_webkit_WebView$getRendererPriorityWaivedWhenNotVisible(), this);
    }

    public void setTextClassifier(TextClassifier textClassifier) {
        InvokeDynamicSupport.bootstrap("setTextClassifier", $$robo$$android_webkit_WebView$setTextClassifier(android.view.textclassifier.TextClassifier ), this, textClassifier);
    }

    public TextClassifier getTextClassifier() {
        return InvokeDynamicSupport.bootstrap("getTextClassifier", $$robo$$android_webkit_WebView$getTextClassifier(), this);
    }

    public static ClassLoader getWebViewClassLoader() {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewClassLoader", $$robo$$android_webkit_WebView$getWebViewClassLoader());
    }

    public Looper getWebViewLooper() {
        return InvokeDynamicSupport.bootstrap("getWebViewLooper", $$robo$$android_webkit_WebView$getWebViewLooper(), this);
    }

    @SystemApi
    public WebViewProvider getWebViewProvider() {
        return InvokeDynamicSupport.bootstrap("getWebViewProvider", $$robo$$android_webkit_WebView$getWebViewProvider(), this);
    }

    void setFindDialogFindListener(FindListener findListener) {
        InvokeDynamicSupport.bootstrap("setFindDialogFindListener", $$robo$$android_webkit_WebView$setFindDialogFindListener(android.webkit.WebView$FindListener ), this, findListener);
    }

    void notifyFindDialogDismissed() {
        InvokeDynamicSupport.bootstrap("notifyFindDialogDismissed", $$robo$$android_webkit_WebView$notifyFindDialogDismissed(), this);
    }

    private void setupFindListenerIfNeeded() {
        InvokeDynamicSupport.bootstrap("setupFindListenerIfNeeded", $$robo$$android_webkit_WebView$setupFindListenerIfNeeded(), this);
    }

    private void ensureProviderCreated() {
        InvokeDynamicSupport.bootstrap("ensureProviderCreated", $$robo$$android_webkit_WebView$ensureProviderCreated(), this);
    }

    private static WebViewFactoryProvider getFactory() {
        return InvokeDynamicSupport.bootstrapStatic("getFactory", $$robo$$android_webkit_WebView$getFactory());
    }

    private void checkThread() {
        InvokeDynamicSupport.bootstrap("checkThread", $$robo$$android_webkit_WebView$checkThread(), this);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_webkit_WebView$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindowInternal() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindowInternal", $$robo$$android_webkit_WebView$onDetachedFromWindowInternal(), this);
    }

    @Override
    public void onMovedToDisplay(int n, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onMovedToDisplay", $$robo$$android_webkit_WebView$onMovedToDisplay(int android.content.res.Configuration ), this, n, configuration);
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("setLayoutParams", $$robo$$android_webkit_WebView$setLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    public void setOverScrollMode(int n) {
        InvokeDynamicSupport.bootstrap("setOverScrollMode", $$robo$$android_webkit_WebView$setOverScrollMode(int ), this, n);
    }

    @Override
    public void setScrollBarStyle(int n) {
        InvokeDynamicSupport.bootstrap("setScrollBarStyle", $$robo$$android_webkit_WebView$setScrollBarStyle(int ), this, n);
    }

    @Override
    protected int computeHorizontalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollRange", $$robo$$android_webkit_WebView$computeHorizontalScrollRange(), this);
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollOffset", $$robo$$android_webkit_WebView$computeHorizontalScrollOffset(), this);
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$android_webkit_WebView$computeVerticalScrollRange(), this);
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$android_webkit_WebView$computeVerticalScrollOffset(), this);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$android_webkit_WebView$computeVerticalScrollExtent(), this);
    }

    @Override
    public void computeScroll() {
        InvokeDynamicSupport.bootstrap("computeScroll", $$robo$$android_webkit_WebView$computeScroll(), this);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHoverEvent", $$robo$$android_webkit_WebView$onHoverEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_webkit_WebView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_webkit_WebView$onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_webkit_WebView$onTrackballEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_webkit_WebView$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_webkit_WebView$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_webkit_WebView$onKeyMultiple(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityNodeProvider", $$robo$$android_webkit_WebView$getAccessibilityNodeProvider(), this);
    }

    @Override
    @Deprecated
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_webkit_WebView$shouldDelayChildPressedState(), this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_webkit_WebView$getAccessibilityClassName(), this);
    }

    @Override
    public void onProvideVirtualStructure(ViewStructure viewStructure) {
        InvokeDynamicSupport.bootstrap("onProvideVirtualStructure", $$robo$$android_webkit_WebView$onProvideVirtualStructure(android.view.ViewStructure ), this, viewStructure);
    }

    @Override
    public void onProvideAutofillVirtualStructure(ViewStructure viewStructure, int n) {
        InvokeDynamicSupport.bootstrap("onProvideAutofillVirtualStructure", $$robo$$android_webkit_WebView$onProvideAutofillVirtualStructure(android.view.ViewStructure int ), this, viewStructure, n);
    }

    @Override
    public void autofill(SparseArray<AutofillValue> sparseArray) {
        InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_webkit_WebView$autofill(android.util.SparseArray<android.view.autofill.AutofillValue> ), this, sparseArray);
    }

    @Override
    public boolean isVisibleToUserForAutofill(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisibleToUserForAutofill", $$robo$$android_webkit_WebView$isVisibleToUserForAutofill(int ), this, n);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_webkit_WebView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_webkit_WebView$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_webkit_WebView$performAccessibilityActionInternal(int android.os.Bundle ), this, n, bundle);
    }

    @Override
    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable drawable2, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onDrawVerticalScrollBar", $$robo$$android_webkit_WebView$onDrawVerticalScrollBar(android.graphics.Canvas android.graphics.drawable.Drawable int int int int ), this, canvas, drawable2, n, n2, n3, n4);
    }

    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("onOverScrolled", $$robo$$android_webkit_WebView$onOverScrolled(int int boolean boolean ), this, n, n2, bl, bl2);
    }

    @Override
    protected void onWindowVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowVisibilityChanged", $$robo$$android_webkit_WebView$onWindowVisibilityChanged(int ), this, n);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_webkit_WebView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public boolean performLongClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performLongClick", $$robo$$android_webkit_WebView$performLongClick(), this);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_webkit_WebView$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        return InvokeDynamicSupport.bootstrap("onCreateInputConnection", $$robo$$android_webkit_WebView$onCreateInputConnection(android.view.inputmethod.EditorInfo ), this, editorInfo);
    }

    @Override
    public boolean onDragEvent(DragEvent dragEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDragEvent", $$robo$$android_webkit_WebView$onDragEvent(android.view.DragEvent ), this, dragEvent);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_webkit_WebView$onVisibilityChanged(android.view.View int ), this, view, n);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_webkit_WebView$onWindowFocusChanged(boolean ), this, bl);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_webkit_WebView$onFocusChanged(boolean int android.graphics.Rect ), this, bl, n, rect);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_webkit_WebView$setFrame(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_webkit_WebView$onSizeChanged(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_webkit_WebView$onScrollChanged(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_webkit_WebView$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    @Override
    public boolean requestFocus(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestFocus", $$robo$$android_webkit_WebView$requestFocus(int android.graphics.Rect ), this, n, rect);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_webkit_WebView$onMeasure(int int ), this, n, n2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$android_webkit_WebView$requestChildRectangleOnScreen(android.view.View android.graphics.Rect boolean ), this, view, rect, bl);
    }

    @Override
    public void setBackgroundColor(int n) {
        InvokeDynamicSupport.bootstrap("setBackgroundColor", $$robo$$android_webkit_WebView$setBackgroundColor(int ), this, n);
    }

    @Override
    public void setLayerType(int n, Paint paint) {
        InvokeDynamicSupport.bootstrap("setLayerType", $$robo$$android_webkit_WebView$setLayerType(int android.graphics.Paint ), this, n, paint);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_webkit_WebView$dispatchDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public void onStartTemporaryDetach() {
        InvokeDynamicSupport.bootstrap("onStartTemporaryDetach", $$robo$$android_webkit_WebView$onStartTemporaryDetach(), this);
    }

    @Override
    public void onFinishTemporaryDetach() {
        InvokeDynamicSupport.bootstrap("onFinishTemporaryDetach", $$robo$$android_webkit_WebView$onFinishTemporaryDetach(), this);
    }

    @Override
    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_webkit_WebView$getHandler(), this);
    }

    @Override
    public View findFocus() {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_webkit_WebView$findFocus(), this);
    }

    public static PackageInfo getCurrentWebViewPackage() {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentWebViewPackage", $$robo$$android_webkit_WebView$getCurrentWebViewPackage());
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("onActivityResult", $$robo$$android_webkit_WebView$onActivityResult(int int android.content.Intent ), this, n, n2, intent);
    }

    @Override
    public boolean onCheckIsTextEditor() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCheckIsTextEditor", $$robo$$android_webkit_WebView$onCheckIsTextEditor(), this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_webkit_WebView$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    static {
        RobolectricInternals.classInitializing(WebView.class);
    }

    public /* synthetic */ WebView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class FindListenerDistributor
    implements FindListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private FindListener mFindDialogFindListener;
        private FindListener mUserFindListener;
        /* synthetic */ WebView this$0;

        private void $$robo$$android_webkit_WebView_FindListenerDistributor$__constructor__(WebView webView) {
            this.this$0 = webView;
        }

        private final void $$robo$$android_webkit_WebView_FindListenerDistributor$onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
            if (this.mFindDialogFindListener != null) {
                this.mFindDialogFindListener.onFindResultReceived(activeMatchOrdinal, numberOfMatches, isDoneCounting);
            }
            if (this.mUserFindListener != null) {
                this.mUserFindListener.onFindResultReceived(activeMatchOrdinal, numberOfMatches, isDoneCounting);
            }
        }

        private /* synthetic */ void $$robo$$android_webkit_WebView_FindListenerDistributor$__constructor__(WebView x0, 1 x1) {
        }

        private void __constructor__(WebView webView) {
            this.$$robo$$android_webkit_WebView_FindListenerDistributor$__constructor__(webView);
        }

        public FindListenerDistributor(WebView webView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView_FindListenerDistributor$__constructor__(android.webkit.WebView ), this, webView);
        }

        @Override
        public void onFindResultReceived(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("onFindResultReceived", $$robo$$android_webkit_WebView_FindListenerDistributor$onFindResultReceived(int int boolean ), this, n, n2, bl);
        }

        private /* synthetic */ void __constructor__(WebView webView, 1 var2_2) {
            this.$$robo$$android_webkit_WebView_FindListenerDistributor$__constructor__(webView, var2_2);
        }

        public /* synthetic */ FindListenerDistributor(WebView webView, 1 var2_2) {
            this(webView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView_FindListenerDistributor$__constructor__(android.webkit.WebView android.webkit.WebView$1 ), this, webView, var2_2);
        }

        public /* synthetic */ FindListenerDistributor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FindListenerDistributor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public class PrivateAccess
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ WebView this$0;

        private void $$robo$$android_webkit_WebView_PrivateAccess$__constructor__(WebView this$0) {
            this.this$0 = this$0;
        }

        private final int $$robo$$android_webkit_WebView_PrivateAccess$super_getScrollBarStyle() {
            return WebView.super.getScrollBarStyle();
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$super_scrollTo(int scrollX, int scrollY) {
            WebView.super.scrollTo(scrollX, scrollY);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$super_computeScroll() {
            WebView.super.computeScroll();
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_onHoverEvent(MotionEvent event) {
            return WebView.super.onHoverEvent(event);
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_performAccessibilityAction(int action, Bundle arguments) {
            return WebView.super.performAccessibilityActionInternal(action, arguments);
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_performLongClick() {
            return WebView.super.performLongClick();
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_setFrame(int left, int top, int right, int bottom) {
            return WebView.super.setFrame(left, top, right, bottom);
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_dispatchKeyEvent(KeyEvent event) {
            return WebView.super.dispatchKeyEvent(event);
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_onGenericMotionEvent(MotionEvent event) {
            return WebView.super.onGenericMotionEvent(event);
        }

        private final boolean $$robo$$android_webkit_WebView_PrivateAccess$super_requestFocus(int direction, Rect previouslyFocusedRect) {
            return WebView.super.requestFocus(direction, previouslyFocusedRect);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$super_setLayoutParams(ViewGroup.LayoutParams params) {
            WebView.super.setLayoutParams(params);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$super_startActivityForResult(Intent intent, int requestCode) {
            WebView.super.startActivityForResult(intent, requestCode);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            this.this$0.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$awakenScrollBars(int duration) {
            this.this$0.awakenScrollBars(duration);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$awakenScrollBars(int duration, boolean invalidate) {
            this.this$0.awakenScrollBars(duration, invalidate);
        }

        private final float $$robo$$android_webkit_WebView_PrivateAccess$getVerticalScrollFactor() {
            return this.this$0.getVerticalScrollFactor();
        }

        private final float $$robo$$android_webkit_WebView_PrivateAccess$getHorizontalScrollFactor() {
            return this.this$0.getHorizontalScrollFactor();
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$setMeasuredDimension(int measuredWidth, int measuredHeight) {
            this.this$0.setMeasuredDimension(measuredWidth, measuredHeight);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$onScrollChanged(int l, int t, int oldl, int oldt) {
            this.this$0.onScrollChanged(l, t, oldl, oldt);
        }

        private final int $$robo$$android_webkit_WebView_PrivateAccess$getHorizontalScrollbarHeight() {
            return this.this$0.getHorizontalScrollbarHeight();
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$super_onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
            WebView.super.onDrawVerticalScrollBar(canvas, scrollBar, l, t, r, b);
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$setScrollXRaw(int scrollX) {
            this.this$0.mScrollX = scrollX;
        }

        private final void $$robo$$android_webkit_WebView_PrivateAccess$setScrollYRaw(int scrollY) {
            this.this$0.mScrollY = scrollY;
        }

        private void __constructor__(WebView webView) {
            this.$$robo$$android_webkit_WebView_PrivateAccess$__constructor__(webView);
        }

        public PrivateAccess(WebView webView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView_PrivateAccess$__constructor__(android.webkit.WebView ), this, webView);
        }

        public int super_getScrollBarStyle() {
            return (int)InvokeDynamicSupport.bootstrap("super_getScrollBarStyle", $$robo$$android_webkit_WebView_PrivateAccess$super_getScrollBarStyle(), this);
        }

        public void super_scrollTo(int n, int n2) {
            InvokeDynamicSupport.bootstrap("super_scrollTo", $$robo$$android_webkit_WebView_PrivateAccess$super_scrollTo(int int ), this, n, n2);
        }

        public void super_computeScroll() {
            InvokeDynamicSupport.bootstrap("super_computeScroll", $$robo$$android_webkit_WebView_PrivateAccess$super_computeScroll(), this);
        }

        public boolean super_onHoverEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("super_onHoverEvent", $$robo$$android_webkit_WebView_PrivateAccess$super_onHoverEvent(android.view.MotionEvent ), this, motionEvent);
        }

        public boolean super_performAccessibilityAction(int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("super_performAccessibilityAction", $$robo$$android_webkit_WebView_PrivateAccess$super_performAccessibilityAction(int android.os.Bundle ), this, n, bundle);
        }

        public boolean super_performLongClick() {
            return (boolean)InvokeDynamicSupport.bootstrap("super_performLongClick", $$robo$$android_webkit_WebView_PrivateAccess$super_performLongClick(), this);
        }

        public boolean super_setFrame(int n, int n2, int n3, int n4) {
            return (boolean)InvokeDynamicSupport.bootstrap("super_setFrame", $$robo$$android_webkit_WebView_PrivateAccess$super_setFrame(int int int int ), this, n, n2, n3, n4);
        }

        public boolean super_dispatchKeyEvent(KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("super_dispatchKeyEvent", $$robo$$android_webkit_WebView_PrivateAccess$super_dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
        }

        public boolean super_onGenericMotionEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("super_onGenericMotionEvent", $$robo$$android_webkit_WebView_PrivateAccess$super_onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
        }

        public boolean super_requestFocus(int n, Rect rect) {
            return (boolean)InvokeDynamicSupport.bootstrap("super_requestFocus", $$robo$$android_webkit_WebView_PrivateAccess$super_requestFocus(int android.graphics.Rect ), this, n, rect);
        }

        public void super_setLayoutParams(ViewGroup.LayoutParams layoutParams) {
            InvokeDynamicSupport.bootstrap("super_setLayoutParams", $$robo$$android_webkit_WebView_PrivateAccess$super_setLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        public void super_startActivityForResult(Intent intent, int n) {
            InvokeDynamicSupport.bootstrap("super_startActivityForResult", $$robo$$android_webkit_WebView_PrivateAccess$super_startActivityForResult(android.content.Intent int ), this, intent, n);
        }

        public void overScrollBy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
            InvokeDynamicSupport.bootstrap("overScrollBy", $$robo$$android_webkit_WebView_PrivateAccess$overScrollBy(int int int int int int int int boolean ), this, n, n2, n3, n4, n5, n6, n7, n8, bl);
        }

        public void awakenScrollBars(int n) {
            InvokeDynamicSupport.bootstrap("awakenScrollBars", $$robo$$android_webkit_WebView_PrivateAccess$awakenScrollBars(int ), this, n);
        }

        public void awakenScrollBars(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("awakenScrollBars", $$robo$$android_webkit_WebView_PrivateAccess$awakenScrollBars(int boolean ), this, n, bl);
        }

        public float getVerticalScrollFactor() {
            return (float)InvokeDynamicSupport.bootstrap("getVerticalScrollFactor", $$robo$$android_webkit_WebView_PrivateAccess$getVerticalScrollFactor(), this);
        }

        public float getHorizontalScrollFactor() {
            return (float)InvokeDynamicSupport.bootstrap("getHorizontalScrollFactor", $$robo$$android_webkit_WebView_PrivateAccess$getHorizontalScrollFactor(), this);
        }

        public void setMeasuredDimension(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setMeasuredDimension", $$robo$$android_webkit_WebView_PrivateAccess$setMeasuredDimension(int int ), this, n, n2);
        }

        public void onScrollChanged(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_webkit_WebView_PrivateAccess$onScrollChanged(int int int int ), this, n, n2, n3, n4);
        }

        public int getHorizontalScrollbarHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalScrollbarHeight", $$robo$$android_webkit_WebView_PrivateAccess$getHorizontalScrollbarHeight(), this);
        }

        public void super_onDrawVerticalScrollBar(Canvas canvas, Drawable drawable2, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("super_onDrawVerticalScrollBar", $$robo$$android_webkit_WebView_PrivateAccess$super_onDrawVerticalScrollBar(android.graphics.Canvas android.graphics.drawable.Drawable int int int int ), this, canvas, drawable2, n, n2, n3, n4);
        }

        public void setScrollXRaw(int n) {
            InvokeDynamicSupport.bootstrap("setScrollXRaw", $$robo$$android_webkit_WebView_PrivateAccess$setScrollXRaw(int ), this, n);
        }

        public void setScrollYRaw(int n) {
            InvokeDynamicSupport.bootstrap("setScrollYRaw", $$robo$$android_webkit_WebView_PrivateAccess$setScrollYRaw(int ), this, n);
        }

        public /* synthetic */ PrivateAccess() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrivateAccess)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RendererPriority {
    }

    public static class HitTestResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int UNKNOWN_TYPE = 0;
        @Deprecated
        public static int ANCHOR_TYPE = 1;
        public static int PHONE_TYPE = 2;
        public static int GEO_TYPE = 3;
        public static int EMAIL_TYPE = 4;
        public static int IMAGE_TYPE = 5;
        @Deprecated
        public static int IMAGE_ANCHOR_TYPE = 6;
        public static int SRC_ANCHOR_TYPE = 7;
        public static int SRC_IMAGE_ANCHOR_TYPE = 8;
        public static int EDIT_TEXT_TYPE = 9;
        private int mType;
        private String mExtra;

        @SystemApi
        private void $$robo$$android_webkit_WebView_HitTestResult$__constructor__() {
            this.mType = 0;
        }

        @SystemApi
        private final void $$robo$$android_webkit_WebView_HitTestResult$setType(int type) {
            this.mType = type;
        }

        @SystemApi
        private final void $$robo$$android_webkit_WebView_HitTestResult$setExtra(String extra) {
            this.mExtra = extra;
        }

        private final int $$robo$$android_webkit_WebView_HitTestResult$getType() {
            return this.mType;
        }

        private final String $$robo$$android_webkit_WebView_HitTestResult$getExtra() {
            return this.mExtra;
        }

        private void __constructor__() {
            this.$$robo$$android_webkit_WebView_HitTestResult$__constructor__();
        }

        public HitTestResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView_HitTestResult$__constructor__(), this);
        }

        @SystemApi
        public void setType(int n) {
            InvokeDynamicSupport.bootstrap("setType", $$robo$$android_webkit_WebView_HitTestResult$setType(int ), this, n);
        }

        @SystemApi
        public void setExtra(String string2) {
            InvokeDynamicSupport.bootstrap("setExtra", $$robo$$android_webkit_WebView_HitTestResult$setExtra(java.lang.String ), this, string2);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_webkit_WebView_HitTestResult$getType(), this);
        }

        public String getExtra() {
            return InvokeDynamicSupport.bootstrap("getExtra", $$robo$$android_webkit_WebView_HitTestResult$getExtra(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HitTestResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface PictureListener {
        @Deprecated
        public void onNewPicture(WebView var1, Picture var2);
    }

    public static abstract class VisualStateCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebView_VisualStateCallback$__constructor__() {
        }

        public abstract void onComplete(long var1);

        private void __constructor__() {
            this.$$robo$$android_webkit_WebView_VisualStateCallback$__constructor__();
        }

        public VisualStateCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView_VisualStateCallback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VisualStateCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface FindListener {
        public void onFindResultReceived(int var1, int var2, boolean var3);
    }

    public class WebViewTransport
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WebView mWebview;
        /* synthetic */ WebView this$0;

        private void $$robo$$android_webkit_WebView_WebViewTransport$__constructor__(WebView this$0) {
            this.this$0 = this$0;
        }

        private final synchronized void $$robo$$android_webkit_WebView_WebViewTransport$setWebView(WebView webview) {
            this.mWebview = webview;
        }

        private final synchronized WebView $$robo$$android_webkit_WebView_WebViewTransport$getWebView() {
            return this.mWebview;
        }

        private void __constructor__(WebView webView) {
            this.$$robo$$android_webkit_WebView_WebViewTransport$__constructor__(webView);
        }

        public WebViewTransport(WebView webView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebView_WebViewTransport$__constructor__(android.webkit.WebView ), this, webView);
        }

        public synchronized void setWebView(WebView webView) {
            InvokeDynamicSupport.bootstrap("setWebView", $$robo$$android_webkit_WebView_WebViewTransport$setWebView(android.webkit.WebView ), this, webView);
        }

        public synchronized WebView getWebView() {
            return InvokeDynamicSupport.bootstrap("getWebView", $$robo$$android_webkit_WebView_WebViewTransport$getWebView(), this);
        }

        public /* synthetic */ WebViewTransport() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewTransport)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

