/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.PendingIntent;
import android.app.RemoteAction;
import android.content.ComponentName;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.os.UserManager;
import android.provider.CalendarContract;
import android.view.textclassifier.GenerateLinksLogger;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImplNative;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassifierImpl
implements TextClassifier,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "androidtc";
    private static String MODEL_DIR = "/etc/textclassifier/";
    private static String MODEL_FILE_REGEX = "textclassifier\\.(.*)\\.model";
    private static String UPDATED_MODEL_FILE_PATH = "/data/misc/textclassifier/textclassifier.model";
    private Context mContext;
    private TextClassifier mFallback;
    private GenerateLinksLogger mGenerateLinksLogger;
    private Object mLock;
    @GuardedBy(value="mLock")
    private List<ModelFile> mAllModelFiles;
    @GuardedBy(value="mLock")
    private ModelFile mModel;
    @GuardedBy(value="mLock")
    private TextClassifierImplNative mNative;
    private Object mLoggerLock;
    @GuardedBy(value="mLoggerLock")
    private SelectionSessionLogger mSessionLogger;
    private TextClassificationConstants mSettings;

    private void $$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(Context context, TextClassificationConstants settings, TextClassifier fallback) {
        this.mLock = new Object();
        this.mLoggerLock = new Object();
        this.mContext = Preconditions.checkNotNull(context);
        this.mFallback = Preconditions.checkNotNull(fallback);
        this.mSettings = Preconditions.checkNotNull(settings);
        this.mGenerateLinksLogger = new GenerateLinksLogger(this.mSettings.getGenerateLinksLogSampleRate());
    }

    private void $$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(Context context, TextClassificationConstants settings) {
    }

    private final TextSelection $$robo$$android_view_textclassifier_TextClassifierImpl$suggestSelection(TextSelection.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            int rangeLength = request.getEndIndex() - request.getStartIndex();
            String string2 = request.getText().toString();
            if (string2.length() > 0 && rangeLength <= this.mSettings.getSuggestSelectionMaxRangeLength()) {
                int end;
                int start;
                String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
                ZonedDateTime refTime = ZonedDateTime.now();
                TextClassifierImplNative nativeImpl = this.getNative(request.getDefaultLocales());
                if (this.mSettings.isModelDarkLaunchEnabled() && !request.isDarkLaunchAllowed()) {
                    start = request.getStartIndex();
                    end = request.getEndIndex();
                } else {
                    int[] startEnd = nativeImpl.suggestSelection(string2, request.getStartIndex(), request.getEndIndex(), new TextClassifierImplNative.SelectionOptions(localesString));
                    start = startEnd[0];
                    end = startEnd[1];
                }
                if (start < end && start >= 0 && end <= string2.length() && start <= request.getStartIndex() && end >= request.getEndIndex()) {
                    TextSelection.Builder tsBuilder = new TextSelection.Builder(start, end);
                    TextClassifierImplNative.ClassificationResult[] results = nativeImpl.classifyText(string2, start, end, new TextClassifierImplNative.ClassificationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString));
                    int size = results.length;
                    for (int i = 0; i < size; ++i) {
                        tsBuilder.setEntityType(results[i].getCollection(), results[i].getScore());
                    }
                    return tsBuilder.setId(this.createId(string2, request.getStartIndex(), request.getEndIndex())).build();
                }
                Log.d("androidtc", "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e("androidtc", "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return this.mFallback.suggestSelection(request);
    }

    private final TextClassification $$robo$$android_view_textclassifier_TextClassifierImpl$classifyText(TextClassification.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            int rangeLength = request.getEndIndex() - request.getStartIndex();
            String string2 = request.getText().toString();
            if (string2.length() > 0 && rangeLength <= this.mSettings.getClassifyTextMaxRangeLength()) {
                String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
                ZonedDateTime refTime = request.getReferenceTime() != null ? request.getReferenceTime() : ZonedDateTime.now();
                TextClassifierImplNative.ClassificationResult[] results = this.getNative(request.getDefaultLocales()).classifyText(string2, request.getStartIndex(), request.getEndIndex(), new TextClassifierImplNative.ClassificationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString));
                if (results.length > 0) {
                    return this.createClassificationResult(results, string2, request.getStartIndex(), request.getEndIndex(), refTime.toInstant());
                }
            }
        }
        catch (Throwable t) {
            Log.e("androidtc", "Error getting text classification info.", t);
        }
        return this.mFallback.classifyText(request);
    }

    private final TextLinks $$robo$$android_view_textclassifier_TextClassifierImpl$generateLinks(TextLinks.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkTextLength(request.getText(), this.getMaxGenerateLinksTextLength());
        TextClassifier.Utils.checkMainThread();
        if (!this.mSettings.isSmartLinkifyEnabled() && request.isLegacyFallback()) {
            return TextClassifier.Utils.generateLegacyLinks(request);
        }
        String textString = request.getText().toString();
        TextLinks.Builder builder = new TextLinks.Builder(textString);
        try {
            TextClassifierImplNative.AnnotatedSpan[] annotations;
            CallSite startTimeMs = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            ZonedDateTime refTime = ZonedDateTime.now();
            List<String> entitiesToIdentify = request.getEntityConfig() != null ? request.getEntityConfig().resolveEntityListModifications(this.getEntitiesForHints(request.getEntityConfig().getHints())) : this.mSettings.getEntityListDefault();
            TextClassifierImplNative nativeImpl = this.getNative(request.getDefaultLocales());
            for (TextClassifierImplNative.AnnotatedSpan span : annotations = nativeImpl.annotate(textString, new TextClassifierImplNative.AnnotationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), TextClassifierImpl.concatenateLocales(request.getDefaultLocales())))) {
                TextClassifierImplNative.ClassificationResult[] results = span.getClassification();
                if (results.length == 0 || !entitiesToIdentify.contains(results[0].getCollection())) continue;
                HashMap<String, Float> entityScores = new HashMap<String, Float>();
                for (int i = 0; i < results.length; ++i) {
                    entityScores.put(results[i].getCollection(), Float.valueOf(results[i].getScore()));
                }
                builder.addLink(span.getStartIndex(), span.getEndIndex(), entityScores);
            }
            TextLinks links = builder.build();
            CallSite endTimeMs = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            String callingPackageName = request.getCallingPackageName() == null ? this.mContext.getPackageName() : request.getCallingPackageName();
            this.mGenerateLinksLogger.logGenerateLinks(request.getText(), links, callingPackageName, (long)(endTimeMs - startTimeMs));
            return links;
        }
        catch (Throwable t) {
            Log.e("androidtc", "Error getting links info.", t);
            return this.mFallback.generateLinks(request);
        }
    }

    private final int $$robo$$android_view_textclassifier_TextClassifierImpl$getMaxGenerateLinksTextLength() {
        return this.mSettings.getGenerateLinksMaxTextLength();
    }

    private final Collection<String> $$robo$$android_view_textclassifier_TextClassifierImpl$getEntitiesForHints(Collection<String> hints) {
        boolean notEditable;
        boolean useDefault;
        boolean editable = hints.contains("android.text_is_editable");
        boolean bl = useDefault = editable == (notEditable = hints.contains("android.text_is_not_editable"));
        if (useDefault) {
            return this.mSettings.getEntityListDefault();
        }
        if (editable) {
            return this.mSettings.getEntityListEditable();
        }
        return this.mSettings.getEntityListNotEditable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_textclassifier_TextClassifierImpl$onSelectionEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        Object object = this.mLoggerLock;
        synchronized (object) {
            if (this.mSessionLogger == null) {
                this.mSessionLogger = new SelectionSessionLogger();
            }
            this.mSessionLogger.writeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextClassifierImplNative $$robo$$android_view_textclassifier_TextClassifierImpl$getNative(LocaleList localeList) throws FileNotFoundException {
        Object object = this.mLock;
        synchronized (object) {
            localeList = localeList == null ? LocaleList.getEmptyLocaleList() : localeList;
            ModelFile bestModel = this.findBestModelLocked(localeList);
            if (bestModel == null) {
                throw new FileNotFoundException("No model for " + localeList.toLanguageTags());
            }
            if (this.mNative == null || !Objects.equals(this.mModel, bestModel)) {
                Log.d("androidtc", "Loading " + bestModel);
                this.destroyNativeIfExistsLocked();
                ParcelFileDescriptor fd = ParcelFileDescriptor.open(new File(bestModel.getPath()), 0x10000000);
                this.mNative = new TextClassifierImplNative(fd.getFd());
                TextClassifierImpl.closeAndLogError(fd);
                this.mModel = bestModel;
            }
            return this.mNative;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_view_textclassifier_TextClassifierImpl$createId(String text, int start, int end) {
        Object object = this.mLock;
        synchronized (object) {
            return SelectionSessionLogger.createId(text, start, end, this.mContext, this.mModel.getVersion(), this.mModel.getSupportedLocales());
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_textclassifier_TextClassifierImpl$destroyNativeIfExistsLocked() {
        if (this.mNative != null) {
            this.mNative.close();
            this.mNative = null;
        }
    }

    private static final String $$robo$$android_view_textclassifier_TextClassifierImpl$concatenateLocales(LocaleList locales) {
        return locales == null ? "" : locales.toLanguageTags();
    }

    @GuardedBy(value="mLock")
    private final ModelFile $$robo$$android_view_textclassifier_TextClassifierImpl$findBestModelLocked(LocaleList localeList) {
        String languages = localeList.isEmpty() ? LocaleList.getDefault().toLanguageTags() : localeList.toLanguageTags() + "," + LocaleList.getDefault().toLanguageTags();
        List<Locale.LanguageRange> languageRangeList = Locale.LanguageRange.parse(languages);
        ModelFile bestModel = null;
        for (ModelFile model : this.listAllModelsLocked()) {
            if (!model.isAnyLanguageSupported(languageRangeList) || !model.isPreferredTo(bestModel)) continue;
            bestModel = model;
        }
        return bestModel;
    }

    @GuardedBy(value="mLock")
    private final List<ModelFile> $$robo$$android_view_textclassifier_TextClassifierImpl$listAllModelsLocked() {
        if (this.mAllModelFiles == null) {
            File modelsDir;
            ModelFile updatedModel;
            ArrayList<ModelFile> allModels = new ArrayList<ModelFile>();
            if (new File("/data/misc/textclassifier/textclassifier.model").exists() && (updatedModel = ModelFile.fromPath("/data/misc/textclassifier/textclassifier.model")) != null) {
                allModels.add(updatedModel);
            }
            if ((modelsDir = new File("/etc/textclassifier/")).exists() && modelsDir.isDirectory()) {
                File[] modelFiles = modelsDir.listFiles();
                Pattern modelFilenamePattern = Pattern.compile("textclassifier\\.(.*)\\.model");
                for (File modelFile : modelFiles) {
                    ModelFile model;
                    Matcher matcher = modelFilenamePattern.matcher(modelFile.getName());
                    if (!matcher.matches() || !modelFile.isFile() || (model = ModelFile.fromPath(modelFile.getAbsolutePath())) == null) continue;
                    allModels.add(model);
                }
            }
            this.mAllModelFiles = allModels;
        }
        return this.mAllModelFiles;
    }

    private final TextClassification $$robo$$android_view_textclassifier_TextClassifierImpl$createClassificationResult(TextClassifierImplNative.ClassificationResult[] classifications, String text, int start, int end, Instant referenceTime) {
        String classifiedText = text.substring(start, end);
        TextClassification.Builder builder = new TextClassification.Builder().setText(classifiedText);
        int size = classifications.length;
        TextClassifierImplNative.ClassificationResult highestScoringResult = null;
        float highestScore = Float.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            builder.setEntityType(classifications[i].getCollection(), classifications[i].getScore());
            if (!(classifications[i].getScore() > highestScore)) continue;
            highestScoringResult = classifications[i];
            highestScore = classifications[i].getScore();
        }
        boolean isPrimaryAction = true;
        for (LabeledIntent labeledIntent : IntentFactory.create(this.mContext, referenceTime, highestScoringResult, classifiedText)) {
            RemoteAction action = labeledIntent.asRemoteAction(this.mContext);
            if (action == null) continue;
            if (isPrimaryAction) {
                builder.setIcon(action.getIcon().loadDrawable(this.mContext));
                builder.setLabel(action.getTitle().toString());
                builder.setIntent(labeledIntent.getIntent());
                builder.setOnClickListener(TextClassification.createIntentOnClickListener(TextClassification.createPendingIntent(this.mContext, labeledIntent.getIntent(), labeledIntent.getRequestCode())));
                isPrimaryAction = false;
            }
            builder.addAction(action);
        }
        return builder.setId(this.createId(text, start, end)).build();
    }

    private static final void $$robo$$android_view_textclassifier_TextClassifierImpl$closeAndLogError(ParcelFileDescriptor fd) {
        try {
            fd.close();
        }
        catch (IOException e) {
            Log.e("androidtc", "Error closing file.", e);
        }
    }

    private void __constructor__(Context context, TextClassificationConstants textClassificationConstants, TextClassifier textClassifier) {
        this.$$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(context, textClassificationConstants, textClassifier);
    }

    public TextClassifierImpl(Context context, TextClassificationConstants textClassificationConstants, TextClassifier textClassifier) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(android.content.Context android.view.textclassifier.TextClassificationConstants android.view.textclassifier.TextClassifier ), this, context, textClassificationConstants, textClassifier);
    }

    private void __constructor__(Context context, TextClassificationConstants textClassificationConstants) {
        this.$$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(context, textClassificationConstants);
    }

    public TextClassifierImpl(Context context, TextClassificationConstants textClassificationConstants) {
        this(context, textClassificationConstants, TextClassifier.NO_OP);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(android.content.Context android.view.textclassifier.TextClassificationConstants ), this, context, textClassificationConstants);
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        return InvokeDynamicSupport.bootstrap("suggestSelection", $$robo$$android_view_textclassifier_TextClassifierImpl$suggestSelection(android.view.textclassifier.TextSelection$Request ), this, request);
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        return InvokeDynamicSupport.bootstrap("classifyText", $$robo$$android_view_textclassifier_TextClassifierImpl$classifyText(android.view.textclassifier.TextClassification$Request ), this, request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        return InvokeDynamicSupport.bootstrap("generateLinks", $$robo$$android_view_textclassifier_TextClassifierImpl$generateLinks(android.view.textclassifier.TextLinks$Request ), this, request);
    }

    @Override
    public int getMaxGenerateLinksTextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxGenerateLinksTextLength", $$robo$$android_view_textclassifier_TextClassifierImpl$getMaxGenerateLinksTextLength(), this);
    }

    private Collection<String> getEntitiesForHints(Collection<String> collection) {
        return InvokeDynamicSupport.bootstrap("getEntitiesForHints", $$robo$$android_view_textclassifier_TextClassifierImpl$getEntitiesForHints(java.util.Collection<java.lang.String> ), this, collection);
    }

    @Override
    public void onSelectionEvent(SelectionEvent selectionEvent) {
        InvokeDynamicSupport.bootstrap("onSelectionEvent", $$robo$$android_view_textclassifier_TextClassifierImpl$onSelectionEvent(android.view.textclassifier.SelectionEvent ), this, selectionEvent);
    }

    private TextClassifierImplNative getNative(LocaleList localeList) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getNative", $$robo$$android_view_textclassifier_TextClassifierImpl$getNative(android.os.LocaleList ), this, localeList);
    }

    private String createId(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createId", $$robo$$android_view_textclassifier_TextClassifierImpl$createId(java.lang.String int int ), this, string2, n, n2);
    }

    private void destroyNativeIfExistsLocked() {
        InvokeDynamicSupport.bootstrap("destroyNativeIfExistsLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$destroyNativeIfExistsLocked(), this);
    }

    private static String concatenateLocales(LocaleList localeList) {
        return InvokeDynamicSupport.bootstrapStatic("concatenateLocales", $$robo$$android_view_textclassifier_TextClassifierImpl$concatenateLocales(android.os.LocaleList ), (LocaleList)localeList);
    }

    private ModelFile findBestModelLocked(LocaleList localeList) {
        return InvokeDynamicSupport.bootstrap("findBestModelLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$findBestModelLocked(android.os.LocaleList ), this, localeList);
    }

    private List<ModelFile> listAllModelsLocked() {
        return InvokeDynamicSupport.bootstrap("listAllModelsLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$listAllModelsLocked(), this);
    }

    private TextClassification createClassificationResult(TextClassifierImplNative.ClassificationResult[] classificationResultArray, String string2, int n, int n2, Instant instant) {
        return InvokeDynamicSupport.bootstrap("createClassificationResult", $$robo$$android_view_textclassifier_TextClassifierImpl$createClassificationResult(android.view.textclassifier.TextClassifierImplNative$ClassificationResult[] java.lang.String int int java.time.Instant ), this, classificationResultArray, string2, n, n2, instant);
    }

    private static void closeAndLogError(ParcelFileDescriptor parcelFileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("closeAndLogError", $$robo$$android_view_textclassifier_TextClassifierImpl$closeAndLogError(android.os.ParcelFileDescriptor ), (ParcelFileDescriptor)parcelFileDescriptor);
    }

    public /* synthetic */ TextClassifierImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassifierImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class IntentFactory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long MIN_EVENT_FUTURE_MILLIS;
        private static long DEFAULT_EVENT_DURATION;

        private void $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$__constructor__() {
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$create(Context context, Instant referenceTime, TextClassifierImplNative.ClassificationResult classification, String text) {
            String type = classification.getCollection().trim().toLowerCase(Locale.ENGLISH);
            text = text.trim();
            switch (type) {
                case "email": {
                    return IntentFactory.createForEmail(context, text);
                }
                case "phone": {
                    return IntentFactory.createForPhone(context, text);
                }
                case "address": {
                    return IntentFactory.createForAddress(context, text);
                }
                case "url": {
                    return IntentFactory.createForUrl(context, text);
                }
                case "date": 
                case "datetime": {
                    if (classification.getDatetimeResult() != null) {
                        Instant parsedTime = Instant.ofEpochMilli(classification.getDatetimeResult().getTimeMsUtc());
                        return IntentFactory.createForDatetime(context, type, referenceTime, parsedTime);
                    }
                    return new ArrayList<LabeledIntent>();
                }
                case "flight": {
                    return IntentFactory.createForFlight(context, text);
                }
            }
            return new ArrayList<LabeledIntent>();
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForEmail(Context context, String text) {
            return Arrays.asList(new LabeledIntent(context.getString(17039817), context.getString(17039823), new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text))), 0), new LabeledIntent(context.getString(17039451), context.getString(17039452), new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("email", text), text.hashCode()));
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForPhone(Context context, String text) {
            Bundle userRestrictions;
            ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
            UserManager userManager = context.getSystemService(UserManager.class);
            Bundle bundle = userRestrictions = userManager != null ? userManager.getUserRestrictions() : new Bundle();
            if (!userRestrictions.getBoolean("no_outgoing_calls", false)) {
                actions.add(new LabeledIntent(context.getString(17039796), context.getString(17039797), new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text))), 0));
            }
            actions.add(new LabeledIntent(context.getString(17039451), context.getString(17039452), new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("phone", text), text.hashCode()));
            if (!userRestrictions.getBoolean("no_sms", false)) {
                actions.add(new LabeledIntent(context.getString(17040886), context.getString(17040891), new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("smsto:%s", text))), 0));
            }
            return actions;
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForAddress(Context context, String text) {
            ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
            try {
                String encText = URLEncoder.encode(text, "UTF-8");
                actions.add(new LabeledIntent(context.getString(17040198), context.getString(17040199), new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", encText))), 0));
            }
            catch (UnsupportedEncodingException e) {
                Log.e("androidtc", "Could not encode address", e);
            }
            return actions;
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForUrl(Context context, String text) {
            if (Uri.parse(text).getScheme() == null) {
                text = "http://" + text;
            }
            return Arrays.asList(new LabeledIntent(context.getString(17039582), context.getString(17039583), new Intent("android.intent.action.VIEW", Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName()), 0));
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForDatetime(Context context, String type, Instant referenceTime, Instant parsedTime) {
            if (referenceTime == null) {
                referenceTime = Instant.now();
            }
            ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
            actions.add(IntentFactory.createCalendarViewIntent(context, parsedTime));
            long millisUntilEvent = referenceTime.until(parsedTime, ChronoUnit.MILLIS);
            if (millisUntilEvent > MIN_EVENT_FUTURE_MILLIS) {
                actions.add(IntentFactory.createCalendarCreateEventIntent(context, parsedTime, type));
            }
            return actions;
        }

        private static final List<LabeledIntent> $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForFlight(Context context, String text) {
            return Arrays.asList(new LabeledIntent(context.getString(17041028), context.getString(17041029), new Intent("android.intent.action.WEB_SEARCH").putExtra("query", text), text.hashCode()));
        }

        private static final LabeledIntent $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createCalendarViewIntent(Context context, Instant parsedTime) {
            Uri.Builder builder = CalendarContract.CONTENT_URI.buildUpon();
            builder.appendPath("time");
            ContentUris.appendId(builder, parsedTime.toEpochMilli());
            return new LabeledIntent(context.getString(17041026), context.getString(17041027), new Intent("android.intent.action.VIEW").setData(builder.build()), 0);
        }

        private static final LabeledIntent $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createCalendarCreateEventIntent(Context context, Instant parsedTime, String type) {
            boolean isAllDay = "date".equals(type);
            return new LabeledIntent(context.getString(17039449), context.getString(17039450), new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("allDay", isAllDay).putExtra("beginTime", parsedTime.toEpochMilli()).putExtra("endTime", parsedTime.toEpochMilli() + DEFAULT_EVENT_DURATION), parsedTime.hashCode());
        }

        static void __staticInitializer__() {
            MIN_EVENT_FUTURE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
            DEFAULT_EVENT_DURATION = TimeUnit.HOURS.toMillis(1L);
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$__constructor__();
        }

        public IntentFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$__constructor__(), this);
        }

        public static List<LabeledIntent> create(Context context, Instant instant, TextClassifierImplNative.ClassificationResult classificationResult, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$create(android.content.Context java.time.Instant android.view.textclassifier.TextClassifierImplNative$ClassificationResult java.lang.String ), (Context)context, (Instant)instant, (TextClassifierImplNative.ClassificationResult)classificationResult, (String)string2);
        }

        private static List<LabeledIntent> createForEmail(Context context, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createForEmail", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForEmail(android.content.Context java.lang.String ), (Context)context, (String)string2);
        }

        private static List<LabeledIntent> createForPhone(Context context, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createForPhone", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForPhone(android.content.Context java.lang.String ), (Context)context, (String)string2);
        }

        private static List<LabeledIntent> createForAddress(Context context, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createForAddress", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForAddress(android.content.Context java.lang.String ), (Context)context, (String)string2);
        }

        private static List<LabeledIntent> createForUrl(Context context, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createForUrl", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForUrl(android.content.Context java.lang.String ), (Context)context, (String)string2);
        }

        private static List<LabeledIntent> createForDatetime(Context context, String string2, Instant instant, Instant instant2) {
            return InvokeDynamicSupport.bootstrapStatic("createForDatetime", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForDatetime(android.content.Context java.lang.String java.time.Instant java.time.Instant ), (Context)context, (String)string2, (Instant)instant, (Instant)instant2);
        }

        private static List<LabeledIntent> createForFlight(Context context, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createForFlight", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createForFlight(android.content.Context java.lang.String ), (Context)context, (String)string2);
        }

        private static LabeledIntent createCalendarViewIntent(Context context, Instant instant) {
            return InvokeDynamicSupport.bootstrapStatic("createCalendarViewIntent", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createCalendarViewIntent(android.content.Context java.time.Instant ), (Context)context, (Instant)instant);
        }

        private static LabeledIntent createCalendarCreateEventIntent(Context context, Instant instant, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createCalendarCreateEventIntent", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$createCalendarCreateEventIntent(android.content.Context java.time.Instant java.lang.String ), (Context)context, (Instant)instant, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(IntentFactory.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LabeledIntent
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static int DEFAULT_REQUEST_CODE = 0;
        private String mTitle;
        private String mDescription;
        private Intent mIntent;
        private int mRequestCode;

        private void $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$__constructor__(String title, String description, Intent intent, int requestCode) {
            this.mTitle = title;
            this.mDescription = description;
            this.mIntent = intent;
            this.mRequestCode = requestCode;
        }

        private final String $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getTitle() {
            return this.mTitle;
        }

        private final String $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getDescription() {
            return this.mDescription;
        }

        private final Intent $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getIntent() {
            return this.mIntent;
        }

        private final int $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getRequestCode() {
            return this.mRequestCode;
        }

        private final RemoteAction $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$asRemoteAction(Context context) {
            PendingIntent pendingIntent;
            PackageManager pm = context.getPackageManager();
            ResolveInfo resolveInfo = pm.resolveActivity(this.mIntent, 0);
            String packageName = resolveInfo != null && resolveInfo.activityInfo != null ? resolveInfo.activityInfo.packageName : null;
            Icon icon = null;
            boolean shouldShowIcon = false;
            if (packageName != null && !"android".equals(packageName)) {
                this.mIntent.setComponent(new ComponentName(packageName, resolveInfo.activityInfo.name));
                if (resolveInfo.activityInfo.getIconResource() != 0) {
                    icon = Icon.createWithResource(packageName, resolveInfo.activityInfo.getIconResource());
                    shouldShowIcon = true;
                }
            }
            if (icon == null) {
                icon = Icon.createWithResource("android", 17302684);
            }
            if ((pendingIntent = TextClassification.createPendingIntent(context, this.mIntent, this.mRequestCode)) == null) {
                return null;
            }
            RemoteAction action = new RemoteAction(icon, this.mTitle, this.mDescription, pendingIntent);
            action.setShouldShowIcon(shouldShowIcon);
            return action;
        }

        private void __constructor__(String string2, String string3, Intent intent, int n) {
            this.$$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$__constructor__(string2, string3, intent, n);
        }

        public LabeledIntent(String string2, String string3, Intent intent, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$__constructor__(java.lang.String java.lang.String android.content.Intent int ), this, string2, string3, intent, n);
        }

        String getTitle() {
            return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getTitle(), this);
        }

        String getDescription() {
            return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getDescription(), this);
        }

        Intent getIntent() {
            return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getIntent(), this);
        }

        int getRequestCode() {
            return (int)InvokeDynamicSupport.bootstrap("getRequestCode", $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$getRequestCode(), this);
        }

        RemoteAction asRemoteAction(Context context) {
            return InvokeDynamicSupport.bootstrap("asRemoteAction", $$robo$$android_view_textclassifier_TextClassifierImpl_LabeledIntent$asRemoteAction(android.content.Context ), this, context);
        }

        public /* synthetic */ LabeledIntent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LabeledIntent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ModelFile
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mPath;
        private String mName;
        private int mVersion;
        private List<Locale> mSupportedLocales;
        private boolean mLanguageIndependent;

        private static final ModelFile $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$fromPath(String path) {
            File file = new File(path);
            try {
                ParcelFileDescriptor modelFd = ParcelFileDescriptor.open(file, 0x10000000);
                int version = TextClassifierImplNative.getVersion(modelFd.getFd());
                String supportedLocalesStr = TextClassifierImplNative.getLocales(modelFd.getFd());
                if (supportedLocalesStr.isEmpty()) {
                    Log.d("androidtc", "Ignoring " + file.getAbsolutePath());
                    return null;
                }
                boolean languageIndependent = supportedLocalesStr.equals("*");
                ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
                for (String langTag : supportedLocalesStr.split(",")) {
                    supportedLocales.add(Locale.forLanguageTag(langTag));
                }
                TextClassifierImpl.closeAndLogError(modelFd);
                return new ModelFile(path, file.getName(), version, supportedLocales, languageIndependent);
            }
            catch (FileNotFoundException e) {
                Log.e("androidtc", "Failed to peek " + file.getAbsolutePath(), e);
                return null;
            }
        }

        private final String $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getPath() {
            return this.mPath;
        }

        private final String $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getName() {
            return this.mName;
        }

        private final int $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getVersion() {
            return this.mVersion;
        }

        private final boolean $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$isAnyLanguageSupported(List<Locale.LanguageRange> languageRanges) {
            return this.mLanguageIndependent || Locale.lookup(languageRanges, this.mSupportedLocales) != null;
        }

        private final List<Locale> $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getSupportedLocales() {
            return Collections.unmodifiableList(this.mSupportedLocales);
        }

        private final boolean $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$isPreferredTo(ModelFile model) {
            if (model == null) {
                return true;
            }
            if (!this.mLanguageIndependent && model.mLanguageIndependent) {
                return true;
            }
            return this.getVersion() > model.getVersion();
        }

        private final boolean $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !ModelFile.class.isAssignableFrom(other.getClass())) {
                return false;
            }
            ModelFile otherModel = (ModelFile)other;
            return this.mPath.equals(otherModel.mPath);
        }

        private final String $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$toString() {
            StringJoiner localesJoiner = new StringJoiner(",");
            for (Locale locale : this.mSupportedLocales) {
                localesJoiner.add(locale.toLanguageTag());
            }
            return String.format(Locale.US, "ModelFile { path=%s name=%s version=%d locales=%s }", this.mPath, this.mName, this.mVersion, localesJoiner.toString());
        }

        private void $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$__constructor__(String path, String name, int version, List<Locale> supportedLocales, boolean languageIndependent) {
            this.mPath = path;
            this.mName = name;
            this.mVersion = version;
            this.mSupportedLocales = supportedLocales;
            this.mLanguageIndependent = languageIndependent;
        }

        static ModelFile fromPath(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("fromPath", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$fromPath(java.lang.String ), (String)string2);
        }

        String getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getPath(), this);
        }

        String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getName(), this);
        }

        int getVersion() {
            return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getVersion(), this);
        }

        boolean isAnyLanguageSupported(List<Locale.LanguageRange> list) {
            return (boolean)InvokeDynamicSupport.bootstrap("isAnyLanguageSupported", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$isAnyLanguageSupported(java.util.List<java.util.Locale$LanguageRange> ), this, list);
        }

        List<Locale> getSupportedLocales() {
            return InvokeDynamicSupport.bootstrap("getSupportedLocales", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$getSupportedLocales(), this);
        }

        public boolean isPreferredTo(ModelFile modelFile) {
            return (boolean)InvokeDynamicSupport.bootstrap("isPreferredTo", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$isPreferredTo(android.view.textclassifier.TextClassifierImpl$ModelFile ), this, modelFile);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$equals(java.lang.Object ), this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$toString(), this);
        }

        private void __constructor__(String string2, String string3, int n, List<Locale> list, boolean bl) {
            this.$$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$__constructor__(string2, string3, n, list, bl);
        }

        public ModelFile(String string2, String string3, int n, List<Locale> list, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_ModelFile$__constructor__(java.lang.String java.lang.String int java.util.List<java.util.Locale> boolean ), this, string2, string3, n, list, bl);
        }

        public /* synthetic */ ModelFile() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ModelFile)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

