/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.util.KeyValueListParser;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassificationConstants
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TextClassificationConstants";
    private static String LOCAL_TEXT_CLASSIFIER_ENABLED = "local_textclassifier_enabled";
    private static String SYSTEM_TEXT_CLASSIFIER_ENABLED = "system_textclassifier_enabled";
    private static String MODEL_DARK_LAUNCH_ENABLED = "model_dark_launch_enabled";
    private static String SMART_SELECTION_ENABLED = "smart_selection_enabled";
    private static String SMART_TEXT_SHARE_ENABLED = "smart_text_share_enabled";
    private static String SMART_LINKIFY_ENABLED = "smart_linkify_enabled";
    private static String SMART_SELECT_ANIMATION_ENABLED = "smart_select_animation_enabled";
    private static String SUGGEST_SELECTION_MAX_RANGE_LENGTH = "suggest_selection_max_range_length";
    private static String CLASSIFY_TEXT_MAX_RANGE_LENGTH = "classify_text_max_range_length";
    private static String GENERATE_LINKS_MAX_TEXT_LENGTH = "generate_links_max_text_length";
    private static String GENERATE_LINKS_LOG_SAMPLE_RATE = "generate_links_log_sample_rate";
    private static String ENTITY_LIST_DEFAULT = "entity_list_default";
    private static String ENTITY_LIST_NOT_EDITABLE = "entity_list_not_editable";
    private static String ENTITY_LIST_EDITABLE = "entity_list_editable";
    private static boolean LOCAL_TEXT_CLASSIFIER_ENABLED_DEFAULT = true;
    private static boolean SYSTEM_TEXT_CLASSIFIER_ENABLED_DEFAULT = true;
    private static boolean MODEL_DARK_LAUNCH_ENABLED_DEFAULT = false;
    private static boolean SMART_SELECTION_ENABLED_DEFAULT = true;
    private static boolean SMART_TEXT_SHARE_ENABLED_DEFAULT = true;
    private static boolean SMART_LINKIFY_ENABLED_DEFAULT = true;
    private static boolean SMART_SELECT_ANIMATION_ENABLED_DEFAULT = true;
    private static int SUGGEST_SELECTION_MAX_RANGE_LENGTH_DEFAULT = 10000;
    private static int CLASSIFY_TEXT_MAX_RANGE_LENGTH_DEFAULT = 10000;
    private static int GENERATE_LINKS_MAX_TEXT_LENGTH_DEFAULT = 100000;
    private static int GENERATE_LINKS_LOG_SAMPLE_RATE_DEFAULT = 100;
    private static String ENTITY_LIST_DELIMITER = ":";
    private static String ENTITY_LIST_DEFAULT_VALUE;
    private boolean mSystemTextClassifierEnabled;
    private boolean mLocalTextClassifierEnabled;
    private boolean mModelDarkLaunchEnabled;
    private boolean mSmartSelectionEnabled;
    private boolean mSmartTextShareEnabled;
    private boolean mSmartLinkifyEnabled;
    private boolean mSmartSelectionAnimationEnabled;
    private int mSuggestSelectionMaxRangeLength;
    private int mClassifyTextMaxRangeLength;
    private int mGenerateLinksMaxTextLength;
    private int mGenerateLinksLogSampleRate;
    private List<String> mEntityListDefault;
    private List<String> mEntityListNotEditable;
    private List<String> mEntityListEditable;

    private void $$robo$$android_view_textclassifier_TextClassificationConstants$__constructor__(String settings) {
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(settings);
        }
        catch (IllegalArgumentException e) {
            Slog.e("TextClassificationConstants", "Bad TextClassifier settings: " + settings);
        }
        this.mSystemTextClassifierEnabled = parser.getBoolean("system_textclassifier_enabled", true);
        this.mLocalTextClassifierEnabled = parser.getBoolean("local_textclassifier_enabled", true);
        this.mModelDarkLaunchEnabled = parser.getBoolean("model_dark_launch_enabled", false);
        this.mSmartSelectionEnabled = parser.getBoolean("smart_selection_enabled", true);
        this.mSmartTextShareEnabled = parser.getBoolean("smart_text_share_enabled", true);
        this.mSmartLinkifyEnabled = parser.getBoolean("smart_linkify_enabled", true);
        this.mSmartSelectionAnimationEnabled = parser.getBoolean("smart_select_animation_enabled", true);
        this.mSuggestSelectionMaxRangeLength = parser.getInt("suggest_selection_max_range_length", 10000);
        this.mClassifyTextMaxRangeLength = parser.getInt("classify_text_max_range_length", 10000);
        this.mGenerateLinksMaxTextLength = parser.getInt("generate_links_max_text_length", 100000);
        this.mGenerateLinksLogSampleRate = parser.getInt("generate_links_log_sample_rate", 100);
        this.mEntityListDefault = TextClassificationConstants.parseEntityList(parser.getString("entity_list_default", ENTITY_LIST_DEFAULT_VALUE));
        this.mEntityListNotEditable = TextClassificationConstants.parseEntityList(parser.getString("entity_list_not_editable", ENTITY_LIST_DEFAULT_VALUE));
        this.mEntityListEditable = TextClassificationConstants.parseEntityList(parser.getString("entity_list_editable", ENTITY_LIST_DEFAULT_VALUE));
    }

    private static final TextClassificationConstants $$robo$$android_view_textclassifier_TextClassificationConstants$loadFromString(String settings) {
        return new TextClassificationConstants(settings);
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isLocalTextClassifierEnabled() {
        return this.mLocalTextClassifierEnabled;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isSystemTextClassifierEnabled() {
        return this.mSystemTextClassifierEnabled;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isModelDarkLaunchEnabled() {
        return this.mModelDarkLaunchEnabled;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartSelectionEnabled() {
        return this.mSmartSelectionEnabled;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartTextShareEnabled() {
        return this.mSmartTextShareEnabled;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartLinkifyEnabled() {
        return this.mSmartLinkifyEnabled;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartSelectionAnimationEnabled() {
        return this.mSmartSelectionAnimationEnabled;
    }

    private final int $$robo$$android_view_textclassifier_TextClassificationConstants$getSuggestSelectionMaxRangeLength() {
        return this.mSuggestSelectionMaxRangeLength;
    }

    private final int $$robo$$android_view_textclassifier_TextClassificationConstants$getClassifyTextMaxRangeLength() {
        return this.mClassifyTextMaxRangeLength;
    }

    private final int $$robo$$android_view_textclassifier_TextClassificationConstants$getGenerateLinksMaxTextLength() {
        return this.mGenerateLinksMaxTextLength;
    }

    private final int $$robo$$android_view_textclassifier_TextClassificationConstants$getGenerateLinksLogSampleRate() {
        return this.mGenerateLinksLogSampleRate;
    }

    private final List<String> $$robo$$android_view_textclassifier_TextClassificationConstants$getEntityListDefault() {
        return this.mEntityListDefault;
    }

    private final List<String> $$robo$$android_view_textclassifier_TextClassificationConstants$getEntityListNotEditable() {
        return this.mEntityListNotEditable;
    }

    private final List<String> $$robo$$android_view_textclassifier_TextClassificationConstants$getEntityListEditable() {
        return this.mEntityListEditable;
    }

    private static final List<String> $$robo$$android_view_textclassifier_TextClassificationConstants$parseEntityList(String listStr) {
        return Collections.unmodifiableList(Arrays.asList(listStr.split(":")));
    }

    static void __staticInitializer__() {
        ENTITY_LIST_DEFAULT_VALUE = new StringJoiner(":").add("address").add("email").add("phone").add("url").add("date").add("datetime").add("flight").toString();
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_view_textclassifier_TextClassificationConstants$__constructor__(string2);
    }

    public TextClassificationConstants(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassificationConstants$__constructor__(java.lang.String ), this, string2);
    }

    public static TextClassificationConstants loadFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadFromString", $$robo$$android_view_textclassifier_TextClassificationConstants$loadFromString(java.lang.String ), (String)string2);
    }

    public boolean isLocalTextClassifierEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLocalTextClassifierEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isLocalTextClassifierEnabled(), this);
    }

    public boolean isSystemTextClassifierEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemTextClassifierEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isSystemTextClassifierEnabled(), this);
    }

    public boolean isModelDarkLaunchEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isModelDarkLaunchEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isModelDarkLaunchEnabled(), this);
    }

    public boolean isSmartSelectionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmartSelectionEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartSelectionEnabled(), this);
    }

    public boolean isSmartTextShareEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmartTextShareEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartTextShareEnabled(), this);
    }

    public boolean isSmartLinkifyEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmartLinkifyEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartLinkifyEnabled(), this);
    }

    public boolean isSmartSelectionAnimationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmartSelectionAnimationEnabled", $$robo$$android_view_textclassifier_TextClassificationConstants$isSmartSelectionAnimationEnabled(), this);
    }

    public int getSuggestSelectionMaxRangeLength() {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestSelectionMaxRangeLength", $$robo$$android_view_textclassifier_TextClassificationConstants$getSuggestSelectionMaxRangeLength(), this);
    }

    public int getClassifyTextMaxRangeLength() {
        return (int)InvokeDynamicSupport.bootstrap("getClassifyTextMaxRangeLength", $$robo$$android_view_textclassifier_TextClassificationConstants$getClassifyTextMaxRangeLength(), this);
    }

    public int getGenerateLinksMaxTextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getGenerateLinksMaxTextLength", $$robo$$android_view_textclassifier_TextClassificationConstants$getGenerateLinksMaxTextLength(), this);
    }

    public int getGenerateLinksLogSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getGenerateLinksLogSampleRate", $$robo$$android_view_textclassifier_TextClassificationConstants$getGenerateLinksLogSampleRate(), this);
    }

    public List<String> getEntityListDefault() {
        return InvokeDynamicSupport.bootstrap("getEntityListDefault", $$robo$$android_view_textclassifier_TextClassificationConstants$getEntityListDefault(), this);
    }

    public List<String> getEntityListNotEditable() {
        return InvokeDynamicSupport.bootstrap("getEntityListNotEditable", $$robo$$android_view_textclassifier_TextClassificationConstants$getEntityListNotEditable(), this);
    }

    public List<String> getEntityListEditable() {
        return InvokeDynamicSupport.bootstrap("getEntityListEditable", $$robo$$android_view_textclassifier_TextClassificationConstants$getEntityListEditable(), this);
    }

    private static List<String> parseEntityList(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseEntityList", $$robo$$android_view_textclassifier_TextClassificationConstants$parseEntityList(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(TextClassificationConstants.class);
    }

    public /* synthetic */ TextClassificationConstants() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationConstants)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

