/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class EntityConfidence
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private ArrayMap<String, Float> mEntityConfidence;
    private ArrayList<String> mSortedEntities;
    public static Parcelable.Creator<EntityConfidence> CREATOR;

    private void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__() {
        this.mEntityConfidence = new ArrayMap();
        this.mSortedEntities = new ArrayList();
    }

    private void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(EntityConfidence source) {
        this.mEntityConfidence = new ArrayMap();
        this.mSortedEntities = new ArrayList();
        Preconditions.checkNotNull(source);
        this.mEntityConfidence.putAll(source.mEntityConfidence);
        this.mSortedEntities.addAll(source.mSortedEntities);
    }

    private void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(Map<String, Float> source) {
        this.mEntityConfidence = new ArrayMap();
        this.mSortedEntities = new ArrayList();
        Preconditions.checkNotNull(source);
        this.mEntityConfidence.ensureCapacity(source.size());
        for (Map.Entry<String, Float> it : source.entrySet()) {
            if (it.getValue().floatValue() <= 0.0f) continue;
            this.mEntityConfidence.put(it.getKey(), Float.valueOf(Math.min(1.0f, it.getValue().floatValue())));
        }
        this.resetSortedEntitiesFromMap();
    }

    private final List<String> $$robo$$android_view_textclassifier_EntityConfidence$getEntities() {
        return Collections.unmodifiableList(this.mSortedEntities);
    }

    private final float $$robo$$android_view_textclassifier_EntityConfidence$getConfidenceScore(String entity) {
        if (this.mEntityConfidence.containsKey(entity)) {
            return this.mEntityConfidence.get(entity).floatValue();
        }
        return 0.0f;
    }

    private final String $$robo$$android_view_textclassifier_EntityConfidence$toString() {
        return this.mEntityConfidence.toString();
    }

    private final int $$robo$$android_view_textclassifier_EntityConfidence$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_textclassifier_EntityConfidence$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEntityConfidence.size());
        for (Map.Entry<String, Float> entry : this.mEntityConfidence.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeFloat(entry.getValue().floatValue());
        }
    }

    private void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(Parcel in) {
        this.mEntityConfidence = new ArrayMap();
        this.mSortedEntities = new ArrayList();
        int numEntities = in.readInt();
        this.mEntityConfidence.ensureCapacity(numEntities);
        for (int i = 0; i < numEntities; ++i) {
            this.mEntityConfidence.put(in.readString(), Float.valueOf(in.readFloat()));
        }
        this.resetSortedEntitiesFromMap();
    }

    private final void $$robo$$android_view_textclassifier_EntityConfidence$resetSortedEntitiesFromMap() {
        this.mSortedEntities.clear();
        this.mSortedEntities.ensureCapacity(this.mEntityConfidence.size());
        this.mSortedEntities.addAll(this.mEntityConfidence.keySet());
        this.mSortedEntities.sort((e1, e2) -> {
            float score1 = this.mEntityConfidence.get(e1).floatValue();
            float score2 = this.mEntityConfidence.get(e2).floatValue();
            return Float.compare(score2, score1);
        });
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<EntityConfidence>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_textclassifier_EntityConfidence_1$__constructor__() {
            }

            private final EntityConfidence $$robo$$android_view_textclassifier_EntityConfidence_1$createFromParcel(Parcel in) {
                return new EntityConfidence(in, null);
            }

            private final EntityConfidence[] $$robo$$android_view_textclassifier_EntityConfidence_1$newArray(int size) {
                return new EntityConfidence[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_textclassifier_EntityConfidence_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence_1$__constructor__(), this);
            }

            @Override
            public EntityConfidence createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_EntityConfidence_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public EntityConfidence[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_EntityConfidence_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__();
    }

    public EntityConfidence() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(), this);
    }

    private void __constructor__(EntityConfidence entityConfidence) {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__(entityConfidence);
    }

    public EntityConfidence(EntityConfidence entityConfidence) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(android.view.textclassifier.EntityConfidence ), this, entityConfidence);
    }

    private void __constructor__(Map<String, Float> map) {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__(map);
    }

    public EntityConfidence(Map<String, Float> map) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(java.util.Map<java.lang.String, java.lang.Float> ), this, map);
    }

    public List<String> getEntities() {
        return InvokeDynamicSupport.bootstrap("getEntities", $$robo$$android_view_textclassifier_EntityConfidence$getEntities(), this);
    }

    public float getConfidenceScore(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("getConfidenceScore", $$robo$$android_view_textclassifier_EntityConfidence$getConfidenceScore(java.lang.String ), this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_EntityConfidence$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_EntityConfidence$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_EntityConfidence$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__(parcel);
    }

    public EntityConfidence(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(android.os.Parcel ), this, parcel);
    }

    private void resetSortedEntitiesFromMap() {
        InvokeDynamicSupport.bootstrap("resetSortedEntitiesFromMap", $$robo$$android_view_textclassifier_EntityConfidence$resetSortedEntitiesFromMap(), this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ EntityConfidence(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(android.os.Parcel android.view.textclassifier.EntityConfidence$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(EntityConfidence.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityConfidence)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

