/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.autofill.FillEventHistory;
import android.service.autofill.UserData;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.KeyEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import android.view.autofill.ParcelableMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AutofillManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AutofillManager";
    public static String EXTRA_ASSIST_STRUCTURE = "android.view.autofill.extra.ASSIST_STRUCTURE";
    public static String EXTRA_AUTHENTICATION_RESULT = "android.view.autofill.extra.AUTHENTICATION_RESULT";
    public static String EXTRA_CLIENT_STATE = "android.view.autofill.extra.CLIENT_STATE";
    public static String EXTRA_RESTORE_SESSION_TOKEN = "android.view.autofill.extra.RESTORE_SESSION_TOKEN";
    private static String SESSION_ID_TAG = "android:sessionId";
    private static String STATE_TAG = "android:state";
    private static String LAST_AUTOFILLED_DATA_TAG = "android:lastAutoFilledData";
    public static int ACTION_START_SESSION = 1;
    public static int ACTION_VIEW_ENTERED = 2;
    public static int ACTION_VIEW_EXITED = 3;
    public static int ACTION_VALUE_CHANGED = 4;
    public static int FLAG_ADD_CLIENT_ENABLED = 1;
    public static int FLAG_ADD_CLIENT_DEBUG = 2;
    public static int FLAG_ADD_CLIENT_VERBOSE = 4;
    private static int AUTHENTICATION_ID_DATASET_ID_MASK = 65535;
    private static int AUTHENTICATION_ID_DATASET_ID_SHIFT = 16;
    public static int AUTHENTICATION_ID_DATASET_ID_UNDEFINED = 65535;
    public static int PENDING_UI_OPERATION_CANCEL = 1;
    public static int PENDING_UI_OPERATION_RESTORE = 2;
    public static int STATE_UNKNOWN = 0;
    public static int STATE_ACTIVE = 1;
    public static int STATE_FINISHED = 2;
    public static int STATE_SHOWING_SAVE_UI = 3;
    public static int STATE_DISABLED_BY_SERVICE = 4;
    public static int STATE_UNKNOWN_COMPAT_MODE = 5;
    public static int FC_SERVICE_TIMEOUT = 5000;
    private MetricsLogger mMetricsLogger;
    public static int NO_SESSION = Integer.MIN_VALUE;
    private IAutoFillManager mService;
    private Object mLock;
    @GuardedBy(value="mLock")
    private IAutoFillManagerClient mServiceClient;
    @GuardedBy(value="mLock")
    private Cleaner.Cleanable mServiceClientCleaner;
    @GuardedBy(value="mLock")
    private AutofillCallback mCallback;
    private Context mContext;
    @GuardedBy(value="mLock")
    private int mSessionId;
    @GuardedBy(value="mLock")
    private int mState;
    @GuardedBy(value="mLock")
    private boolean mEnabled;
    @GuardedBy(value="mLock")
    private ParcelableMap mLastAutofilledData;
    @GuardedBy(value="mLock")
    private TrackedViews mTrackedViews;
    @GuardedBy(value="mLock")
    private ArraySet<AutofillId> mFillableIds;
    private AutofillId mIdShownFillUi;
    @GuardedBy(value="mLock")
    private ArraySet<AutofillId> mEnteredIds;
    @GuardedBy(value="mLock")
    private AutofillId mSaveTriggerId;
    @GuardedBy(value="mLock")
    private boolean mOnInvisibleCalled;
    @GuardedBy(value="mLock")
    private boolean mSaveOnFinish;
    @GuardedBy(value="mLock")
    private CompatibilityBridge mCompatibilityBridge;
    public static int SET_STATE_FLAG_ENABLED = 1;
    public static int SET_STATE_FLAG_RESET_SESSION = 2;
    public static int SET_STATE_FLAG_RESET_CLIENT = 4;
    public static int SET_STATE_FLAG_DEBUG = 8;
    public static int SET_STATE_FLAG_VERBOSE = 16;

    private static final int $$robo$$android_view_autofill_AutofillManager$makeAuthenticationId(int requestId, int datasetId) {
        return requestId << 16 | datasetId & 0xFFFF;
    }

    private static final int $$robo$$android_view_autofill_AutofillManager$getRequestIdFromAuthenticationId(int authRequestId) {
        return authRequestId >> 16;
    }

    private static final int $$robo$$android_view_autofill_AutofillManager$getDatasetIdFromAuthenticationId(int authRequestId) {
        return authRequestId & 0xFFFF;
    }

    private void $$robo$$android_view_autofill_AutofillManager$__constructor__(Context context, IAutoFillManager service) {
        this.mMetricsLogger = new MetricsLogger();
        this.mLock = new Object();
        this.mSessionId = Integer.MIN_VALUE;
        this.mState = 0;
        this.mContext = Preconditions.checkNotNull(context, "context cannot be null");
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$enableCompatibilityMode() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCompatibilityBridge = new CompatibilityBridge(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onCreate(Bundle savedInstanceState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAutofilledData = (ParcelableMap)savedInstanceState.getParcelable("android:lastAutoFilledData");
            if (this.isActiveLocked()) {
                Log.w("AutofillManager", "New session was started before onCreate()");
                return;
            }
            this.mSessionId = savedInstanceState.getInt("android:sessionId", Integer.MIN_VALUE);
            this.mState = savedInstanceState.getInt("android:state", 0);
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.ensureServiceClientAddedIfNeededLocked();
                AutofillClient client = this.getClient();
                if (client != null) {
                    try {
                        boolean sessionWasRestored = this.mService.restoreSession(this.mSessionId, client.autofillClientGetActivityToken(), this.mServiceClient.asBinder());
                        if (!sessionWasRestored) {
                            Log.w("AutofillManager", "Session " + this.mSessionId + " could not be restored");
                            this.mSessionId = Integer.MIN_VALUE;
                            this.mState = 0;
                        } else {
                            if (Helper.sDebug) {
                                Log.d("AutofillManager", "session " + this.mSessionId + " was restored");
                            }
                            client.autofillClientResetableStateAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e("AutofillManager", "Could not figure out if there was an autofill session", e);
                    }
                }
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$onVisibleForAutofill() {
        Choreographer.getInstance().postCallback(3, () -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mEnabled && this.isActiveLocked() && this.mTrackedViews != null) {
                    this.mTrackedViews.onVisibleForAutofillChangedLocked();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onInvisibleForAutofill() {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnInvisibleCalled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onSaveInstanceState(Bundle outState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                outState.putInt("android:sessionId", this.mSessionId);
            }
            if (this.mState != 0) {
                outState.putInt("android:state", this.mState);
            }
            if (this.mLastAutofilledData != null) {
                outState.putParcelable("android:lastAutoFilledData", this.mLastAutofilledData);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final boolean $$robo$$android_view_autofill_AutofillManager$isCompatibilityModeEnabledLocked() {
        return this.mCompatibilityBridge != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_autofill_AutofillManager$isEnabled() {
        if (!this.hasAutofillFeature()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDisabledByServiceLocked()) {
                return false;
            }
            this.ensureServiceClientAddedIfNeededLocked();
            return this.mEnabled;
        }
    }

    private final FillEventHistory $$robo$$android_view_autofill_AutofillManager$getFillEventHistory() {
        try {
            return this.mService.getFillEventHistory();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestAutofill(View view) {
        this.notifyViewEntered(view, 1);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestAutofill(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 1);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view) {
        this.notifyViewEntered(view, 0);
    }

    @GuardedBy(value="mLock")
    private final boolean $$robo$$android_view_autofill_AutofillManager$shouldIgnoreViewEnteredLocked(AutofillId id2, int flags) {
        if (this.isDisabledByServiceLocked()) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ") on state " + this.getStateAsStringLocked() + " because disabled by svc");
            }
            return true;
        }
        if (this.isFinishedLocked() && (flags & 1) == 0 && this.mEnteredIds != null && this.mEnteredIds.contains(id2)) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ") on state " + this.getStateAsStringLocked() + " because view was already entered: " + this.mEnteredIds);
            }
            return true;
        }
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "not ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ", state " + this.getStateAsStringLocked() + ", enteredIds=" + this.mEnteredIds);
        }
        return false;
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isClientVisibleForAutofillLocked() {
        AutofillClient client = this.getClient();
        return client != null && client.autofillClientIsVisibleForAutofill();
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isClientDisablingEnterExitEvent() {
        AutofillClient client = this.getClient();
        return client != null && client.isDisablingEnterExitEventForAutofill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view, int flags) {
        AutofillCallback callback;
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callback = this.notifyViewEnteredLocked(view, flags);
        }
        if (callback != null) {
            this.mCallback.onAutofillEvent(view, 3);
        }
    }

    @GuardedBy(value="mLock")
    private final AutofillCallback $$robo$$android_view_autofill_AutofillManager$notifyViewEnteredLocked(View view, int flags) {
        AutofillId id2 = view.getAutofillId();
        if (this.shouldIgnoreViewEnteredLocked(id2, flags)) {
            return null;
        }
        AutofillCallback callback = null;
        this.ensureServiceClientAddedIfNeededLocked();
        if (!this.mEnabled) {
            if (this.mCallback != null) {
                callback = this.mCallback;
            }
        } else if (!this.isClientDisablingEnterExitEvent()) {
            AutofillValue value = view.getAutofillValue();
            if (!this.isActiveLocked()) {
                this.startSessionLocked(id2, null, value, flags);
            } else {
                this.updateSessionLocked(id2, null, value, 2, flags);
            }
            this.addEnteredIdLocked(id2);
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewExited(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyViewExitedLocked(view);
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewExitedLocked(View view) {
        this.ensureServiceClientAddedIfNeededLocked();
        if (this.mEnabled && this.isActiveLocked() && !this.isClientDisablingEnterExitEvent()) {
            AutofillId id2 = view.getAutofillId();
            this.updateSessionLocked(id2, null, null, 3, 0);
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(View view, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, 0, isVisible, false);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(View view, int virtualId, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, virtualId, isVisible, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChangedInternal(View view, int virtualId, boolean isVisible, boolean virtual) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2;
                AutofillId autofillId = id2 = virtual ? AutofillManager.getAutofillId(view, virtualId) : view.getAutofillId();
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "visibility changed for " + id2 + ": " + isVisible);
                }
                if (!isVisible && this.mFillableIds != null && this.mFillableIds.contains(id2)) {
                    if (Helper.sDebug) {
                        Log.d("AutofillManager", "Hidding UI when view " + id2 + " became invisible");
                    }
                    this.requestHideFillUi(id2, view);
                }
                if (this.mTrackedViews != null) {
                    this.mTrackedViews.notifyViewVisibilityChangedLocked(id2, isVisible);
                } else if (Helper.sVerbose) {
                    Log.v("AutofillManager", "Ignoring visibility change on " + id2 + ": no tracked views");
                }
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view, int virtualId, Rect bounds, int flags) {
        AutofillCallback callback;
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callback = this.notifyViewEnteredLocked(view, virtualId, bounds, flags);
        }
        if (callback != null) {
            callback.onAutofillEvent(view, virtualId, 3);
        }
    }

    @GuardedBy(value="mLock")
    private final AutofillCallback $$robo$$android_view_autofill_AutofillManager$notifyViewEnteredLocked(View view, int virtualId, Rect bounds, int flags) {
        AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
        AutofillCallback callback = null;
        if (this.shouldIgnoreViewEnteredLocked(id2, flags)) {
            return callback;
        }
        this.ensureServiceClientAddedIfNeededLocked();
        if (!this.mEnabled) {
            if (this.mCallback != null) {
                callback = this.mCallback;
            }
        } else if (!this.isClientDisablingEnterExitEvent()) {
            if (!this.isActiveLocked()) {
                this.startSessionLocked(id2, bounds, null, flags);
            } else {
                this.updateSessionLocked(id2, bounds, null, 2, flags);
            }
            this.addEnteredIdLocked(id2);
        }
        return callback;
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$addEnteredIdLocked(AutofillId id2) {
        if (this.mEnteredIds == null) {
            this.mEnteredIds = new ArraySet(1);
        }
        this.mEnteredIds.add(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewExited(View view, int virtualId) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "notifyViewExited(" + view.getAutofillId() + ", " + virtualId);
        }
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyViewExitedLocked(view, virtualId);
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewExitedLocked(View view, int virtualId) {
        this.ensureServiceClientAddedIfNeededLocked();
        if (this.mEnabled && this.isActiveLocked() && !this.isClientDisablingEnterExitEvent()) {
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, null, 3, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillId id2 = null;
        boolean valueWasRead = false;
        AutofillValue value = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastAutofilledData == null) {
                view.setAutofilled(false);
            } else {
                id2 = view.getAutofillId();
                if (this.mLastAutofilledData.containsKey(id2)) {
                    value = view.getAutofillValue();
                    valueWasRead = true;
                    if (Objects.equals(this.mLastAutofilledData.get(id2), value)) {
                        view.setAutofilled(true);
                    } else {
                        view.setAutofilled(false);
                        this.mLastAutofilledData.remove(id2);
                    }
                } else {
                    view.setAutofilled(false);
                }
            }
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "notifyValueChanged(" + view.getAutofillId() + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            if (id2 == null) {
                id2 = view.getAutofillId();
            }
            if (!valueWasRead) {
                value = view.getAutofillValue();
            }
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(View view, int virtualId, AutofillValue value) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "notifyValueChanged(" + view.getAutofillId() + ":" + virtualId + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewClicked(View view) {
        this.notifyViewClicked(view.getAutofillId());
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewClicked(View view, int virtualId) {
        this.notifyViewClicked(AutofillManager.getAutofillId(view, virtualId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewClicked(AutofillId id2) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "notifyViewClicked(): id=" + id2 + ", trigger=" + this.mSaveTriggerId);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                return;
            }
            if (this.mSaveTriggerId != null && this.mSaveTriggerId.equals(id2)) {
                if (Helper.sDebug) {
                    Log.d("AutofillManager", "triggering commit by click of " + id2);
                }
                this.commitLocked();
                this.mMetricsLogger.write(this.newLog(1229));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onActivityFinishing() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSaveOnFinish) {
                if (Helper.sDebug) {
                    Log.d("AutofillManager", "onActivityFinishing(): calling commitLocked()");
                }
                this.commitLocked();
            } else {
                if (Helper.sDebug) {
                    Log.d("AutofillManager", "onActivityFinishing(): calling cancelLocked()");
                }
                this.cancelLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$commit() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "commit() called by app");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.commitLocked();
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$commitLocked() {
        if (!this.mEnabled && !this.isActiveLocked()) {
            return;
        }
        this.finishSessionLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$cancel() {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "cancel() called by app");
        }
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.cancelLocked();
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$cancelLocked() {
        if (!this.mEnabled && !this.isActiveLocked()) {
            return;
        }
        this.cancelSessionLocked();
    }

    private final void $$robo$$android_view_autofill_AutofillManager$disableOwnedAutofillServices() {
        this.disableAutofillServices();
    }

    private final void $$robo$$android_view_autofill_AutofillManager$disableAutofillServices() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        try {
            this.mService.disableOwnedAutofillServices(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$hasEnabledAutofillServices() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceEnabled(this.mContext.getUserId(), this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ComponentName $$robo$$android_view_autofill_AutofillManager$getAutofillServiceComponentName() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getAutofillServiceComponentName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_view_autofill_AutofillManager$getUserDataId() {
        try {
            return this.mService.getUserDataId();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    private final UserData $$robo$$android_view_autofill_AutofillManager$getUserData() {
        try {
            return this.mService.getUserData();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$setUserData(UserData userData) {
        try {
            this.mService.setUserData(userData);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isFieldClassificationEnabled() {
        try {
            return this.mService.isFieldClassificationEnabled();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    private final String $$robo$$android_view_autofill_AutofillManager$getDefaultFieldClassificationAlgorithm() {
        try {
            return this.mService.getDefaultFieldClassificationAlgorithm();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    private final List<String> $$robo$$android_view_autofill_AutofillManager$getAvailableFieldClassificationAlgorithms() {
        try {
            String[] algorithms = this.mService.getAvailableFieldClassificationAlgorithms();
            return algorithms != null ? Arrays.asList(algorithms) : Collections.emptyList();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isAutofillSupported() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceSupported(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final AutofillClient $$robo$$android_view_autofill_AutofillManager$getClient() {
        AutofillClient client = this.mContext.getAutofillClient();
        if (client == null && Helper.sDebug) {
            Log.d("AutofillManager", "No AutofillClient for " + this.mContext.getPackageName() + " on context " + this.mContext);
        }
        return client;
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isAutofillUiShowing() {
        AutofillClient client = this.mContext.getAutofillClient();
        return client != null && client.autofillClientIsFillUiShowing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onAuthenticationResult(int authenticationId, Intent data, View focusView) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sDebug) {
            Log.d("AutofillManager", "onAuthenticationResult(): d=" + data);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isActiveLocked()) {
                return;
            }
            if (!this.mOnInvisibleCalled && focusView != null && focusView.canNotifyAutofillEnterExitEvent()) {
                this.notifyViewExitedLocked(focusView);
                this.notifyViewEnteredLocked(focusView, 0);
            }
            if (data == null) {
                return;
            }
            Object result = data.getParcelableExtra("android.view.autofill.extra.AUTHENTICATION_RESULT");
            Bundle responseData = new Bundle();
            responseData.putParcelable("android.view.autofill.extra.AUTHENTICATION_RESULT", (Parcelable)result);
            Bundle newClientState = data.getBundleExtra("android.view.autofill.extra.CLIENT_STATE");
            if (newClientState != null) {
                responseData.putBundle("android.view.autofill.extra.CLIENT_STATE", newClientState);
            }
            try {
                this.mService.setAuthenticationResult(responseData, this.mSessionId, authenticationId, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                Log.e("AutofillManager", "Error delivering authentication result", e);
            }
        }
    }

    private final AutofillId $$robo$$android_view_autofill_AutofillManager$getNextAutofillId() {
        AutofillClient client = this.getClient();
        if (client == null) {
            return null;
        }
        AutofillId id2 = client.autofillClientGetNextAutofillId();
        if (id2 == null && Helper.sDebug) {
            Log.d("AutofillManager", "getNextAutofillId(): client " + client + " returned null");
        }
        return id2;
    }

    private static final AutofillId $$robo$$android_view_autofill_AutofillManager$getAutofillId(View parent, int virtualId) {
        return new AutofillId(parent.getAutofillViewId(), virtualId);
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$startSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int flags) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "startSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", flags=" + flags + ", state=" + this.getStateAsStringLocked() + ", compatMode=" + this.isCompatibilityModeEnabledLocked() + ", enteredIds=" + this.mEnteredIds);
        }
        if (this.mState != 0 && !this.isFinishedLocked() && (flags & 1) == 0) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "not automatically starting session for " + id2 + " on state " + this.getStateAsStringLocked() + " and flags " + flags);
            }
            return;
        }
        try {
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            this.mSessionId = this.mService.startSession(client.autofillClientGetActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, client.autofillClientGetComponentName(), this.isCompatibilityModeEnabledLocked());
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.mState = 1;
            }
            client.autofillClientResetableStateAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$finishSessionLocked() {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "finishSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.finishSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked(true);
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$cancelSessionLocked() {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "cancelSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.cancelSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked(true);
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$resetSessionLocked(boolean resetEnteredIds) {
        this.mSessionId = Integer.MIN_VALUE;
        this.mState = 0;
        this.mTrackedViews = null;
        this.mFillableIds = null;
        this.mSaveTriggerId = null;
        this.mIdShownFillUi = null;
        if (resetEnteredIds) {
            this.mEnteredIds = null;
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$updateSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int action, int flags) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "updateSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", action=" + action + ", flags=" + flags);
        }
        boolean restartIfNecessary = (flags & 1) != 0;
        try {
            if (restartIfNecessary) {
                AutofillClient client = this.getClient();
                if (client == null) {
                    return;
                }
                int newId = this.mService.updateOrRestartSession(client.autofillClientGetActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, client.autofillClientGetComponentName(), this.mSessionId, action, this.isCompatibilityModeEnabledLocked());
                if (newId != this.mSessionId) {
                    if (Helper.sDebug) {
                        Log.d("AutofillManager", "Session restarted: " + this.mSessionId + "=>" + newId);
                    }
                    this.mSessionId = newId;
                    this.mState = this.mSessionId == Integer.MIN_VALUE ? 0 : 1;
                    client.autofillClientResetableStateAvailable();
                }
            } else {
                this.mService.updateSession(this.mSessionId, id2, bounds, value, action, flags, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_view_autofill_AutofillManager$ensureServiceClientAddedIfNeededLocked() {
        if (this.getClient() == null) {
            return;
        }
        if (this.mServiceClient == null) {
            this.mServiceClient = new AutofillManagerClient(this);
            try {
                int userId = this.mContext.getUserId();
                int flags = this.mService.addClient(this.mServiceClient, userId);
                this.mEnabled = (flags & 1) != 0;
                Helper.sDebug = (flags & 2) != 0;
                Helper.sVerbose = (flags & 4) != 0;
                IAutoFillManager service = this.mService;
                IAutoFillManagerClient serviceClient = this.mServiceClient;
                this.mServiceClientCleaner = InvokeDynamicSupport.bootstrapIntrinsic("create", "sun.misc.Cleaner", (Object)this, () -> {
                    try {
                        service.removeClient(serviceClient, userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$registerCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            boolean hadCallback = this.mCallback != null;
            this.mCallback = callback;
            if (!hadCallback) {
                try {
                    this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), true);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$unregisterCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null || this.mCallback == null || callback != this.mCallback) {
                return;
            }
            this.mCallback = null;
            try {
                this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClient()) != null && client.autofillClientRequestShowFillUi(anchor, width, height, anchorBounds, presenter)) {
                callback = this.mCallback;
                this.mIdShownFillUi = id2;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 1);
            } else {
                callback.onAutofillEvent(anchor, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (sessionId == this.mSessionId && (client = this.getClient()) != null) {
                this.mOnInvisibleCalled = false;
                client.autofillClientAuthenticate(authenticationId, intent, fillInIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        Object callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClient()) != null) {
                client.autofillClientDispatchUnhandledKey(anchor, keyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setState(int flags) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "setState(" + flags + ")");
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.mEnabled = (flags & 1) != 0;
            if (!this.mEnabled || (flags & 2) != 0) {
                this.resetSessionLocked(true);
            }
            if ((flags & 4) != 0) {
                this.mServiceClient = null;
                if (this.mServiceClientCleaner != null) {
                    InvokeDynamicSupport.bootstrapIntrinsic("clean", "sun.misc.Cleaner", (Cleaner.Cleanable)this.mServiceClientCleaner);
                    this.mServiceClientCleaner = null;
                }
            }
        }
        Helper.sDebug = (flags & 8) != 0;
        Helper.sVerbose = (flags & 0x10) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setAutofilledIfValuesIs(View view, AutofillValue targetValue) {
        AutofillValue currentValue = view.getAutofillValue();
        if (Objects.equals(currentValue, targetValue)) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(1);
                }
                this.mLastAutofilledData.put(view.getAutofillId(), targetValue);
            }
            view.setAutofilled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            if (sessionId != this.mSessionId) {
                return;
            }
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            int itemCount = ids.size();
            int numApplied = 0;
            ArrayMap<View, SparseArray<AutofillValue>> virtualValues = null;
            View[] views = client.autofillClientFindViewsByAutofillIdTraversal(Helper.toArray(ids));
            ArrayList<AutofillId> failedIds = null;
            for (i = 0; i < itemCount; ++i) {
                AutofillId id2 = ids.get(i);
                AutofillValue value = values.get(i);
                int viewId = id2.getViewId();
                View view = views[i];
                if (view == null) {
                    Log.d("AutofillManager", "autofill(): no View with id " + id2);
                    if (failedIds == null) {
                        failedIds = new ArrayList<AutofillId>();
                    }
                    failedIds.add(id2);
                    continue;
                }
                if (id2.isVirtual()) {
                    SparseArray<AutofillValue> valuesByParent;
                    if (virtualValues == null) {
                        virtualValues = new ArrayMap<View, SparseArray<AutofillValue>>(1);
                    }
                    if ((valuesByParent = (SparseArray<AutofillValue>)virtualValues.get(view)) == null) {
                        valuesByParent = new SparseArray<AutofillValue>(5);
                        virtualValues.put(view, valuesByParent);
                    }
                    valuesByParent.put(id2.getVirtualChildId(), value);
                    continue;
                }
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(itemCount - i);
                }
                this.mLastAutofilledData.put(id2, value);
                view.autofill(value);
                this.setAutofilledIfValuesIs(view, value);
                ++numApplied;
            }
            if (failedIds != null) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "autofill(): total failed views: " + failedIds);
                }
                try {
                    this.mService.setAutofillFailure(this.mSessionId, failedIds, this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
            if (virtualValues != null) {
                for (i = 0; i < virtualValues.size(); ++i) {
                    View parent = (View)virtualValues.keyAt(i);
                    SparseArray childrenValues = (SparseArray)virtualValues.valueAt(i);
                    parent.autofill(childrenValues);
                    numApplied += childrenValues.size();
                }
            }
            this.mMetricsLogger.write(this.newLog(913).addTaggedData(914, itemCount).addTaggedData(915, numApplied));
        }
    }

    private final LogMaker $$robo$$android_view_autofill_AutofillManager$newLog(int category) {
        AutofillClient client;
        LogMaker log = new LogMaker(category).addTaggedData(1456, this.mSessionId);
        if (this.isCompatibilityModeEnabledLocked()) {
            log.addTaggedData(1414, 1);
        }
        if ((client = this.getClient()) == null) {
            log.setPackageName(this.mContext.getPackageName());
        } else {
            log.setComponentName(client.autofillClientGetComponentName());
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setTrackedViews(int sessionId, AutofillId[] trackedIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.mSessionId == sessionId) {
                this.mTrackedViews = saveOnAllViewsInvisible ? new TrackedViews(this, trackedIds) : null;
                this.mSaveOnFinish = saveOnFinish;
                if (fillableIds != null) {
                    if (this.mFillableIds == null) {
                        this.mFillableIds = new ArraySet(fillableIds.length);
                    }
                    for (AutofillId id2 : fillableIds) {
                        this.mFillableIds.add(id2);
                    }
                    if (Helper.sVerbose) {
                        Log.v("AutofillManager", "setTrackedViews(): fillableIds=" + fillableIds + ", mFillableIds" + this.mFillableIds);
                    }
                }
                if (this.mSaveTriggerId != null && !this.mSaveTriggerId.equals(saveTriggerId)) {
                    this.setNotifyOnClickLocked(this.mSaveTriggerId, false);
                }
                if (saveTriggerId != null && !saveTriggerId.equals(this.mSaveTriggerId)) {
                    this.mSaveTriggerId = saveTriggerId;
                    this.setNotifyOnClickLocked(this.mSaveTriggerId, true);
                }
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$setNotifyOnClickLocked(AutofillId id2, boolean notify) {
        View view = this.findView(id2);
        if (view == null) {
            Log.w("AutofillManager", "setNotifyOnClick(): invalid id: " + id2);
            return;
        }
        view.setNotifyAutofillManagerOnClick(notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setSaveUiState(int sessionId, boolean shown) {
        if (Helper.sDebug) {
            Log.d("AutofillManager", "setSaveUiState(" + sessionId + "): " + shown);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                Log.w("AutofillManager", "setSaveUiState(" + sessionId + ", " + shown + ") called on existing session " + this.mSessionId + "; cancelling it");
                this.cancelSessionLocked();
            }
            if (shown) {
                this.mSessionId = sessionId;
                this.mState = 3;
            } else {
                this.mSessionId = Integer.MIN_VALUE;
                this.mState = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setSessionFinished(int newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "setSessionFinished(): from " + this.getStateAsStringLocked() + " to " + AutofillManager.getStateAsString(newState));
            }
            if (newState == 5) {
                this.resetSessionLocked(true);
                this.mState = 0;
            } else {
                this.resetSessionLocked(false);
                this.mState = newState;
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestHideFillUi() {
        this.requestHideFillUi(this.mIdShownFillUi, true);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(AutofillId id2, boolean force) {
        View anchor;
        View view = anchor = id2 == null ? null : this.findView(id2);
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "requestHideFillUi(" + id2 + "): anchor = " + anchor);
        }
        if (anchor == null) {
            AutofillClient client;
            if (force && (client = this.getClient()) != null) {
                client.autofillClientRequestHideFillUi();
            }
            return;
        }
        this.requestHideFillUi(id2, anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(AutofillId id2, View anchor) {
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client = this.getClient();
            if (client != null && client.autofillClientRequestHideFillUi()) {
                this.mIdShownFillUi = null;
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 2);
            } else {
                callback.onAutofillEvent(anchor, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) {
        View anchor;
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "notifyNoFillUi(): sessionId=" + sessionId + ", autofillId=" + id2 + ", sessionFinishedState=" + sessionFinishedState);
        }
        if ((anchor = this.findView(id2)) == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId == sessionId && this.getClient() != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 3);
            } else {
                callback.onAutofillEvent(anchor, 3);
            }
        }
        if (sessionFinishedState != 0) {
            this.setSessionFinished(sessionFinishedState);
        }
    }

    private final View $$robo$$android_view_autofill_AutofillManager$findView(AutofillId autofillId) {
        AutofillClient client = this.getClient();
        if (client != null) {
            return client.autofillClientFindViewByAutofillIdTraversal(autofillId);
        }
        return null;
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$hasAutofillFeature() {
        return this.mService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPendingSaveUi(operation, token);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$dump(String outerPrefix, PrintWriter pw) {
        pw.print(outerPrefix);
        pw.println("AutofillManager:");
        String pfx = outerPrefix + "  ";
        pw.print(pfx);
        pw.print("sessionId: ");
        pw.println(this.mSessionId);
        pw.print(pfx);
        pw.print("state: ");
        pw.println(this.getStateAsStringLocked());
        pw.print(pfx);
        pw.print("context: ");
        pw.println(this.mContext);
        pw.print(pfx);
        pw.print("client: ");
        pw.println(this.getClient());
        pw.print(pfx);
        pw.print("enabled: ");
        pw.println(this.mEnabled);
        pw.print(pfx);
        pw.print("hasService: ");
        pw.println(this.mService != null);
        pw.print(pfx);
        pw.print("hasCallback: ");
        pw.println(this.mCallback != null);
        pw.print(pfx);
        pw.print("onInvisibleCalled ");
        pw.println(this.mOnInvisibleCalled);
        pw.print(pfx);
        pw.print("last autofilled data: ");
        pw.println(this.mLastAutofilledData);
        pw.print(pfx);
        pw.print("tracked views: ");
        if (this.mTrackedViews == null) {
            pw.println("null");
        } else {
            String pfx2 = pfx + "  ";
            pw.println();
            pw.print(pfx2);
            pw.print("visible:");
            pw.println(this.mTrackedViews.mVisibleTrackedIds);
            pw.print(pfx2);
            pw.print("invisible:");
            pw.println(this.mTrackedViews.mInvisibleTrackedIds);
        }
        pw.print(pfx);
        pw.print("fillable ids: ");
        pw.println(this.mFillableIds);
        pw.print(pfx);
        pw.print("entered ids: ");
        pw.println(this.mEnteredIds);
        pw.print(pfx);
        pw.print("save trigger id: ");
        pw.println(this.mSaveTriggerId);
        pw.print(pfx);
        pw.print("save on finish(): ");
        pw.println(this.mSaveOnFinish);
        pw.print(pfx);
        pw.print("compat mode enabled: ");
        pw.println(this.isCompatibilityModeEnabledLocked());
        pw.print(pfx);
        pw.print("debug: ");
        pw.print(Helper.sDebug);
        pw.print(" verbose: ");
        pw.println(Helper.sVerbose);
    }

    @GuardedBy(value="mLock")
    private final String $$robo$$android_view_autofill_AutofillManager$getStateAsStringLocked() {
        return AutofillManager.getStateAsString(this.mState);
    }

    private static final String $$robo$$android_view_autofill_AutofillManager$getStateAsString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "FINISHED";
            }
            case 3: {
                return "SHOWING_SAVE_UI";
            }
            case 4: {
                return "DISABLED_BY_SERVICE";
            }
            case 5: {
                return "UNKNOWN_COMPAT_MODE";
            }
        }
        return "INVALID:" + state;
    }

    @GuardedBy(value="mLock")
    private final boolean $$robo$$android_view_autofill_AutofillManager$isActiveLocked() {
        return this.mState == 1;
    }

    @GuardedBy(value="mLock")
    private final boolean $$robo$$android_view_autofill_AutofillManager$isDisabledByServiceLocked() {
        return this.mState == 4;
    }

    @GuardedBy(value="mLock")
    private final boolean $$robo$$android_view_autofill_AutofillManager$isFinishedLocked() {
        return this.mState == 2;
    }

    private final void $$robo$$android_view_autofill_AutofillManager$post(Runnable runnable) {
        AutofillClient client = this.getClient();
        if (client == null) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "ignoring post() because client is null");
            }
            return;
        }
        client.autofillClientRunOnUiThread(runnable);
    }

    public static int makeAuthenticationId(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("makeAuthenticationId", $$robo$$android_view_autofill_AutofillManager$makeAuthenticationId(int int ), (int)n, (int)n2);
    }

    public static int getRequestIdFromAuthenticationId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRequestIdFromAuthenticationId", $$robo$$android_view_autofill_AutofillManager$getRequestIdFromAuthenticationId(int ), (int)n);
    }

    public static int getDatasetIdFromAuthenticationId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDatasetIdFromAuthenticationId", $$robo$$android_view_autofill_AutofillManager$getDatasetIdFromAuthenticationId(int ), (int)n);
    }

    private void __constructor__(Context context, IAutoFillManager iAutoFillManager) {
        this.$$robo$$android_view_autofill_AutofillManager$__constructor__(context, iAutoFillManager);
    }

    public AutofillManager(Context context, IAutoFillManager iAutoFillManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager$__constructor__(android.content.Context android.view.autofill.IAutoFillManager ), this, context, iAutoFillManager);
    }

    public void enableCompatibilityMode() {
        InvokeDynamicSupport.bootstrap("enableCompatibilityMode", $$robo$$android_view_autofill_AutofillManager$enableCompatibilityMode(), this);
    }

    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_view_autofill_AutofillManager$onCreate(android.os.Bundle ), this, bundle);
    }

    public void onVisibleForAutofill() {
        InvokeDynamicSupport.bootstrap("onVisibleForAutofill", $$robo$$android_view_autofill_AutofillManager$onVisibleForAutofill(), this);
    }

    public void onInvisibleForAutofill() {
        InvokeDynamicSupport.bootstrap("onInvisibleForAutofill", $$robo$$android_view_autofill_AutofillManager$onInvisibleForAutofill(), this);
    }

    public void onSaveInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_view_autofill_AutofillManager$onSaveInstanceState(android.os.Bundle ), this, bundle);
    }

    public boolean isCompatibilityModeEnabledLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompatibilityModeEnabledLocked", $$robo$$android_view_autofill_AutofillManager$isCompatibilityModeEnabledLocked(), this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_autofill_AutofillManager$isEnabled(), this);
    }

    public FillEventHistory getFillEventHistory() {
        return InvokeDynamicSupport.bootstrap("getFillEventHistory", $$robo$$android_view_autofill_AutofillManager$getFillEventHistory(), this);
    }

    public void requestAutofill(View view) {
        InvokeDynamicSupport.bootstrap("requestAutofill", $$robo$$android_view_autofill_AutofillManager$requestAutofill(android.view.View ), this, view);
    }

    public void requestAutofill(View view, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("requestAutofill", $$robo$$android_view_autofill_AutofillManager$requestAutofill(android.view.View int android.graphics.Rect ), this, view, n, rect);
    }

    public void notifyViewEntered(View view) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View ), this, view);
    }

    private boolean shouldIgnoreViewEnteredLocked(AutofillId autofillId, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIgnoreViewEnteredLocked", $$robo$$android_view_autofill_AutofillManager$shouldIgnoreViewEnteredLocked(android.view.autofill.AutofillId int ), this, autofillId, n);
    }

    private boolean isClientVisibleForAutofillLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClientVisibleForAutofillLocked", $$robo$$android_view_autofill_AutofillManager$isClientVisibleForAutofillLocked(), this);
    }

    private boolean isClientDisablingEnterExitEvent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClientDisablingEnterExitEvent", $$robo$$android_view_autofill_AutofillManager$isClientDisablingEnterExitEvent(), this);
    }

    private void notifyViewEntered(View view, int n) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View int ), this, view, n);
    }

    private AutofillCallback notifyViewEnteredLocked(View view, int n) {
        return InvokeDynamicSupport.bootstrap("notifyViewEnteredLocked", $$robo$$android_view_autofill_AutofillManager$notifyViewEnteredLocked(android.view.View int ), this, view, n);
    }

    public void notifyViewExited(View view) {
        InvokeDynamicSupport.bootstrap("notifyViewExited", $$robo$$android_view_autofill_AutofillManager$notifyViewExited(android.view.View ), this, view);
    }

    void notifyViewExitedLocked(View view) {
        InvokeDynamicSupport.bootstrap("notifyViewExitedLocked", $$robo$$android_view_autofill_AutofillManager$notifyViewExitedLocked(android.view.View ), this, view);
    }

    public void notifyViewVisibilityChanged(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyViewVisibilityChanged", $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(android.view.View boolean ), this, view, bl);
    }

    public void notifyViewVisibilityChanged(View view, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyViewVisibilityChanged", $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(android.view.View int boolean ), this, view, n, bl);
    }

    private void notifyViewVisibilityChangedInternal(View view, int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("notifyViewVisibilityChangedInternal", $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChangedInternal(android.view.View int boolean boolean ), this, view, n, bl, bl2);
    }

    public void notifyViewEntered(View view, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View int android.graphics.Rect ), this, view, n, rect);
    }

    private void notifyViewEntered(View view, int n, Rect rect, int n2) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View int android.graphics.Rect int ), this, view, n, rect, n2);
    }

    private AutofillCallback notifyViewEnteredLocked(View view, int n, Rect rect, int n2) {
        return InvokeDynamicSupport.bootstrap("notifyViewEnteredLocked", $$robo$$android_view_autofill_AutofillManager$notifyViewEnteredLocked(android.view.View int android.graphics.Rect int ), this, view, n, rect, n2);
    }

    private void addEnteredIdLocked(AutofillId autofillId) {
        InvokeDynamicSupport.bootstrap("addEnteredIdLocked", $$robo$$android_view_autofill_AutofillManager$addEnteredIdLocked(android.view.autofill.AutofillId ), this, autofillId);
    }

    public void notifyViewExited(View view, int n) {
        InvokeDynamicSupport.bootstrap("notifyViewExited", $$robo$$android_view_autofill_AutofillManager$notifyViewExited(android.view.View int ), this, view, n);
    }

    private void notifyViewExitedLocked(View view, int n) {
        InvokeDynamicSupport.bootstrap("notifyViewExitedLocked", $$robo$$android_view_autofill_AutofillManager$notifyViewExitedLocked(android.view.View int ), this, view, n);
    }

    public void notifyValueChanged(View view) {
        InvokeDynamicSupport.bootstrap("notifyValueChanged", $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(android.view.View ), this, view);
    }

    public void notifyValueChanged(View view, int n, AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("notifyValueChanged", $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(android.view.View int android.view.autofill.AutofillValue ), this, view, n, autofillValue);
    }

    public void notifyViewClicked(View view) {
        InvokeDynamicSupport.bootstrap("notifyViewClicked", $$robo$$android_view_autofill_AutofillManager$notifyViewClicked(android.view.View ), this, view);
    }

    public void notifyViewClicked(View view, int n) {
        InvokeDynamicSupport.bootstrap("notifyViewClicked", $$robo$$android_view_autofill_AutofillManager$notifyViewClicked(android.view.View int ), this, view, n);
    }

    private void notifyViewClicked(AutofillId autofillId) {
        InvokeDynamicSupport.bootstrap("notifyViewClicked", $$robo$$android_view_autofill_AutofillManager$notifyViewClicked(android.view.autofill.AutofillId ), this, autofillId);
    }

    public void onActivityFinishing() {
        InvokeDynamicSupport.bootstrap("onActivityFinishing", $$robo$$android_view_autofill_AutofillManager$onActivityFinishing(), this);
    }

    public void commit() {
        InvokeDynamicSupport.bootstrap("commit", $$robo$$android_view_autofill_AutofillManager$commit(), this);
    }

    private void commitLocked() {
        InvokeDynamicSupport.bootstrap("commitLocked", $$robo$$android_view_autofill_AutofillManager$commitLocked(), this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_autofill_AutofillManager$cancel(), this);
    }

    private void cancelLocked() {
        InvokeDynamicSupport.bootstrap("cancelLocked", $$robo$$android_view_autofill_AutofillManager$cancelLocked(), this);
    }

    public void disableOwnedAutofillServices() {
        InvokeDynamicSupport.bootstrap("disableOwnedAutofillServices", $$robo$$android_view_autofill_AutofillManager$disableOwnedAutofillServices(), this);
    }

    public void disableAutofillServices() {
        InvokeDynamicSupport.bootstrap("disableAutofillServices", $$robo$$android_view_autofill_AutofillManager$disableAutofillServices(), this);
    }

    public boolean hasEnabledAutofillServices() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEnabledAutofillServices", $$robo$$android_view_autofill_AutofillManager$hasEnabledAutofillServices(), this);
    }

    public ComponentName getAutofillServiceComponentName() {
        return InvokeDynamicSupport.bootstrap("getAutofillServiceComponentName", $$robo$$android_view_autofill_AutofillManager$getAutofillServiceComponentName(), this);
    }

    public String getUserDataId() {
        return InvokeDynamicSupport.bootstrap("getUserDataId", $$robo$$android_view_autofill_AutofillManager$getUserDataId(), this);
    }

    public UserData getUserData() {
        return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$android_view_autofill_AutofillManager$getUserData(), this);
    }

    public void setUserData(UserData userData) {
        InvokeDynamicSupport.bootstrap("setUserData", $$robo$$android_view_autofill_AutofillManager$setUserData(android.service.autofill.UserData ), this, userData);
    }

    public boolean isFieldClassificationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFieldClassificationEnabled", $$robo$$android_view_autofill_AutofillManager$isFieldClassificationEnabled(), this);
    }

    public String getDefaultFieldClassificationAlgorithm() {
        return InvokeDynamicSupport.bootstrap("getDefaultFieldClassificationAlgorithm", $$robo$$android_view_autofill_AutofillManager$getDefaultFieldClassificationAlgorithm(), this);
    }

    public List<String> getAvailableFieldClassificationAlgorithms() {
        return InvokeDynamicSupport.bootstrap("getAvailableFieldClassificationAlgorithms", $$robo$$android_view_autofill_AutofillManager$getAvailableFieldClassificationAlgorithms(), this);
    }

    public boolean isAutofillSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutofillSupported", $$robo$$android_view_autofill_AutofillManager$isAutofillSupported(), this);
    }

    private AutofillClient getClient() {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_view_autofill_AutofillManager$getClient(), this);
    }

    public boolean isAutofillUiShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutofillUiShowing", $$robo$$android_view_autofill_AutofillManager$isAutofillUiShowing(), this);
    }

    public void onAuthenticationResult(int n, Intent intent, View view) {
        InvokeDynamicSupport.bootstrap("onAuthenticationResult", $$robo$$android_view_autofill_AutofillManager$onAuthenticationResult(int android.content.Intent android.view.View ), this, n, intent, view);
    }

    public AutofillId getNextAutofillId() {
        return InvokeDynamicSupport.bootstrap("getNextAutofillId", $$robo$$android_view_autofill_AutofillManager$getNextAutofillId(), this);
    }

    private static AutofillId getAutofillId(View view, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAutofillId", $$robo$$android_view_autofill_AutofillManager$getAutofillId(android.view.View int ), (View)view, (int)n);
    }

    private void startSessionLocked(AutofillId autofillId, Rect rect, AutofillValue autofillValue, int n) {
        InvokeDynamicSupport.bootstrap("startSessionLocked", $$robo$$android_view_autofill_AutofillManager$startSessionLocked(android.view.autofill.AutofillId android.graphics.Rect android.view.autofill.AutofillValue int ), this, autofillId, rect, autofillValue, n);
    }

    private void finishSessionLocked() {
        InvokeDynamicSupport.bootstrap("finishSessionLocked", $$robo$$android_view_autofill_AutofillManager$finishSessionLocked(), this);
    }

    private void cancelSessionLocked() {
        InvokeDynamicSupport.bootstrap("cancelSessionLocked", $$robo$$android_view_autofill_AutofillManager$cancelSessionLocked(), this);
    }

    private void resetSessionLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("resetSessionLocked", $$robo$$android_view_autofill_AutofillManager$resetSessionLocked(boolean ), this, bl);
    }

    private void updateSessionLocked(AutofillId autofillId, Rect rect, AutofillValue autofillValue, int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateSessionLocked", $$robo$$android_view_autofill_AutofillManager$updateSessionLocked(android.view.autofill.AutofillId android.graphics.Rect android.view.autofill.AutofillValue int int ), this, autofillId, rect, autofillValue, n, n2);
    }

    private void ensureServiceClientAddedIfNeededLocked() {
        InvokeDynamicSupport.bootstrap("ensureServiceClientAddedIfNeededLocked", $$robo$$android_view_autofill_AutofillManager$ensureServiceClientAddedIfNeededLocked(), this);
    }

    public void registerCallback(AutofillCallback autofillCallback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_view_autofill_AutofillManager$registerCallback(android.view.autofill.AutofillManager$AutofillCallback ), this, autofillCallback);
    }

    public void unregisterCallback(AutofillCallback autofillCallback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_view_autofill_AutofillManager$unregisterCallback(android.view.autofill.AutofillManager$AutofillCallback ), this, autofillCallback);
    }

    private void requestShowFillUi(int n, AutofillId autofillId, int n2, int n3, Rect rect, IAutofillWindowPresenter iAutofillWindowPresenter) {
        InvokeDynamicSupport.bootstrap("requestShowFillUi", $$robo$$android_view_autofill_AutofillManager$requestShowFillUi(int android.view.autofill.AutofillId int int android.graphics.Rect android.view.autofill.IAutofillWindowPresenter ), this, n, autofillId, n2, n3, rect, iAutofillWindowPresenter);
    }

    private void authenticate(int n, int n2, IntentSender intentSender, Intent intent) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_view_autofill_AutofillManager$authenticate(int int android.content.IntentSender android.content.Intent ), this, n, n2, intentSender, intent);
    }

    private void dispatchUnhandledKey(int n, AutofillId autofillId, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchUnhandledKey", $$robo$$android_view_autofill_AutofillManager$dispatchUnhandledKey(int android.view.autofill.AutofillId android.view.KeyEvent ), this, n, autofillId, keyEvent);
    }

    private void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_view_autofill_AutofillManager$setState(int ), this, n);
    }

    private void setAutofilledIfValuesIs(View view, AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("setAutofilledIfValuesIs", $$robo$$android_view_autofill_AutofillManager$setAutofilledIfValuesIs(android.view.View android.view.autofill.AutofillValue ), this, view, autofillValue);
    }

    private void autofill(int n, List<AutofillId> list, List<AutofillValue> list2) {
        InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_view_autofill_AutofillManager$autofill(int java.util.List<android.view.autofill.AutofillId> java.util.List<android.view.autofill.AutofillValue> ), this, n, list, list2);
    }

    private LogMaker newLog(int n) {
        return InvokeDynamicSupport.bootstrap("newLog", $$robo$$android_view_autofill_AutofillManager$newLog(int ), this, n);
    }

    private void setTrackedViews(int n, AutofillId[] autofillIdArray, boolean bl, boolean bl2, AutofillId[] autofillIdArray2, AutofillId autofillId) {
        InvokeDynamicSupport.bootstrap("setTrackedViews", $$robo$$android_view_autofill_AutofillManager$setTrackedViews(int android.view.autofill.AutofillId[] boolean boolean android.view.autofill.AutofillId[] android.view.autofill.AutofillId ), this, n, autofillIdArray, bl, bl2, autofillIdArray2, autofillId);
    }

    private void setNotifyOnClickLocked(AutofillId autofillId, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNotifyOnClickLocked", $$robo$$android_view_autofill_AutofillManager$setNotifyOnClickLocked(android.view.autofill.AutofillId boolean ), this, autofillId, bl);
    }

    private void setSaveUiState(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSaveUiState", $$robo$$android_view_autofill_AutofillManager$setSaveUiState(int boolean ), this, n, bl);
    }

    private void setSessionFinished(int n) {
        InvokeDynamicSupport.bootstrap("setSessionFinished", $$robo$$android_view_autofill_AutofillManager$setSessionFinished(int ), this, n);
    }

    public void requestHideFillUi() {
        InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(), this);
    }

    private void requestHideFillUi(AutofillId autofillId, boolean bl) {
        InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(android.view.autofill.AutofillId boolean ), this, autofillId, bl);
    }

    private void requestHideFillUi(AutofillId autofillId, View view) {
        InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(android.view.autofill.AutofillId android.view.View ), this, autofillId, view);
    }

    private void notifyNoFillUi(int n, AutofillId autofillId, int n2) {
        InvokeDynamicSupport.bootstrap("notifyNoFillUi", $$robo$$android_view_autofill_AutofillManager$notifyNoFillUi(int android.view.autofill.AutofillId int ), this, n, autofillId, n2);
    }

    private View findView(AutofillId autofillId) {
        return InvokeDynamicSupport.bootstrap("findView", $$robo$$android_view_autofill_AutofillManager$findView(android.view.autofill.AutofillId ), this, autofillId);
    }

    public boolean hasAutofillFeature() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAutofillFeature", $$robo$$android_view_autofill_AutofillManager$hasAutofillFeature(), this);
    }

    public void onPendingSaveUi(int n, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("onPendingSaveUi", $$robo$$android_view_autofill_AutofillManager$onPendingSaveUi(int android.os.IBinder ), this, n, iBinder);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_view_autofill_AutofillManager$dump(java.lang.String java.io.PrintWriter ), this, string2, printWriter);
    }

    private String getStateAsStringLocked() {
        return InvokeDynamicSupport.bootstrap("getStateAsStringLocked", $$robo$$android_view_autofill_AutofillManager$getStateAsStringLocked(), this);
    }

    private static String getStateAsString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getStateAsString", $$robo$$android_view_autofill_AutofillManager$getStateAsString(int ), (int)n);
    }

    private boolean isActiveLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveLocked", $$robo$$android_view_autofill_AutofillManager$isActiveLocked(), this);
    }

    private boolean isDisabledByServiceLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisabledByServiceLocked", $$robo$$android_view_autofill_AutofillManager$isDisabledByServiceLocked(), this);
    }

    private boolean isFinishedLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFinishedLocked", $$robo$$android_view_autofill_AutofillManager$isFinishedLocked(), this);
    }

    private void post(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("post", $$robo$$android_view_autofill_AutofillManager$post(java.lang.Runnable ), this, runnable);
    }

    public /* synthetic */ AutofillManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class AutofillManagerClient
    extends IAutoFillManagerClient.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<AutofillManager> mAfm;

        private void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$__constructor__(AutofillManager autofillManager) {
            this.mAfm = new WeakReference<AutofillManager>(autofillManager);
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setState(int flags) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setState(flags));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofill(sessionId, ids, values));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.authenticate(sessionId, authenticationId, intent, fillInIntent));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestHideFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestHideFillUi(id2, false));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyNoFillUi(sessionId, id2, sessionFinishedState));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent fullScreen) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.dispatchUnhandledKey(sessionId, id2, fullScreen));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$startIntentSender(IntentSender intentSender, Intent intent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> {
                    try {
                        afm.mContext.startIntentSender(intentSender, intent, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e("AutofillManager", "startIntentSender() failed for intent:" + intentSender, e);
                    }
                });
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setTrackedViews(int sessionId, AutofillId[] ids, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setTrackedViews(sessionId, ids, saveOnAllViewsInvisible, saveOnFinish, fillableIds, saveTriggerId));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSaveUiState(int sessionId, boolean shown) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSaveUiState(sessionId, shown));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSessionFinished(int newState) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSessionFinished(newState));
            }
        }

        private void __constructor__(AutofillManager autofillManager) {
            this.$$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$__constructor__(autofillManager);
        }

        public AutofillManagerClient(AutofillManager autofillManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$__constructor__(android.view.autofill.AutofillManager ), this, autofillManager);
        }

        @Override
        public void setState(int n) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setState(int ), this, n);
        }

        @Override
        public void autofill(int n, List<AutofillId> list, List<AutofillValue> list2) {
            InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$autofill(int java.util.List<android.view.autofill.AutofillId> java.util.List<android.view.autofill.AutofillValue> ), this, n, list, list2);
        }

        @Override
        public void authenticate(int n, int n2, IntentSender intentSender, Intent intent) {
            InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$authenticate(int int android.content.IntentSender android.content.Intent ), this, n, n2, intentSender, intent);
        }

        @Override
        public void requestShowFillUi(int n, AutofillId autofillId, int n2, int n3, Rect rect, IAutofillWindowPresenter iAutofillWindowPresenter) {
            InvokeDynamicSupport.bootstrap("requestShowFillUi", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestShowFillUi(int android.view.autofill.AutofillId int int android.graphics.Rect android.view.autofill.IAutofillWindowPresenter ), this, n, autofillId, n2, n3, rect, iAutofillWindowPresenter);
        }

        @Override
        public void requestHideFillUi(int n, AutofillId autofillId) {
            InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestHideFillUi(int android.view.autofill.AutofillId ), this, n, autofillId);
        }

        @Override
        public void notifyNoFillUi(int n, AutofillId autofillId, int n2) {
            InvokeDynamicSupport.bootstrap("notifyNoFillUi", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$notifyNoFillUi(int android.view.autofill.AutofillId int ), this, n, autofillId, n2);
        }

        @Override
        public void dispatchUnhandledKey(int n, AutofillId autofillId, KeyEvent keyEvent) {
            InvokeDynamicSupport.bootstrap("dispatchUnhandledKey", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$dispatchUnhandledKey(int android.view.autofill.AutofillId android.view.KeyEvent ), this, n, autofillId, keyEvent);
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) {
            InvokeDynamicSupport.bootstrap("startIntentSender", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$startIntentSender(android.content.IntentSender android.content.Intent ), this, intentSender, intent);
        }

        @Override
        public void setTrackedViews(int n, AutofillId[] autofillIdArray, boolean bl, boolean bl2, AutofillId[] autofillIdArray2, AutofillId autofillId) {
            InvokeDynamicSupport.bootstrap("setTrackedViews", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setTrackedViews(int android.view.autofill.AutofillId[] boolean boolean android.view.autofill.AutofillId[] android.view.autofill.AutofillId ), this, n, autofillIdArray, bl, bl2, autofillIdArray2, autofillId);
        }

        @Override
        public void setSaveUiState(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setSaveUiState", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSaveUiState(int boolean ), this, n, bl);
        }

        @Override
        public void setSessionFinished(int n) {
            InvokeDynamicSupport.bootstrap("setSessionFinished", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSessionFinished(int ), this, n);
        }

        public /* synthetic */ AutofillManagerClient() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillManagerClient)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AutofillCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int EVENT_INPUT_SHOWN = 1;
        public static int EVENT_INPUT_HIDDEN = 2;
        public static int EVENT_INPUT_UNAVAILABLE = 3;

        private void $$robo$$android_view_autofill_AutofillManager_AutofillCallback$__constructor__() {
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(View view, int event) {
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(View view, int virtualId, int event) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_autofill_AutofillManager_AutofillCallback$__constructor__();
        }

        public AutofillCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_AutofillCallback$__constructor__(), this);
        }

        public void onAutofillEvent(View view, int n) {
            InvokeDynamicSupport.bootstrap("onAutofillEvent", $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(android.view.View int ), this, view, n);
        }

        public void onAutofillEvent(View view, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onAutofillEvent", $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(android.view.View int int ), this, view, n, n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AutofillEventType {
        }
    }

    private class TrackedViews
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ArraySet<AutofillId> mVisibleTrackedIds;
        private ArraySet<AutofillId> mInvisibleTrackedIds;
        /* synthetic */ AutofillManager this$0;

        private final <T> boolean $$robo$$android_view_autofill_AutofillManager_TrackedViews$isInSet(ArraySet<T> set, T value) {
            return set != null && set.contains(value);
        }

        private final <T> ArraySet<T> $$robo$$android_view_autofill_AutofillManager_TrackedViews$addToSet(ArraySet<T> set, T valueToAdd) {
            if (set == null) {
                set = new ArraySet(1);
            }
            set.add(valueToAdd);
            return set;
        }

        private final <T> ArraySet<T> $$robo$$android_view_autofill_AutofillManager_TrackedViews$removeFromSet(ArraySet<T> set, T valueToRemove) {
            if (set == null) {
                return null;
            }
            set.remove(valueToRemove);
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }

        private void $$robo$$android_view_autofill_AutofillManager_TrackedViews$__constructor__(AutofillManager autofillManager, AutofillId[] trackedIds) {
            this.this$0 = autofillManager;
            AutofillClient client = autofillManager.getClient();
            if (!ArrayUtils.isEmpty(trackedIds) && client != null) {
                boolean[] isVisible;
                if (client.autofillClientIsVisibleForAutofill()) {
                    if (Helper.sVerbose) {
                        Log.v("AutofillManager", "client is visible, check tracked ids");
                    }
                    isVisible = client.autofillClientGetViewVisibility(trackedIds);
                } else {
                    isVisible = new boolean[trackedIds.length];
                }
                int numIds = trackedIds.length;
                for (int i = 0; i < numIds; ++i) {
                    AutofillId id2 = trackedIds[i];
                    if (isVisible[i]) {
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                        continue;
                    }
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "TrackedViews(trackedIds=" + Arrays.toString(trackedIds) + "):  mVisibleTrackedIds=" + this.mVisibleTrackedIds + " mInvisibleTrackedIds=" + this.mInvisibleTrackedIds);
            }
            if (this.mVisibleTrackedIds == null) {
                autofillManager.finishSessionLocked();
            }
        }

        @GuardedBy(value="mLock")
        private final void $$robo$$android_view_autofill_AutofillManager_TrackedViews$notifyViewVisibilityChangedLocked(AutofillId id2, boolean isVisible) {
            if (Helper.sDebug) {
                Log.d("AutofillManager", "notifyViewVisibilityChangedLocked(): id=" + id2 + " isVisible=" + isVisible);
            }
            if (this.this$0.isClientVisibleForAutofillLocked()) {
                if (isVisible) {
                    if (this.isInSet(this.mInvisibleTrackedIds, id2)) {
                        this.mInvisibleTrackedIds = this.removeFromSet(this.mInvisibleTrackedIds, id2);
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                    }
                } else if (this.isInSet(this.mVisibleTrackedIds, id2)) {
                    this.mVisibleTrackedIds = this.removeFromSet(this.mVisibleTrackedIds, id2);
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "No more visible ids. Invisibile = " + this.mInvisibleTrackedIds);
                }
                this.this$0.finishSessionLocked();
            }
        }

        @GuardedBy(value="mLock")
        private final void $$robo$$android_view_autofill_AutofillManager_TrackedViews$onVisibleForAutofillChangedLocked() {
            AutofillClient client = this.this$0.getClient();
            ArraySet<AutofillId> updatedVisibleTrackedIds = null;
            ArraySet<AutofillId> updatedInvisibleTrackedIds = null;
            if (client != null) {
                AutofillId id2;
                int i;
                boolean[] isVisible;
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "onVisibleForAutofillChangedLocked(): inv= " + this.mInvisibleTrackedIds + " vis=" + this.mVisibleTrackedIds);
                }
                if (this.mInvisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedInvisibleIds = new ArrayList<AutofillId>(this.mInvisibleTrackedIds);
                    isVisible = client.autofillClientGetViewVisibility(Helper.toArray(orderedInvisibleIds));
                    int numInvisibleTrackedIds = orderedInvisibleIds.size();
                    for (i = 0; i < numInvisibleTrackedIds; ++i) {
                        id2 = orderedInvisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            if (!Helper.sDebug) continue;
                            Log.d("AutofillManager", "onVisibleForAutofill() " + id2 + " became visible");
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                    }
                }
                if (this.mVisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedVisibleIds = new ArrayList<AutofillId>(this.mVisibleTrackedIds);
                    isVisible = client.autofillClientGetViewVisibility(Helper.toArray(orderedVisibleIds));
                    int numVisibleTrackedIds = orderedVisibleIds.size();
                    for (i = 0; i < numVisibleTrackedIds; ++i) {
                        id2 = orderedVisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                        if (!Helper.sDebug) continue;
                        Log.d("AutofillManager", "onVisibleForAutofill() " + id2 + " became invisible");
                    }
                }
                this.mInvisibleTrackedIds = updatedInvisibleTrackedIds;
                this.mVisibleTrackedIds = updatedVisibleTrackedIds;
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "onVisibleForAutofillChangedLocked(): no more visible ids");
                }
                this.this$0.finishSessionLocked();
            }
        }

        private <T> boolean isInSet(ArraySet<T> arraySet, T t) {
            return (boolean)InvokeDynamicSupport.bootstrap("isInSet", $$robo$$android_view_autofill_AutofillManager_TrackedViews$isInSet(android.util.ArraySet<T> T ), this, arraySet, t);
        }

        private <T> ArraySet<T> addToSet(ArraySet<T> arraySet, T t) {
            return InvokeDynamicSupport.bootstrap("addToSet", $$robo$$android_view_autofill_AutofillManager_TrackedViews$addToSet(android.util.ArraySet<T> T ), this, arraySet, t);
        }

        private <T> ArraySet<T> removeFromSet(ArraySet<T> arraySet, T t) {
            return InvokeDynamicSupport.bootstrap("removeFromSet", $$robo$$android_view_autofill_AutofillManager_TrackedViews$removeFromSet(android.util.ArraySet<T> T ), this, arraySet, t);
        }

        private void __constructor__(AutofillManager autofillManager, AutofillId[] autofillIdArray) {
            this.$$robo$$android_view_autofill_AutofillManager_TrackedViews$__constructor__(autofillManager, autofillIdArray);
        }

        public TrackedViews(AutofillManager autofillManager, AutofillId[] autofillIdArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_TrackedViews$__constructor__(android.view.autofill.AutofillManager android.view.autofill.AutofillId[] ), this, autofillManager, autofillIdArray);
        }

        void notifyViewVisibilityChangedLocked(AutofillId autofillId, boolean bl) {
            InvokeDynamicSupport.bootstrap("notifyViewVisibilityChangedLocked", $$robo$$android_view_autofill_AutofillManager_TrackedViews$notifyViewVisibilityChangedLocked(android.view.autofill.AutofillId boolean ), this, autofillId, bl);
        }

        void onVisibleForAutofillChangedLocked() {
            InvokeDynamicSupport.bootstrap("onVisibleForAutofillChangedLocked", $$robo$$android_view_autofill_AutofillManager_TrackedViews$onVisibleForAutofillChangedLocked(), this);
        }

        public /* synthetic */ TrackedViews() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrackedViews)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CompatibilityBridge
    implements AccessibilityManager.AccessibilityPolicy,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @GuardedBy(value="mLock")
        private Rect mFocusedBounds;
        @GuardedBy(value="mLock")
        private Rect mTempBounds;
        @GuardedBy(value="mLock")
        private int mFocusedWindowId;
        @GuardedBy(value="mLock")
        private long mFocusedNodeId;
        @GuardedBy(value="mLock")
        AccessibilityServiceInfo mCompatServiceInfo;
        /* synthetic */ AutofillManager this$0;

        private void $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$__constructor__(AutofillManager autofillManager) {
            this.this$0 = autofillManager;
            this.mFocusedBounds = new Rect();
            this.mTempBounds = new Rect();
            this.mFocusedWindowId = -1;
            this.mFocusedNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
            AccessibilityManager am = AccessibilityManager.getInstance(autofillManager.mContext);
            am.setAccessibilityPolicy(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AccessibilityServiceInfo $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getCompatServiceInfo() {
            Object object = this.this$0.mLock;
            synchronized (object) {
                if (this.mCompatServiceInfo != null) {
                    return this.mCompatServiceInfo;
                }
                Intent intent = new Intent();
                intent.setComponent(new ComponentName("android", "com.android.server.autofill.AutofillCompatAccessibilityService"));
                ResolveInfo resolveInfo = this.this$0.mContext.getPackageManager().resolveService(intent, 0x100080);
                try {
                    this.mCompatServiceInfo = new AccessibilityServiceInfo(resolveInfo, this.this$0.mContext);
                }
                catch (IOException | XmlPullParserException e) {
                    Log.e("AutofillManager", "Cannot find compat autofill service:" + intent);
                    throw new IllegalStateException("Cannot find compat autofill service");
                }
                return this.mCompatServiceInfo;
            }
        }

        private final boolean $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$isEnabled(boolean accessibilityEnabled) {
            return true;
        }

        private final int $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getRelevantEventTypes(int relevantEventTypes) {
            return relevantEventTypes | 8 | 0x10 | 1 | 0x800;
        }

        private final List<AccessibilityServiceInfo> $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> installedServices) {
            if (installedServices == null) {
                installedServices = new ArrayList<AccessibilityServiceInfo>();
            }
            installedServices.add(this.getCompatServiceInfo());
            return installedServices;
        }

        private final List<AccessibilityServiceInfo> $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getEnabledAccessibilityServiceList(int feedbackTypeFlags, List<AccessibilityServiceInfo> enabledService) {
            if (enabledService == null) {
                enabledService = new ArrayList<AccessibilityServiceInfo>();
            }
            enabledService.add(this.getCompatServiceInfo());
            return enabledService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AccessibilityEvent $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$onAccessibilityEvent(AccessibilityEvent event, boolean accessibilityEnabled, int relevantEventTypes) {
            switch (event.getEventType()) {
                case 8: {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        long nodeId;
                        int windowId;
                        if (this.mFocusedWindowId == event.getWindowId() && this.mFocusedNodeId == event.getSourceNodeId()) {
                            return event;
                        }
                        if (this.mFocusedWindowId != -1 && this.mFocusedNodeId != AccessibilityNodeInfo.UNDEFINED_NODE_ID) {
                            this.notifyViewExited(this.mFocusedWindowId, this.mFocusedNodeId);
                            this.mFocusedWindowId = -1;
                            this.mFocusedNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
                            this.mFocusedBounds.set(0, 0, 0, 0);
                        }
                        if (this.notifyViewEntered(windowId = event.getWindowId(), nodeId = event.getSourceNodeId(), this.mFocusedBounds)) {
                            this.mFocusedWindowId = windowId;
                            this.mFocusedNodeId = nodeId;
                        }
                        break;
                    }
                }
                case 16: {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (this.mFocusedWindowId == event.getWindowId() && this.mFocusedNodeId == event.getSourceNodeId()) {
                            this.notifyValueChanged(event.getWindowId(), event.getSourceNodeId());
                        }
                        break;
                    }
                }
                case 1: {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.notifyViewClicked(event.getWindowId(), event.getSourceNodeId());
                        break;
                    }
                }
                case 2048: {
                    AutofillClient client = this.this$0.getClient();
                    if (client == null) break;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (client.autofillClientIsFillUiShowing()) {
                            this.notifyViewEntered(this.mFocusedWindowId, this.mFocusedNodeId, this.mFocusedBounds);
                        }
                        this.updateTrackedViewsLocked();
                        break;
                    }
                }
            }
            return accessibilityEnabled ? event : null;
        }

        private final boolean $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyViewEntered(int windowId, long nodeId, Rect focusedBounds) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return false;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return false;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return false;
            }
            if (!node.isEditable()) {
                return false;
            }
            Rect newBounds = this.mTempBounds;
            node.getBoundsInScreen(newBounds);
            if (newBounds.equals(focusedBounds)) {
                return false;
            }
            focusedBounds.set(newBounds);
            this.this$0.notifyViewEntered(view, virtualId, newBounds);
            return true;
        }

        private final void $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyViewExited(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            this.this$0.notifyViewExited(view, virtualId);
        }

        private final void $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyValueChanged(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return;
            }
            this.this$0.notifyValueChanged(view, virtualId, AutofillValue.forText(node.getText()));
        }

        private final void $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyViewClicked(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return;
            }
            this.this$0.notifyViewClicked(view, virtualId);
        }

        @GuardedBy(value="mLock")
        private final void $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$updateTrackedViewsLocked() {
            if (this.this$0.mTrackedViews != null) {
                this.this$0.mTrackedViews.onVisibleForAutofillChangedLocked();
            }
        }

        private final View $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$findViewByAccessibilityId(int windowId, long nodeId) {
            AutofillClient client = this.this$0.getClient();
            if (client == null) {
                return null;
            }
            int viewId = AccessibilityNodeInfo.getAccessibilityViewId(nodeId);
            return client.autofillClientFindViewByAccessibilityIdTraversal(viewId, windowId);
        }

        private final AccessibilityNodeInfo $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$findVirtualNodeByAccessibilityId(View view, int virtualId) {
            AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
            if (provider == null) {
                return null;
            }
            return provider.createAccessibilityNodeInfo(virtualId);
        }

        private final boolean $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$isVirtualNode(int nodeId) {
            return nodeId != -1 && nodeId != Integer.MAX_VALUE;
        }

        private void __constructor__(AutofillManager autofillManager) {
            this.$$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$__constructor__(autofillManager);
        }

        public CompatibilityBridge(AutofillManager autofillManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$__constructor__(android.view.autofill.AutofillManager ), this, autofillManager);
        }

        private AccessibilityServiceInfo getCompatServiceInfo() {
            return InvokeDynamicSupport.bootstrap("getCompatServiceInfo", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getCompatServiceInfo(), this);
        }

        @Override
        public boolean isEnabled(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$isEnabled(boolean ), this, bl);
        }

        @Override
        public int getRelevantEventTypes(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getRelevantEventTypes", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getRelevantEventTypes(int ), this, n);
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> list) {
            return InvokeDynamicSupport.bootstrap("getInstalledAccessibilityServiceList", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getInstalledAccessibilityServiceList(java.util.List<android.accessibilityservice.AccessibilityServiceInfo> ), this, list);
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int n, List<AccessibilityServiceInfo> list) {
            return InvokeDynamicSupport.bootstrap("getEnabledAccessibilityServiceList", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$getEnabledAccessibilityServiceList(int java.util.List<android.accessibilityservice.AccessibilityServiceInfo> ), this, n, list);
        }

        @Override
        public AccessibilityEvent onAccessibilityEvent(AccessibilityEvent accessibilityEvent, boolean bl, int n) {
            return InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent boolean int ), this, accessibilityEvent, bl, n);
        }

        private boolean notifyViewEntered(int n, long l, Rect rect) {
            return (boolean)InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyViewEntered(int long android.graphics.Rect ), this, n, l, rect);
        }

        private void notifyViewExited(int n, long l) {
            InvokeDynamicSupport.bootstrap("notifyViewExited", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyViewExited(int long ), this, n, l);
        }

        private void notifyValueChanged(int n, long l) {
            InvokeDynamicSupport.bootstrap("notifyValueChanged", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyValueChanged(int long ), this, n, l);
        }

        private void notifyViewClicked(int n, long l) {
            InvokeDynamicSupport.bootstrap("notifyViewClicked", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$notifyViewClicked(int long ), this, n, l);
        }

        private void updateTrackedViewsLocked() {
            InvokeDynamicSupport.bootstrap("updateTrackedViewsLocked", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$updateTrackedViewsLocked(), this);
        }

        private View findViewByAccessibilityId(int n, long l) {
            return InvokeDynamicSupport.bootstrap("findViewByAccessibilityId", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$findViewByAccessibilityId(int long ), this, n, l);
        }

        private AccessibilityNodeInfo findVirtualNodeByAccessibilityId(View view, int n) {
            return InvokeDynamicSupport.bootstrap("findVirtualNodeByAccessibilityId", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$findVirtualNodeByAccessibilityId(android.view.View int ), this, view, n);
        }

        private boolean isVirtualNode(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isVirtualNode", $$robo$$android_view_autofill_AutofillManager_CompatibilityBridge$isVirtualNode(int ), this, n);
        }

        public /* synthetic */ CompatibilityBridge() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompatibilityBridge)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface AutofillClient {
        public void autofillClientAuthenticate(int var1, IntentSender var2, Intent var3);

        public void autofillClientResetableStateAvailable();

        public boolean autofillClientRequestShowFillUi(View var1, int var2, int var3, Rect var4, IAutofillWindowPresenter var5);

        public void autofillClientDispatchUnhandledKey(View var1, KeyEvent var2);

        public boolean autofillClientRequestHideFillUi();

        public boolean autofillClientIsFillUiShowing();

        public boolean[] autofillClientGetViewVisibility(AutofillId[] var1);

        public boolean autofillClientIsVisibleForAutofill();

        public boolean isDisablingEnterExitEventForAutofill();

        public View[] autofillClientFindViewsByAutofillIdTraversal(AutofillId[] var1);

        public View autofillClientFindViewByAutofillIdTraversal(AutofillId var1);

        public View autofillClientFindViewByAccessibilityIdTraversal(int var1, int var2);

        public void autofillClientRunOnUiThread(Runnable var1);

        public ComponentName autofillClientGetComponentName();

        public IBinder autofillClientGetActivityToken();

        public boolean autofillClientIsCompatibilityModeEnabled();

        public AutofillId autofillClientGetNextAutofillId();
    }
}

