/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AnimationSet
extends Animation
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int PROPERTY_FILL_AFTER_MASK = 1;
    private static int PROPERTY_FILL_BEFORE_MASK = 2;
    private static int PROPERTY_REPEAT_MODE_MASK = 4;
    private static int PROPERTY_START_OFFSET_MASK = 8;
    private static int PROPERTY_SHARE_INTERPOLATOR_MASK = 16;
    private static int PROPERTY_DURATION_MASK = 32;
    private static int PROPERTY_MORPH_MATRIX_MASK = 64;
    private static int PROPERTY_CHANGE_BOUNDS_MASK = 128;
    private int mFlags;
    private boolean mDirty;
    private boolean mHasAlpha;
    private ArrayList<Animation> mAnimations;
    private Transformation mTempTransformation;
    private long mLastEnd;
    private long[] mStoredOffsets;

    private void $$robo$$android_view_animation_AnimationSet$__constructor__(Context context, AttributeSet attrs) {
        this.mFlags = 0;
        this.mAnimations = new ArrayList();
        this.mTempTransformation = new Transformation();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnimationSet);
        this.setFlag(16, a.getBoolean(1, true));
        this.init();
        if (context.getApplicationInfo().targetSdkVersion >= 14) {
            if (a.hasValue(0)) {
                this.mFlags |= 0x20;
            }
            if (a.hasValue(2)) {
                this.mFlags |= 2;
            }
            if (a.hasValue(3)) {
                this.mFlags |= 1;
            }
            if (a.hasValue(5)) {
                this.mFlags |= 4;
            }
            if (a.hasValue(4)) {
                this.mFlags |= 8;
            }
        }
        a.recycle();
    }

    private void $$robo$$android_view_animation_AnimationSet$__constructor__(boolean shareInterpolator) {
        this.mFlags = 0;
        this.mAnimations = new ArrayList();
        this.mTempTransformation = new Transformation();
        this.setFlag(16, shareInterpolator);
        this.init();
    }

    private final AnimationSet $$robo$$android_view_animation_AnimationSet$clone() throws CloneNotSupportedException {
        AnimationSet animation = (AnimationSet)super.clone();
        animation.mTempTransformation = new Transformation();
        animation.mAnimations = new ArrayList();
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = 0; i < count; ++i) {
            animation.mAnimations.add((Animation)animations.get(i).clone());
        }
        return animation;
    }

    private final void $$robo$$android_view_animation_AnimationSet$setFlag(int mask, boolean value) {
        this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
    }

    private final void $$robo$$android_view_animation_AnimationSet$init() {
        this.mStartTime = 0L;
    }

    private final void $$robo$$android_view_animation_AnimationSet$setFillAfter(boolean fillAfter) {
        this.mFlags |= 1;
        super.setFillAfter(fillAfter);
    }

    private final void $$robo$$android_view_animation_AnimationSet$setFillBefore(boolean fillBefore) {
        this.mFlags |= 2;
        super.setFillBefore(fillBefore);
    }

    private final void $$robo$$android_view_animation_AnimationSet$setRepeatMode(int repeatMode) {
        this.mFlags |= 4;
        super.setRepeatMode(repeatMode);
    }

    private final void $$robo$$android_view_animation_AnimationSet$setStartOffset(long startOffset) {
        this.mFlags |= 8;
        super.setStartOffset(startOffset);
    }

    private final boolean $$robo$$android_view_animation_AnimationSet$hasAlpha() {
        if (this.mDirty) {
            this.mHasAlpha = false;
            this.mDirty = false;
            int count = this.mAnimations.size();
            ArrayList<Animation> animations = this.mAnimations;
            for (int i = 0; i < count; ++i) {
                if (!animations.get(i).hasAlpha()) continue;
                this.mHasAlpha = true;
                break;
            }
        }
        return this.mHasAlpha;
    }

    private final void $$robo$$android_view_animation_AnimationSet$setDuration(long durationMillis) {
        this.mFlags |= 0x20;
        super.setDuration(durationMillis);
        this.mLastEnd = this.mStartOffset + this.mDuration;
    }

    private final void $$robo$$android_view_animation_AnimationSet$addAnimation(Animation a) {
        boolean changeBounds;
        boolean noMatrix;
        this.mAnimations.add(a);
        boolean bl = noMatrix = (this.mFlags & 0x40) == 0;
        if (noMatrix && a.willChangeTransformationMatrix()) {
            this.mFlags |= 0x40;
        }
        boolean bl2 = changeBounds = (this.mFlags & 0x80) == 0;
        if (changeBounds && a.willChangeBounds()) {
            this.mFlags |= 0x80;
        }
        if ((this.mFlags & 0x20) == 32) {
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else if (this.mAnimations.size() == 1) {
            this.mDuration = a.getStartOffset() + a.getDuration();
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else {
            this.mLastEnd = Math.max(this.mLastEnd, this.mStartOffset + a.getStartOffset() + a.getDuration());
            this.mDuration = this.mLastEnd - this.mStartOffset;
        }
        this.mDirty = true;
    }

    private final void $$robo$$android_view_animation_AnimationSet$setStartTime(long startTimeMillis) {
        super.setStartTime(startTimeMillis);
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = 0; i < count; ++i) {
            Animation a = animations.get(i);
            a.setStartTime(startTimeMillis);
        }
    }

    private final long $$robo$$android_view_animation_AnimationSet$getStartTime() {
        long startTime = Long.MAX_VALUE;
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = 0; i < count; ++i) {
            Animation a = animations.get(i);
            startTime = Math.min(startTime, a.getStartTime());
        }
        return startTime;
    }

    private final void $$robo$$android_view_animation_AnimationSet$restrictDuration(long durationMillis) {
        super.restrictDuration(durationMillis);
        ArrayList<Animation> animations = this.mAnimations;
        int count = animations.size();
        for (int i = 0; i < count; ++i) {
            animations.get(i).restrictDuration(durationMillis);
        }
    }

    private final long $$robo$$android_view_animation_AnimationSet$getDuration() {
        boolean durationSet;
        ArrayList<Animation> animations = this.mAnimations;
        int count = animations.size();
        long duration = 0L;
        boolean bl = durationSet = (this.mFlags & 0x20) == 32;
        if (durationSet) {
            duration = this.mDuration;
        } else {
            for (int i = 0; i < count; ++i) {
                duration = Math.max(duration, animations.get(i).getDuration());
            }
        }
        return duration;
    }

    private final long $$robo$$android_view_animation_AnimationSet$computeDurationHint() {
        long duration = 0L;
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = count - 1; i >= 0; --i) {
            long d = animations.get(i).computeDurationHint();
            if (d <= duration) continue;
            duration = d;
        }
        return duration;
    }

    private final void $$robo$$android_view_animation_AnimationSet$initializeInvalidateRegion(int left, int top, int right, int bottom) {
        RectF region = this.mPreviousRegion;
        region.set(left, top, right, bottom);
        region.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            int count = this.mAnimations.size();
            ArrayList<Animation> animations = this.mAnimations;
            Transformation temp = this.mTempTransformation;
            Transformation previousTransformation = this.mPreviousTransformation;
            for (int i = count - 1; i >= 0; --i) {
                Animation a = animations.get(i);
                if (a.isFillEnabled() && !a.getFillBefore() && a.getStartOffset() != 0L) continue;
                temp.clear();
                Interpolator interpolator2 = a.mInterpolator;
                a.applyTransformation(interpolator2 != null ? interpolator2.getInterpolation(0.0f) : 0.0f, temp);
                previousTransformation.compose(temp);
            }
        }
    }

    private final boolean $$robo$$android_view_animation_AnimationSet$getTransformation(long currentTime, Transformation t) {
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        Transformation temp = this.mTempTransformation;
        boolean more = false;
        boolean started = false;
        boolean ended = true;
        t.clear();
        for (int i = count - 1; i >= 0; --i) {
            Animation a = animations.get(i);
            temp.clear();
            more = a.getTransformation(currentTime, temp, this.getScaleFactor()) || more;
            t.compose(temp);
            started = started || a.hasStarted();
            ended = a.hasEnded() && ended;
        }
        if (started && !this.mStarted) {
            if (this.mListener != null) {
                this.mListener.onAnimationStart(this);
            }
            this.mStarted = true;
        }
        if (ended != this.mEnded) {
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this);
            }
            this.mEnded = ended;
        }
        return more;
    }

    private final void $$robo$$android_view_animation_AnimationSet$scaleCurrentDuration(float scale) {
        ArrayList<Animation> animations = this.mAnimations;
        int count = animations.size();
        for (int i = 0; i < count; ++i) {
            animations.get(i).scaleCurrentDuration(scale);
        }
    }

    private final void $$robo$$android_view_animation_AnimationSet$initialize(int width, int height, int parentWidth, int parentHeight) {
        boolean startOffsetSet;
        super.initialize(width, height, parentWidth, parentHeight);
        boolean durationSet = (this.mFlags & 0x20) == 32;
        boolean fillAfterSet = (this.mFlags & 1) == 1;
        boolean fillBeforeSet = (this.mFlags & 2) == 2;
        boolean repeatModeSet = (this.mFlags & 4) == 4;
        boolean shareInterpolator = (this.mFlags & 0x10) == 16;
        boolean bl = startOffsetSet = (this.mFlags & 8) == 8;
        if (shareInterpolator) {
            this.ensureInterpolator();
        }
        ArrayList<Animation> children = this.mAnimations;
        int count = children.size();
        long duration = this.mDuration;
        boolean fillAfter = this.mFillAfter;
        boolean fillBefore = this.mFillBefore;
        int repeatMode = this.mRepeatMode;
        Interpolator interpolator2 = this.mInterpolator;
        long startOffset = this.mStartOffset;
        long[] storedOffsets = this.mStoredOffsets;
        if (startOffsetSet) {
            if (storedOffsets == null || storedOffsets.length != count) {
                storedOffsets = this.mStoredOffsets = new long[count];
            }
        } else if (storedOffsets != null) {
            this.mStoredOffsets = null;
            storedOffsets = null;
        }
        for (int i = 0; i < count; ++i) {
            Animation a = children.get(i);
            if (durationSet) {
                a.setDuration(duration);
            }
            if (fillAfterSet) {
                a.setFillAfter(fillAfter);
            }
            if (fillBeforeSet) {
                a.setFillBefore(fillBefore);
            }
            if (repeatModeSet) {
                a.setRepeatMode(repeatMode);
            }
            if (shareInterpolator) {
                a.setInterpolator(interpolator2);
            }
            if (startOffsetSet) {
                long offset = a.getStartOffset();
                a.setStartOffset(offset + startOffset);
                storedOffsets[i] = offset;
            }
            a.initialize(width, height, parentWidth, parentHeight);
        }
    }

    private final void $$robo$$android_view_animation_AnimationSet$reset() {
        super.reset();
        this.restoreChildrenStartOffset();
    }

    private final void $$robo$$android_view_animation_AnimationSet$restoreChildrenStartOffset() {
        long[] offsets = this.mStoredOffsets;
        if (offsets == null) {
            return;
        }
        ArrayList<Animation> children = this.mAnimations;
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            children.get(i).setStartOffset(offsets[i]);
        }
    }

    private final List<Animation> $$robo$$android_view_animation_AnimationSet$getAnimations() {
        return this.mAnimations;
    }

    private final boolean $$robo$$android_view_animation_AnimationSet$willChangeTransformationMatrix() {
        return (this.mFlags & 0x40) == 64;
    }

    private final boolean $$robo$$android_view_animation_AnimationSet$willChangeBounds() {
        return (this.mFlags & 0x80) == 128;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_AnimationSet$__constructor__(context, attributeSet);
    }

    public AnimationSet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_AnimationSet$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_view_animation_AnimationSet$__constructor__(bl);
    }

    public AnimationSet(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_AnimationSet$__constructor__(boolean ), this, bl);
    }

    @Override
    protected AnimationSet clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_view_animation_AnimationSet$clone(), this);
    }

    private void setFlag(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_view_animation_AnimationSet$setFlag(int boolean ), this, n, bl);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_animation_AnimationSet$init(), this);
    }

    @Override
    public void setFillAfter(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillAfter", $$robo$$android_view_animation_AnimationSet$setFillAfter(boolean ), this, bl);
    }

    @Override
    public void setFillBefore(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillBefore", $$robo$$android_view_animation_AnimationSet$setFillBefore(boolean ), this, bl);
    }

    @Override
    public void setRepeatMode(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatMode", $$robo$$android_view_animation_AnimationSet$setRepeatMode(int ), this, n);
    }

    @Override
    public void setStartOffset(long l) {
        InvokeDynamicSupport.bootstrap("setStartOffset", $$robo$$android_view_animation_AnimationSet$setStartOffset(long ), this, l);
    }

    @Override
    public boolean hasAlpha() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAlpha", $$robo$$android_view_animation_AnimationSet$hasAlpha(), this);
    }

    @Override
    public void setDuration(long l) {
        InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_view_animation_AnimationSet$setDuration(long ), this, l);
    }

    public void addAnimation(Animation animation) {
        InvokeDynamicSupport.bootstrap("addAnimation", $$robo$$android_view_animation_AnimationSet$addAnimation(android.view.animation.Animation ), this, animation);
    }

    @Override
    public void setStartTime(long l) {
        InvokeDynamicSupport.bootstrap("setStartTime", $$robo$$android_view_animation_AnimationSet$setStartTime(long ), this, l);
    }

    @Override
    public long getStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getStartTime", $$robo$$android_view_animation_AnimationSet$getStartTime(), this);
    }

    @Override
    public void restrictDuration(long l) {
        InvokeDynamicSupport.bootstrap("restrictDuration", $$robo$$android_view_animation_AnimationSet$restrictDuration(long ), this, l);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_view_animation_AnimationSet$getDuration(), this);
    }

    @Override
    public long computeDurationHint() {
        return (long)InvokeDynamicSupport.bootstrap("computeDurationHint", $$robo$$android_view_animation_AnimationSet$computeDurationHint(), this);
    }

    @Override
    public void initializeInvalidateRegion(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("initializeInvalidateRegion", $$robo$$android_view_animation_AnimationSet$initializeInvalidateRegion(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public boolean getTransformation(long l, Transformation transformation) {
        return (boolean)InvokeDynamicSupport.bootstrap("getTransformation", $$robo$$android_view_animation_AnimationSet$getTransformation(long android.view.animation.Transformation ), this, l, transformation);
    }

    @Override
    public void scaleCurrentDuration(float f) {
        InvokeDynamicSupport.bootstrap("scaleCurrentDuration", $$robo$$android_view_animation_AnimationSet$scaleCurrentDuration(float ), this, f);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_animation_AnimationSet$initialize(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_view_animation_AnimationSet$reset(), this);
    }

    void restoreChildrenStartOffset() {
        InvokeDynamicSupport.bootstrap("restoreChildrenStartOffset", $$robo$$android_view_animation_AnimationSet$restoreChildrenStartOffset(), this);
    }

    public List<Animation> getAnimations() {
        return InvokeDynamicSupport.bootstrap("getAnimations", $$robo$$android_view_animation_AnimationSet$getAnimations(), this);
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return (boolean)InvokeDynamicSupport.bootstrap("willChangeTransformationMatrix", $$robo$$android_view_animation_AnimationSet$willChangeTransformationMatrix(), this);
    }

    @Override
    public boolean willChangeBounds() {
        return (boolean)InvokeDynamicSupport.bootstrap("willChangeBounds", $$robo$$android_view_animation_AnimationSet$willChangeBounds(), this);
    }

    public /* synthetic */ AnimationSet() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationSet)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

