/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pools;
import android.view.accessibility.AccessibilityRecord;
import com.android.internal.util.BitUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityEvent
extends AccessibilityRecord
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    public static boolean DEBUG_ORIGIN = false;
    public static int INVALID_POSITION = -1;
    @Deprecated
    public static int MAX_TEXT_LENGTH = 500;
    public static int TYPE_VIEW_CLICKED = 1;
    public static int TYPE_VIEW_LONG_CLICKED = 2;
    public static int TYPE_VIEW_SELECTED = 4;
    public static int TYPE_VIEW_FOCUSED = 8;
    public static int TYPE_VIEW_TEXT_CHANGED = 16;
    public static int TYPE_WINDOW_STATE_CHANGED = 32;
    public static int TYPE_NOTIFICATION_STATE_CHANGED = 64;
    public static int TYPE_VIEW_HOVER_ENTER = 128;
    public static int TYPE_VIEW_HOVER_EXIT = 256;
    public static int TYPE_TOUCH_EXPLORATION_GESTURE_START = 512;
    public static int TYPE_TOUCH_EXPLORATION_GESTURE_END = 1024;
    public static int TYPE_WINDOW_CONTENT_CHANGED = 2048;
    public static int TYPE_VIEW_SCROLLED = 4096;
    public static int TYPE_VIEW_TEXT_SELECTION_CHANGED = 8192;
    public static int TYPE_ANNOUNCEMENT = 16384;
    public static int TYPE_VIEW_ACCESSIBILITY_FOCUSED = 32768;
    public static int TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED = 65536;
    public static int TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY = 131072;
    public static int TYPE_GESTURE_DETECTION_START = 262144;
    public static int TYPE_GESTURE_DETECTION_END = 524288;
    public static int TYPE_TOUCH_INTERACTION_START = 0x100000;
    public static int TYPE_TOUCH_INTERACTION_END = 0x200000;
    public static int TYPE_WINDOWS_CHANGED = 0x400000;
    public static int TYPE_VIEW_CONTEXT_CLICKED = 0x800000;
    public static int TYPE_ASSIST_READING_CONTEXT = 0x1000000;
    public static int CONTENT_CHANGE_TYPE_UNDEFINED = 0;
    public static int CONTENT_CHANGE_TYPE_SUBTREE = 1;
    public static int CONTENT_CHANGE_TYPE_TEXT = 2;
    public static int CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION = 4;
    public static int CONTENT_CHANGE_TYPE_PANE_TITLE = 8;
    public static int CONTENT_CHANGE_TYPE_PANE_APPEARED = 16;
    public static int CONTENT_CHANGE_TYPE_PANE_DISAPPEARED = 32;
    public static int WINDOWS_CHANGE_ADDED = 1;
    public static int WINDOWS_CHANGE_REMOVED = 2;
    public static int WINDOWS_CHANGE_TITLE = 4;
    public static int WINDOWS_CHANGE_BOUNDS = 8;
    public static int WINDOWS_CHANGE_LAYER = 16;
    public static int WINDOWS_CHANGE_ACTIVE = 32;
    public static int WINDOWS_CHANGE_FOCUSED = 64;
    public static int WINDOWS_CHANGE_ACCESSIBILITY_FOCUSED = 128;
    public static int WINDOWS_CHANGE_PARENT = 256;
    public static int WINDOWS_CHANGE_CHILDREN = 512;
    public static int WINDOWS_CHANGE_PIP = 1024;
    public static int TYPES_ALL_MASK = -1;
    private static int MAX_POOL_SIZE = 10;
    private static Pools.SynchronizedPool<AccessibilityEvent> sPool;
    private int mEventType;
    private CharSequence mPackageName;
    private long mEventTime;
    int mMovementGranularity;
    int mAction;
    int mContentChangeTypes;
    int mWindowChangeTypes;
    public StackTraceElement[] originStackTrace;
    private ArrayList<AccessibilityRecord> mRecords;
    public static Parcelable.Creator<AccessibilityEvent> CREATOR;

    private void $$robo$$android_view_accessibility_AccessibilityEvent$__constructor__() {
        this.originStackTrace = null;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$init(AccessibilityEvent event) {
        super.init(event);
        this.mEventType = event.mEventType;
        this.mMovementGranularity = event.mMovementGranularity;
        this.mAction = event.mAction;
        this.mContentChangeTypes = event.mContentChangeTypes;
        this.mWindowChangeTypes = event.mWindowChangeTypes;
        this.mEventTime = event.mEventTime;
        this.mPackageName = event.mPackageName;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setSealed(boolean sealed) {
        super.setSealed(sealed);
        ArrayList<AccessibilityRecord> records = this.mRecords;
        if (records != null) {
            int recordCount = records.size();
            for (int i = 0; i < recordCount; ++i) {
                AccessibilityRecord record = (AccessibilityRecord)records.get(i);
                record.setSealed(sealed);
            }
        }
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$getRecordCount() {
        return this.mRecords == null ? 0 : this.mRecords.size();
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$appendRecord(AccessibilityRecord record) {
        this.enforceNotSealed();
        if (this.mRecords == null) {
            this.mRecords = new ArrayList();
        }
        this.mRecords.add(record);
    }

    private final AccessibilityRecord $$robo$$android_view_accessibility_AccessibilityEvent$getRecord(int index) {
        if (this.mRecords == null) {
            throw new IndexOutOfBoundsException("Invalid index " + index + ", size is 0");
        }
        return this.mRecords.get(index);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$getEventType() {
        return this.mEventType;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$getContentChangeTypes() {
        return this.mContentChangeTypes;
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityEvent$contentChangeTypesToString(int types) {
        return BitUtils.flagsToString(types, AccessibilityEvent::singleContentChangeTypeToString);
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityEvent$singleContentChangeTypeToString(int type) {
        switch (type) {
            case 4: {
                return "CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION";
            }
            case 1: {
                return "CONTENT_CHANGE_TYPE_SUBTREE";
            }
            case 2: {
                return "CONTENT_CHANGE_TYPE_TEXT";
            }
            case 8: {
                return "CONTENT_CHANGE_TYPE_PANE_TITLE";
            }
            case 0: {
                return "CONTENT_CHANGE_TYPE_UNDEFINED";
            }
        }
        return Integer.toHexString(type);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setContentChangeTypes(int changeTypes) {
        this.enforceNotSealed();
        this.mContentChangeTypes = changeTypes;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$getWindowChanges() {
        return this.mWindowChangeTypes;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setWindowChanges(int changes) {
        this.mWindowChangeTypes = changes;
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityEvent$windowChangeTypesToString(int types) {
        return BitUtils.flagsToString(types, AccessibilityEvent::singleWindowChangeTypeToString);
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityEvent$singleWindowChangeTypeToString(int type) {
        switch (type) {
            case 1: {
                return "WINDOWS_CHANGE_ADDED";
            }
            case 2: {
                return "WINDOWS_CHANGE_REMOVED";
            }
            case 4: {
                return "WINDOWS_CHANGE_TITLE";
            }
            case 8: {
                return "WINDOWS_CHANGE_BOUNDS";
            }
            case 16: {
                return "WINDOWS_CHANGE_LAYER";
            }
            case 32: {
                return "WINDOWS_CHANGE_ACTIVE";
            }
            case 64: {
                return "WINDOWS_CHANGE_FOCUSED";
            }
            case 128: {
                return "WINDOWS_CHANGE_ACCESSIBILITY_FOCUSED";
            }
            case 256: {
                return "WINDOWS_CHANGE_PARENT";
            }
            case 512: {
                return "WINDOWS_CHANGE_CHILDREN";
            }
        }
        return Integer.toHexString(type);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setEventType(int eventType) {
        this.enforceNotSealed();
        this.mEventType = eventType;
    }

    private final long $$robo$$android_view_accessibility_AccessibilityEvent$getEventTime() {
        return this.mEventTime;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setEventTime(long eventTime) {
        this.enforceNotSealed();
        this.mEventTime = eventTime;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityEvent$getPackageName() {
        return this.mPackageName;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setMovementGranularity(int granularity) {
        this.enforceNotSealed();
        this.mMovementGranularity = granularity;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$getMovementGranularity() {
        return this.mMovementGranularity;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$setAction(int action) {
        this.enforceNotSealed();
        this.mAction = action;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$getAction() {
        return this.mAction;
    }

    private static final AccessibilityEvent $$robo$$android_view_accessibility_AccessibilityEvent$obtainWindowsChangedEvent(int windowId, int windowChangeTypes) {
        AccessibilityEvent event = AccessibilityEvent.obtain(0x400000);
        event.setWindowId(windowId);
        event.setWindowChanges(windowChangeTypes);
        event.setImportantForAccessibility(true);
        return event;
    }

    private static final AccessibilityEvent $$robo$$android_view_accessibility_AccessibilityEvent$obtain(int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain();
        event.setEventType(eventType);
        return event;
    }

    private static final AccessibilityEvent $$robo$$android_view_accessibility_AccessibilityEvent$obtain(AccessibilityEvent event) {
        AccessibilityEvent eventClone = AccessibilityEvent.obtain();
        eventClone.init(event);
        if (event.mRecords != null) {
            int recordCount = event.mRecords.size();
            eventClone.mRecords = new ArrayList(recordCount);
            for (int i = 0; i < recordCount; ++i) {
                AccessibilityRecord record = event.mRecords.get(i);
                AccessibilityRecord recordClone = AccessibilityRecord.obtain(record);
                eventClone.mRecords.add(recordClone);
            }
        }
        return eventClone;
    }

    private static final AccessibilityEvent $$robo$$android_view_accessibility_AccessibilityEvent$obtain() {
        AccessibilityEvent event = sPool.acquire();
        if (event == null) {
            event = new AccessibilityEvent();
        }
        return event;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$recycle() {
        this.clear();
        sPool.release(this);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$clear() {
        super.clear();
        this.mEventType = 0;
        this.mMovementGranularity = 0;
        this.mAction = 0;
        this.mContentChangeTypes = 0;
        this.mWindowChangeTypes = 0;
        this.mPackageName = null;
        this.mEventTime = 0L;
        if (this.mRecords != null) {
            while (!this.mRecords.isEmpty()) {
                AccessibilityRecord record = this.mRecords.remove(0);
                record.recycle();
            }
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$initFromParcel(Parcel parcel) {
        this.mSealed = parcel.readInt() == 1;
        this.mEventType = parcel.readInt();
        this.mMovementGranularity = parcel.readInt();
        this.mAction = parcel.readInt();
        this.mContentChangeTypes = parcel.readInt();
        this.mWindowChangeTypes = parcel.readInt();
        this.mPackageName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mEventTime = parcel.readLong();
        this.mConnectionId = parcel.readInt();
        this.readAccessibilityRecordFromParcel(this, parcel);
        int recordCount = parcel.readInt();
        if (recordCount > 0) {
            this.mRecords = new ArrayList(recordCount);
            for (int i = 0; i < recordCount; ++i) {
                AccessibilityRecord record = AccessibilityRecord.obtain();
                this.readAccessibilityRecordFromParcel(record, parcel);
                record.mConnectionId = this.mConnectionId;
                this.mRecords.add(record);
            }
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$readAccessibilityRecordFromParcel(AccessibilityRecord record, Parcel parcel) {
        record.mBooleanProperties = parcel.readInt();
        record.mCurrentItemIndex = parcel.readInt();
        record.mItemCount = parcel.readInt();
        record.mFromIndex = parcel.readInt();
        record.mToIndex = parcel.readInt();
        record.mScrollX = parcel.readInt();
        record.mScrollY = parcel.readInt();
        record.mScrollDeltaX = parcel.readInt();
        record.mScrollDeltaY = parcel.readInt();
        record.mMaxScrollX = parcel.readInt();
        record.mMaxScrollY = parcel.readInt();
        record.mAddedCount = parcel.readInt();
        record.mRemovedCount = parcel.readInt();
        record.mClassName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        record.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        record.mBeforeText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        record.mParcelableData = parcel.readParcelable(null);
        parcel.readList(record.mText, null);
        record.mSourceWindowId = parcel.readInt();
        record.mSourceNodeId = parcel.readLong();
        record.mSealed = parcel.readInt() == 1;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.isSealed() ? 1 : 0);
        parcel.writeInt(this.mEventType);
        parcel.writeInt(this.mMovementGranularity);
        parcel.writeInt(this.mAction);
        parcel.writeInt(this.mContentChangeTypes);
        parcel.writeInt(this.mWindowChangeTypes);
        TextUtils.writeToParcel(this.mPackageName, parcel, 0);
        parcel.writeLong(this.mEventTime);
        parcel.writeInt(this.mConnectionId);
        this.writeAccessibilityRecordToParcel(this, parcel, flags);
        int recordCount = this.getRecordCount();
        parcel.writeInt(recordCount);
        for (int i = 0; i < recordCount; ++i) {
            AccessibilityRecord record = this.mRecords.get(i);
            this.writeAccessibilityRecordToParcel(record, parcel, flags);
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityEvent$writeAccessibilityRecordToParcel(AccessibilityRecord record, Parcel parcel, int flags) {
        parcel.writeInt(record.mBooleanProperties);
        parcel.writeInt(record.mCurrentItemIndex);
        parcel.writeInt(record.mItemCount);
        parcel.writeInt(record.mFromIndex);
        parcel.writeInt(record.mToIndex);
        parcel.writeInt(record.mScrollX);
        parcel.writeInt(record.mScrollY);
        parcel.writeInt(record.mScrollDeltaX);
        parcel.writeInt(record.mScrollDeltaY);
        parcel.writeInt(record.mMaxScrollX);
        parcel.writeInt(record.mMaxScrollY);
        parcel.writeInt(record.mAddedCount);
        parcel.writeInt(record.mRemovedCount);
        TextUtils.writeToParcel(record.mClassName, parcel, flags);
        TextUtils.writeToParcel(record.mContentDescription, parcel, flags);
        TextUtils.writeToParcel(record.mBeforeText, parcel, flags);
        parcel.writeParcelable(record.mParcelableData, flags);
        parcel.writeList(record.mText);
        parcel.writeInt(record.mSourceWindowId);
        parcel.writeLong(record.mSourceNodeId);
        parcel.writeInt(record.mSealed ? 1 : 0);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityEvent$describeContents() {
        return 0;
    }

    private final String $$robo$$android_view_accessibility_AccessibilityEvent$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EventType: ").append(AccessibilityEvent.eventTypeToString(this.mEventType));
        builder.append("; EventTime: ").append(this.mEventTime);
        builder.append("; PackageName: ").append(this.mPackageName);
        builder.append("; MovementGranularity: ").append(this.mMovementGranularity);
        builder.append("; Action: ").append(this.mAction);
        builder.append("; ContentChangeTypes: ").append(AccessibilityEvent.contentChangeTypesToString(this.mContentChangeTypes));
        builder.append("; WindowChangeTypes: ").append(AccessibilityEvent.windowChangeTypesToString(this.mWindowChangeTypes));
        super.appendTo(builder);
        builder.append("; recordCount: ").append(this.getRecordCount());
        return builder.toString();
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityEvent$eventTypeToString(int eventType) {
        if (eventType == -1) {
            return "TYPES_ALL_MASK";
        }
        StringBuilder builder = new StringBuilder();
        int eventTypeCount = 0;
        while (eventType != 0) {
            int eventTypeFlag = 1 << Integer.numberOfTrailingZeros(eventType);
            eventType &= ~eventTypeFlag;
            if (eventTypeCount > 0) {
                builder.append(", ");
            }
            builder.append(AccessibilityEvent.singleEventTypeToString(eventTypeFlag));
            ++eventTypeCount;
        }
        if (eventTypeCount > 1) {
            builder.insert(0, '[');
            builder.append(']');
        }
        return builder.toString();
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityEvent$singleEventTypeToString(int eventType) {
        switch (eventType) {
            case 1: {
                return "TYPE_VIEW_CLICKED";
            }
            case 2: {
                return "TYPE_VIEW_LONG_CLICKED";
            }
            case 4: {
                return "TYPE_VIEW_SELECTED";
            }
            case 8: {
                return "TYPE_VIEW_FOCUSED";
            }
            case 16: {
                return "TYPE_VIEW_TEXT_CHANGED";
            }
            case 32: {
                return "TYPE_WINDOW_STATE_CHANGED";
            }
            case 128: {
                return "TYPE_VIEW_HOVER_ENTER";
            }
            case 256: {
                return "TYPE_VIEW_HOVER_EXIT";
            }
            case 64: {
                return "TYPE_NOTIFICATION_STATE_CHANGED";
            }
            case 512: {
                return "TYPE_TOUCH_EXPLORATION_GESTURE_START";
            }
            case 1024: {
                return "TYPE_TOUCH_EXPLORATION_GESTURE_END";
            }
            case 2048: {
                return "TYPE_WINDOW_CONTENT_CHANGED";
            }
            case 8192: {
                return "TYPE_VIEW_TEXT_SELECTION_CHANGED";
            }
            case 4096: {
                return "TYPE_VIEW_SCROLLED";
            }
            case 16384: {
                return "TYPE_ANNOUNCEMENT";
            }
            case 32768: {
                return "TYPE_VIEW_ACCESSIBILITY_FOCUSED";
            }
            case 65536: {
                return "TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED";
            }
            case 131072: {
                return "TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY";
            }
            case 262144: {
                return "TYPE_GESTURE_DETECTION_START";
            }
            case 524288: {
                return "TYPE_GESTURE_DETECTION_END";
            }
            case 0x100000: {
                return "TYPE_TOUCH_INTERACTION_START";
            }
            case 0x200000: {
                return "TYPE_TOUCH_INTERACTION_END";
            }
            case 0x400000: {
                return "TYPE_WINDOWS_CHANGED";
            }
            case 0x800000: {
                return "TYPE_VIEW_CONTEXT_CLICKED";
            }
            case 0x1000000: {
                return "TYPE_ASSIST_READING_CONTEXT";
            }
        }
        return Integer.toHexString(eventType);
    }

    static void __staticInitializer__() {
        sPool = new Pools.SynchronizedPool(10);
        CREATOR = new Parcelable.Creator<AccessibilityEvent>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_accessibility_AccessibilityEvent_1$__constructor__() {
            }

            private final AccessibilityEvent $$robo$$android_view_accessibility_AccessibilityEvent_1$createFromParcel(Parcel parcel) {
                AccessibilityEvent event = AccessibilityEvent.obtain();
                event.initFromParcel(parcel);
                return event;
            }

            private final AccessibilityEvent[] $$robo$$android_view_accessibility_AccessibilityEvent_1$newArray(int size) {
                return new AccessibilityEvent[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_accessibility_AccessibilityEvent_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityEvent_1$__constructor__(), this);
            }

            @Override
            public AccessibilityEvent createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_accessibility_AccessibilityEvent_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public AccessibilityEvent[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_accessibility_AccessibilityEvent_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_view_accessibility_AccessibilityEvent$__constructor__();
    }

    public AccessibilityEvent() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityEvent$__constructor__(), this);
    }

    void init(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_accessibility_AccessibilityEvent$init(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public void setSealed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSealed", $$robo$$android_view_accessibility_AccessibilityEvent$setSealed(boolean ), this, bl);
    }

    public int getRecordCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRecordCount", $$robo$$android_view_accessibility_AccessibilityEvent$getRecordCount(), this);
    }

    public void appendRecord(AccessibilityRecord accessibilityRecord) {
        InvokeDynamicSupport.bootstrap("appendRecord", $$robo$$android_view_accessibility_AccessibilityEvent$appendRecord(android.view.accessibility.AccessibilityRecord ), this, accessibilityRecord);
    }

    public AccessibilityRecord getRecord(int n) {
        return InvokeDynamicSupport.bootstrap("getRecord", $$robo$$android_view_accessibility_AccessibilityEvent$getRecord(int ), this, n);
    }

    public int getEventType() {
        return (int)InvokeDynamicSupport.bootstrap("getEventType", $$robo$$android_view_accessibility_AccessibilityEvent$getEventType(), this);
    }

    public int getContentChangeTypes() {
        return (int)InvokeDynamicSupport.bootstrap("getContentChangeTypes", $$robo$$android_view_accessibility_AccessibilityEvent$getContentChangeTypes(), this);
    }

    private static String contentChangeTypesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("contentChangeTypesToString", $$robo$$android_view_accessibility_AccessibilityEvent$contentChangeTypesToString(int ), (int)n);
    }

    private static String singleContentChangeTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("singleContentChangeTypeToString", $$robo$$android_view_accessibility_AccessibilityEvent$singleContentChangeTypeToString(int ), (int)n);
    }

    public void setContentChangeTypes(int n) {
        InvokeDynamicSupport.bootstrap("setContentChangeTypes", $$robo$$android_view_accessibility_AccessibilityEvent$setContentChangeTypes(int ), this, n);
    }

    public int getWindowChanges() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowChanges", $$robo$$android_view_accessibility_AccessibilityEvent$getWindowChanges(), this);
    }

    public void setWindowChanges(int n) {
        InvokeDynamicSupport.bootstrap("setWindowChanges", $$robo$$android_view_accessibility_AccessibilityEvent$setWindowChanges(int ), this, n);
    }

    private static String windowChangeTypesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("windowChangeTypesToString", $$robo$$android_view_accessibility_AccessibilityEvent$windowChangeTypesToString(int ), (int)n);
    }

    private static String singleWindowChangeTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("singleWindowChangeTypeToString", $$robo$$android_view_accessibility_AccessibilityEvent$singleWindowChangeTypeToString(int ), (int)n);
    }

    public void setEventType(int n) {
        InvokeDynamicSupport.bootstrap("setEventType", $$robo$$android_view_accessibility_AccessibilityEvent$setEventType(int ), this, n);
    }

    public long getEventTime() {
        return (long)InvokeDynamicSupport.bootstrap("getEventTime", $$robo$$android_view_accessibility_AccessibilityEvent$getEventTime(), this);
    }

    public void setEventTime(long l) {
        InvokeDynamicSupport.bootstrap("setEventTime", $$robo$$android_view_accessibility_AccessibilityEvent$setEventTime(long ), this, l);
    }

    public CharSequence getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_view_accessibility_AccessibilityEvent$getPackageName(), this);
    }

    public void setPackageName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_view_accessibility_AccessibilityEvent$setPackageName(java.lang.CharSequence ), this, charSequence);
    }

    public void setMovementGranularity(int n) {
        InvokeDynamicSupport.bootstrap("setMovementGranularity", $$robo$$android_view_accessibility_AccessibilityEvent$setMovementGranularity(int ), this, n);
    }

    public int getMovementGranularity() {
        return (int)InvokeDynamicSupport.bootstrap("getMovementGranularity", $$robo$$android_view_accessibility_AccessibilityEvent$getMovementGranularity(), this);
    }

    public void setAction(int n) {
        InvokeDynamicSupport.bootstrap("setAction", $$robo$$android_view_accessibility_AccessibilityEvent$setAction(int ), this, n);
    }

    public int getAction() {
        return (int)InvokeDynamicSupport.bootstrap("getAction", $$robo$$android_view_accessibility_AccessibilityEvent$getAction(), this);
    }

    public static AccessibilityEvent obtainWindowsChangedEvent(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("obtainWindowsChangedEvent", $$robo$$android_view_accessibility_AccessibilityEvent$obtainWindowsChangedEvent(int int ), (int)n, (int)n2);
    }

    public static AccessibilityEvent obtain(int n) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityEvent$obtain(int ), (int)n);
    }

    public static AccessibilityEvent obtain(AccessibilityEvent accessibilityEvent) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityEvent$obtain(android.view.accessibility.AccessibilityEvent ), (AccessibilityEvent)accessibilityEvent);
    }

    public static AccessibilityEvent obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityEvent$obtain());
    }

    @Override
    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityEvent$recycle(), this);
    }

    @Override
    protected void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityEvent$clear(), this);
    }

    public void initFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("initFromParcel", $$robo$$android_view_accessibility_AccessibilityEvent$initFromParcel(android.os.Parcel ), this, parcel);
    }

    private void readAccessibilityRecordFromParcel(AccessibilityRecord accessibilityRecord, Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readAccessibilityRecordFromParcel", $$robo$$android_view_accessibility_AccessibilityEvent$readAccessibilityRecordFromParcel(android.view.accessibility.AccessibilityRecord android.os.Parcel ), this, accessibilityRecord, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_accessibility_AccessibilityEvent$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void writeAccessibilityRecordToParcel(AccessibilityRecord accessibilityRecord, Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeAccessibilityRecordToParcel", $$robo$$android_view_accessibility_AccessibilityEvent$writeAccessibilityRecordToParcel(android.view.accessibility.AccessibilityRecord android.os.Parcel int ), this, accessibilityRecord, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_accessibility_AccessibilityEvent$describeContents(), this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_accessibility_AccessibilityEvent$toString(), this);
    }

    public static String eventTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("eventTypeToString", $$robo$$android_view_accessibility_AccessibilityEvent$eventTypeToString(int ), (int)n);
    }

    private static String singleEventTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("singleEventTypeToString", $$robo$$android_view_accessibility_AccessibilityEvent$singleEventTypeToString(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityEvent.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityEvent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentChangeTypes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WindowsChangeTypes {
    }
}

