/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.ActionProvider;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import com.android.internal.R;
import com.android.internal.view.menu.MenuItemImpl;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MenuInflater
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "MenuInflater";
    private static String XML_MENU = "menu";
    private static String XML_GROUP = "group";
    private static String XML_ITEM = "item";
    private static int NO_ID = 0;
    private static Class<?>[] ACTION_VIEW_CONSTRUCTOR_SIGNATURE;
    private static Class<?>[] ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE;
    private Object[] mActionViewConstructorArguments;
    private Object[] mActionProviderConstructorArguments;
    private Context mContext;
    private Object mRealOwner;

    private void $$robo$$android_view_MenuInflater$__constructor__(Context context) {
        this.mContext = context;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mActionProviderConstructorArguments = this.mActionViewConstructorArguments;
    }

    private void $$robo$$android_view_MenuInflater$__constructor__(Context context, Object realOwner) {
        this.mContext = context;
        this.mRealOwner = realOwner;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mActionProviderConstructorArguments = this.mActionViewConstructorArguments;
    }

    private final void $$robo$$android_view_MenuInflater$inflate(int menuRes, Menu menu2) {
        try (XmlResourceParser parser = null;){
            parser = this.mContext.getResources().getLayout(menuRes);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            this.parseMenu(parser, attrs, menu2);
        }
    }

    private final void $$robo$$android_view_MenuInflater$parseMenu(XmlPullParser parser, AttributeSet attrs, Menu menu2) throws XmlPullParserException, IOException {
        String tagName;
        MenuState menuState = new MenuState(this, menu2);
        int eventType = parser.getEventType();
        boolean lookingForEndOfUnknownTag = false;
        String unknownTagName = null;
        do {
            if (eventType != 2) continue;
            tagName = parser.getName();
            if (tagName.equals("menu")) {
                eventType = parser.next();
                break;
            }
            throw new RuntimeException("Expecting menu, got " + tagName);
        } while ((eventType = parser.next()) != 1);
        boolean reachedEndOfMenu = false;
        while (!reachedEndOfMenu) {
            switch (eventType) {
                case 2: {
                    if (lookingForEndOfUnknownTag) break;
                    tagName = parser.getName();
                    if (tagName.equals("group")) {
                        menuState.readGroup(attrs);
                        break;
                    }
                    if (tagName.equals("item")) {
                        menuState.readItem(attrs);
                        break;
                    }
                    if (tagName.equals("menu")) {
                        SubMenu subMenu = menuState.addSubMenuItem();
                        this.registerMenu(subMenu, attrs);
                        this.parseMenu(parser, attrs, subMenu);
                        break;
                    }
                    lookingForEndOfUnknownTag = true;
                    unknownTagName = tagName;
                    break;
                }
                case 3: {
                    tagName = parser.getName();
                    if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                        lookingForEndOfUnknownTag = false;
                        unknownTagName = null;
                        break;
                    }
                    if (tagName.equals("group")) {
                        menuState.resetGroup();
                        break;
                    }
                    if (tagName.equals("item")) {
                        if (menuState.hasAddedItem()) break;
                        if (menuState.itemActionProvider != null && menuState.itemActionProvider.hasSubMenu()) {
                            this.registerMenu(menuState.addSubMenuItem(), attrs);
                            break;
                        }
                        this.registerMenu(menuState.addItem(), attrs);
                        break;
                    }
                    if (!tagName.equals("menu")) break;
                    reachedEndOfMenu = true;
                    break;
                }
                case 1: {
                    throw new RuntimeException("Unexpected end of document");
                }
            }
            eventType = parser.next();
        }
    }

    private final void $$robo$$android_view_MenuInflater$registerMenu(MenuItem item, AttributeSet set) {
    }

    private final void $$robo$$android_view_MenuInflater$registerMenu(SubMenu subMenu, AttributeSet set) {
    }

    private final Context $$robo$$android_view_MenuInflater$getContext() {
        return this.mContext;
    }

    private final Object $$robo$$android_view_MenuInflater$getRealOwner() {
        if (this.mRealOwner == null) {
            this.mRealOwner = this.findRealOwner(this.mContext);
        }
        return this.mRealOwner;
    }

    private final Object $$robo$$android_view_MenuInflater$findRealOwner(Object owner) {
        if (owner instanceof Activity) {
            return owner;
        }
        if (owner instanceof ContextWrapper) {
            return this.findRealOwner(((ContextWrapper)owner).getBaseContext());
        }
        return owner;
    }

    static void __staticInitializer__() {
        ACTION_VIEW_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};
        ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE = ACTION_VIEW_CONSTRUCTOR_SIGNATURE;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_MenuInflater$__constructor__(context);
    }

    public MenuInflater(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MenuInflater$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, Object object) {
        this.$$robo$$android_view_MenuInflater$__constructor__(context, object);
    }

    public MenuInflater(Context context, Object object) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MenuInflater$__constructor__(android.content.Context java.lang.Object ), this, context, object);
    }

    public void inflate(int n, Menu menu2) {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_view_MenuInflater$inflate(int android.view.Menu ), this, n, menu2);
    }

    private void parseMenu(XmlPullParser xmlPullParser, AttributeSet attributeSet, Menu menu2) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("parseMenu", $$robo$$android_view_MenuInflater$parseMenu(org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.view.Menu ), this, xmlPullParser, attributeSet, menu2);
    }

    private void registerMenu(MenuItem menuItem, AttributeSet attributeSet) {
        InvokeDynamicSupport.bootstrap("registerMenu", $$robo$$android_view_MenuInflater$registerMenu(android.view.MenuItem android.util.AttributeSet ), this, menuItem, attributeSet);
    }

    private void registerMenu(SubMenu subMenu, AttributeSet attributeSet) {
        InvokeDynamicSupport.bootstrap("registerMenu", $$robo$$android_view_MenuInflater$registerMenu(android.view.SubMenu android.util.AttributeSet ), this, subMenu, attributeSet);
    }

    Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_view_MenuInflater$getContext(), this);
    }

    private Object getRealOwner() {
        return InvokeDynamicSupport.bootstrap("getRealOwner", $$robo$$android_view_MenuInflater$getRealOwner(), this);
    }

    private Object findRealOwner(Object object) {
        return InvokeDynamicSupport.bootstrap("findRealOwner", $$robo$$android_view_MenuInflater$findRealOwner(java.lang.Object ), this, object);
    }

    static {
        RobolectricInternals.classInitializing(MenuInflater.class);
    }

    public /* synthetic */ MenuInflater() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuInflater)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MenuState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Menu menu;
        private int groupId;
        private int groupCategory;
        private int groupOrder;
        private int groupCheckable;
        private boolean groupVisible;
        private boolean groupEnabled;
        private boolean itemAdded;
        private int itemId;
        private int itemCategoryOrder;
        private CharSequence itemTitle;
        private CharSequence itemTitleCondensed;
        private int itemIconResId;
        private ColorStateList itemIconTintList;
        private PorterDuff.Mode itemIconTintMode;
        private char itemAlphabeticShortcut;
        private int itemAlphabeticModifiers;
        private char itemNumericShortcut;
        private int itemNumericModifiers;
        private int itemCheckable;
        private boolean itemChecked;
        private boolean itemVisible;
        private boolean itemEnabled;
        private int itemShowAsAction;
        private int itemActionViewLayout;
        private String itemActionViewClassName;
        private String itemActionProviderClassName;
        private String itemListenerMethodName;
        private ActionProvider itemActionProvider;
        private CharSequence itemContentDescription;
        private CharSequence itemTooltipText;
        private static int defaultGroupId = 0;
        private static int defaultItemId = 0;
        private static int defaultItemCategory = 0;
        private static int defaultItemOrder = 0;
        private static int defaultItemCheckable = 0;
        private static boolean defaultItemChecked = false;
        private static boolean defaultItemVisible = true;
        private static boolean defaultItemEnabled = true;
        /* synthetic */ MenuInflater this$0;

        private void $$robo$$android_view_MenuInflater_MenuState$__constructor__(MenuInflater menuInflater, Menu menu2) {
            this.this$0 = menuInflater;
            this.itemIconTintList = null;
            this.itemIconTintMode = null;
            this.menu = menu2;
            this.resetGroup();
        }

        private final void $$robo$$android_view_MenuInflater_MenuState$resetGroup() {
            this.groupId = 0;
            this.groupCategory = 0;
            this.groupOrder = 0;
            this.groupCheckable = 0;
            this.groupVisible = true;
            this.groupEnabled = true;
        }

        private final void $$robo$$android_view_MenuInflater_MenuState$readGroup(AttributeSet attrs) {
            TypedArray a = this.this$0.mContext.obtainStyledAttributes(attrs, R.styleable.MenuGroup);
            this.groupId = a.getResourceId(1, 0);
            this.groupCategory = a.getInt(3, 0);
            this.groupOrder = a.getInt(4, 0);
            this.groupCheckable = a.getInt(5, 0);
            this.groupVisible = a.getBoolean(2, true);
            this.groupEnabled = a.getBoolean(0, true);
            a.recycle();
        }

        private final void $$robo$$android_view_MenuInflater_MenuState$readItem(AttributeSet attrs) {
            boolean hasActionProvider;
            TypedArray a = this.this$0.mContext.obtainStyledAttributes(attrs, R.styleable.MenuItem);
            this.itemId = a.getResourceId(2, 0);
            int category = a.getInt(5, this.groupCategory);
            int order = a.getInt(6, this.groupOrder);
            this.itemCategoryOrder = category & 0xFFFF0000 | order & 0xFFFF;
            this.itemTitle = a.getText(7);
            this.itemTitleCondensed = a.getText(8);
            this.itemIconResId = a.getResourceId(0, 0);
            this.itemIconTintMode = a.hasValue(22) ? Drawable.parseTintMode(a.getInt(22, -1), this.itemIconTintMode) : null;
            this.itemIconTintList = a.hasValue(21) ? a.getColorStateList(21) : null;
            this.itemAlphabeticShortcut = this.getShortcut(a.getString(9));
            this.itemAlphabeticModifiers = a.getInt(19, 4096);
            this.itemNumericShortcut = this.getShortcut(a.getString(10));
            this.itemNumericModifiers = a.getInt(20, 4096);
            this.itemCheckable = a.hasValue(11) ? (a.getBoolean(11, false) ? 1 : 0) : this.groupCheckable;
            this.itemChecked = a.getBoolean(3, false);
            this.itemVisible = a.getBoolean(4, this.groupVisible);
            this.itemEnabled = a.getBoolean(1, this.groupEnabled);
            this.itemShowAsAction = a.getInt(14, -1);
            this.itemListenerMethodName = a.getString(12);
            this.itemActionViewLayout = a.getResourceId(15, 0);
            this.itemActionViewClassName = a.getString(16);
            this.itemActionProviderClassName = a.getString(17);
            boolean bl = hasActionProvider = this.itemActionProviderClassName != null;
            if (hasActionProvider && this.itemActionViewLayout == 0 && this.itemActionViewClassName == null) {
                this.itemActionProvider = (ActionProvider)this.newInstance(this.itemActionProviderClassName, ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE, this.this$0.mActionProviderConstructorArguments);
            } else {
                if (hasActionProvider) {
                    Log.w("MenuInflater", "Ignoring attribute 'actionProviderClass'. Action view already specified.");
                }
                this.itemActionProvider = null;
            }
            this.itemContentDescription = a.getText(13);
            this.itemTooltipText = a.getText(18);
            a.recycle();
            this.itemAdded = false;
        }

        private final char $$robo$$android_view_MenuInflater_MenuState$getShortcut(String shortcutString) {
            if (shortcutString == null) {
                return '\u0000';
            }
            return shortcutString.charAt(0);
        }

        private final void $$robo$$android_view_MenuInflater_MenuState$setItem(MenuItem item) {
            item.setChecked(this.itemChecked).setVisible(this.itemVisible).setEnabled(this.itemEnabled).setCheckable(this.itemCheckable >= 1).setTitleCondensed(this.itemTitleCondensed).setIcon(this.itemIconResId).setAlphabeticShortcut(this.itemAlphabeticShortcut, this.itemAlphabeticModifiers).setNumericShortcut(this.itemNumericShortcut, this.itemNumericModifiers);
            if (this.itemShowAsAction >= 0) {
                item.setShowAsAction(this.itemShowAsAction);
            }
            if (this.itemIconTintMode != null) {
                item.setIconTintMode(this.itemIconTintMode);
            }
            if (this.itemIconTintList != null) {
                item.setIconTintList(this.itemIconTintList);
            }
            if (this.itemListenerMethodName != null) {
                if (this.this$0.mContext.isRestricted()) {
                    throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                }
                item.setOnMenuItemClickListener(new InflatedOnMenuItemClickListener(this.this$0.getRealOwner(), this.itemListenerMethodName));
            }
            if (item instanceof MenuItemImpl) {
                MenuItemImpl impl = (MenuItemImpl)item;
                if (this.itemCheckable >= 2) {
                    impl.setExclusiveCheckable(true);
                }
            }
            boolean actionViewSpecified = false;
            if (this.itemActionViewClassName != null) {
                View actionView = (View)this.newInstance(this.itemActionViewClassName, ACTION_VIEW_CONSTRUCTOR_SIGNATURE, this.this$0.mActionViewConstructorArguments);
                item.setActionView(actionView);
                actionViewSpecified = true;
            }
            if (this.itemActionViewLayout > 0) {
                if (!actionViewSpecified) {
                    item.setActionView(this.itemActionViewLayout);
                    actionViewSpecified = true;
                } else {
                    Log.w("MenuInflater", "Ignoring attribute 'itemActionViewLayout'. Action view already specified.");
                }
            }
            if (this.itemActionProvider != null) {
                item.setActionProvider(this.itemActionProvider);
            }
            item.setContentDescription(this.itemContentDescription);
            item.setTooltipText(this.itemTooltipText);
        }

        private final MenuItem $$robo$$android_view_MenuInflater_MenuState$addItem() {
            this.itemAdded = true;
            MenuItem item = this.menu.add(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(item);
            return item;
        }

        private final SubMenu $$robo$$android_view_MenuInflater_MenuState$addSubMenuItem() {
            this.itemAdded = true;
            SubMenu subMenu = this.menu.addSubMenu(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(subMenu.getItem());
            return subMenu;
        }

        private final boolean $$robo$$android_view_MenuInflater_MenuState$hasAddedItem() {
            return this.itemAdded;
        }

        private final <T> T $$robo$$android_view_MenuInflater_MenuState$newInstance(String className, Class<?>[] constructorSignature, Object[] arguments) {
            try {
                Class<?> clazz = this.this$0.mContext.getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(constructorSignature);
                constructor.setAccessible(true);
                return (T)constructor.newInstance(arguments);
            }
            catch (Exception e) {
                Log.w("MenuInflater", "Cannot instantiate class: " + className, e);
                return null;
            }
        }

        private void __constructor__(MenuInflater menuInflater, Menu menu2) {
            this.$$robo$$android_view_MenuInflater_MenuState$__constructor__(menuInflater, menu2);
        }

        public MenuState(MenuInflater menuInflater, Menu menu2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MenuInflater_MenuState$__constructor__(android.view.MenuInflater android.view.Menu ), this, menuInflater, menu2);
        }

        public void resetGroup() {
            InvokeDynamicSupport.bootstrap("resetGroup", $$robo$$android_view_MenuInflater_MenuState$resetGroup(), this);
        }

        public void readGroup(AttributeSet attributeSet) {
            InvokeDynamicSupport.bootstrap("readGroup", $$robo$$android_view_MenuInflater_MenuState$readGroup(android.util.AttributeSet ), this, attributeSet);
        }

        public void readItem(AttributeSet attributeSet) {
            InvokeDynamicSupport.bootstrap("readItem", $$robo$$android_view_MenuInflater_MenuState$readItem(android.util.AttributeSet ), this, attributeSet);
        }

        private char getShortcut(String string2) {
            return (char)InvokeDynamicSupport.bootstrap("getShortcut", $$robo$$android_view_MenuInflater_MenuState$getShortcut(java.lang.String ), this, string2);
        }

        private void setItem(MenuItem menuItem) {
            InvokeDynamicSupport.bootstrap("setItem", $$robo$$android_view_MenuInflater_MenuState$setItem(android.view.MenuItem ), this, menuItem);
        }

        public MenuItem addItem() {
            return InvokeDynamicSupport.bootstrap("addItem", $$robo$$android_view_MenuInflater_MenuState$addItem(), this);
        }

        public SubMenu addSubMenuItem() {
            return InvokeDynamicSupport.bootstrap("addSubMenuItem", $$robo$$android_view_MenuInflater_MenuState$addSubMenuItem(), this);
        }

        public boolean hasAddedItem() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasAddedItem", $$robo$$android_view_MenuInflater_MenuState$hasAddedItem(), this);
        }

        private <T> T newInstance(String string2, Class<?>[] classArray, Object[] objectArray) {
            return (T)InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_view_MenuInflater_MenuState$newInstance(java.lang.String java.lang.Class<?>[] java.lang.Object[] ), this, string2, classArray, objectArray);
        }

        public /* synthetic */ MenuState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InflatedOnMenuItemClickListener
    implements MenuItem.OnMenuItemClickListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static Class<?>[] PARAM_TYPES;
        private Object mRealOwner;
        private Method mMethod;

        private void $$robo$$android_view_MenuInflater_InflatedOnMenuItemClickListener$__constructor__(Object realOwner, String methodName) {
            this.mRealOwner = realOwner;
            Class<?> c = realOwner.getClass();
            try {
                this.mMethod = c.getMethod(methodName, PARAM_TYPES);
            }
            catch (Exception e) {
                InflateException ex = new InflateException("Couldn't resolve menu item onClick handler " + methodName + " in class " + c.getName());
                ex.initCause(e);
                throw ex;
            }
        }

        private final boolean $$robo$$android_view_MenuInflater_InflatedOnMenuItemClickListener$onMenuItemClick(MenuItem item) {
            try {
                if (this.mMethod.getReturnType() == Boolean.TYPE) {
                    return (Boolean)this.mMethod.invoke(this.mRealOwner, item);
                }
                this.mMethod.invoke(this.mRealOwner, item);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static void __staticInitializer__() {
            PARAM_TYPES = new Class[]{MenuItem.class};
        }

        private void __constructor__(Object object, String string2) {
            this.$$robo$$android_view_MenuInflater_InflatedOnMenuItemClickListener$__constructor__(object, string2);
        }

        public InflatedOnMenuItemClickListener(Object object, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MenuInflater_InflatedOnMenuItemClickListener$__constructor__(java.lang.Object java.lang.String ), this, object, string2);
        }

        @Override
        public boolean onMenuItemClick(MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemClick", $$robo$$android_view_MenuInflater_InflatedOnMenuItemClickListener$onMenuItemClick(android.view.MenuItem ), this, menuItem);
        }

        static {
            RobolectricInternals.classInitializing(InflatedOnMenuItemClickListener.class);
        }

        public /* synthetic */ InflatedOnMenuItemClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InflatedOnMenuItemClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

