/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.os.Build;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.apk.ApkSigningBlockUtils;
import android.util.apk.ApkVerityBuilder;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureInfo;
import android.util.apk.SignatureNotFoundException;
import android.util.apk.VerbatimX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApkSignatureSchemeV3Verifier
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int SF_ATTRIBUTE_ANDROID_APK_SIGNED_ID = 3;
    private static int APK_SIGNATURE_SCHEME_V3_BLOCK_ID = -262969152;
    private static int PROOF_OF_ROTATION_ATTR_ID = 1000370060;

    private void $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$__constructor__() {
    }

    private static final boolean $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$hasSignature(String apkFile) throws IOException {
        boolean bl;
        RandomAccessFile apk = new RandomAccessFile(apkFile, "r");
        Throwable throwable = null;
        try {
            ApkSignatureSchemeV3Verifier.findSignature(apk);
            bl = true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    ApkSignatureSchemeV3Verifier.$closeResource(throwable, apk);
                    throw throwable3;
                }
            }
            catch (SignatureNotFoundException e) {
                return false;
            }
        }
        ApkSignatureSchemeV3Verifier.$closeResource(throwable, apk);
        return bl;
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        return ApkSignatureSchemeV3Verifier.verify(apkFile, true);
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$plsCertsNoVerifyOnlyCerts(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        return ApkSignatureSchemeV3Verifier.verify(apkFile, false);
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(String apkFile, boolean verifyIntegrity) throws SignatureNotFoundException, SecurityException, IOException {
        try (RandomAccessFile apk = new RandomAccessFile(apkFile, "r");){
            VerifiedSigner verifiedSigner = ApkSignatureSchemeV3Verifier.verify(apk, verifyIntegrity);
            return verifiedSigner;
        }
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(RandomAccessFile apk, boolean verifyIntegrity) throws SignatureNotFoundException, SecurityException, IOException {
        SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk);
        return ApkSignatureSchemeV3Verifier.verify(apk, signatureInfo, verifyIntegrity);
    }

    private static final SignatureInfo $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$findSignature(RandomAccessFile apk) throws IOException, SignatureNotFoundException {
        return ApkSigningBlockUtils.findSignature(apk, -262969152);
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(RandomAccessFile apk, SignatureInfo signatureInfo, boolean doVerifyIntegrity) throws SecurityException, IOException {
        ByteBuffer signers;
        CertificateFactory certFactory;
        int signerCount = 0;
        ArrayMap<Integer, byte[]> contentDigests = new ArrayMap<Integer, byte[]>();
        VerifiedSigner result = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        try {
            signers = ApkSigningBlockUtils.getLengthPrefixedSlice(signatureInfo.signatureBlock);
        }
        catch (IOException e) {
            throw new SecurityException("Failed to read list of signers", e);
        }
        while (signers.hasRemaining()) {
            try {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                result = ApkSignatureSchemeV3Verifier.verifySigner(signer, contentDigests, certFactory);
                ++signerCount;
            }
            catch (PlatformNotSupportedException e) {
            }
            catch (IOException | SecurityException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse/verify signer #" + signerCount + " block", e);
            }
        }
        if (signerCount < 1 || result == null) {
            throw new SecurityException("No signers found");
        }
        if (signerCount != 1) {
            throw new SecurityException("APK Signature Scheme V3 only supports one signer: multiple signers found.");
        }
        if (contentDigests.isEmpty()) {
            throw new SecurityException("No content digests found");
        }
        if (doVerifyIntegrity) {
            ApkSigningBlockUtils.verifyIntegrity(contentDigests, apk, signatureInfo);
        }
        if (contentDigests.containsKey(3)) {
            byte[] verityDigest = (byte[])contentDigests.get(3);
            result.verityRootHash = ApkSigningBlockUtils.parseVerityDigestAndVerifySourceLength(verityDigest, apk.length(), signatureInfo);
        }
        return result;
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verifySigner(ByteBuffer signerBlock, Map<Integer, byte[]> contentDigests, CertificateFactory certFactory) throws SecurityException, IOException, PlatformNotSupportedException {
        boolean sigVerified;
        ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        int minSdkVersion = signerBlock.getInt();
        int maxSdkVersion = signerBlock.getInt();
        if (Build.VERSION.SDK_INT < minSdkVersion || Build.VERSION.SDK_INT > maxSdkVersion) {
            throw new PlatformNotSupportedException("Signer not supported by this platform version. This platform: " + Build.VERSION.SDK_INT + ", signer minSdkVersion: " + minSdkVersion + ", maxSdkVersion: " + maxSdkVersion);
        }
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        int bestSigAlgorithm = -1;
        byte[] bestSigAlgorithmSignatureBytes = null;
        ArrayList<Integer> signaturesSigAlgorithms = new ArrayList<Integer>();
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                if (signature.remaining() < 8) {
                    throw new SecurityException("Signature record too short");
                }
                int sigAlgorithm = signature.getInt();
                signaturesSigAlgorithms.add(sigAlgorithm);
                if (!ApkSignatureSchemeV3Verifier.isSupportedSignatureAlgorithm(sigAlgorithm) || bestSigAlgorithm != -1 && ApkSigningBlockUtils.compareSignatureAlgorithm(sigAlgorithm, bestSigAlgorithm) <= 0) continue;
                bestSigAlgorithm = sigAlgorithm;
                bestSigAlgorithmSignatureBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse signature record #" + signatureCount, e);
            }
        }
        if (bestSigAlgorithm == -1) {
            if (signatureCount == 0) {
                throw new SecurityException("No signatures found");
            }
            throw new SecurityException("No supported signatures found");
        }
        String keyAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmJcaKeyAlgorithm(bestSigAlgorithm);
        Pair<String, ? extends AlgorithmParameterSpec> signatureAlgorithmParams = ApkSigningBlockUtils.getSignatureAlgorithmJcaSignatureAlgorithm(bestSigAlgorithm);
        String jcaSignatureAlgorithm = (String)signatureAlgorithmParams.first;
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)signatureAlgorithmParams.second;
        try {
            PublicKey publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            sigVerified = sig.verify(bestSigAlgorithmSignatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new SecurityException("Failed to verify " + jcaSignatureAlgorithm + " signature", e);
        }
        if (!sigVerified) {
            throw new SecurityException(jcaSignatureAlgorithm + " signature did not verify");
        }
        byte[] contentDigest = null;
        signedData.clear();
        ByteBuffer digests = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<Integer> digestsSigAlgorithms = new ArrayList<Integer>();
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSigningBlockUtils.getLengthPrefixedSlice(digests);
                if (digest.remaining() < 8) {
                    throw new IOException("Record too short");
                }
                int sigAlgorithm = digest.getInt();
                digestsSigAlgorithms.add(sigAlgorithm);
                if (sigAlgorithm != bestSigAlgorithm) continue;
                contentDigest = ApkSigningBlockUtils.readLengthPrefixedByteArray(digest);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new IOException("Failed to parse digest record #" + digestCount, e);
            }
        }
        if (!signaturesSigAlgorithms.equals(digestsSigAlgorithms)) {
            throw new SecurityException("Signature algorithms don't match between digests and signatures records");
        }
        int digestAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmContentDigestAlgorithm(bestSigAlgorithm);
        byte[] previousSignerDigest = contentDigests.put(digestAlgorithm, contentDigest);
        if (previousSignerDigest != null && !MessageDigest.isEqual(previousSignerDigest, contentDigest)) {
            throw new SecurityException(ApkSigningBlockUtils.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithm) + " contents digest does not match the digest specified by a preceding signer");
        }
        ByteBuffer certificates = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        int certificateCount = 0;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateCount;
            byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(certificates);
            try {
                certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
            }
            catch (CertificateException e) {
                throw new SecurityException("Failed to decode certificate #" + certificateCount, e);
            }
            certificate = new VerbatimX509Certificate(certificate, encodedCert);
            certs.add(certificate);
        }
        if (certs.isEmpty()) {
            throw new SecurityException("No certificates listed");
        }
        X509Certificate mainCertificate = (X509Certificate)certs.get(0);
        byte[] certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            throw new SecurityException("Public key mismatch between certificate and signature record");
        }
        int signedMinSDK = signedData.getInt();
        if (signedMinSDK != minSdkVersion) {
            throw new SecurityException("minSdkVersion mismatch between signed and unsigned in v3 signer block.");
        }
        int signedMaxSDK = signedData.getInt();
        if (signedMaxSDK != maxSdkVersion) {
            throw new SecurityException("maxSdkVersion mismatch between signed and unsigned in v3 signer block.");
        }
        ByteBuffer additionalAttrs = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        return ApkSignatureSchemeV3Verifier.verifyAdditionalAttributes(additionalAttrs, certs, certFactory);
    }

    private static final VerifiedSigner $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verifyAdditionalAttributes(ByteBuffer attrs, List<X509Certificate> certs, CertificateFactory certFactory) throws IOException {
        X509Certificate[] certChain = certs.toArray(new X509Certificate[certs.size()]);
        VerifiedProofOfRotation por = null;
        block5: while (attrs.hasRemaining()) {
            ByteBuffer attr2 = ApkSigningBlockUtils.getLengthPrefixedSlice(attrs);
            if (attr2.remaining() < 4) {
                throw new IOException("Remaining buffer too short to contain additional attribute ID. Remaining: " + attr2.remaining());
            }
            int id2 = attr2.getInt();
            switch (id2) {
                case 1000370060: {
                    if (por != null) {
                        throw new SecurityException("Encountered multiple Proof-of-rotation records when verifying APK Signature Scheme v3 signature");
                    }
                    por = ApkSignatureSchemeV3Verifier.verifyProofOfRotationStruct(attr2, certFactory);
                    try {
                        if (por.certs.size() <= 0 || Arrays.equals(por.certs.get(por.certs.size() - 1).getEncoded(), certChain[0].getEncoded())) continue block5;
                        throw new SecurityException("Terminal certificate in Proof-of-rotation record does not match APK signing certificate");
                    }
                    catch (CertificateEncodingException e) {
                        throw new SecurityException("Failed to encode certificate when comparing Proof-of-rotation record and signing certificate", e);
                    }
                }
            }
        }
        return new VerifiedSigner(certChain, por);
    }

    private static final VerifiedProofOfRotation $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verifyProofOfRotationStruct(ByteBuffer porBuf, CertificateFactory certFactory) throws SecurityException, IOException {
        int levelCount = 0;
        int lastSigAlgorithm = -1;
        Certificate lastCert = null;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        ArrayList<Integer> flagsList = new ArrayList<Integer>();
        try {
            porBuf.getInt();
            HashSet<Certificate> certHistorySet = new HashSet<Certificate>();
            while (porBuf.hasRemaining()) {
                ++levelCount;
                ByteBuffer level = ApkSigningBlockUtils.getLengthPrefixedSlice(porBuf);
                ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(level);
                int flags = level.getInt();
                int sigAlgorithm = level.getInt();
                byte[] signature = ApkSigningBlockUtils.readLengthPrefixedByteArray(level);
                if (lastCert != null) {
                    Pair<String, ? extends AlgorithmParameterSpec> sigAlgParams = ApkSigningBlockUtils.getSignatureAlgorithmJcaSignatureAlgorithm(lastSigAlgorithm);
                    PublicKey publicKey = lastCert.getPublicKey();
                    Signature sig = Signature.getInstance((String)sigAlgParams.first);
                    sig.initVerify(publicKey);
                    if (sigAlgParams.second != null) {
                        sig.setParameter((AlgorithmParameterSpec)sigAlgParams.second);
                    }
                    sig.update(signedData);
                    if (!sig.verify(signature)) {
                        throw new SecurityException("Unable to verify signature of certificate #" + levelCount + " using " + (String)sigAlgParams.first + " when verifying Proof-of-rotation record");
                    }
                }
                signedData.rewind();
                byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(signedData);
                int signedSigAlgorithm = signedData.getInt();
                if (lastCert != null && lastSigAlgorithm != signedSigAlgorithm) {
                    throw new SecurityException("Signing algorithm ID mismatch for certificate #" + levelCount + " when verifying Proof-of-rotation record");
                }
                lastCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
                lastCert = new VerbatimX509Certificate((X509Certificate)lastCert, encodedCert);
                lastSigAlgorithm = sigAlgorithm;
                if (certHistorySet.contains(lastCert)) {
                    throw new SecurityException("Encountered duplicate entries in Proof-of-rotation record at certificate #" + levelCount + ".  All signing certificates should be unique");
                }
                certHistorySet.add(lastCert);
                certs.add((X509Certificate)lastCert);
                flagsList.add(flags);
            }
        }
        catch (IOException | BufferUnderflowException e) {
            throw new IOException("Failed to parse Proof-of-rotation record", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SecurityException("Failed to verify signature over signed data for certificate #" + levelCount + " when verifying Proof-of-rotation record", e);
        }
        catch (CertificateException e) {
            throw new SecurityException("Failed to decode certificate #" + levelCount + " when verifying Proof-of-rotation record", e);
        }
        return new VerifiedProofOfRotation(certs, flagsList);
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$getVerityRootHash(String apkPath) throws IOException, SignatureNotFoundException, SecurityException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk);
            VerifiedSigner vSigner = ApkSignatureSchemeV3Verifier.verify(apk, false);
            byte[] byArray = vSigner.verityRootHash;
            return byArray;
        }
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$generateApkVerity(String apkPath, ByteBufferFactory bufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk);
            byte[] byArray = ApkSigningBlockUtils.generateApkVerity(apkPath, bufferFactory, signatureInfo);
            return byArray;
        }
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$generateFsverityRootHash(String apkPath) throws NoSuchAlgorithmException, DigestException, IOException, SignatureNotFoundException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk);
            VerifiedSigner vSigner = ApkSignatureSchemeV3Verifier.verify(apk, false);
            if (vSigner.verityRootHash == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = ApkVerityBuilder.generateFsverityRootHash(apk, ByteBuffer.wrap(vSigner.verityRootHash), signatureInfo);
            return byArray;
        }
    }

    private static final boolean $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$isSupportedSignatureAlgorithm(int sigAlgorithm) {
        switch (sigAlgorithm) {
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 513: 
            case 514: 
            case 769: 
            case 1057: 
            case 1059: 
            case 1061: {
                return true;
            }
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$__constructor__();
    }

    public ApkSignatureSchemeV3Verifier() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$__constructor__(), this);
    }

    public static boolean hasSignature(String string2) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSignature", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$hasSignature(java.lang.String ), (String)string2);
    }

    public static VerifiedSigner verify(String string2) throws SignatureNotFoundException, SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(java.lang.String ), (String)string2);
    }

    public static VerifiedSigner plsCertsNoVerifyOnlyCerts(String string2) throws SignatureNotFoundException, SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("plsCertsNoVerifyOnlyCerts", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$plsCertsNoVerifyOnlyCerts(java.lang.String ), (String)string2);
    }

    private static VerifiedSigner verify(String string2, boolean bl) throws SignatureNotFoundException, SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    private static VerifiedSigner verify(RandomAccessFile randomAccessFile, boolean bl) throws SignatureNotFoundException, SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(java.io.RandomAccessFile boolean ), (RandomAccessFile)randomAccessFile, (boolean)bl);
    }

    private static SignatureInfo findSignature(RandomAccessFile randomAccessFile) throws IOException, SignatureNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("findSignature", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$findSignature(java.io.RandomAccessFile ), (RandomAccessFile)randomAccessFile);
    }

    private static VerifiedSigner verify(RandomAccessFile randomAccessFile, SignatureInfo signatureInfo, boolean bl) throws SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verify(java.io.RandomAccessFile android.util.apk.SignatureInfo boolean ), (RandomAccessFile)randomAccessFile, (SignatureInfo)signatureInfo, (boolean)bl);
    }

    private static VerifiedSigner verifySigner(ByteBuffer byteBuffer, Map<Integer, byte[]> map, CertificateFactory certificateFactory) throws SecurityException, IOException, PlatformNotSupportedException {
        return InvokeDynamicSupport.bootstrapStatic("verifySigner", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verifySigner(java.nio.ByteBuffer java.util.Map<java.lang.Integer, byte[]> java.security.cert.CertificateFactory ), (ByteBuffer)byteBuffer, map, (CertificateFactory)certificateFactory);
    }

    private static VerifiedSigner verifyAdditionalAttributes(ByteBuffer byteBuffer, List<X509Certificate> list, CertificateFactory certificateFactory) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("verifyAdditionalAttributes", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verifyAdditionalAttributes(java.nio.ByteBuffer java.util.List<java.security.cert.X509Certificate> java.security.cert.CertificateFactory ), (ByteBuffer)byteBuffer, list, (CertificateFactory)certificateFactory);
    }

    private static VerifiedProofOfRotation verifyProofOfRotationStruct(ByteBuffer byteBuffer, CertificateFactory certificateFactory) throws SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verifyProofOfRotationStruct", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$verifyProofOfRotationStruct(java.nio.ByteBuffer java.security.cert.CertificateFactory ), (ByteBuffer)byteBuffer, (CertificateFactory)certificateFactory);
    }

    static byte[] getVerityRootHash(String string2) throws IOException, SignatureNotFoundException, SecurityException {
        return InvokeDynamicSupport.bootstrapStatic("getVerityRootHash", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$getVerityRootHash(java.lang.String ), (String)string2);
    }

    static byte[] generateApkVerity(String string2, ByteBufferFactory byteBufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        return InvokeDynamicSupport.bootstrapStatic("generateApkVerity", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$generateApkVerity(java.lang.String android.util.apk.ByteBufferFactory ), (String)string2, (ByteBufferFactory)byteBufferFactory);
    }

    static byte[] generateFsverityRootHash(String string2) throws NoSuchAlgorithmException, DigestException, IOException, SignatureNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("generateFsverityRootHash", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$generateFsverityRootHash(java.lang.String ), (String)string2);
    }

    private static boolean isSupportedSignatureAlgorithm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupportedSignatureAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier$isSupportedSignatureAlgorithm(int ), (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkSignatureSchemeV3Verifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PlatformNotSupportedException
    extends Exception
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_PlatformNotSupportedException$__constructor__(String s) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_PlatformNotSupportedException$__constructor__(string2);
        }

        public PlatformNotSupportedException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_PlatformNotSupportedException$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ PlatformNotSupportedException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlatformNotSupportedException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VerifiedSigner
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public X509Certificate[] certs;
        public VerifiedProofOfRotation por;
        public byte[] verityRootHash;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_VerifiedSigner$__constructor__(X509Certificate[] certs, VerifiedProofOfRotation por) {
            this.certs = certs;
            this.por = por;
        }

        private void __constructor__(X509Certificate[] x509CertificateArray, VerifiedProofOfRotation verifiedProofOfRotation) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_VerifiedSigner$__constructor__(x509CertificateArray, verifiedProofOfRotation);
        }

        public VerifiedSigner(X509Certificate[] x509CertificateArray, VerifiedProofOfRotation verifiedProofOfRotation) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_VerifiedSigner$__constructor__(java.security.cert.X509Certificate[] android.util.apk.ApkSignatureSchemeV3Verifier$VerifiedProofOfRotation ), this, x509CertificateArray, verifiedProofOfRotation);
        }

        public /* synthetic */ VerifiedSigner() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VerifiedSigner)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VerifiedProofOfRotation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public List<X509Certificate> certs;
        public List<Integer> flagsList;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_VerifiedProofOfRotation$__constructor__(List<X509Certificate> certs, List<Integer> flagsList) {
            this.certs = certs;
            this.flagsList = flagsList;
        }

        private void __constructor__(List<X509Certificate> list, List<Integer> list2) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_VerifiedProofOfRotation$__constructor__(list, list2);
        }

        public VerifiedProofOfRotation(List<X509Certificate> list, List<Integer> list2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV3Verifier_VerifiedProofOfRotation$__constructor__(java.util.List<java.security.cert.X509Certificate> java.util.List<java.lang.Integer> ), this, list, list2);
        }

        public /* synthetic */ VerifiedProofOfRotation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VerifiedProofOfRotation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

