/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Build;
import android.os.SystemClock;
import android.os.Trace;
import android.util.Pair;
import android.util.Slog;
import java.util.ArrayDeque;
import java.util.Deque;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimingsTraceLog
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_BOOT_TIME;
    private Deque<Pair<String, Long>> mStartTimes;
    private String mTag;
    private long mTraceTag;
    private long mThreadId;

    private void $$robo$$android_util_TimingsTraceLog$__constructor__(String tag, long traceTag) {
        this.mStartTimes = DEBUG_BOOT_TIME ? new ArrayDeque() : null;
        this.mTag = tag;
        this.mTraceTag = traceTag;
        this.mThreadId = Thread.currentThread().getId();
    }

    private final void $$robo$$android_util_TimingsTraceLog$traceBegin(String name) {
        this.assertSameThread();
        Trace.traceBegin(this.mTraceTag, name);
        if (DEBUG_BOOT_TIME) {
            this.mStartTimes.push(Pair.create(name, SystemClock.elapsedRealtime()));
        }
    }

    private final void $$robo$$android_util_TimingsTraceLog$traceEnd() {
        this.assertSameThread();
        Trace.traceEnd(this.mTraceTag);
        if (!DEBUG_BOOT_TIME) {
            return;
        }
        if (this.mStartTimes.peek() == null) {
            Slog.w(this.mTag, "traceEnd called more times than traceBegin");
            return;
        }
        Pair<String, Long> event = this.mStartTimes.pop();
        this.logDuration((String)event.first, SystemClock.elapsedRealtime() - (Long)event.second);
    }

    private final void $$robo$$android_util_TimingsTraceLog$assertSameThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getId() != this.mThreadId) {
            throw new IllegalStateException("Instance of TimingsTraceLog can only be called from the thread it was created on (tid: " + this.mThreadId + "), but was from " + currentThread.getName() + " (tid: " + currentThread.getId() + ")");
        }
    }

    private final void $$robo$$android_util_TimingsTraceLog$logDuration(String name, long timeMs) {
        Slog.d(this.mTag, name + " took to complete: " + timeMs + "ms");
    }

    static void __staticInitializer__() {
        DEBUG_BOOT_TIME = !Build.IS_USER;
    }

    private void __constructor__(String string2, long l) {
        this.$$robo$$android_util_TimingsTraceLog$__constructor__(string2, l);
    }

    public TimingsTraceLog(String string2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_TimingsTraceLog$__constructor__(java.lang.String long ), this, string2, l);
    }

    public void traceBegin(String string2) {
        InvokeDynamicSupport.bootstrap("traceBegin", $$robo$$android_util_TimingsTraceLog$traceBegin(java.lang.String ), this, string2);
    }

    public void traceEnd() {
        InvokeDynamicSupport.bootstrap("traceEnd", $$robo$$android_util_TimingsTraceLog$traceEnd(), this);
    }

    private void assertSameThread() {
        InvokeDynamicSupport.bootstrap("assertSameThread", $$robo$$android_util_TimingsTraceLog$assertSameThread(), this);
    }

    public void logDuration(String string2, long l) {
        InvokeDynamicSupport.bootstrap("logDuration", $$robo$$android_util_TimingsTraceLog$logDuration(java.lang.String long ), this, string2, l);
    }

    static {
        RobolectricInternals.classInitializing(TimingsTraceLog.class);
    }

    public /* synthetic */ TimingsTraceLog() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimingsTraceLog)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

