/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TypeEvaluator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.widget.ImageView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransitionUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MAX_IMAGE_SIZE;

    private void $$robo$$android_transition_TransitionUtils$__constructor__() {
    }

    private static final Animator $$robo$$android_transition_TransitionUtils$mergeAnimators(Animator animator1, Animator animator2) {
        if (animator1 == null) {
            return animator2;
        }
        if (animator2 == null) {
            return animator1;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animator1, animator2);
        return animatorSet;
    }

    private static final Transition $$robo$$android_transition_TransitionUtils$mergeTransitions(Transition ... transitions) {
        int count = 0;
        int nonNullIndex = -1;
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i] == null) continue;
            ++count;
            nonNullIndex = i;
        }
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return transitions[nonNullIndex];
        }
        TransitionSet transitionSet = new TransitionSet();
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i] == null) continue;
            transitionSet.addTransition(transitions[i]);
        }
        return transitionSet;
    }

    private static final View $$robo$$android_transition_TransitionUtils$copyViewImage(ViewGroup sceneRoot, View view, View parent) {
        Matrix matrix = new Matrix();
        matrix.setTranslate(-parent.getScrollX(), -parent.getScrollY());
        view.transformMatrixToGlobal(matrix);
        sceneRoot.transformMatrixToLocal(matrix);
        RectF bounds = new RectF(0.0f, 0.0f, view.getWidth(), view.getHeight());
        matrix.mapRect(bounds);
        int left = Math.round(bounds.left);
        int top = Math.round(bounds.top);
        int right = Math.round(bounds.right);
        int bottom = Math.round(bounds.bottom);
        ImageView copy = new ImageView(view.getContext());
        copy.setScaleType(ImageView.ScaleType.CENTER_CROP);
        Bitmap bitmap = TransitionUtils.createViewBitmap(view, matrix, bounds, sceneRoot);
        if (bitmap != null) {
            copy.setImageBitmap(bitmap);
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec(right - left, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(bottom - top, 0x40000000);
        copy.measure(widthSpec, heightSpec);
        copy.layout(left, top, right, bottom);
        return copy;
    }

    private static final Bitmap $$robo$$android_transition_TransitionUtils$createDrawableBitmap(Drawable drawable2, View hostView) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        float scale = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(width * height));
        if (drawable2 instanceof BitmapDrawable && scale == 1.0f) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int bitmapWidth = (int)((float)width * scale);
        int bitmapHeight = (int)((float)height * scale);
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(width, height);
        Rect existingBounds = drawable2.getBounds();
        int left = existingBounds.left;
        int top = existingBounds.top;
        int right = existingBounds.right;
        int bottom = existingBounds.bottom;
        drawable2.setBounds(0, 0, bitmapWidth, bitmapHeight);
        drawable2.draw(canvas);
        drawable2.setBounds(left, top, right, bottom);
        picture.endRecording();
        return Bitmap.createBitmap(picture);
    }

    private static final Bitmap $$robo$$android_transition_TransitionUtils$createViewBitmap(View view, Matrix matrix, RectF bounds, ViewGroup sceneRoot) {
        boolean addToOverlay = !view.isAttachedToWindow();
        ViewGroup parent = null;
        int indexInParent = 0;
        if (addToOverlay) {
            if (sceneRoot == null || !sceneRoot.isAttachedToWindow()) {
                return null;
            }
            parent = (ViewGroup)view.getParent();
            indexInParent = parent.indexOfChild(view);
            ((ViewGroupOverlay)sceneRoot.getOverlay()).add(view);
        }
        Bitmap bitmap = null;
        int bitmapWidth = Math.round(bounds.width());
        int bitmapHeight = Math.round(bounds.height());
        if (bitmapWidth > 0 && bitmapHeight > 0) {
            float scale = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(bitmapWidth * bitmapHeight));
            bitmapWidth = (int)((float)bitmapWidth * scale);
            bitmapHeight = (int)((float)bitmapHeight * scale);
            matrix.postTranslate(-bounds.left, -bounds.top);
            matrix.postScale(scale, scale);
            Picture picture = new Picture();
            Canvas canvas = picture.beginRecording(bitmapWidth, bitmapHeight);
            canvas.concat(matrix);
            view.draw(canvas);
            picture.endRecording();
            bitmap = Bitmap.createBitmap(picture);
        }
        if (addToOverlay) {
            ((ViewGroupOverlay)sceneRoot.getOverlay()).remove(view);
            parent.addView(view, indexInParent);
        }
        return bitmap;
    }

    static void __staticInitializer__() {
        MAX_IMAGE_SIZE = 0x100000;
    }

    private void __constructor__() {
        this.$$robo$$android_transition_TransitionUtils$__constructor__();
    }

    public TransitionUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionUtils$__constructor__(), this);
    }

    static Animator mergeAnimators(Animator animator2, Animator animator3) {
        return InvokeDynamicSupport.bootstrapStatic("mergeAnimators", $$robo$$android_transition_TransitionUtils$mergeAnimators(android.animation.Animator android.animation.Animator ), (Animator)animator2, (Animator)animator3);
    }

    public static Transition mergeTransitions(Transition ... transitionArray) {
        return InvokeDynamicSupport.bootstrapStatic("mergeTransitions", $$robo$$android_transition_TransitionUtils$mergeTransitions(android.transition.Transition[] ), (Transition[])transitionArray);
    }

    public static View copyViewImage(ViewGroup viewGroup, View view, View view2) {
        return InvokeDynamicSupport.bootstrapStatic("copyViewImage", $$robo$$android_transition_TransitionUtils$copyViewImage(android.view.ViewGroup android.view.View android.view.View ), (ViewGroup)viewGroup, (View)view, (View)view2);
    }

    public static Bitmap createDrawableBitmap(Drawable drawable2, View view) {
        return InvokeDynamicSupport.bootstrapStatic("createDrawableBitmap", $$robo$$android_transition_TransitionUtils$createDrawableBitmap(android.graphics.drawable.Drawable android.view.View ), (Drawable)drawable2, (View)view);
    }

    public static Bitmap createViewBitmap(View view, Matrix matrix, RectF rectF, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrapStatic("createViewBitmap", $$robo$$android_transition_TransitionUtils$createViewBitmap(android.view.View android.graphics.Matrix android.graphics.RectF android.view.ViewGroup ), (View)view, (Matrix)matrix, (RectF)rectF, (ViewGroup)viewGroup);
    }

    static {
        RobolectricInternals.classInitializing(TransitionUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MatrixEvaluator
    implements TypeEvaluator<Matrix> {
        public /* synthetic */ Object __robo_data__;
        float[] mTempStartValues;
        float[] mTempEndValues;
        Matrix mTempMatrix;

        private void $$robo$$android_transition_TransitionUtils_MatrixEvaluator$__constructor__() {
            this.mTempStartValues = new float[9];
            this.mTempEndValues = new float[9];
            this.mTempMatrix = new Matrix();
        }

        private final Matrix $$robo$$android_transition_TransitionUtils_MatrixEvaluator$evaluate(float fraction2, Matrix startValue, Matrix endValue) {
            startValue.getValues(this.mTempStartValues);
            endValue.getValues(this.mTempEndValues);
            for (int i = 0; i < 9; ++i) {
                float diff = this.mTempEndValues[i] - this.mTempStartValues[i];
                this.mTempEndValues[i] = this.mTempStartValues[i] + fraction2 * diff;
            }
            this.mTempMatrix.setValues(this.mTempEndValues);
            return this.mTempMatrix;
        }

        private void __constructor__() {
            this.$$robo$$android_transition_TransitionUtils_MatrixEvaluator$__constructor__();
        }

        public MatrixEvaluator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionUtils_MatrixEvaluator$__constructor__(), this);
        }

        @Override
        public Matrix evaluate(float f, Matrix matrix, Matrix matrix2) {
            return InvokeDynamicSupport.bootstrap("evaluate", $$robo$$android_transition_TransitionUtils_MatrixEvaluator$evaluate(float android.graphics.Matrix android.graphics.Matrix ), this, f, matrix, matrix2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MatrixEvaluator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

