/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Rect;
import android.transition.CircularPropagation;
import android.transition.TransitionValues;
import android.transition.TranslationAnimationCreator;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Explode
extends Visibility
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static TimeInterpolator sDecelerate;
    private static TimeInterpolator sAccelerate;
    private static String TAG = "Explode";
    private static String PROPNAME_SCREEN_BOUNDS = "android:explode:screenBounds";
    private int[] mTempLoc;

    private void $$robo$$android_transition_Explode$__constructor__() {
        this.mTempLoc = new int[2];
        this.setPropagation(new CircularPropagation());
    }

    private void $$robo$$android_transition_Explode$__constructor__(Context context, AttributeSet attrs) {
        this.mTempLoc = new int[2];
        this.setPropagation(new CircularPropagation());
    }

    private final void $$robo$$android_transition_Explode$captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        view.getLocationOnScreen(this.mTempLoc);
        int left = this.mTempLoc[0];
        int top = this.mTempLoc[1];
        int right = left + view.getWidth();
        int bottom = top + view.getHeight();
        transitionValues.values.put("android:explode:screenBounds", new Rect(left, top, right, bottom));
    }

    private final void $$robo$$android_transition_Explode$captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    private final void $$robo$$android_transition_Explode$captureEndValues(TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    private final Animator $$robo$$android_transition_Explode$onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        Rect bounds = (Rect)endValues.values.get("android:explode:screenBounds");
        float endX = view.getTranslationX();
        float endY = view.getTranslationY();
        this.calculateOut(sceneRoot, bounds, this.mTempLoc);
        float startX = endX + (float)this.mTempLoc[0];
        float startY = endY + (float)this.mTempLoc[1];
        return TranslationAnimationCreator.createAnimation(view, endValues, bounds.left, bounds.top, startX, startY, endX, endY, sDecelerate, this);
    }

    private final Animator $$robo$$android_transition_Explode$onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        Rect bounds = (Rect)startValues.values.get("android:explode:screenBounds");
        int viewPosX = bounds.left;
        int viewPosY = bounds.top;
        float startX = view.getTranslationX();
        float startY = view.getTranslationY();
        float endX = startX;
        float endY = startY;
        int[] interruptedPosition = (int[])startValues.view.getTag(16909435);
        if (interruptedPosition != null) {
            endX += (float)(interruptedPosition[0] - bounds.left);
            endY += (float)(interruptedPosition[1] - bounds.top);
            bounds.offsetTo(interruptedPosition[0], interruptedPosition[1]);
        }
        this.calculateOut(sceneRoot, bounds, this.mTempLoc);
        return TranslationAnimationCreator.createAnimation(view, startValues, viewPosX, viewPosY, startX, startY, endX += (float)this.mTempLoc[0], endY += (float)this.mTempLoc[1], sAccelerate, this);
    }

    private final void $$robo$$android_transition_Explode$calculateOut(View sceneRoot, Rect bounds, int[] outVector) {
        int focalY;
        int focalX;
        sceneRoot.getLocationOnScreen(this.mTempLoc);
        int sceneRootX = this.mTempLoc[0];
        int sceneRootY = this.mTempLoc[1];
        Rect epicenter = this.getEpicenter();
        if (epicenter == null) {
            focalX = sceneRootX + sceneRoot.getWidth() / 2 + Math.round(sceneRoot.getTranslationX());
            focalY = sceneRootY + sceneRoot.getHeight() / 2 + Math.round(sceneRoot.getTranslationY());
        } else {
            focalX = epicenter.centerX();
            focalY = epicenter.centerY();
        }
        int centerX = bounds.centerX();
        int centerY = bounds.centerY();
        double xVector = centerX - focalX;
        double yVector = centerY - focalY;
        if (xVector == 0.0 && yVector == 0.0) {
            xVector = Math.random() * 2.0 - 1.0;
            yVector = Math.random() * 2.0 - 1.0;
        }
        double vectorSize = Math.hypot(xVector, yVector);
        double maxDistance = Explode.calculateMaxDistance(sceneRoot, focalX - sceneRootX, focalY - sceneRootY);
        outVector[0] = (int)Math.round(maxDistance * (xVector /= vectorSize));
        outVector[1] = (int)Math.round(maxDistance * (yVector /= vectorSize));
    }

    private static final double $$robo$$android_transition_Explode$calculateMaxDistance(View sceneRoot, int focalX, int focalY) {
        int maxX = Math.max(focalX, sceneRoot.getWidth() - focalX);
        int maxY = Math.max(focalY, sceneRoot.getHeight() - focalY);
        return Math.hypot(maxX, maxY);
    }

    static void __staticInitializer__() {
        sDecelerate = new DecelerateInterpolator();
        sAccelerate = new AccelerateInterpolator();
    }

    private void __constructor__() {
        this.$$robo$$android_transition_Explode$__constructor__();
    }

    public Explode() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Explode$__constructor__(), this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_Explode$__constructor__(context, attributeSet);
    }

    public Explode(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Explode$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void captureValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureValues", $$robo$$android_transition_Explode$captureValues(android.transition.TransitionValues ), this, transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureStartValues", $$robo$$android_transition_Explode$captureStartValues(android.transition.TransitionValues ), this, transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureEndValues", $$robo$$android_transition_Explode$captureEndValues(android.transition.TransitionValues ), this, transitionValues);
    }

    @Override
    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("onAppear", $$robo$$android_transition_Explode$onAppear(android.view.ViewGroup android.view.View android.transition.TransitionValues android.transition.TransitionValues ), this, viewGroup, view, transitionValues, transitionValues2);
    }

    @Override
    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("onDisappear", $$robo$$android_transition_Explode$onDisappear(android.view.ViewGroup android.view.View android.transition.TransitionValues android.transition.TransitionValues ), this, viewGroup, view, transitionValues, transitionValues2);
    }

    private void calculateOut(View view, Rect rect, int[] nArray) {
        InvokeDynamicSupport.bootstrap("calculateOut", $$robo$$android_transition_Explode$calculateOut(android.view.View android.graphics.Rect int[] ), this, view, rect, nArray);
    }

    private static double calculateMaxDistance(View view, int n, int n2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("calculateMaxDistance", $$robo$$android_transition_Explode$calculateMaxDistance(android.view.View int int ), (View)view, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(Explode.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Explode)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

