/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.text.format.TimeFormatter;
import android.util.TimeFormatException;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import libcore.util.ZoneInfo;
import libcore.util.ZoneInfoDB;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
public class Time
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String Y_M_D_T_H_M_S_000 = "%Y-%m-%dT%H:%M:%S.000";
    private static String Y_M_D_T_H_M_S_000_Z = "%Y-%m-%dT%H:%M:%S.000Z";
    private static String Y_M_D = "%Y-%m-%d";
    public static String TIMEZONE_UTC = "UTC";
    public static int EPOCH_JULIAN_DAY = 2440588;
    public static int MONDAY_BEFORE_JULIAN_EPOCH = 2440585;
    public boolean allDay;
    public int second;
    public int minute;
    public int hour;
    public int monthDay;
    public int month;
    public int year;
    public int weekDay;
    public int yearDay;
    public int isDst;
    public long gmtoff;
    public String timezone;
    public static int SECOND = 1;
    public static int MINUTE = 2;
    public static int HOUR = 3;
    public static int MONTH_DAY = 4;
    public static int MONTH = 5;
    public static int YEAR = 6;
    public static int WEEK_DAY = 7;
    public static int YEAR_DAY = 8;
    public static int WEEK_NUM = 9;
    public static int SUNDAY = 0;
    public static int MONDAY = 1;
    public static int TUESDAY = 2;
    public static int WEDNESDAY = 3;
    public static int THURSDAY = 4;
    public static int FRIDAY = 5;
    public static int SATURDAY = 6;
    private TimeCalculator calculator;
    private static int[] DAYS_PER_MONTH;
    private static int[] sThursdayOffset;

    private void $$robo$$android_text_format_Time$__constructor__(String timezoneId) {
        if (timezoneId == null) {
            throw new NullPointerException("timezoneId is null!");
        }
        this.initialize(timezoneId);
    }

    private void $$robo$$android_text_format_Time$__constructor__() {
        this.initialize(TimeZone.getDefault().getID());
    }

    private void $$robo$$android_text_format_Time$__constructor__(Time other) {
        this.initialize(other.timezone);
        this.set(other);
    }

    private final void $$robo$$android_text_format_Time$initialize(String timezoneId) {
        this.timezone = timezoneId;
        this.year = 1970;
        this.monthDay = 1;
        this.isDst = -1;
        this.calculator = new TimeCalculator(timezoneId);
    }

    private final long $$robo$$android_text_format_Time$normalize(boolean ignoreDst) {
        this.calculator.copyFieldsFromTime(this);
        long timeInMillis = this.calculator.toMillis(ignoreDst);
        this.calculator.copyFieldsToTime(this);
        return timeInMillis;
    }

    private final void $$robo$$android_text_format_Time$switchTimezone(String timezone) {
        this.calculator.copyFieldsFromTime(this);
        this.calculator.switchTimeZone(timezone);
        this.calculator.copyFieldsToTime(this);
        this.timezone = timezone;
    }

    private final int $$robo$$android_text_format_Time$getActualMaximum(int field) {
        switch (field) {
            case 1: {
                return 59;
            }
            case 2: {
                return 59;
            }
            case 3: {
                return 23;
            }
            case 4: {
                int n = DAYS_PER_MONTH[this.month];
                if (n != 28) {
                    return n;
                }
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 2037;
            }
            case 7: {
                return 6;
            }
            case 8: {
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 365 : 364;
            }
            case 9: {
                throw new RuntimeException("WEEK_NUM not implemented");
            }
        }
        throw new RuntimeException("bad field=" + field);
    }

    private final void $$robo$$android_text_format_Time$clear(String timezoneId) {
        if (timezoneId == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = timezoneId;
        this.allDay = false;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = 0;
        this.month = 0;
        this.year = 0;
        this.weekDay = 0;
        this.yearDay = 0;
        this.gmtoff = 0L;
        this.isDst = -1;
    }

    private static final int $$robo$$android_text_format_Time$compare(Time a, Time b) {
        if (a == null) {
            throw new NullPointerException("a == null");
        }
        if (b == null) {
            throw new NullPointerException("b == null");
        }
        a.calculator.copyFieldsFromTime(a);
        b.calculator.copyFieldsFromTime(b);
        return TimeCalculator.compare(a.calculator, b.calculator);
    }

    private final String $$robo$$android_text_format_Time$format(String format) {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.format(format);
    }

    private final String $$robo$$android_text_format_Time$toString() {
        TimeCalculator calculator = new TimeCalculator(this.timezone);
        calculator.copyFieldsFromTime(this);
        return calculator.toStringInternal();
    }

    private final boolean $$robo$$android_text_format_Time$parse(String s) {
        if (s == null) {
            throw new NullPointerException("time string is null");
        }
        if (this.parseInternal(s)) {
            this.timezone = "UTC";
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_text_format_Time$parseInternal(String s) {
        int len = s.length();
        if (len < 8) {
            throw new TimeFormatException("String is too short: \"" + s + "\" Expected at least 8 characters.");
        }
        boolean inUtc = false;
        int n = Time.getChar(s, 0, 1000);
        n += Time.getChar(s, 1, 100);
        n += Time.getChar(s, 2, 10);
        this.year = n += Time.getChar(s, 3, 1);
        n = Time.getChar(s, 4, 10);
        n += Time.getChar(s, 5, 1);
        this.month = --n;
        n = Time.getChar(s, 6, 10);
        this.monthDay = n += Time.getChar(s, 7, 1);
        if (len > 8) {
            if (len < 15) {
                throw new TimeFormatException("String is too short: \"" + s + "\" If there are more than 8 characters there must be at least 15.");
            }
            this.checkChar(s, 8, 'T');
            this.allDay = false;
            n = Time.getChar(s, 9, 10);
            this.hour = n += Time.getChar(s, 10, 1);
            n = Time.getChar(s, 11, 10);
            this.minute = n += Time.getChar(s, 12, 1);
            n = Time.getChar(s, 13, 10);
            this.second = n += Time.getChar(s, 14, 1);
            if (len > 15) {
                this.checkChar(s, 15, 'Z');
                inUtc = true;
            }
        } else {
            this.allDay = true;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
        }
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
        return inUtc;
    }

    private final void $$robo$$android_text_format_Time$checkChar(String s, int spos, char expected) {
        char c = s.charAt(spos);
        if (c != expected) {
            throw new TimeFormatException(String.format("Unexpected character 0x%02d at pos=%d.  Expected 0x%02d ('%c').", c, spos, (int)expected, Character.valueOf(expected)));
        }
    }

    private static final int $$robo$$android_text_format_Time$getChar(String s, int spos, int mul) {
        char c = s.charAt(spos);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c) * mul;
        }
        throw new TimeFormatException("Parse error at pos=" + spos);
    }

    private final boolean $$robo$$android_text_format_Time$parse3339(String s) {
        if (s == null) {
            throw new NullPointerException("time string is null");
        }
        if (this.parse3339Internal(s)) {
            this.timezone = "UTC";
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_text_format_Time$parse3339Internal(String s) {
        int len = s.length();
        if (len < 10) {
            throw new TimeFormatException("String too short --- expected at least 10 characters.");
        }
        boolean inUtc = false;
        int n = Time.getChar(s, 0, 1000);
        n += Time.getChar(s, 1, 100);
        n += Time.getChar(s, 2, 10);
        this.year = n += Time.getChar(s, 3, 1);
        this.checkChar(s, 4, '-');
        n = Time.getChar(s, 5, 10);
        n += Time.getChar(s, 6, 1);
        this.month = --n;
        this.checkChar(s, 7, '-');
        n = Time.getChar(s, 8, 10);
        this.monthDay = n += Time.getChar(s, 9, 1);
        if (len >= 19) {
            this.checkChar(s, 10, 'T');
            this.allDay = false;
            n = Time.getChar(s, 11, 10);
            int hour = n += Time.getChar(s, 12, 1);
            this.checkChar(s, 13, ':');
            n = Time.getChar(s, 14, 10);
            int minute = n += Time.getChar(s, 15, 1);
            this.checkChar(s, 16, ':');
            n = Time.getChar(s, 17, 10);
            this.second = n += Time.getChar(s, 18, 1);
            int tzIndex = 19;
            if (tzIndex < len && s.charAt(tzIndex) == '.') {
                while (++tzIndex < len && Character.isDigit(s.charAt(tzIndex))) {
                }
            }
            int offset = 0;
            if (len > tzIndex) {
                char c = s.charAt(tzIndex);
                switch (c) {
                    case 'Z': {
                        offset = 0;
                        break;
                    }
                    case '-': {
                        offset = 1;
                        break;
                    }
                    case '+': {
                        offset = -1;
                        break;
                    }
                    default: {
                        throw new TimeFormatException(String.format("Unexpected character 0x%02d at position %d.  Expected + or -", c, tzIndex));
                    }
                }
                inUtc = true;
                if (offset != 0) {
                    if (len < tzIndex + 6) {
                        throw new TimeFormatException(String.format("Unexpected length; should be %d characters", tzIndex + 6));
                    }
                    n = Time.getChar(s, tzIndex + 1, 10);
                    n += Time.getChar(s, tzIndex + 2, 1);
                    hour += (n *= offset);
                    n = Time.getChar(s, tzIndex + 4, 10);
                    n += Time.getChar(s, tzIndex + 5, 1);
                    minute += (n *= offset);
                }
            }
            this.hour = hour;
            this.minute = minute;
            if (offset != 0) {
                this.normalize(false);
            }
        } else {
            this.allDay = true;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
        }
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
        return inUtc;
    }

    private static final String $$robo$$android_text_format_Time$getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    private final void $$robo$$android_text_format_Time$setToNow() {
        this.set((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private final long $$robo$$android_text_format_Time$toMillis(boolean ignoreDst) {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.toMillis(ignoreDst);
    }

    private final void $$robo$$android_text_format_Time$set(long millis) {
        this.allDay = false;
        this.calculator.timezone = this.timezone;
        this.calculator.setTimeInMillis(millis);
        this.calculator.copyFieldsToTime(this);
    }

    private final String $$robo$$android_text_format_Time$format2445() {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.format2445(!this.allDay);
    }

    private final void $$robo$$android_text_format_Time$set(Time that) {
        this.timezone = that.timezone;
        this.allDay = that.allDay;
        this.second = that.second;
        this.minute = that.minute;
        this.hour = that.hour;
        this.monthDay = that.monthDay;
        this.month = that.month;
        this.year = that.year;
        this.weekDay = that.weekDay;
        this.yearDay = that.yearDay;
        this.isDst = that.isDst;
        this.gmtoff = that.gmtoff;
    }

    private final void $$robo$$android_text_format_Time$set(int second, int minute, int hour, int monthDay, int month, int year) {
        this.allDay = false;
        this.second = second;
        this.minute = minute;
        this.hour = hour;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    private final void $$robo$$android_text_format_Time$set(int monthDay, int month, int year) {
        this.allDay = true;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    private final boolean $$robo$$android_text_format_Time$before(Time that) {
        return Time.compare(this, that) < 0;
    }

    private final boolean $$robo$$android_text_format_Time$after(Time that) {
        return Time.compare(this, that) > 0;
    }

    private final int $$robo$$android_text_format_Time$getWeekNumber() {
        int closestThursday = this.yearDay + sThursdayOffset[this.weekDay];
        if (closestThursday >= 0 && closestThursday <= 364) {
            return closestThursday / 7 + 1;
        }
        Time temp = new Time(this);
        temp.monthDay += sThursdayOffset[this.weekDay];
        temp.normalize(true);
        return temp.yearDay / 7 + 1;
    }

    private final String $$robo$$android_text_format_Time$format3339(boolean allDay) {
        if (allDay) {
            return this.format("%Y-%m-%d");
        }
        if ("UTC".equals(this.timezone)) {
            return this.format("%Y-%m-%dT%H:%M:%S.000Z");
        }
        String base = this.format("%Y-%m-%dT%H:%M:%S.000");
        String sign = this.gmtoff < 0L ? "-" : "+";
        int offset = (int)Math.abs(this.gmtoff);
        int minutes = offset % 3600 / 60;
        int hours = offset / 3600;
        return String.format(Locale.US, "%s%s%02d:%02d", base, sign, hours, minutes);
    }

    private static final boolean $$robo$$android_text_format_Time$isEpoch(Time time) {
        long millis = time.toMillis(true);
        return Time.getJulianDay(millis, 0L) == 2440588;
    }

    private static final int $$robo$$android_text_format_Time$getJulianDay(long millis, long gmtoff) {
        long offsetMillis = gmtoff * 1000L;
        long julianDay = (millis + offsetMillis) / 86400000L;
        return (int)julianDay + 2440588;
    }

    private final long $$robo$$android_text_format_Time$setJulianDay(int julianDay) {
        long millis = (long)(julianDay - 2440588) * 86400000L;
        this.set(millis);
        int approximateDay = Time.getJulianDay(millis, this.gmtoff);
        int diff = julianDay - approximateDay;
        this.monthDay += diff;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        millis = this.normalize(true);
        return millis;
    }

    private static final int $$robo$$android_text_format_Time$getWeeksSinceEpochFromJulianDay(int julianDay, int firstDayOfWeek) {
        int diff = 4 - firstDayOfWeek;
        if (diff < 0) {
            diff += 7;
        }
        int refDay = 2440588 - diff;
        return (julianDay - refDay) / 7;
    }

    private static final int $$robo$$android_text_format_Time$getJulianMondayFromWeeksSinceEpoch(int week) {
        return 2440585 + week * 7;
    }

    static void __staticInitializer__() {
        DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        sThursdayOffset = new int[]{-3, 3, 2, 1, 0, -1, -2};
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_text_format_Time$__constructor__(string2);
    }

    public Time(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Time$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__() {
        this.$$robo$$android_text_format_Time$__constructor__();
    }

    public Time() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Time$__constructor__(), this);
    }

    private void __constructor__(Time time) {
        this.$$robo$$android_text_format_Time$__constructor__(time);
    }

    public Time(Time time) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Time$__constructor__(android.text.format.Time ), this, time);
    }

    private void initialize(String string2) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_text_format_Time$initialize(java.lang.String ), this, string2);
    }

    public long normalize(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_text_format_Time$normalize(boolean ), this, bl);
    }

    public void switchTimezone(String string2) {
        InvokeDynamicSupport.bootstrap("switchTimezone", $$robo$$android_text_format_Time$switchTimezone(java.lang.String ), this, string2);
    }

    public int getActualMaximum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActualMaximum", $$robo$$android_text_format_Time$getActualMaximum(int ), this, n);
    }

    public void clear(String string2) {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_text_format_Time$clear(java.lang.String ), this, string2);
    }

    public static int compare(Time time, Time time2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_text_format_Time$compare(android.text.format.Time android.text.format.Time ), (Time)time, (Time)time2);
    }

    public String format(String string2) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_text_format_Time$format(java.lang.String ), this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_format_Time$toString(), this);
    }

    public boolean parse(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$android_text_format_Time$parse(java.lang.String ), this, string2);
    }

    private boolean parseInternal(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseInternal", $$robo$$android_text_format_Time$parseInternal(java.lang.String ), this, string2);
    }

    private void checkChar(String string2, int n, char c) {
        InvokeDynamicSupport.bootstrap("checkChar", $$robo$$android_text_format_Time$checkChar(java.lang.String int char ), this, string2, n, c);
    }

    private static int getChar(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getChar", $$robo$$android_text_format_Time$getChar(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public boolean parse3339(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parse3339", $$robo$$android_text_format_Time$parse3339(java.lang.String ), this, string2);
    }

    private boolean parse3339Internal(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parse3339Internal", $$robo$$android_text_format_Time$parse3339Internal(java.lang.String ), this, string2);
    }

    public static String getCurrentTimezone() {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentTimezone", $$robo$$android_text_format_Time$getCurrentTimezone());
    }

    public void setToNow() {
        InvokeDynamicSupport.bootstrap("setToNow", $$robo$$android_text_format_Time$setToNow(), this);
    }

    public long toMillis(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("toMillis", $$robo$$android_text_format_Time$toMillis(boolean ), this, bl);
    }

    public void set(long l) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_text_format_Time$set(long ), this, l);
    }

    public String format2445() {
        return InvokeDynamicSupport.bootstrap("format2445", $$robo$$android_text_format_Time$format2445(), this);
    }

    public void set(Time time) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_text_format_Time$set(android.text.format.Time ), this, time);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_text_format_Time$set(int int int int int int ), this, n, n2, n3, n4, n5, n6);
    }

    public void set(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_text_format_Time$set(int int int ), this, n, n2, n3);
    }

    public boolean before(Time time) {
        return (boolean)InvokeDynamicSupport.bootstrap("before", $$robo$$android_text_format_Time$before(android.text.format.Time ), this, time);
    }

    public boolean after(Time time) {
        return (boolean)InvokeDynamicSupport.bootstrap("after", $$robo$$android_text_format_Time$after(android.text.format.Time ), this, time);
    }

    public int getWeekNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getWeekNumber", $$robo$$android_text_format_Time$getWeekNumber(), this);
    }

    public String format3339(boolean bl) {
        return InvokeDynamicSupport.bootstrap("format3339", $$robo$$android_text_format_Time$format3339(boolean ), this, bl);
    }

    public static boolean isEpoch(Time time) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEpoch", $$robo$$android_text_format_Time$isEpoch(android.text.format.Time ), (Time)time);
    }

    public static int getJulianDay(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getJulianDay", $$robo$$android_text_format_Time$getJulianDay(long long ), (long)l, (long)l2);
    }

    public long setJulianDay(int n) {
        return (long)InvokeDynamicSupport.bootstrap("setJulianDay", $$robo$$android_text_format_Time$setJulianDay(int ), this, n);
    }

    public static int getWeeksSinceEpochFromJulianDay(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getWeeksSinceEpochFromJulianDay", $$robo$$android_text_format_Time$getWeeksSinceEpochFromJulianDay(int int ), (int)n, (int)n2);
    }

    public static int getJulianMondayFromWeeksSinceEpoch(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getJulianMondayFromWeeksSinceEpoch", $$robo$$android_text_format_Time$getJulianMondayFromWeeksSinceEpoch(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(Time.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Time)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TimeCalculator
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ZoneInfo.WallTime wallTime;
        public String timezone;
        private ZoneInfo zoneInfo;

        private void $$robo$$android_text_format_Time_TimeCalculator$__constructor__(String timezoneId) {
            this.zoneInfo = TimeCalculator.lookupZoneInfo(timezoneId);
            this.wallTime = new ZoneInfo.WallTime();
        }

        private final long $$robo$$android_text_format_Time_TimeCalculator$toMillis(boolean ignoreDst) {
            int r;
            if (ignoreDst) {
                this.wallTime.setIsDst(-1);
            }
            if ((r = this.wallTime.mktime(this.zoneInfo)) == -1) {
                return -1L;
            }
            return (long)r * 1000L;
        }

        private final void $$robo$$android_text_format_Time_TimeCalculator$setTimeInMillis(long millis) {
            int intSeconds = (int)(millis / 1000L);
            this.updateZoneInfoFromTimeZone();
            this.wallTime.localtime(intSeconds, this.zoneInfo);
        }

        private final String $$robo$$android_text_format_Time_TimeCalculator$format(String format) {
            if (format == null) {
                format = "%c";
            }
            TimeFormatter formatter = new TimeFormatter();
            return formatter.format(format, this.wallTime, this.zoneInfo);
        }

        private final void $$robo$$android_text_format_Time_TimeCalculator$updateZoneInfoFromTimeZone() {
            if (!this.zoneInfo.getID().equals(this.timezone)) {
                this.zoneInfo = TimeCalculator.lookupZoneInfo(this.timezone);
            }
        }

        private static final ZoneInfo $$robo$$android_text_format_Time_TimeCalculator$lookupZoneInfo(String timezoneId) {
            try {
                ZoneInfo zoneInfo = ZoneInfoDB.getInstance().makeTimeZone(timezoneId);
                if (zoneInfo == null) {
                    zoneInfo = ZoneInfoDB.getInstance().makeTimeZone("GMT");
                }
                if (zoneInfo == null) {
                    throw new AssertionError((Object)("GMT not found: \"" + timezoneId + "\""));
                }
                return zoneInfo;
            }
            catch (IOException e) {
                throw new AssertionError("Error loading timezone: \"" + timezoneId + "\"", e);
            }
        }

        private final void $$robo$$android_text_format_Time_TimeCalculator$switchTimeZone(String timezone) {
            int seconds = this.wallTime.mktime(this.zoneInfo);
            this.timezone = timezone;
            this.updateZoneInfoFromTimeZone();
            this.wallTime.localtime(seconds, this.zoneInfo);
        }

        private final String $$robo$$android_text_format_Time_TimeCalculator$format2445(boolean hasTime) {
            char[] buf = new char[hasTime ? 16 : 8];
            int n = this.wallTime.getYear();
            buf[0] = this.toChar(n / 1000);
            buf[1] = this.toChar((n %= 1000) / 100);
            buf[2] = this.toChar((n %= 100) / 10);
            buf[3] = this.toChar(n %= 10);
            n = this.wallTime.getMonth() + 1;
            buf[4] = this.toChar(n / 10);
            buf[5] = this.toChar(n % 10);
            n = this.wallTime.getMonthDay();
            buf[6] = this.toChar(n / 10);
            buf[7] = this.toChar(n % 10);
            if (!hasTime) {
                return new String(buf, 0, 8);
            }
            buf[8] = 84;
            n = this.wallTime.getHour();
            buf[9] = this.toChar(n / 10);
            buf[10] = this.toChar(n % 10);
            n = this.wallTime.getMinute();
            buf[11] = this.toChar(n / 10);
            buf[12] = this.toChar(n % 10);
            n = this.wallTime.getSecond();
            buf[13] = this.toChar(n / 10);
            buf[14] = this.toChar(n % 10);
            if ("UTC".equals(this.timezone)) {
                buf[15] = 90;
                return new String(buf, 0, 16);
            }
            return new String(buf, 0, 15);
        }

        private final char $$robo$$android_text_format_Time_TimeCalculator$toChar(int n) {
            return n >= 0 && n <= 9 ? (char)(n + 48) : (char)' ';
        }

        private final String $$robo$$android_text_format_Time_TimeCalculator$toStringInternal() {
            return String.format("%04d%02d%02dT%02d%02d%02d%s(%d,%d,%d,%d,%d)", this.wallTime.getYear(), this.wallTime.getMonth() + 1, this.wallTime.getMonthDay(), this.wallTime.getHour(), this.wallTime.getMinute(), this.wallTime.getSecond(), this.timezone, this.wallTime.getWeekDay(), this.wallTime.getYearDay(), this.wallTime.getGmtOffset(), this.wallTime.getIsDst(), this.toMillis(false) / 1000L);
        }

        private static final int $$robo$$android_text_format_Time_TimeCalculator$compare(TimeCalculator aObject, TimeCalculator bObject) {
            long bm;
            if (aObject.timezone.equals(bObject.timezone)) {
                int diff = aObject.wallTime.getYear() - bObject.wallTime.getYear();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getMonth() - bObject.wallTime.getMonth();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getMonthDay() - bObject.wallTime.getMonthDay();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getHour() - bObject.wallTime.getHour();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getMinute() - bObject.wallTime.getMinute();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getSecond() - bObject.wallTime.getSecond();
                if (diff != 0) {
                    return diff;
                }
                return 0;
            }
            long am = aObject.toMillis(false);
            long diff = am - (bm = bObject.toMillis(false));
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        private final void $$robo$$android_text_format_Time_TimeCalculator$copyFieldsToTime(Time time) {
            time.second = this.wallTime.getSecond();
            time.minute = this.wallTime.getMinute();
            time.hour = this.wallTime.getHour();
            time.monthDay = this.wallTime.getMonthDay();
            time.month = this.wallTime.getMonth();
            time.year = this.wallTime.getYear();
            time.weekDay = this.wallTime.getWeekDay();
            time.yearDay = this.wallTime.getYearDay();
            time.isDst = this.wallTime.getIsDst();
            time.gmtoff = this.wallTime.getGmtOffset();
        }

        private final void $$robo$$android_text_format_Time_TimeCalculator$copyFieldsFromTime(Time time) {
            this.wallTime.setSecond(time.second);
            this.wallTime.setMinute(time.minute);
            this.wallTime.setHour(time.hour);
            this.wallTime.setMonthDay(time.monthDay);
            this.wallTime.setMonth(time.month);
            this.wallTime.setYear(time.year);
            this.wallTime.setWeekDay(time.weekDay);
            this.wallTime.setYearDay(time.yearDay);
            this.wallTime.setIsDst(time.isDst);
            this.wallTime.setGmtOffset((int)time.gmtoff);
            if (time.allDay && (time.second != 0 || time.minute != 0 || time.hour != 0)) {
                throw new IllegalArgumentException("allDay is true but sec, min, hour are not 0.");
            }
            this.timezone = time.timezone;
            this.updateZoneInfoFromTimeZone();
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_text_format_Time_TimeCalculator$__constructor__(string2);
        }

        public TimeCalculator(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Time_TimeCalculator$__constructor__(java.lang.String ), this, string2);
        }

        public long toMillis(boolean bl) {
            return (long)InvokeDynamicSupport.bootstrap("toMillis", $$robo$$android_text_format_Time_TimeCalculator$toMillis(boolean ), this, bl);
        }

        public void setTimeInMillis(long l) {
            InvokeDynamicSupport.bootstrap("setTimeInMillis", $$robo$$android_text_format_Time_TimeCalculator$setTimeInMillis(long ), this, l);
        }

        public String format(String string2) {
            return InvokeDynamicSupport.bootstrap("format", $$robo$$android_text_format_Time_TimeCalculator$format(java.lang.String ), this, string2);
        }

        private void updateZoneInfoFromTimeZone() {
            InvokeDynamicSupport.bootstrap("updateZoneInfoFromTimeZone", $$robo$$android_text_format_Time_TimeCalculator$updateZoneInfoFromTimeZone(), this);
        }

        private static ZoneInfo lookupZoneInfo(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("lookupZoneInfo", $$robo$$android_text_format_Time_TimeCalculator$lookupZoneInfo(java.lang.String ), (String)string2);
        }

        public void switchTimeZone(String string2) {
            InvokeDynamicSupport.bootstrap("switchTimeZone", $$robo$$android_text_format_Time_TimeCalculator$switchTimeZone(java.lang.String ), this, string2);
        }

        public String format2445(boolean bl) {
            return InvokeDynamicSupport.bootstrap("format2445", $$robo$$android_text_format_Time_TimeCalculator$format2445(boolean ), this, bl);
        }

        private char toChar(int n) {
            return (char)InvokeDynamicSupport.bootstrap("toChar", $$robo$$android_text_format_Time_TimeCalculator$toChar(int ), this, n);
        }

        public String toStringInternal() {
            return InvokeDynamicSupport.bootstrap("toStringInternal", $$robo$$android_text_format_Time_TimeCalculator$toStringInternal(), this);
        }

        public static int compare(TimeCalculator timeCalculator, TimeCalculator timeCalculator2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_text_format_Time_TimeCalculator$compare(android.text.format.Time$TimeCalculator android.text.format.Time$TimeCalculator ), (TimeCalculator)timeCalculator, (TimeCalculator)timeCalculator2);
        }

        public void copyFieldsToTime(Time time) {
            InvokeDynamicSupport.bootstrap("copyFieldsToTime", $$robo$$android_text_format_Time_TimeCalculator$copyFieldsToTime(android.text.format.Time ), this, time);
        }

        public void copyFieldsFromTime(Time time) {
            InvokeDynamicSupport.bootstrap("copyFieldsFromTime", $$robo$$android_text_format_Time_TimeCalculator$copyFieldsFromTime(android.text.format.Time ), this, time);
        }

        public /* synthetic */ TimeCalculator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeCalculator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

