/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Resources;
import android.icu.text.MeasureFormat;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.net.NetworkUtils;
import android.text.BidiFormatter;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Formatter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int FLAG_SHORTER = 1;
    public static int FLAG_CALCULATE_ROUNDED = 2;
    public static int FLAG_SI_UNITS = 4;
    public static int FLAG_IEC_UNITS = 8;
    private static int SECONDS_PER_MINUTE = 60;
    private static int SECONDS_PER_HOUR = 3600;
    private static int SECONDS_PER_DAY = 86400;
    private static int MILLIS_PER_MINUTE = 60000;

    private void $$robo$$android_text_format_Formatter$__constructor__() {
    }

    private static final Locale $$robo$$android_text_format_Formatter$localeFromContext(Context context) {
        return context.getResources().getConfiguration().getLocales().get(0);
    }

    private static final String $$robo$$android_text_format_Formatter$bidiWrap(Context context, String source) {
        Locale locale = Formatter.localeFromContext(context);
        if (TextUtils.getLayoutDirectionFromLocale(locale) == 1) {
            return BidiFormatter.getInstance(true).unicodeWrap(source);
        }
        return source;
    }

    private static final String $$robo$$android_text_format_Formatter$formatFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 4);
        return Formatter.bidiWrap(context, context.getString(17039894, res.value, res.units));
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 5);
        return Formatter.bidiWrap(context, context.getString(17039894, res.value, res.units));
    }

    private static final BytesResult $$robo$$android_text_format_Formatter$formatBytes(Resources res, long sizeBytes, int flags) {
        String roundFormat;
        int roundFactor;
        int unit = (flags & 8) != 0 ? 1024 : 1000;
        boolean isNegative = sizeBytes < 0L;
        float result = isNegative ? (float)(-sizeBytes) : (float)sizeBytes;
        int suffix = 17039591;
        long mult = 1L;
        if (result > 900.0f) {
            suffix = 17040118;
            mult = unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17040296;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17039940;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17040964;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17040672;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (mult == 1L || result >= 100.0f) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else if (result < 1.0f) {
            roundFactor = 100;
            roundFormat = "%.2f";
        } else if (result < 10.0f) {
            if ((flags & 1) != 0) {
                roundFactor = 10;
                roundFormat = "%.1f";
            } else {
                roundFactor = 100;
                roundFormat = "%.2f";
            }
        } else if ((flags & 1) != 0) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else {
            roundFactor = 100;
            roundFormat = "%.2f";
        }
        if (isNegative) {
            result = -result;
        }
        String roundedString = String.format(roundFormat, Float.valueOf(result));
        long roundedBytes = (flags & 2) == 0 ? 0L : (long)Math.round(result * (float)roundFactor) * mult / (long)roundFactor;
        String units = res.getString(suffix);
        return new BytesResult(roundedString, units, roundedBytes);
    }

    @Deprecated
    private static final String $$robo$$android_text_format_Formatter$formatIpAddress(int ipv4Address) {
        return NetworkUtils.intToInetAddress(ipv4Address).getHostAddress();
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        Locale locale = Formatter.localeFromContext(context);
        MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
        if (days >= 2 || days > 0 && hours == 0) {
            return measureFormat.format(new Measure(days += (hours + 12) / 24, MeasureUnit.DAY));
        }
        if (days > 0) {
            return measureFormat.formatMeasures(new Measure(days, MeasureUnit.DAY), new Measure(hours, MeasureUnit.HOUR));
        }
        if (hours >= 2 || hours > 0 && minutes == 0) {
            return measureFormat.format(new Measure(hours += (minutes + 30) / 60, MeasureUnit.HOUR));
        }
        if (hours > 0) {
            return measureFormat.formatMeasures(new Measure(hours, MeasureUnit.HOUR), new Measure(minutes, MeasureUnit.MINUTE));
        }
        if (minutes >= 2 || minutes > 0 && seconds == 0) {
            return measureFormat.format(new Measure(minutes += (seconds + 30) / 60, MeasureUnit.MINUTE));
        }
        if (minutes > 0) {
            return measureFormat.formatMeasures(new Measure(minutes, MeasureUnit.MINUTE), new Measure(seconds, MeasureUnit.SECOND));
        }
        return measureFormat.format(new Measure(seconds, MeasureUnit.SECOND));
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortElapsedTimeRoundingUpToMinutes(Context context, long millis) {
        long minutesRoundedUp = (millis + 60000L - 1L) / 60000L;
        if (minutesRoundedUp == 0L || minutesRoundedUp == 1L) {
            Locale locale = Formatter.localeFromContext(context);
            MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
            return measureFormat.format(new Measure(minutesRoundedUp, MeasureUnit.MINUTE));
        }
        return Formatter.formatShortElapsedTime(context, minutesRoundedUp * 60000L);
    }

    private void __constructor__() {
        this.$$robo$$android_text_format_Formatter$__constructor__();
    }

    public Formatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter$__constructor__(), this);
    }

    private static Locale localeFromContext(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("localeFromContext", $$robo$$android_text_format_Formatter$localeFromContext(android.content.Context ), (Context)context);
    }

    private static String bidiWrap(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("bidiWrap", $$robo$$android_text_format_Formatter$bidiWrap(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public static String formatFileSize(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatFileSize", $$robo$$android_text_format_Formatter$formatFileSize(android.content.Context long ), (Context)context, (long)l);
    }

    public static String formatShortFileSize(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortFileSize", $$robo$$android_text_format_Formatter$formatShortFileSize(android.content.Context long ), (Context)context, (long)l);
    }

    public static BytesResult formatBytes(Resources resources, long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatBytes", $$robo$$android_text_format_Formatter$formatBytes(android.content.res.Resources long int ), (Resources)resources, (long)l, (int)n);
    }

    @Deprecated
    public static String formatIpAddress(int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatIpAddress", $$robo$$android_text_format_Formatter$formatIpAddress(int ), (int)n);
    }

    public static String formatShortElapsedTime(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortElapsedTime", $$robo$$android_text_format_Formatter$formatShortElapsedTime(android.content.Context long ), (Context)context, (long)l);
    }

    public static String formatShortElapsedTimeRoundingUpToMinutes(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortElapsedTimeRoundingUpToMinutes", $$robo$$android_text_format_Formatter$formatShortElapsedTimeRoundingUpToMinutes(android.content.Context long ), (Context)context, (long)l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Formatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class BytesResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String value;
        public String units;
        public long roundedBytes;

        private void $$robo$$android_text_format_Formatter_BytesResult$__constructor__(String value, String units, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.roundedBytes = roundedBytes;
        }

        private void __constructor__(String string2, String string3, long l) {
            this.$$robo$$android_text_format_Formatter_BytesResult$__constructor__(string2, string3, l);
        }

        public BytesResult(String string2, String string3, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter_BytesResult$__constructor__(java.lang.String java.lang.String long ), this, string2, string3, l);
        }

        public /* synthetic */ BytesResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BytesResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

