/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.NoCopySpan;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.reflect.Array;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SpannableStringInternal
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mText;
    private Object[] mSpans;
    private int[] mSpanData;
    private int mSpanCount;
    static Object[] EMPTY;
    private static int START = 0;
    private static int END = 1;
    private static int FLAGS = 2;
    private static int COLUMNS = 3;

    private void $$robo$$android_text_SpannableStringInternal$__constructor__(CharSequence source, int start, int end, boolean ignoreNoCopySpan) {
        this.mText = start == 0 && end == source.length() ? source.toString() : source.toString().substring(start, end);
        this.mSpans = EmptyArray.OBJECT;
        this.mSpanData = EmptyArray.INT;
        if (source instanceof Spanned) {
            if (source instanceof SpannableStringInternal) {
                this.copySpans((SpannableStringInternal)((Object)source), start, end, ignoreNoCopySpan);
            } else {
                this.copySpans((Spanned)source, start, end, ignoreNoCopySpan);
            }
        }
    }

    private void $$robo$$android_text_SpannableStringInternal$__constructor__(CharSequence source, int start, int end) {
    }

    private final void $$robo$$android_text_SpannableStringInternal$copySpans(Spanned src, int start, int end, boolean ignoreNoCopySpan) {
        Object[] spans = src.getSpans(start, end, Object.class);
        for (int i = 0; i < spans.length; ++i) {
            if (ignoreNoCopySpan && spans[i] instanceof NoCopySpan) continue;
            int st = src.getSpanStart(spans[i]);
            int en = src.getSpanEnd(spans[i]);
            int fl = src.getSpanFlags(spans[i]);
            if (st < start) {
                st = start;
            }
            if (en > end) {
                en = end;
            }
            this.setSpan(spans[i], st - start, en - start, fl, false);
        }
    }

    private final void $$robo$$android_text_SpannableStringInternal$copySpans(SpannableStringInternal src, int start, int end, boolean ignoreNoCopySpan) {
        int i;
        int count = 0;
        int[] srcData = src.mSpanData;
        Object[] srcSpans = src.mSpans;
        int limit = src.mSpanCount;
        boolean hasNoCopySpan = false;
        for (i = 0; i < limit; ++i) {
            int spanStart = srcData[i * 3 + 0];
            int spanEnd = srcData[i * 3 + 1];
            if (this.isOutOfCopyRange(start, end, spanStart, spanEnd)) continue;
            if (srcSpans[i] instanceof NoCopySpan) {
                hasNoCopySpan = true;
                if (ignoreNoCopySpan) continue;
            }
            ++count;
        }
        if (count == 0) {
            return;
        }
        if (!hasNoCopySpan && start == 0 && end == src.length()) {
            this.mSpans = ArrayUtils.newUnpaddedObjectArray(src.mSpans.length);
            this.mSpanData = new int[src.mSpanData.length];
            this.mSpanCount = src.mSpanCount;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)src.mSpans, (int)0, (Object)this.mSpans, (int)0, (int)src.mSpans.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)src.mSpanData, (int)0, (Object)this.mSpanData, (int)0, (int)this.mSpanData.length);
        } else {
            this.mSpanCount = count;
            this.mSpans = ArrayUtils.newUnpaddedObjectArray(this.mSpanCount);
            this.mSpanData = new int[this.mSpans.length * 3];
            int j = 0;
            for (i = 0; i < limit; ++i) {
                int spanStart = srcData[i * 3 + 0];
                int spanEnd = srcData[i * 3 + 1];
                if (this.isOutOfCopyRange(start, end, spanStart, spanEnd) || ignoreNoCopySpan && srcSpans[i] instanceof NoCopySpan) continue;
                if (spanStart < start) {
                    spanStart = start;
                }
                if (spanEnd > end) {
                    spanEnd = end;
                }
                this.mSpans[j] = srcSpans[i];
                this.mSpanData[j * 3 + 0] = spanStart - start;
                this.mSpanData[j * 3 + 1] = spanEnd - start;
                this.mSpanData[j * 3 + 2] = srcData[i * 3 + 2];
                ++j;
            }
        }
    }

    private final boolean $$robo$$android_text_SpannableStringInternal$isOutOfCopyRange(int start, int end, int spanStart, int spanEnd) {
        if (spanStart > end || spanEnd < start) {
            return true;
        }
        return spanStart != spanEnd && start != end && (spanStart == end || spanEnd == start);
    }

    private final int $$robo$$android_text_SpannableStringInternal$length() {
        return this.mText.length();
    }

    private final char $$robo$$android_text_SpannableStringInternal$charAt(int i) {
        return this.mText.charAt(i);
    }

    private final String $$robo$$android_text_SpannableStringInternal$toString() {
        return this.mText;
    }

    private final void $$robo$$android_text_SpannableStringInternal$getChars(int start, int end, char[] dest, int off) {
        this.mText.getChars(start, end, dest, off);
    }

    private final void $$robo$$android_text_SpannableStringInternal$setSpan(Object what, int start, int end, int flags) {
        this.setSpan(what, start, end, flags, true);
    }

    private final boolean $$robo$$android_text_SpannableStringInternal$isIndexFollowsNextLine(int index) {
        return index != 0 && index != this.length() && this.charAt(index - 1) != '\n';
    }

    private final void $$robo$$android_text_SpannableStringInternal$setSpan(Object what, int start, int end, int flags, boolean enforceParagraph) {
        int nstart = start;
        int nend = end;
        this.checkRange("setSpan", start, end);
        if ((flags & 0x33) == 51) {
            if (this.isIndexFollowsNextLine(start)) {
                if (!enforceParagraph) {
                    return;
                }
                throw new RuntimeException("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + this.charAt(start - 1) + ")");
            }
            if (this.isIndexFollowsNextLine(end)) {
                if (!enforceParagraph) {
                    return;
                }
                throw new RuntimeException("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + this.charAt(end - 1) + ")");
            }
        }
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = 0; i < count; ++i) {
            if (spans[i] != what) continue;
            int ostart = data[i * 3 + 0];
            int oend = data[i * 3 + 1];
            data[i * 3 + 0] = start;
            data[i * 3 + 1] = end;
            data[i * 3 + 2] = flags;
            this.sendSpanChanged(what, ostart, oend, nstart, nend);
            return;
        }
        if (this.mSpanCount + 1 >= this.mSpans.length) {
            Object[] newtags = ArrayUtils.newUnpaddedObjectArray(GrowingArrayUtils.growSize(this.mSpanCount));
            int[] newdata = new int[newtags.length * 3];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mSpans, (int)0, (Object)newtags, (int)0, (int)this.mSpanCount);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mSpanData, (int)0, (Object)newdata, (int)0, (int)(this.mSpanCount * 3));
            this.mSpans = newtags;
            this.mSpanData = newdata;
        }
        this.mSpans[this.mSpanCount] = what;
        this.mSpanData[this.mSpanCount * 3 + 0] = start;
        this.mSpanData[this.mSpanCount * 3 + 1] = end;
        this.mSpanData[this.mSpanCount * 3 + 2] = flags;
        ++this.mSpanCount;
        if (this instanceof Spannable) {
            this.sendSpanAdded(what, nstart, nend);
        }
    }

    private final void $$robo$$android_text_SpannableStringInternal$removeSpan(Object what) {
        this.removeSpan(what, 0);
    }

    private final void $$robo$$android_text_SpannableStringInternal$removeSpan(Object what, int flags) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int ostart = data[i * 3 + 0];
            int oend = data[i * 3 + 1];
            int c = count - (i + 1);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)spans, (int)(i + 1), (Object)spans, (int)i, (int)c);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)data, (int)((i + 1) * 3), (Object)data, (int)(i * 3), (int)(c * 3));
            --this.mSpanCount;
            if ((flags & 0x200) == 0) {
                this.sendSpanRemoved(what, ostart, oend);
            }
            return;
        }
    }

    private final int $$robo$$android_text_SpannableStringInternal$getSpanStart(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 0];
        }
        return -1;
    }

    private final int $$robo$$android_text_SpannableStringInternal$getSpanEnd(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 1];
        }
        return -1;
    }

    private final int $$robo$$android_text_SpannableStringInternal$getSpanFlags(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 2];
        }
        return 0;
    }

    private final <T> T[] $$robo$$android_text_SpannableStringInternal$getSpans(int queryStart, int queryEnd, Class<T> kind) {
        int count = 0;
        int spanCount = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        Object[] ret = null;
        Object ret1 = null;
        for (int i = 0; i < spanCount; ++i) {
            int prio;
            int spanStart = data[i * 3 + 0];
            int spanEnd = data[i * 3 + 1];
            if (spanStart > queryEnd || spanEnd < queryStart || spanStart != spanEnd && queryStart != queryEnd && (spanStart == queryEnd || spanEnd == queryStart) || kind != null && kind != Object.class && !kind.isInstance(spans[i])) continue;
            if (count == 0) {
                ret1 = spans[i];
                ++count;
                continue;
            }
            if (count == 1) {
                ret = (Object[])Array.newInstance(kind, spanCount - i + 1);
                ret[0] = ret1;
            }
            if ((prio = data[i * 3 + 2] & 0xFF0000) != 0) {
                int p;
                int j;
                for (j = 0; j < count && prio <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ret, (int)j, (Object)ret, (int)(j + 1), (int)(count - j));
                ret[j] = spans[i];
                ++count;
                continue;
            }
            ret[count++] = spans[i];
        }
        if (count == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        if (count == 1) {
            ret = (Object[])Array.newInstance(kind, 1);
            ret[0] = ret1;
            return ret;
        }
        if (count == ret.length) {
            return ret;
        }
        Object[] nret = (Object[])Array.newInstance(kind, count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ret, (int)0, (Object)nret, (int)0, (int)count);
        return nret;
    }

    private final int $$robo$$android_text_SpannableStringInternal$nextSpanTransition(int start, int limit, Class kind) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        if (kind == null) {
            kind = Object.class;
        }
        for (int i = 0; i < count; ++i) {
            int st = data[i * 3 + 0];
            int en = data[i * 3 + 1];
            if (st > start && st < limit && kind.isInstance(spans[i])) {
                limit = st;
            }
            if (en <= start || en >= limit || !kind.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }

    private final void $$robo$$android_text_SpannableStringInternal$sendSpanAdded(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanAdded((Spannable)((Object)this), what, start, end);
        }
    }

    private final void $$robo$$android_text_SpannableStringInternal$sendSpanRemoved(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanRemoved((Spannable)((Object)this), what, start, end);
        }
    }

    private final void $$robo$$android_text_SpannableStringInternal$sendSpanChanged(Object what, int s, int e, int st, int en) {
        SpanWatcher[] recip = this.getSpans(Math.min(s, st), Math.max(e, en), SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanChanged((Spannable)((Object)this), what, s, e, st, en);
        }
    }

    private static final String $$robo$$android_text_SpannableStringInternal$region(int start, int end) {
        return "(" + start + " ... " + end + ")";
    }

    private final void $$robo$$android_text_SpannableStringInternal$checkRange(String operation, int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " has end before start");
        }
        int len = this.length();
        if (start > len || end > len) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " ends beyond length " + len);
        }
        if (start < 0 || end < 0) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " starts before 0");
        }
    }

    private final boolean $$robo$$android_text_SpannableStringInternal$equals(Object o) {
        Spanned other;
        Object[] otherSpans;
        if (o instanceof Spanned && this.toString().equals(o.toString()) && this.mSpanCount == (otherSpans = (other = (Spanned)o).getSpans(0, other.length(), Object.class)).length) {
            for (int i = 0; i < this.mSpanCount; ++i) {
                Object thisSpan = this.mSpans[i];
                Object otherSpan = otherSpans[i];
                if (!(thisSpan == this ? other != otherSpan || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan) : !thisSpan.equals(otherSpan) || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$android_text_SpannableStringInternal$hashCode() {
        int hash = this.toString().hashCode();
        hash = hash * 31 + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object span = this.mSpans[i];
            if (span != this) {
                hash = hash * 31 + span.hashCode();
            }
            hash = hash * 31 + this.getSpanStart(span);
            hash = hash * 31 + this.getSpanEnd(span);
            hash = hash * 31 + this.getSpanFlags(span);
        }
        return hash;
    }

    private final void $$robo$$android_text_SpannableStringInternal$copySpans(Spanned src, int start, int end) {
        this.copySpans(src, start, end, false);
    }

    private final void $$robo$$android_text_SpannableStringInternal$copySpans(SpannableStringInternal src, int start, int end) {
        this.copySpans(src, start, end, false);
    }

    static void __staticInitializer__() {
        EMPTY = new Object[0];
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, boolean bl) {
        this.$$robo$$android_text_SpannableStringInternal$__constructor__(charSequence, n, n2, bl);
    }

    public SpannableStringInternal(CharSequence charSequence, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_SpannableStringInternal$__constructor__(java.lang.CharSequence int int boolean ), this, charSequence, n, n2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2) {
        this.$$robo$$android_text_SpannableStringInternal$__constructor__(charSequence, n, n2);
    }

    public SpannableStringInternal(CharSequence charSequence, int n, int n2) {
        this(charSequence, n, n2, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_SpannableStringInternal$__constructor__(java.lang.CharSequence int int ), this, charSequence, n, n2);
    }

    private void copySpans(Spanned spanned, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("copySpans", $$robo$$android_text_SpannableStringInternal$copySpans(android.text.Spanned int int boolean ), this, spanned, n, n2, bl);
    }

    private void copySpans(SpannableStringInternal spannableStringInternal, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("copySpans", $$robo$$android_text_SpannableStringInternal$copySpans(android.text.SpannableStringInternal int int boolean ), this, spannableStringInternal, n, n2, bl);
    }

    private boolean isOutOfCopyRange(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutOfCopyRange", $$robo$$android_text_SpannableStringInternal$isOutOfCopyRange(int int int int ), this, n, n2, n3, n4);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_text_SpannableStringInternal$length(), this);
    }

    public char charAt(int n) {
        return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_text_SpannableStringInternal$charAt(int ), this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_SpannableStringInternal$toString(), this);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_text_SpannableStringInternal$getChars(int int char[] int ), this, n, n2, cArray, n3);
    }

    void setSpan(Object object, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setSpan", $$robo$$android_text_SpannableStringInternal$setSpan(java.lang.Object int int int ), this, object, n, n2, n3);
    }

    private boolean isIndexFollowsNextLine(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIndexFollowsNextLine", $$robo$$android_text_SpannableStringInternal$isIndexFollowsNextLine(int ), this, n);
    }

    private void setSpan(Object object, int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpan", $$robo$$android_text_SpannableStringInternal$setSpan(java.lang.Object int int int boolean ), this, object, n, n2, n3, bl);
    }

    void removeSpan(Object object) {
        InvokeDynamicSupport.bootstrap("removeSpan", $$robo$$android_text_SpannableStringInternal$removeSpan(java.lang.Object ), this, object);
    }

    public void removeSpan(Object object, int n) {
        InvokeDynamicSupport.bootstrap("removeSpan", $$robo$$android_text_SpannableStringInternal$removeSpan(java.lang.Object int ), this, object, n);
    }

    public int getSpanStart(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanStart", $$robo$$android_text_SpannableStringInternal$getSpanStart(java.lang.Object ), this, object);
    }

    public int getSpanEnd(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanEnd", $$robo$$android_text_SpannableStringInternal$getSpanEnd(java.lang.Object ), this, object);
    }

    public int getSpanFlags(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanFlags", $$robo$$android_text_SpannableStringInternal$getSpanFlags(java.lang.Object ), this, object);
    }

    public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrap("getSpans", $$robo$$android_text_SpannableStringInternal$getSpans(int int java.lang.Class<T> ), this, n, n2, clazz);
    }

    public int nextSpanTransition(int n, int n2, Class clazz) {
        return (int)InvokeDynamicSupport.bootstrap("nextSpanTransition", $$robo$$android_text_SpannableStringInternal$nextSpanTransition(int int java.lang.Class ), this, n, n2, clazz);
    }

    private void sendSpanAdded(Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendSpanAdded", $$robo$$android_text_SpannableStringInternal$sendSpanAdded(java.lang.Object int int ), this, object, n, n2);
    }

    private void sendSpanRemoved(Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendSpanRemoved", $$robo$$android_text_SpannableStringInternal$sendSpanRemoved(java.lang.Object int int ), this, object, n, n2);
    }

    private void sendSpanChanged(Object object, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("sendSpanChanged", $$robo$$android_text_SpannableStringInternal$sendSpanChanged(java.lang.Object int int int int ), this, object, n, n2, n3, n4);
    }

    private static String region(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("region", $$robo$$android_text_SpannableStringInternal$region(int int ), (int)n, (int)n2);
    }

    private void checkRange(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("checkRange", $$robo$$android_text_SpannableStringInternal$checkRange(java.lang.String int int ), this, string2, n, n2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_text_SpannableStringInternal$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_text_SpannableStringInternal$hashCode(), this);
    }

    private void copySpans(Spanned spanned, int n, int n2) {
        InvokeDynamicSupport.bootstrap("copySpans", $$robo$$android_text_SpannableStringInternal$copySpans(android.text.Spanned int int ), this, spanned, n, n2);
    }

    private void copySpans(SpannableStringInternal spannableStringInternal, int n, int n2) {
        InvokeDynamicSupport.bootstrap("copySpans", $$robo$$android_text_SpannableStringInternal$copySpans(android.text.SpannableStringInternal int int ), this, spannableStringInternal, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(SpannableStringInternal.class);
    }

    public /* synthetic */ SpannableStringInternal() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpannableStringInternal)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

